/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.barcode.scm.BarcodeDefaultSolutionCollection;
import com.kingdee.eas.barcode.scm.BarcodeDefaultSolutionFactory;
import com.kingdee.eas.barcode.scm.BarcodeDefaultSolutionInfo;
import com.kingdee.eas.barcode.scm.client.BarcodeDefaultUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BarcodeDefaultListPanel
extends KDPanel {
    protected KDList solutionList;
    protected BarcodeDefaultUI parentUI;
    protected KDScrollPane pane = new KDScrollPane();
    protected BarcodeDefaultSolutionCollection solutionColl;
    public static final Icon icon = EASResource.getIcon((String)"imgTbtn_distribute");
    protected int BUTTON_HEIGHT = 20;
    protected int SPACE = 3;

    public BarcodeDefaultListPanel(BarcodeDefaultUI parentUI) {
        this.parentUI = parentUI;
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void init() throws BOSException {
        this.solutionList = new KDList();
        this.solutionList.setSelectionMode(0);
        this.solutionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    BarcodeDefaultListPanel.this.solutionList_ValueChanged(e);
                }
            }
        });
        this.refreshSolutionList();
        this.pane.getViewport().add((Component)this.solutionList, null);
        this.setLayout(new BorderLayout());
        int height = 300 - 3 * this.BUTTON_HEIGHT - 3 * this.SPACE;
        this.pane.setPreferredSize(new Dimension(240, height));
        this.add((Component)this.pane, "Center");
    }

    protected void solutionList_ValueChanged(ListSelectionEvent e) {
        BarcodeDefaultSolutionInfo solution = (BarcodeDefaultSolutionInfo)this.solutionList.getSelectedValue();
        this.parentUI.getTablePanel().reloadSolution(solution);
    }

    public BarcodeDefaultSolutionInfo getSelectedSolution() {
        return (BarcodeDefaultSolutionInfo)this.solutionList.getSelectedValue();
    }

    public void refreshSolutionList() throws BOSException {
        this.solutionList.removeAllElements();
        this.solutionColl = this.getSolutionCol();
        for (int i = 0; i < this.solutionColl.size(); ++i) {
            this.solutionList.addElement((Object)this.solutionColl.get(i));
            this.solutionList.setElementIcon(icon, (Object)this.solutionColl.get(i));
        }
    }

    public KDList getSolutionList() {
        return this.solutionList;
    }

    public void setSelected(BarcodeDefaultSolutionInfo info) {
        if (info != null) {
            ListModel model = this.solutionList.getModel();
            int size = model.getSize();
            for (int i = 0; i < size; ++i) {
                BarcodeDefaultSolutionInfo solutionInfo = (BarcodeDefaultSolutionInfo)model.getElementAt(i);
                if (!StringUtils.equals((String)StringUtils.cnulls((Object)solutionInfo.getId()), (String)StringUtils.cnulls((Object)info.getId()))) continue;
                this.solutionList.setSelectedIndex(i);
                this.solutionList.ensureIndexIsVisible(i);
            }
        } else {
            this.solutionList.setSelectedIndex(-1);
        }
        this.solutionList_ValueChanged(null);
    }

    public BarcodeDefaultSolutionCollection getSolutionCol() throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("barcodeConfig.id", (Object)this.parentUI.getBarcodeConfigInfo().getId().toString(), CompareType.EQUALS));
        ev.setFilter(filter);
        BarcodeDefaultSolutionCollection coll = BarcodeDefaultSolutionFactory.getRemoteInstance().getBarcodeDefaultSolutionCollection(ev);
        return coll;
    }
}

