/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.scm.BarcodeDefaultSolutionFactory;
import com.kingdee.eas.barcode.scm.BarcodeDefaultSolutionInfo;
import com.kingdee.eas.barcode.scm.BarcodeDefaultXMLInfo;
import com.kingdee.eas.barcode.scm.BarcodeDefaultXMLItem;
import com.kingdee.eas.barcode.scm.BarcodeXMLHelper;
import com.kingdee.eas.barcode.scm.client.BarcodeDefaultUI;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class BarcodeDefaultSolutionUI
extends CoreUI {
    private static final long serialVersionUID = 1L;
    protected BarcodeDefaultSolutionInfo currentSolutionInfo;
    protected KDBizMultiLangBox solutionNameTextField;
    protected KDButton confirmButton;
    protected KDButton cancelButton;
    protected BarcodeDefaultUI parentUI;
    public static final String PARENTUI = "parentUI";
    public static final String CURRSOLUTION = "currSolution";
    protected BarcodeDefaultSolutionInfo returnObject;

    public BarcodeDefaultSolutionUI() throws Exception {
        this.init();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.parentUI = (BarcodeDefaultUI)((Object)this.getUIContext().get(PARENTUI));
        this.currentSolutionInfo = (BarcodeDefaultSolutionInfo)this.getUIContext().get(CURRSOLUTION);
        if (this.currentSolutionInfo != null) {
            UIHelper.loadMultiLangFields((KDMultiLangBox)this.solutionNameTextField, (IObjectValue)this.currentSolutionInfo, (String)"name");
        }
    }

    public void init() {
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"92_BarcodeDefaultSolutionUI"));
        KDLabelContainer solutionLabContainer = new KDLabelContainer();
        solutionLabContainer.setBoundLabel((JLabel)new KDLabel(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"93_BarcodeDefaultSolutionUI")));
        solutionLabContainer.setBoundLabelLength(80);
        solutionLabContainer.setBoundLabelUnderline(true);
        solutionLabContainer.setBounds(new Rectangle(10, 15, 280, 19));
        this.solutionNameTextField = new KDBizMultiLangBox();
        this.solutionNameTextField.setRequired(true);
        List langList = KDBizMultiLangBox.getLanguageList();
        for (int i = 0; i < langList.size(); ++i) {
            if (!SysContext.getSysContext().getLocale().toString().equalsIgnoreCase(((LanguageInfo)langList.get(i)).getLocale().toString())) continue;
            this.solutionNameTextField.setSelectedLanguage((LanguageInfo)langList.get(i));
        }
        solutionLabContainer.setBoundEditor((JComponent)this.solutionNameTextField);
        this.solutionNameTextField.setMaxLength(79);
        this.add((Component)solutionLabContainer);
        this.confirmButton = new KDButton();
        this.confirmButton.setText(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"94_BarcodeDefaultSolutionUI"));
        this.confirmButton.setBounds(new Rectangle(141, 71, 73, 19));
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BarcodeDefaultSolutionUI.this.confirmButton_actionPerformed(e);
            }
        });
        this.add((Component)this.confirmButton);
        this.cancelButton = new KDButton();
        this.cancelButton.setText(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"95_BarcodeDefaultSolutionUI"));
        this.cancelButton.setBounds(new Rectangle(217, 71, 73, 19));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BarcodeDefaultSolutionUI.this.cancelButton_actionPerformed(e);
            }
        });
        this.add((Component)this.cancelButton);
        KDSeparator separator = new KDSeparator();
        separator.setBounds(new Rectangle(0, 64, 300, 2));
        this.add((Component)separator);
        this.setLayout(null);
        this.setPreferredSize(new Dimension(300, 100));
    }

    protected void cancelButton_actionPerformed(ActionEvent e) {
        Util.getWindow((Component)((Object)this)).dispose();
    }

    protected void saveSolution() throws EASBizException, BOSException {
        String solutionName = this.solutionNameTextField.getSelectedItem().toString();
        if (StringUtils.isEmpty((String)solutionName)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"96_BarcodeDefaultSolutionUI"));
            SysUtil.abort();
        }
        BarcodeDefaultSolutionInfo solutionInfo = null;
        if (this.isAddNew()) {
            solutionInfo = new BarcodeDefaultSolutionInfo();
            UIHelper.storeMultiLangFields((KDMultiLangBox)this.solutionNameTextField, (IObjectValue)solutionInfo, (String)"name");
            UserInfo owner = SysContext.getSysContext().getCurrentUserInfo();
            solutionInfo.setCreator(owner);
            solutionInfo.setId(BOSUuid.create((String)solutionInfo.getBOSType().toString()));
        } else {
            solutionInfo = this.currentSolutionInfo;
        }
        solutionInfo.setEntityBosType(this.parentUI.getEntity().getType().toString());
        solutionInfo.setBarcodeConfig(this.parentUI.getBarcodeConfigInfo());
        BarcodeDefaultXMLInfo xmlInfo = this.buildBarcodeDefaultXMLInfo(solutionInfo);
        solutionInfo.setDetailsXML(BarcodeXMLHelper.barcodeDefaultXMLInfoToXML(xmlInfo));
        IObjectPK pk = BarcodeDefaultSolutionFactory.getRemoteInstance().submit((CoreBaseInfo)solutionInfo);
        this.setReturnObject(solutionInfo);
        this.parentUI.showMsg(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"97_BarcodeDefaultSolutionUI"));
    }

    protected BarcodeDefaultXMLInfo buildBarcodeDefaultXMLInfo(BarcodeDefaultSolutionInfo solutionInfo) {
        BarcodeDefaultXMLInfo xmlInfo = new BarcodeDefaultXMLInfo();
        if (solutionInfo.getId() != null) {
            xmlInfo.setId(solutionInfo.getId().toString());
        }
        if (solutionInfo.getCreator() != null) {
            xmlInfo.setCreateorId(solutionInfo.getCreator().getId().toString());
        }
        if (solutionInfo.getBarcodeConfig() != null) {
            xmlInfo.setConfigId(solutionInfo.getBarcodeConfig().getId().toString());
        }
        xmlInfo.setEntityBosType(solutionInfo.getEntityBosType());
        xmlInfo.setName(solutionInfo.getName());
        List<BarcodeDefaultXMLItem> list = this.parentUI.getTablePanel().buildDefaultItems();
        xmlInfo.setItems(list);
        return xmlInfo;
    }

    public boolean isAddNew() {
        Locale locale = SysContext.getSysContext().getLocale();
        LanguageInfo lang = new LanguageInfo(locale);
        String newName = this.solutionNameTextField.getItemBy(lang).getData().toString();
        return this.currentSolutionInfo == null || !newName.equals(this.currentSolutionInfo.getName());
    }

    protected void confirmButton_actionPerformed(ActionEvent e) {
        try {
            this.saveSolution();
        }
        catch (Exception e1) {
            this.handleException(e1);
            return;
        }
        Util.getWindow((Component)((Object)this)).dispose();
    }

    public BarcodeDefaultSolutionInfo getReturnObject() {
        return this.returnObject;
    }

    public void setReturnObject(BarcodeDefaultSolutionInfo returnObject) {
        this.returnObject = returnObject;
    }
}

