/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.barcode.scm.BarcodeDefaultSolutionInfo;
import com.kingdee.eas.barcode.scm.BarcodeDefaultXMLInfo;
import com.kingdee.eas.barcode.scm.BarcodeDefaultXMLItem;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.BarcodeXMLHelper;
import com.kingdee.eas.barcode.scm.client.BarcodeDefaultUI;
import com.kingdee.eas.barcode.scm.util.BarcodeClientUtils;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JScrollBar;

public class BarcodeDefaultTablePanel
extends KDPanel {
    protected KDContainer container = new KDContainer();
    protected KDTable kdtTable;
    protected KDWorkButton addRowButton;
    protected KDWorkButton delRowButton;
    protected KDWorkButton clearButton;
    private int width;
    private int height;
    private int SMALL_BUTTON_WIDTH = 22;
    private int SMALL_BUTTON_HEIGHT = 19;
    private int SPACE = 3;
    private int SMALL_SPACE = 1;
    private final String TB_FIELD = "field";
    private final String TB_VALUE = "value";
    private final String TB_NAME = "name";
    protected BarcodeDefaultUI parentUI;
    private Set existsPropety = new HashSet();

    public List<BarcodeDefaultXMLItem> buildDefaultItems() {
        ArrayList<BarcodeDefaultXMLItem> result = new ArrayList<BarcodeDefaultXMLItem>();
        for (int i = 0; i < this.kdtTable.getRowCount(); ++i) {
            IRow row = this.kdtTable.getRow(i);
            BarcodeDefaultXMLItem item = new BarcodeDefaultXMLItem();
            PropertyInfo property = (PropertyInfo)row.getCell("field").getUserObject();
            item.setField(property.getString("fullName"));
            item.setAlias(property.getString("fullAlias"));
            String dataType = property.getString("dataType");
            if (BarcodeClientUtils.getSingleCellValue(row.getCell("value"), property) != null) {
                item.setValue(BarcodeClientUtils.getSingleCellValue(row.getCell("value"), property) + "");
            } else {
                item.setValue(null);
            }
            if (row.getCell("name").getValue() != null) {
                item.setName(row.getCell("name").getValue().toString());
            }
            item.setDataType(dataType);
            result.add(item);
        }
        return result;
    }

    public BarcodeDefaultTablePanel(BarcodeDefaultUI parentUI, int width, int height) {
        this.parentUI = parentUI;
        this.add((Component)this.container);
        this.width = width;
        this.height = height;
        this.jbInit();
    }

    public void jbInit() {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.container.setSize(new Dimension(this.width, this.height));
        this.addRowButton = new KDWorkButton();
        this.addRowButton.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.addRowButton.setToolTipText(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"98_BarcodeDefaultTablePanel"));
        this.addRowButton.setBounds(this.width - (this.SMALL_BUTTON_WIDTH + this.SPACE) * 3, this.SPACE, this.SMALL_BUTTON_WIDTH, this.SMALL_BUTTON_HEIGHT);
        this.addRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BarcodeDefaultTablePanel.this.addRowButton_actionPerformed(e);
            }
        });
        this.delRowButton = new KDWorkButton();
        this.delRowButton.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.delRowButton.setToolTipText(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"99_BarcodeDefaultTablePanel"));
        this.delRowButton.setBounds(this.width - (this.SMALL_BUTTON_WIDTH + this.SPACE) * 2, this.SPACE, this.SMALL_BUTTON_WIDTH, this.SMALL_BUTTON_HEIGHT);
        this.delRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BarcodeDefaultTablePanel.this.delRowButton_actionPerformed(e);
            }
        });
        this.container.add((Component)this.delRowButton);
        this.clearButton = new KDWorkButton();
        this.clearButton.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.clearButton.setToolTipText(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"100_BarcodeDefaultTablePanel"));
        this.clearButton.setBounds(this.width - this.SMALL_BUTTON_WIDTH - this.SPACE, this.SPACE, this.SMALL_BUTTON_WIDTH, this.SMALL_BUTTON_HEIGHT);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BarcodeDefaultTablePanel.this.clearButton_actionPerformed(e);
            }
        });
        this.container.add((Component)this.clearButton);
        this.initTable();
        this.kdtTable.setBounds(this.SPACE, this.SPACE + this.SMALL_BUTTON_HEIGHT + this.SMALL_SPACE, this.width - this.SPACE * 2, this.height - this.SPACE * 3 - this.SMALL_BUTTON_HEIGHT - 40);
        this.container.add((Component)this.kdtTable);
    }

    protected void initTable() {
        this.kdtTable = new KDTable();
        String[] colums = new String[]{"field", "value", "name"};
        String[] alias = new String[]{EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"101_BarcodeDefaultTablePanel"), EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"102_BarcodeDefaultTablePanel"), EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"103_BarcodeDefaultTablePanel")};
        for (int i = 0; i < colums.length; ++i) {
            IColumn iColumn = this.kdtTable.addColumn();
            iColumn.setKey(colums[i]);
            iColumn.setWidth(100);
        }
        this.kdtTable.getColumn(0).setWidth(200);
        this.kdtTable.getColumn(0).getStyleAttributes().setBackground(BarcodeClientUtils.lockedColor);
        this.kdtTable.getColumn(2).getStyleAttributes().setBackground(BarcodeClientUtils.lockedColor);
        IRow headRow = this.kdtTable.addHeadRow();
        for (int i = 0; i < alias.length; ++i) {
            headRow.getCell(i).setValue((Object)alias[i]);
        }
        this.kdtTable.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
        this.kdtTable.getLayoutManager().setHorizonScrollBar((JScrollBar)new KDScrollBar(0));
        this.kdtTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    BarcodeDefaultTablePanel.this.kdtTable_editStopped(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
    }

    protected void kdtTable_editStopped(KDTEditEvent e) {
        if (e.getValue() == null) {
            this.kdtTable.getCell(e.getRowIndex(), "name").setValue(null);
            return;
        }
        if (e.getColIndex() == this.kdtTable.getColumnIndex("value") && e.getValue() instanceof IObjectValue) {
            IObjectValue value = (IObjectValue)e.getValue();
            if (value instanceof TrackNumberInfo) {
                this.kdtTable.getCell(e.getRowIndex(), "name").setValue(value.get("number"));
            } else {
                this.kdtTable.getCell(e.getRowIndex(), "name").setValue(value.get("name"));
            }
        }
    }

    protected void clearButton_actionPerformed(ActionEvent e) {
        this.kdtTable.removeRows();
    }

    protected void delRowButton_actionPerformed(ActionEvent e) {
        int selectedRowIndex = this.kdtTable.getSelectManager().getActiveRowIndex();
        if (selectedRowIndex == -1) {
            return;
        }
        PropertyInfo propertyInfo = (PropertyInfo)this.kdtTable.getCell(selectedRowIndex, "field").getUserObject();
        if (propertyInfo != null) {
            this.existsPropety.remove(propertyInfo.get("fullName"));
        }
        this.kdtTable.removeRow(selectedRowIndex);
    }

    protected void addRowButton_actionPerformed(ActionEvent e) {
        this.addRow();
    }

    protected void addRow() {
        int currentRowSize = this.kdtTable.getRowCount();
        this.kdtTable.addRow(currentRowSize);
        this.initTableEditor(currentRowSize);
    }

    public IRow addRow(int index) {
        IRow row = this.kdtTable.addRow(index);
        return row;
    }

    protected void initTableEditor(int currentRowSize) {
    }

    public IRow insertNewRow(PropertyInfo property, String value) {
        if (property != null && this.existsPropety.contains(property.get("fullName"))) {
            return null;
        }
        int insertRowIndex = this.getInsertRowIndex();
        IRow row = this.addRow(insertRowIndex);
        row.getStyleAttributes().setLocked(true);
        row.getCell("field").setValue(property.get("fullAlias"));
        row.getCell("field").setUserObject((Object)property);
        ICell compareValueCell = row.getCell("value");
        try {
            BarcodeClientUtils.loadSingleCell(compareValueCell, property, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            ExceptionHandler.handle((Throwable)e);
        }
        this.kdtTable.getSelectManager().select(insertRowIndex, 2);
        if (property != null) {
            this.existsPropety.add(property.get("fullName"));
        }
        return row;
    }

    public void clear() {
        this.kdtTable.removeRows();
        this.existsPropety.clear();
    }

    public int getInsertRowIndex() {
        ArrayList blocks = this.kdtTable.getSelectManager().getBlocks();
        if (blocks.size() == 1) {
            KDTSelectBlock block = (KDTSelectBlock)blocks.get(0);
            int selectedRowIndex = block.getBeginRow();
            if (this.kdtTable.getCell(selectedRowIndex, "field").getValue() == null) {
                return block.getBeginRow();
            }
            return block.getBeginRow() + 1;
        }
        return this.getFirstBrankRowIndex();
    }

    public int getFirstBrankRowIndex() {
        int size = this.kdtTable.getRowCount();
        for (int i = 0; i < size; ++i) {
            if (this.kdtTable.getRow(i).getCell("field").getValue() != null) continue;
            return i;
        }
        return this.kdtTable.getRowCount();
    }

    public void reloadSolution(BarcodeDefaultSolutionInfo solution) {
        this.clear();
        if (solution == null || solution.getDetailsXML() == null) {
            return;
        }
        BarcodeDefaultXMLInfo xmlInfo = BarcodeXMLHelper.toBarcodeDefaultXMLInfo(solution.getDetailsXML());
        List<BarcodeDefaultXMLItem> list = xmlInfo.getItems();
        EntityObjectInfo entity = this.parentUI.getEntity();
        try {
            for (int i = 0; i < list.size(); ++i) {
                BarcodeDefaultXMLItem item = list.get(i);
                String field = item.getField();
                String alias = item.getAlias();
                String name = item.getName();
                PropertyInfo propertyInfo = BarcodeUtils.getPropertyByMuch(field, entity);
                propertyInfo.put("fullName", (Object)field);
                propertyInfo.put("fullAlias", (Object)alias);
                IRow row = this.insertNewRow(propertyInfo, item.getValue());
                if (row == null || name == null) continue;
                row.getCell("name").setValue((Object)name);
                IObjectValue value = (IObjectValue)row.getCell("value").getValue();
                if (value != null) {
                    value.put("name", (Object)name);
                    continue;
                }
                row.getCell("name").setValue(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ExceptionHandler.handle((Throwable)e);
        }
    }
}

