/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.barcode.scm.client.BarcodeDefaultTablePanel;
import com.kingdee.eas.barcode.scm.client.BarcodeDefaultUI;
import com.kingdee.eas.barcode.scm.client.SelectEntityUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BarcodeDefaultTreePanel
extends KDPanel {
    private Logger logger = Logger.getLogger(KDPanel.class);
    protected KDTreeView treeView;
    protected KDTree tree;
    protected EntityObjectInfo entityObjectInfo;
    protected BarcodeDefaultUI parentUI;
    int SPACE = 3;
    int BUTTON_HEIGHT = 20;

    public BarcodeDefaultTreePanel(BarcodeDefaultUI parentUI, EntityObjectInfo entityObjectInfo) {
        this.parentUI = parentUI;
        this.entityObjectInfo = entityObjectInfo;
        this.init();
    }

    public void init() {
        DefaultKingdeeTreeNode root = null;
        try {
            root = new SelectEntityUI().getProperty(this.entityObjectInfo);
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
        }
        this.tree = new KDTree();
        ((KingdeeTreeModel)this.tree.getModel()).setRoot((TreeNode)root);
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BarcodeDefaultTreePanel.this.treeClickEvent(e);
            }
        });
        this.tree.setShowCheckBox(false);
        this.treeView = new KDTreeView(this.tree);
        this.treeView.setShowButton(false);
        KDScrollPane pane = new KDScrollPane();
        pane.getViewport().add((Component)this.treeView, null);
        this.setLayout(new BorderLayout());
        int height = 300 - 3 * this.BUTTON_HEIGHT - 3 * this.SPACE;
        pane.setPreferredSize(new Dimension(this.parentUI.kDTabbedPane1.getWidth() - this.SPACE * 2, this.parentUI.kDTabbedPane1.getHeight() - this.SPACE * 3 - 1 * this.BUTTON_HEIGHT));
        pane.setHorizontalScrollBarPolicy(31);
        this.add((Component)pane, "Center");
    }

    public void treeClickEvent(MouseEvent e) {
        if (e.getButton() != 1 || e.getClickCount() != 2) {
            return;
        }
        KDTree tree = (KDTree)e.getSource();
        TreePath treePath = tree.getPathForLocation(e.getX(), e.getY());
        if (treePath == null) {
            return;
        }
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)tree.getLastSelectedPathComponent();
        if (!treeNode.isLeaf() || !(treeNode.getUserObject() instanceof PropertyInfo)) {
            return;
        }
        PropertyInfo property = (PropertyInfo)treeNode.getUserObject();
        BarcodeDefaultTablePanel tablePanel = this.parentUI.getTablePanel();
        tablePanel.insertNewRow(property, null);
    }
}

