/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.barcode.scm.BarcodeDossierCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierEntryCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodeDossierFactory;
import com.kingdee.eas.barcode.scm.BarcodeDossierInfo;
import com.kingdee.eas.barcode.scm.BarcodeDossierTemplateEntryCollection;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.IBarcodeDossier;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterEntryCollection;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterInfo;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetInfo;
import com.kingdee.eas.barcode.scm.client.AbstractBarcodeDossierListUI;
import com.kingdee.eas.barcode.scm.client.BarCodeBDPrint;
import com.kingdee.eas.barcode.scm.client.BarCodePrintParam;
import com.kingdee.eas.barcode.scm.client.BarcodePrintConfig;
import com.kingdee.eas.barcode.scm.client.FABarcodeUtils;
import com.kingdee.eas.barcode.scm.client.IndBarcodeFilterUI;
import com.kingdee.eas.barcode.scm.util.BarcodeClientUtils;
import com.kingdee.eas.barcode.scm.util.BarcodeDataProvider;
import com.kingdee.eas.barcode.scm.util.BarcodePrintListener;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.util.MultiDataSourceDataProviderProxy;
import com.kingdee.eas.basedata.assistant.util.PrintIntegrationManager;
import com.kingdee.eas.basedata.master.material.AsstAttrValueCollection;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.IAsstAttrValue;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUIController;
import com.kingdee.eas.framework.print.MultiapproveDataProvider;
import com.kingdee.eas.tools.datatask.DIETemplateCollection;
import com.kingdee.eas.tools.datatask.DIETemplateFactory;
import com.kingdee.eas.tools.datatask.DIETemplateInfo;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.IDIETemplate;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BarcodeDossierListUI
extends AbstractBarcodeDossierListUI {
    private static final Logger logger = CoreUIObject.getLogger(BarcodeDossierListUI.class);
    private IndBarcodeFilterUI filterUI = null;
    private CommonQueryDialog commonQueryDialog = null;
    IndBarcodeMasterInfo masterInfo = null;
    private BarcodePrintConfig printConfig = null;
    private File selectedTmplFile = null;
    private String arriKey = "";
    private Map<String, String> tdHashMap = new LinkedHashMap<String, String>();
    private Map<String, String> dynColMap = new HashMap<String, String>();
    private Map<String, BarcodeDossierTemplateEntryCollection> billTemplateMap = new HashMap<String, BarcodeDossierTemplateEntryCollection>();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        FABarcodeUtils.requestLicenseOrReleaseLicense(this.getUIContext(), true, (CoreUI)this);
        super.onLoad();
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.btnPrintPreview.setText("\u91cd\u6253");
        this.btnPrintPreview.setToolTipText("\u91cd\u6253");
        this.actionExportData.setVisible(true);
        this.actionExportData.setEnabled(true);
        this.actionBarcodeTDPrint.setEnabled(true);
        this.actionBarcodeTDPerview.setEnabled(true);
        this.actionBarcodeTDPrint.setVisible(true);
        this.actionBarcodeTDPerview.setVisible(true);
        this.btnTemplate.setIcon(EASResource.getIcon((String)"imgTree_topic_open"));
        String userNum = null;
        SysContext sysCtx = SysContext.getSysContext();
        if (sysCtx != null && sysCtx.getCurrentUserInfo() != null) {
            userNum = sysCtx.getCurrentUserInfo().getNumber();
        }
        this.printConfig = new BarcodePrintConfig(userNum);
        this.selectedTmplFile = this.printConfig.getTemplateFile(this.printConfig.getTemplateDir(), this.printConfig.getSelectedTemplate());
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getColumn("isLaser").getStyleAttributes().setHided(true);
        this.actionPrint.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setEnabled(false);
        this.actionPrintPreview.setVisible(false);
        this.btnPrint.setEnabled(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setEnabled(false);
        this.btnPrintPreview.setVisible(false);
        this.actionTemplate.setEnabled(false);
        this.actionTemplate.setVisible(false);
        this.actionUpdateOutRule.setEnabled(true);
        this.menuItemUpdateRule.setEnabled(true);
        if (this.getUIContext().containsKey("masterInfo")) {
            this.masterInfo = (IndBarcodeMasterInfo)this.getUIContext().get("masterInfo");
            this.filterUI.prmtMaster.setValue((Object)this.masterInfo);
            this.initTypeCol();
        }
    }

    protected boolean isOrderForClickTableHead() {
        return false;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void reloadData() {
        IRow curRow = null;
        for (int i = this.tblMain.getRowCount() - 1; i >= 0; --i) {
            curRow = this.tblMain.getRow(i);
            if (curRow == null || curRow.getCell("isHide") == null || curRow.getCell("isHide").getValue() == null || !((Boolean)curRow.getCell("isHide").getValue()).booleanValue()) continue;
            this.tblMain.removeRow(i);
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK arg0, EntityViewInfo arg1) {
        if (this.getUIContext().containsKey("ids")) {
            IObjectPK[] ids = (IObjectPK[])this.getUIContext().get("ids");
            HashSet<IObjectPK> setIds = new HashSet<IObjectPK>();
            for (int i = 0; i < ids.length; ++i) {
                setIds.add(ids[i]);
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", setIds, CompareType.INCLUDE));
            arg1.setFilter(filter);
        }
        SorterItemCollection sorterCol = new SorterItemCollection();
        SorterItemInfo sortItem = new SorterItemInfo("number");
        sortItem.setSortType(SortType.ASCEND);
        sorterCol.add(sortItem);
        arg1.setSorter(sorterCol);
        IQueryExecutor exec = super.getQueryExecutor(arg0, arg1);
        return exec;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        return filter;
    }

    protected void setSortForQuery(SorterItemInfo sortItem, SorterItemInfo oldSortItem) throws Exception {
        super.setSortForQuery(sortItem, oldSortItem);
    }

    public void setIsNeedDefaultFilter(boolean need) {
        super.setIsNeedDefaultFilter(true);
    }

    public FilterInfo getFilterInfo() {
        return super.getFilterInfo();
    }

    protected void execQuery() {
        super.execQuery();
    }

    public void actionQuery_actionPerformed(ActionEvent arg0) throws Exception {
        this.getFilterUI();
        super.actionQuery_actionPerformed(arg0);
        this.masterInfo = (IndBarcodeMasterInfo)this.filterUI.prmtMaster.getValue();
    }

    public void refreshList() throws Exception {
        this.initTypeCol();
        super.refreshList();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        uiContext.put((Object)"MASTERINFO", (Object)this.masterInfo);
        this.prepareUIContext(uiContext, e);
        this.getUIContext().putAll(uiContext);
        IUIWindow uiWindow = null;
        ((ListUIController)super.getUIController()).actionAddNew();
        uiWindow = ((ListUIController)super.getUIController()).getNavigator().getUIWindow();
        Window win = SwingUtilities.getWindowAncestor((Component)uiWindow.getUIObject());
        if (!win.isActive() && win instanceof JFrame && ((JFrame)win).getExtendedState() == 1) {
            ((JFrame)win).setExtendedState(0);
        }
        if (uiWindow == null || !this.isDoRefresh(uiWindow)) {
            return;
        }
        if (UtilRequest.isPrepare((String)"ActionRefresh", (CoreUIObject)this)) {
            this.prepareRefresh(null).callHandler();
        }
        this.refresh(e);
        this.setPreSelecteRow();
    }

    @Override
    public void actionTemplate_actionPerformed(ActionEvent e) throws Exception {
        File templFile;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileFilter(BarcodePrintConfig.TEMPLATE_FILTER);
        if (this.selectedTmplFile != null) {
            fileChooser.setSelectedFile(this.selectedTmplFile);
        } else if (this.printConfig != null && (templFile = this.printConfig.getTemplateFile(this.printConfig.getTemplateDir(), this.printConfig.getSelectedTemplate())) != null && templFile.exists()) {
            fileChooser.setSelectedFile(templFile);
        }
        int action = fileChooser.showOpenDialog((Component)((Object)this));
        File selectedTempl = null;
        if (action == 0) {
            selectedTempl = fileChooser.getSelectedFile();
            boolean fA = BarcodePrintConfig.TEMPLATE_FILTER.accept(selectedTempl);
            logger.debug((Object)("has the lab files :" + fA));
            if (fA) {
                this.selectedTmplFile = selectedTempl;
                this.printConfig.saveTemplate(selectedTempl);
            }
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BarcodeDossierFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        BarcodeDossierInfo objectValue = new BarcodeDossierInfo();
        return objectValue;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = super.initCommonQueryDialog();
            this.commonQueryDialog.setWidth(400);
        }
        this.commonQueryDialog.addUserPanel((KDPanel)this.getFilterUI());
        return this.commonQueryDialog;
    }

    protected CustomerQueryPanel getCustomerQueryPanel() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new IndBarcodeFilterUI();
        }
        return this.filterUI;
    }

    private CustomerQueryPanel getFilterUI() {
        if (this.filterUI == null) {
            try {
                this.filterUI = new IndBarcodeFilterUI();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.abort(e);
            }
        }
        return this.filterUI;
    }

    protected boolean initDefaultFilter() {
        return !this.getUIContext().containsKey("masterInfo");
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        this.print(e, false);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        this.print(e, true);
    }

    @Override
    public void actionBarcodeTDPrint_actionPerformed(ActionEvent e) throws Exception {
        List<Map<String, String>> printBarcodes = this.getSelectedBarcodes(false, true);
        if (printBarcodes == null || printBarcodes.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u8bf7\u9009\u62e9\u9700\u8981\u6253\u5370\u7684\u6761\u7801\uff01");
            logger.error((Object)"no barcodes are selected to print");
            return;
        }
        this.invokePrintFunction(e, true, printBarcodes);
    }

    @Override
    public void actionBarcodeTDPerview_actionPerformed(ActionEvent e) throws Exception {
        List<Map<String, String>> printBarcodes = this.getSelectedBarcodes(false, true);
        if (printBarcodes == null || printBarcodes.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u8bf7\u9009\u62e9\u9700\u8981\u6253\u5370\u7684\u6761\u7801\uff01");
            logger.error((Object)"no barcodes are selected to print");
            return;
        }
        this.invokePrintFunction(e, false, printBarcodes);
    }

    protected void invokePrintFunction(ActionEvent e, boolean isPrint, List<Map<String, String>> idList) throws Exception {
        if (idList == null || idList.size() == 0) {
            return;
        }
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        BarcodeDataProvider mainQueryData = new BarcodeDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        HashMap<String, String> updatBarcodeMap = new HashMap<String, String>();
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            Map<String, String> barcodeMap = idList.get(i);
            String barcode = barcodeMap.get("Barcode");
            if (updatBarcodeMap.containsKey(barcode)) continue;
            updatBarcodeMap.put(barcode, barcode);
        }
        BarcodePrintListener barcodePrintListener = new BarcodePrintListener(appHlp, null, updatBarcodeMap, this.getTDFileName());
        appHlp.addKDNoteActionListener((IPrintActionListener)barcodePrintListener);
        if (isPrint) {
            appHlp.print(this.getTDFileName(), (Object)mainQueryData, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview(this.getTDFileName(), (Object)mainQueryData, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
        this.refreshList();
    }

    private void print(ActionEvent e, boolean isRePrint) throws Exception {
        if (this.selectedTmplFile == null || !this.selectedTmplFile.exists()) {
            logger.error((Object)"no template are selected ");
            this.actionTemplate_actionPerformed(e);
            if (this.selectedTmplFile == null || !this.selectedTmplFile.exists()) {
                logger.error((Object)"user doesnot select any template ");
                return;
            }
        }
        String templateFileName = this.selectedTmplFile.getAbsolutePath();
        List<Map<String, String>> printBarcodes = this.getSelectedBarcodes(isRePrint, false);
        if (printBarcodes.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u8bf7\u9009\u62e9\u9700\u8981\u6253\u5370\u7684\u6761\u7801\uff01");
            logger.error((Object)"no barcodes are selected to print");
            return;
        }
        BarCodeBDPrint printer = new BarCodeBDPrint();
        BarCodePrintParam param = new BarCodePrintParam(this, templateFileName, 1, printBarcodes, this.tblMain);
        printer.doPrint(param);
    }

    private List<Map<String, String>> getSelectedBarcodes(boolean isRePrint, boolean isTDPrint) {
        ArrayList selBlocks = this.tblMain.getSelectManager().getBlocks();
        if (selBlocks == null || selBlocks.size() == 0) {
            return null;
        }
        ArrayList<Map<String, String>> barcodes = new ArrayList<Map<String, String>>();
        IRow row = null;
        KDTSelectBlock block = null;
        IBarcodeDossier iBarcodeDossier = null;
        try {
            iBarcodeDossier = BarcodeDossierFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        boolean isRepeatPrint = false;
        try {
            IndubarodeParamsetInfo indParasetInfo = BarcodeClientUtils.getParamValue(null);
            isRepeatPrint = indParasetInfo.isRepeatPrint();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        StringBuffer idsbf = new StringBuffer();
        LinkedHashMap<String, String> rowIndexMap = new LinkedHashMap<String, String>();
        HashMap<String, String> numberMap = new HashMap<String, String>();
        int n = selBlocks.size();
        block6: for (int i = 0; i < n; ++i) {
            block = (KDTSelectBlock)selBlocks.get(i);
            int iBeginRow = block.getBeginRow();
            int iEndRow = block.getEndRow();
            for (int j = iBeginRow; j <= iEndRow; ++j) {
                String id;
                row = this.tblMain.getRow(j);
                if (!isRepeatPrint) {
                    if (isRePrint) {
                        if (!Boolean.valueOf(row.getCell("isPrint").getValue().toString()).booleanValue()) {
                            MsgBox.showWarning((Component)((Object)this), (String)"\u5df2\u6253\u5370\u7684\u6761\u7801\u624d\u80fd\u91cd\u6253\uff01");
                            SysUtil.abort();
                            continue block6;
                        }
                    } else if (Boolean.valueOf(row.getCell("isPrint").getValue().toString()).booleanValue()) {
                        MsgBox.showWarning((Component)((Object)this), (String)"\u5df2\u6253\u5370\u7684\u6761\u7801\u4e0d\u80fd\u518d\u6253\u5370\uff01");
                        SysUtil.abort();
                        continue;
                    }
                }
                if (row.getCell("number").getValue() == null || numberMap.containsKey(id = row.getCell("number").getValue().toString())) continue;
                if (idsbf.length() > 0) {
                    idsbf.append(",").append(id);
                } else {
                    idsbf.append(id);
                }
                numberMap.put(id, id);
                rowIndexMap.put(id, j + "");
            }
        }
        try {
            if (idsbf.length() > 0) {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection sic = this.getSelectors();
                sic.add(new SelectorItemInfo("entrys.displayName.isHide"));
                sic.add(new SelectorItemInfo("entrys.displayName.name"));
                sic.add(new SelectorItemInfo("entrys.displayName.tdPt"));
                sic.add(new SelectorItemInfo("entrys.value"));
                sic.add(new SelectorItemInfo("entrys.name"));
                sic.add(new SelectorItemInfo("entrys.seq"));
                sic.add(new SelectorItemInfo("barRule.*"));
                sic.add(new SelectorItemInfo("qrcode"));
                sic.add(new SelectorItemInfo("template.number"));
                sic.add(new SelectorItemInfo("template.entrys.name"));
                sic.add(new SelectorItemInfo("template.entrys.value"));
                sic.add(new SelectorItemInfo("template.entrys.displayName.*"));
                view.setSelector(sic);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)idsbf.toString(), CompareType.INCLUDE));
                view.setFilter(filter);
                SorterItemCollection sortColl = new SorterItemCollection();
                if (this.mainQuery.getSorter() != null) {
                    SorterItemCollection oldSorterCol = this.mainQuery.getSorter();
                    int size = oldSorterCol.size();
                    for (int i = 0; i < size; ++i) {
                        SorterItemInfo sortInfo = oldSorterCol.get(i);
                        String name = sortInfo.getPropertyName();
                        if ("entry.seq".equals(name) || "id".equals(name)) continue;
                        sortColl.add(sortInfo);
                    }
                } else {
                    SorterItemInfo sortItem = new SorterItemInfo("number");
                    sortItem.setSortType(SortType.ASCEND);
                    sortColl.add(sortItem);
                }
                view.setSorter(sortColl);
                BarcodeDossierCollection bossierInfoCol = iBarcodeDossier.getBarcodeDossierCollection(view);
                System.out.println("\u5957\u6253\u6570\u636e\u7684sql" + view.toString());
                if (bossierInfoCol.size() > 0) {
                    return this.getPrintBarcodeMap(bossierInfoCol, isTDPrint, rowIndexMap);
                }
                MsgBox.showWarning((Component)((Object)this), (String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u6253\u5370\u8bb0\u5f55");
                SysUtil.abort();
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u6253\u5370\u8bb0\u5f55");
                SysUtil.abort();
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return barcodes;
    }

    private List<Map<String, String>> getPrintBarcodeMap(BarcodeDossierCollection bossierInfoCol, boolean isTDPrint, Map<String, String> rowIndexMap) {
        ArrayList<Map<String, String>> listMap = new ArrayList<Map<String, String>>();
        IAsstAttrValue iAsstAttrValue = null;
        IMaterial iMaterial = null;
        IMeasureUnit iMeasureUnit = null;
        try {
            iAsstAttrValue = AsstAttrValueFactory.getRemoteInstance();
            iMaterial = MaterialFactory.getRemoteInstance();
            iMeasureUnit = MeasureUnitFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        int size = bossierInfoCol.size();
        for (int i = 0; i < size; ++i) {
            BarcodeDossierInfo barcodeDossierInfo = bossierInfoCol.get(i);
            HashMap<String, String> dMap = new HashMap<String, String>();
            String barCode = barcodeDossierInfo.getNumber();
            dMap.put("Barcode", barCode);
            String qrcode = barcodeDossierInfo.getQrcode();
            if (qrcode != null) {
                try {
                    String nreqr = BarcodeUtils.getQrCode(isTDPrint, qrcode, barCode);
                    dMap.put("QRcode", nreqr);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            String dKey = "f";
            Object colKey = null;
            int keyIdx = 2;
            String cellVal = null;
            BarcodeDossierEntryCollection dossierEntryCol = barcodeDossierInfo.getEntrysByTemplate();
            if (!isTDPrint && rowIndexMap.containsKey(barcodeDossierInfo.getId().toString())) {
                dMap.put(barCode, rowIndexMap.get(barcodeDossierInfo.getId().toString()));
            }
            int m = dossierEntryCol.size();
            for (int j = 0; j < m; ++j) {
                BarcodeDossierEntryInfo entryInfo = dossierEntryCol.get(j);
                cellVal = entryInfo.getValue();
                if (!isTDPrint) {
                    if (entryInfo.getDisplayName().isIsHide()) continue;
                    if (cellVal != null) {
                        dMap.put(dKey + keyIdx, cellVal.toString());
                    } else {
                        dMap.put(dKey + keyIdx, " ");
                    }
                    String dispalyName = entryInfo.getDisplayName().getName();
                    if ("\u8f85\u52a9\u5c5e\u6027".equalsIgnoreCase(dispalyName) && cellVal != null) {
                        try {
                            AsstAttrValueCollection asstAttrValueCollection = iAsstAttrValue.getAsstAttrValueCollection("select name from where number='" + cellVal + "'");
                            if (asstAttrValueCollection.size() > 0) {
                                this.setAssistMap(asstAttrValueCollection.get(0).getName(), dMap);
                            }
                        }
                        catch (BOSException e) {
                            e.printStackTrace();
                        }
                    }
                    if ("\u8ba1\u91cf\u5355\u4f4d".equalsIgnoreCase(dispalyName) && cellVal != null) {
                        try {
                            MeasureUnitCollection unitCol = iMeasureUnit.getMeasureUnitCollection("select name from where number='" + cellVal + "'");
                            if (unitCol.size() > 0) {
                                dMap.put(dKey + keyIdx, unitCol.get(0).getName().toString());
                            }
                        }
                        catch (BOSException e) {
                            e.printStackTrace();
                        }
                    }
                    ++keyIdx;
                    continue;
                }
                if (entryInfo.getDisplayName() == null || entryInfo.getDisplayName().getTdPt() == null) continue;
                String tdPt = entryInfo.getDisplayName().getTdPt().getValue();
                if (cellVal == null) {
                    dMap.put(tdPt, "");
                    continue;
                }
                dMap.put(tdPt, cellVal.toString());
            }
            listMap.add(dMap);
        }
        return listMap;
    }

    private void setAssistMap(String assistValue, Map<String, String> dMap) {
        String valueName = assistValue;
        String[] propArr = valueName.split("/");
        for (int i = 0; i < propArr.length; ++i) {
            if (i == 0) {
                dMap.put("FZM001", propArr[0]);
            }
            if (i == 1) {
                dMap.put("FZM002", propArr[1]);
            }
            if (i != 2) continue;
            dMap.put("FZM003", propArr[2]);
        }
    }

    protected void invokePrintFunction(ActionEvent e, boolean isPrint) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        MultiDataSourceDataProviderProxy data = new MultiDataSourceDataProviderProxy();
        BarcodeDataProvider mainQueryData = new BarcodeDataProvider(null);
        data.put("MainQuery", (BOSQueryDelegate)mainQueryData);
        MultiapproveDataProvider multiapproveDataSource = new MultiapproveDataProvider(this.getSelectedIdForPrint(), this.isShowMultiapproveHistoryForPrint(), "billId");
        multiapproveDataSource.setMultiapproveDataFilter(this.getMultiapproveDataFilter());
        data.put(this.getMultiapproveQueryNameForPrint(), (BOSQueryDelegate)multiapproveDataSource);
        KDNoteHelper appHlp = new KDNoteHelper();
        PrintIntegrationManager.initPrint((KDNoteHelper)appHlp, (BOSObjectType)new BarcodeDossierInfo().getBOSType(), (List)idList, (String)this.getTDFileName(), (String)"com.kingdee.eas.scm.common.SCMResource", (boolean)true);
        if (isPrint) {
            appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.barcode.scm.app.IndBarcodeSetupPrintQuery");
    }

    @Override
    protected String getTDFileName() {
        return "/barcode";
    }

    @Override
    public void actionUpdateBarcode_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        StringBuffer barcodeStr = new StringBuffer();
        HashMap<String, String> numMap = new HashMap<String, String>();
        for (int i = 0; i < selectRows.length; ++i) {
            String key;
            String objectValue = this.tblMain.getRow(selectRows[i]).getCell("number").getValue().toString();
            if (objectValue == null || numMap.containsKey(key = objectValue.toString())) continue;
            numMap.put(key, key);
            if (barcodeStr.length() > 0) {
                barcodeStr.append("','").append(key);
                continue;
            }
            barcodeStr.append(key);
        }
        if (barcodeStr.length() > 0) {
            try {
                BarcodeDossierFactory.getRemoteInstance().updateBarcodeStatus(barcodeStr.toString(), 2, null, null);
                MsgBox.showInfo((Component)((Object)this), (String)"\u66f4\u65b0\u6210\u529f\uff01");
                this.refresh(e);
            }
            catch (Exception e2) {
                e2.fillInStackTrace();
                MsgBox.showInfo((Component)((Object)this), (String)"\u66f4\u65b0\u5931\u8d25\uff01");
            }
        }
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        super.getRowSetBeforeFillTable(rowSet);
        if (rowSet != null) {
            try {
                while (rowSet.next()) {
                    rowSet.getObject("template.id");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                rowSet.first();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        int start = e.getFirstRow();
        int end = e.getLastRow();
        super.afterTableFillData(e);
        String key = null;
        HashSet<String> newTempSet = new HashSet<String>();
        HashSet<String> ids = new HashSet<String>();
        for (int i = start; i <= end; ++i) {
            ids.add((String)this.tblMain.getCell(i, "id").getValue());
            key = (String)this.tblMain.getCell(i, "templateid").getValue();
            if (this.billTemplateMap.get(key) != null || key == null || newTempSet.contains(key)) continue;
            newTempSet.add(key);
        }
        try {
            Map revMap = BarcodeDossierFactory.getRemoteInstance().getBillEntrysColl(ids, newTempSet);
            Map billEntryMap = (Map)revMap.get("BILL_ENTRY");
            Map tempIdEntryMap = (Map)revMap.get("TEMPLATE_ENTRY");
            if (tempIdEntryMap != null) {
                this.billTemplateMap.putAll(tempIdEntryMap);
            }
            this.fillData(e, start, end, billEntryMap, this.billTemplateMap);
        }
        catch (BOSException e1) {
            e1.printStackTrace();
            this.handUIException(e1);
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
            e1.printStackTrace();
        }
    }

    private void initTypeCol() {
        IndBarcodeMasterInfo info = (IndBarcodeMasterInfo)this.filterUI.prmtMaster.getValue();
        IndBarcodeMasterEntryCollection colls = info.getEntry();
        if (this.dynColMap.size() > 0) {
            Iterator<String> it = this.dynColMap.keySet().iterator();
            String key = null;
            while (it.hasNext()) {
                key = it.next();
                this.tblMain.removeColumn(this.tblMain.getColumnIndex(this.dynColMap.get(key)));
            }
        }
        this.dynColMap.clear();
        if (colls == null || colls.size() == 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("Entry.id"));
            sic.add(new SelectorItemInfo("Entry.name"));
            sic.add(new SelectorItemInfo("Entry.type"));
            try {
                info = IndBarcodeMasterFactory.getRemoteInstance().getIndBarcodeMasterInfo((IObjectPK)new ObjectUuidPK(info.getId()), sic);
                colls = info.getEntry();
            }
            catch (EASBizException e) {
                e.printStackTrace();
                this.handUIException(e);
            }
            catch (BOSException e) {
                e.printStackTrace();
                this.handUIException(e);
            }
        }
        IRow row = this.tblMain.getHeadRow(0);
        String colkey = null;
        int count = colls.size();
        for (int i = 0; i < count; ++i) {
            IColumn col = this.tblMain.addColumn();
            colkey = "dyncol" + (i + 1);
            col.setKey(colkey);
            row.getCell(colkey).setValue((Object)colls.get(i).getName());
            this.dynColMap.put(colls.get(i).getName(), colkey);
        }
    }

    private void fillData(KDTDataRequestEvent e, int start, int end, Map<String, BarcodeDossierEntryCollection> entryMap, Map<String, BarcodeDossierTemplateEntryCollection> templateEntryMap) throws EASBizException, BOSException {
        Object key = null;
        Object id = null;
        Object val = null;
        BarcodeDossierEntryCollection entryColl = null;
        BarcodeDossierTemplateEntryCollection tempEntryColl = null;
        for (int i = start; i <= end; ++i) {
            id = this.tblMain.getCell(i, "id").getValue();
            key = this.tblMain.getCell(i, "templateid").getValue();
            entryColl = entryMap.get(id);
            tempEntryColl = templateEntryMap.get(key);
            this.cellSetVal(this.tblMain.getRow(i), this.dynColMap, tempEntryColl);
            this.cellSetVal(this.tblMain.getRow(i), this.dynColMap, entryColl);
        }
    }

    private void cellSetVal(IRow row, Map<String, String> colMap, AbstractObjectCollection coll) {
        if (coll != null && coll.size() > 0) {
            String name = null;
            int count = coll.size();
            for (int i = 0; i < count; ++i) {
                name = coll.getObject(i).getObjectValue("displayName").getString("name");
                if (colMap.get(name) == null) continue;
                row.getCell(colMap.get(name)).setValue(coll.getObject(i).get("value"));
            }
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        return sic;
    }

    @Override
    protected List getQueryPKFields() {
        super.getQueryPKFields();
        ArrayList<String> pkList = new ArrayList<String>();
        pkList.add("id");
        return pkList;
    }

    @Override
    public void actionUpdateOutRule_actionPerformed(ActionEvent e) throws Exception {
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        if (this.getImportCollectionParam() != null) {
            task.invoke(this.getImportCollectionParam(), 0);
        }
    }

    protected ArrayList getImportCollectionParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.supplyManage.imManage.BarcodeDossier";
        param.alias = BarcodeDossierListUI.getTemplateSheetName("BarcodeDossier");
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public static String getTemplateSheetName(String tempalteNumber) {
        String sheetName = "sheet1";
        try {
            DIETemplateInfo info;
            IDIETemplate iDIETemplate = DIETemplateFactory.getRemoteInstance();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)tempalteNumber, CompareType.EQUALS));
            filter.setMaskString("#0");
            viewInfo.setFilter(filter);
            DIETemplateCollection dIETemplateCollection = iDIETemplate.getDIETemplateCollection(viewInfo);
            if (dIETemplateCollection != null && dIETemplateCollection.size() > 0 && (info = dIETemplateCollection.get(0)) != null) {
                sheetName = info.getSheetName() != null ? info.getSheetName() : info.getName();
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        return sheetName;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.invoke(para, 1);
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "BarcodeDossierTemplate";
        param.datataskMode = 1;
        param.alias = EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"215_IndBarcodeMaster");
        param.varList = new ArrayList();
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }
}

