/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.ActiveContainerEvent;
import com.kingdee.bos.ctrl.swing.event.ActiveContainerListener;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.barcode.scm.BarcodeConfigFactory;
import com.kingdee.eas.barcode.scm.BarcodeConfigInfo;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetCollection;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetFactory;
import com.kingdee.eas.barcode.scm.client.BarcodeComponent;
import com.kingdee.eas.barcode.scm.client.BarcodeDataImport;
import com.kingdee.eas.barcode.scm.client.DefaultBarcodeComponent;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.config.client.ConfigServiceUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class BarcodeEditUI
extends CoreUI {
    private static final long serialVersionUID = 1L;
    protected KDTextArea txtBarcode = new KDTextArea();
    protected KDScrollPane scrollBarocde = new KDScrollPane();
    protected CoreUI parentUI;
    protected BarcodeComponent barcodeComponent;
    protected KDBizPromptBox prmtConfig;
    protected KDCheckBox chkDefault;
    private String defaultConfigId;
    protected KDContainer kcSetting;
    String paramValue = "0";
    private Component comp;
    private Map<String, Object> barcodeMap;

    public void onLoad() throws Exception {
        this.doPermissionItem();
        super.onLoad();
        Component[] cArr = this.getComponents();
        for (int i = 0; i < cArr.length; ++i) {
            cArr[i].setBackground(null);
        }
    }

    private void doPermissionItem() throws BOSException {
    }

    public void onShow() throws Exception {
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"124_BarcodeEditUI"));
        super.onShow();
        this.chkDefault.setSelected(true);
        this.chkDefault.setVisible(false);
        this.parentUI = (CoreUI)this.getUIContext().get("UI");
        this.initConfigFilter();
        this.txtBarcode.requestFocus();
        this.prmtConfig.setRequired(true);
    }

    public boolean destroyWindow() {
        if (this.chkDefault.isSelected()) {
            if (this.prmtConfig.getValue() != null) {
                String configId = ((BarcodeConfigInfo)this.prmtConfig.getValue()).getId().toString();
                if (!configId.equals(this.defaultConfigId)) {
                    ConfigServiceUtils.saveUserConfigData((String)"defaultBarcodeConfig", (CoreUI)this.parentUI, (String)configId);
                }
            } else {
                ConfigServiceUtils.saveUserConfigData((String)"defaultBarcodeConfig", (CoreUI)this.parentUI, (String)"null");
            }
        }
        return super.destroyWindow();
    }

    public void initUIContentLayout() {
        this.setBounds(0, 0, 350, 230);
        this.setLayout(null);
        this.setBackground(null);
        this.setOpaque(false);
        this.scrollBarocde.setAutoscrolls(true);
        this.scrollBarocde.getViewport().add((Component)this.txtBarcode, null);
        this.scrollBarocde.setOpaque(false);
        this.scrollBarocde.setBackground(null);
        this.scrollBarocde.setBounds(new Rectangle(1, 1, 348, 150));
        this.add((Component)this.scrollBarocde);
        this.kcSetting = new KDContainer();
        this.kcSetting.setTitle(EASResource.getString((String)"com.kingdee.eas.barcode.scm.SCMAutoGenerateResource", (String)"16_BarcodeEditUI"));
        this.kcSetting.setBounds(new Rectangle(1, 151, 348, 48));
        KDLabelContainer lbcConfig = CtrlSwingUtilities.createLabelContainer((JComponent)this.prmtConfig, (String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"125_BarcodeEditUI"), (int)10);
        lbcConfig.setBounds(new Rectangle(5, 25, 60, 21));
        this.prmtConfig = new KDBizPromptBox();
        this.prmtConfig.setBounds(new Rectangle(65, 25, 250, 21));
        this.prmtConfig.setEditable(false);
        this.chkDefault = new KDCheckBox();
        this.chkDefault.setBounds(new Rectangle(125, 25, 100, 21));
        this.chkDefault.setText(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource", (String)"BarcodeEditUI_isSetDefault"));
        this.kcSetting.add((Component)lbcConfig);
        this.kcSetting.add((Component)this.prmtConfig);
        this.kcSetting.add((Component)this.chkDefault);
        this.add((Component)this.kcSetting);
        KDWorkButton btnImportCheck = new KDWorkButton();
        btnImportCheck.setName("btnImportCheck");
        btnImportCheck.setText(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"barcodeImport"));
        btnImportCheck.setIcon(EASResource.getIcon((String)"imgTbtn_importcyclostyle"));
        btnImportCheck.setEnabled(true);
        btnImportCheck.setBounds(1, 200, 101, 26);
        this.add((Component)btnImportCheck);
        this.comp = this;
        btnImportCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object config = BarcodeEditUI.this.prmtConfig.getData();
                if (config == null) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"138_BarcodeScanningEditUI"));
                    SysUtil.abort();
                }
                UIContext uiContext = new UIContext((Object)this);
                try {
                    IUIWindow impUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BarcodeDataImport.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
                    impUI.show();
                    IUIObject selUI = impUI.getUIObject();
                    BarcodeEditUI.this.barcodeMap = ((BarcodeDataImport)selUI).getBarcodeMap();
                    if (BarcodeEditUI.this.barcodeMap.size() > 0) {
                        LongTimeDialog dialog = new LongTimeDialog((Dialog)impUI);
                        ((BarcodeDataImport)selUI).destroyWindow();
                        dialog.setLongTimeTask(new ILongTimeTask(){

                            public void afterExec(Object value) throws Exception {
                            }

                            public Object exec() throws Exception {
                                BarcodeEditUI.this.txtBarcode.setText(null);
                                List barcodeList = (List)BarcodeEditUI.this.barcodeMap.get("barcodeList");
                                int importType = Integer.valueOf(BarcodeEditUI.this.barcodeMap.get("importType").toString());
                                int size = barcodeList.size();
                                for (int i = 0; i < size; ++i) {
                                    String barcode = barcodeList.get(i).toString();
                                    BarcodeEditUI.this.txtBarcode.setText(barcode);
                                    BarcodeEditUI.this.actionBarcode_actionPerformed(null);
                                    BarcodeEditUI.this.txtBarcode.setText(null);
                                }
                                return null;
                            }
                        });
                        dialog.setTitle("\u6b63\u5728\u5bfc\u5165\u6570\u636e\uff0c\u8bf7\u7a0d\u7b49......");
                        dialog.show();
                    }
                }
                catch (UIException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.kcSetting.addActiveContainerListener(new ActiveContainerListener(){

            public void action(ActiveContainerEvent e) {
                BarcodeEditUI.this.kcSetting_stateChange(e);
            }
        });
        KeyStroke enter = KeyStroke.getKeyStroke("ENTER");
        this.txtBarcode.getInputMap().put(enter, "none");
        this.txtBarcode.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    try {
                        BarcodeEditUI.this.actionBarcode_actionPerformed(null);
                    }
                    catch (Exception e1) {
                        BarcodeEditUI.this.handleException(e1);
                    }
                }
            }
        });
        this.txtBarcode.setEnabled(true);
        try {
            IndubarodeParamsetCollection paramCol = IndubarodeParamsetFactory.getRemoteInstance().getIndubarodeParamsetCollection();
            if (paramCol != null && paramCol.get(0) != null) {
                if (paramCol.get(0).isBusinessBarcode()) {
                    this.paramValue = "0";
                } else if (paramCol.get(0).isIndBarcode()) {
                    this.paramValue = "1";
                } else if (paramCol.get(0).isPriorBusiness()) {
                    this.paramValue = "2";
                } else if (paramCol.get(0).isPriorInd()) {
                    this.paramValue = "3";
                }
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public boolean isCustomized() {
        return true;
    }

    protected void kcSetting_stateChange(ActiveContainerEvent e) {
        if (this.kcSetting.getState() == 0) {
            this.repaint(0, 0, 350, 120);
        }
    }

    protected void actionBarcode_actionPerformed(Object object) {
        this.barcodeComponent = this.getBarcodeComponent();
        this.barcodeComponent.setBarcodeConfigInfo((BarcodeConfigInfo)this.prmtConfig.getValue());
        try {
            this.barcodeComponent.setBarcodeConfigInfo((BarcodeConfigInfo)this.prmtConfig.getValue());
            this.barcodeComponent.exceuteBarcode(this.parentUI, this.txtBarcode.getText(), this.paramValue);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        this.txtBarcode.selectAll();
    }

    public void initConfigFilter() {
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        this.defaultConfigId = ConfigServiceUtils.getUserConfigData((String)"defaultBarcodeConfig", (CoreUI)this.parentUI);
        this.prmtConfig.setQueryInfo("com.kingdee.eas.barcode.scm.app.F7BarcodeConfigQuery");
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destBosType", (Object)this.parentUI.getDataObject().getBOSType().toString()));
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cu.getId().toString()));
        ev.setFilter(filter);
        this.prmtConfig.setEntityViewInfo(ev);
        this.kcSetting.setState(1);
        if (this.defaultConfigId != null && !"null".equalsIgnoreCase(this.defaultConfigId)) {
            try {
                BarcodeConfigInfo defaultConfigInfo = BarcodeConfigFactory.getRemoteInstance().getBarcodeConfigInfo("where id='" + this.defaultConfigId + "' and cu.id='" + cu.getId().toString() + "'");
                if (defaultConfigInfo != null) {
                    this.kcSetting.setState(0);
                    this.prmtConfig.setValue((Object)defaultConfigInfo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected BarcodeComponent getBarcodeComponent() {
        if (this.barcodeComponent == null) {
            this.barcodeComponent = new DefaultBarcodeComponent();
        }
        return this.barcodeComponent;
    }

    public IMetaDataPK getMetaDataPK() {
        return new MetaDataPK("com.kingdee.eas.barcode.scm.client", "BarcodeEditUI");
    }
}

