/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.ctrl.kdf.kds.ICells;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.read.POIXlsxReader;
import com.kingdee.eas.barcode.scm.BarcodeBillCustColInfo;
import com.kingdee.eas.barcode.scm.BarcodeBillUIConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeExcelData;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BarcodeExcelParser {
    private static final Logger logger = Logger.getLogger(BarcodeExcelParser.class);
    private File excelFile = null;
    private BarcodeBillUIConfigInfo uiConfigInfo = null;
    private List<String> colNames = null;
    private List<String> colKeys = null;

    public BarcodeExcelParser(File excelFile, BarcodeBillUIConfigInfo uiConfigInfo) {
        this.excelFile = excelFile;
        this.uiConfigInfo = uiConfigInfo;
        this.initCols(uiConfigInfo);
    }

    private void initCols(BarcodeBillUIConfigInfo uiConfigInfo) {
        if (uiConfigInfo == null) {
            return;
        }
        List<BarcodeBillCustColInfo> colInfos = uiConfigInfo.getCustCols();
        if (colInfos == null || colInfos.size() == 0) {
            return;
        }
        this.colNames = new ArrayList<String>();
        this.colKeys = new ArrayList<String>();
        this.colKeys.add("barcode");
        this.colKeys.add("billNum");
        int n = colInfos.size();
        for (int i = 0; i < n; ++i) {
            this.colNames.add(colInfos.get(i).getDisplayName());
            this.colKeys.add(colInfos.get(i).getPropertyId());
        }
    }

    public boolean isValidFile() {
        return this.excelFile != null && this.excelFile.exists();
    }

    public boolean isDataEmpty() {
        return false;
    }

    public BarcodeExcelData parseExcel() {
        int i;
        KDSBook kdsBook = null;
        try {
            String name = this.excelFile.getName();
            if (name.contains("xlsx")) {
                kdsBook = POIXlsxReader.parse((String)this.excelFile.getAbsolutePath());
            } else if (name.contains("xls")) {
                kdsBook = POIXlsReader.parse((String)this.excelFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            logger.error((Object)" exception to parse file as excel, ", (Throwable)e);
        }
        if (kdsBook == null) {
            logger.error((Object)(" failed to parse file as excel, " + this.excelFile));
            return null;
        }
        KDSSheet sheet = kdsBook.getSheet((Object)new Integer(0));
        if (sheet == null) {
            logger.error((Object)" cannot get the excel sheet ");
            return null;
        }
        int rowCount = sheet.getRowCount();
        if (rowCount < 2) {
            logger.error((Object)" excel should at leat two rows, head, data");
            return null;
        }
        ICells cells = sheet.getCells();
        int colCt = this.getColsCount(cells);
        if (colCt < 1) {
            return null;
        }
        KDSCell cell = null;
        Object cellVal = null;
        cellVal = cells.getCell(0, 0, false).getValue();
        if (cellVal != null && !"\u6761\u7801".equals(cellVal.toString())) {
            logger.error((Object)" first col name must be barcode ");
            return null;
        }
        int[] colIdArr = new int[this.colNames.size() + 2];
        colIdArr[0] = 0;
        colIdArr[1] = 1;
        for (i = 2; i < colIdArr.length; ++i) {
            colIdArr[i] = -1;
        }
        int idx = 2;
        for (i = 0; i < colCt; ++i) {
            cell = cells.getCell(0, i, false);
            cellVal = cell.getValue();
            if (cellVal == null || !this.colNames.contains(cellVal.toString())) continue;
            idx = this.colNames.indexOf(cellVal.toString());
            colIdArr[idx + 2] = i;
        }
        ArrayList<Map<String, String>> dataRows = new ArrayList<Map<String, String>>();
        BarcodeExcelData parsedData = new BarcodeExcelData();
        if (this.uiConfigInfo.getBillType() != null) {
            parsedData.setBillType(this.uiConfigInfo.getBillType().getValue());
        }
        parsedData.setBarcodeMasterId(this.uiConfigInfo.getBarcodeMasterId());
        parsedData.setBarcodeSetupInfo(this.uiConfigInfo.getBarcodeSetupInfo());
        parsedData.setOrgUnitInfo(this.uiConfigInfo.getOrgUnitInfo());
        for (int i2 = 1; i2 < rowCount; ++i2) {
            HashMap<String, String> dRow = new HashMap<String, String>();
            for (int j = 0; j < colIdArr.length; ++j) {
                if (colIdArr[j] == -1) {
                    dRow.put(this.colKeys.get(j), "");
                    continue;
                }
                cell = cells.getCell(i2, colIdArr[j], false);
                cellVal = cell.getValue();
                dRow.put(this.colKeys.get(j), cellVal.toString());
            }
            dataRows.add(dRow);
        }
        parsedData.setRows(dataRows);
        return parsedData;
    }

    private int getColsCount(ICells cells) {
        int ct = 0;
        KDSCell cell = null;
        Object cellVal = null;
        boolean fHasNext = true;
        while ((cell = cells.getCell(0, ct, false)) != null && (cellVal = cell.getValue()) != null && !StringUtils.isEmpty((String)cellVal.toString())) {
            ++ct;
            if (fHasNext) continue;
        }
        return ct;
    }

    private boolean isMatchBarcodeSetup(ICells cells, int colCt) {
        return false;
    }
}

