/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.barcode.scm.BarcodeDossierCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierFactory;
import com.kingdee.eas.barcode.scm.BarcodeDossierInfo;
import com.kingdee.eas.barcode.scm.BarcodeInventoryFactory;
import com.kingdee.eas.barcode.scm.BarcodeInventoryInfo;
import com.kingdee.eas.barcode.scm.BarcodeOfDateMinFactory;
import com.kingdee.eas.barcode.scm.BarcodeOfDateMinInfo;
import com.kingdee.eas.barcode.scm.IBarcodeOfDateMin;
import com.kingdee.eas.barcode.scm.PositionFactory;
import com.kingdee.eas.barcode.scm.PositionInfo;
import com.kingdee.eas.barcode.scm.client.AbstractBarcodeInventoryEditUI;
import com.kingdee.eas.barcode.scm.client.BarcodeInventoryListUI;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class BarcodeInventoryEditUI
extends AbstractBarcodeInventoryEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BarcodeInventoryEditUI.class);
    private static boolean isFirst = false;
    private BarcodeInventoryInfo barcodeInventory = null;
    private Date inWarehouseDate = null;
    private IUIObject parentUI;

    public void onShow() throws Exception {
        if (this.getUIContext().containsKey("barodeInventoryInfo") && isFirst) {
            this.barcodeInventory = (BarcodeInventoryInfo)this.getUIContext().get("barodeInventoryInfo");
            if (this.barcodeInventory != null) {
                if (this.barcodeInventory.getMaterial() != null) {
                    MaterialInfo materiaInfo = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(this.barcodeInventory.getMaterial().getId()));
                    this.prmtMaterial.setValue((Object)materiaInfo);
                }
                this.txtLot.setText(this.barcodeInventory.getLot());
                if (this.barcodeInventory.getPosition() != null) {
                    PositionInfo positionInfo = PositionFactory.getRemoteInstance().getPositionInfo((IObjectPK)new ObjectUuidPK(this.barcodeInventory.getPosition().getId()));
                    this.prmtPosition.setValue((Object)positionInfo);
                }
                this.txtQty.setValue((Object)this.barcodeInventory.getCurStoreQty());
            }
            super.setDataObject((IObjectValue)this.barcodeInventory);
        }
        if (this.getUIContext().containsKey("inWarehouseDate")) {
            this.inWarehouseDate = (Date)this.getUIContext().get("inWarehouseDate");
        }
        super.onShow();
    }

    public void onLoad() throws Exception {
        isFirst = true;
        super.onLoad();
        this.prmtMaterial.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialBaseInfoQuery");
        this.prmtMaterial.setVisible(true);
        this.prmtMaterial.setEditable(true);
        this.prmtMaterial.setDisplayFormat("$name$");
        this.prmtMaterial.setEditFormat("$number$");
        this.prmtMaterial.setCommitFormat("$number$");
        InvClientUtils.getMaterialF7ForFilterUI((KDBizPromptBox)this.prmtMaterial, (Object)((Object)this));
        this.prmtPosition.setQueryInfo("com.kingdee.eas.barcode.scm.app.F7PositionQuery");
        this.prmtPosition.setVisible(true);
        this.prmtPosition.setEditable(true);
        this.prmtPosition.setDisplayFormat("$name$");
        this.prmtPosition.setEditFormat("$number$");
        this.prmtPosition.setCommitFormat("$number$");
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setEnabled(true);
        this.actionYes.setEnabled(true);
    }

    public IUIObject getParentUI() {
        return this.parentUI;
    }

    public void setParentUI(IUIObject parentUI) {
        this.parentUI = parentUI;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionYes_actionPerformed(ActionEvent e) throws Exception {
        super.actionYes_actionPerformed(e);
        BigDecimal oldQty = BigDecimal.ZERO;
        if (this.prmtPosition.getValue() != null) {
            PositionInfo positionInfo = (PositionInfo)this.prmtPosition.getValue();
            this.barcodeInventory.setPosition(positionInfo);
        }
        if (this.txtQty.getText() != null) {
            oldQty = this.barcodeInventory.getCurStoreQty();
            this.barcodeInventory.setCurStoreQty(this.txtQty.getBigDecimalValue());
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("lot"));
        selector.add(new SelectorItemInfo("position.id"));
        BarcodeInventoryFactory.getRemoteInstance().updatePartial(this.barcodeInventory, selector);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)this.barcodeInventory.getMaterial().getId()));
        filterInfo.getFilterItems().add(new FilterItemInfo("batchNumber", (Object)this.barcodeInventory.getLot()));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("number"));
        coll.add(new SelectorItemInfo("batchNumber"));
        coll.add(new SelectorItemInfo("material.id"));
        view.setSelector(coll);
        SorterItemCollection sorterCol = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo();
        sortInfo.setPropertyName("batchNumber");
        sortInfo.setSortType(SortType.ASCEND);
        sorterCol.add(sortInfo);
        view.setSorter(sorterCol);
        BarcodeDossierCollection barcodeCol = BarcodeDossierFactory.getRemoteInstance().getBarcodeDossierCollection(view);
        if (barcodeCol.size() > 0) {
            BarcodeDossierInfo barcodeDossierInfo = barcodeCol.get(0);
            String barcode = barcodeDossierInfo.getNumber();
            IBarcodeOfDateMin iBarcodeOfDateMin = BarcodeOfDateMinFactory.getRemoteInstance();
            BarcodeOfDateMinInfo barcodedateMinInfo = new BarcodeOfDateMinInfo();
            barcodedateMinInfo.setBarcode(barcode);
            barcodedateMinInfo.setBarcodeInventory(this.barcodeInventory);
            barcodedateMinInfo.setLot(this.barcodeInventory.getLot());
            barcodedateMinInfo.setInWarehouseDate(this.getTime());
            barcodedateMinInfo.setQty(this.txtQty.getBigDecimalValue().subtract(oldQty));
            if (barcodedateMinInfo.getQty().compareTo(BigDecimal.ONE) >= 0) {
                iBarcodeOfDateMin.save((CoreBaseInfo)barcodedateMinInfo);
            }
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("curStoreQty"));
            selector.add(new SelectorItemInfo("position"));
            BarcodeInventoryFactory.getRemoteInstance().updatePartial(this.barcodeInventory, selector);
            this.showMessageForStatus();
            ((BarcodeInventoryListUI)this.getParentUI()).refreshList();
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)"\u5bf9\u5e94\u7684\u7269\u6599+\u6279\u6b21\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u6761\u7801\uff0c\u4fdd\u5b58\u5931\u8d25\uff01");
            SysUtil.abort();
        }
    }

    private SelectorItemCollection getBarcodeOfDateMinSelect() {
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("barcode"));
        coll.add(new SelectorItemInfo("lot"));
        coll.add(new SelectorItemInfo("inWarehouseDate"));
        coll.add(new SelectorItemInfo("qty"));
        coll.add(new SelectorItemInfo("barcodeInventory.id"));
        coll.add(new SelectorItemInfo("id"));
        return coll;
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(date);
        Timestamp createtime = null;
        try {
            createtime = new Timestamp(formatter.parse(dateString).getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return createtime;
    }

    protected void showMessageForStatus() {
        this.setShowMessagePolicy(2);
        if ("EDIT".equals(this.getOprtState())) {
            this.showEdit();
        } else if ("ADDNEW".equals(this.getOprtState())) {
            this.showAddNew();
        } else {
            if (!"VIEW".equals(this.getOprtState())) {
                return;
            }
            this.showView();
        }
    }

    protected void showAddNew() {
        String msg = null;
        Object msg_Next = null;
        String res = null;
        Object res2 = null;
        Object[] objs = null;
        res = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_AddNew_New");
        objs = new Object[]{this.getClassAlise()};
        msg = MessageFormat.format(res, objs);
        this.setMessageText(msg);
        this.setIsShowTextOnly(true);
        this.showMessage();
    }

    protected void showEdit() {
        String msg = null;
        Object msg_Next = null;
        String res = null;
        Object res2 = null;
        Object[] objs = null;
        res = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Edit_New");
        objs = new Object[]{this.getClassAlise()};
        msg = MessageFormat.format("{0}\u6570\u636e\u4fdd\u5b58\u6210\u529f", objs);
        this.setMessageText(msg);
        this.setIsShowTextOnly(true);
        this.showMessage();
    }

    protected void showView() {
        String msg = null;
        Object msg_Next = null;
        String res = null;
        Object res2 = null;
        Object[] objs = null;
        res = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_View_New");
        objs = new Object[]{this.getClassAlise()};
        msg = MessageFormat.format(res, objs);
        this.setMessageText(msg);
        this.setIsShowTextOnly(true);
        this.showMessage();
    }

    protected String getClassAlise() {
        String className = FrameWorkUtils.getClassAlias((CoreBaseInfo)this.barcodeInventory);
        return className;
    }

    protected void showCopyAddNew() {
        String msg = null;
        Object msg_Next = null;
        String res = null;
        Object res2 = null;
        Object[] objs = null;
        res = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CopyNew_New");
        objs = new Object[]{this.getClassAlise()};
        msg = MessageFormat.format(res, objs);
        this.setMessageText(msg);
        this.setIsShowTextOnly(true);
        this.setShowMessagePolicy(2);
        this.showMessage();
    }

    @Override
    public void actionNo_actionPerformed(ActionEvent e) throws Exception {
        super.actionNo_actionPerformed(e);
        super.destroyWindow();
    }
}

