/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.barcode.scm.BarcodeDossierFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterEntryCollection;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterInfo;
import com.kingdee.eas.barcode.scm.PositionFactory;
import com.kingdee.eas.barcode.scm.PositionInfo;
import com.kingdee.eas.barcode.scm.PropertyTypeEnum;
import com.kingdee.eas.barcode.scm.client.AbstractBarcodeInventoryFilterUI;
import com.kingdee.eas.barcode.scm.util.BarcodeClientUtils;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class BarcodeInventoryFilterUI
extends AbstractBarcodeInventoryFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BarcodeInventoryFilterUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    protected void prmtMaster_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtMaster_dataChanged(e);
        IndBarcodeMasterInfo oldVal = (IndBarcodeMasterInfo)e.getOldValue();
        IndBarcodeMasterInfo newVal = (IndBarcodeMasterInfo)e.getNewValue();
        if (oldVal != null && newVal != null && !oldVal.getId().toString().equals(newVal.getId().toString()) || oldVal == null && newVal != null || oldVal != null && newVal == null) {
            this.initTableData(newVal);
        }
    }

    public void initTableData(IndBarcodeMasterInfo masterInfo) {
        this.kdtentrys.checkParsed();
        KDCheckBox kdtentrys_ischecked_CheckBox = new KDCheckBox();
        kdtentrys_ischecked_CheckBox.setName("kdtentrys_ischecked_CheckBox");
        KDTDefaultCellEditor kdtentrys_ischecked_editor = new KDTDefaultCellEditor((JCheckBox)kdtentrys_ischecked_CheckBox);
        this.kdtentrys.getColumn("ischecked").setEditor((ICellEditor)kdtentrys_ischecked_editor);
        this.kdtentrys.removeRows();
        if (masterInfo != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("Entry.id"));
            sic.add(new SelectorItemInfo("Entry.name"));
            sic.add(new SelectorItemInfo("Entry.type"));
            try {
                masterInfo = IndBarcodeMasterFactory.getRemoteInstance().getIndBarcodeMasterInfo((IObjectPK)new ObjectUuidPK(masterInfo.getId()), sic);
                IndBarcodeMasterEntryCollection colls = masterInfo.getEntry();
                if (colls != null && colls.size() > 0) {
                    for (int i = 0; i < colls.size(); ++i) {
                        IRow row = this.kdtentrys.addRow();
                        row.getCell("name").setValue((Object)colls.get(i).getName());
                        row.getCell("ischecked").setValue((Object)true);
                        PropertyTypeEnum type = colls.get(i).getType();
                        if (type == PropertyTypeEnum.text) {
                            row.getCell("value").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)new KDTextField()));
                        }
                        if (type == PropertyTypeEnum.bool) {
                            row.getCell("value").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
                        }
                        if (type == PropertyTypeEnum.number) {
                            row.getCell("value").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)new KDTextField()));
                        }
                        if (type == PropertyTypeEnum.date) {
                            row.getCell("value").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
                        }
                        row.getCell("type").setValue((Object)type);
                        row.getCell("id").setValue((Object)colls.get(i).getId().toString());
                    }
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
                this.handUIException(e);
            }
            catch (BOSException e) {
                e.printStackTrace();
                this.handUIException(e);
            }
        }
    }

    public Map<String, Map> getTableFilter() {
        HashMap<String, Map> m = new HashMap<String, Map>();
        int rowcount = this.kdtentrys.getRowCount();
        HashMap<String, Object> values = new HashMap<String, Object>();
        HashMap<String, PropertyTypeEnum> types = new HashMap<String, PropertyTypeEnum>();
        HashMap<String, Boolean> checkeds = new HashMap<String, Boolean>();
        for (int i = 0; i < rowcount; ++i) {
            IRow row = this.kdtentrys.getRow(i);
            String name = row.getCell("name").getValue().toString();
            String id = row.getCell("id").getValue().toString();
            Object value = row.getCell("value").getValue();
            boolean checked = (Boolean)row.getCell("ischecked").getValue();
            PropertyTypeEnum type = (PropertyTypeEnum)((Object)row.getCell("type").getValue());
            if (checked && value != null && !StringUtils.isEmpty((String)value.toString())) {
                values.put(id, value);
            }
            types.put(id, type);
            if (!checked) continue;
            checkeds.put(name, checked);
        }
        m.put("filters", values);
        m.put("types", types);
        m.put("checkeds", checkeds);
        return m;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo = super.getFilterInfo();
        this.filterInfo = new FilterInfo();
        Object o = this.prmtMaterial.getValue();
        if (o != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("material.number", (Object)((MaterialInfo)o).getNumber()));
        }
        if ((o = this.prmtWarehouse.getValue()) != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("warehouse.number", (Object)((WarehouseInfo)o).getNumber()));
        }
        if ((o = this.prmtPosition.getValue()) != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("position.number", (Object)((PositionInfo)o).getNumber()));
        }
        if ((o = this.prmtMaster.getValue()) != null) {
            Map<String, Map> tf = this.getTableFilter();
            Map values = tf.get("filters");
            Map types = tf.get("types");
            if (values.size() > 0) {
                Map m = new HashMap();
                try {
                    m = BarcodeDossierFactory.getRemoteInstance().getFilterDataByExtends(((IndBarcodeMasterInfo)o).getId().toString(), values, types, new HashMap());
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                HashSet<String> filters = new HashSet<String>();
                filters.add("none");
                filters.addAll(((Map)m.get("id2codes")).values());
                this.filterInfo.getFilterItems().add(new FilterItemInfo("barcode", filters, CompareType.INCLUDE));
            } else {
                Map m = new HashMap();
                try {
                    m = BarcodeDossierFactory.getRemoteInstance().getIdsAndTemplateIdsAndCode(((IndBarcodeMasterInfo)o).getId().toString(), null);
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                HashSet<String> filters = new HashSet<String>();
                filters.add("none");
                filters.addAll(((Map)m.get("ids_map")).values());
                this.filterInfo.getFilterItems().add(new FilterItemInfo("barcode", filters, CompareType.INCLUDE));
            }
        }
        this.filterInfo.getFilterItems().add(new FilterItemInfo("curStoreQty", (Object)BigDecimal.ZERO, CompareType.GREATER));
        return this.filterInfo;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        Object value = this.prmtMaterial.getValue();
        if (value != null) {
            cp.addCustomerParam("material.number", ((MaterialInfo)value).getNumber());
        }
        if ((value = this.pkinWarehouseDateFrom.getTimestamp()) != null) {
            cp.putDate("inWarehouseDateFrom", (Date)this.pkinWarehouseDateFrom.getTimestamp());
        }
        if ((value = this.pkinWarehouseDateFrom.getTimestamp()) != null) {
            cp.putDate("inWarehouseDateTo", (Date)this.pkinWarehouseDateTo.getTimestamp());
        }
        if ((value = this.prmtWarehouse.getValue()) != null) {
            cp.addCustomerParam("warehouse.number", ((WarehouseInfo)value).getNumber());
        }
        if (value != null) {
            cp.addCustomerParam("position.number", ((PositionInfo)value).getNumber());
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        this.clear();
        Object value = cp.getCustomerParam("material.number");
        if (value != null && !value.equals("")) {
            try {
                MaterialInfo materialInfo = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(((MaterialInfo)value).getId()));
                this.prmtMaterial.setValue((Object)materialInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((value = cp.getDate("inWarehouseDateFrom")) != null && !value.equals("")) {
            this.pkinWarehouseDateFrom.setValue(value);
        }
        if ((value = cp.getDate("inWarehouseDateTo")) != null && !value.equals("")) {
            this.pkinWarehouseDateTo.setValue(value);
        }
        if ((value = cp.getCustomerParam("warehouse.number")) != null && !value.equals("")) {
            try {
                WarehouseInfo warehouseInfo = WarehouseFactory.getRemoteInstance().getWarehouseInfo((IObjectPK)new ObjectUuidPK(((WarehouseInfo)value).getId()));
                this.prmtWarehouse.setValue((Object)warehouseInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((value = cp.getCustomerParam("position.number")) != null && !value.equals("")) {
            try {
                PositionInfo positionInfo = PositionFactory.getRemoteInstance().getPositionInfo((IObjectPK)new ObjectUuidPK(((PositionInfo)value).getId()));
                this.prmtWarehouse.setValue((Object)positionInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public RequestContext prepareSetCustomerParams(CustomerParams cp) {
        return super.prepareSetCustomerParams(cp);
    }

    public RequestContext prepareGetCustomerParams() {
        return super.prepareGetCustomerParams();
    }

    public boolean verify() {
        Object value = this.prmtMaster.getValue();
        if (null == value) {
            MsgBox.showWarning((String)"\u6761\u7801\u6863\u6848\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        Timestamp beginDate = this.pkinWarehouseDateFrom.getTimestamp();
        Timestamp toDate = this.pkinWarehouseDateTo.getTimestamp();
        if (beginDate != null && toDate != null && beginDate.after((Date)toDate)) {
            MsgBox.showInfo((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("dateBefore"));
            return false;
        }
        return true;
    }
}

