/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.barcode.scm.BarcodeConfigCollection;
import com.kingdee.eas.barcode.scm.BarcodeConfigFactory;
import com.kingdee.eas.barcode.scm.BarcodeConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeConfigXML;
import com.kingdee.eas.barcode.scm.BarcodeConfigXMLDetail;
import com.kingdee.eas.barcode.scm.BarcodeConfigXMLProperty;
import com.kingdee.eas.barcode.scm.BarcodeDefaultSolutionInfo;
import com.kingdee.eas.barcode.scm.BarcodePDAConfigPropertiesEventUtil;
import com.kingdee.eas.barcode.scm.BarcodePDAConfigXmlUntil;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigEntryCollection;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigFactory;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.BarcodeXMLHelper;
import com.kingdee.eas.barcode.scm.ConsleTypeEnum;
import com.kingdee.eas.barcode.scm.DynamicMenuTypeEnum;
import com.kingdee.eas.barcode.scm.client.AbstractBarcodePDAViewConfigEditUI;
import com.kingdee.eas.barcode.scm.client.BarcodePDAViewConfigListUI;
import com.kingdee.eas.barcode.scm.util.BarcodeClientUtils;
import com.kingdee.eas.base.form.ide.utils.EntityObjectInfoHelp;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.EnumUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class BarcodePDAViewConfigEditUI
extends AbstractBarcodePDAViewConfigEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BarcodePDAViewConfigEditUI.class);
    private Map uiContext = this.getUIContext();
    protected BarcodeConfigInfo entity;
    private BarcodeConfigXML xmlInfo = null;
    private Object[] menuType = null;
    private Map<String, String> enumMap = new HashMap<String, String>();
    private String bosStr = null;
    private BarcodePDAViewConfigEntryCollection cachCol = new BarcodePDAViewConfigEntryCollection();

    protected void initWorkButton() {
        super.initWorkButton();
        this.conMenuType.setEditable(false);
        this.conMenuType.setEnabled(false);
        this.scanConfig.setEditable(false);
        this.scanConfig.setEnabled(false);
        this.defaultSolution.setRequired(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initColumnAttr();
        this.initDatas();
        this.scanConfig.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    BarcodePDAViewConfigEditUI.this.scanConfig_dataChanged(e);
                }
                catch (Exception e1) {
                    BarcodePDAViewConfigEditUI.this.handUIException(e1);
                }
            }
        });
    }

    @Override
    public void loadFields() {
        this.tblMain.checkParsed();
        BarcodePDAConfigXmlUntil.sortTable(this.editData.getEntitys());
        super.loadFields();
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row.getCell("columnCode").getValue() == null || !"sourceBillNum".equalsIgnoreCase(row.getCell("columnCode").getValue().toString()) && !"barcode".equalsIgnoreCase(row.getCell("columnCode").getValue().toString())) continue;
            row.getStyleAttributes().setLocked(true);
            row.getCell("ScanSeq").getStyleAttributes().setLocked(false);
            row.getCell("isView").getStyleAttributes().setLocked(false);
            row.getCell("isListView").getStyleAttributes().setLocked(false);
            row.getCell("isEdit").getStyleAttributes().setLocked(false);
            row.getCell("pdaTitle").getStyleAttributes().setLocked(false);
        }
    }

    private void loadConfigXmlObject() {
        String configXmlStr;
        if (this.entity != null && (configXmlStr = this.entity.getDetailsXML()) != null && !"".equals(configXmlStr)) {
            this.xmlInfo = BarcodeXMLHelper.toBarcodeConfigXML(configXmlStr);
        }
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        if (e.getValue() != null && e.getValue().equals(e.getOldValue()) || e.getValue() == null && e.getOldValue() == null) {
            return;
        }
        int selectRow = e.getRowIndex();
        int selectCol = e.getColIndex();
        KDTable kDTable = (KDTable)e.getSource();
        String colName = kDTable.getColumnKey(e.getColIndex());
    }

    private void initDatas() {
        BarcodeConfigCollection col = null;
        try {
            col = BarcodePDAViewConfigListUI.getBarcodeConfigCollectionIsPda();
            if (col != null && col.size() > 0) {
                for (int i = 0; i < col.size(); ++i) {
                    BarcodeConfigInfo binfo = col.get(i);
                    String desBosType = binfo.getDestBosType();
                    EntityObjectInfo entry = BarcodeUtils.getEntityByBosType(desBosType);
                    this.enumMap.put(desBosType, entry.getAlias());
                }
            }
        }
        catch (BOSException i) {
            // empty catch block
        }
        if (this.oprtState.equals("ADDNEW")) {
            this.entity = (BarcodeConfigInfo)this.uiContext.get("barcodeConfigInfo");
            EntityObjectInfo einfo = (EntityObjectInfo)this.uiContext.get("businessObj");
            if (einfo != null) {
                this.bosStr = einfo.getType().toString();
            }
        } else {
            this.entity = this.editData.getScanConfig();
            if (this.editData.getScanConfig() != null) {
                this.bosStr = this.editData.getScanConfig().getDestBosType();
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("destBosType", (Object)this.bosStr);
        view.setFilter(filter);
        this.scanConfig.setEntityViewInfo(view);
        EntityViewInfo view1 = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        if (this.entity != null) {
            filter1.appendFilterItem("barcodeConfig.id", (Object)this.entity.getId().toString());
        }
        view1.setFilter(filter1);
        this.defaultSolution.setEntityViewInfo(view1);
        if (this.uiContext.get("enumMap") != null) {
            this.enumMap = (HashMap)this.uiContext.get("enumMap");
        }
        int i = 0;
        DynamicMenuTypeEnum selectedObj = null;
        if (this.enumMap != null && this.enumMap.size() > 0) {
            this.menuType = new Object[this.enumMap.size()];
            for (Map.Entry<String, String> entry : this.enumMap.entrySet()) {
                String pName = "bosTypeStr";
                String name = entry.getKey();
                String value = entry.getValue();
                DynamicMenuTypeEnum dm = new DynamicMenuTypeEnum(value, pName, name);
                this.menuType[i] = dm;
                if (name.equals(this.bosStr)) {
                    selectedObj = dm;
                }
                ++i;
            }
            this.conMenuType.removeAllItems();
            this.conMenuType.addItems(this.menuType);
            this.conMenuType.setSelectedItem(selectedObj);
        }
        if (this.entity != null) {
            this.scanConfig.setValue((Object)this.entity);
        }
    }

    private void initColumnAttr() {
        this.tblMain.checkParsed();
        KDCheckBox tblMain_pipei_CheckBox = new KDCheckBox();
        tblMain_pipei_CheckBox.setName("tblMain_pipei_CheckBox");
        KDTDefaultCellEditor tblMain_pipei_CellEditor = new KDTDefaultCellEditor((JCheckBox)tblMain_pipei_CheckBox);
        this.tblMain.getColumn("isView").setEditor((ICellEditor)tblMain_pipei_CellEditor);
        KDCheckBox tblMain_isListView_CheckBox = new KDCheckBox();
        tblMain_pipei_CheckBox.setName("tblMain_isListView_CheckBox");
        KDTDefaultCellEditor tblMain_isListView_CellEditor = new KDTDefaultCellEditor((JCheckBox)tblMain_isListView_CheckBox);
        this.tblMain.getColumn("isListView").setEditor((ICellEditor)tblMain_isListView_CellEditor);
        KDComboBox kb = new KDComboBox();
        kb.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.barcode.scm.ConsleTypeEnum").toArray());
        this.tblMain.getColumn("consleType").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)kb));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        this.initDatas();
        this.loadConfigXmlObject();
        BarcodePDAViewConfigInfo objectValue = new BarcodePDAViewConfigInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        if (this.uiContext.get("businessObj") != null) {
            EntityObjectInfo eo = (EntityObjectInfo)this.uiContext.get("businessObj");
            String a = eo.getType().toString();
            objectValue.setMenuType(eo.getType().toString());
            BarcodeConfigInfo barcodeConfigInfo = (BarcodeConfigInfo)this.uiContext.get("barcodeConfigInfo");
            objectValue.setScanConfig((BarcodeConfigInfo)this.uiContext.get("barcodeConfigInfo"));
            objectValue.setCU(barcodeConfigInfo.getCU());
            objectValue.setTableName(eo.getTable().getName());
        }
        BarcodePDAViewConfigEntryCollection col = this.loadEntryData();
        objectValue.getEntitys().addCollection(col);
        return objectValue;
    }

    private BarcodePDAViewConfigEntryCollection loadEntryData() {
        BarcodePDAViewConfigEntryCollection col = new BarcodePDAViewConfigEntryCollection();
        BarcodePDAViewConfigEntryInfo entry = null;
        int indexSeq = 0;
        entry = new BarcodePDAViewConfigEntryInfo();
        entry.setName(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource", (String)"sourceBilleNumName"));
        entry.setColumnType(BarcodeClientUtils.getBarcodeResource("Test"));
        entry.setPdaTitle(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource", (String)"sourceBilleNumName"));
        entry.setIsView(true);
        entry.setIsListView(false);
        entry.setConsleType(ConsleTypeEnum.getEnum("CheckBox"));
        entry.setScanSeq(col.size() + 1);
        entry.setColumnCode("sourceBillNum");
        entry.setEntryType(0);
        entry.setProEventStr(BarcodePDAConfigPropertiesEventUtil.getEventStr("number"));
        entry.setSpecialColStr("");
        entry.setIsEdit(true);
        entry.setParentBosTypeStr(this.bosStr);
        entry.setEntryName("");
        col.add(entry);
        entry = new BarcodePDAViewConfigEntryInfo();
        entry.setName(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource", (String)"barCodeScanCol"));
        entry.setColumnType(BarcodeClientUtils.getBarcodeResource("Test"));
        entry.setPdaTitle(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource", (String)"barCodeScanCol"));
        entry.setIsView(true);
        entry.setIsListView(false);
        entry.setConsleType(ConsleTypeEnum.getEnum("CheckBox"));
        entry.setScanSeq(col.size() + 1);
        entry.setColumnCode("barcode");
        entry.setEntryType(1);
        entry.setProEventStr(BarcodePDAConfigPropertiesEventUtil.getEventStr("barcode"));
        entry.setSpecialColStr("");
        entry.setIsEdit(true);
        entry.setParentBosTypeStr(this.bosStr);
        entry.setEntryName("");
        EntityObjectInfo parentEo = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)this.bosStr));
        if (this.bosStr.equals("4409E7F0") || this.bosStr.equals("42AC39EC")) {
            entry.setFiledName("fnumber");
            entry.setTableName(parentEo.getTable().getName());
        } else {
            entry.setFiledName(null);
            entry.setTableName(null);
        }
        col.add(entry);
        entry = new BarcodePDAViewConfigEntryInfo();
        entry.setName(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource", (String)"PCS"));
        entry.setColumnType(BarcodeClientUtils.getBarcodeResource("Test"));
        entry.setPdaTitle(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource", (String)"PCS"));
        entry.setIsView(true);
        entry.setIsListView(false);
        entry.setConsleType(ConsleTypeEnum.getEnum("CheckBox"));
        entry.setScanSeq(col.size() + 1);
        entry.setColumnCode("PCS");
        entry.setEntryType(1);
        entry.setProEventStr(BarcodePDAConfigPropertiesEventUtil.getEventStr(""));
        entry.setSpecialColStr("PCS");
        entry.setIsEdit(true);
        entry.setParentBosTypeStr(this.bosStr);
        entry.setEntryName("");
        col.add(entry);
        if (this.xmlInfo != null) {
            List<BarcodeConfigXMLDetail> deXml = this.xmlInfo.getDetails();
            int entryNum = 0;
            for (int i = 0; i < deXml.size(); ++i) {
                List<BarcodeConfigXMLProperty> pXml = deXml.get(i).getProperties();
                String bosType = deXml.get(i).getBosType();
                String parBosType = deXml.get(i).getParentBosType();
                String entryName = "";
                if (parBosType != null && !parBosType.equals("")) {
                    ++entryNum;
                    entryName = deXml.get(i).getName();
                }
                if ("BA8AD747".equals(bosType)) {
                    ++entryNum;
                }
                if ("42AC39EC".equals(parBosType)) {
                    entryNum = 0;
                }
                if (entryNum > 0) {
                    entryNum = 1;
                }
                EntityObjectInfo eo = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)bosType));
                for (int j = 0; j < pXml.size(); ++j) {
                    BarcodeConfigXMLProperty bcp = pXml.get(j);
                    boolean isHandShow = bcp.isHandShow();
                    if (!isHandShow) continue;
                    this.loadConfigField(bcp, entryNum, bosType, parBosType, entryName, col, indexSeq++, eo);
                }
                if (pXml.size() <= 0) continue;
                entry = new BarcodePDAViewConfigEntryInfo();
                entry.setName("fid");
                entry.setColumnType(BarcodeClientUtils.getBarcodeResource("Test"));
                entry.setPdaTitle("fid");
                entry.setIsView(false);
                entry.setIsListView(false);
                entry.setConsleType(ConsleTypeEnum.getEnum("CheckBox"));
                entry.setColumnCode("fid");
                entry.setEntryType(entryNum);
                entry.setProEventStr(BarcodePDAConfigPropertiesEventUtil.getEventStr(""));
                entry.setSpecialColStr("");
                entry.setIsEdit(false);
                entry.setBosTypeStr(bosType);
                entry.setParentBosTypeStr(parBosType);
                entry.setEntryName("");
                this.cachCol.add(entry);
                if (parBosType == null || parBosType.equals("")) continue;
                entry.setBosTypeStr(entryName + "_" + bosType);
                entry = new BarcodePDAViewConfigEntryInfo();
                entry.setName(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource", (String)"fsrcBillId"));
                entry.setColumnType(BarcodeClientUtils.getBarcodeResource("Test"));
                entry.setPdaTitle(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource", (String)"fsrcBillId"));
                entry.setIsView(false);
                entry.setIsListView(false);
                entry.setConsleType(ConsleTypeEnum.getEnum("CheckBox"));
                entry.setColumnCode("fsrcBillId");
                entry.setEntryType(entryNum);
                entry.setProEventStr(BarcodePDAConfigPropertiesEventUtil.getEventStr(""));
                entry.setSpecialColStr("");
                entry.setIsEdit(false);
                entry.setBosTypeStr(entryName + "_" + bosType);
                entry.setParentBosTypeStr(parBosType);
                entry.setEntryName("");
                this.cachCol.add(entry);
                entry = new BarcodePDAViewConfigEntryInfo();
                entry.setName(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource", (String)"fsrcEntryId"));
                entry.setColumnType(BarcodeClientUtils.getBarcodeResource("Test"));
                entry.setPdaTitle(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource", (String)"fsrcEntryId"));
                entry.setIsView(false);
                entry.setIsListView(false);
                entry.setConsleType(ConsleTypeEnum.getEnum("CheckBox"));
                entry.setColumnCode("fsrcEntryId");
                entry.setEntryType(entryNum);
                entry.setProEventStr(BarcodePDAConfigPropertiesEventUtil.getEventStr(""));
                entry.setSpecialColStr("");
                entry.setIsEdit(false);
                entry.setBosTypeStr(entryName + "_" + bosType);
                entry.setParentBosTypeStr(parBosType);
                entry.setEntryName("");
                this.cachCol.add(entry);
            }
        }
        return col;
    }

    private void loadConfigField(BarcodeConfigXMLProperty bcp, int entryNum, String bosType, String parBosType, String entryName, BarcodePDAViewConfigEntryCollection col, int indexSeq, EntityObjectInfo eo) {
        String typeName = bcp.getDataType();
        String proBosType = bcp.getLinkedBosType();
        boolean isLink = bcp.isLinkedProperty();
        String value = null;
        String proEventStr = "";
        boolean isFull = true;
        String spacialCol = "";
        boolean isMatiarial = true;
        BarcodePDAViewConfigEntryInfo entry = null;
        String a = bcp.getAlias();
        if (isLink && proBosType != null) {
            isFull = false;
            EntityObjectInfo eoi = BarcodeUtils.getEntityByBosType(proBosType);
            if ("com.kingdee.eas.basedata.scm.common.app.BizType".equals(eoi.getFullName())) {
                proEventStr = BarcodePDAConfigPropertiesEventUtil.getEventStr("bizType");
            } else if ("com.kingdee.eas.basedata.master.cssp.app.Supplier".equals(eoi.getFullName())) {
                proEventStr = BarcodePDAConfigPropertiesEventUtil.getEventStr("supplier");
            } else if ("com.kingdee.eas.basedata.scm.im.inv.app.Warehouse".equals(eoi.getFullName())) {
                proEventStr = BarcodePDAConfigPropertiesEventUtil.getEventStr("warehouse");
                spacialCol = "warehouse";
            } else if ("com.kingdee.eas.basedata.scm.im.inv.app.Location".equals(eoi.getFullName())) {
                proEventStr = BarcodePDAConfigPropertiesEventUtil.getEventStr("location");
                spacialCol = "location";
            } else if ("com.kingdee.eas.basedata.master.material.app.Material".equals(eoi.getFullName())) {
                spacialCol = "Material";
                isMatiarial = false;
            } else if ("com.kingdee.eas.basedata.master.material.app.AsstAttrValue".equals(eoi.getFullName())) {
                proEventStr = BarcodePDAConfigPropertiesEventUtil.getEventStr("asstAttrValue");
                spacialCol = "Assist";
            } else if ("com.kingdee.eas.basedata.scm.common.app.TransactionType".equals(eoi.getFullName())) {
                spacialCol = "transcationType";
            } else if ("com.kingdee.eas.basedata.master.cssp.app.Customer".equals(eoi.getFullName())) {
                proEventStr = BarcodePDAConfigPropertiesEventUtil.getEventStr("customer");
            } else if ("com.kingdee.eas.basedata.org.app.StorageOrgUnit".equals(eoi.getFullName())) {
                spacialCol = "storageOrgUnit";
                proEventStr = BarcodePDAConfigPropertiesEventUtil.getEventStr("baseData");
            } else if ("com.kingdee.eas.basedata.org.app.AdminOrgUnit".equals(eoi.getFullName())) {
                if ("useDept".equals(bcp.getName())) {
                    spacialCol = "useDept";
                }
                if ("adminDept".equals(bcp.getName())) {
                    spacialCol = "adminDept";
                }
                proEventStr = BarcodePDAConfigPropertiesEventUtil.getEventStr("baseData");
            } else {
                proEventStr = BarcodePDAConfigPropertiesEventUtil.getEventStr("baseData");
            }
        }
        if (typeName != null && "BigDecimal".equals(typeName)) {
            value = BarcodeClientUtils.getBarcodeResource("Values");
        } else if (typeName != null && "Boolean".equals(typeName)) {
            value = BarcodeClientUtils.getBarcodeResource("Values");
        } else if (typeName != null && ("Date".equals(typeName) || "TimeStamp".equals(typeName))) {
            value = BarcodeClientUtils.getBarcodeResource("Date");
            if ("mfg".equalsIgnoreCase(bcp.getName())) {
                spacialCol = "mfg";
                proEventStr = BarcodePDAConfigPropertiesEventUtil.getEventStr("date");
            }
            if ("exp".equalsIgnoreCase(bcp.getName())) {
                spacialCol = "exp";
            }
        } else {
            value = BarcodeClientUtils.getBarcodeResource("Test");
        }
        if (bcp.isScanQty()) {
            proEventStr = BarcodePDAConfigPropertiesEventUtil.getEventStr("amount");
            spacialCol = "Qty";
            entry = new BarcodePDAViewConfigEntryInfo();
            entry.setName(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource", (String)"sourceNum"));
            entry.setColumnType(BarcodeClientUtils.getBarcodeResource("Test"));
            entry.setPdaTitle(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource", (String)"sourceNum"));
            entry.setIsView(false);
            entry.setIsListView(false);
            entry.setConsleType(ConsleTypeEnum.getEnum("CheckBox"));
            entry.setColumnCode("fsrcQty");
            entry.setEntryType(entryNum);
            entry.setProEventStr(BarcodePDAConfigPropertiesEventUtil.getEventStr(""));
            entry.setSpecialColStr("");
            entry.setIsEdit(false);
            entry.setBosTypeStr(bosType);
            entry.setParentBosTypeStr(parBosType);
            entry.setEntryName("");
            entry.setTableName(eo.getTable().getName());
            if (!"BA8AD747".equals(bosType)) {
                this.cachCol.add(entry);
            }
        }
        if (proEventStr.equals("")) {
            proEventStr = BarcodePDAConfigPropertiesEventUtil.getEventStr("");
        }
        entry = new BarcodePDAViewConfigEntryInfo();
        entry.setName(bcp.getAlias());
        entry.setColumnType(value);
        entry.setPdaTitle(bcp.getAlias());
        entry.setIsView(isMatiarial);
        entry.setIsListView(true);
        entry.setConsleType(ConsleTypeEnum.getEnum("CheckBox"));
        entry.setScanSeq(col.size() + 1);
        entry.setColumnCode(isFull ? bcp.getFullName() : bcp.getName() + "_number");
        entry.setEntryType(entryNum);
        entry.setProEventStr(proEventStr);
        entry.setSpecialColStr(spacialCol);
        entry.setIsEdit(isMatiarial);
        entry.setBosTypeStr(bosType);
        entry.setParentBosTypeStr(parBosType);
        entry.setEntryName(entryName);
        entry.setFullName(isFull ? bcp.getFullName() : bcp.getFullName() + ".number");
        String fieldName = eo.getPropertyByName(bcp.getName()).getMappingField().getName();
        entry.setFiledName(fieldName);
        entry.setTableName(eo.getTable().getName());
        String tableName = null;
        if (!isFull) {
            EntityObjectInfo linkEntity = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)bcp.getLinkedBosType()));
            tableName = linkEntity.getTable().getName();
            entry.setLinkTableName(tableName);
        }
        col.add(entry);
        if (!isFull) {
            entry = new BarcodePDAViewConfigEntryInfo();
            entry.setName(bcp.getAlias());
            entry.setColumnType(BarcodeClientUtils.getBarcodeResource("Test"));
            entry.setPdaTitle(bcp.getAlias() + "\u540d\u79f0");
            entry.setIsView(false);
            entry.setIsListView(true);
            entry.setConsleType(ConsleTypeEnum.getEnum("CheckBox"));
            entry.setColumnCode(isFull ? bcp.getFullName() : bcp.getName() + "_name");
            entry.setEntryType(entryNum);
            entry.setProEventStr(BarcodePDAConfigPropertiesEventUtil.getEventStr(""));
            entry.setSpecialColStr("");
            entry.setIsEdit(false);
            entry.setBosTypeStr(bosType);
            entry.setParentBosTypeStr(parBosType);
            entry.setEntryName(entryName);
            entry.setScanSeq(col.size() + 1);
            col.add(entry);
            entry.setFiledName(fieldName);
            entry.setTableName(eo.getTable().getName());
            entry.setLinkTableName(tableName);
            entry.setFullName(isFull ? bcp.getFullName() : bcp.getFullName() + ".name");
            if ("Material".equals(spacialCol)) {
                entry = new BarcodePDAViewConfigEntryInfo();
                entry.setName(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource", (String)"model"));
                entry.setColumnType(BarcodeClientUtils.getBarcodeResource("Test"));
                entry.setPdaTitle(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource", (String)"model"));
                entry.setIsView(false);
                entry.setIsListView(true);
                entry.setConsleType(ConsleTypeEnum.getEnum("CheckBox"));
                entry.setScanSeq(col.size() + 1);
                entry.setColumnCode("material_model");
                entry.setEntryType(1);
                entry.setProEventStr(BarcodePDAConfigPropertiesEventUtil.getEventStr(""));
                entry.setSpecialColStr("");
                entry.setIsEdit(false);
                entry.setBosTypeStr(bosType);
                entry.setParentBosTypeStr(parBosType);
                entry.setEntryName("");
                entry.setFiledName(fieldName);
                entry.setTableName(eo.getTable().getName());
                entry.setLinkTableName(tableName);
                entry.setFullName(bcp.getFullName() + ".model");
                col.add(entry);
            }
        }
        if (bcp.isScanQty()) {
            entry = new BarcodePDAViewConfigEntryInfo();
            entry.setName(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource", (String)"diffNum"));
            entry.setColumnType(BarcodeClientUtils.getBarcodeResource("Test"));
            entry.setPdaTitle(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource", (String)"diffNum"));
            entry.setIsView(false);
            entry.setIsListView(true);
            entry.setConsleType(ConsleTypeEnum.getEnum("CheckBox"));
            entry.setColumnCode("fdifQty");
            entry.setEntryType(entryNum);
            entry.setProEventStr(BarcodePDAConfigPropertiesEventUtil.getEventStr(""));
            entry.setSpecialColStr("");
            entry.setIsEdit(false);
            entry.setBosTypeStr(bosType);
            entry.setParentBosTypeStr(parBosType);
            entry.setEntryName("");
            if (!"BA8AD747".equals(bosType)) {
                this.cachCol.add(entry);
            }
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BarcodePDAViewConfigFactory.getRemoteInstance();
    }

    protected void beforeStoreFields(ActionEvent arg0) throws Exception {
        super.beforeStoreFields(arg0);
        if (this.scanConfig.getText() == null || this.scanConfig.getText().trim().equals("")) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource", (String)"scanConfig_is_null"));
            this.abort();
        }
        this.editData.setMenuType(this.bosStr);
        int n = this.tblMain.getRowCount();
        ArrayList<String> arr = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            Object num = this.tblMain.getRow(i).getCell("ScanSeq").getValue();
            if (num == null || !BarcodePDAConfigXmlUntil.isInt(num.toString()) || arr.indexOf(num.toString()) != -1 || Integer.valueOf(num.toString()) < 0) {
                MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource", (String)"info_row_scanSeq") + (i + 1)));
                this.abort();
            }
            arr.add(num.toString());
        }
        String cacheXml = this.editData.getCacheXml();
        if (cacheXml == null || "".equals(cacheXml)) {
            cacheXml = BarcodePDAConfigXmlUntil.getSpecialColXml(this.cachCol);
        }
        BarcodePDAViewConfigInfo bio = new BarcodePDAViewConfigInfo();
        BarcodePDAViewConfigEntryCollection bcoll = new BarcodePDAViewConfigEntryCollection();
        this.editData.setXmlFileName(this.entity.getNumber() + ".xml");
        String xml = "";
        try {
            bio.setScanConfig(BarcodeConfigFactory.getRemoteInstance().getBarcodeConfigInfo((IObjectPK)new ObjectUuidPK(this.editData.getScanConfig().getId())));
            bio.setDefualtSolution((BarcodeDefaultSolutionInfo)this.defaultSolution.getData());
            if (this.tblMain.getRowCount() > 0) {
                for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                    BarcodePDAViewConfigEntryInfo bi = new BarcodePDAViewConfigEntryInfo();
                    IRow row = this.tblMain.getRow(i);
                    String fullName = (String)row.getCell("name").getValue();
                    String pdaName = (String)row.getCell("pdaTitle").getValue();
                    String colType = (String)row.getCell("objType").getValue();
                    ConsleTypeEnum conType = (ConsleTypeEnum)((Object)row.getCell("consleType").getValue());
                    String scanSeq = row.getCell("ScanSeq").getValue().toString();
                    boolean colView = (Boolean)row.getCell("isView").getValue();
                    boolean colListView = (Boolean)row.getCell("isListView").getValue();
                    String colCode = (String)row.getCell("columnCode").getValue();
                    String proEvent = (String)row.getCell("proEventStr").getValue();
                    boolean isEdit = (Boolean)row.getCell("isEdit").getValue();
                    boolean isSetDefault = (Boolean)row.getCell("isSetDefault").getValue();
                    String bosType = (String)row.getCell("bosType").getValue();
                    String parentBosType = (String)row.getCell("parentBosType").getValue();
                    String entryType = row.getCell("entryType").getValue().toString();
                    String specialColMark = (String)row.getCell("specialColMark").getValue();
                    String entryName = (String)row.getCell("entryName").getValue();
                    String tableName = row.getCell("tableName").getValue() != null ? row.getCell("tableName").getValue().toString() : null;
                    String filedName = row.getCell("filedName").getValue() != null ? row.getCell("filedName").getValue().toString() : null;
                    String linkTableName = (String)row.getCell("linkTableName").getValue() != null ? row.getCell("linkTableName").getValue().toString() : null;
                    String fullNameFilte = (String)row.getCell("fullName").getValue() != null ? row.getCell("fullName").getValue().toString() : null;
                    bi.setName(fullName);
                    bi.setPdaTitle(pdaName);
                    bi.setColumnType(colType);
                    bi.setConsleType(conType);
                    bi.setScanSeq(Integer.valueOf(scanSeq));
                    bi.setIsView(colView);
                    bi.setIsListView(colListView);
                    bi.setColumnCode(colCode);
                    bi.setProEventStr(proEvent);
                    bi.setIsEdit(isEdit);
                    bi.setIsSetDefault(isSetDefault);
                    bi.setBosTypeStr(bosType);
                    bi.setParentBosTypeStr(parentBosType);
                    bi.setEntryType(Integer.valueOf(entryType));
                    bi.setSpecialColStr(specialColMark);
                    bi.setEntryName(entryName);
                    bi.setTableName(tableName);
                    bi.setFiledName(filedName);
                    bi.setLinkTableName(linkTableName);
                    bi.setFullName(fullNameFilte);
                    bcoll.add(bi);
                }
            }
            bio.getEntitys().addCollection(bcoll);
            String x = this.editData.getXmlByteData();
            xml = BarcodePDAConfigXmlUntil.getPdaMenuItemXml(bio, cacheXml);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        this.editData.setCacheXml(cacheXml);
        this.editData.setXmlByteData(xml);
    }

    protected void scanConfig_dataChanged(DataChangeEvent e) throws Exception {
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("scanConfig.*"));
        sic.add(new SelectorItemInfo("scanConfig.isMatchBill"));
        sic.add(new SelectorItemInfo("scanConfig.completeCheck"));
        sic.add(new SelectorItemInfo("scanConfig.isWholeScan"));
        sic.add(new SelectorItemInfo("entitys.fullName"));
        return sic;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent arg0) throws Exception {
        super.actionEdit_actionPerformed(arg0);
    }
}

