/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.barcode.scm.BarcodeConfigCollection;
import com.kingdee.eas.barcode.scm.BarcodeConfigFactory;
import com.kingdee.eas.barcode.scm.BarcodeConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigCollection;
import com.kingdee.eas.barcode.scm.BarcodePDAViewConfigFactory;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.OrgUnitUtils;
import com.kingdee.eas.barcode.scm.client.AbstractBarcodePDAViewConfigListUI;
import com.kingdee.eas.barcode.scm.client.BarcodePDAViewConfigEditUI;
import com.kingdee.eas.barcode.scm.client.FABarcodeUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUIController;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BarcodePDAViewConfigListUI
extends AbstractBarcodePDAViewConfigListUI {
    private static final Logger logger = CoreUIObject.getLogger(BarcodePDAViewConfigListUI.class);
    private HashMap<String, String> enumMap = new HashMap();
    private String permissionCuStr = "";
    private int curIndex = -1;

    protected ICoreBase getBizInterface() throws Exception {
        return BarcodePDAViewConfigFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return BarcodePDAViewConfigEditUI.class.getName();
    }

    public void onLoad() throws Exception {
        FABarcodeUtils.requestLicenseOrReleaseLicense(this.getUIContext(), true, (CoreUI)this);
        super.onLoad();
        this.initTree();
        this.tblMain.getColumn("menuName").setSortable(false);
        this.kDTree1.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    BarcodePDAViewConfigListUI.this.treeSelectionChanged(e);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        OrgUnitCollection coll = OrgUnitUtils.getAuthOrgByPermItem(null, OrgType.ControlUnit, "BarcodePDAView_View");
        this.permissionCuStr = OrgUnitUtils.toStringList(coll, "number");
    }

    private void treeSelectionChanged(TreeSelectionEvent e) throws Exception {
        this.kDTree1.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.refreshQueryData();
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.kDTree1.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void refreshQueryData() throws Exception {
        EntityViewInfo evi;
        this.mainQuery = evi = new EntityViewInfo();
        this.filterData();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        FilterInfo mergfilter = new FilterInfo();
        mergfilter.getFilterItems().add(new FilterItemInfo("cu.number", (Object)this.permissionCuStr, CompareType.INCLUDE));
        try {
            if (viewInfo.getFilter() == null) {
                viewInfo.setFilter(mergfilter);
            } else {
                viewInfo.getFilter().mergeFilter(mergfilter, "and");
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        IQueryExecutor exe = super.getQueryExecutor(queryPK, viewInfo);
        return exe;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    private void filterData() throws Exception {
        FilterInfo filter = new FilterInfo();
        String strBizObj = "";
        ArrayList<String> bizObjs = new ArrayList<String>();
        ArrayList boList = this.getTreeBOList();
        if (boList == null) {
            return;
        }
        StringBuffer strBizObjs = new StringBuffer("");
        for (int i = 0; i < boList.size(); ++i) {
            BarcodeConfigInfo uo = (BarcodeConfigInfo)boList.get(i);
            strBizObj = uo.getId().toString();
            if (strBizObjs.length() > 0) {
                strBizObjs.append(",");
            }
            strBizObjs.append(strBizObj);
            bizObjs.add(strBizObj);
        }
        FilterItemInfo fi = new FilterItemInfo("scanConfig.id", (Object)strBizObjs.toString(), CompareType.INCLUDE);
        filter.getFilterItems().add(fi);
        this.mainQuery.setFilter(filter);
        this.refreshKDTable(this.tblMain);
    }

    protected void refreshKDTable(KDTable table) {
        this.saveCurrentLocation(table);
        table.removeRows();
        this.restoreCurrentLocation(table);
    }

    protected void restoreCurrentLocation(KDTable table) {
        if (table.getRow(this.curIndex) != null) {
            table.getSelectManager().select(this.curIndex, 0);
        }
    }

    protected void saveCurrentLocation(KDTable table) {
        KDTSelectBlock selectBlock = table.getSelectManager().get();
        this.curIndex = selectBlock != null ? selectBlock.getTop() : 0;
    }

    private ArrayList getTreeBOList() {
        KDTree tree = this.kDTree1;
        DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)tree.getLastSelectedPathComponent();
        ArrayList list = null;
        if (selectedNode != null) {
            list = this.getBOList(selectedNode);
        } else {
            logger.debug((Object)"tree event:No select Leaf Node!");
        }
        return list;
    }

    private ArrayList getBOList(DefaultKingdeeTreeNode root) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (root.isLeaf()) {
            list.add(root.getUserObject());
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                if (root.getChildAt(i).isLeaf()) {
                    Object childrenNode = ((DefaultKingdeeTreeNode)root.getChildAt(i)).getUserObject();
                    list.add(childrenNode);
                    continue;
                }
                list.addAll(this.getBOList((DefaultKingdeeTreeNode)root.getChildAt(i)));
            }
        }
        return list;
    }

    private void initTree() throws Exception {
        int i;
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)this.getResource("rootMenu"));
        DefaultKingdeeTreeNode parent = new DefaultKingdeeTreeNode((Object)this.getResource("washRoom"));
        root.add((MutableTreeNode)parent);
        BarcodeConfigCollection col = BarcodePDAViewConfigListUI.getBarcodeConfigCollectionIsPda();
        ArrayList<String> bosTypes = new ArrayList<String>();
        HashMap<String, EntityObjectInfo> bosMaps = new HashMap<String, EntityObjectInfo>();
        if (col != null && col.size() > 0) {
            for (i = 0; i < col.size(); ++i) {
                BarcodeConfigInfo binfo = col.get(i);
                String desBosType = binfo.getDestBosType();
                EntityObjectInfo entry = BarcodeUtils.getEntityByBosType(desBosType);
                if (bosTypes.indexOf(desBosType) != -1) continue;
                bosTypes.add(desBosType);
                bosMaps.put(desBosType, entry);
                this.enumMap.put(desBosType, entry.getAlias());
            }
        }
        for (i = 0; i < bosTypes.size(); ++i) {
            String bosString = (String)bosTypes.get(i);
            DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode(bosMaps.get(bosString));
            child.setText(((EntityObjectInfo)bosMaps.get(bosString)).getAlias() + this.getResource("scan"));
            for (int j = 0; j < col.size(); ++j) {
                BarcodeConfigInfo binfo = col.get(j);
                String bosString2 = binfo.getDestBosType();
                if (!bosString2.equals(bosString)) continue;
                child.add((MutableTreeNode)new DefaultKingdeeTreeNode((Object)binfo));
            }
            parent.add((MutableTreeNode)child);
        }
        this.kDTree1.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        this.kDTree1.setSelectionRow(0);
        this.kDTree1.expandAllNodes(true, (TreeNode)root);
    }

    public static BarcodeConfigCollection getBarcodeConfigCollectionIsPda() throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("isPDA", (Object)true);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        String selectorAll = System.getProperty("selector.all");
        if (StringUtils.isEmpty((String)selectorAll)) {
            selectorAll = "true";
        }
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("srcBosType"));
        sic.add(new SelectorItemInfo("destBosType"));
        sic.add(new SelectorItemInfo("srcAlias"));
        sic.add(new SelectorItemInfo("destAlias"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("botMapping.alias"));
        sic.add(new SelectorItemInfo("botMapping.name"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("detailsXML"));
        sic.add(new SelectorItemInfo("botMapping.id"));
        sic.add(new SelectorItemInfo("botMapping.name"));
        sic.add(new SelectorItemInfo("botMapping.number"));
        sic.add(new SelectorItemInfo("isPDA"));
        view.setSelector(sic);
        view.setFilter(filter);
        BarcodeConfigCollection col = BarcodeConfigFactory.getRemoteInstance().getBarcodeConfigCollection(view);
        return col;
    }

    private String getResource(String sName) {
        return EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource", (String)sName);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.showDetailWindows(e);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void showDetailWindows(ActionEvent e) throws Exception {
        UIContext hm = new UIContext((Object)this);
        BarcodeConfigInfo eo = null;
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.kDTree1.getLastSelectedPathComponent();
        if (node == null) {
            MsgBox.showInfo((String)this.getResource("Msg_SelectObject"));
            return;
        }
        Object obj = node.getUserObject();
        if (!(obj instanceof BarcodeConfigInfo)) {
            MsgBox.showInfo((String)this.getResource("Msg_SelectObjeoct"));
            return;
        }
        BarcodeConfigInfo uo = (BarcodeConfigInfo)obj;
        if (uo.isEmpty()) {
            MsgBox.showInfo((String)this.getResource("Msg_SelectObject"));
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("scanConfig.id", (Object)uo.getId());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        BarcodePDAViewConfigCollection col = BarcodePDAViewConfigFactory.getRemoteInstance().getBarcodePDAViewConfigCollection(view);
        if (col != null && col.size() > 0) {
            MsgBox.showInfo((String)this.getResource("has_menuitem"));
            return;
        }
        eo = uo;
        hm.put((Object)"businessObj", ((DefaultKingdeeTreeNode)node.getParent()).getUserObject());
        hm.put((Object)"barcodeConfigInfo", (Object)eo);
        hm.put((Object)"enumMap", this.enumMap);
        this.prepareUIContext(hm, e);
        this.getUIContext().putAll(hm);
        IUIWindow uiWindow = null;
        ((ListUIController)super.getUIController()).actionAddNew();
        this.refresh(e);
        this.setPreSelecteRow();
        uiWindow = ((ListUIController)super.getUIController()).getNavigator().getUIWindow();
        Window win = SwingUtilities.getWindowAncestor((Component)uiWindow.getUIObject());
        if (!win.isActive() && win instanceof JFrame && ((JFrame)win).getExtendedState() == 1) {
            ((JFrame)win).setExtendedState(0);
        }
        if (uiWindow == null || !this.isDoRefresh(uiWindow)) {
            return;
        }
        if (UtilRequest.isPrepare((String)"ActionRefresh", (CoreUIObject)this)) {
            this.prepareRefresh(null).callHandler();
        }
        this.refresh(e);
        this.setPreSelecteRow();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.initTree();
        super.actionRefresh_actionPerformed(e);
    }

    protected boolean initDefaultFilter() {
        return false;
    }
}

