/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BarcodePrintConfig {
    private static final Logger logger = Logger.getLogger(BarcodePrintConfig.class);
    private static final String PROP_FILE = "barcode.properties";
    private static final String PROP_PREV_TEMPLATE = "prevTemplate_";
    private static final String PROP_TEMPLATE_DIR = "templateDir_";
    private static final String FILE_SUF = ".lab";
    private File selectedDir = null;
    private String selectedTmpl = null;
    private String userNum = null;
    public static final FileFilter TEMPLATE_FILTER = new SimpleFileFilter("lab");

    public BarcodePrintConfig(String userNum) {
        this.userNum = userNum;
        this.loadSavedTemplateDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSavedTemplateDir() {
        FileInputStream is = null;
        Properties prop = new Properties();
        try {
            is = new FileInputStream(PROP_FILE);
            prop.load(is);
            String dir = prop.getProperty(PROP_TEMPLATE_DIR + this.userNum);
            String tmpl = prop.getProperty(PROP_PREV_TEMPLATE + this.userNum);
            if (StringUtils.isEmpty((String)dir)) {
                return;
            }
            File fileDir = new File(dir);
            if (fileDir.exists()) {
                File tmplFile;
                this.selectedDir = fileDir;
                if (!StringUtils.isEmpty((String)tmpl) && (tmplFile = new File(dir + File.separator + tmpl + FILE_SUF)).exists()) {
                    this.selectedTmpl = tmpl;
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)("cannot find barcode property file!!" + e.getMessage()));
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public File getTemplateDir() {
        return this.selectedDir;
    }

    public String getSelectedTemplate() {
        return this.selectedTmpl;
    }

    public File getTemplateFile(File fDir, String templName) {
        File selFile = null;
        String fStr = this.getTemplateFileStr(fDir, templName);
        if (fStr != null) {
            selFile = new File(fStr);
        }
        return selFile;
    }

    public String getTemplateFileStr(File fDir, String templName) {
        String selFile = null;
        String fName = templName;
        if (templName != null && !templName.toLowerCase(Locale.ENGLISH).endsWith(FILE_SUF)) {
            fName = templName + FILE_SUF;
        }
        if (fDir != null && templName != null) {
            selFile = fDir + File.separator + fName;
        } else if (fDir == null) {
            selFile = fName;
        }
        return selFile;
    }

    public void saveTemplate(File selectedTmpl) {
        if (selectedTmpl != null && selectedTmpl.isFile()) {
            String name = selectedTmpl.getName();
            int idx = name.toLowerCase().lastIndexOf(FILE_SUF);
            logger.debug((Object)(" selectedTemplate : " + selectedTmpl));
            if (idx > 0) {
                name = name.substring(0, idx);
                File templDir = selectedTmpl.getParentFile();
                this.saveTemplate(templDir, name);
            } else {
                logger.debug((Object)" selectedTemplate is not a .lab file ");
            }
        } else {
            this.saveTemplate(selectedTmpl, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTemplate(File fdir, String selTmpl) {
        if (fdir == null || !fdir.exists()) {
            return;
        }
        FileOutputStream os = null;
        Properties prop = new Properties();
        try {
            os = new FileOutputStream(PROP_FILE);
            String sDir = prop.getProperty(PROP_TEMPLATE_DIR + this.userNum);
            if (sDir == null || !fdir.getAbsolutePath().equals(sDir)) {
                prop.put(PROP_TEMPLATE_DIR + this.userNum, fdir.getAbsolutePath());
                this.selectedDir = fdir;
            }
            String preFile = prop.getProperty(PROP_PREV_TEMPLATE + this.userNum);
            if (!(selTmpl == null || preFile != null && selTmpl.equals(preFile))) {
                prop.put(PROP_PREV_TEMPLATE + this.userNum, selTmpl);
                this.selectedTmpl = selTmpl;
            }
            prop.store(os, null);
            logger.info((Object)("save template dir: " + fdir + ", " + selTmpl));
        }
        catch (IOException e) {
            logger.error((Object)("cannot write barcode property file!!" + e.getMessage()));
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public ComboBoxModel getTemplatesComboModel(File selectedDir) {
        if (selectedDir == null) {
            return null;
        }
        File[] files = selectedDir.listFiles();
        if (files == null || files.length == 0) {
            return null;
        }
        boolean fContainsSel = false;
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < files.length; ++i) {
            String name = files[i].getName();
            String lowName = name.toLowerCase(Locale.ENGLISH);
            if (!lowName.endsWith(FILE_SUF)) continue;
            int idx = lowName.lastIndexOf(FILE_SUF);
            name = name.substring(0, idx);
            logger.debug((Object)("template file " + name));
            names.add(name);
            if (fContainsSel || !name.equals(this.selectedTmpl)) continue;
            fContainsSel = true;
        }
        Object[] nameArr = names.toArray();
        DefaultComboBoxModel<Object> comboModel = new DefaultComboBoxModel<Object>(nameArr);
        if (this.selectedTmpl != null && fContainsSel) {
            comboModel.setSelectedItem(this.selectedTmpl);
        }
        return comboModel;
    }
}

