/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.util.BosHelper;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.barcode.scm.BarcodePrintBillTypeEnum;
import com.kingdee.eas.barcode.scm.IndBarCodeCountMsgCollection;
import com.kingdee.eas.barcode.scm.IndBarCodeCountMsgFactory;
import com.kingdee.eas.barcode.scm.IndBarCodeCountMsgInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.scm.im.inv.LotFrame;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleFactory;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BarcodePrintHelper {
    private static final String[] colNames = new String[]{"id", "entry.id"};

    public static String[] getTableColNames(KDTable tbl) {
        int ct = tbl.getColumnCount();
        String[] colNames = new String[ct - 1];
        int j = 0;
        for (int i = 0; i < ct; ++i) {
            String colKey = tbl.getColumnKey(i);
            if ("select".equals(colKey) || "barcodeCount".equals(colKey)) continue;
            colNames[j++] = colKey;
        }
        return colNames;
    }

    public static void loadSelectedData(List selBills, KDTable tblBill, BarcodePrintBillTypeEnum billType) {
        String[] colNames = BarcodePrintHelper.getTableColNames(tblBill);
        Map rowData = null;
        IRow row = null;
        String key = null;
        int n = selBills.size();
        for (int i = 0; i < n; ++i) {
            rowData = (Map)selBills.get(i);
            row = tblBill.addRow();
            BarcodePrintHelper.setCellValue(row.getCell("select"), Boolean.FALSE);
            BarcodePrintHelper.setCellValue(row.getCell("barcodeCount"), Integer.decode("1"));
            BarcodePrintHelper.setCellValue(row.getCell("billType"), billType.getAlias());
            for (int j = 0; j < colNames.length; ++j) {
                key = colNames[j];
                BarcodePrintHelper.setCellValue(row.getCell(key), rowData.get(key));
            }
        }
    }

    public static void setCellValue(ICell cell, Object val) {
        if (val != null && cell != null) {
            cell.setValue(val);
        }
    }

    public static void setCellValue(IRow row, String key, Object val) {
        ICell cell = row.getCell(key);
        if (val != null && cell != null) {
            if (val instanceof BigDecimal) {
                BigDecimal amtVal = (BigDecimal)val;
                cell.setValue((Object)amtVal);
            } else {
                cell.setValue(val);
            }
        }
    }

    public static void setAssistPropertyCellStyle(final IRow row, String key, MaterialInfo materialInfo, IUIObject uiObject) {
        if (key == null) {
            return;
        }
        final ICell cell = row.getCell(key);
        if (cell.getValue() != null || "".equals(cell.getValue())) {
            return;
        }
        if (materialInfo.getId() != null) {
            try {
                materialInfo = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()));
                if (materialInfo.getAssistAttr() != null) {
                    KDBizPromptBox prmtAssistProperty = new KDBizPromptBox();
                    SCMClientUtils.setAsstAttrInputF7((KDBizPromptBox)prmtAssistProperty, (MaterialInfo)materialInfo, (IUIObject)uiObject);
                    prmtAssistProperty.setDisplayFormat("$name$");
                    cell.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtAssistProperty));
                    cell.getStyleAttributes().setLocked(false);
                    prmtAssistProperty.addDataChangeListener(new DataChangeListener(){

                        public void dataChanged(DataChangeEvent e) {
                            try {
                                Object value = e.getNewValue();
                                if (value instanceof AsstAttrValueInfo) {
                                    AsstAttrValueInfo valueInfo = (AsstAttrValueInfo)value;
                                    cell.setValue((Object)valueInfo.getName());
                                    if (row.getCell("assistID") != null) {
                                        row.getCell("assistID").setValue((Object)valueInfo.getId().toString());
                                    }
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                } else {
                    cell.getStyleAttributes().setLocked(true);
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    public static void setLotCellStyle(IRow row, String key, MaterialInfo materialInfo, String orgId, IUIObject uiObject) {
        if (key == null) {
            return;
        }
        ICell cell = row.getCell(key);
        if (cell == null || cell.getValue() != null || "".equals(cell.getValue())) {
            return;
        }
        if (materialInfo.getId() != null && orgId != null) {
            try {
                LinkedList<LotFrame> lotFrameList = new LinkedList<LotFrame>();
                LotFrame lotFrame = new LotFrame();
                lotFrame.setSeq(row.getRowIndex());
                lotFrame.setMainBizOrg(orgId);
                lotFrame.setMaterial(materialInfo.getId().toString());
                lotFrameList.add(lotFrame);
                List retLotFrameList = LotRuleFactory.getRemoteInstance().fillLotFrames(lotFrameList);
                for (LotFrame lf : retLotFrameList) {
                    if (lf == null) continue;
                    long currentSerial = BarcodePrintHelper.getSerialNumber(lf, materialInfo.getId().toString());
                    lf.setCurrentSerial(currentSerial);
                    row.getCell("lot").setValue((Object)lf.getLotNumber());
                    if (lf.getLotRule() == null) continue;
                    if (lf.getLotRule().isIsModifiable()) {
                        cell.getStyleAttributes().setLocked(false);
                        continue;
                    }
                    cell.getStyleAttributes().setLocked(true);
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    protected static long getSerialNumber(LotFrame lotFrame, String materialID) {
        if (lotFrame == null) {
            return 0L;
        }
        LotRuleInfo lotRult = lotFrame.getLotRule();
        String lotRuleAssign = lotFrame.getLotRuleAssign();
        long serialNumber = 0L;
        try {
            serialNumber = LotRuleFactory.getRemoteInstance().fillSerialNumber(materialID, lotRult, lotRuleAssign);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serialNumber;
    }

    public static IndBarCodeCountMsgInfo updateBarcodeCount(IRow row, EntityObjectInfo entity) {
        String billID = null;
        billID = !"1D0D80DD".equalsIgnoreCase(entity.getType().toString()) ? row.getCell("entry.id").getValue().toString() : row.getCell("id").getValue().toString();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("billId"));
        sic.add(new SelectorItemInfo("totalCount"));
        sic.add(new SelectorItemInfo("counted"));
        sic.add(new SelectorItemInfo("unCount"));
        view.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billId", (Object)billID));
        view.setFilter(filterInfo);
        try {
            IndBarCodeCountMsgCollection barcodeCountMsgCol = IndBarCodeCountMsgFactory.getRemoteInstance().getIndBarCodeCountMsgCollection(view);
            if (barcodeCountMsgCol.size() > 0) {
                return barcodeCountMsgCol.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static List getSelectedRows(KDTable tblMain, String[] billCols) {
        ArrayList<Map<String, Object>> selRows = null;
        IRow row = null;
        Map<String, Object> rowData = null;
        ArrayList selBlocks = tblMain.getSelectManager().getBlocks();
        if (selBlocks != null && selBlocks.size() > 0) {
            selRows = new ArrayList<Map<String, Object>>();
            KDTSelectBlock block = null;
            int n = selBlocks.size();
            for (int i = 0; i < n; ++i) {
                int iEndRow;
                block = (KDTSelectBlock)selBlocks.get(i);
                int iBeginRow = block.getBeginRow();
                if (iBeginRow == (iEndRow = block.getEndRow())) {
                    row = tblMain.getRow(iBeginRow);
                    rowData = BarcodePrintHelper.getBillMap(row, billCols);
                    selRows.add(rowData);
                    continue;
                }
                for (int j = iBeginRow; j <= iEndRow; ++j) {
                    row = tblMain.getRow(j);
                    rowData = BarcodePrintHelper.getBillMap(row, billCols);
                    selRows.add(rowData);
                }
            }
        }
        return selRows;
    }

    public static Map<String, Object> getBillMap(IRow row, String[] billCols) {
        HashMap<String, Object> rowData = new HashMap<String, Object>();
        for (int i = 0; i < billCols.length; ++i) {
            String key = billCols[i];
            ICell cell = row.getCell(key);
            if (cell == null || cell.getValue() == null) continue;
            rowData.put(key, cell.getValue());
        }
        return rowData;
    }

    public static List getSelectedRows(KDTable tblMain) {
        return BarcodePrintHelper.getSelectedRows(tblMain, colNames);
    }

    public static Map getSelectedIdsMap(KDTable tblMain, String entryIdCol) {
        if (tblMain == null) {
            return null;
        }
        IRow row = null;
        HashMap idsMap = new HashMap();
        KDTSelectManager sm = tblMain.getSelectManager();
        int blockCount = sm.size();
        int keyField = tblMain.getColumnIndex(entryIdCol);
        String id = null;
        String eId = null;
        Object value = null;
        for (int i = 0; i < blockCount; ++i) {
            KDTSelectBlock block = sm.get(i);
            int bottom = block.getBottom();
            for (int j = block.getTop(); j <= bottom; ++j) {
                Set<String> eSet;
                row = tblMain.getRow(j);
                if (row == null) continue;
                value = row.getCell(keyField).getValue();
                ICell cell = row.getCell("id");
                if (cell.getValue() != null) {
                    id = cell.getValue().toString();
                }
                if (value == null || id == null || value.toString().trim().length() == 0) continue;
                eId = value.toString();
                if (!idsMap.containsKey(id)) {
                    eSet = new HashSet<String>();
                    eSet.add(eId);
                    idsMap.put(id, eSet);
                    continue;
                }
                eSet = (Set)idsMap.get(id);
                eSet.add(eId);
            }
        }
        return idsMap;
    }

    public static String getSelectedNumbers(KDTable tblMain, String entryIdCol) {
        if (tblMain == null) {
            return null;
        }
        IRow row = null;
        StringBuffer numberStr = new StringBuffer();
        HashMap<String, String> numbersMap = new HashMap<String, String>();
        KDTSelectManager sm = tblMain.getSelectManager();
        int blockCount = sm.size();
        int keyField = tblMain.getColumnIndex(entryIdCol);
        String number = null;
        Object value = null;
        for (int i = 0; i < blockCount; ++i) {
            KDTSelectBlock block = sm.get(i);
            int bottom = block.getBottom();
            for (int j = block.getTop(); j <= bottom; ++j) {
                row = tblMain.getRow(j);
                if (row == null || (value = row.getCell(keyField).getValue()) == null || value.toString().trim().length() == 0 || numbersMap.containsKey(number = value.toString())) continue;
                numbersMap.put(number, number);
                if (numberStr.length() > 0) {
                    numberStr.append(",").append(number);
                    continue;
                }
                numberStr.append(number);
            }
        }
        return numberStr.toString();
    }

    private static void addToMap(Map<String, Set<String>> idsMap, IRow row, String entryIdCol) {
        ICell eCell;
        String id = null;
        String eId = null;
        ICell cell = row.getCell("id");
        if (cell.getValue() != null) {
            id = cell.getValue().toString();
        }
        if ((eCell = row.getCell(entryIdCol)) != null && eCell.getValue() != null) {
            eId = eCell.getValue().toString();
        }
        if (id != null && eId != null) {
            if (!idsMap.containsKey(id)) {
                HashSet<String> eSet = new HashSet<String>();
                eSet.add(eId);
                idsMap.put(id, eSet);
            } else {
                Set<String> eSet = idsMap.get(id);
                eSet.add(eId);
            }
        }
    }

    public static void showUIMsg(CoreUI ui, String msg) {
        ui.setMessageText(msg);
        ui.showMessage();
    }

    public static void setPropertyCellStyles(IRow row, String index, String prop, String fullName) throws BOSException {
        final ICell cell = row.getCell(index);
        if (cell == null || StringUtils.isEmpty((String)fullName)) {
            return;
        }
        final String props = prop;
        String format = "$" + prop + "$";
        KDBizPromptBox prmtPersion = new KDBizPromptBox();
        prmtPersion.setDisplayFormat(format);
        prmtPersion.setCommitFormat(format);
        prmtPersion.setEditFormat(format);
        String[] stc = fullName.split("\\.");
        String fullNames = stc[stc.length - 1].replaceAll("Info", "");
        Object in = null;
        String easfullNames = "";
        for (int i = 0; stc.length > i; ++i) {
            easfullNames = stc.length - 1 == i ? easfullNames + "app." : easfullNames + stc[i] + ".";
        }
        String query = easfullNames + fullNames;
        String F7query = easfullNames + "F7" + fullNames;
        if (BosHelper.getQueryInfo((MetaDataPK)new MetaDataPK(query + "Query")) != null) {
            prmtPersion.setQueryInfo(query + "Query");
        } else if (BosHelper.getQueryInfo((MetaDataPK)new MetaDataPK(F7query + "Query")) != null) {
            prmtPersion.setQueryInfo(F7query + "Query");
        } else {
            return;
        }
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtPersion));
        cell.getStyleAttributes().setLocked(false);
        prmtPersion.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    Object value = e.getNewValue();
                    if (value instanceof IObjectValue) {
                        IObjectValue valueInfo = (IObjectValue)value;
                        if (valueInfo.get(props) != null) {
                            cell.setValue(valueInfo.get(props));
                        } else {
                            cell.setValue(null);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

