/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDFilterTextField;
import com.kingdee.bos.ctrl.swing.KDNumberTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.scm.BarcodeBillCustColInfo;
import com.kingdee.eas.barcode.scm.BarcodeBillUIConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeDossierCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierEntryCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodeDossierFactory;
import com.kingdee.eas.barcode.scm.BarcodeDossierInfo;
import com.kingdee.eas.barcode.scm.BarcodeExcelData;
import com.kingdee.eas.barcode.scm.BarcodeFacadeFactory;
import com.kingdee.eas.barcode.scm.BarcodeGenResult;
import com.kingdee.eas.barcode.scm.BarcodeGenerateParamInfo;
import com.kingdee.eas.barcode.scm.BarcodeGenerateParams;
import com.kingdee.eas.barcode.scm.BarcodePrintBillTypeEnum;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.IBarcodeFacade;
import com.kingdee.eas.barcode.scm.IndBarCodeCountMsgCollection;
import com.kingdee.eas.barcode.scm.IndBarCodeCountMsgFactory;
import com.kingdee.eas.barcode.scm.IndBarCodeCountMsgInfo;
import com.kingdee.eas.barcode.scm.IndBarcodeRuleFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeRuleInfo;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupCollection;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupInfo;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetCollection;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetFactory;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetInfo;
import com.kingdee.eas.barcode.scm.client.AbstractBarcodePrintUI;
import com.kingdee.eas.barcode.scm.client.BarCodeBDPrint;
import com.kingdee.eas.barcode.scm.client.BarCodePrintParam;
import com.kingdee.eas.barcode.scm.client.BarcodeExcelParser;
import com.kingdee.eas.barcode.scm.client.BarcodePrintConfig;
import com.kingdee.eas.barcode.scm.client.BarcodePrintHelper;
import com.kingdee.eas.barcode.scm.client.FABarcodeUtils;
import com.kingdee.eas.barcode.scm.client.IBarcodeBillSelectUI;
import com.kingdee.eas.barcode.scm.client.SelectEntityUI;
import com.kingdee.eas.barcode.scm.util.BarcodeClientUtils;
import com.kingdee.eas.barcode.scm.util.BarcodeDataProvider;
import com.kingdee.eas.barcode.scm.util.BarcodePrintListener;
import com.kingdee.eas.base.form.ide.utils.EntityObjectInfoHelp;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.TimeUnitEnum;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DataBase;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.config.client.ConfigServiceUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BarcodePrintUI
extends AbstractBarcodePrintUI {
    private static final Logger logger = CoreUIObject.getLogger(BarcodePrintUI.class);
    private static final FileFilter EXCEL_FILTER = new SimpleFileFilter(new String[]{"xlsx", "xls"});
    private static final int displNum = Integer.parseInt("1");
    private static final int displBool = Integer.parseInt("3");
    private KDTDefaultCellEditor tblChkEditor = null;
    private boolean fBillToBarcode = false;
    private boolean fBarcodePrint = false;
    private File selectedDir = null;
    private String selectedTmpl = null;
    private String userNum = null;
    private List<String> custCols = null;
    private Map<String, List<String>> headKeyMap = null;
    private BarcodeBillUIConfigInfo currUIConfig = null;
    private BarcodeExcelParser excelParser = null;
    private File selectedImportFile = null;
    private BarcodePrintConfig printConfig = null;
    protected EntityObjectInfo entity;
    protected String entryProperty = "";
    private final Color balckColor = new Color(252, 251, 223);
    private String arriKey = "";
    private String baseUnitStr = null;
    private String materialNumberStr = null;
    private String qtyStr = null;
    private String qtyPack = null;
    private String mgf = null;
    private String exp = null;
    private String materialCode = null;
    private Map<String, EntityObjectInfo> entryEntityObjectMap = null;
    private Map<Integer, String> rowColIndexMap = new LinkedHashMap<Integer, String>();
    private Boolean isSaveBarcode = true;
    private Boolean isBaseData = false;
    private IMetaDataPK mainQueryPK = null;
    private KDTEditListener kDTEditListener = null;
    private ItemListener itemListener = null;
    private final int billCustInd = 9;
    private final int barCustInd = 6;
    private String defaultBosType;
    private String defaultIndBarcodeSetup;
    private String defaultRule;
    private IndubarodeParamsetInfo indubarodeParamsetInfo = null;

    public void onLoad() throws Exception {
        FABarcodeUtils.requestLicenseOrReleaseLicense(this.getUIContext(), true, this);
        super.onLoad();
        this.chkIsSave.setSelected(true);
        this.chkPrintBillNum.setVisible(false);
        SysContext sysCtx = SysContext.getSysContext();
        if (sysCtx != null && sysCtx.getCurrentUserInfo() != null) {
            this.userNum = sysCtx.getCurrentUserInfo().getNumber();
        }
        this.initCtrls();
        this.actionTemplateDir.setVisible(false);
        this.actionBarcodePrint.setVisible(false);
        this.defaultBosType = ConfigServiceUtils.getUserConfigData((String)"defaultEntity", (CoreUI)this);
        this.defaultIndBarcodeSetup = ConfigServiceUtils.getUserConfigData((String)"defaultIndBarcodeSetup", (CoreUI)this);
        this.defaultRule = ConfigServiceUtils.getUserConfigData((String)"defaultRule", (CoreUI)this);
        this.setDefaultValue();
        this.indubarodeParamsetInfo = this.getParamsetInfo();
    }

    public IndubarodeParamsetInfo getParamsetInfo() {
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            String selectorAll = System.getProperty("selector.all");
            if (StringUtils.isEmpty((String)selectorAll)) {
                selectorAll = "true";
            }
            sic.add(new SelectorItemInfo("indBarcode"));
            sic.add(new SelectorItemInfo("priorBusiness"));
            sic.add(new SelectorItemInfo("businessBarcode"));
            sic.add(new SelectorItemInfo("priorInd"));
            sic.add(new SelectorItemInfo("barcodeInv"));
            sic.add(new SelectorItemInfo("barcodeLot"));
            sic.add(new SelectorItemInfo("description"));
            sic.add(new SelectorItemInfo("status"));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setSelector(sic);
            IndubarodeParamsetCollection paramCol = IndubarodeParamsetFactory.getRemoteInstance().getIndubarodeParamsetCollection(viewInfo);
            if (paramCol.size() > 0) {
                return paramCol.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return new IndubarodeParamsetInfo();
    }

    protected void checkTableParsed() {
        this.tblBill.checkParsed();
        this.tblBarcode.checkParsed();
    }

    private void initCtrls() throws Exception {
        this.prmtEntity.setSelector((KDPromptSelector)new KDPromptBox.DefaultSelector());
        this.prmtEntity.setReadOnly(false);
        this.prmtEntity.setEditable(true);
        this.prmtEntity.setRequired(true);
        this.prmtEntity.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    BarcodePrintUI.this.actionEntityF7_actionPerformed(null);
                }
                catch (Exception e1) {
                    BarcodePrintUI.this.handleException(e1);
                }
            }
        });
        this.prmtEntity.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    BarcodePrintUI.this.prmtEntity_dataChanged(e);
                    BarcodePrintUI.this.tblBill.setRefresh(true);
                    BarcodePrintUI.this.tblBill.repaint();
                    BarcodePrintUI.this.tblBarcode.setRefresh(true);
                    BarcodePrintUI.this.tblBarcode.repaint();
                }
                catch (Exception e1) {
                    BarcodePrintUI.this.handleException(e1);
                }
            }
        });
        this.itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                BarcodePrintUI.this.chkIsSave_addItemListener(e);
            }
        };
        this.chkIsSave.addItemListener(this.itemListener);
        ArrayList<BarcodePrintBillTypeEnum> billTypes = new ArrayList<BarcodePrintBillTypeEnum>();
        billTypes.add(BarcodePrintBillTypeEnum.PurOrder);
        billTypes.add(BarcodePrintBillTypeEnum.PurInWarehs);
        billTypes.add(BarcodePrintBillTypeEnum.SaleIssue);
        billTypes.add(BarcodePrintBillTypeEnum.MaterialReq);
        billTypes.add(BarcodePrintBillTypeEnum.MaterialRequest);
        billTypes.add(BarcodePrintBillTypeEnum.StockTransfer);
        Object[] billTypeArr = billTypes.toArray();
        DefaultComboBoxModel<Object> comboModel = new DefaultComboBoxModel<Object>(billTypeArr);
        this.comboBillType.setModel(comboModel);
        this.setPrmptRuleFilter();
        this.printConfig = new BarcodePrintConfig(this.userNum);
        this.selectedDir = this.printConfig.getTemplateDir();
        this.selectedTmpl = this.printConfig.getSelectedTemplate();
        this.loadPrintTemplates(this.selectedDir);
        this.numPrintCt.setValue((Object)new Integer(1));
        logger.debug((Object)("tblBill colCount " + this.tblBill.getColumnCount()));
        logger.debug((Object)("tblBill colCount " + this.tblBarcode.getColumnCount()));
        this.initActions();
        this.tblBarcode.setRefresh(false);
        this.tblBill.setRefresh(false);
        this.setColEditorColStatus();
        this.resetTable(this.tblBill, 9);
        this.resetTable(this.tblBarcode, 6);
        this.tblBill.getSelectManager().setSelectMode(2);
        this.tblBarcode.getSelectManager().setSelectMode(10);
        this.initCustColumns();
        this.tblBill.getColumn("barcodeCount").getStyleAttributes().setBackground(this.balckColor);
        this.tblBill.getColumn("billType").getStyleAttributes().setHided(false);
        this.tblBill.getColumn("billNum").getStyleAttributes().setHided(false);
        this.tblBill.setRefresh(true);
        this.tblBarcode.setRefresh(true);
        this.tblBill.repaint();
        this.tblBarcode.repaint();
        this.btnSelectBills.setText(BarcodeClientUtils.getBarcodeResource("obejctSelect"));
        this.actionSelectBills.setEnabled(false);
        this.actionTemplateDir.setVisible(true);
        this.actionBarcodePrint.setVisible(true);
        this.setFilterIndBarcodeSetup();
        this.prmtStorageOrgUnit.setValue((Object)SysContext.getSysContext().getCurrentStorageUnit());
        this.deleteAndAddkDTEditListener();
    }

    private void setFilterIndBarcodeSetup() {
        if (this.entity == null) {
            this.prmtIndBarcodeSetup.setEnabled(false);
        } else {
            this.prmtIndBarcodeSetup.setEnabled(true);
        }
        this.prmtIndBarcodeSetup.setQueryInfo("com.kingdee.eas.barcode.scm.app.F7IndBarcodeSetupQuery");
        this.prmtIndBarcodeSetup.setEnabledMultiSelection(false);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.entity != null) {
            filter.getFilterItems().add(new FilterItemInfo("businessObjectID", (Object)this.entity.getType().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("businessObjectID", (Object)"???"));
        }
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1"));
        ev.setFilter(filter);
        this.prmtIndBarcodeSetup.setEntityViewInfo(ev);
        this.prmtIndBarcodeSetup.setValue(null);
    }

    public void chkIsSave_addItemListener(ItemEvent e) {
        int index;
        if (!this.chkIsSave.isSelected() && (index = MsgBox.showConfirm2((String)BarcodeClientUtils.getBarcodeResource("isSaveBarcode"))) == 0) {
            this.chkIsSave.removeItemListener(this.itemListener);
            this.chkIsSave.setSelected(false);
            this.chkIsSave.addItemListener(this.itemListener);
        }
        this.isSaveBarcode = this.chkIsSave.isSelected();
    }

    public void actionEntityF7_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("selectBizType", "application");
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SelectEntityUI.class.getName(), (Map)uiContext);
        }
        catch (UIException e1) {
            e1.printStackTrace();
            this.handleException((Exception)((Object)e1));
        }
        SelectEntityUI ui = (SelectEntityUI)uiWindow.getUIObject();
        uiWindow.show();
        if (ui.getReturnObject() != null) {
            this.entity = (EntityObjectInfo)ui.getReturnObject();
        }
        if (this.entity != null) {
            Object o = null;
            try {
                logger.info((Object)("className:" + this.entity.getBusinessImplName()));
                if (this.entity.getBusinessImplName() != null) {
                    o = Class.forName(this.entity.getBusinessImplName()).newInstance();
                    this.isBaseData = o instanceof DataBase;
                }
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
            this.prmtEntity.setText(this.entity.getAlias());
        } else {
            this.entity = null;
        }
    }

    public void prmtEntity_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() == null && e.getOldValue() != null) {
            this.prmtEntity.setText(null);
        }
        this.changeColAttr();
        this.dataChanged(e);
    }

    private void changeColAttr() {
        if (this.isBaseData.booleanValue()) {
            this.tblBill.getColumn("billType").getStyleAttributes().setHided(false);
            this.tblBill.getColumn("billNum").getStyleAttributes().setHided(false);
        } else {
            this.tblBill.getColumn("billType").getStyleAttributes().setHided(false);
            this.tblBill.getColumn("billNum").getStyleAttributes().setHided(false);
        }
    }

    @Override
    protected void prmtIndBarcodeSetup_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() != null) {
            int action;
            if (!this.fBillToBarcode && this.tblBill.getRowCount() > 0 && (action = MsgBox.showConfirm3((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("isClearData"))) != 0) {
                SysUtil.abort();
            }
            this.resetTable(this.tblBill, 9);
            if (!this.fBarcodePrint && this.tblBarcode.getRowCount() > 0 && (action = MsgBox.showConfirm3((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("isClearBarcode"))) != 0) {
                SysUtil.abort();
            }
            this.resetTable(this.tblBarcode, 6);
            this.initCustColumns();
            this.deleteAndAddkDTEditListener();
            this.regfeshTable();
        }
    }

    private void dataChanged(DataChangeEvent e) {
        int action;
        if (!this.fBillToBarcode && this.tblBill.getRowCount() > 0 && (action = MsgBox.showConfirm3((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("isClearData"))) != 0) {
            SysUtil.abort();
        }
        if (!this.fBarcodePrint && this.tblBarcode.getRowCount() > 0 && (action = MsgBox.showConfirm3((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("isClearBarcode"))) != 0) {
            SysUtil.abort();
        }
        try {
            this.resetTable(this.tblBill, 9);
            this.resetTable(this.tblBarcode, 6);
            this.setPrmptRuleFilter();
            this.setFilterIndBarcodeSetup();
            this.setDefaultData();
        }
        catch (ParserException e1) {
            e1.printStackTrace();
        }
    }

    private void setDefaultData() {
        if (this.entity == null) {
            return;
        }
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("master.*");
        sic.add("master.Entry.*");
        sic.add("Entry.*");
        sic.add("Entry.property.*");
        ev.setSelector(sic);
        BOSObjectType bosType = this.entity.getType();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("businessObjectID", (Object)bosType.toString()));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1"));
        ev.setFilter(filter);
        try {
            IndBarcodeSetupCollection setupCol = IndBarcodeSetupFactory.getRemoteInstance().getIndBarcodeSetupCollection(ev);
            IndBarcodeSetupInfo setupInfo = null;
            if (setupInfo != null && setupCol.size() == 1) {
                setupInfo = setupCol.get(0);
                this.prmtIndBarcodeSetup.setValue((Object)setupInfo);
                this.prmtIndBarcodeSetup.setEnabled(true);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private void initActions() {
        this.actionDelBill.putValue("ShortDescription", null);
        this.actionDelAllBills.putValue("ShortDescription", null);
        this.actionSelAllBills.putValue("ShortDescription", null);
        this.actionDeselAllBills.putValue("ShortDescription", null);
        this.actionDelBarcode.putValue("ShortDescription", null);
        this.actionDelAllBarcodes.putValue("ShortDescription", null);
        this.actionSelAllBarcodes.putValue("ShortDescription", null);
        this.actionDeselAllBarcodes.putValue("ShortDescription", null);
        if (this.contBill.getButtons().length <= 0) {
            this.contBill.add((Action)((Object)this.actionDelBill));
            this.contBill.add((Action)((Object)this.actionDelAllBills));
            this.contBill.add((Action)((Object)this.actionSelAllBills));
            this.contBill.add((Action)((Object)this.actionDeselAllBills));
        }
        if (this.contBarcode.getButtons().length <= 0) {
            this.contBarcode.add((Action)((Object)this.actionDelBarcode));
            this.contBarcode.add((Action)((Object)this.actionDelAllBarcodes));
            this.contBarcode.add((Action)((Object)this.actionSelAllBarcodes));
            this.contBarcode.add((Action)((Object)this.actionDeselAllBarcodes));
        }
    }

    private void setColEditorColStatus() {
        IColumn col;
        JCheckBox chk = new JCheckBox();
        this.tblChkEditor = new KDTDefaultCellEditor(chk);
        KDNumberTextField numTxtBarcodeCt = new KDNumberTextField();
        KDTDefaultCellEditor numEditor = new KDTDefaultCellEditor((JTextField)numTxtBarcodeCt);
        this.tblBill.getStyleAttributes().setLocked(true);
        this.tblBarcode.getStyleAttributes().setLocked(true);
        if (this.tblBill != null) {
            col = this.tblBill.getColumn("select");
            if (col != null) {
                col.setEditor((ICellEditor)this.tblChkEditor);
                col.getStyleAttributes().setLocked(false);
            }
            if ((col = this.tblBill.getColumn("barcodeCount")) != null) {
                col.setEditor((ICellEditor)numEditor);
                col.getStyleAttributes().setLocked(false);
            }
        }
        if (this.tblBarcode != null && (col = this.tblBarcode.getColumn("select")) != null) {
            col.setEditor((ICellEditor)this.tblChkEditor);
            col.getStyleAttributes().setLocked(false);
        }
    }

    protected void initSampleData() {
        IRow row = null;
        this.tblBarcode.addRows(3);
        ArrayList barcodes = new ArrayList();
        Map d = new HashMap<String, String>();
        d.put("select", "false");
        d.put("barcode", "232342");
        d.put("materialNum", "130823.03");
        d.put("materialName", "Portable WD 1.5T");
        d.put("model", "USB 3.0");
        d.put("measureUnit", "Each");
        d.put("lotNum", "8239-39238");
        d.put("unitPrice", "530.00");
        d.put("supplier", "WestDigital Co.");
        barcodes.add(d);
        barcodes.add(d);
        barcodes.add(d);
        int n = barcodes.size();
        for (int i = 0; i < n; ++i) {
            d = (Map)barcodes.get(i);
            row = this.tblBarcode.getRow(i);
            if (row == null) {
                row = this.tblBarcode.addRow();
            }
            row.setUserObject(d);
            BarcodePrintHelper.setCellValue(row.getCell("select"), Boolean.valueOf((String)d.get("select")));
            BarcodePrintHelper.setCellValue(row.getCell("barcode"), d.get("barcode"));
            BarcodePrintHelper.setCellValue(row.getCell("materialNum"), d.get("materialNum"));
            BarcodePrintHelper.setCellValue(row.getCell("materialName"), d.get("materialName"));
            BarcodePrintHelper.setCellValue(row.getCell("specModel"), d.get("model"));
            BarcodePrintHelper.setCellValue(row.getCell("lotNum"), d.get("lotNum"));
            BarcodePrintHelper.setCellValue(row.getCell("unitPrice"), d.get("unitPrice"));
            BarcodePrintHelper.setCellValue(row.getCell("supplier"), d.get("supplier"));
        }
    }

    private void initCustColumns() {
        this.custCols = null;
        List<BarcodeBillCustColInfo> cols = null;
        if (this.entity == null || this.prmtIndBarcodeSetup.getValue() == null) {
            return;
        }
        IndBarcodeSetupInfo indBarcodeSetupInfo = (IndBarcodeSetupInfo)this.prmtIndBarcodeSetup.getValue();
        try {
            cols = this.getCustColumns(indBarcodeSetupInfo.getId().toString());
        }
        catch (Exception e) {
            logger.error((Object)("cannot get barcode cust cols " + e.getMessage()));
            MsgBox.showWarning((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("errorIndBarcode"));
        }
        if (cols == null || cols.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("cancalDossor"));
            this.actionImport.setEnabled(false);
            this.actionSelectBills.setEnabled(false);
            this.actionGenBarcode.setEnabled(false);
            this.actionBarcodePrint.setEnabled(false);
            return;
        }
        this.actionImport.setEnabled(true);
        this.actionSelectBills.setEnabled(true);
        this.actionGenBarcode.setEnabled(true);
        this.actionBarcodePrint.setEnabled(true);
        IRow uheadRow = this.tblBill.getHeadRow(0);
        IRow bheadRow = this.tblBarcode.getHeadRow(0);
        this.custCols = new ArrayList<String>(cols.size());
        this.headKeyMap = new HashMap<String, List<String>>();
        int n = cols.size();
        for (int i = 0; i < n; ++i) {
            BarcodeBillCustColInfo colInfo = cols.get(i);
            String key = colInfo.getPropertyId();
            String name = colInfo.getPropertyName();
            String dispName = colInfo.getDisplayName();
            int displType = colInfo.getDataType();
            this.custCols.add(name);
            if (name != null) {
                List<Object> keyList;
                if (!this.headKeyMap.containsKey(name)) {
                    keyList = new ArrayList<String>();
                    keyList.add(key);
                    this.headKeyMap.put(name, keyList);
                } else {
                    keyList = this.headKeyMap.get(name);
                    keyList.add(key);
                    this.headKeyMap.put(key, keyList);
                }
            }
            this.addCustColumn(this.tblBill, uheadRow, key, dispName, displType, colInfo.isHide(), colInfo.isEdit());
            this.addCustColumn(this.tblBarcode, bheadRow, key, dispName, displType, colInfo.isHide(), colInfo.isEdit());
        }
    }

    private void addCustColumn(KDTable tbl, IRow headRow, String key, String dispName, int displType, boolean isHide, boolean isEdit) {
        IColumn col = tbl.addColumn();
        int idx = col.getColumnIndex();
        col.setKey(key);
        col.getStyleAttributes().setLocked(false);
        headRow.getCell(idx).setValue((Object)dispName);
        if (BarcodeClientUtils.getBarcodeResource("MeasureUnit").equals(dispName)) {
            this.baseUnitStr = key;
        }
        if (tbl.getName().equals("tblBill")) {
            if (BarcodeClientUtils.getBarcodeResource("MaterialsCode").equals(dispName)) {
                this.materialNumberStr = key;
            }
            if (BarcodeClientUtils.getBarcodeResource("Count").equals(dispName)) {
                this.qtyStr = key;
            }
            if (this.qtyStr != null && BarcodeClientUtils.getBarcodeResource("Count").equals(dispName)) {
                this.qtyStr = key;
            }
            if ("\u6761\u7801\u5305\u88c5\u6570\u91cf".equals(dispName)) {
                this.qtyPack = key;
            }
            if ("\u751f\u4ea7\u65e5\u671f".equals(dispName)) {
                this.mgf = key;
            }
            if ("\u5230\u671f\u65e5\u671f".equals(dispName)) {
                this.exp = key;
            }
            if ("\u7269\u6599\u7f16\u7801".equals(dispName)) {
                this.materialCode = key;
            }
        }
        if (displType == displNum) {
            col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            col.getStyleAttributes().setNumberFormat(BarcodeClientUtils.getFormatPattern(8, true));
        } else if (displType == displBool) {
            col.setEditor((ICellEditor)this.tblChkEditor);
        } else if (displType == new Integer("2")) {
            KDDatePicker datePicker = new KDDatePicker();
            col.setEditor((ICellEditor)new KDTDefaultCellEditor(datePicker));
        }
        col.getStyleAttributes().setHided(isHide);
    }

    protected List<BarcodeBillCustColInfo> getSampleCustColumns() {
        ArrayList<BarcodeBillCustColInfo> cols = new ArrayList<BarcodeBillCustColInfo>();
        return cols;
    }

    private List<BarcodeBillCustColInfo> getCustColumns(String billType) throws BOSException, EASBizException {
        BarcodeBillUIConfigInfo uiConfigInfo;
        if (billType == null) {
            return null;
        }
        IBarcodeFacade iFacade = BarcodeFacadeFactory.getRemoteInstance();
        this.currUIConfig = uiConfigInfo = iFacade.getBillUIConfigInfo(billType);
        if (uiConfigInfo != null) {
            return uiConfigInfo.getCustCols();
        }
        return null;
    }

    @Override
    protected void chkPrintBillNum_itemStateChanged(ItemEvent e) throws Exception {
        boolean fPrintBillNum = this.chkPrintBillNum.isSelected();
        this.prmptRule.setEnabled(!fPrintBillNum);
        this.tblBill.getColumn("barcodeCount").getStyleAttributes().setLocked(fPrintBillNum);
    }

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.tblBill.addRow();
        this.setBillRowDefaultVal(this.entity, row);
    }

    @Override
    public void actionInsRow_actionPerformed(ActionEvent e) throws Exception {
        IRow row = null;
        KDTSelectBlock selBlock = this.tblBill.getSelectManager().get();
        if (selBlock != null) {
            int lastSelRow = selBlock.getEndRow();
            row = this.tblBill.addRow(lastSelRow);
        } else {
            row = this.tblBill.addRow();
        }
        this.setBillRowDefaultVal(this.entity, row);
    }

    private void setBillRowDefaultVal(EntityObjectInfo entity, IRow row) {
        BarcodePrintHelper.setCellValue(row.getCell("select"), Boolean.FALSE);
        BarcodePrintHelper.setCellValue(row.getCell("barcodeCount"), Integer.decode("1"));
        BarcodePrintHelper.setCellValue(row.getCell("billType"), entity != null ? entity.getAlias() : "");
    }

    @Override
    public void actionDelBill_actionPerformed(ActionEvent e) throws Exception {
        this.delTableRow(this.tblBill);
    }

    @Override
    public void actionDelAllBills_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblBill.getRowCount() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        } else if (MsgBox.showConfirm2((Component)((Object)this), (String)"\u662f\u5426\u5220\u9664\u6240\u6709\u5bf9\u8c61\u6570\u636e\u884c\uff1f") == 0) {
            this.tblBill.removeRows();
        }
    }

    @Override
    public void actionDelBarcode_actionPerformed(ActionEvent e) throws Exception {
        int index = -1;
        if (this.tblBarcode.getRowCount() > 0) {
            index = MsgBox.showConfirm2((Component)((Object)this), (String)"\u662f\u5426\u5220\u9664\u6761\u7801\uff1f");
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if (index == 0) {
            this.delTableRow(this.tblBarcode);
        }
    }

    @Override
    public void actionDelAllBarcodes_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblBarcode.getRowCount() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        } else if (MsgBox.showConfirm2((Component)((Object)this), (String)"\u662f\u5426\u5220\u9664\u6761\u7801") == 0) {
            this.tblBarcode.removeRows();
        }
    }

    private void delTableRow(KDTable tbl) throws EASBizException, BOSException {
        if (tbl.getRowCount() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if (tbl.getRowCount() > 0) {
            this.removeLine(tbl);
            tbl.repaint();
        }
    }

    protected void removeLine(KDTable table) throws EASBizException, BOSException {
        IndubarodeParamsetInfo indubarodeParamsetInfo = BarcodeClientUtils.getParamValue(null);
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int index;
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
                if (null != table.getCell(rowIndex, "barcode") && indubarodeParamsetInfo.isIsDelBarcode()) {
                    String barcode = table.getCell(rowIndex, "barcode").getValue().toString();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)barcode));
                    BarcodeDossierFactory.getRemoteInstance().delete(filter);
                }
                table.removeRow(rowIndex);
                IObjectCollection collection = (IObjectCollection)table.getUserObject();
                if (collection == null) {
                    logger.error((Object)"collection not be binded to table");
                    continue;
                }
                if (detailData == null || (index = this.getCollectionIndex(collection, detailData)) < 0 || collection.size() <= index) continue;
                collection.removeObject(index);
            }
            if (table.getRow(0) != null) {
                table.getSelectManager().select(0, 0);
            }
        }
    }

    private int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    @Override
    public void actionSelAllBills_actionPerformed(ActionEvent e) throws Exception {
        this.selAllDeSelAll(this.tblBill, true);
    }

    @Override
    public void actionDeselAllBills_actionPerformed(ActionEvent e) throws Exception {
        this.selAllDeSelAll(this.tblBill, false);
    }

    @Override
    public void actionSelAllBarcodes_actionPerformed(ActionEvent e) throws Exception {
        boolean isRepeatPrint = false;
        try {
            IndubarodeParamsetInfo indParasetInfo = BarcodeClientUtils.getParamValue(null);
            isRepeatPrint = indParasetInfo.isRepeatPrint();
            int n = this.tblBarcode.getRowCount();
            for (int i = 0; i < n; ++i) {
                IRow row = this.tblBarcode.getRow(i);
                if (row.getCell("isPrint").getValue() == null) continue;
                boolean isPrint = Boolean.parseBoolean(row.getCell("isPrint").getValue().toString());
                if (isPrint) {
                    if (isRepeatPrint) {
                        row.getCell("select").setValue((Object)true);
                        continue;
                    }
                    row.getCell("select").setValue((Object)false);
                    continue;
                }
                row.getCell("select").setValue((Object)true);
            }
        }
        catch (BOSException be) {
            be.printStackTrace();
        }
    }

    @Override
    public void actionDeselAllBarcodes_actionPerformed(ActionEvent e) throws Exception {
        this.selAllDeSelAll(this.tblBarcode, false);
    }

    private void selAllDeSelAll(KDTable tbl, boolean fSel) {
        if (tbl.getRowCount() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        Boolean fVal = fSel ? Boolean.TRUE : Boolean.FALSE;
        int n = tbl.getRowCount();
        for (int i = 0; i < n; ++i) {
            tbl.getRow(i).getCell("select").setValue((Object)fVal);
        }
    }

    private boolean checkFunctionPermission(String permissionItem) {
        BOSUuid userId = SysContext.getSysContext().getCurrentUserInfo().getId();
        BOSUuid orgId = SysContext.getSysContext().getCurrentCtrlUnit().getId();
        try {
            return PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(orgId), permissionItem);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return false;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkFunctionPermission("bracodePrint_Import")) {
            MsgBox.showWarning((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("bracodePrint_Import"));
            return;
        }
        if (this.currUIConfig == null) {
            MsgBox.showWarning((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("cancleIndMaster"));
            return;
        }
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setFileSelectionMode(2);
        fileChooser.setFileFilter(EXCEL_FILTER);
        if (this.selectedImportFile != null) {
            fileChooser.setSelectedFile(this.selectedImportFile);
        }
        int action = fileChooser.showOpenDialog((Component)((Object)this));
        File selectedFile = null;
        if (action == 0) {
            this.selectedImportFile = selectedFile = fileChooser.getSelectedFile();
            logger.info((Object)("selected data file :" + selectedFile));
            if (this.prmtStorageOrgUnit.getValue() != null) {
                this.currUIConfig.setOrgUnitInfo((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
            }
            this.excelParser = new BarcodeExcelParser(selectedFile, this.currUIConfig);
            final BarcodeExcelData excelData = this.excelParser.parseExcel();
            if (excelData == null) {
                MsgBox.showWarning((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("excelParser"));
                return;
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    BarcodePrintUI.this.importBarcodes(excelData);
                }
            }).start();
        }
    }

    private void importBarcodes(BarcodeExcelData excelData) {
        this.setMessageText(BarcodeClientUtils.getBarcodeResource("importing"));
        this.showMessage();
        try {
            IBarcodeFacade iFacade = BarcodeFacadeFactory.getRemoteInstance();
            BarcodeGenResult barcodesRslt = iFacade.importBarcodes(excelData);
            if (barcodesRslt != null) {
                this.setBarcodeTbl(barcodesRslt);
            } else {
                logger.error((Object)"no barcodes are imported !");
                MsgBox.showWarning((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("importError"));
            }
        }
        catch (Exception e) {
            logger.error((Object)("print barcode has exception, " + e.getMessage()));
        }
        this.setMessageText(BarcodeClientUtils.getBarcodeResource("finishedImport"));
        this.showMessage();
    }

    @Override
    protected void comboBillType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1) {
            int action;
            if (!this.fBillToBarcode && this.tblBill.getRowCount() > 0 && (action = MsgBox.showConfirm3((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("isClearData"))) != 0) {
                SysUtil.abort();
            }
            if (!this.fBarcodePrint && this.tblBarcode.getRowCount() > 0 && (action = MsgBox.showConfirm3((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("isClearBarcode"))) != 0) {
                SysUtil.abort();
            }
            this.setPrmptRuleFilter();
            this.tblBill.setRefresh(false);
            this.tblBarcode.setRefresh(false);
            this.tblBill.removeRows();
            this.tblBarcode.removeRows();
            this.resetTable(this.tblBill, 9);
            this.resetTable(this.tblBarcode, 6);
            this.initCustColumns();
            this.regfeshTable();
        }
    }

    private void regfeshTable() {
        this.tblBill.setRefresh(true);
        this.tblBill.repaint();
        this.tblBarcode.setRefresh(true);
        this.tblBarcode.repaint();
    }

    private void setPrmptRuleFilter() throws ParserException {
        if (this.entity == null) {
            this.prmptRule.setEnabled(false);
            return;
        }
        BOSObjectType bosType = this.entity.getType();
        if (bosType != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter("businessObjectID = '" + bosType + "' and state = " + 1);
            this.prmptRule.setEntityViewInfo(viewInfo);
            this.prmptRule.setEnabled(true);
        } else {
            this.prmptRule.setEnabled(false);
        }
        this.prmptRule.setValue(null);
    }

    private void resetTable(KDTable tbl, int initCt) {
        int colCt = tbl.getColumnCount();
        tbl.removeRows();
        for (int i = colCt - 1; i > initCt - 1; --i) {
            tbl.removeColumn(i);
        }
    }

    @Override
    protected void prmptRule_dataChanged(DataChangeEvent e) throws Exception {
    }

    @Override
    protected void txtBillNum_keyPressed(KeyEvent e) throws Exception {
        String nums;
        int keyCode = e.getKeyCode();
        if (keyCode == 10 && !StringUtils.isEmpty((String)(nums = this.txtBillNum.getText()))) {
            this.actionSelectBills_actionPerformed(null);
        }
    }

    @Override
    public void actionSelectBills_actionPerformed(ActionEvent e) throws Exception {
        int i;
        IObjectCollection bills = null;
        String billNums = this.txtBillNum.getText();
        if (!StringUtils.isEmpty((String)billNums) && (bills = this.getBillsByNums(billNums = billNums.trim(), this.entity)) != null && bills.size() > 0) {
            this.loadBillsData(this.entity, bills, null);
            this.fBillToBarcode = false;
            return;
        }
        Map idsMap = this.getBillSelectedData(this.entity);
        if (idsMap == null || idsMap.size() == 0) {
            logger.error((Object)"no bills are selected");
            return;
        }
        bills = this.getBillsBySelectedData(this.entity, idsMap);
        if (bills == null || bills.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("selectStateBill"));
            return;
        }
        KDTRow headRow = this.tblBill.getHead().getRow(0);
        this.rowColIndexMap.clear();
        int size = headRow.getCells().size();
        for (i = 0; i < size; ++i) {
            KDTCell kdtCell = headRow.getCell(i);
            String value = kdtCell.getValue().toString();
            this.rowColIndexMap.put(i, value);
        }
        this.loadBillsData(this.entity, bills, idsMap);
        for (i = 0; this.tblBill.getRowCount() > i; ++i) {
            IRow iRow = this.tblBill.getRow(i);
            this.countDueDate(iRow);
        }
        this.fBillToBarcode = false;
        this.regfeshTable();
    }

    private IObjectCollection getBillsBySelectedData(EntityObjectInfo entity, Map<String, Set<String>> idsMap) {
        StringBuffer oql = new StringBuffer();
        oql.append(this.getOqlSelect(entity));
        oql.append(" id in (");
        for (String id : idsMap.keySet()) {
            oql.append("'").append(id);
            oql.append("',");
        }
        oql.deleteCharAt(oql.length() - 1);
        oql.append(")");
        IObjectCollection bills = this.getBills(entity, oql.toString());
        return bills;
    }

    private IObjectCollection getBills(EntityObjectInfo selectEntry, String oql) {
        if (selectEntry == null) {
            return null;
        }
        CoreBaseCollection bills = null;
        try {
            String bizClsName = selectEntry.getBusinessInterface();
            Class<?> bizCls = Class.forName(bizClsName);
            ICoreBase iBiz = (ICoreBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)selectEntry.getType(), bizCls);
            bills = iBiz.getCollection(oql.toString());
        }
        catch (Exception e) {
            logger.error((Object)"no data provided!!", (Throwable)e);
            this.handUIException(e);
            SysUtil.abort();
        }
        return bills;
    }

    private String getOqlSelect(EntityObjectInfo billEntity) {
        if (billEntity == null) {
            return "";
        }
        String billBosType = billEntity.getType().toString();
        EntityObjectInfo entryEntity = null;
        if (billBosType.equals("1D0D80DD")) {
            entryEntity = BarcodeUtils.getEntityByBosType("ED498839");
        }
        Map<String, EntityObjectInfo> entryEntityObjectMap = this.getEntryEntityObjectInfo(billEntity);
        String propName = null;
        String[] propArr = null;
        PropertyInfo propInfo = null;
        StringBuffer oql = new StringBuffer();
        oql.append("select id, number");
        if (this.custCols != null && this.custCols.size() > 0) {
            int n = this.custCols.size();
            for (int i = 0; i < n; ++i) {
                propName = this.custCols.get(i);
                if (StringUtils.isEmpty((String)propName)) continue;
                oql.append(", ").append(propName);
                propArr = propName.split("\\.");
                if (propArr.length == 1) {
                    propInfo = billEntity.getPropertyByName(propName);
                    if (!(propInfo instanceof LinkPropertyInfo)) continue;
                    oql.append(".id, ").append(propName).append(".name");
                    oql.append(", ").append(propName).append(".number");
                    if (!"material".equalsIgnoreCase(propInfo.getName())) continue;
                    oql.append(", ").append(propName).append(".model");
                    continue;
                }
                if (propArr.length == 2) {
                    String key = propArr[0];
                    if (entryEntityObjectMap.containsKey(key)) {
                        entryEntity = entryEntityObjectMap.get(key);
                    }
                    if (entryEntity == null || !((propInfo = entryEntity.getPropertyByName(propArr[1])) instanceof LinkPropertyInfo)) continue;
                    oql.append(".id, ").append(propName).append(".name");
                    oql.append(", ").append(propName).append(".number");
                    if (!"material".equalsIgnoreCase(propInfo.getName())) continue;
                    oql.append(", ").append(propName).append(".model");
                    continue;
                }
                if (propArr.length != 3) continue;
                logger.warn((Object)("prop in 3 level, " + propName));
            }
        }
        if (!(this.isBaseData.booleanValue() || "42AC39EC".equals(billEntity.getType().toString()) || "BA8AD747".equals(billEntity.getType().toString()))) {
            oql.append(" where (baseStatus = ");
            oql.append(1);
            oql.append(" or baseStatus = ");
            oql.append(2);
            oql.append(" or baseStatus = ");
            oql.append(4);
            oql.append(" or baseStatus = ");
            oql.append(7);
            oql.append(" or baseStatus = ");
            oql.append(5);
            oql.append(" or baseStatus = ");
            oql.append("8)");
            oql.append(" and ");
        } else {
            oql.append(" where ");
        }
        return oql.toString();
    }

    private Map<String, EntityObjectInfo> getEntryEntityObjectInfo(EntityObjectInfo billEntity) {
        HashMap<String, EntityObjectInfo> bosTypeMap = new HashMap<String, EntityObjectInfo>();
        PropertyCollection pyColl = billEntity.getEntityProperties();
        for (int i = 0; i < pyColl.size(); ++i) {
            PropertyInfo property = pyColl.get(i);
            if (property.getName().equalsIgnoreCase("ID") || !BarcodeUtils.isEntryProperty(billEntity, property)) continue;
            RelationshipInfo relation = ((LinkPropertyInfo)property).getRelationship();
            String bosType = relation.getSupplierObject().getType().toString();
            EntityObjectInfo entryEntity = BarcodeUtils.getEntityByBosType(bosType);
            bosTypeMap.put(property.getName(), entryEntity);
        }
        this.setEntryEntityObjectMap(bosTypeMap);
        return bosTypeMap;
    }

    private IObjectCollection getBillsByNums(String billNums, EntityObjectInfo entity) {
        StringBuffer oql = new StringBuffer();
        oql.append(this.getOqlSelect(entity));
        oql.append(this.toBillNumInSql(billNums));
        IObjectCollection bills = this.getBills(entity, oql.toString());
        return bills;
    }

    private String toBillNumInSql(String billNums) {
        StringBuffer inSql = new StringBuffer();
        inSql.append(" number ");
        if (billNums.indexOf(",") > 0) {
            String[] arr = billNums.split(",");
            inSql.append(" in (");
            for (int i = 0; i < arr.length; ++i) {
                inSql.append("'").append(arr[i].trim());
                inSql.append(i + 1 < arr.length ? "', " : "'");
            }
            inSql.append(")");
        } else {
            inSql.append(" = '").append(billNums).append("'");
        }
        return inSql.toString();
    }

    private void loadBillsData(EntityObjectInfo entity, IObjectCollection bills, Map<String, Set<String>> idsMap) throws BOSException {
        boolean fPrintBillNum = this.chkPrintBillNum.isSelected();
        String entryName = null;
        if (this.custCols != null) {
            String propName = null;
            String[] propArr = null;
            int n = this.custCols.size();
            for (int i = 0; i < n; ++i) {
                propName = this.custCols.get(i);
                if (StringUtils.isEmpty((String)propName)) continue;
                propArr = propName.split("\\.");
                if (propArr.length == 2) {
                    entryName = propArr[0];
                }
                if (propArr.length <= 2) continue;
                entryName = propArr[0];
                break;
            }
            Map<String, EntityObjectInfo> mapEntity = BarcodeUtils.getEntryName(entity);
            if (entryName != null && !mapEntity.containsKey(entryName)) {
                entryName = null;
            }
        }
        if (this.isBaseData.booleanValue()) {
            entryName = null;
        }
        this.isBaseData = entryName == null ? Boolean.valueOf(true) : Boolean.valueOf(false);
        this.entryProperty = entryName;
        int n = bills.size();
        for (int i = 0; i < n; ++i) {
            IObjectValue info = bills.getObject(i);
            this.loadBillToRow(entity, info, entryName, idsMap);
        }
        try {
            this.getPacageQty(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadBillToRow(EntityObjectInfo entity, IObjectValue info, String entryName, Map<String, Set<String>> idsMap) throws BOSException {
        Set<String> eSet;
        String entryId;
        String id;
        IObjectValue entryInfo;
        int j;
        if (this.custCols == null) {
            return;
        }
        Object propName = null;
        Object propVal = null;
        Object propArr = null;
        MaterialInfo materialInfo = null;
        IRow row = null;
        if (entryName == null) {
            row = this.tblBill.addRow();
            materialInfo = this.loadBillEntryToRow(entity, info, null, row);
            if (this.prmtStorageOrgUnit.getValue() != null && materialInfo != null) {
                StorageOrgUnitInfo orgUnitInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
                try {
                    MaterialInventoryInfo inventoryInfo;
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    viewInfo.getSelector().add(new SelectorItemInfo("isLotNumber"));
                    viewInfo.getSelector().add(new SelectorItemInfo("isBarcodeLot"));
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialInfo.getId(), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitInfo.getId(), CompareType.EQUALS));
                    viewInfo.setFilter(filter);
                    MaterialInventoryCollection inventoryCol = MaterialInventoryFactory.getRemoteInstance().getMaterialInventoryCollection(viewInfo);
                    if (inventoryCol.size() > 0 && (inventoryInfo = inventoryCol.get(0)).isIsLotNumber()) {
                        BarcodePrintHelper.setLotCellStyle(row, "lot", materialInfo, orgUnitInfo.getId().toString(), (IUIObject)this);
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            this.updateBarcodeCount();
            return;
        }
        IObjectCollection entries = (IObjectCollection)info.get(entryName);
        if (entries == null) {
            return;
        }
        boolean isExstsEntry = false;
        int m = entries.size();
        for (j = 0; j < m; ++j) {
            entryInfo = entries.getObject(j);
            id = info.get("id").toString();
            entryId = entryInfo.get("id").toString();
            eSet = idsMap.get(id);
            if (!eSet.contains(entryId)) continue;
            isExstsEntry = true;
            break;
        }
        m = entries.size();
        for (j = 0; j < m; ++j) {
            entryInfo = entries.getObject(j);
            if (idsMap == null) {
                row = this.tblBill.addRow();
                materialInfo = this.loadBillEntryToRow(entity, info, entryInfo, row);
            } else {
                id = info.get("id").toString();
                entryId = entryInfo.get("id").toString();
                eSet = idsMap.get(id);
                if (eSet.contains(entryId) || !isExstsEntry) {
                    row = this.tblBill.addRow();
                    materialInfo = this.loadBillEntryToRow(entity, info, entryInfo, row);
                    isExstsEntry = true;
                }
            }
            if (row == null || this.prmtStorageOrgUnit.getValue() == null || materialInfo == null) continue;
            StorageOrgUnitInfo orgUnitInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
            try {
                MaterialInventoryInfo inventoryInfo;
                EntityViewInfo viewInfo = new EntityViewInfo();
                viewInfo.getSelector().add(new SelectorItemInfo("isLotNumber"));
                viewInfo.getSelector().add(new SelectorItemInfo("isBarcodeLot"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialInfo.getId(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitInfo.getId(), CompareType.EQUALS));
                viewInfo.setFilter(filter);
                MaterialInventoryCollection inventoryCol = MaterialInventoryFactory.getRemoteInstance().getMaterialInventoryCollection(viewInfo);
                if (inventoryCol.size() <= 0 || !(inventoryInfo = inventoryCol.get(0)).isIsLotNumber()) continue;
                BarcodePrintHelper.setLotCellStyle(row, "lot", materialInfo, orgUnitInfo.getId().toString(), (IUIObject)this);
                continue;
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        this.updateBarcodeCount();
    }

    private MaterialInfo loadBillEntryToRow(EntityObjectInfo entity, IObjectValue info, IObjectValue entryInfo, IRow row) throws BOSException {
        Object barcodeQty;
        this.setBillRowDefaultVal(entity, row);
        BarcodePrintHelper.setCellValue(row.getCell("billNum"), info.getString("number"));
        BarcodePrintHelper.setCellValue(row.getCell("id"), info.getString("id"));
        if (entryInfo != null) {
            BarcodePrintHelper.setCellValue(row.getCell("entry.id"), entryInfo.getString("id"));
        } else {
            BarcodePrintHelper.setCellValue(row.getCell("entry.id"), info.getString("id"));
        }
        String propName = null;
        Object propVal = null;
        String[] propArr = null;
        MaterialInfo materialInfo = null;
        if (info instanceof MaterialInfo) {
            materialInfo = (MaterialInfo)info;
        }
        AdminOrgUnitInfo administratorInfo = null;
        Object assistPropertyKey = null;
        Object productionLineKey = null;
        Object shiftKey = null;
        String materialName = null;
        String martialModel = null;
        StringBuffer fullName = new StringBuffer();
        int n = this.custCols.size();
        for (int i = 0; i < n; ++i) {
            propName = this.custCols.get(i);
            if (!StringUtils.isEmpty((String)propName)) {
                KDFilterTextField txt;
                String key;
                int j;
                int m;
                List<String> proNameList;
                propArr = propName.split("\\.");
                boolean bool = false;
                fullName.setLength(0);
                if (propArr.length == 1) {
                    propVal = info.get(propName);
                    if (propVal instanceof IObjectValue) {
                        bool = true;
                        fullName.append(propVal.getClass().getName());
                        if (propVal instanceof AdminOrgUnitInfo) {
                            administratorInfo = (AdminOrgUnitInfo)propVal;
                        }
                        if (propVal instanceof MaterialInfo) {
                            materialInfo = (MaterialInfo)propVal;
                            propVal = ((IObjectValue)propVal).getString("number");
                            materialName = materialInfo.getString("name");
                            martialModel = materialInfo.getString("model");
                        } else {
                            propVal = ((IObjectValue)propVal).getString("name");
                        }
                    }
                } else if (propArr.length == 2) {
                    Object propValObje = null;
                    boolean isEntryProperty = BarcodeUtils.isEntryProperty(entity, entity.getPropertyByName(propArr[0]));
                    if (isEntryProperty) {
                        propVal = entryInfo.get(propArr[1]);
                        propValObje = entryInfo.get(propArr[1]);
                        if (propValObje instanceof IObjectValue) {
                            bool = true;
                            fullName.append(propVal.getClass().getName());
                            if (propValObje instanceof MaterialInfo) {
                                materialInfo = (MaterialInfo)propValObje;
                                propVal = ((IObjectValue)propVal).getString("number");
                            } else {
                                propVal = ((IObjectValue)propVal).getString("number");
                            }
                        }
                    } else if (info != null) {
                        propVal = info.get(propArr[0]);
                        propValObje = info.get(propArr[0]);
                        if (propValObje instanceof IObjectValue) {
                            bool = true;
                            fullName.append(propVal.getClass().getName());
                            if (propValObje instanceof MaterialInfo) {
                                materialInfo = (MaterialInfo)propValObje;
                                propVal = ((IObjectValue)propVal).getString(propArr[1]);
                            } else {
                                propVal = ((IObjectValue)propVal).getString(propArr[1]);
                            }
                        }
                    }
                } else if (propArr.length > 2) {
                    bool = true;
                    propVal = entryInfo != null ? this.getPropVal(entryInfo, propName, 1, materialInfo, fullName) : this.getPropVal(info, propName, 0, materialInfo, fullName);
                }
                if (propName.equals("materialName")) {
                    propVal = materialName;
                }
                if (propName.equals("material_model")) {
                    propVal = martialModel;
                }
                if (this.headKeyMap.containsKey(propName)) {
                    proNameList = this.headKeyMap.get(propName);
                    m = proNameList.size();
                    for (j = 0; j < m; ++j) {
                        BarcodePrintHelper.setCellValue(row, proNameList.get(j), propVal);
                        if (!bool) continue;
                        String prop = propName.split("\\.")[propName.split("\\.").length - 1];
                        BarcodePrintHelper.setPropertyCellStyles(row, proNameList.get(j), prop, fullName.toString());
                    }
                }
                if (propName.equals(this.qtyStr) && row.getCell(this.qtyPack) != null) {
                    if (propVal != null) {
                        BigDecimal amtVal = (BigDecimal)propVal;
                        row.getCell(this.qtyPack).setValue((Object)amtVal);
                    } else {
                        row.getCell(this.qtyPack).setValue((Object)1);
                    }
                }
                if (this.headKeyMap.containsKey("barcodeQ")) {
                    proNameList = this.headKeyMap.get("barcodeQ");
                    m = proNameList.size();
                    for (j = 0; j < m; ++j) {
                        key = proNameList.get(j);
                        txt = new KDFilterTextField();
                        txt.setFilterType(1);
                        txt.setValidCharacters(".");
                        txt.setMaxLength(80);
                        row.getCell(key).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txt));
                        row.getCell(key).getStyleAttributes().setLocked(false);
                        row.getCell(key).getStyleAttributes().setBackground(this.balckColor);
                    }
                }
                if (this.headKeyMap.containsKey("barcodeRemart")) {
                    proNameList = this.headKeyMap.get("barcodeRemart");
                    m = proNameList.size();
                    for (j = 0; j < m; ++j) {
                        key = proNameList.get(j);
                        txt = new KDTextField();
                        txt.setName("barcodeRemart");
                        txt.setHorizontalAlignment(2);
                        txt.setMaxLength(255);
                        txt.setRequired(false);
                        row.getCell(key).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txt));
                        row.getCell(key).getStyleAttributes().setLocked(false);
                        this.tblBill.getColumn(key).getStyleAttributes().setBackground(this.balckColor);
                    }
                }
            }
            propVal = null;
        }
        if (row.getCell(this.qtyPack) != null && ((barcodeQty = row.getCell(this.qtyPack).getValue()) == null || "".equals(barcodeQty.toString()) || BigDecimal.ZERO.compareTo(new BigDecimal(barcodeQty.toString())) == 0)) {
            row.getCell(this.qtyPack).setValue((Object)1);
        }
        return materialInfo;
    }

    private Object getPropVal(IObjectValue info, String propName, int index, StringBuffer fullName) {
        Object propVal = null;
        String[] propArr = propName.split("\\.");
        for (int i = index; i < propArr.length; ++i) {
            String propNameAr = propArr[index];
            propVal = info.get(propNameAr);
            if (!(propVal instanceof IObjectValue)) continue;
            fullName.setLength(0);
            fullName.append(propVal.getClass().getName());
            propVal = this.getPropVal((IObjectValue)propVal, propName, ++i, fullName);
            break;
        }
        return propVal;
    }

    @Override
    protected void tblBill_editStopped(KDTEditEvent e) throws Exception {
        IRow row = this.tblBill.getRow(e.getRowIndex());
        if (e.getColIndex() == this.tblBill.getColumnIndex("barcodeQ")) {
            ICell cell = row.getCell("barcodeQ");
            cell.getValue();
        }
    }

    @Override
    protected void tblBill_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    @Override
    protected void tblBarcode_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (e.getSelectBlock() == null) {
            return;
        }
        int beginRow = e.getSelectBlock().getBeginRow();
        int endRow = e.getSelectBlock().getEndRow();
        boolean isRepeatPrint = false;
        try {
            IndubarodeParamsetInfo indParasetInfo = BarcodeClientUtils.getParamValue(null);
            isRepeatPrint = indParasetInfo.isRepeatPrint();
        }
        catch (BOSException be) {
            be.printStackTrace();
        }
        for (int i = beginRow; i <= endRow; ++i) {
            boolean isPrint;
            IRow row = this.tblBarcode.getRow(i);
            if (row == null || row.getCell("select").getValue() == null) continue;
            boolean isSelect = Boolean.parseBoolean(row.getCell("select").getValue().toString());
            row.getCell("select").setValue((Object)(!isSelect ? 1 : 0));
            if (row.getCell("isPrint").getValue() == null || !(isPrint = Boolean.parseBoolean(row.getCell("isPrint").getValue().toString())) || isRepeatPrint) continue;
            row.getCell("select").setValue((Object)false);
        }
    }

    private String getBillSelectUICls(EntityObjectInfo selectEntity) {
        String cls = null;
        String fullName = selectEntity.getFullName();
        fullName = fullName.substring(fullName.lastIndexOf("."), fullName.length());
        cls = "com.kingdee.eas.barcode.scm.client" + fullName + "SelectUI";
        return cls;
    }

    private Map getBillSelectedData(EntityObjectInfo selectEntity) throws Exception {
        if (selectEntity == null) {
            return null;
        }
        Map selBills = null;
        String uiCls = this.getBillSelectUICls(selectEntity);
        if (StringUtils.isEmpty((String)uiCls)) {
            logger.error((Object)("invalid billTye, not in enum!! " + selectEntity.getType()));
            return selBills;
        }
        UIContext uiContext = new UIContext((Object)this);
        try {
            IUIWindow billSelUiWin = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiCls, (Map)uiContext, null, OprtState.VIEW, 95);
            billSelUiWin.show();
            IUIObject selUI = billSelUiWin.getUIObject();
            if (selUI instanceof IBarcodeBillSelectUI) {
                selBills = ((IBarcodeBillSelectUI)selUI).getBarcodeSelectedData();
                this.entryProperty = ((IBarcodeBillSelectUI)selUI).getEntryID();
                this.mainQueryPK = ((IBarcodeBillSelectUI)selUI).getTDQueryPK();
            }
        }
        catch (UIException e) {
            if (e.getMessage() != null && e.getMessage().contains("Can not create ui object!")) {
                MsgBox.showWarning((Component)((Object)this), (String)("[" + selectEntity.getAlias() + "]" + BarcodeClientUtils.getBarcodeResource("ObjectTypePrint")));
                SysUtil.abort();
            }
            if (e.getCauseClassName() != null && e.getCauseClassName().equals("com.kingdee.eas.common.EASBizException")) {
                MsgBox.showWarning((String)e.fillInStackTrace().getCause().getMessage());
                SysUtil.abort();
            }
            e.printStackTrace();
        }
        return selBills;
    }

    public void actionSelectBillsData_actionPerformed(ActionEvent e, KDTable tblMain) throws Exception {
        if (tblMain.getRowCount() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("queryBill"));
            SysUtil.abort();
        } else {
            ArrayList selBlocks = tblMain.getSelectManager().getBlocks();
            if (selBlocks == null || selBlocks.size() <= 0) {
                MsgBox.showWarning((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("selectBill"));
                SysUtil.abort();
            }
        }
        this.disposeUIWindow();
    }

    @Override
    public void actionGenBarcode_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblBill.getRowCount() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("selectBill"));
            logger.error((Object)"no data provided!!");
            return;
        }
        if (this.prmtIndBarcodeSetup.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("selectIndMaster"));
            this.prmtIndBarcodeSetup.requestFocus();
            logger.error((Object)"no rule provided!!");
            return;
        }
        boolean fPrintBillNum = this.chkPrintBillNum.isSelected();
        if (!fPrintBillNum && this.prmptRule.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("selectBarcodeRule"));
            this.prmptRule.requestFocus();
            logger.error((Object)"no rule provided!!");
            return;
        }
        if (fPrintBillNum) {
            this.setBillNumAsBarcode();
        } else {
            BarcodeGenerateParams barcodeGenParam = this.getSelectedBills();
            List<BarcodeGenerateParamInfo> bList = barcodeGenParam.getParamList();
            if (bList == null || bList.size() == 0) {
                MsgBox.showWarning((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("selectBarcodeData"));
                logger.error((Object)"no data selected!!");
                return;
            }
            barcodeGenParam.setSave(this.isSaveBarcode);
            if (this.entity.getType().toString().equals("42AC39EC")) {
                barcodeGenParam.setBaseData(true);
            } else {
                barcodeGenParam.setBaseData(this.isBaseData);
            }
            IBarcodeFacade iFacade = BarcodeFacadeFactory.getRemoteInstance();
            BarcodeGenResult barcodesRslt = iFacade.geneateBarcodes(barcodeGenParam);
            this.setBarcodeTbl(barcodesRslt);
        }
    }

    private BarcodeGenerateParams getSelectedBills() {
        BarcodeGenerateParams param = new BarcodeGenerateParams();
        ArrayList<BarcodeGenerateParamInfo> pList = new ArrayList<BarcodeGenerateParamInfo>();
        IRow row = null;
        boolean fSel = false;
        int n = this.tblBill.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.tblBill.getRow(i);
            fSel = Boolean.parseBoolean(row.getCell("select").getValue().toString());
            if (!fSel) continue;
            BarcodeGenerateParamInfo pInfo = new BarcodeGenerateParamInfo();
            Object val = row.getCell("id").getValue();
            if (val != null) {
                pInfo.setBillId((String)val);
            }
            if ((val = row.getCell("entry.id").getValue()) != null) {
                pInfo.setEntryId((String)val);
            }
            if ((val = row.getCell("barcodeCount").getValue()) != null) {
                pInfo.setBarcodeCount(Integer.parseInt(val.toString()));
            }
            if (this.datePicker.getValue() != null) {
                pInfo.setBarcodeDate((Date)this.datePicker.getValue());
            }
            if (row.getCell("barcodeQ") != null && row.getCell("barcodeQ").getValue() != null) {
                String barcodeQty = row.getCell("barcodeQ").getValue().toString();
                pInfo.setBarcodeQty(new BigDecimal(barcodeQty));
            }
            if (val != null) {
                pInfo.setTotalCount(new BigDecimal(val.toString()));
            }
            HashMap<String, String> rowValueMap = new HashMap<String, String>();
            for (int colIndex : this.rowColIndexMap.keySet()) {
                String disName = this.rowColIndexMap.get(new Integer(colIndex));
                Object value = row.getCell(colIndex).getValue();
                if (value instanceof Date) {
                    value = BarcodeUtils.SIMPLE_DATE_FORMAT.format(value);
                }
                rowValueMap.put(disName, value == null ? "" : value.toString());
            }
            pInfo.setRowValueMap(rowValueMap);
            pInfo.setRowValueMap(pInfo.getRowValueMap());
            if (this.prmtStorageOrgUnit.getValue() != null) {
                pInfo.setStorageOrgUnitInfo((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
            }
            if (row.getCell("billNum").getValue() != null) {
                pInfo.setBillNum(row.getCell("billNum").getValue().toString());
            }
            pList.add(pInfo);
        }
        if (pList.size() > 0) {
            IndBarcodeRuleInfo ruleInfo = (IndBarcodeRuleInfo)this.prmptRule.getData();
            param.setEntity(this.entity);
            if (ruleInfo.getId() != null) {
                param.setBarcodeRuleId(ruleInfo.getId().toString());
            }
            param.setParamList(pList);
            IndBarcodeSetupInfo setupInfo = (IndBarcodeSetupInfo)this.prmtIndBarcodeSetup.getData();
            param.setIndBarcodeSetupId(setupInfo.getId().toString());
            if (this.entryProperty != null) {
                String[] strArg = this.entryProperty.split("\\.");
                String key = strArg[0];
                Map<String, EntityObjectInfo> entryEntityMap = null;
                if (this.getEntryEntityObjectMap() == null) {
                    this.setEntryEntityObjectMap(this.getEntryEntityObjectInfo(this.entity));
                }
                if ((entryEntityMap = this.getEntryEntityObjectMap()).containsKey(key)) {
                    param.setEntrtyEntity(entryEntityMap.get(key));
                }
            }
        }
        return param;
    }

    private void setBillNumAsBarcode() {
        int i;
        IRow row = null;
        IRow bRow = null;
        boolean fSel = false;
        String billNum = null;
        ArrayList<String> billNums = new ArrayList<String>();
        int n = this.tblBill.getRowCount();
        for (i = 0; i < n; ++i) {
            row = this.tblBill.getRow(i);
            fSel = Boolean.parseBoolean(row.getCell("select").getValue().toString());
            if (!fSel || billNums.contains(billNum = row.getCell("billNum").getValue().toString())) continue;
            billNums.add(billNum);
        }
        if (billNums.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("selectBarcodeData"));
            logger.error((Object)"no data selected!!");
            return;
        }
        n = billNums.size();
        for (i = 0; i < n; ++i) {
            bRow = this.tblBarcode.addRow();
            this.setBarcodeAttrs(bRow, (String)billNums.get(i), null);
        }
    }

    private void setBarcodeTbl(BarcodeGenResult barcodesRslt) {
        if (barcodesRslt == null) {
            MsgBox.showWarning((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("barcodesRsltErroe"));
            logger.error((Object)"no barcodes are generated !");
            return;
        }
        BarcodeDossierCollection barcodes = barcodesRslt.getBarcodes();
        boolean fNoBarcodes = barcodes == null || barcodes.size() == 0;
        this.showBarcodeGenMsg(barcodesRslt, fNoBarcodes);
        if (fNoBarcodes) {
            return;
        }
        IRow row = null;
        String barcode = null;
        String qrcode = null;
        int n = barcodes.size();
        for (int i = 0; i < n; ++i) {
            BarcodeDossierInfo barcodeInfo = barcodes.get(i);
            barcode = barcodeInfo.getNumber();
            qrcode = barcodeInfo.getQrcode();
            row = this.tblBarcode.addRow();
            barcodeInfo.replaceEntrysByTemplate();
            this.setBarcodeAttrs(row, barcode, qrcode, barcodeInfo);
        }
    }

    private void updateBarcodeCount() {
        int rowCount = this.tblBill.getRowCount();
        Map<String, IndBarCodeCountMsgInfo> countMsgMap = this.getBarcodeCount();
        for (int i = 0; i < rowCount; ++i) {
            BigDecimal barcodeUnCount;
            IRow row = this.tblBill.getRow(i);
            if (row.getCell("entry.id").getValue() == null || row.getCell("id").getValue() == null) continue;
            String key = "";
            key = !"1D0D80DD".equalsIgnoreCase(this.entity.getType().toString()) ? row.getCell("entry.id").getValue().toString() : row.getCell("id").getValue().toString();
            if (!countMsgMap.containsKey(key)) continue;
            IndBarCodeCountMsgInfo barcodeCountedMsgInfo = countMsgMap.get(key);
            if (row.getCell(this.qtyStr) == null) {
                return;
            }
            if (row.getCell(this.qtyStr).getValue() == null) {
                row.getCell(this.qtyStr).setValue((Object)new BigDecimal(1));
            }
            String billQtyStr = row.getCell(this.qtyStr).getValue().toString();
            if (row.getCell("barcodeQ") == null) continue;
            String minPakegeQtyStr = row.getCell("barcodeQ").getValue().toString();
            BigDecimal qty = new BigDecimal(billQtyStr);
            BigDecimal minPakegeQty = new BigDecimal(minPakegeQtyStr);
            if (minPakegeQty.abs().compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal barcodeTotalCount = qty.divide(minPakegeQty, 0, 0);
            row.getCell("barcodeTotalCount").setValue((Object)barcodeTotalCount);
            if (barcodeCountedMsgInfo.getTotalCount() == null) {
                barcodeCountedMsgInfo.setTotalCount(barcodeTotalCount);
            }
            BigDecimal barcodeCounted = barcodeCountedMsgInfo.getCounted().setScale(0);
            row.getCell("barcodeCounted").setValue((Object)barcodeCounted);
            if (row.getCell("barcodeTotalCount").getValue() == null) {
                row.getCell("barcodeTotalCount").setValue((Object)barcodeCountedMsgInfo.getTotalCount().setScale(0));
            }
            if ((barcodeUnCount = barcodeTotalCount.subtract(barcodeCounted).setScale(0)).compareTo(BigDecimal.ZERO) < 0) {
                barcodeUnCount = BigDecimal.ZERO;
            }
            row.getCell("barcodeUnCount").setValue((Object)barcodeUnCount);
        }
        this.tblBill.reLayoutAndPaint();
    }

    private Map<String, IndBarCodeCountMsgInfo> getBarcodeCount() {
        HashMap<String, IndBarCodeCountMsgInfo> countMsgMap = new HashMap<String, IndBarCodeCountMsgInfo>();
        int rowCount = this.tblBill.getRowCount();
        StringBuffer sbfStr = new StringBuffer();
        String entryID = null;
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblBill.getRow(i);
            if (row.getCell("entry.id").getValue() == null || row.getCell("id").getValue() == null) continue;
            entryID = !"1D0D80DD".equalsIgnoreCase(this.entity.getType().toString()) ? row.getCell("entry.id").getValue().toString() : row.getCell("id").getValue().toString();
            if (sbfStr.length() > 0) {
                sbfStr.append("','").append(entryID);
                continue;
            }
            sbfStr.append(entryID);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("billId"));
        sic.add(new SelectorItemInfo("totalCount"));
        sic.add(new SelectorItemInfo("counted"));
        sic.add(new SelectorItemInfo("unCount"));
        view.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billId", (Object)sbfStr.toString()));
        try {
            IndBarCodeCountMsgCollection barcodeCountMsgCol = IndBarCodeCountMsgFactory.getRemoteInstance().getIndBarCodeCountMsgCollection(view);
            int size = barcodeCountMsgCol.size();
            for (int i = 0; i < size; ++i) {
                IndBarCodeCountMsgInfo barcodeMsgInfo = barcodeCountMsgCol.get(i);
                String billID = barcodeMsgInfo.getBillId();
                if (countMsgMap.containsKey(billID)) continue;
                countMsgMap.put(billID, barcodeMsgInfo);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return countMsgMap;
    }

    private void showBarcodeGenMsg(BarcodeGenResult barcodesRslt, boolean fNoBarcodes) {
        String msg = null;
        StringBuffer allMsg = null;
        boolean fErr = false;
        if (fNoBarcodes) {
            msg = BarcodeClientUtils.getBarcodeResource("notBarcode");
            logger.error((Object)" no barcodes generated!!");
            fErr = true;
        }
        int status = barcodesRslt.getStatus();
        List<String> msgs = barcodesRslt.getMessages();
        if (status != 2 && msgs != null && msgs.size() > 0) {
            msg = msg == null ? BarcodeClientUtils.getBarcodeResource("barcodesRsltErroe") : msg;
            allMsg = new StringBuffer();
            int n = msgs.size();
            for (int i = 0; i < n; ++i) {
                allMsg.append(msgs.get(i));
                if (i + 1 >= n) continue;
                allMsg.append("\r\n");
            }
            logger.error((Object)(" barcodes msg: " + allMsg));
            fErr = true;
        }
        if (fErr) {
            if (allMsg != null) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)allMsg.toString(), (int)-1);
            } else {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, null, (int)-1);
            }
        } else if (status == 2) {
            this.setMessageText(BarcodeClientUtils.getBarcodeResource("repeateBarcode"));
            this.showMessage();
        }
    }

    private void setBarcodeAttrs(IRow row, String barcode, String qrcode, BarcodeDossierInfo dossierInfo) {
        row.getCell("barcode").setValue((Object)barcode);
        row.getCell("qrcode").setValue((Object)qrcode);
        row.getCell("select").setValue((Object)Boolean.FALSE);
        row.getCell("isPrint").setValue((Object)Boolean.FALSE);
        row.getCell("billNum").setValue((Object)dossierInfo.getSrcBillNumber());
        BarcodeDossierEntryCollection entries = dossierInfo.getEntrys();
        if (entries == null || entries.size() == 0) {
            logger.warn((Object)" the barcode doesnot has ext Attr");
            return;
        }
        int n = entries.size();
        for (int i = 0; i < n; ++i) {
            BarcodeDossierEntryInfo entryInfo = entries.get(i);
            String key = entryInfo.getDisplayName().getId().toString();
            String propVal = entryInfo.getValue();
            if ("assistID".equals(entryInfo.getName())) {
                this.arriKey = key;
            }
            if (StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)propVal)) continue;
            BarcodePrintHelper.setCellValue(row.getCell(key), propVal);
        }
    }

    private void setBarcodeAttrs(IRow row, String barcode, BarcodeDossierInfo dossierInfo) {
        this.setBarcodeAttrs(row, barcode, null, dossierInfo);
    }

    @Override
    public void actionTemplateDir_actionPerformed(ActionEvent e) throws Exception {
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setFileSelectionMode(1);
        if (this.selectedDir != null) {
            fileChooser.setSelectedFile(this.selectedDir);
        }
        int action = fileChooser.showOpenDialog((Component)((Object)this));
        File selectedNewDir = null;
        if (action == 0) {
            selectedNewDir = fileChooser.getSelectedFile();
            boolean fA = BarcodePrintConfig.TEMPLATE_FILTER.accept(selectedNewDir);
            logger.debug((Object)("has the lab files :" + fA));
            boolean fLoaded = this.loadPrintTemplates(selectedNewDir);
            if (!fLoaded) {
                MsgBox.showWarning((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("DirNoTemplates"));
                SysUtil.abort();
            } else {
                this.selectedDir = selectedNewDir;
                this.printConfig.saveTemplate(this.selectedDir);
            }
        }
    }

    private boolean loadPrintTemplates(File tmplDir) {
        if (tmplDir == null) {
            return false;
        }
        logger.debug((Object)("Load template file from :" + tmplDir));
        boolean fLoaded = false;
        ComboBoxModel comboModel = this.printConfig.getTemplatesComboModel(tmplDir);
        if (comboModel != null) {
            this.comboTemplate.setModel(comboModel);
            fLoaded = true;
        }
        return fLoaded;
    }

    @Override
    public void actionBarcodePrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblBarcode.getRowCount() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("selectGenBarcode"));
            logger.error((Object)"no barcodes are generated!!");
            return;
        }
        String templateFileName = this.getTemplateFileName();
        if (templateFileName == null) {
            MsgBox.showWarning((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("selectTemplates"));
            logger.error((Object)"no template is selected to print");
            return;
        }
        File tFile = new File(templateFileName);
        if (!tFile.exists()) {
            MsgBox.showWarning((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("notExistsTemplates"));
            logger.error((Object)"template file does not exists");
            return;
        }
        Integer oCount = this.numPrintCt.getIntegerValue();
        int count = oCount;
        if (count < 1) {
            MsgBox.showWarning((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("printCount"));
            logger.error((Object)"print count should > 0");
            return;
        }
        List<Map<String, String>> printBarcodes = this.getSelectedBarcodes(false);
        if (printBarcodes.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("selectPrintBarcode"));
            logger.error((Object)"no barcodes are selected to print");
            return;
        }
        String selTmplName = (String)this.comboTemplate.getSelectedItem();
        this.printConfig.saveTemplate(this.selectedDir, selTmplName);
        BarcodePrintUI prtUI = this;
        BarCodeBDPrint printer = new BarCodeBDPrint();
        BarCodePrintParam param = new BarCodePrintParam(this, templateFileName, count, printBarcodes, this.tblBarcode);
        printer.doPrint(param);
        this.fBarcodePrint = true;
    }

    private String getTemplateFileName() {
        String fName = null;
        if (this.selectedDir != null && this.comboTemplate.getSelectedItem() != null) {
            String name = (String)this.comboTemplate.getSelectedItem();
            fName = this.printConfig.getTemplateFileStr(this.selectedDir, name);
        }
        fName = "E:\\easspace\\barcode\\bartender\\test22.btw";
        return fName;
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        List<Map<String, String>> printBarcodes = this.getSelectedBarcodes(true);
        if (printBarcodes == null || printBarcodes.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("selectPrintBarcode"));
            logger.error((Object)"no barcodes are selected to print");
            return;
        }
        this.invokePrintFunction(e, false, printBarcodes);
    }

    protected void invokePrintFunction(ActionEvent e, boolean isPrint, List<Map<String, String>> idList) throws Exception {
        if (idList == null || idList.size() == 0) {
            return;
        }
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        HashMap<String, String> updatBarcodeMap = new HashMap<String, String>();
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            Map<String, String> barcodeMap = idList.get(i);
            String barcode = barcodeMap.get("Barcode");
            if (updatBarcodeMap.containsKey(barcode)) continue;
            updatBarcodeMap.put(barcode, barcodeMap.get(barcode));
            barcodeMap.remove(barcode);
        }
        BarcodeDataProvider mainQueryData = new BarcodeDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        BarcodePrintListener barcodePrintListener = new BarcodePrintListener(appHlp, this.entity.getType(), updatBarcodeMap, this.getTDFileName());
        appHlp.addKDNoteActionListener((IPrintActionListener)barcodePrintListener);
        if (isPrint) {
            appHlp.print(this.getTDFileName(), (Object)mainQueryData, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview(this.getTDFileName(), (Object)mainQueryData, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
        if (barcodePrintListener.getBarcodeMap() != null && barcodePrintListener.isPrint()) {
            Map<String, String> resultMap = barcodePrintListener.getBarcodeMap();
            for (String key : resultMap.keySet()) {
                String value = resultMap.get(key);
                IRow row = this.tblBarcode.getRow(Integer.valueOf(value).intValue());
                row.getCell("isPrint").setValue((Object)true);
                row.getCell("select").setValue((Object)false);
                row.getCell("select").getStyleAttributes().setLocked(true);
            }
        }
        this.tblBarcode.reLayoutAndPaint();
    }

    protected IMetaDataPK getTDQueryPK() {
        if (this.mainQueryPK != null) {
            return this.mainQueryPK;
        }
        return new MetaDataPK("com.kingdee.eas.barcode.scm.app.BarcodeTDPropertyPrint");
    }

    @Override
    public void actionPacageQty_actionPerformed(ActionEvent e) throws Exception {
        this.getPacageQty(false);
    }

    private void getPacageQty(boolean allSelected) throws BOSException {
        if (this.prmtStorageOrgUnit.getValue() == null) {
            return;
        }
        boolean fSel = false;
        boolean isSeleced = false;
        StringBuffer sbf = new StringBuffer();
        HashMap rowMaterialMap = new HashMap();
        int size = this.tblBill.getRowCount();
        for (int i = 0; i < size; ++i) {
            List<Integer> rowIndexList;
            IRow row = this.tblBill.getRow(i);
            fSel = allSelected ? true : Boolean.parseBoolean(row.getCell("select").getValue().toString());
            if (!fSel) continue;
            isSeleced = true;
            if (this.materialNumberStr == null || "".equals(this.materialNumberStr) || row.getCell(this.materialNumberStr) == null || row.getCell(this.materialNumberStr).getValue() == null) continue;
            String materialNumber = row.getCell(this.materialNumberStr).getValue().toString();
            if (sbf.length() > 0) {
                sbf.append(",").append(materialNumber);
            } else {
                sbf.append(materialNumber);
            }
            if (rowMaterialMap.containsKey(materialNumber)) {
                rowIndexList = (List)rowMaterialMap.get(materialNumber);
                rowIndexList.add(row.getRowIndex());
                rowMaterialMap.put(materialNumber, rowIndexList);
                continue;
            }
            rowIndexList = new ArrayList();
            rowIndexList.add(row.getRowIndex());
            rowMaterialMap.put(materialNumber, rowIndexList);
        }
        if (!isSeleced) {
            MsgBox.showWarning((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("selectPacageQty"));
            logger.error((Object)"no barcodes are selected to print");
            return;
        }
        if (sbf.length() == 0) {
            logger.error((Object)"no barcodes are selected to print");
            return;
        }
        StorageOrgUnitInfo orgUnitInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("qtyMinPackage"));
        view.getSelector().add(new SelectorItemInfo("material.id"));
        view.getSelector().add(new SelectorItemInfo("material.name"));
        view.getSelector().add(new SelectorItemInfo("material.number"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.number", (Object)sbf.toString(), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitInfo.getId(), CompareType.EQUALS));
        view.setFilter(filter);
        MaterialInventoryCollection inventoryCol = MaterialInventoryFactory.getRemoteInstance().getMaterialInventoryCollection(view);
        StringBuffer errorStr = new StringBuffer();
        int size2 = inventoryCol.size();
        for (int i = 0; i < size2; ++i) {
            MaterialInventoryInfo inventoryInfo = inventoryCol.get(i);
            String materialNumber = inventoryInfo.getMaterial().getNumber();
            if (!rowMaterialMap.containsKey(materialNumber)) continue;
            List rowIndexList = (List)rowMaterialMap.get(materialNumber);
            int m = rowIndexList.size();
            for (int j = 0; j < m; ++j) {
                int rowIndex = (Integer)rowIndexList.get(j);
                IRow row = this.tblBill.getRow(rowIndex);
                BigDecimal qtyMinPackage = inventoryInfo.getQtyMinPackage();
                if (qtyMinPackage == null || qtyMinPackage.compareTo(BigDecimal.ZERO) == 0) {
                    if (errorStr.length() > 0) {
                        errorStr.append(",").append(inventoryInfo.getMaterial().getName());
                        continue;
                    }
                    errorStr.append(inventoryInfo.getMaterial().getName());
                    continue;
                }
                row.getCell("barcodeQ").setValue((Object)qtyMinPackage);
                if (row.getCell(this.qtyStr) == null || row.getCell(this.qtyStr).getValue() == null) continue;
                BigDecimal qty = new BigDecimal(row.getCell(this.qtyStr).getValue().toString());
                row.getCell("barcodeCount").setValue((Object)qty.divide(qtyMinPackage, 0, 0).setScale(0));
            }
        }
        if (!allSelected) {
            if (inventoryCol.size() == 0) {
                MsgBox.showWarning((Component)((Object)this), (String)("\u3010" + sbf + "\u3011" + BarcodeClientUtils.getBarcodeResource("NOTPacageQty")));
                return;
            }
            if (errorStr.length() > 0) {
                MsgBox.showWarning((Component)((Object)this), (String)("\u3010" + errorStr + "\u3011" + BarcodeClientUtils.getBarcodeResource("NOTPacageQty")));
                return;
            }
        }
    }

    protected String getTDFileName() {
        return "/barcode";
    }

    private List<Map<String, String>> getSelectedBarcodes(boolean isTDPrint) {
        if (this.tblBarcode.getRowCount() == 0) {
            return null;
        }
        ArrayList<Map<String, String>> barcodes = new ArrayList<Map<String, String>>();
        IRow row = null;
        String colName = "select";
        boolean isRepeatPrint = false;
        try {
            IndubarodeParamsetInfo indParasetInfo = BarcodeClientUtils.getParamValue(null);
            isRepeatPrint = indParasetInfo.isRepeatPrint();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        int n = this.tblBarcode.getRowCount();
        for (int i = 0; i < n; ++i) {
            boolean fSelected;
            row = this.tblBarcode.getRow(i);
            if (row == null || row.getCell(colName) == null || row.getCell(colName).getValue() == null || !(fSelected = Boolean.parseBoolean(row.getCell(colName).getValue().toString()))) continue;
            boolean isPrint = Boolean.parseBoolean(row.getCell("isPrint").getValue().toString());
            if (isPrint) {
                if (!isRepeatPrint) continue;
                barcodes.add(this.getPrintBarcodeMap(row, isTDPrint));
                continue;
            }
            barcodes.add(this.getPrintBarcodeMap(row, isTDPrint));
        }
        return barcodes;
    }

    private Map<String, String> getPrintBarcodeMap(IRow row, boolean isTDPrint) {
        Object assistValue;
        LinkedHashMap<String, String> dMap = new LinkedHashMap<String, String>();
        String barCode = (String)row.getCell("barcode").getValue();
        dMap.put("Barcode", barCode);
        String qrcode = (String)row.getCell("qrcode").getValue();
        if (qrcode != null) {
            try {
                System.out.println("");
                String nreqr = BarcodeUtils.getQrCode(isTDPrint, qrcode, barCode);
                dMap.put("Qrcode", nreqr);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        String dKey = "f";
        int keyIdx = 1;
        Object cellVal = null;
        String baseUnitName = null;
        int index = -1;
        if (this.baseUnitStr != null && row.getCell(this.baseUnitStr) != null) {
            index = row.getCell(this.baseUnitStr).getColumnIndex();
            if (row.getCell(this.baseUnitStr).getValue() != null) {
                String unitNumber = row.getCell(this.baseUnitStr).getValue().toString();
                try {
                    MeasureUnitCollection unitCol = MeasureUnitFactory.getRemoteInstance().getMeasureUnitCollection("select name from where number='" + unitNumber + "'");
                    if (unitCol.size() > 0) {
                        baseUnitName = unitCol.get(0).getName();
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
        if (isTDPrint && this.currUIConfig != null) {
            List<BarcodeBillCustColInfo> custColInfoCol = this.currUIConfig.getCustCols();
            int size = custColInfoCol.size();
            for (int i = 0; i < size; ++i) {
                ICell cell;
                BarcodeBillCustColInfo custColInfo = custColInfoCol.get(i);
                if (custColInfo.getDtProprety() == null || "".equals(custColInfo.getDtProprety()) || (cell = row.getCell(custColInfo.getPropertyId())) == null) continue;
                Object obj = cell.getValue();
                if (index == cell.getColumnIndex() && baseUnitName != null) {
                    obj = baseUnitName;
                }
                if (obj != null && !"".equals(obj)) {
                    dMap.put(custColInfo.getDtProprety(), obj.toString());
                    continue;
                }
                if (custColInfo.getDtProprety() == null) continue;
                dMap.put(custColInfo.getDtProprety(), "");
            }
        } else {
            int n = this.tblBarcode.getColumnCount();
            for (int i = 3; i < n; ++i) {
                cellVal = row.getCell(i).getValue();
                if (row.getCell(i).getStyleAttributes().isHided()) continue;
                if (index == i && baseUnitName != null) {
                    cellVal = baseUnitName;
                }
                if (cellVal != null) {
                    dMap.put(dKey + keyIdx, cellVal.toString());
                } else {
                    dMap.put(dKey + keyIdx, " ");
                }
                ++keyIdx;
            }
        }
        if (!isTDPrint && row.getCell(this.arriKey) != null && (assistValue = row.getCell(this.arriKey).getValue()) != null) {
            this.setAssistMap(assistValue.toString(), dMap);
        }
        dMap.put(barCode, row.getRowIndex() + "");
        Object[] key = dMap.keySet().toArray();
        Arrays.sort(key);
        LinkedHashMap<String, String> newdMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < key.length; ++i) {
            newdMap.put(key[i].toString(), (String)dMap.get(key[i]));
        }
        return newdMap;
    }

    private void setAssistMap(String assistValue, Map<String, String> dMap) {
        try {
            AsstAttrValueInfo asstAttrValueInfo = AsstAttrValueFactory.getRemoteInstance().getAsstAttrValueInfo((IObjectPK)new ObjectUuidPK(assistValue));
            String valueName = asstAttrValueInfo.getName();
            String[] propArr = valueName.split("/");
            for (int i = 0; i < propArr.length; ++i) {
                if (i == 0) {
                    dMap.put("FZM001", propArr[0]);
                }
                if (i == 1) {
                    dMap.put("FZM002", propArr[1]);
                }
                if (i != 2) continue;
                dMap.put("FZM003", propArr[2]);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    protected List<Map<String, String>> getSamplePrintBarcodeMap() {
        ArrayList<Map<String, String>> barcodes = new ArrayList<Map<String, String>>();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("Barcode", "311.23-129");
        dataMap.put("f0", "311.23-129");
        dataMap.put("f1", "23-33-21133");
        dataMap.put("f2", "Nokia");
        dataMap.put("f3", "EMC");
        dataMap.put("f4", "Nokia Lumia 4100");
        dataMap.put("f5", "\u901a\u8fc7");
        dataMap.put("f6", "2013-11-23");
        dataMap.put("f7", "Arivil Emillie");
        dataMap.put("f8", "EMC");
        dataMap.put("f9", "Brad Pit");
        barcodes.add(dataMap);
        return barcodes;
    }

    public Map<String, EntityObjectInfo> getEntryEntityObjectMap() {
        return this.entryEntityObjectMap;
    }

    public void setEntryEntityObjectMap(Map<String, EntityObjectInfo> entryEntityObjectMap) {
        this.entryEntityObjectMap = entryEntityObjectMap;
    }

    public boolean destroyWindow() {
        String indBarcodeRuleID;
        String indBarcodeSetupID;
        String bosType;
        if (this.entity != null && !(bosType = this.entity.getType().toString()).equals(this.defaultBosType)) {
            ConfigServiceUtils.saveUserConfigData((String)"defaultEntity", (CoreUI)this, (String)bosType);
        }
        if (this.prmtIndBarcodeSetup.getValue() != null && !(indBarcodeSetupID = ((IndBarcodeSetupInfo)this.prmtIndBarcodeSetup.getValue()).getId().toString()).equals(this.defaultIndBarcodeSetup)) {
            ConfigServiceUtils.saveUserConfigData((String)"defaultIndBarcodeSetup", (CoreUI)this, (String)indBarcodeSetupID);
        }
        if (this.prmptRule.getValue() != null && !(indBarcodeRuleID = ((IndBarcodeRuleInfo)this.prmptRule.getValue()).getId().toString()).equals(this.defaultRule)) {
            ConfigServiceUtils.saveUserConfigData((String)"defaultRule", (CoreUI)this, (String)indBarcodeRuleID);
        }
        return super.destroyWindow();
    }

    private void setDefaultValue() {
        DataChangeEvent e;
        if (this.prmtEntity.getValue() == null && this.defaultBosType != null && !"null".equalsIgnoreCase(this.defaultBosType)) {
            try {
                EntityObjectInfo defaultEntity = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)this.defaultBosType));
                if (defaultEntity != null) {
                    this.entity = defaultEntity;
                    this.prmtEntity.setValue((Object)this.entity.getAlias());
                    e = new DataChangeEvent((Object)this.prmtIndBarcodeSetup);
                    e.setNewValue((Object)this.entity.getAlias());
                    this.prmtEntity_dataChanged(e);
                    if (this.entity != null) {
                        Object o = null;
                        try {
                            o = Class.forName(this.entity.getBusinessImplName()).newInstance();
                            this.isBaseData = o instanceof DataBase;
                        }
                        catch (Exception e1) {
                            this.handleException(e1);
                        }
                    }
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        if (this.prmtIndBarcodeSetup.getValue() == null && this.defaultIndBarcodeSetup != null && !"null".equalsIgnoreCase(this.defaultIndBarcodeSetup)) {
            try {
                IndBarcodeSetupInfo setupInfo = IndBarcodeSetupFactory.getRemoteInstance().getIndBarcodeSetupInfo((IObjectPK)new ObjectUuidPK(this.defaultIndBarcodeSetup));
                this.prmtIndBarcodeSetup.setValue((Object)setupInfo);
                e = new DataChangeEvent((Object)this.prmtIndBarcodeSetup);
                e.setNewValue(this.prmtIndBarcodeSetup.getValue());
                this.prmtIndBarcodeSetup_dataChanged(e);
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }
        if (this.prmptRule.getValue() == null && this.defaultIndBarcodeSetup != null && !"null".equalsIgnoreCase(this.defaultRule)) {
            try {
                IndBarcodeRuleInfo ruleInfo = IndBarcodeRuleFactory.getRemoteInstance().getIndBarcodeRuleInfo((IObjectPK)new ObjectUuidPK(this.defaultRule));
                this.prmptRule.setValue((Object)ruleInfo);
            }
            catch (Exception e4) {
                e4.printStackTrace();
            }
        }
    }

    private void countDueDate(IRow iRow) throws BOSException, ParseException {
        if (iRow.getCell(this.materialCode) != null && iRow.getCell(this.materialCode).getValue() != null && iRow.getCell(this.mgf) != null && iRow.getCell(this.mgf).getValue() != null) {
            String materialNumber = iRow.getCell(this.materialCode).getValue().toString();
            Date date = null;
            String expDate = "";
            if (iRow.getCell(this.mgf).getValue() instanceof Date) {
                date = (Date)iRow.getCell(this.mgf).getValue();
            } else {
                expDate = iRow.getCell(this.mgf).getValue().toString();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                if (!StringUtils.isEmpty((String)expDate)) {
                    date = sdf.parse(expDate);
                }
            }
            MaterialInventoryCollection materialInventoryColl = MaterialInventoryFactory.getRemoteInstance().getMaterialInventoryCollection(" where  material.number='" + materialNumber + "'  and  orgUnit='" + SysContext.getSysContext().getCurrentStorageUnit().getId() + "'");
            if (materialInventoryColl.size() > 0 && materialInventoryColl.get(0).isIsPeriodValid()) {
                int periodValid = materialInventoryColl.get(0).getPeriodValid();
                TimeUnitEnum periodValidUnit = materialInventoryColl.get(0).getPeriodValidUnit();
                Calendar d = Calendar.getInstance();
                d.setTime(date);
                d.set(2, d.get(2) + 1);
                if (periodValidUnit.getValue() == 1) {
                    d.add(1, periodValid);
                } else if (periodValidUnit.getValue() == 2) {
                    d.add(2, periodValid);
                } else if (periodValidUnit.getValue() == 3) {
                    d.add(5, periodValid);
                }
                iRow.getCell(this.exp).setValue((Object)d.getTime());
            }
        }
    }

    private void editStoped(KDTEditEvent e) {
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if ("\u751f\u4ea7\u65e5\u671f".equals(this.rowColIndexMap.get(colIndex))) {
            IRow iRow = this.tblBill.getRow(rowIndex);
            try {
                this.countDueDate(iRow);
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
            catch (ParseException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void deleteAndAddkDTEditListener() {
        if (this.kDTEditListener != null) {
            this.tblBill.removeKDTEditListener(this.kDTEditListener);
        }
        this.kDTEditListener = new KDTEditListener(){

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                BarcodePrintUI.this.editStoped(e);
            }

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editCanceled(KDTEditEvent e) {
            }
        };
        this.tblBill.addKDTEditListener(this.kDTEditListener);
    }

    private Object getPropVal(IObjectValue info, String propName, int index, MaterialInfo materialInfo, StringBuffer fullName) {
        Object propVal = null;
        String[] propArr = propName.split("\\.");
        for (int i = index; i < propArr.length; ++i) {
            String propNameAr = propArr[index];
            propVal = info.get(propNameAr);
            if (!(propVal instanceof IObjectValue)) continue;
            if (propVal instanceof MaterialInfo) {
                materialInfo = (MaterialInfo)propVal;
            }
            fullName.setLength(0);
            fullName.append(propVal.getClass().getName());
            propVal = this.getPropVal((IObjectValue)propVal, propName, ++i, fullName);
            break;
        }
        return propVal;
    }
}

