/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.eas.barcode.scm.client.OleAutomationInvoker;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;

public class BarcodePrinter
extends Composite {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.uw.client.BarcodePrinter");
    private static final String PROG_ID = "Lppx2.Application";
    private OleFrame myFrame = null;
    private OleControlSite controlSite = null;
    private OleAutomation automation = null;
    private int count;
    private List<Map<String, String>> printBarcodes;
    private String templateFileName;

    public BarcodePrinter(Composite parent) {
        super(parent, 0);
        this.myFrame = new OleFrame(parent, 0);
        this.controlSite = new OleControlSite((Composite)this.myFrame, 0, PROG_ID);
        this.controlSite.doVerb(-1);
        this.automation = new OleAutomation((OleClientSite)this.controlSite);
    }

    public static BarcodePrinter getInstance() {
        return null;
    }

    public String getTemplateFileName() {
        return this.templateFileName;
    }

    public void setTemplateFileName(String templateFileName) {
        this.templateFileName = templateFileName;
    }

    public List<Map<String, String>> getPrintBarcodes() {
        return this.printBarcodes;
    }

    public void setPrintBarcodes(List<Map<String, String>> printBarcodes) {
        this.printBarcodes = printBarcodes;
    }

    public OleAutomation getOaAppActiveDoc() {
        String templatePath;
        File templateFile = new File(this.templateFileName);
        if (!templateFile.canRead()) {
            logger.error((Object)(this.templateFileName + " is not exists or cannot read it"));
            return null;
        }
        OleAutomation oDocs = null;
        Variant vFile = null;
        Variant vDocuments = OleAutomationInvoker.invoke(this.automation, "Documents");
        oDocs = vDocuments.getAutomation();
        if (OleAutomationInvoker.invoke(oDocs, "Open", vFile = new Variant(templatePath = templateFile.getAbsolutePath())) == null) {
            logger.error((Object)(templatePath + " is not opened"));
            return null;
        }
        logger.debug((Object)(this.templateFileName + " is opened"));
        Variant vActiveDoc = OleAutomationInvoker.invoke(this.automation, "ActiveDocument");
        OleAutomation oaAppActiveDoc = vActiveDoc.getAutomation();
        return oaAppActiveDoc;
    }

    public int getPerCount() {
        Variant vDocFormat = OleAutomationInvoker.invoke(this.getOaAppActiveDoc(), "Format");
        OleAutomation oaDocFormat = vDocFormat.getAutomation();
        long columnCount = OleAutomationInvoker.invoke(oaDocFormat, "ColumnCount").getInt();
        long rowCount = OleAutomationInvoker.invoke(oaDocFormat, "RowCount").getInt();
        long perCount = columnCount * rowCount;
        return Integer.valueOf(Long.toString(perCount));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int print(Map<String, String> dataMap, boolean isFormFeed) {
        File templateFile;
        int rtnVal;
        boolean fOpened;
        Variant vFile;
        OleAutomation oDocs;
        block8: {
            oDocs = null;
            vFile = null;
            fOpened = false;
            rtnVal = 0;
            templateFile = new File(this.getTemplateFileName());
            if (templateFile.canRead()) break block8;
            logger.error((Object)(this.getTemplateFileName() + " is not exists or cannot read it"));
            int n = -1;
            return n;
        }
        Variant vDocuments = OleAutomationInvoker.invoke(this.automation, "Documents");
        oDocs = vDocuments.getAutomation();
        String templatePath = templateFile.getAbsolutePath();
        vFile = new Variant(templatePath);
        if (OleAutomationInvoker.invoke(oDocs, "Open", vFile) == null) {
            logger.error((Object)(templatePath + " is not opened"));
            int n = -1;
            return n;
        }
        fOpened = true;
        try {
            OleAutomation oaAppActiveDoc = this.getOaAppActiveDoc();
            Variant vDocVariables = OleAutomationInvoker.invoke(oaAppActiveDoc, "Variables");
            OleAutomation oaDocVars = vDocVariables.getAutomation();
            logger.debug((Object)"set template variables");
            boolean fSuccess = this.setupVariables(oaDocVars, dataMap);
            OleAutomationInvoker.invoke(oaAppActiveDoc, "PrintLabel", new Variant(1));
            if (isFormFeed) {
                OleAutomationInvoker.invoke(oaAppActiveDoc, "FormFeed");
                this.disposeResouces(oDocs, vFile, fOpened);
            }
            logger.debug((Object)"Print OK");
        }
        catch (Exception e) {
            rtnVal = -3;
            logger.error((Object)("exception when print barcode, " + e.getMessage()));
            this.disposeResouces(oDocs, vFile, fOpened);
        }
        return rtnVal;
    }

    private void disposeResouces(OleAutomation oDocs, Variant vFile, boolean fOpened) {
        try {
            if (fOpened && oDocs != null) {
                OleAutomationInvoker.invoke(oDocs, "CloseAllDocuments", vFile);
            }
            OleAutomationInvoker.invoke(this.automation, "Quit");
        }
        catch (Exception e) {
            logger.error((Object)("exception, dispose Variant file " + e.getMessage()));
        }
        try {
            this.automation.dispose();
        }
        catch (Exception e) {
            logger.error((Object)("exception, dispose automation " + e.getMessage()));
        }
        try {
            this.controlSite.dispose();
        }
        catch (Exception e) {
            logger.error((Object)("exception, dispose controlSite " + e.getMessage()));
        }
        try {
            this.myFrame.dispose();
        }
        catch (Exception e) {
            logger.error((Object)("exception, dispose myFrame " + e.getMessage()));
        }
        this.automation = null;
        this.controlSite = null;
        this.myFrame = null;
    }

    private boolean setupVariables(OleAutomation oaDocVars, Map<String, String> dataMap) {
        boolean fSuccess = true;
        Set<String> keys = dataMap.keySet();
        Iterator<String> it = keys.iterator();
        Variant vDocVar = null;
        String key = null;
        String val = null;
        while (it.hasNext()) {
            key = it.next();
            val = dataMap.get(key);
            try {
                vDocVar = OleAutomationInvoker.invoke(oaDocVars, "Item", new Variant(key));
                if (vDocVar == null) continue;
                OleAutomationInvoker.invoke(vDocVar.getAutomation(), "Value", new Variant(val));
            }
            catch (SWTException e) {
                logger.error((Object)("template, no variable with name " + key));
                fSuccess = false;
            }
        }
        return fSuccess;
    }
}

