/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFilterTextField;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.barcode.scm.BarcodeRuleEntryInfo;
import com.kingdee.eas.barcode.scm.BarcodeRuleFactory;
import com.kingdee.eas.barcode.scm.BarcodeRuleInfo;
import com.kingdee.eas.barcode.scm.BarcodeRuleXML;
import com.kingdee.eas.barcode.scm.BarcodeRuleXMLDetail;
import com.kingdee.eas.barcode.scm.BarcodeTypeCollection;
import com.kingdee.eas.barcode.scm.BarcodeTypeFactory;
import com.kingdee.eas.barcode.scm.BarcodeTypeInfo;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.BarcodeXMLHelper;
import com.kingdee.eas.barcode.scm.StatusEnum;
import com.kingdee.eas.barcode.scm.client.AbstractBarcodeRuleEditUI;
import com.kingdee.eas.barcode.scm.client.BarcodeClientUtils;
import com.kingdee.eas.barcode.scm.client.SelectEntityUI;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.client.OrgF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.CtrlF7;
import com.kingdee.eas.basedata.org.client.f7.OrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class BarcodeRuleEditUI
extends AbstractBarcodeRuleEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BarcodeRuleEditUI.class);
    protected IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(null);
    protected CtrlUnitInfo currentCtrlUnit = SysContext.getSysContext().getCurrentCtrlUnit();
    protected EntityObjectInfo entity;
    protected Action actionTable;
    protected KDWorkButton btnAddLine = null;
    protected KDWorkButton btnInsertLine = null;
    protected KDWorkButton btnRemoveLine = null;
    public static final String TB_STARTSWITH = "startsWith";
    public static final String TB_ENDSWITH = "endsWith";
    public static final String TB_PROPERTYALIAS = "propertyAlias";
    public static final String TB_PROPERTY = "property";
    public static final String TB_FORMAT = "format";
    public static final String TB_BARCODEDICT = "barcodeDict";
    public static final String TB_REMARK = "remark";
    public static final String TB_PROPERTYBOSTYPE = "propertyBosType";
    public static final String TB_ISMACHTITEM = "isMatchItem";
    public static final String TB_SEGMENTLOCATION = "segmentLocation";

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.actionSave.setVisible(false);
        this.actionEntityF7.setEnabled(true);
        this.comboStatus.setEnabled(false);
        this.actionCancel.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.actionCancelCancel.setEnabled(true);
        this.btnCancelCancel.setEnabled(true);
        this.menuSubmitOption.setVisible(false);
        this.rMenuItemSubmitAndPrint.setVisible(false);
        this.prmtEntity.setSelector((KDPromptSelector)new KDPromptBox.DefaultSelector());
        this.prmtEntity.setReadOnly(false);
        this.prmtEntity.setEditable(true);
        this.prmtEntity.setRequired(true);
        this.txtLength.setDataType(0);
        this.txtLength.setPrecision(0);
        this.txtLength.setValue((Object)1);
        this.txtLength.setMaximumValue((Comparable)Integer.valueOf(99999));
        this.txtLength.setGroupingUsed(false);
        this.txtLength.setSupportedEmpty(true);
        this.txtSegmentNum.setDataType(0);
        this.txtSegmentNum.setPrecision(0);
        this.txtSegmentNum.setValue((Object)1);
        this.txtSegmentNum.setMaximumValue((Comparable)Integer.valueOf(999));
        this.txtSegmentNum.setGroupingUsed(false);
        this.txtSegmentNum.setSupportedEmpty(true);
        this.txtSegmentSeparators.setMaxLength(5);
        this.prmtBarcodeType.setEnabled(false);
        CtrlF7 ctrlF7 = new CtrlF7();
        ctrlF7.setIsCUFilter(false);
        ctrlF7.setContainSealUp(true);
        ctrlF7.setCumulate(false);
        ctrlF7.setPermissionItem("barcodeRule_view");
        this.prmtAdminCU.setSelector((KDPromptSelector)ctrlF7);
        OrgUnitFilterInfoProducer producer = new OrgUnitFilterInfoProducer((OrgF7PromptDialog)ctrlF7);
        this.prmtAdminCU.setFilterInfoProducer((IFilterInfoProducer)producer);
        this.actionTable = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BarcodeRuleEditUI.this.getDetailTable() != null) {
                    BarcodeRuleEditUI.this.getDetailTable().removeRow(BarcodeRuleEditUI.this.getDetailTable().getRowCount() - 1);
                    try {
                        BarcodeRuleEditUI.this.actionAddLine_actionPerformed(null);
                    }
                    catch (Exception e1) {
                        BarcodeRuleEditUI.this.handleException(e1);
                    }
                }
            }
        };
        this.actionAddLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnAddLine = (KDWorkButton)this.kDContainer1.add((Action)((Object)this.actionAddLine));
        this.btnAddLine.setText(null);
        this.btnAddLine.setSize(new Dimension(22, 19));
        this.btnAddLine.setEnabled(true);
        this.actionInsertLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnInsertLine = (KDWorkButton)this.kDContainer1.add((Action)((Object)this.actionInsertLine));
        this.btnInsertLine.setText(null);
        this.btnInsertLine.setSize(new Dimension(22, 19));
        this.btnInsertLine.setEnabled(true);
        this.actionRemoveLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnRemoveLine = (KDWorkButton)this.kDContainer1.add((Action)((Object)this.actionRemoveLine));
        this.btnRemoveLine.setText(null);
        this.btnRemoveLine.setSize(new Dimension(22, 19));
        this.btnRemoveLine.setEnabled(true);
        this.prmtEntity.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    BarcodeRuleEditUI.this.actionEntityF7_actionPerformed(null);
                }
                catch (Exception e1) {
                    BarcodeRuleEditUI.this.handleException(e1);
                }
            }
        });
        this.prmtEntity.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    BarcodeRuleEditUI.this.prmtEntity_dataChanged(e);
                }
                catch (Exception e1) {
                    BarcodeRuleEditUI.this.handleException(e1);
                }
            }
        });
        this.chkRuleSegment.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BarcodeRuleEditUI.this.chkRuleSegment_Changed(e);
            }
        });
        this.prmtBarcodeType.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                BarcodeRuleEditUI.this.prmtBarcodeType_Changed(e);
            }
        });
    }

    public void prmtEntity_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() == null && e.getOldValue() != null) {
            int flag;
            if (this.kdtDetails.getRowCount() > 0 && (flag = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"112_BarcodeDictEditUI"))) == 2) {
                this.prmtEntity.setValue(e.getOldValue());
                return;
            }
            this.clearDetailsProperty();
            this.entity = null;
            this.prmtEntity.setText(null);
            this.initDetailF7();
            this.initEntry();
            this.kdtDetails.removeRows();
        }
    }

    protected void prmtBarcodeType_Changed(DataChangeEvent e) {
        if (this.isPackageType()) {
            this.kdtDetails.removeRows();
            this.kdtDetails.getStyleAttributes().setLocked(true);
            this.txtSegmentNum.setValue((Object)0);
            this.txtSegmentNum.setEnabled(false);
        } else {
            this.kdtDetails.getStyleAttributes().setLocked(false);
            this.txtSegmentNum.setEnabled(true);
        }
    }

    protected void chkRuleSegment_Changed(ChangeEvent e) {
        if (this.chkRuleSegment.isSelected()) {
            this.contSegmentNum.setVisible(true);
            this.txtSegmentNum.setRequired(true);
            this.contSegmentSeparators.setVisible(true);
            this.txtSegmentSeparators.setRequired(true);
            this.kdtDetails.getColumn(TB_STARTSWITH).getStyleAttributes().setHided(true);
            this.kdtDetails.getColumn(TB_ENDSWITH).getStyleAttributes().setHided(true);
            this.kdtDetails.getColumn(TB_SEGMENTLOCATION).getStyleAttributes().setHided(false);
            this.contLength.setVisible(false);
            this.txtLength.setRequired(false);
        } else {
            this.contSegmentNum.setVisible(false);
            this.txtSegmentNum.setRequired(false);
            this.contSegmentSeparators.setVisible(false);
            this.txtSegmentSeparators.setRequired(false);
            this.kdtDetails.getColumn(TB_STARTSWITH).getStyleAttributes().setHided(false);
            this.kdtDetails.getColumn(TB_ENDSWITH).getStyleAttributes().setHided(false);
            this.kdtDetails.getColumn(TB_SEGMENTLOCATION).getStyleAttributes().setHided(true);
            this.contLength.setVisible(true);
            this.txtLength.setRequired(true);
        }
    }

    protected void tableValue_Changed(KDTEditEvent e) {
        int currLength;
        if (e.getValue() != null && e.getValue().equals(e.getOldValue()) || e.getValue() == null && e.getOldValue() == null) {
            return;
        }
        int rowIndex = e.getRowIndex();
        int columnIndex = e.getColIndex();
        if (this.chkRuleSegment.isSelected()) {
            int currLength2;
            if (columnIndex == this.kdtDetails.getColumnIndex(TB_SEGMENTLOCATION) && (currLength2 = this.getIntValue(this.kdtDetails.getCell(rowIndex, columnIndex))) > this.txtSegmentNum.getIntegerValue()) {
                this.txtSegmentNum.setValue((Object)currLength2);
            }
        } else if (columnIndex == this.kdtDetails.getColumnIndex(TB_ENDSWITH) && (currLength = this.getIntValue(this.kdtDetails.getCell(rowIndex, columnIndex))) > this.txtLength.getIntegerValue()) {
            this.txtLength.setValue((Object)currLength);
        }
    }

    @Override
    public void loadFields() {
        this.initUserConfig();
        super.loadFields();
        this.prmtEntity.setEditable(false);
        if (this.prmtAdminCU.getValue() == null) {
            this.prmtAdminCU.setValue((Object)this.currentCtrlUnit);
        }
        if (this.editData != null && this.editData.getEntityBosType() != null) {
            this.entity = this.loader.getEntity(BOSObjectType.create((String)this.editData.getEntityBosType()));
        }
        this.initDetails();
        this.initDetailF7();
        this.chkRuleSegment_Changed(null);
        this.prmtBarcodeType_Changed(null);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.actionCancel.setEnabled(false);
            this.actionCancelCancel.setEnabled(false);
            this.prmtEntity.setEnabled(true);
            this.initTableKeyStroke(this.getDetailTable(), true);
            this.btnAddLine.setEnabled(true);
            this.btnInsertLine.setEnabled(true);
            this.btnRemoveLine.setEnabled(true);
            this.prmtBarcodeType.setEnabled(true);
        } else if (this.getOprtState().equals(OprtState.EDIT)) {
            this.actionCancel.setEnabled(true);
            this.actionCancelCancel.setEnabled(true);
            this.prmtEntity.setEnabled(true);
            this.initTableKeyStroke(this.getDetailTable(), true);
            this.btnAddLine.setEnabled(true);
            this.btnInsertLine.setEnabled(true);
            this.btnRemoveLine.setEnabled(true);
            this.prmtBarcodeType.setEnabled(true);
        } else if (this.getOprtState().equals(OprtState.VIEW)) {
            this.actionCancel.setEnabled(true);
            this.actionCancelCancel.setEnabled(true);
            this.prmtEntity.setEnabled(false);
            KDTableHelper.updateEnterWithTab((KDTable)this.getDetailTable(), (boolean)false, null);
            KDTableHelper.downArrowAutoAddRow((KDTable)this.getDetailTable(), (boolean)false, null);
            this.btnAddLine.setEnabled(false);
            this.btnInsertLine.setEnabled(false);
            this.btnRemoveLine.setEnabled(false);
            this.prmtBarcodeType.setEnabled(false);
        }
    }

    protected void initTableKeyStroke(KDTable table, boolean isDownArrow) {
        KDTableHelper.updateEnterWithTab((KDTable)table, (boolean)true, (Action)this.actionTable);
        if (isDownArrow) {
            KDTableHelper.downArrowAutoAddRow((KDTable)table, (boolean)true, (Action)this.actionTable);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection coll = super.getSelectors();
        coll.add(new SelectorItemInfo("*"));
        coll.add(new SelectorItemInfo("barcodeType.*"));
        coll.add(new SelectorItemInfo("detailsXML"));
        return coll;
    }

    public void initDetails() {
        KDBizPromptBox barcodeDict_PromptBox = new KDBizPromptBox();
        barcodeDict_PromptBox.setVisible(true);
        barcodeDict_PromptBox.setEditable(true);
        barcodeDict_PromptBox.setDisplayFormat("$number$");
        barcodeDict_PromptBox.setEditFormat("$number$");
        barcodeDict_PromptBox.setCommitFormat("$number$");
        barcodeDict_PromptBox.setQueryInfo("com.kingdee.eas.barcode.scm.app.BarcodeDictQuery");
        KDTDefaultCellEditor object_CellEditor = new KDTDefaultCellEditor((IKDEditor)barcodeDict_PromptBox);
        this.kdtDetails.getColumn(TB_BARCODEDICT).setEditor((ICellEditor)object_CellEditor);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtDetails.getColumn(TB_BARCODEDICT).setRenderer((IBasicRender)avr);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
        ev.setFilter(filter);
        barcodeDict_PromptBox.setEntityViewInfo(ev);
        KDFormattedTextField numTxtField = new KDFormattedTextField();
        numTxtField.setPrecision(0);
        numTxtField.setDataType(0);
        numTxtField.setValue((Object)0);
        numTxtField.setMaximumValue((Comparable)Integer.valueOf(99999));
        numTxtField.setSupportedEmpty(true);
        this.kdtDetails.getColumn(TB_STARTSWITH).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)numTxtField));
        this.kdtDetails.getColumn(TB_ENDSWITH).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)numTxtField));
        this.kdtDetails.getColumn(TB_SEGMENTLOCATION).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)numTxtField));
        this.kdtDetails.getColumn(TB_FORMAT).getStyleAttributes().setLocked(true);
        this.kdtDetails.getColumn(TB_FORMAT).getStyleAttributes().setBackground(BarcodeClientUtils.lockedColor);
        for (int i = 0; i < this.kdtDetails.getRowCount(); ++i) {
            String property;
            IRow row = this.kdtDetails.getRow(i);
            if (this.entity == null || (property = (String)row.getCell(TB_PROPERTY).getValue()) == null) continue;
            String fullAlias = (String)row.getCell(TB_PROPERTYALIAS).getValue();
            String linBosType = (String)row.getCell(TB_PROPERTYBOSTYPE).getValue();
            PropertyInfo propertyInfo = BarcodeUtils.getPropertyByMuch(property, this.entity);
            if (propertyInfo == null) continue;
            propertyInfo.put("fullName", (Object)property);
            propertyInfo.put("fullAlias", (Object)fullAlias);
            propertyInfo.put("linkedBosType", (Object)linBosType);
            this.propertyChanged(i, propertyInfo);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        this.initEntry();
    }

    @Override
    public void storeFields() {
        if (this.txtNumber.getText() != null) {
            this.txtNumber.setText(this.txtNumber.getText().trim());
        }
        if (this.txtName.getText() != null) {
            this.txtName.setText(this.txtName.getText().trim());
        }
        super.storeFields();
        this.editData.setDetailsXML(this.buildDetailsXML(this.editData));
    }

    protected String buildDetailsXML(BarcodeRuleInfo info) {
        BarcodeRuleXML xmlInfo = null;
        xmlInfo = info.getDetailsXML() != null ? BarcodeXMLHelper.toBarcodeRuleXMLInfo(info.getDetailsXML()) : new BarcodeRuleXML();
        xmlInfo.setBarcodeType(info.getBarcodeType().getBarcodeType().getValue());
        xmlInfo.setLength(info.getLength());
        xmlInfo.setStatus(info.getStatus().getValue());
        xmlInfo.setEntityBosType(info.getEntityBosType());
        xmlInfo.setEntityAlias(info.getEntityAlias());
        xmlInfo.setUseFlag(info.isIsUseFlag());
        xmlInfo.setCumsumQty(info.isIsCumsumQty());
        xmlInfo.setBarcoeRepeat(info.isIsBarcoeRepeat());
        xmlInfo.setRuleSegment(info.isRuleSegment());
        xmlInfo.setSegmentNum(info.getSegmentNum());
        xmlInfo.setSeparators(info.getSeparators());
        xmlInfo.setPattern(info.getPattern());
        xmlInfo.getDetails().clear();
        Map<String, EntityObjectInfo> mapEntity = BarcodeUtils.getEntryName(this.entity);
        EntityObjectInfo entryEntity = null;
        for (int i = 0; i < info.getDetails().size(); ++i) {
            BarcodeRuleEntryInfo entryInfo = info.getDetails().get(i);
            BarcodeRuleXMLDetail detail = new BarcodeRuleXMLDetail();
            detail.setStartsWith(entryInfo.getStartsWith());
            detail.setEndsWith(entryInfo.getEndsWith());
            detail.setProperty(entryInfo.getProperty());
            detail.setFormat(entryInfo.getFormat());
            detail.setPropertyBosType(entryInfo.getPropertyBosType());
            detail.setPropertyAlias(entryInfo.getPropertyAlias());
            detail.setMatchItem(entryInfo.isIsMatchItem());
            detail.setSegmentLocation(entryInfo.getSegmentLocation());
            PropertyInfo propertyInfo = this.entity.getPropertyByName(entryInfo.getProperty());
            if (propertyInfo != null) {
                if (propertyInfo instanceof LinkPropertyInfo) {
                    detail.setAttributes(propertyInfo.getName() + "_number");
                } else {
                    detail.setAttributes(propertyInfo.getName());
                }
            } else {
                for (String key : entryInfo.getProperty().split("\\.")) {
                    if (mapEntity.containsKey(key)) {
                        if (entryEntity != null) continue;
                        entryEntity = mapEntity.get(key);
                        continue;
                    }
                    propertyInfo = entryEntity.getPropertyByName(key);
                    if (propertyInfo instanceof LinkPropertyInfo) {
                        detail.setAttributes(propertyInfo.getName() + "_number");
                        continue;
                    }
                    detail.setAttributes(entryInfo.getProperty());
                }
            }
            xmlInfo.addDetail(detail);
        }
        return BarcodeXMLHelper.barcodeRuleXMLInfoToXML(xmlInfo);
    }

    protected IObjectValue createNewData() {
        this.entity = null;
        BarcodeRuleInfo info = new BarcodeRuleInfo();
        info.setStatus(StatusEnum.SAVED);
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setLength(1);
        info.setBarcodeType(this.getDefaultBarcodeType());
        return info;
    }

    protected BarcodeTypeInfo getDefaultBarcodeType() {
        try {
            BarcodeTypeCollection coll = BarcodeTypeFactory.getRemoteInstance().getBarcodeTypeCollection("where barcodeType=0 order by number");
            if (coll != null && coll.size() > 0) {
                return coll.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BarcodeRuleFactory.getRemoteInstance();
    }

    @Override
    public void actionEntityF7_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("selectBizType", "bizbill");
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SelectEntityUI.class.getName(), (Map)uiContext);
        }
        catch (UIException e1) {
            e1.printStackTrace();
            this.handleException((Exception)((Object)e1));
        }
        SelectEntityUI ui = (SelectEntityUI)uiWindow.getUIObject();
        uiWindow.show();
        if (!ui.isCancel) {
            if (this.kdtDetails.getRowCount() > 0) {
                int flag = 0;
                if (this.entity != null && !((EntityObjectInfo)ui.getReturnObject()).getType().equals((Object)this.entity.getType()) && (flag = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"112_BarcodeDictEditUI"))) == 2) {
                    return;
                }
            }
            this.clearDetailsProperty();
            this.entity = (EntityObjectInfo)ui.getReturnObject();
            this.prmtEntity.setText(this.entity.getAlias());
            this.initDetailF7();
            this.initEntry();
        }
    }

    protected void clearDetailsProperty() {
        for (int i = 0; i < this.kdtDetails.getRowCount(); ++i) {
            IRow row = this.kdtDetails.getRow(i);
            row.getCell(TB_PROPERTY).setValue(null);
            row.getCell(TB_PROPERTYALIAS).setValue(null);
            row.getCell(TB_PROPERTYBOSTYPE).setValue(null);
            row.getCell(TB_FORMAT).getStyleAttributes().setLocked(true);
            row.getCell(TB_FORMAT).setEditor(null);
            row.getCell(TB_FORMAT).setValue(null);
            row.getCell(TB_FORMAT).getStyleAttributes().setBackground(BarcodeClientUtils.lockedColor);
        }
    }

    protected void initDetailF7() {
        if (this.entity != null) {
            this.prmtEntity.setText(this.entity.getAlias());
            this.editData.setEntityAlias(this.entity.getAlias());
            this.editData.setEntityBosType(this.entity.getType().toString());
            this.kdtDetails.getColumn(TB_PROPERTYALIAS).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.initPropertyEditor(this.kdtDetails)));
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtDetails.getStyleAttributes().isLocked()) {
            return;
        }
        if (this.entity == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"128_BarcodeRuleEditUI"));
            return;
        }
        IRow row = this.kdtDetails.addRow();
        this.afterAddLine(row);
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.entity == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"128_BarcodeRuleEditUI"));
            return;
        }
        this.insertLine(this.kdtDetails);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        this.removeLine(this.kdtDetails);
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getStyleAttributes().isLocked()) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                table.removeRow(rowIndex);
            }
            if (table.getRow(0) != null) {
                table.getSelectManager().select(0, 0);
            }
        }
    }

    protected void insertLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getStyleAttributes().isLocked()) {
            return;
        }
        IRow row = null;
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            row = this.isTableColumnSelected(table) ? table.addRow() : table.addRow(top);
        } else {
            row = table.addRow();
        }
        this.afterAddLine(row);
    }

    protected int getIntValue(KDFormattedTextField kdtxt) {
        int result = 0;
        try {
            result = kdtxt.getIntegerValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected int getIntValue(ICell cell) {
        int result = 0;
        try {
            result = Integer.parseInt(cell.getValue().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected void afterAddLine(IRow row) {
        IRow preRow = this.kdtDetails.getRow(row.getRowIndex() - 1);
        int startsWith = 1;
        int segmentLocation = 1;
        if (preRow != null) {
            int preEnd = Integer.parseInt(preRow.getCell(TB_ENDSWITH).getValue().toString());
            int preSegmentLocation = Integer.parseInt(preRow.getCell(TB_SEGMENTLOCATION).getValue().toString());
            startsWith = preEnd + 1;
            segmentLocation = preSegmentLocation + 1;
        }
        row.getCell(TB_STARTSWITH).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell(TB_ENDSWITH).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell(TB_SEGMENTLOCATION).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell(TB_STARTSWITH).setValue((Object)startsWith);
        row.getCell(TB_ENDSWITH).setValue((Object)startsWith);
        row.getCell(TB_SEGMENTLOCATION).setValue((Object)segmentLocation);
        row.getCell(TB_ISMACHTITEM).setValue((Object)false);
        if (startsWith > this.getIntValue(this.txtLength)) {
            this.txtLength.setValue((Object)startsWith);
        }
        if (segmentLocation > this.getIntValue(this.txtSegmentNum)) {
            this.txtSegmentNum.setValue((Object)segmentLocation);
        }
    }

    protected final boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected KDPromptBox initPropertyEditor(final KDTable table) {
        KDBizPromptBox f7Box = new KDBizPromptBox();
        f7Box.setSelector((KDPromptSelector)new KDPromptBox.DefaultSelector());
        f7Box.setAccessAuthority(1);
        f7Box.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                int colIndex;
                int rowIndex = table.getEditManager().getEditRowIndex();
                PropertyInfo property = BarcodeRuleEditUI.this.selectProperty(rowIndex, colIndex = table.getEditManager().getEditColIndex());
                if (property != null) {
                    BarcodeRuleEditUI.this.propertyChanged(rowIndex, property);
                }
            }
        });
        f7Box.setReadOnly(false);
        f7Box.setEditable(true);
        return f7Box;
    }

    @Override
    protected void kdtDetails_editStopped(KDTEditEvent e) throws Exception {
        int currLength;
        int rowIndex = e.getRowIndex();
        int columnIndex = e.getColIndex();
        ICell formatCell = this.kdtDetails.getCell(rowIndex, TB_FORMAT);
        String dataType = null;
        if (formatCell.getEditor() != null) {
            if (formatCell.getEditor().getComponent() instanceof KDFilterTextField) {
                dataType = "BigDecimal";
            } else if (formatCell.getEditor().getComponent() instanceof KDComboBox) {
                dataType = "Date";
            }
        }
        if (columnIndex == this.kdtDetails.getColumnIndex(TB_PROPERTYALIAS)) {
            if (dataType != null) {
                if ("BigDecimal".equals(dataType)) {
                    this.kdtDetails.getCell(rowIndex, TB_FORMAT).setValue((Object)new BigDecimal("1000.00"));
                } else if ("Date".equals(dataType)) {
                    this.kdtDetails.getCell(rowIndex, TB_FORMAT).setValue(((KDComboBox)formatCell.getEditor().getComponent()).getItemAt(0));
                }
            } else {
                this.kdtDetails.getCell(rowIndex, TB_FORMAT).setValue(null);
                this.kdtDetails.getCell(rowIndex, TB_FORMAT).setEditor(null);
            }
            if (this.kdtDetails.getCell(rowIndex, TB_PROPERTYALIAS).getValue() == null) {
                this.kdtDetails.getCell(rowIndex, TB_FORMAT).setValue(null);
                this.kdtDetails.getCell(rowIndex, TB_FORMAT).setEditor(null);
            }
        } else if (columnIndex == this.kdtDetails.getColumnIndex(TB_FORMAT)) {
            if ("BigDecimal".equals(dataType)) {
                Object o = this.kdtDetails.getCell(rowIndex, columnIndex).getValue();
                if (o != null && !o.toString().equals("")) {
                    int endInd;
                    int startInd = o.toString().indexOf(".");
                    if (startInd != (endInd = o.toString().lastIndexOf("."))) {
                        this.kdtDetails.getCell(rowIndex, columnIndex).setValue(e.getOldValue());
                    } else if (startInd == 0) {
                        this.kdtDetails.getCell(rowIndex, columnIndex).setValue((Object)("0" + o.toString()));
                    }
                } else {
                    this.kdtDetails.getCell(rowIndex, TB_FORMAT).setValue(e.getOldValue());
                }
            }
        } else if (columnIndex == this.kdtDetails.getColumnIndex(TB_SEGMENTLOCATION)) {
            int currLength2;
            if (this.chkRuleSegment.isSelected() && (currLength2 = this.getIntValue(this.kdtDetails.getCell(rowIndex, columnIndex))) > this.txtSegmentNum.getIntegerValue()) {
                this.txtSegmentNum.setValue((Object)currLength2);
            }
        } else if (columnIndex == this.kdtDetails.getColumnIndex(TB_ENDSWITH) && !this.chkRuleSegment.isSelected() && (currLength = this.getIntValue(this.kdtDetails.getCell(rowIndex, columnIndex))) > this.txtLength.getIntegerValue()) {
            this.txtLength.setValue((Object)currLength);
        }
    }

    protected void propertyChanged(int rowIndex, PropertyInfo property) {
        IRow row = this.kdtDetails.getRow(rowIndex);
        String fullName = property.getString("fullName");
        String fullAlias = property.getString("fullAlias");
        String bosType = property.getString("linkedBosType");
        row.getCell(TB_PROPERTY).setValue((Object)fullName);
        row.getCell(TB_PROPERTYALIAS).setValue((Object)fullAlias);
        row.getCell(TB_PROPERTYBOSTYPE).setValue((Object)bosType);
        row.getCell(TB_FORMAT).getStyleAttributes().setLocked(true);
        row.getCell(TB_FORMAT).setEditor(null);
        row.getCell(TB_FORMAT).getStyleAttributes().setBackground(BarcodeClientUtils.lockedColor);
        row.getCell(TB_STARTSWITH).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell(TB_ENDSWITH).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        String dataType = null;
        if (bosType != null) {
            dataType = null;
        } else {
            dataType = (String)property.get("dataType");
            if (dataType != null && "BigDecimal".equals(dataType)) {
                KDFilterTextField txt = new KDFilterTextField();
                txt.setFilterType(1);
                txt.setValidCharacters(".");
                txt.setMaxLength(80);
                row.getCell(TB_FORMAT).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txt));
                row.getCell(TB_FORMAT).getStyleAttributes().setLocked(false);
                row.getCell(TB_FORMAT).getStyleAttributes().setBackground(Color.WHITE);
                row.getCell(TB_FORMAT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            } else if (!(dataType != null && "Boolean".equals(dataType) || dataType == null || !"Date".equals(dataType) && !"TimeStamp".equals(dataType))) {
                KDComboBox comboBox = new KDComboBox();
                comboBox.setName("comboBox");
                comboBox.setVisible(true);
                comboBox.addItems(new Object[]{EnumUtils.getEnumList((String)"com.kingdee.eas.barcode.scm.DateFormatEnum").get(0)});
                KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JComboBox)comboBox);
                row.getCell(TB_FORMAT).setEditor((ICellEditor)editor);
                row.getCell(TB_FORMAT).getStyleAttributes().setLocked(false);
                row.getCell(TB_FORMAT).getStyleAttributes().setBackground(Color.WHITE);
            }
        }
    }

    protected PropertyInfo selectProperty(int rowIndex, int colIndex) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("entity", this.entity);
        uiContext.put("selectBizType", "AnalysisProperty");
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SelectEntityUI.class.getName(), (Map)uiContext);
        }
        catch (UIException e1) {
            e1.printStackTrace();
            this.handleException((Exception)((Object)e1));
        }
        SelectEntityUI ui = (SelectEntityUI)uiWindow.getUIObject();
        uiWindow.show();
        PropertyInfo property = (PropertyInfo)ui.getReturnObject();
        return property;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getStatus().getValue() != 0 && this.editData.getStatus().getValue() != 2) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"116_BarcodeDictEditUI"));
            SysUtil.abort();
        }
        super.actionCancelCancel_actionPerformed(e);
    }

    public boolean isPackageType() {
        BarcodeTypeInfo bti = (BarcodeTypeInfo)this.prmtBarcodeType.getValue();
        return bti != null && bti.getBarcodeType().getValue() == 2;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.txtNumber.getText() == null || "".equals(this.txtNumber.getText().trim())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"113_BarcodeDictEditUI"));
            SysUtil.abort();
        }
        if (this.txtName.getText() == null || "".equals(this.txtName.getText().trim())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"114_BarcodeDictEditUI"));
            SysUtil.abort();
        }
        if (this.prmtEntity.getText() == null || "".equals(this.prmtEntity.getText().trim())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"129_BarcodeRuleEditUI"));
            SysUtil.abort();
        }
        if (this.prmtAdminCU.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"34_BarcodeRuleControllerBean"));
            SysUtil.abort();
        }
        if (this.prmtBarcodeType.getValue() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"35_BarcodeRuleControllerBean")));
        }
        if (this.txtLength.getText() == null || this.txtLength.getText().toString().equals("")) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"130_BarcodeRuleEditUI"));
            SysUtil.abort();
        }
        if (!this.isPackageType() && this.kdtDetails.getRowCount() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"115_BarcodeDictEditUI"));
            SysUtil.abort();
        }
        if (this.chkRuleSegment.isSelected()) {
            if (!this.isPackageType() && new BigDecimal(this.txtSegmentNum.getText()).compareTo(new BigDecimal("0")) <= 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"31_BarcodeRuleControllerBean"));
                SysUtil.abort();
            }
            if (this.txtSegmentSeparators.getText() == null || "".equals(this.txtSegmentSeparators.getText())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"131_BarcodeRuleEditUI"));
                SysUtil.abort();
            }
        } else if (new BigDecimal(this.txtLength.getText()).compareTo(new BigDecimal("0")) <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"132_BarcodeRuleEditUI"));
            SysUtil.abort();
        }
        super.verifyInput(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        String number = (String)newData.get("number");
        String name = (String)newData.get("name");
        if (number != null && !"".equals(number)) {
            newData.put("number", (Object)(number.trim() + "copy"));
        }
        if (name != null && !"".equals(name)) {
            newData.put("name", (Object)(name.trim() + "copy"));
        }
        newData.put("status", (Object)StatusEnum.SAVED);
        super.setFieldsNull(newData);
    }

    protected void initEntry() {
        KDTextField txtRemark = new KDTextField();
        txtRemark.setMaxLength(255);
        KDTDefaultCellEditor edtRemark = new KDTDefaultCellEditor((JTextField)txtRemark);
        this.kdtDetails.getColumn(TB_REMARK).setEditor((ICellEditor)edtRemark);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getStatus().getValue() == 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"117_BarcodeDictEditUI"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    protected KDTable getDetailTable() {
        return this.kdtDetails;
    }
}

