/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.barcode.scm.BarcodeRuleFactory;
import com.kingdee.eas.barcode.scm.OrgUnitUtils;
import com.kingdee.eas.barcode.scm.client.AbstractBarcodeRuleListUI;
import com.kingdee.eas.barcode.scm.client.BarcodeRuleEditUI;
import com.kingdee.eas.barcode.scm.client.FABarcodeUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class BarcodeRuleListUI
extends AbstractBarcodeRuleListUI {
    private static final Logger logger = CoreUIObject.getLogger(BarcodeRuleListUI.class);
    private String permissionCuStr = "";

    public BarcodeRuleListUI() throws Exception {
        this.actionCancel.setEnabled(true);
        this.actionCancel.setVisible(true);
        this.actionCancelCancel.setEnabled(true);
        this.actionCancelCancel.setVisible(true);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected String getEditUIName() {
        return BarcodeRuleEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BarcodeRuleFactory.getRemoteInstance();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.refreshList();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.cancelCancel();
        this.refreshList();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        BizEnumValueDTO status;
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int index = -1;
        if (selectRows.length > 0) {
            index = selectRows[0];
        }
        if ((status = (BizEnumValueDTO)this.tblMain.getRow(index).getCell("status").getValue()).getName().equals("ACTIVE")) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"117_BarcodeDictEditUI"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        FABarcodeUtils.requestLicenseOrReleaseLicense(this.getUIContext(), true, (CoreUI)this);
        OrgUnitCollection coll = OrgUnitUtils.getAuthOrgByPermItem(null, OrgType.ControlUnit, "barcodeRule_view");
        this.permissionCuStr = OrgUnitUtils.toStringList(coll, "number");
        super.onLoad();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        FilterInfo mergfilter = new FilterInfo();
        mergfilter.getFilterItems().add(new FilterItemInfo("cu.number", (Object)this.permissionCuStr, CompareType.INCLUDE));
        try {
            if (viewInfo.getFilter() == null) {
                viewInfo.setFilter(mergfilter);
            } else {
                viewInfo.getFilter().mergeFilter(mergfilter, "and");
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        IQueryExecutor exe = super.getQueryExecutor(queryPK, viewInfo);
        return exe;
    }
}

