/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.scm.BarcodeAnalysisResult;
import com.kingdee.eas.barcode.scm.BarcodeAnalysisResultItem;
import com.kingdee.eas.barcode.scm.BarcodeConfigFactory;
import com.kingdee.eas.barcode.scm.BarcodeConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeConfigXML;
import com.kingdee.eas.barcode.scm.BarcodeConfigXMLDetail;
import com.kingdee.eas.barcode.scm.BarcodeConfigXMLProperty;
import com.kingdee.eas.barcode.scm.BarcodeDefaultSolutionCollection;
import com.kingdee.eas.barcode.scm.BarcodeDefaultSolutionFactory;
import com.kingdee.eas.barcode.scm.BarcodeDefaultSolutionInfo;
import com.kingdee.eas.barcode.scm.BarcodeDefaultXMLInfo;
import com.kingdee.eas.barcode.scm.BarcodeDefaultXMLItem;
import com.kingdee.eas.barcode.scm.BarcodeDossierCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierFactory;
import com.kingdee.eas.barcode.scm.BarcodeExecutor;
import com.kingdee.eas.barcode.scm.BarcodeScanningBarcodeInfo;
import com.kingdee.eas.barcode.scm.BarcodeScanningFactory;
import com.kingdee.eas.barcode.scm.BarcodeScanningInfo;
import com.kingdee.eas.barcode.scm.BarcodeScanningPropertyInfo;
import com.kingdee.eas.barcode.scm.BarcodeScanningRecodeInfo;
import com.kingdee.eas.barcode.scm.BarcodeTypeEnum;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.BarcodeXMLHelper;
import com.kingdee.eas.barcode.scm.DataBasePermissionUtil;
import com.kingdee.eas.barcode.scm.ForegrdStautsEnum;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetCollection;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetFactory;
import com.kingdee.eas.barcode.scm.OrgUnitUtils;
import com.kingdee.eas.barcode.scm.client.AbstractBarcodeScanningEditUI;
import com.kingdee.eas.barcode.scm.client.BarcodeAnalysisClientHelper;
import com.kingdee.eas.barcode.scm.client.BarcodeDataImport;
import com.kingdee.eas.barcode.scm.util.BarcodeClientUtils;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.CodingRuleUtils;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.core.util.EqualsUtil;
import com.kingdee.eas.base.form.ide.utils.EntityObjectInfoHelp;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.config.client.ConfigServiceUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class BarcodeScanningEditUI
extends AbstractBarcodeScanningEditUI
implements BarcodeExecutor {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BarcodeScanningEditUI.class);
    public static final String TB_PARENTID = "fparentId";
    public static final String TB_ID = "fid";
    public static final String TB_BOSTYPE = "fbosType";
    public static final String TB_PARENTBOSTYPE = "fparentBosType";
    public static final String TB_SRCQTY = "fsrcQty";
    public static final String TB_DIFQTY = "fdifQty";
    public static final String TB_SRCBILLID = "fsrcBillId";
    public static final String TB_SRCBILLENTRYID = "fsrcEntryId";
    public static final String TB_SEQ = "fseq";
    public static final String TB_DESTBILLID = "fdestBillid";
    public static final String TB_SCANNINGID = "fScanningId";
    public static String seqNoFiled = "sequenceNumber";
    public static final String BC_PARENTID = "parentId";
    public static final String BC_PARENTBOSTYPE = "parentBosType";
    public static final String BC_BARCODE = "barcode";
    public static final String BC_ENTITYALAILS = "entityAlais";
    public static final String BC_ROWNUM = "rowNum";
    public static final String BC_BARCODERULEID = "barcodeRuleId";
    public static final String SEQ_PARENTID = "parentId";
    public static final String SEQ_PARENTBOSTYPE = "parentBosType";
    public static final String SEQ_SEQ = "seq";
    public static final String SEQ_ENTITYALAILS = "entityAlais";
    public static final String SEQ_ROWNUM = "rowNum";
    public BarcodeConfigXML xmlInfo = new BarcodeConfigXML();
    public Map<String, String> parentIdMap = new HashMap<String, String>();
    public boolean isModifyNumber = true;
    public boolean isAddView = true;
    protected KDWorkButton btnRemoveLine = null;
    public String countTaskBosType = "AC301916";
    public String countTableBosType = "D9D2CA5D";
    private BarcodeAnalysisClientHelper barcodeAnalysisClientHelper = new BarcodeAnalysisClientHelper();
    public String barcode = null;
    private String defaultConfigId;
    public String paramValue = "0";

    protected void configNamePreChange(PreChangeEvent e) throws EASBizException, BOSException {
        int result;
        if (EqualsUtil.equals((Object)e.getData(), (Object)e.getOldData())) {
            return;
        }
        if (this.kdtpEntry.getTabCount() > 0 && ((result = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"134_BarcodeScanningEditUI"))) == 1 || result == 2)) {
            e.setResult(0);
            return;
        }
        this.clearByChangeConfig();
        if (e.getData() == null) {
            return;
        }
        BarcodeConfigInfo info = (BarcodeConfigInfo)e.getData();
        this.editData.setStatus(ForegrdStautsEnum.SAVED);
        this.txtNumber.setText(this.getNumberByCoding(this.editData));
        this.editData.setId(BOSUuid.create((BOSObjectType)new BarcodeScanningInfo().getBOSType()));
        this.editData.setCU(info.getCU());
        if (info.getSrcBosType() != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("name");
            sic.add("id");
            BOTMappingInfo botInfo = BOTMappingFactory.getRemoteInstance().getBOTMappingInfo((IObjectPK)new ObjectUuidPK(info.getBotMapping().getId()), sic);
            this.txtBotpNumber.setText(botInfo.getName());
            this.txtBotpId.setText(botInfo.getId().toString());
            this.txtSrcBosType.setText(info.getSrcBosType());
        } else {
            this.txtBotpNumber.setText(null);
            this.txtBotpId.setText(null);
            this.txtSrcBosType.setText(null);
        }
        this.txtDestBosType.setText(info.getDestBosType().toString());
        this.initDetails(info);
    }

    protected void initDetails(BarcodeConfigInfo configInfo) {
        this.kdtpEntry.removeAll();
        String o = configInfo.getDetailsXML();
        if (o != null) {
            String detailsXml = o;
            this.xmlInfo = BarcodeXMLHelper.toBarcodeConfigXML(detailsXml);
            for (int i = 0; i < this.xmlInfo.getDetails().size(); ++i) {
                BarcodeConfigXMLDetail detail = this.xmlInfo.getDetails().get(i);
                KDTable table = this.initTable(detail);
                this.kdtpEntry.addTab(detail.getEntityAlias(), (Component)table);
                table.addKDTEditListener(new KDTEditListener(){

                    public void editValueChanged(KDTEditEvent e) {
                    }

                    public void editStopping(KDTEditEvent e) {
                    }

                    public void editStopped(KDTEditEvent e) {
                        BarcodeScanningEditUI.this.editStoped(e);
                    }

                    public void editStarting(KDTEditEvent e) {
                    }

                    public void editStarted(KDTEditEvent e) {
                    }

                    public void editCanceled(KDTEditEvent e) {
                    }
                });
                table.addKeyListener(new KeyListener(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                    }

                    @Override
                    public void keyReleased(KeyEvent e) {
                        BarcodeScanningEditUI.this.tableKeyReleased(e);
                    }

                    @Override
                    public void keyPressed(KeyEvent e) {
                    }
                });
                if (detail.getParentBosType() == null && this.isValueNull(this.txtSrcBosType.getText()) && this.oprtState.equals("VIEW")) continue;
            }
        }
    }

    protected KDTable initTable(BarcodeConfigXMLDetail detail) {
        KDTable table = new KDTable();
        table.setName(detail.getFullName());
        ArrayList<String> aliasList = new ArrayList<String>();
        this.initPropertyColumns(detail, table, aliasList);
        this.addSrcAndDifQtyColumn(table, aliasList);
        table.addColumn().setKey(TB_SRCBILLID);
        table.getColumn(TB_SRCBILLID).getStyleAttributes().setHided(true);
        aliasList.add(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"135_BarcodeScanningEditUI"));
        table.addColumn().setKey(TB_SRCBILLENTRYID);
        table.getColumn(TB_SRCBILLENTRYID).getStyleAttributes().setHided(true);
        aliasList.add(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"136_BarcodeScanningEditUI"));
        table.addColumn().setKey(TB_DESTBILLID);
        table.getColumn(TB_DESTBILLID).getStyleAttributes().setHided(true);
        aliasList.add(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"137_BarcodeScanningEditUI"));
        table.addColumn().setKey(TB_PARENTID);
        table.getColumn(TB_PARENTID).getStyleAttributes().setHided(true);
        aliasList.add(TB_PARENTID);
        table.addColumn().setKey(TB_ID);
        table.getColumn(TB_ID).getStyleAttributes().setHided(true);
        aliasList.add(TB_ID);
        IRow headRow = table.addHeadRow(0);
        for (int i = 0; i < aliasList.size(); ++i) {
            headRow.getCell(i).setValue(aliasList.get(i));
        }
        return table;
    }

    @Override
    public void executeBarcode(String barcode) throws Exception {
        BarcodeAnalysisResult barcodeResult;
        String destBosType;
        String srcBosType;
        block21: {
            if (this.comboStatus.getSelectedItem() == ForegrdStautsEnum.SUSPEND) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"141_BarcodeScanningEditUI"));
                SysUtil.abort();
            }
            this.barcode = barcode;
            srcBosType = this.txtSrcBosType.getText();
            destBosType = this.txtDestBosType.getText();
            if (this.prmtConfigName.getValue() == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"138_BarcodeScanningEditUI"));
                SysUtil.abort();
            }
            if (destBosType.equals(this.countTableBosType)) {
                srcBosType = this.countTaskBosType;
            }
            barcodeResult = null;
            CtrlUnitInfo ctrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
            if ("1".equals(this.paramValue) || "3".equals(this.paramValue)) {
                barcodeResult = this.isCountTableForDestBosType() && ((KDTable)this.kdtpEntry.getComponentAt(0)).getRowCount3() == 0 ? this.barcodeAnalysisClientHelper.processDossier(this, barcode, ctrlUnitInfo, srcBosType) : this.barcodeAnalysisClientHelper.processDossier(this, barcode, ctrlUnitInfo, destBosType);
                if (barcodeResult == null) {
                    if ("1".equals(this.paramValue)) {
                        MsgBox.showWarning((String)"\u672a\u627e\u5230\u5408\u9002\u7684\u89c4\u5219");
                    } else if ("3".equals(this.paramValue)) {
                        try {
                            barcodeResult = this.barcodeAnalysisClientHelper.barcodeAnalysis(this, barcode, srcBosType, destBosType, SysContext.getSysContext().getCurrentCtrlUnit().getNumber());
                        }
                        catch (Exception e) {
                            MsgBox.showWarning((String)"\u672a\u627e\u5230\u5408\u9002\u7684\u89c4\u5219");
                        }
                    }
                }
            } else if ("0".equals(this.paramValue)) {
                barcodeResult = this.barcodeAnalysisClientHelper.barcodeAnalysis(this, barcode, srcBosType, destBosType, SysContext.getSysContext().getCurrentCtrlUnit().getNumber());
            } else if ("2".equals(this.paramValue)) {
                try {
                    barcodeResult = this.barcodeAnalysisClientHelper.barcodeAnalysis(this, barcode, srcBosType, destBosType, SysContext.getSysContext().getCurrentCtrlUnit().getNumber());
                }
                catch (Exception e) {
                    barcodeResult = this.isCountTableForDestBosType() && ((KDTable)this.kdtpEntry.getComponentAt(0)).getRowCount3() == 0 ? this.barcodeAnalysisClientHelper.processDossier(this, barcode, ctrlUnitInfo, srcBosType) : this.barcodeAnalysisClientHelper.processDossier(this, barcode, ctrlUnitInfo, destBosType);
                    if (barcodeResult != null) break block21;
                    MsgBox.showWarning((String)"\u672a\u627e\u5230\u5408\u9002\u7684\u89c4\u5219");
                }
            }
        }
        if (barcodeResult == null) {
            return;
        }
        if (srcBosType != null && !srcBosType.equals("") && barcodeResult.getBarcodeType() != BarcodeTypeEnum.billBarcode && ((KDTable)this.kdtpEntry.getComponentAt(0)).getRowCount3() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"139_BarcodeScanningEditUI"));
            SysUtil.abort();
        }
        if (this.isCountTableForDestBosType() && ((KDTable)this.kdtpEntry.getComponentAt(0)).getRowCount3() == 0 && !barcodeResult.getBosType().equals(this.countTaskBosType)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"140_BarcodeScanningEditUI"));
            SysUtil.abort();
        }
        String transTypeNumber = null;
        if (this.prmtDefaultSolution.getValue() != null) {
            BarcodeDefaultSolutionInfo dsi = (BarcodeDefaultSolutionInfo)this.prmtDefaultSolution.getValue();
            transTypeNumber = this.findeDefaultSolutionTransTypeNumber(dsi);
        }
        if (barcodeResult.isBarcodeRepeat()) {
            this.warnForBarcodeRepeat(barcode, destBosType, transTypeNumber);
        }
        BarcodeConfigInfo info = (BarcodeConfigInfo)this.prmtConfigName.getValue();
        this.processBarcode(srcBosType, destBosType, barcodeResult, info);
        this.afterexecuteBarcode(barcode, destBosType, transTypeNumber);
    }

    public String findeDefaultSolutionTransTypeNumber(BarcodeDefaultSolutionInfo dsi) {
        BarcodeDefaultXMLInfo defaultXmlInfo = BarcodeXMLHelper.toBarcodeDefaultXMLInfo(dsi.getDetailsXML());
        for (int i = 0; i < defaultXmlInfo.getItems().size(); ++i) {
            BarcodeDefaultXMLItem item = defaultXmlInfo.getItems().get(i);
            String fullField = item.getField();
            if (!"transactionType".equalsIgnoreCase(fullField)) continue;
            return item.getValue();
        }
        return null;
    }

    protected void processBarcode(String srcBosType, String destBosType, BarcodeAnalysisResult barcodeResult, BarcodeConfigInfo info) throws BOSException, EASBizException {
        if (barcodeResult.getBarcodeType().getValue() == 1 || this.countTaskBosType.equals(barcodeResult.getBosType())) {
            if (srcBosType == null || "".equals(srcBosType)) {
                barcodeResult.setBosType(destBosType);
            } else {
                barcodeResult.setBosType(srcBosType);
            }
            this.processBillBarcode(srcBosType, destBosType, barcodeResult);
        } else if (barcodeResult.getBarcodeType().getValue() == 0) {
            this.processNormalBarcode(barcodeResult, info);
        }
    }

    protected void processNormalBarcode(BarcodeAnalysisResult barcodeResult, BarcodeConfigInfo info) {
        if (!this.isValueNull(info.getSrcBosType()) || this.isCountTableForDestBosType()) {
            this.fillNomarlBarcodeInSrcBill(barcodeResult);
        } else {
            this.fillNomalBarcodeNoSrcBill(barcodeResult);
        }
    }

    protected void processBillBarcode(String srcBosType, String destBosType, BarcodeAnalysisResult barcodeResult) throws BOSException, EASBizException {
        if (barcodeResult.getBosType().equals(this.countTaskBosType) && ((KDTable)this.kdtpEntry.getComponentAt(0)).getRowCount3() != 0) {
            int result = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"142_BarcodeScanningEditUI"));
            if (result == 0) {
                for (int i = 0; i < this.kdtpEntry.getTabCount(); ++i) {
                    KDTable table = (KDTable)this.kdtpEntry.getComponentAt(i);
                    table.removeRows();
                }
            } else {
                SysUtil.abort();
            }
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        String botpNumber = this.txtBotpNumber.getText();
        map.put("srcBosType", srcBosType);
        map.put("botpNumber", botpNumber);
        map.put("barcodeResult", barcodeResult);
        map.put("destBosType", destBosType);
        boolean isBotp = botpNumber.length() > 0;
        IObjectCollection objectColl = (IObjectCollection)BarcodeScanningFactory.getRemoteInstance().getDestBill(map);
        if (objectColl != null && objectColl.size() > 0) {
            for (int i = 0; i < objectColl.size(); ++i) {
                this.fillBillData(objectColl.getObject(i), isBotp);
            }
        }
    }

    @Override
    public void actionBarcode_actionPerformed(ActionEvent e) throws Exception {
        String barcode = this.txtBarcode.getText();
        this.executeBarcode(barcode);
        this.txtBarcode.selectAll();
    }

    protected void fillBillData(IObjectValue value, boolean isBotp) {
        KDTable billTable = null;
        BOSUuid billId = null;
        String entityAlais = this.kdtpEntry.getTitleAt(0);
        for (int i = 0; i < this.kdtpEntry.getTabCount(); ++i) {
            KDTable table = (KDTable)this.kdtpEntry.getComponentAt(i);
            String scanQtyFiled = this.getScanOrSrcQtyFiled(table, false, true);
            IObjectCollection entryColl = null;
            EntityObjectInfo entity = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)this.getBosType(table, TB_BOSTYPE)));
            if (!this.isValueNull(table.getName())) {
                if (table.getName().indexOf(".") != -1 || (entryColl = (IObjectCollection)value.get(table.getName())) == null || entryColl.size() <= 0) continue;
                for (int x = 0; x < entryColl.size(); ++x) {
                    IObjectValue entryValue = entryColl.getObject(x);
                    IRow row = table.addRow();
                    this.fillBillToTable(table, entryValue, row, entity, isBotp);
                    if (!this.isValueNull(scanQtyFiled) && !this.isValueNull(this.txtSrcBosType.getText())) {
                        row.getCell(TB_SRCQTY).setValue(entryValue.get(scanQtyFiled));
                        BigDecimal scanQty = new BigDecimal(row.getCell(scanQtyFiled).getValue().toString());
                        BigDecimal srcQty = new BigDecimal(row.getCell(TB_SRCQTY).getValue().toString());
                        row.getCell(TB_DIFQTY).setValue((Object)srcQty.subtract(scanQty));
                    }
                    row.getCell(TB_PARENTID).setValue((Object)billId);
                    row.getCell(TB_ID).setValue((Object)this.createRowId(table, row, TB_ID));
                    row.getCell(TB_SRCBILLID).setValue(entryValue.get("sourceBillId"));
                    row.getCell(TB_SRCBILLENTRYID).setValue(entryValue.get("sourceBillEntryId"));
                    row.getCell(TB_DESTBILLID).setValue(entryValue.get("id"));
                }
                this.kdtpEntry.setSelectedIndex(i);
                continue;
            }
            billTable = table;
            IRow row = table.addRow();
            this.fillBillToTable(table, value, row, entity, isBotp);
            billId = this.createRowId(table, row, TB_ID);
            row.getCell(TB_ID).setValue((Object)billId);
            row.getCell(TB_DESTBILLID).setValue(value.get("id"));
            this.fillToTblBarcode(billTable, billId.toString(), this.barcode, entityAlais, row.getRowIndex());
            this.parentIdMap.put(this.getBosType(table, TB_BOSTYPE), billId.toString());
        }
    }

    protected void fillBillToTable(KDTable table, IObjectValue value, IRow row, EntityObjectInfo entity, boolean isBotp) {
        String scanQtyFiled = this.getScanOrSrcQtyFiled(table, false, true);
        for (int j = 0; j < table.getColumnCount(); ++j) {
            String key = table.getColumnKey(j);
            String objectKey = key.substring(key.lastIndexOf(".") + 1);
            if (key.contains("_")) {
                Object linkValue = value.get(objectKey = objectKey.substring(0, objectKey.indexOf("_")));
                if (linkValue != null) {
                    IObjectValue objectValue = (IObjectValue)linkValue;
                    Object number = objectValue.get("number");
                    if (number == null && objectValue.get("id") != null) {
                        try {
                            objectValue = (IObjectValue)BarcodeScanningFactory.getRemoteInstance().getIObjectValueById(objectValue.get("id").toString());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.handleException(e);
                        }
                    }
                    row.getCell(j).setValue(objectValue.get("number"));
                    row.getCell(++j).setValue(objectValue.get("name"));
                    continue;
                }
                ++j;
                continue;
            }
            if (key.equals(scanQtyFiled) && isBotp) {
                row.getCell(j).setValue((Object)new BigDecimal("0"));
                continue;
            }
            if (key.equals(TB_ID) || key.equals(TB_PARENTID)) continue;
            PropertyInfo property = entity.getPropertyByName(objectKey);
            if (property != null) {
                if (value.get(objectKey) instanceof Date) {
                    BarcodeClientUtils.setSingleCellValue(row.getCell(j), property, BarcodeUtils.SIMPLE_DATE_FORMAT.format(value.get(objectKey)));
                    continue;
                }
                BarcodeClientUtils.setSingleCellValue(row.getCell(j), property, value.getString(objectKey));
                continue;
            }
            row.getCell(j).setValue((Object)value.getString(objectKey));
        }
    }

    protected void fillNomarlBarcodeInSrcBill(BarcodeAnalysisResult barcodeResult) {
        List<BarcodeAnalysisResultItem> items = barcodeResult.getItems();
        String destBosType = null;
        if (items != null && items.size() > 0 && items.get(0) != null) {
            destBosType = items.get(0).getBosType();
        }
        for (int i = 0; i < this.kdtpEntry.getTabCount(); ++i) {
            KDTable table = (KDTable)this.kdtpEntry.getComponentAt(i);
            String bosType = this.getBosType(table, TB_BOSTYPE);
            if (destBosType == null || !destBosType.equals(bosType)) continue;
            this.kdtpEntry.setSelectedIndex(i);
            String entityAlais = this.kdtpEntry.getTitleAt(i);
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)table);
            if (selectRows.length > 0) {
                int selectRowIndx = selectRows[0];
                IRow selectRow = table.getRow(selectRowIndx);
                String seqNo = this.getAnalysisItem(items, seqNoFiled);
                boolean isMatch = this.isMtchForSelectRow(items, table, selectRow);
                if (isMatch) {
                    this.fillBarcodeAnalysisResultToRow(items, selectRow, table);
                    this.cumSumQty(items, table, selectRow, null, barcodeResult.isCumsumQty());
                    this.calculateDifQty(table, selectRow, this.getMergeBolck(table, selectRowIndx), items);
                    String id = selectRow.getCell(TB_ID).getValue().toString();
                    int rowNum = selectRow.getRowIndex();
                    this.fillToTblBarcode(table, id, this.barcode, entityAlais, rowNum);
                    continue;
                }
                this.fillBarcodeInSrc(barcodeResult, items, table, entityAlais, -1);
                continue;
            }
            this.fillBarcodeInSrc(barcodeResult, items, table, entityAlais, -1);
        }
    }

    protected void fillNomalBarcodeNoSrcBill(BarcodeAnalysisResult barcodeResult) {
        List<BarcodeAnalysisResultItem> items = barcodeResult.getItems();
        String destBosType = items.get(0).getBosType();
        for (int i = 0; i < this.kdtpEntry.getTabCount(); ++i) {
            KDTable table = (KDTable)this.kdtpEntry.getComponentAt(i);
            String bosType = this.getBosType(table, TB_BOSTYPE);
            if (!destBosType.equals(bosType)) continue;
            String entityAlais = this.kdtpEntry.getTitleAt(i);
            String parentBosType = this.getBosType(table, TB_PARENTBOSTYPE);
            this.checkParentId(parentBosType);
            if (table.getRowCount3() == 0) {
                this.addNewRow(table, parentBosType, -1);
            }
            IRow row = table.getRow(0);
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)table);
            if (selectRows.length > 0) {
                String seqNo = this.getAnalysisItem(items, seqNoFiled);
                int selectRowIndx = selectRows[0];
                row = table.getRow(selectRowIndx);
                boolean isMatch = this.isMtchForSelectRow(items, table, row);
                if (isMatch) {
                    this.fillBarcodeAnalysisResultToRow(items, row, table);
                    this.cumSumQty(items, table, row, null, barcodeResult.isCumsumQty());
                    String id = row.getCell(TB_ID).getValue().toString();
                    int rowNum = row.getRowIndex();
                    this.fillToTblBarcode(table, id, this.barcode, entityAlais, rowNum);
                    if (seqNo != null) {
                        this.fillToTblSeqNo(table, id, seqNo, entityAlais, rowNum);
                    }
                } else {
                    this.fillBarcodesNoSrc(barcodeResult, items, table, entityAlais);
                }
            } else {
                this.fillBarcodesNoSrc(barcodeResult, items, table, entityAlais);
            }
            this.kdtpEntry.setSelectedIndex(i);
        }
    }

    protected void fillBarcodesNoSrc(BarcodeAnalysisResult barcodeResult, List<BarcodeAnalysisResultItem> items, KDTable table, String entityAlais) {
        String seqNo = this.getAnalysisItem(items, seqNoFiled);
        String parentBosType = this.getBosType(table, TB_PARENTBOSTYPE);
        String bosType = this.getBosType(table, TB_BOSTYPE);
        String scanQtyFiled = this.getScanOrSrcQtyFiled(table, false, true);
        IRow row = table.getRow(0);
        boolean isSum = barcodeResult.isCumsumQty();
        if (scanQtyFiled == null && isSum) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"143_BarcodeScanningEditUI"));
            SysUtil.abort();
        } else {
            Map map = this.getMatchResult(items, table, barcodeResult.isCumsumQty(), -1, false);
            int matchRowIndex = new BigDecimal(map.get("matchRowIndex").toString()).intValue();
            int someMatchRowIndex = new BigDecimal(map.get("someMatchRowIndex").toString()).intValue();
            int someCellVaueNullRowIndex = new BigDecimal(map.get("someCellVaueNullRowIndex").toString()).intValue();
            row = matchRowIndex != -1 || this.isSumForSomeMtchItem(someMatchRowIndex, table) ? table.getRow(matchRowIndex == -1 ? someMatchRowIndex : matchRowIndex) : (someCellVaueNullRowIndex != -1 ? table.getRow(someCellVaueNullRowIndex) : this.addNewRow(table, parentBosType, -1));
            this.fillBarcodeAnalysisResultToRow(items, row, table);
            this.cumSumQty(items, table, row, null, barcodeResult.isCumsumQty());
        }
        String id = row.getCell(TB_ID).getValue().toString();
        int rowNum = row.getRowIndex();
        this.parentIdMap.put(bosType, id);
        this.fillToTblBarcode(table, id, this.barcode, entityAlais, rowNum);
        if (seqNo != null) {
            this.fillToTblSeqNo(table, id, seqNo, entityAlais, rowNum);
        }
    }

    protected IRow splitRow(List<BarcodeAnalysisResultItem> items, KDTable table, IRow matchRow, String entityAlais) {
        int someMatchRowIndex = matchRow.getRowIndex();
        IRow splitRow = table.addRow(someMatchRowIndex + 1);
        this.copyRow(splitRow, matchRow, table);
        KDTMergeBlock merg = this.getMergeBolck(table, someMatchRowIndex);
        if (merg == null) {
            int colunmIndex = table.getColumn(TB_SRCQTY).getColumnIndex();
            table.getMergeManager().mergeBlock(someMatchRowIndex, colunmIndex, someMatchRowIndex + 1, colunmIndex);
            int difQtyColIdx = table.getColumn(TB_DIFQTY).getColumnIndex();
            table.getMergeManager().mergeBlock(someMatchRowIndex, difQtyColIdx, someMatchRowIndex + 1, difQtyColIdx);
            merg = this.getMergeBolck(table, someMatchRowIndex);
        }
        return splitRow;
    }

    protected void calculateDifQty(KDTable table, IRow row, KDTMergeBlock merg, List<BarcodeAnalysisResultItem> items) {
        BigDecimal srcQty;
        String scanFiled = this.getScanOrSrcQtyFiled(table, false, true);
        BigDecimal scanQty = new BigDecimal("0");
        BigDecimal diffQty = new BigDecimal("0");
        Object srcQtyO = row.getCell(TB_SRCQTY).getValue();
        BigDecimal bigDecimal = srcQty = this.isValueNull(srcQtyO) ? new BigDecimal("0") : new BigDecimal(srcQtyO.toString());
        if (merg != null) {
            int x;
            int beginRowIdx = merg.getTop();
            int endRowIdx = merg.getBottom();
            for (x = beginRowIdx; x <= endRowIdx; ++x) {
                scanQty = scanQty.add(new BigDecimal(table.getRow(x).getCell(scanFiled).getValue().toString()));
            }
            diffQty = srcQty.subtract(scanQty);
            for (x = beginRowIdx; x <= endRowIdx; ++x) {
                table.getRow(x).getCell(TB_DIFQTY).setValue((Object)diffQty);
            }
        } else {
            Object scanQtyO = row.getCell(scanFiled).getValue();
            scanQty = this.isValueNull(scanQtyO) ? new BigDecimal("0") : new BigDecimal(scanQtyO.toString());
            diffQty = srcQty.subtract(scanQty);
            if (this.isCountTableForDestBosType()) {
                diffQty = diffQty.multiply(new BigDecimal("-1"));
            }
            row.getCell(TB_DIFQTY).getStyleAttributes().setNumberFormat("0.00000000");
            row.getCell(TB_DIFQTY).setValue((Object)diffQty);
        }
    }

    @Override
    public void storeFields() {
        List<BarcodeScanningRecodeInfo> list = this.editData.getScanRecodeList();
        for (int i = 0; i < this.kdtpEntry.getTabCount(); ++i) {
            KDTable table = (KDTable)this.kdtpEntry.getComponentAt(i);
            String parentBosType = this.getBosType(table, TB_PARENTBOSTYPE);
            String entityName = this.getEntityName(table);
            String entityAlias = this.kdtpEntry.getTitleAt(i);
            if (!parentBosType.equals(new BarcodeScanningInfo().getBOSType().toString()) || (list = this.crateRecodeList(table, this.editData.getId() == null ? "" : this.editData.getId().toString(), list)).size() <= 0) continue;
            for (int j = 0; j < list.size(); ++j) {
                BarcodeScanningRecodeInfo info = list.get(j);
                info.setFentityName(entityName);
                info.setFentityAlias(entityAlias);
            }
        }
        if (list != null && list.size() > 0) {
            this.editData.setScanRecodeList(list);
        }
        super.storeFields();
    }

    public void tableKeyReleased(KeyEvent e) {
        KDTable table;
        if (e.getKeyCode() == 27 && KDTableUtil.getSelectedRows((KDTable)(table = (KDTable)e.getSource())).length > 0) {
            table.getSelectManager().getBlocks().clear();
            table.repaint();
        }
    }

    protected void editStoped(KDTEditEvent e) {
        String key;
        KDTable table = (KDTable)e.getSource();
        int rowIndex = e.getRowIndex();
        IRow row = table.getRow(rowIndex);
        String colName = table.getColumnKey(e.getColIndex());
        String scanQtyFiled = this.getScanOrSrcQtyFiled(table, false, true);
        if (!this.isValueNull(scanQtyFiled) && colName.equals(scanQtyFiled)) {
            Object scanO = row.getCell(scanQtyFiled).getValue();
            scanO = this.isValueNull(scanO) ? "0" : scanO;
            this.isNumberFormt(scanO.toString());
            BigDecimal scanQty = new BigDecimal(scanO.toString());
            this.cumSumQty(null, table, row, scanQty);
            this.calculateDifQty(table, row, this.getMergeBolck(table, rowIndex), null);
        }
        if (colName.indexOf("_") != -1 && this.isReferProperty(table, key = colName.substring(0, colName.indexOf("_")))) {
            IObjectValue value;
            Object valueO = row.getCell(colName).getValue();
            if (valueO == null) {
                row.getCell(key + "_name").setValue(null);
            }
            if (valueO instanceof IObjectValue && (value = (IObjectValue)row.getCell(colName).getValue()) != null) {
                row.getCell(key + "_name").setValue(value.get("name"));
            }
        }
    }

    protected boolean isReferProperty(KDTable table, String key) {
        for (int i = 0; i < this.xmlInfo.getDetails().size(); ++i) {
            BarcodeConfigXMLDetail xmlDetail = this.xmlInfo.getDetails().get(i);
            String fullName = xmlDetail.getFullName();
            String tblName = table.getName();
            if ((tblName != null || fullName != null) && (tblName == null || fullName == null || !tblName.equals(fullName))) continue;
            for (int j = 0; j < xmlDetail.getProperties().size(); ++j) {
                BarcodeConfigXMLProperty property = xmlDetail.getProperties().get(j);
                if (!property.isRefer() || !property.getName().equals(key)) continue;
                return true;
            }
        }
        return false;
    }

    protected void initPropertyColumns(BarcodeConfigXMLDetail detail, KDTable table, List<String> aliasList) {
        List<BarcodeConfigXMLProperty> propertys = detail.getProperties();
        EntityObjectInfo entity = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)detail.getBosType()));
        for (int i = 0; i < propertys.size(); ++i) {
            BarcodeConfigXMLProperty property = propertys.get(i);
            String key = property.getFullName();
            key = key.substring(key.lastIndexOf(".") + 1);
            PropertyInfo entityProperty = entity.getPropertyByName(key);
            if (property.isLinkedProperty()) {
                this.addColumnForLinkedProperty(table, aliasList, property, key, entityProperty);
                continue;
            }
            if (property.isScanQty()) {
                this.addColunm(table, key, property, entityProperty);
                table.getColumn(key).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                aliasList.add(property.getAlias() + EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"147_BarcodeScanningEditUI"));
                continue;
            }
            this.addColunm(table, key, property, entityProperty);
            if (property.getDataType().equals("BigDecimal") || property.getDataType().equals("Integer")) {
                table.getColumn(key).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            } else if (property.getDataType().equals("Date")) {
                table.getColumn(key).getStyleAttributes().setNumberFormat("%{yyyy-MM-dd}t");
            } else if (property.getDataType().equals("TimeStamp")) {
                table.getColumn(key).getStyleAttributes().setNumberFormat("%{yyyy-MM-dd HH:mm:ss}t");
            }
            aliasList.add(property.getAlias());
        }
    }

    protected void addColumnForLinkedProperty(KDTable table, List<String> aliasList, BarcodeConfigXMLProperty property, String key, PropertyInfo entityProperty) {
        String filedNumber = key + "_number";
        String filedName = key + "_name";
        this.addColunm(table, filedNumber, property, entityProperty);
        this.addColunm(table, filedName, property, entityProperty);
        aliasList.add(property.getAlias() + EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"145_BarcodeScanningEditUI"));
        aliasList.add(property.getAlias() + EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"103_BarcodeDefaultTablePanel"));
    }

    protected void addSrcAndDifQtyColumn(KDTable table, List<String> aliasList) {
        String srcBosType = this.txtSrcBosType.getText();
        boolean isHasSrcBill = !this.isValueNull(srcBosType);
        String scanQtyFiled = this.getScanOrSrcQtyFiled(table, false, true);
        int scannIndex = table.getColumnIndex(scanQtyFiled);
        if (scannIndex == -1) {
            table.addColumn().setKey(TB_SRCQTY);
            aliasList.add(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"146_BarcodeScanningEditUI"));
            table.addColumn().setKey(TB_DIFQTY);
            aliasList.add(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"148_BarcodeScanningEditUI"));
        } else {
            table.addColumn(scannIndex).setKey(TB_SRCQTY);
            aliasList.add(scannIndex, EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"146_BarcodeScanningEditUI"));
            table.addColumn(scannIndex + 2).setKey(TB_DIFQTY);
            aliasList.add(scannIndex + 2, EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"148_BarcodeScanningEditUI"));
        }
        table.getColumn(TB_SRCQTY).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn(TB_SRCQTY).getStyleAttributes().setNumberFormat("0.00000000");
        table.getColumn(TB_SRCQTY).getStyleAttributes().setLocked(true);
        table.getColumn(TB_SRCQTY).getStyleAttributes().setFontColor(Color.BLUE);
        table.getColumn(TB_DIFQTY).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn(TB_DIFQTY).getStyleAttributes().setNumberFormat("0.00000000");
        table.getColumn(TB_DIFQTY).getStyleAttributes().setLocked(true);
        table.getColumn(TB_DIFQTY).getStyleAttributes().setFontColor(Color.RED);
        if (isHasSrcBill && scannIndex != -1) {
            table.getColumn(TB_SRCQTY).getStyleAttributes().setHided(false);
            table.getColumn(TB_DIFQTY).getStyleAttributes().setHided(false);
        } else {
            table.getColumn(TB_SRCQTY).getStyleAttributes().setHided(true);
            table.getColumn(TB_DIFQTY).getStyleAttributes().setHided(true);
        }
    }

    protected void addColunm(KDTable table, String key, BarcodeConfigXMLProperty property, PropertyInfo entityProperty) {
        IColumn column = table.addColumn();
        column.setKey(key);
        column.getStyleAttributes().setHided(property.isUnVisable());
        if (property.isLinkedProperty() && property.isRefer() && key.contains("_number")) {
            this.addF7Column(column, property, entityProperty);
        } else if (!property.isLinkedProperty()) {
            BarcodeClientUtils.loadSingleColumn(column, entityProperty);
        }
    }

    protected void addF7Column(IColumn column, BarcodeConfigXMLProperty xmlProperty, PropertyInfo entityProperty) {
        EntityObjectInfo tempEntity;
        String defaultF7;
        KDBizPromptBox f7 = null;
        if (entityProperty instanceof LinkPropertyInfo && (defaultF7 = (tempEntity = ((LinkPropertyInfo)entityProperty).getRelationship().getSupplierObject()).getExtendedProperty("defaultF7Query")) != null) {
            f7 = new KDBizPromptBox();
            f7.setVisible(true);
            f7.setEditable(true);
            f7.setDisplayFormat("$number$");
            f7.setEditFormat("$number$");
            f7.setCommitFormat("$number$");
            KDTDefaultCellEditor object_CellEditor = new KDTDefaultCellEditor((IKDEditor)f7);
            column.setEditor((ICellEditor)object_CellEditor);
            ObjectValueRender avr = new ObjectValueRender();
            avr.setFormat((IDataFormat)new BizDataFormat(f7.getDisplayFormatter().toString()));
            column.setRenderer((IBasicRender)avr);
            f7.setQueryInfo(defaultF7);
        }
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    protected IObjectValue createNewData() {
        BarcodeScanningInfo info = new BarcodeScanningInfo();
        info.setStatus(ForegrdStautsEnum.SAVED);
        info.setId(BOSUuid.create((BOSObjectType)new BarcodeScanningInfo().getBOSType()));
        info.setNumber(this.getNumberByCoding(info));
        return info;
    }

    protected String getNumberByCoding(BarcodeScanningInfo info) {
        if (this.isAddView) {
            try {
                String number = CodingRuleUtils.getNumberByClient((IObjectValue)info, (String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
                if (number != null && !number.equals("")) {
                    return number;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BarcodeScanningFactory.getRemoteInstance();
    }

    protected void setEnableOrUnEnable(boolean isEnable) {
        this.prmtConfigName.setEnabled(isEnable);
        this.prmtDefaultSolution.setEnabled(isEnable);
        this.txtBarcode.setEnabled(isEnable);
        if (this.isModifyNumber) {
            this.txtNumber.setEnabled(isEnable);
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if (this.oprtState == "VIEW") {
            this.setTableIsEnable(false);
        } else {
            this.setTableIsEnable(true);
        }
        if (this.editData.getStatus() != null) {
            if (this.editData.getStatus() == ForegrdStautsEnum.SUSPEND) {
                this.btnSuspend.setText(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"150_BarcodeScanningEditUI"));
            } else {
                this.btnSuspend.setText(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"151_BarcodeScanningEditUI"));
            }
        }
    }

    public void onLoad() throws Exception {
        this.getCodingRuleStatus();
        this.initUICompont();
        super.onLoad();
        this.hideCompont();
        this.initBarcodeConfig();
        this.initDefaultSolution();
        this.prmtConfigName.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                try {
                    BarcodeScanningEditUI.this.configNamePreChange(e);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    BarcodeScanningEditUI.this.handleException(e1);
                }
            }
        });
        this.prmtConfigName.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    BarcodeScanningEditUI.this.pconfigNameChange(e);
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                    BarcodeScanningEditUI.this.handleException((Exception)((Object)e1));
                }
            }
        });
        IndubarodeParamsetCollection paramCol = IndubarodeParamsetFactory.getRemoteInstance().getIndubarodeParamsetCollection();
        if (paramCol != null && paramCol.get(0) != null) {
            if (paramCol.get(0).isBusinessBarcode()) {
                this.paramValue = "0";
            } else if (paramCol.get(0).isIndBarcode()) {
                this.paramValue = "1";
            } else if (paramCol.get(0).isPriorBusiness()) {
                this.paramValue = "2";
            } else if (paramCol.get(0).isPriorInd()) {
                this.paramValue = "3";
            }
        }
    }

    protected void initUICompont() {
        this.kDLabelContainer1.setVisible(false);
        this.btnUpLoad.setEnabled(true);
        this.btnSuspend.setEnabled(true);
        this.txtBarcode.setAutoscrolls(true);
        this.contBarcode.setAutoscrolls(true);
        this.actionRemoveLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnRemoveLine = (KDWorkButton)this.kDContainer1.add((Action)((Object)this.actionRemoveLine));
        this.btnRemoveLine.setText(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"149_BarcodeScanningEditUI"));
        this.btnRemoveLine.setSize(new Dimension(22, 19));
        this.btnRemoveLine.setEnabled(true);
        this.btnSave.setVisible(false);
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        KeyStroke enter = KeyStroke.getKeyStroke("ENTER");
        this.txtBarcode.getInputMap().put(enter, "none");
        this.txtBarcode.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    try {
                        BarcodeScanningEditUI.this.actionBarcode_actionPerformed(null);
                    }
                    catch (Exception e1) {
                        BarcodeScanningEditUI.this.handleException(e1);
                    }
                }
            }
        });
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "EscPress");
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BarcodeScanningEditUI.this.esc_actionPerformed(e);
            }
        };
        actionMap.put("EscPress", escAction);
    }

    public boolean destroyWindow() {
        String configId;
        if (this.prmtConfigName.getValue() != null && !(configId = ((BarcodeConfigInfo)this.prmtConfigName.getValue()).getId().toString()).equals(this.defaultConfigId)) {
            ConfigServiceUtils.saveUserConfigData((String)"defaultBarcodeConfig", (CoreUI)this, (String)configId);
        }
        return super.destroyWindow();
    }

    protected void initBarcodeConfig() throws EASBizException, BOSException {
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        this.defaultConfigId = ConfigServiceUtils.getUserConfigData((String)"defaultBarcodeConfig", (CoreUI)this);
        OrgUnitCollection coll = OrgUnitUtils.getAuthOrgByPermItem(null, OrgType.ControlUnit, "barcodeScan_view");
        String permissionCuStr = OrgUnitUtils.toStringList(coll, "number");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cu.number", (Object)permissionCuStr, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtConfigName.setEntityViewInfo(view);
        if (this.prmtConfigName.getValue() == null && this.defaultConfigId != null && !"null".equalsIgnoreCase(this.defaultConfigId)) {
            try {
                BarcodeConfigInfo defaultConfigInfo = BarcodeConfigFactory.getRemoteInstance().getBarcodeConfigInfo("where id='" + this.defaultConfigId + "' and cu.id='" + cu.getId().toString() + "'");
                if (defaultConfigInfo != null) {
                    this.prmtConfigName.setValue((Object)defaultConfigInfo);
                    PreChangeEvent e = new PreChangeEvent((Object)this.prmtConfigName);
                    e.setData(this.prmtConfigName.getValue());
                    this.configNamePreChange(e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        ActionMap actionMap = this.getActionMap();
        actionMap.remove("barcodeExecute");
    }

    protected void esc_actionPerformed(ActionEvent e) {
        for (int i = 0; i < this.kdtpEntry.getTabCount(); ++i) {
            KDTable table = (KDTable)this.kdtpEntry.getComponentAt(i);
            table.getEditManager().cancelEditing();
            table.getSelectManager().remove();
        }
        this.txtBarcode.requestFocus();
        this.txtBarcode.selectAll();
    }

    protected void getCodingRuleStatus() throws BOSException, EASBizException, CodingRuleException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        this.editData = new BarcodeScanningInfo();
        RuleStatus rStatus = iCodingRuleManager.getRuleStatus((IObjectValue)this.editData, SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        if (rStatus.isExist()) {
            if (!rStatus.isModifiable()) {
                this.isModifyNumber = false;
                this.txtNumber.setEnabled(false);
            }
            if (!rStatus.isAddView()) {
                this.isAddView = false;
            }
        }
    }

    protected void setTableIsEnable(boolean isEanble) {
        for (int i = 0; i < this.kdtpEntry.getTabCount(); ++i) {
            KDTable table = (KDTable)this.kdtpEntry.getComponentAt(i);
            table.setEnabled(isEanble);
        }
        this.btnRemoveLine.setEnabled(isEanble);
    }

    protected void pconfigNameChange(ChangeEvent e) throws BOSException {
        this.initDefaultSolution();
    }

    protected void hideCompont() {
        this.prmtCreator.setEnabled(false);
        this.prmtLastUpdateUser.setEnabled(false);
        this.comboStatus.setAccessAuthority(0);
        this.pkCreateTime.setAccessAuthority(0);
        this.comboStatus.setEnabled(false);
        this.pkCreateTime.setEnabled(false);
        this.pkLastUpdateTime.setEnabled(false);
        this.btnCopy.setVisible(false);
        this.prmtConfigName.setHistoryRecordEnabled(false);
        this.menuSubmitOption.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.menuBiz.setVisible(false);
        this.menuItemCopy.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.tblSeq.setVisible(false);
        this.kDTabbedPane1.removeTabAt(1);
    }

    protected void clearByChangeConfig() {
        this.prmtDefaultSolution.setValue(null);
        this.txtBarcode.setText(null);
        this.tblBarcode.removeRows();
        this.tblSeq.removeRows();
        this.kdtpEntry.removeAll();
        this.prmtLastUpdateUser.setValue(null);
        this.prmtCreator.setValue(null);
        this.pkCreateTime.setValue(null);
        this.pkLastUpdateTime.setValue(null);
        this.txtNumber.setText(null);
    }

    protected void initDefaultSolution() throws BOSException {
        this.prmtDefaultSolution.setEnabled(false);
        if ((this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals(OprtState.ADDNEW)) && this.prmtConfigName.getValue() != null) {
            UserInfo user;
            BarcodeConfigInfo config = (BarcodeConfigInfo)this.prmtConfigName.getValue();
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("barcodeConfig.id", (Object)config.getId().toString(), CompareType.EQUALS));
            ev.setFilter(filter);
            this.prmtDefaultSolution.setEntityViewInfo(ev);
            if (this.editData.getStatus() != ForegrdStautsEnum.UPOVER) {
                this.prmtDefaultSolution.setEnabled(true);
            }
            if (this.getOprtState().equals(OprtState.ADDNEW) && this.prmtDefaultSolution.getValue() == null && (user = SysContext.getSysContext().getCurrentUserInfo()).getPerson() != null) {
                filter.getFilterItems().add(new FilterItemInfo("creator.id", (Object)user.getId().toString(), CompareType.EQUALS));
                BarcodeDefaultSolutionCollection coll = BarcodeDefaultSolutionFactory.getRemoteInstance().getBarcodeDefaultSolutionCollection(ev);
                if (coll.size() > 0) {
                    this.prmtDefaultSolution.setValue((Object)coll.get(0));
                }
            }
        }
    }

    protected void fillToTblBarcode(KDTable table, String id, String barcode, String entityAlais, int rowNum) {
        IRow barcodeRow = this.tblBarcode.addRow();
        barcodeRow.getCell("parentId").setValue((Object)id);
        barcodeRow.getCell("parentBosType").setValue((Object)this.getBosType(table, TB_BOSTYPE));
        barcodeRow.getCell(BC_BARCODE).setValue((Object)barcode);
        barcodeRow.getCell("entityAlais").setValue((Object)entityAlais);
        barcodeRow.getCell("rowNum").setValue((Object)(rowNum + 1));
        barcodeRow.getCell(BC_BARCODERULEID).setValue((Object)this.barcodeAnalysisClientHelper.getCurrRuleId());
    }

    protected void fillToTblSeqNo(KDTable table, String id, String seqNo, String entityAlais, int rowNum) {
        IRow barcodeRow = this.tblSeq.addRow();
        barcodeRow.getCell("parentId").setValue((Object)id);
        barcodeRow.getCell("parentBosType").setValue((Object)this.getBosType(table, TB_BOSTYPE));
        barcodeRow.getCell(SEQ_SEQ).setValue((Object)seqNo);
        barcodeRow.getCell("entityAlais").setValue((Object)entityAlais);
        barcodeRow.getCell("rowNum").setValue((Object)(rowNum + 1));
    }

    protected BOSUuid createRowId(KDTable table, IRow row, String key) {
        BOSUuid id = BOSUuid.create((String)"1938B6C0");
        row.getCell(key).setValue((Object)id);
        return id;
    }

    protected boolean isMtchForSelectRow(List<BarcodeAnalysisResultItem> items, KDTable table, IRow selectRow) {
        boolean isMatch = true;
        for (int j = 0; j < items.size(); ++j) {
            Object cellValue;
            BarcodeAnalysisResultItem item = items.get(j);
            if (!item.getIsMatchItem()) continue;
            String filed = item.getField();
            filed = filed.substring(filed.lastIndexOf(".") + 1);
            String string = filed = item.isLinkedProperty() ? filed + "_number" : filed;
            if (filed.equals(this.getScanOrSrcQtyFiled(table, false, true)) || filed.equals(this.getScanOrSrcQtyFiled(table, true, false)) || selectRow.getCell(filed) == null || (cellValue = selectRow.getCell(filed).getValue()) == null || item.getValue() == null || cellValue.toString().equals(item.getValue().toString())) continue;
            isMatch = false;
        }
        table.getSelectManager().remove();
        return isMatch;
    }

    protected boolean isCountTableForDestBosType() {
        return this.countTableBosType.equals(this.txtDestBosType.getText());
    }

    protected boolean isSumForSomeMtchItem(int someMatchRowIndex, KDTable table) {
        if (someMatchRowIndex == -1) {
            return false;
        }
        String scanQty = this.getScanOrSrcQtyFiled(table, false, true);
        if (scanQty == null) {
            return false;
        }
        Object scanQtyValue = table.getRow(someMatchRowIndex).getCell(scanQty).getValue();
        return scanQtyValue == null || scanQtyValue.equals("") || new BigDecimal(scanQtyValue.toString()).compareTo(new BigDecimal("0")) == 0;
    }

    protected void fillBarcodeInSrc(BarcodeAnalysisResult barcodeResult, List<BarcodeAnalysisResultItem> items, KDTable table, String entityAlais, int scanCompletedRowIdx) {
        String scanQtyFiled;
        Map map = this.getMatchResult(items, table, barcodeResult.isCumsumQty(), scanCompletedRowIdx, !barcodeResult.getBosType().equals(this.countTableBosType));
        int matchRowIndex = new BigDecimal(map.get("matchRowIndex").toString()).intValue();
        int someMatchRowIndex = new BigDecimal(map.get("someMatchRowIndex").toString()).intValue();
        Boolean isNoMatchItemForRule = (Boolean)map.get("isNoMatchItemForRule");
        int someCellVaueNullRowIndex = new BigDecimal(map.get("someCellVaueNullRowIndex").toString()).intValue();
        boolean isCumsum = barcodeResult.isCumsumQty();
        IRow row = table.getRow(0);
        if (matchRowIndex == -1 && someMatchRowIndex == -1 && !isNoMatchItemForRule.booleanValue() && !this.isCountTableForDestBosType()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"153_BarcodeScanningEditUI"));
            SysUtil.abort();
        }
        if ((scanQtyFiled = this.getScanOrSrcQtyFiled(table, false, true)) == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"162_BarcodeScanningEditUI"));
            SysUtil.abort();
        }
        if (matchRowIndex != -1 || this.isSumForSomeMtchItem(someMatchRowIndex, table)) {
            row = table.getRow(matchRowIndex == -1 ? someMatchRowIndex : matchRowIndex);
            BigDecimal difQty = this.getDifQty(table, row, items);
            if (difQty.doubleValue() <= 0.0 && !this.isCountTableForDestBosType()) {
                boolean result = this.isScanNext(barcodeResult, items, table, row);
                if (result) {
                    this.fillBarcodeInSrc(barcodeResult, items, table, entityAlais, this.getCompleteScanRowIdx(table, row));
                    return;
                }
                if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"156_BarcodeScanningEditUI")) != 0) {
                    SysUtil.abort();
                }
            }
        } else if (!this.isCountTableForDestBosType()) {
            IRow someMathcRow = table.getRow(someMatchRowIndex);
            if (someMathcRow != null) {
                BigDecimal difQty = this.getDifQty(table, row, items);
                if (difQty.doubleValue() <= 0.0) {
                    boolean result = this.isScanNext(barcodeResult, items, table, someMathcRow);
                    if (result) {
                        this.fillBarcodeInSrc(barcodeResult, items, table, entityAlais, this.getCompleteScanRowIdx(table, someMathcRow));
                        return;
                    }
                    if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"156_BarcodeScanningEditUI")) != 0) {
                        SysUtil.abort();
                    }
                }
                row = this.splitRow(items, table, someMathcRow, entityAlais);
            }
        } else if (this.isCountTableForDestBosType()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"153_BarcodeScanningEditUI"));
            SysUtil.abort();
        }
        this.fillBarcodeAnalysisResultToRow(items, row, table);
        KDTMergeBlock merg = this.getMergeBolck(table, row.getRowIndex());
        this.cumSumQty(items, table, row, null, isCumsum);
        this.calculateDifQty(table, row, merg, items);
        String id = row.getCell(TB_ID).getValue().toString();
        int rowNum = row.getRowIndex();
        this.fillToTblBarcode(table, id, this.barcode, entityAlais, rowNum);
    }

    private BigDecimal getDifQty(KDTable table, IRow currRow, List<BarcodeAnalysisResultItem> items) {
        String scanFiled = this.getScanOrSrcQtyFiled(table, false, true);
        Object difQtyCellValue = currRow.getCell(TB_DIFQTY).getValue();
        BigDecimal diffQty = this.isValueNull(difQtyCellValue) ? new BigDecimal("0") : new BigDecimal(difQtyCellValue.toString());
        BigDecimal scanQty = new BigDecimal("0");
        for (int i = 0; i < items.size(); ++i) {
            String filed = items.get(i).getField();
            if (!scanFiled.equals(filed = filed.substring(filed.lastIndexOf(".") + 1))) continue;
            if (items.get(i).getValue() == null) {
                scanQty = new BigDecimal("1");
                break;
            }
            String qtyStr = items.get(i).getValue().toString();
            scanQty = new BigDecimal(qtyStr);
            break;
        }
        diffQty = diffQty.subtract(scanQty);
        return diffQty;
    }

    protected int getCompleteScanRowIdx(KDTable table, IRow row) {
        KDTMergeBlock meg = this.getMergeBolck(table, row.getRowIndex());
        int nextRowIndex = meg == null ? row.getRowIndex() : meg.getBottom();
        return nextRowIndex;
    }

    protected boolean isScanNext(BarcodeAnalysisResult barcodeResult, List<BarcodeAnalysisResultItem> items, KDTable table, IRow row) {
        BigDecimal difQty = row.getCell(TB_DIFQTY).getValue() == null ? BigDecimal.ZERO : new BigDecimal(row.getCell(TB_DIFQTY).getValue().toString());
        boolean result = false;
        if (difQty.doubleValue() <= 0.0) {
            int nextRowIndex = this.getCompleteScanRowIdx(table, row);
            Map nexMap = this.getMatchResult(items, table, barcodeResult.isCumsumQty(), nextRowIndex, true);
            int nextMatchRowIndex = new BigDecimal(nexMap.get("matchRowIndex").toString()).intValue();
            int nextSomeMatchRowIndex = new BigDecimal(nexMap.get("someMatchRowIndex").toString()).intValue();
            if (nextMatchRowIndex != -1 || nextSomeMatchRowIndex != -1) {
                result = true;
            }
        }
        return result;
    }

    protected IRow addRowFroCountTable(List<BarcodeAnalysisResultItem> items, KDTable table, String entityAlais) {
        IRow row = this.addNewRow(table, this.getBosType(table, TB_PARENTBOSTYPE), table.getRowCount3());
        row.getCell(TB_SRCQTY).setValue((Object)new BigDecimal("0.00"));
        return row;
    }

    protected String getAnalysisItem(List<BarcodeAnalysisResultItem> items, String key) {
        for (int i = 0; i < items.size(); ++i) {
            BarcodeAnalysisResultItem item = items.get(i);
            if (!item.getField().substring(item.getField().lastIndexOf(".") + 1).equals(key)) continue;
            return item.getValue() == null ? null : item.getValue().toString();
        }
        return null;
    }

    protected KDTMergeBlock getMergeBolck(KDTable table, int matchRowIndex) {
        KDTMergeBlock merg = null;
        Set set = table.getMergeManager().getMergeBlockSet();
        Iterator itr = set.iterator();
        if (itr.hasNext()) {
            while (itr.hasNext()) {
                KDTMergeBlock block = (KDTMergeBlock)itr.next();
                if (matchRowIndex < block.getTop() || matchRowIndex > block.getBottom()) continue;
                merg = block;
                break;
            }
        }
        return merg;
    }

    protected Map getMatchResult(List<BarcodeAnalysisResultItem> items, KDTable table, boolean isCumSumQty, int scanCompletedRowIdx, boolean hasSrcBill) {
        LinkedHashMap<String, Constable> map = new LinkedHashMap<String, Constable>();
        int someMatchRowIndex = -1;
        int matchRowIndex = -1;
        int someCellVaueNullRowIndex = -1;
        int cellNullCount = 0;
        Boolean isNoMatchItemForRule = false;
        String scanQtyFiled = this.getScanOrSrcQtyFiled(table, false, true);
        for (int j = scanCompletedRowIdx + 1; j < table.getRowCount3(); ++j) {
            cellNullCount = 0;
            int count = 0;
            int matchCount = 0;
            int notMatchCount = 0;
            int equal = 0;
            int srcAndScanCount = 0;
            IRow row = table.getRow(j);
            for (int k = 0; k < items.size(); ++k) {
                BarcodeAnalysisResultItem item = items.get(k);
                String filed = item.getField();
                filed = filed.substring(filed.lastIndexOf(".") + 1);
                if (item.isLinkedProperty()) {
                    filed = filed + "_number";
                }
                if (!filed.equals(scanQtyFiled) && !filed.equals(seqNoFiled)) {
                    ICell cell = row.getCell(filed);
                    if (cell == null) {
                        if (item.getIsMatchItem()) {
                            ++count;
                            ++matchCount;
                            continue;
                        }
                        ++notMatchCount;
                        ++equal;
                        continue;
                    }
                    Object cellValue = cell.getValue();
                    if (item.getIsMatchItem()) {
                        ++matchCount;
                        if (this.isValueNull(cellValue)) {
                            ++count;
                        }
                        if (this.isValueNull(cellValue) || this.isValueNull(item.getValue())) continue;
                        if (cellValue instanceof IObjectValue) {
                            cellValue = ((IObjectValue)cellValue).get("number");
                        }
                        if (!cellValue.toString().trim().equals(item.getValue().toString().trim())) continue;
                        ++count;
                        continue;
                    }
                    ++notMatchCount;
                    if (this.isValueNull(cellValue)) {
                        ++equal;
                        ++cellNullCount;
                    }
                    if (this.isValueNull(cellValue) || this.isValueNull(item.getValue())) continue;
                    if (cellValue instanceof IObjectValue) {
                        cellValue = ((IObjectValue)cellValue).get("number");
                    }
                    if (!cellValue.toString().trim().equals(item.getValue().toString().trim())) continue;
                    ++equal;
                    continue;
                }
                ++srcAndScanCount;
            }
            if (notMatchCount + srcAndScanCount == items.size()) {
                if (cellNullCount != 0 && someCellVaueNullRowIndex == -1) {
                    someCellVaueNullRowIndex = j;
                }
                isNoMatchItemForRule = true;
                continue;
            }
            if (count != matchCount) continue;
            if (notMatchCount == equal && matchRowIndex == -1) {
                matchRowIndex = row.getRowIndex();
                continue;
            }
            if (notMatchCount == equal || someMatchRowIndex != -1) continue;
            someMatchRowIndex = row.getRowIndex();
        }
        if (hasSrcBill && isCumSumQty && matchRowIndex != -1 && someMatchRowIndex != -1) {
            KDTMergeBlock merg = this.getMergeBolck(table, matchRowIndex);
            if (merg != null && someMatchRowIndex >= merg.getTop() && someMatchRowIndex <= merg.getBottom()) {
                someMatchRowIndex = -1;
            } else if (matchRowIndex > someMatchRowIndex) {
                matchRowIndex = -1;
            } else {
                someMatchRowIndex = -1;
            }
        }
        map.put("someCellVaueNullRowIndex", Integer.valueOf(someCellVaueNullRowIndex));
        map.put("matchRowIndex", Integer.valueOf(matchRowIndex));
        map.put("someMatchRowIndex", Integer.valueOf(someMatchRowIndex));
        map.put("isNoMatchItemForRule", isNoMatchItemForRule);
        return map;
    }

    protected void copyRow(IRow splitRow, IRow row, KDTable table) {
        for (int i = 0; i < table.getColumnCount(); ++i) {
            String scanQtyFiled;
            String filed = table.getColumnKey(i);
            if (filed.equals(scanQtyFiled = this.getScanOrSrcQtyFiled(table, false, true))) continue;
            splitRow.getCell(i).setValue(row.getCell(i).getValue());
        }
        this.createRowId(table, splitRow, TB_ID);
    }

    protected boolean isValueNull(Object obj) {
        return obj == null || obj.toString().trim().equals("");
    }

    protected void fillForSeqBarCode(List<BarcodeAnalysisResultItem> items, KDTable table, IRow row, String scanQtyFiled) {
        Object scanQtyO = row.getCell(scanQtyFiled).getValue();
        if (this.isValueNull(scanQtyO)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"158_BarcodeScanningEditUI"));
            SysUtil.abort();
        } else {
            String rowId = row.getCell(TB_ID).getValue().toString();
            int seqCount = this.getSeqCountForParent(rowId);
            BigDecimal scanQty = new BigDecimal(scanQtyO.toString());
            if (scanQty.subtract(BigDecimal.valueOf(seqCount)).doubleValue() > 0.0) {
                this.fillBarcodeAnalysisResultToRow(items, row, table);
            } else {
                MsgBox.showWarning((String)(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"159_BarcodeScanningEditUI") + scanQty + EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"160_BarcodeScanningEditUI")));
            }
        }
    }

    protected int getSeqCountForParent(String rowId) {
        int seqCount = 0;
        for (int j = 0; j < this.tblSeq.getRowCount(); ++j) {
            if (!this.tblSeq.getRow(j).getCell("parentId").getValue().toString().equals(rowId)) continue;
            ++seqCount;
        }
        return seqCount;
    }

    protected void checkParentId(String parentBosType) {
        if (parentBosType != null) {
            for (int j = 0; j < this.kdtpEntry.getTabCount(); ++j) {
                KDTable parentTable = (KDTable)this.kdtpEntry.getComponentAt(j);
                String currBosType = this.getBosType(parentTable, TB_BOSTYPE);
                if (currBosType == null || !currBosType.equals(parentBosType) || parentTable.getRowCount3() != 0) continue;
                IRow row = this.addNewRow(parentTable, this.getBosType(parentTable, TB_PARENTBOSTYPE), -1);
                this.parentIdMap.put(currBosType, row.getCell(TB_ID).getValue().toString());
                this.kdtpEntry.setSelectedIndex(j);
            }
        }
    }

    protected IRow addNewRow(KDTable table, String parentBosType, int rowIndex) {
        IRow row = table.getRow(0);
        row = rowIndex != -1 ? table.addRow(rowIndex) : table.addRow();
        this.createRowId(table, row, TB_ID);
        if (!this.isValueNull(parentBosType)) {
            row.getCell(TB_PARENTID).setValue((Object)this.parentIdMap.get(parentBosType));
        }
        this.setCellDeftValForBoolean(table, row);
        return row;
    }

    protected void setCellDeftValForBoolean(KDTable table, IRow row) {
        EntityObjectInfo entity = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)this.getBosType(table, TB_BOSTYPE)));
        for (int i = 0; i < table.getColumnCount(); ++i) {
            String key = table.getColumnKey(i);
            PropertyInfo pro = entity.getPropertyByName(key);
            if (pro == null || !pro.getString("dataType").equals("Boolean")) continue;
            row.getCell(key).setValue((Object)false);
        }
    }

    protected void warnForBarcodeRepeat(String barcode, String destBosType, String transTypeNumber) {
        int index = -1;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isScan", (Object)1, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("barcodeState", (Object)BarcodeClientUtils.getInOrOutBill(null, destBosType, transTypeNumber), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)barcode, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        BarcodeDossierCollection dossiercol = null;
        try {
            dossiercol = BarcodeDossierFactory.getRemoteInstance().getBarcodeDossierCollection(viewInfo);
            if (dossiercol.size() > 0 && 0 == (index = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"161_BarcodeScanningEditUI")))) {
                SysUtil.abort();
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < this.tblBarcode.getRowCount3(); ++i) {
            String bcode = this.tblBarcode.getRow(i).getCell(BC_BARCODE).getValue().toString();
            String ruleId = null;
            if (this.tblBarcode.getRow(i).getCell(BC_BARCODERULEID).getValue() != null) {
                ruleId = this.tblBarcode.getRow(i).getCell(BC_BARCODERULEID).getValue().toString();
            }
            if (!barcode.equals(bcode) || ruleId == null || !ruleId.equals(this.barcodeAnalysisClientHelper.getCurrRuleId()) || 0 != (index = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"161_BarcodeScanningEditUI"))) && 2 != index) continue;
            SysUtil.abort();
        }
    }

    protected BigDecimal cumSumQty(List<BarcodeAnalysisResultItem> items, KDTable table, IRow currRow, BigDecimal scanQty) {
        BigDecimal qty = new BigDecimal("0");
        String scanQtyFiled = this.getScanOrSrcQtyFiled(table, false, true);
        if (scanQtyFiled == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"162_BarcodeScanningEditUI"));
            SysUtil.abort();
        }
        if (scanQty != null) {
            qty = scanQty;
        } else {
            for (int i = 0; i < items.size(); ++i) {
                Object oldValue = currRow.getCell(scanQtyFiled).getValue();
                BigDecimal value = oldValue == null ? new BigDecimal("0") : new BigDecimal(oldValue.toString());
                String filed = items.get(i).getField();
                if ((filed = filed.substring(filed.lastIndexOf(".") + 1)).equals(scanQtyFiled)) {
                    if (items.get(i).getValue() == null) break;
                    String qtyStr = items.get(i).getValue().toString();
                    this.isNumberFormt(qtyStr);
                    qty = value.add(new BigDecimal(qtyStr));
                    break;
                }
                if (scanQtyFiled.equals(filed) || i != items.size() - 1) continue;
                qty = value.add(new BigDecimal("1"));
            }
        }
        currRow.getCell(scanQtyFiled).setValue((Object)qty);
        return qty;
    }

    protected BigDecimal cumSumQty(List<BarcodeAnalysisResultItem> items, KDTable table, IRow currRow, BigDecimal scanQty, boolean isCumsum) {
        BigDecimal qty = new BigDecimal("0");
        String scanQtyFiled = this.getScanOrSrcQtyFiled(table, false, true);
        if (scanQtyFiled == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"162_BarcodeScanningEditUI"));
            SysUtil.abort();
        }
        if (scanQty != null) {
            qty = scanQty;
        } else if (isCumsum) {
            for (int i = 0; i < items.size(); ++i) {
                Object oldValue = currRow.getCell(scanQtyFiled).getValue();
                BigDecimal value = oldValue == null ? new BigDecimal("0") : new BigDecimal(oldValue.toString());
                String filed = items.get(i).getField();
                if ((filed = filed.substring(filed.lastIndexOf(".") + 1)).equals(scanQtyFiled)) {
                    if (items.get(i).getValue() == null) break;
                    String qtyStr = items.get(i).getValue().toString();
                    this.isNumberFormt(qtyStr);
                    qty = value.add(new BigDecimal(qtyStr));
                    break;
                }
                if (scanQtyFiled.equals(filed) || i != items.size() - 1) continue;
                qty = value.add(new BigDecimal("1"));
            }
        } else {
            for (int i = 0; i < items.size(); ++i) {
                String filed = items.get(i).getField();
                if (!(filed = filed.substring(filed.lastIndexOf(".") + 1)).equals(scanQtyFiled)) continue;
                if (items.get(i).getValue() == null) break;
                String qtyStr = items.get(i).getValue().toString();
                this.isNumberFormt(qtyStr);
                qty = new BigDecimal(qtyStr);
                break;
            }
        }
        currRow.getCell(scanQtyFiled).setValue((Object)qty);
        return qty;
    }

    protected void isNumberFormt(String qtyStr) {
        try {
            new BigDecimal(qtyStr);
        }
        catch (NumberFormatException e) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"163_BarcodeScanningEditUI"));
            SysUtil.abort();
        }
    }

    protected void fillBarcodeAnalysisResultToRow(List<BarcodeAnalysisResultItem> items, IRow row, KDTable table) {
        for (int i = 0; i < items.size(); ++i) {
            Object value;
            ICell cell;
            BarcodeAnalysisResultItem item = items.get(i);
            String filed = item.getField();
            String scanQtyFiled = this.getScanOrSrcQtyFiled(table, false, true);
            if (scanQtyFiled == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"162_BarcodeScanningEditUI"));
                SysUtil.abort();
            }
            String realFiled = filed = filed.substring(filed.lastIndexOf(".") + 1);
            String filedName = "";
            if (item.isLinkedProperty()) {
                realFiled = filed + "_number";
                filedName = filed + "_name";
            }
            if (realFiled.equals(scanQtyFiled) || (cell = row.getCell(realFiled)) == null) continue;
            Object object = value = item.getNumber() != null ? item.getNumber() : item.getValue();
            if (value == null || value.equals("") || value.toString().equals(row.getCell(realFiled).getValue())) continue;
            row.getCell(realFiled).setValue(value);
            if (!item.isLinkedProperty() || row.getCell(filedName) == null) continue;
            row.getCell(filedName).setValue((Object)item.getName());
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.comboStatus.getSelectedItem() == ForegrdStautsEnum.UPOVER || this.comboStatus.getSelectedItem() == ForegrdStautsEnum.SUSPEND) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"164_BarcodeScanningEditUI"));
            SysUtil.abort();
        }
        super.actionSubmit_actionPerformed(e);
    }

    protected void doAfterSubmit(IObjectPK pk) throws Exception {
        this.setOprtState(OprtState.VIEW);
        super.doAfterSubmit(pk);
    }

    protected List<BarcodeScanningRecodeInfo> crateRecodeList(KDTable table, String parentId, List<BarcodeScanningRecodeInfo> list) {
        ArrayList<BarcodeScanningRecodeInfo> listNew = new ArrayList<BarcodeScanningRecodeInfo>();
        String bosType = this.getBosType(table, TB_BOSTYPE);
        EntityObjectInfo entity = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)this.getBosType(table, TB_BOSTYPE)));
        for (int j = 0; j < table.getRowCount3(); ++j) {
            IRow row = table.getRow(j);
            BarcodeScanningRecodeInfo info = this.setPropertyValue(table, row, parentId, entity);
            Map<String, List<BarcodeScanningRecodeInfo>> entryMap = this.createEntryMap(row, bosType);
            info.setEntriesMap(entryMap);
            info.setBarcodeList(this.createBarcodeList(info.getFid()));
            info.setSeqNoList(this.createSeqList(info.getFid()));
            listNew.add(info);
        }
        return listNew;
    }

    protected List<BarcodeScanningBarcodeInfo> createBarcodeList(String id) {
        ArrayList<BarcodeScanningBarcodeInfo> barcodeList = new ArrayList<BarcodeScanningBarcodeInfo>();
        for (int i = 0; i < this.tblBarcode.getRowCount3(); ++i) {
            IRow row = this.tblBarcode.getRow(i);
            String parentId = row.getCell("parentId").getValue().toString();
            if (!id.equals(parentId)) continue;
            BarcodeScanningBarcodeInfo bsbi = new BarcodeScanningBarcodeInfo();
            bsbi.setBarcode(row.getCell(BC_BARCODE).getValue().toString());
            if (row.getCell(BC_BARCODERULEID) != null && row.getCell(BC_BARCODERULEID).getValue() != null) {
                bsbi.setBarcodeRuleId(row.getCell(BC_BARCODERULEID).getValue().toString());
            }
            barcodeList.add(bsbi);
        }
        return barcodeList;
    }

    protected List<String> createSeqList(String id) {
        ArrayList<String> seqNoList = new ArrayList<String>();
        for (int i = 0; i < this.tblSeq.getRowCount3(); ++i) {
            IRow row = this.tblSeq.getRow(i);
            String parentId = row.getCell("parentId").getValue().toString();
            if (!id.equals(parentId)) continue;
            seqNoList.add(row.getCell(SEQ_SEQ).getValue().toString());
        }
        return seqNoList;
    }

    protected Map<String, List<BarcodeScanningRecodeInfo>> createEntryMap(IRow row, String bosType) {
        LinkedHashMap<String, List<BarcodeScanningRecodeInfo>> entriesMap = new LinkedHashMap<String, List<BarcodeScanningRecodeInfo>>();
        String id = row.getCell(TB_ID).getValue().toString();
        for (int i = 0; i < this.kdtpEntry.getTabCount(); ++i) {
            KDTable table = (KDTable)this.kdtpEntry.getComponentAt(i);
            String parentBosType = this.getBosType(table, TB_PARENTBOSTYPE);
            String childBosType = this.getBosType(table, TB_BOSTYPE);
            String entityName = this.getEntityName(table);
            String entityAlias = this.kdtpEntry.getTitleAt(i);
            if (!parentBosType.equals(bosType)) continue;
            ArrayList<BarcodeScanningRecodeInfo> childList = new ArrayList<BarcodeScanningRecodeInfo>();
            EntityObjectInfo entity = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)childBosType));
            for (int j = 0; j < table.getRowCount3(); ++j) {
                IRow childRow = table.getRow(j);
                String parentId = childRow.getCell(TB_PARENTID).getValue().toString();
                if (!parentId.equals(id)) continue;
                Object prtId = childRow.getCell(TB_PARENTID).getValue();
                BarcodeScanningRecodeInfo childInfo = this.setPropertyValue(table, childRow, prtId == null ? null : prtId.toString(), entity);
                childInfo.setBarcodeList(this.createBarcodeList(childInfo.getFid()));
                childInfo.setSeqNoList(this.createSeqList(childInfo.getFid()));
                childInfo.setFentityName(entityName);
                childInfo.setFentityAlias(entityAlias);
                childList.add(childInfo);
                Map<String, List<BarcodeScanningRecodeInfo>> childEntryMap = this.createEntryMap(childRow, childBosType);
                if (childEntryMap.size() <= 0) continue;
                childInfo.setEntriesMap(childEntryMap);
            }
            entriesMap.put(table.getName().substring(table.getName().lastIndexOf(".") + 1), childList);
        }
        return entriesMap;
    }

    protected BarcodeConfigXMLProperty getXmlPropertyByKey(String filed, String bosType) {
        int index = filed.indexOf("f");
        filed = index == 0 ? filed.substring(index + 1) : filed;
        for (int i = 0; i < this.xmlInfo.getDetails().size(); ++i) {
            if (!this.xmlInfo.getDetails().get(i).getBosType().equals(bosType)) continue;
            BarcodeConfigXMLDetail detailXml = this.xmlInfo.getDetails().get(i);
            for (int j = 0; j < detailXml.getProperties().size(); ++j) {
                BarcodeConfigXMLProperty xmlProperty = detailXml.getProperties().get(j);
                if (xmlProperty.getName().equals(filed)) {
                    return xmlProperty;
                }
                if (xmlProperty.getName().equals(filed) || j != detailXml.getProperties().size() - 1) continue;
                return null;
            }
        }
        return null;
    }

    protected BarcodeScanningRecodeInfo setPropertyValue(KDTable table, IRow childRow, String parentId, EntityObjectInfo entity) {
        BarcodeScanningRecodeInfo childInfo = new BarcodeScanningRecodeInfo();
        TreeMap<String, BarcodeScanningPropertyInfo> map = new TreeMap<String, BarcodeScanningPropertyInfo>();
        String childId = childRow.getCell(TB_ID).getValue().toString();
        String bosType = this.getBosType(table, TB_BOSTYPE);
        String parentBosType = this.getBosType(table, TB_PARENTBOSTYPE);
        childInfo.setFid(childId);
        childInfo.setFparentId(parentId);
        childInfo.setFbosType(bosType);
        if (parentBosType == null) {
            parentBosType = new BarcodeScanningInfo().getBOSType().toString();
        }
        childInfo.setFparentBosType(parentBosType);
        Object srcBillId = childRow.getCell(TB_SRCBILLID).getValue();
        childInfo.setFsrcBillId(srcBillId == null ? null : srcBillId.toString());
        Object srcBillEntryId = childRow.getCell(TB_SRCBILLENTRYID).getValue();
        childInfo.setFsrcEntryId(srcBillEntryId == null ? null : srcBillEntryId.toString());
        for (int k = 0; k < table.getColumnCount(); ++k) {
            Object cellValue;
            BarcodeScanningPropertyInfo proInfo;
            String key = table.getColumnKey(k);
            PropertyInfo property = entity.getPropertyByName(key);
            if (property != null) {
                proInfo = new BarcodeScanningPropertyInfo();
                proInfo.setKey(key);
                cellValue = BarcodeClientUtils.getSingleCellValue(childRow.getCell(key), property);
                String dataType = property.getString("dataType");
                if (dataType.equals("Date")) {
                    proInfo.setValue(cellValue == null ? null : java.sql.Date.valueOf(cellValue.toString()));
                } else if (dataType.equals("TimeStamp")) {
                    Object timeValue = childRow.getCell(key).getValue();
                    proInfo.setValue(timeValue == null ? null : Timestamp.valueOf(cellValue.toString()));
                } else {
                    proInfo.setValue(cellValue);
                }
                map.put(key, proInfo);
                continue;
            }
            if (key.indexOf("_") != -1) {
                proInfo = new BarcodeScanningPropertyInfo();
                proInfo.setKey(key);
                cellValue = childRow.getCell(k).getValue();
                if (cellValue instanceof IObjectValue) {
                    proInfo.setValue(((IObjectValue)cellValue).get("number"));
                } else {
                    proInfo.setValue(cellValue);
                }
                map.put(key, proInfo);
                proInfo = new BarcodeScanningPropertyInfo();
                String nameKey = key.substring(0, key.indexOf("_")) + "_name";
                proInfo.setKey(nameKey);
                proInfo.setValue(childRow.getCell(++k).getValue());
                map.put(nameKey, proInfo);
                continue;
            }
            proInfo = new BarcodeScanningPropertyInfo();
            proInfo.setKey(key);
            proInfo.setValue(childRow.getCell(k).getValue());
            map.put(key, proInfo);
        }
        if (!parentId.equals("")) {
            ((BarcodeScanningPropertyInfo)map.get(TB_PARENTID)).setValue(parentId);
        }
        BarcodeScanningPropertyInfo proInfo = new BarcodeScanningPropertyInfo();
        proInfo.setKey(TB_SEQ);
        proInfo.setValue(childRow.getRowIndex());
        map.put(TB_SEQ, proInfo);
        proInfo = new BarcodeScanningPropertyInfo();
        proInfo.setKey(TB_SCANNINGID);
        proInfo.setValue(this.editData.getId().toString());
        map.put(TB_SCANNINGID, proInfo);
        childInfo.setProperties(map);
        return childInfo;
    }

    protected String getBosType(KDTable table, String key) {
        for (int i = 0; i < this.xmlInfo.getDetails().size(); ++i) {
            BarcodeConfigXMLDetail xmlDetail = this.xmlInfo.getDetails().get(i);
            if ((xmlDetail.getFullName() != null || xmlDetail.getFullName() != table.getName()) && (xmlDetail.getFullName() == null || !xmlDetail.getFullName().equals(table.getName()))) continue;
            if (key.equals(TB_BOSTYPE)) {
                return xmlDetail.getBosType();
            }
            if (!key.equals(TB_PARENTBOSTYPE)) continue;
            return xmlDetail.getParentBosType() == null ? new BarcodeScanningInfo().getBOSType().toString() : xmlDetail.getParentBosType();
        }
        return null;
    }

    protected String getEntityName(KDTable table) {
        for (int i = 0; i < this.xmlInfo.getDetails().size(); ++i) {
            BarcodeConfigXMLDetail xmlDetail = this.xmlInfo.getDetails().get(i);
            if ((xmlDetail.getFullName() != null || xmlDetail.getFullName() != table.getName()) && (xmlDetail.getFullName() == null || !xmlDetail.getFullName().equals(table.getName()))) continue;
            return xmlDetail.getEntityName();
        }
        return null;
    }

    protected String getScanOrSrcQtyFiled(KDTable table, boolean isSrcQty, boolean isScanQty) {
        for (int i = 0; i < this.xmlInfo.getDetails().size(); ++i) {
            BarcodeConfigXMLDetail xmlDetail = this.xmlInfo.getDetails().get(i);
            if (xmlDetail.getFullName() != null && !xmlDetail.getFullName().equals(table.getName())) continue;
            List<BarcodeConfigXMLProperty> xmlPropertyList = xmlDetail.getProperties();
            for (int j = 0; j < xmlPropertyList.size(); ++j) {
                BarcodeConfigXMLProperty xmlProperty = xmlPropertyList.get(j);
                if (isSrcQty && xmlProperty.isSrcQty()) {
                    return xmlProperty.getName();
                }
                if (!isScanQty || !xmlProperty.isScanQty()) continue;
                return xmlProperty.getName();
            }
        }
        return null;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.clearAll();
        this.setEnableOrUnEnable(true);
        this.setTableIsEnable(true);
        this.btnSuspend.setText(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"151_BarcodeScanningEditUI"));
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        ObjectUuidPK orgPK = new ObjectUuidPK(((BarcodeConfigInfo)this.prmtConfigName.getValue()).getCU().getId());
        DataBasePermissionUtil.chekcPermission(null, (IObjectPK)orgPK, "barcodeScan_update");
        if (this.comboStatus.getSelectedItem() == ForegrdStautsEnum.UPOVER) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"165_BarcodeScanningEditUI"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
        this.setTableIsEnable(true);
    }

    protected void removeByPK(IObjectPK pk) throws Exception {
        this.clearAll();
        for (int i = 0; i < this.kdtpEntry.getTabCount(); ++i) {
            KDTable table = (KDTable)this.kdtpEntry.getComponentAt(i);
            table.removeRows();
        }
        super.removeByPK(pk);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getStatus() == ForegrdStautsEnum.UPOVER) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"51_BarcodeScanningControllerBean"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        if (this.comboStatus.getSelectedItem() == ForegrdStautsEnum.SUSPEND) {
            this.btnSuspend.setText(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"150_BarcodeScanningEditUI"));
        } else {
            this.btnSuspend.setText(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"151_BarcodeScanningEditUI"));
        }
        this.setTableIsEnable(false);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        if (this.comboStatus.getSelectedItem() == ForegrdStautsEnum.SUSPEND) {
            this.btnSuspend.setText(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"150_BarcodeScanningEditUI"));
        } else {
            this.btnSuspend.setText(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"151_BarcodeScanningEditUI"));
        }
        this.setTableIsEnable(false);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        if (this.comboStatus.getSelectedItem() == ForegrdStautsEnum.SUSPEND) {
            this.btnSuspend.setText(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"150_BarcodeScanningEditUI"));
        } else {
            this.btnSuspend.setText(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"151_BarcodeScanningEditUI"));
        }
        this.setTableIsEnable(false);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        if (this.comboStatus.getSelectedItem() == ForegrdStautsEnum.SUSPEND) {
            this.btnSuspend.setText(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"150_BarcodeScanningEditUI"));
        } else {
            this.btnSuspend.setText(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"151_BarcodeScanningEditUI"));
        }
        this.setTableIsEnable(false);
    }

    protected void clearAll() {
        this.txtBarcode.setText(null);
        this.kdtpEntry.removeAll();
        this.tblBarcode.removeRows();
        this.tblSeq.removeRows();
    }

    @Override
    public void actionUpLoad_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        this.beforeStoreFields(e);
        this.actionSubmit_actionPerformed(e);
        paraMap.put("id", this.editData.getId().toString());
        paraMap.put("srcBosType", this.txtSrcBosType.getText());
        paraMap.put("botpId", this.txtBotpId.getText());
        paraMap.put("xmlInfo", this.xmlInfo);
        if (this.prmtDefaultSolution.getValue() != null) {
            paraMap.put("defaultSolutionId", ((BarcodeDefaultSolutionInfo)this.prmtDefaultSolution.getValue()).getId().toString());
        }
        for (int i = 0; i < this.xmlInfo.getDetails().size(); ++i) {
            BarcodeConfigXMLDetail xmlDetail = this.xmlInfo.getDetails().get(i);
            if (xmlDetail.getParentBosType() != null) continue;
            paraMap.put("bosType", xmlDetail.getBosType());
        }
        IObjectPK pkLog = LogUtil.beginLog(null, (String)"actionUpLoad", (BOSObjectType)new BarcodeScanningInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(this.editData.getId()), (String)this.editData.getNumber(), (String)"bc_barcodeScan_upload");
        BarcodeScanningFactory.getRemoteInstance().barcodeUpLoad(paraMap);
        LogUtil.afterLog(null, (IObjectPK)pkLog);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"166_BarcodeScanningEditUI"));
        this.setEnableOrUnEnable(false);
        this.editData.setStatus(ForegrdStautsEnum.UPOVER);
        this.loadFields();
    }

    @Override
    public void actionSuspend_actionPerformed(ActionEvent e) throws Exception {
        this.beforeStoreFields(e);
        ObjectUuidPK orgPK = new ObjectUuidPK(((BarcodeConfigInfo)this.prmtConfigName.getValue()).getCU().getId());
        DataBasePermissionUtil.chekcPermission(null, (IObjectPK)orgPK, "barcodeScan_suspend");
        if (this.comboStatus.getSelectedItem() == ForegrdStautsEnum.UPOVER) {
            MsgBox.showWarning((String)(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"167_BarcodeScanningEditUI") + this.btnSuspend.getText()));
            SysUtil.abort();
        }
        if (this.comboStatus.getSelectedItem() == ForegrdStautsEnum.SAVED) {
            IObjectPK pkLog = LogUtil.beginLog(null, (String)"actionSuspend", (BOSObjectType)new BarcodeScanningInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(this.editData.getId()), (String)this.editData.getNumber(), (String)"bc_barcodeScan_suspend");
            this.actionSubmit_actionPerformed(e);
            BarcodeScanningFactory.getRemoteInstance().updateStatus(2, this.editData.getId().toString());
            LogUtil.afterLog(null, (IObjectPK)pkLog);
            this.comboStatus.setSelectedItem((Object)ForegrdStautsEnum.SUSPEND);
            this.btnSuspend.setText(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"150_BarcodeScanningEditUI"));
        } else if (this.comboStatus.getSelectedItem() == ForegrdStautsEnum.SUSPEND) {
            IObjectPK pkLog = LogUtil.beginLog(null, (String)"actionSuspend", (BOSObjectType)new BarcodeScanningInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(this.editData.getId()), (String)this.editData.getNumber(), (String)"bc_barcodeScan_unsuspend");
            BarcodeScanningFactory.getRemoteInstance().updateStatus(1, this.editData.getId().toString());
            LogUtil.afterLog(null, (IObjectPK)pkLog);
            this.comboStatus.setSelectedItem((Object)ForegrdStautsEnum.SAVED);
            this.btnSuspend.setText(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"151_BarcodeScanningEditUI"));
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (this.prmtConfigName.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"168_BarcodeScanningEditUI"));
            SysUtil.abort();
        }
        if (this.isValueNull(this.txtNumber.getText()) && this.isAddView) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"169_BarcodeScanningEditUI"));
            SysUtil.abort();
        }
        String bosType = "";
        for (int i = 0; i < this.kdtpEntry.getTabCount(); ++i) {
            KDTable table = (KDTable)this.kdtpEntry.getComponentAt(i);
            String chiledBosType = this.getBosType(table, TB_BOSTYPE);
            String parentBosType = this.getBosType(table, TB_PARENTBOSTYPE);
            if (parentBosType.equals(new BarcodeScanningInfo().getBOSType().toString())) {
                bosType = this.getBosType(table, TB_BOSTYPE);
                if (table.getRowCount3() == 0) {
                    MsgBox.showWarning((String)(this.kdtpEntry.getTitleAt(i) + EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"170_BarcodeScanningEditUI")));
                    SysUtil.abort();
                }
            }
            if (!chiledBosType.equals(bosType) || table.getRowCount3() != 0) continue;
            MsgBox.showWarning((String)(this.kdtpEntry.getTitleAt(i) + EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"170_BarcodeScanningEditUI")));
            SysUtil.abort();
        }
    }

    @Override
    public void loadFields() {
        this.initUserConfig();
        super.loadFields();
        ArrayList<BarcodeScanningRecodeInfo> recodesList = new ArrayList();
        try {
            if (!this.oprtState.equals("ADDNEW")) {
                BarcodeConfigInfo configInfo = (BarcodeConfigInfo)this.prmtConfigName.getValue();
                BarcodeConfigXML configXml = BarcodeXMLHelper.toBarcodeConfigXML(configInfo.getDetailsXML());
                this.initDetails(configInfo);
                Object o = BarcodeScanningFactory.getRemoteInstance().getRecodesList(this.editData.getId().toString(), configXml);
                if (o != null) {
                    recodesList = (List)o;
                    this.editData.setScanRecodeList(recodesList);
                    if (this.tblBarcode.getRowCount3() > 0) {
                        this.tblBarcode.removeRows();
                    }
                    if (this.tblSeq.getRowCount3() > 0) {
                        this.tblSeq.removeRows();
                    }
                    this.loadScanRecods(recodesList, null);
                }
            }
            this.initDefaultSolution();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handleException(e);
        }
    }

    protected void loadScanRecods(List<BarcodeScanningRecodeInfo> recodesList, String entryName) {
        for (int j = 0; j < this.kdtpEntry.getTabCount(); ++j) {
            KDTable table = (KDTable)this.kdtpEntry.getComponentAt(j);
            String tblName = table.getName();
            if ((tblName != null || entryName != null) && (tblName == null || entryName == null || !tblName.substring(tblName.lastIndexOf(".") + 1).equals(entryName))) continue;
            List<Object> childRecodsList = new ArrayList();
            String key = null;
            if (this.isValueNull(tblName) && table.getRowCount3() > 0) {
                table.removeRows();
            }
            if (recodesList.size() > 0) {
                this.parentIdMap.put(recodesList.get(recodesList.size() - 1).getFbosType(), recodesList.get(0).getFid());
            }
            EntityObjectInfo entity = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)this.getBosType(table, TB_BOSTYPE)));
            int startIndex = table.getRowCount3();
            for (int i = 0; i < recodesList.size(); ++i) {
                Map<String, List<BarcodeScanningRecodeInfo>> entryMap;
                IRow row = table.addRow(i + startIndex);
                BarcodeScanningRecodeInfo recodeInfo = recodesList.get(i);
                int rowNum = i + 1;
                String entityAlais = recodeInfo.getFentityAlias();
                Map<String, BarcodeScanningPropertyInfo> properties = recodeInfo.getProperties();
                for (int k = 0; k < table.getColumnCount(); ++k) {
                    String filed = table.getColumnKey(k);
                    BarcodeScanningPropertyInfo propertyInfo = properties.get(filed);
                    PropertyInfo property = entity.getPropertyByName(filed);
                    if (property != null) {
                        BarcodeClientUtils.setSingleCellValue(row.getCell(filed), property, propertyInfo.getValue() == null ? null : propertyInfo.getValue().toString());
                        continue;
                    }
                    row.getCell(filed).setValue(propertyInfo == null ? null : propertyInfo.getValue());
                }
                this.loadBarcodeAndSeq(recodeInfo, rowNum, entityAlais);
                if (!this.isCountTableForDestBosType()) {
                    this.mergAfterLoad(table);
                }
                if ((entryMap = recodeInfo.getEntriesMap()) == null || entryMap.size() <= 0) continue;
                Object[] keys = entryMap.keySet().toArray();
                for (int m = 0; m < keys.length; ++m) {
                    key = keys[m].toString();
                    childRecodsList = entryMap.get(key);
                    if (childRecodsList.size() <= 0) continue;
                    this.loadScanRecods(childRecodsList, key);
                }
            }
        }
    }

    protected void loadBarcodeAndSeq(BarcodeScanningRecodeInfo recodeInfo, int rowNum, String entityAlais) {
        List<BarcodeScanningBarcodeInfo> barcodeList = recodeInfo.getBarcodeList();
        for (int k = 0; k < barcodeList.size(); ++k) {
            IRow bRow = this.tblBarcode.addRow();
            BarcodeScanningBarcodeInfo bsbi = barcodeList.get(k);
            bRow.getCell(BC_BARCODE).setValue((Object)bsbi.getBarcode());
            bRow.getCell(BC_BARCODERULEID).setValue((Object)bsbi.getBarcodeRuleId());
            bRow.getCell("parentBosType").setValue((Object)recodeInfo.getFbosType());
            bRow.getCell("parentId").setValue((Object)recodeInfo.getFid());
            bRow.getCell("entityAlais").setValue((Object)entityAlais);
            bRow.getCell("rowNum").setValue((Object)rowNum);
        }
    }

    protected void mergAfterLoad(KDTable table) {
        String scanQty = this.getScanOrSrcQtyFiled(table, false, true);
        String mergRowParentIds = "";
        if (TB_SRCQTY != null && scanQty != null) {
            IRow row;
            Object value;
            for (int f = 0; f < table.getRowCount3() && (value = (row = table.getRow(f)).getCell(TB_SRCBILLENTRYID).getValue()) != null; ++f) {
                String srcEtryId = value.toString();
                String fparentId = row.getCell(TB_PARENTID).getValue().toString();
                if (mergRowParentIds.equals(srcEtryId)) continue;
                int count = 0;
                for (int m = 0; m < table.getRowCount3(); ++m) {
                    if (m == f) continue;
                    String srcEid = table.getRow(m).getCell(TB_SRCBILLENTRYID).getValue().toString();
                    String pId = table.getRow(m).getCell(TB_PARENTID).getValue().toString();
                    if (!srcEtryId.equals(srcEid) || !fparentId.equals(pId)) continue;
                    ++count;
                }
                if (count <= 0) continue;
                table.getMergeManager().mergeBlock(f, table.getColumnIndex(TB_SRCQTY), f + count, table.getColumnIndex(TB_SRCQTY));
                table.getMergeManager().mergeBlock(f, table.getColumnIndex(TB_DIFQTY), f + count, table.getColumnIndex(TB_DIFQTY));
                mergRowParentIds = mergRowParentIds + srcEtryId;
            }
        }
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        KDTable table = (KDTable)this.kdtpEntry.getSelectedComponent();
        this.removeLine(table);
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            String bosType = this.getBosType(table, TB_BOSTYPE);
            List<KDTable> list = this.getChildTable(bosType);
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                String id = table.getRow(rowIndex).getCell(TB_ID).getValue().toString();
                this.removeRows(table, list, id);
                this.removeBarcodeRows(id, bosType);
                this.removeSeqRows(id, bosType);
                String scanFiled = this.getScanOrSrcQtyFiled(table, false, true);
                if (!this.isValueNull(scanFiled)) {
                    BigDecimal scanQty;
                    KDTMergeBlock merg = this.getMergeBolck(table, rowIndex);
                    Object scanValue = table.getRow(rowIndex).getCell(scanFiled).getValue();
                    BigDecimal bigDecimal = scanQty = this.isValueNull(scanValue) ? new BigDecimal("0") : new BigDecimal("-" + scanValue.toString());
                    if (merg != null && scanQty.compareTo(new BigDecimal("0")) != 0) {
                        scanQty = new BigDecimal("0");
                        this.cumSumQty(null, table, table.getRow(rowIndex), scanQty);
                        this.calculateDifQty(table, table.getRow(rowIndex), merg, null);
                    }
                }
                table.removeRow(rowIndex);
            }
            table.getSelectManager().remove();
        }
    }

    protected List<KDTable> getChildTable(String bosType) {
        ArrayList<KDTable> list = new ArrayList<KDTable>();
        for (int j = 0; j < this.kdtpEntry.getTabCount(); ++j) {
            KDTable cldTable = (KDTable)this.kdtpEntry.getComponentAt(j);
            String pBosType = this.getBosType(cldTable, TB_PARENTBOSTYPE);
            if (pBosType == null || !pBosType.equals(bosType)) continue;
            list.add(cldTable);
        }
        return list;
    }

    protected void removeRows(KDTable table, List<KDTable> childTableList, String id) {
        if (childTableList != null && childTableList.size() > 0) {
            for (int i = 0; i < childTableList.size(); ++i) {
                KDTable childTable = childTableList.get(i);
                for (int j = childTable.getRowCount3() - 1; j >= 0; --j) {
                    String parentId = childTable.getRow(j).getCell(TB_PARENTID).getValue().toString();
                    if (!parentId.equals(id)) continue;
                    String childId = childTable.getRow(j).getCell(TB_ID).getValue().toString();
                    List<KDTable> cldTableList = this.getChildTable(this.getBosType(childTable, TB_BOSTYPE));
                    this.removeRows(childTable, cldTableList, childId);
                    childTable.removeRow(j);
                }
            }
        }
    }

    protected void removeBarcodeRows(String id, String bosType) {
        int size = this.tblBarcode.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow barcodeRow = this.tblBarcode.getRow(i);
            if (barcodeRow == null || barcodeRow.getCell("parentId").getValue() == null || barcodeRow.getCell("parentBosType").getValue() == null) continue;
            String parentID = barcodeRow.getCell("parentId").getValue().toString();
            String parentBosType = barcodeRow.getCell("parentBosType").getValue().toString();
            if (!parentID.equals(id) || !parentBosType.equals(bosType)) continue;
            this.tblBarcode.removeRow(i);
        }
    }

    protected void removeSeqRows(String id, String bosType) {
        int size = this.tblSeq.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow barcodeRow = this.tblSeq.getRow(i);
            if (barcodeRow.getCell("parentId").getValue() == null || barcodeRow.getCell("parentId").getValue() == null) continue;
            String parentID = barcodeRow.getCell("parentBosType").getValue().toString();
            String parentBosType = barcodeRow.getCell("parentBosType").getValue().toString();
            if (!parentID.equals(id) || !parentBosType.equals(bosType)) continue;
            this.tblSeq.removeRow(i);
        }
    }

    @Override
    public boolean isAutoExecutePackageBarcode() {
        return true;
    }

    @Override
    public void checkBarcodeAnalysisIds(List list, String barcode, String srcBosType, String destBosType) {
    }

    @Override
    public void afterexecuteBarcode(String barcode, String destBosType, String transTypeNumber) {
        try {
            BarcodeDossierFactory.getRemoteInstance().updateBarcodeStatus(barcode, 1, destBosType, transTypeNumber);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionImportCheck_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow impUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BarcodeDataImport.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        impUI.show();
        IUIObject selUI = impUI.getUIObject();
        Map<String, Object> barcodeMap = ((BarcodeDataImport)selUI).getBarcodeMap();
        if (barcodeMap.size() > 0) {
            List barcodeList = (List)barcodeMap.get("barcodeList");
            int importType = Integer.valueOf(barcodeMap.get("importType").toString());
            int size = barcodeList.size();
            for (int i = 0; i < size; ++i) {
                String barcode = barcodeList.get(i).toString();
                this.executeBarcode(barcode);
            }
        }
    }
}

