/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.barcode.scm.BarcodeConfigFactory;
import com.kingdee.eas.barcode.scm.BarcodeConfigInfo;
import com.kingdee.eas.barcode.scm.ForegrdStautsEnum;
import com.kingdee.eas.barcode.scm.OrgUnitUtils;
import com.kingdee.eas.barcode.scm.client.AbstractBarcodeScanningFilterUI;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.scm.common.filter.QueryFilterManager;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.EnumUtils;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class BarcodeScanningFilterUI
extends AbstractBarcodeScanningFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BarcodeScanningFilterUI.class);
    private QueryFilterManager manager = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.comboStatus.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.barcode.scm.ForegrdStautsEnum").toArray());
        OrgUnitCollection coll = OrgUnitUtils.getAuthOrgByPermItem(null, OrgType.ControlUnit, "barcodeScan_view");
        String permissionCuStr = OrgUnitUtils.toStringList(coll, "number");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cu.number", (Object)permissionCuStr, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtConfigName.setEntityViewInfo(view);
    }

    public boolean verify() {
        if (this.prmtConfigName.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"171_BarcodeScanningFilterUI"));
            this.prmtConfigName.requestFocus();
            return false;
        }
        if (this.pkCreateFrom.getTimestamp() != null && this.pkCreateTo.getTimestamp() != null) {
            Timestamp dt2;
            Timestamp dt1 = this.pkCreateFrom.getTimestamp();
            if (dt1.after((Date)(dt2 = this.pkCreateTo.getTimestamp()))) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"174_BarcodeScanningFilterUI"));
                this.pkCreateFrom.requestFocus();
                return false;
            }
            if (dt2.before((Date)dt1)) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"174_BarcodeScanningFilterUI"));
                this.pkCreateFrom.requestFocus();
                return false;
            }
        }
        return true;
    }

    public FilterInfo getFilterInfo() {
        String scanNumber;
        this.filterInfo = super.getFilterInfo();
        this.filterInfo = new FilterInfo();
        Object o = this.prmtConfigName.getValue();
        if (o != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("configName.number", (Object)((BarcodeConfigInfo)o).getNumber()));
        }
        if ((scanNumber = this.txtNumber.getText()) != null && !scanNumber.equals("")) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)scanNumber));
        }
        if (this.comboStatus.getSelectedItem() != ForegrdStautsEnum.All) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)this.comboStatus.getSelectedIndex()));
        }
        if ((o = this.pkCreateFrom.getValue()) != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("fromCreateTime", o, CompareType.GREATER_EQUALS));
        }
        if ((o = this.pkCreateTo.getValue()) != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Calendar cd = Calendar.getInstance();
            try {
                cd.setTime(sdf.parse(sdf.format(o)));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            cd.add(5, 1);
            this.filterInfo.getFilterItems().add(new FilterItemInfo("toCreateTime", (Object)cd.getTime(), CompareType.LESS_EQUALS));
        }
        return this.filterInfo;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        Object value = this.prmtConfigName.getValue();
        if (value != null) {
            BarcodeConfigInfo configInfo = (BarcodeConfigInfo)value;
            cp.addCustomerParam("configName.number", configInfo.getId().toString());
        }
        if ((value = this.txtNumber.getText()) != null && !value.equals("")) {
            cp.addCustomerParam("number", value.toString());
        }
        if (value != null) {
            cp.putInt("status", this.comboStatus.getSelectedIndex());
        }
        value = this.pkCreateFrom.getValue();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (value != null) {
            cp.addCustomerParam("fromCreateTime", sdf.format(value));
        }
        if ((value = this.pkCreateTo.getValue()) != null) {
            cp.addCustomerParam("toCreateTime", sdf.format(value));
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        this.clear();
        EntityViewInfo evi = new EntityViewInfo();
        String value = cp.getCustomerParam("configName.number");
        if (value != null && !value.equals("")) {
            try {
                BarcodeConfigInfo configInfo = BarcodeConfigFactory.getRemoteInstance().getBarcodeConfigInfo((IObjectPK)new ObjectUuidPK(value));
                this.prmtConfigName.setValue((Object)configInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((value = cp.getCustomerParam("number")) != null && !value.equals("")) {
            this.txtNumber.setText(value);
        }
        this.comboStatus.setSelectedIndex(cp.getInt("status"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        value = cp.getCustomerParam("fromCreateTime");
        try {
            if (value != null && !value.equals("")) {
                this.pkCreateFrom.setValue((Object)sdf.parse(value));
            }
            if ((value = cp.getCustomerParam("toCreateTime")) != null && !value.equals("")) {
                this.pkCreateTo.setValue((Object)sdf.parse(value));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void clear() {
        this.prmtConfigName.setValue(null);
        this.txtNumber.setText("");
        this.comboStatus.setSelectedIndex(0);
    }
}

