/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.ComponentProperty;
import com.kingdee.bos.appframework.databinding.DataComponentMap;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTMappingUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.scm.BarcodeAnalysisResult;
import com.kingdee.eas.barcode.scm.BarcodeAnalysisResultItem;
import com.kingdee.eas.barcode.scm.BarcodeConfigXML;
import com.kingdee.eas.barcode.scm.BarcodeConfigXMLDetail;
import com.kingdee.eas.barcode.scm.BarcodeConfigXMLProperty;
import com.kingdee.eas.barcode.scm.BarcodeDossierFactory;
import com.kingdee.eas.barcode.scm.BarcodeTypeEnum;
import com.kingdee.eas.barcode.scm.BarcodeXMLHelper;
import com.kingdee.eas.barcode.scm.IndBarcodeBackInfo;
import com.kingdee.eas.barcode.scm.IndDossierGenerateFacodeFactory;
import com.kingdee.eas.barcode.scm.ReflectUtil;
import com.kingdee.eas.barcode.scm.client.BarcodeComponent;
import com.kingdee.eas.barcode.scm.util.SerialNumberHelper;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeCollection;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreFlagEnum;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.client.SCMBillEditUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SplitOptionConfig;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberFactory;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberInfo;
import com.kingdee.eas.scm.im.inv.client.InvBillEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DefaultBarcodeComponent
extends BarcodeComponent {
    public BarcodeConfigXML xmlInfo;
    public static final String TB_SRCBILLENTRYID = "sourceBillEntryId";
    public static final String TB_SRCQTY = "@srcqty";
    public static final String TB_DIFQTY = "@difqty";
    public String TB_SCANQTY;
    public String scanQtyField;
    int rowNum = 0;

    @Override
    protected void analysisResult(BarcodeAnalysisResult barcodeResult) throws Exception {
        if (barcodeResult.isBarcodeRepeat()) {
            // empty if block
        }
        if (this.barcodeConfigInfo != null) {
            this.xmlInfo = BarcodeXMLHelper.toBarcodeConfigXML(this.barcodeConfigInfo.getDetailsXML());
            this.initInstanceVar(this.xmlInfo);
            if (!this.isValueNull(this.barcodeConfigInfo.getSrcBosType())) {
                this.fillNomarlBarcodeInSrcBill(barcodeResult);
            } else {
                this.fillNomarlBarcodeNoSrcBill(barcodeResult);
            }
        } else {
            MsgBox.showWarning((String)"\u672a\u627e\u5230\u626b\u63cf\u914d\u7f6e");
        }
    }

    @Override
    protected int analysisResultForLog(BarcodeAnalysisResult barcodeResult) throws Exception {
        if (barcodeResult.isBarcodeRepeat()) {
            // empty if block
        }
        if (this.barcodeConfigInfo != null) {
            SCMBillEditUI invBillEditUI;
            SCMBillBaseInfo editData;
            this.xmlInfo = BarcodeXMLHelper.toBarcodeConfigXML(this.barcodeConfigInfo.getDetailsXML());
            this.initInstanceVar(this.xmlInfo);
            KDTable table = null;
            this.rowNum = -1;
            table = !this.isValueNull(this.barcodeConfigInfo.getSrcBosType()) ? this.fillNomarlBarcodeInSrcBill(barcodeResult) : this.fillNomarlBarcodeNoSrcBill(barcodeResult);
            table.checkParsed();
            if (this.coreUI instanceof SCMBillEditUI && ((editData = (SCMBillBaseInfo)(invBillEditUI = (SCMBillEditUI)this.coreUI).getEditData()) == null || editData.getId() == null)) {
                KDWorkButton btnSave = null;
                int size = this.coreUI.getUIToolBar().getComponentCount();
                for (int i = 0; i < size; ++i) {
                    Component componet = this.coreUI.getUIToolBar().getComponents()[i];
                    if (!"btnSave".equalsIgnoreCase(componet.getName())) continue;
                    if (!(componet instanceof KDWorkButton)) break;
                    btnSave = (KDWorkButton)componet;
                    break;
                }
                ActionEvent esave = new ActionEvent(btnSave, 0, "save");
                ((SCMBillEditUI)this.coreUI).actionSave_actionPerformed(esave);
            }
            if (BarcodeTypeEnum.nomarlBarcode.equals((Object)barcodeResult.getBarcodeType()) && this.coreUI instanceof InvBillEditUI && this.rowNum > -1 && table.getRow(this.rowNum) != null) {
                invBillEditUI = (InvBillEditUI)this.coreUI;
                IRow row = table.getRow(this.rowNum);
                MeasureUnitInfo measureUnit = null;
                MaterialInfo material = null;
                boolean isSerialNumber = false;
                ICell cell = row.getCell("unit");
                if (cell != null) {
                    measureUnit = (MeasureUnitInfo)cell.getValue();
                }
                if ((cell = row.getCell("materialNum")) != null) {
                    material = (MaterialInfo)cell.getValue();
                }
                if (material != null && measureUnit != null) {
                    isSerialNumber = this.isSerialNumberManger(row, measureUnit, material);
                }
                if (isSerialNumber) {
                    InvBillBaseInfo editData2 = (InvBillBaseInfo)invBillEditUI.getEditData();
                    cell = row.getCell("id");
                    String entryId = null;
                    IObjectValue entryValue = (IObjectValue)row.getUserObject();
                    if (cell != null && cell.getValue() != null) {
                        entryId = cell.getValue().toString();
                    }
                    if (editData2 == null || editData2.getId() == null || entryId == null) {
                        KDWorkButton btnSave = null;
                        int size = this.coreUI.getUIToolBar().getComponentCount();
                        for (int i = 0; i < size; ++i) {
                            Component componet = this.coreUI.getUIToolBar().getComponents()[i];
                            if (!"btnSave".equalsIgnoreCase(componet.getName())) continue;
                            if (!(componet instanceof KDWorkButton)) break;
                            btnSave = (KDWorkButton)componet;
                            break;
                        }
                        ActionEvent esave = new ActionEvent(btnSave, 0, "save");
                        ((SCMBillEditUI)this.coreUI).actionSave_actionPerformed(esave);
                        table.getEditManager().editCellAt(this.rowNum, 0);
                        editData2 = (InvBillBaseInfo)invBillEditUI.getEditData();
                        entryValue = (IObjectValue)row.getUserObject();
                    }
                    if (entryValue.get("seq") == null) {
                        entryValue.put("seq", (Object)this.rowNum);
                    }
                    SerialNumberHelper serialNumberHelper = new SerialNumberHelper();
                    LinkedHashMap<String, List<CoreBaseInfo>> entryIdBarcodeMap = new LinkedHashMap<String, List<CoreBaseInfo>>();
                    ArrayList<IndBarcodeBackInfo> baseInfoList = new ArrayList<IndBarcodeBackInfo>();
                    IndBarcodeBackInfo barcodeBackInfo = new IndBarcodeBackInfo();
                    barcodeBackInfo.put("name", barcodeResult.getBarcode());
                    baseInfoList.add(barcodeBackInfo);
                    if (entryValue.get("id") == null) {
                        entryValue.put("id", (Object)entryId);
                    }
                    entryIdBarcodeMap.put(entryValue.get("id").toString(), baseInfoList);
                    MaterialSerialNumberInfo serrialNumberInfo = serialNumberHelper.createSerialNumberInfo(null, (IObjectValue)editData2, entryValue, entryIdBarcodeMap);
                    MaterialSerialNumberFactory.getRemoteInstance().saveSerialNumber(serrialNumberInfo);
                }
            }
            if (this.rowNum > -1) {
                HashMap<String, Object> pramMap = new HashMap<String, Object>();
                pramMap.put("editData", this.coreUI.getDataObject());
                if (table.getRow(this.rowNum) != null && table.getRow(this.rowNum).getCell("id") != null && table.getRow(this.rowNum).getCell("id") != null) {
                    pramMap.put("rowNum", table.getRow(this.rowNum).getCell("id").getValue().toString());
                } else {
                    pramMap.put("rowNum", this.rowNum);
                }
                pramMap.put("barcode", barcodeResult.getBarcode());
                IndDossierGenerateFacodeFactory.getRemoteInstance().generateLogers(pramMap);
            }
            return this.rowNum + 1;
        }
        MsgBox.showWarning((String)"\u672a\u627e\u5230\u626b\u63cf\u914d\u7f6e");
        return -1;
    }

    @Override
    protected void analysisResultForInd(BarcodeAnalysisResult barcodeResult) throws Exception {
        if (barcodeResult.isBarcodeRepeat()) {
            // empty if block
        }
        this.fillNomarlBarcodeNoSrcBillForInd(barcodeResult);
    }

    protected void initInstanceVar(BarcodeConfigXML xmlInfo) throws BOSException {
        if (xmlInfo != null && xmlInfo.getBotpId() != null) {
            if (this.coreUI.getUIContext().get("@botpDestEntryName") != null) {
                this.botpSrcEntryName = (String)this.coreUI.getUIContext().get("@botpSrcEntryName");
                this.botpDestEntryName = (String)this.coreUI.getUIContext().get("@botpDestEntryName");
            } else if (this.barcodeConfigInfo.getBotMapping() != null && this.barcodeConfigInfo.getBotMapping().getId() != null) {
                BOTMappingInfo mappingInfo = BOTMappingFactory.getRemoteInstance().getMappingInfoByPK((IObjectPK)new ObjectUuidPK(this.barcodeConfigInfo.getBotMapping().getId().toString()));
                this.botpSrcEntryName = BOTMappingUtil.getSrcEntriesName((BOTMappingInfo)mappingInfo);
                this.botpDestEntryName = BOTMappingUtil.getDestEntriesName((BOTMappingInfo)mappingInfo);
            }
            this.scanQtyField = this.getScanQtyFiled();
        }
    }

    protected KDTable fillNomarlBarcodeInSrcBill(BarcodeAnalysisResult barcodeResult) throws Exception {
        Map<String, List<BarcodeAnalysisResultItem>> map = this.getItemsForEntryAndHead(barcodeResult.getItems());
        List<BarcodeAnalysisResultItem> entryItems = map.get("entryItems");
        List<BarcodeAnalysisResultItem> headItems = map.get("headItems");
        KDTable table = null;
        if (entryItems.size() > 0) {
            IRow row;
            ComponentProperty compProp = this.dcm.getComponentProperty(entryItems.get(0).getField());
            Component comp = compProp.getComponent();
            table = (KDTable)comp;
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)table);
            if (selectRows.length > 0) {
                int selectRowIndx = selectRows[0];
                IRow selectRow = table.getRow(selectRowIndx);
                boolean isMatch = this.isMtchForSelectRow(entryItems, table, selectRow);
                if (isMatch) {
                    this.fillBarcodeAnalysisResultToRow(entryItems, selectRow, table);
                    this.cumSumQty(entryItems, table, selectRow, barcodeResult.isCumsumQty());
                    this.rowNum = selectRowIndx;
                } else {
                    this.fillBarcodeInSrc(barcodeResult, entryItems, table, -1);
                }
            } else {
                this.fillBarcodeInSrc(barcodeResult, entryItems, table, -1);
            }
            if (this.rowNum > -1 && (row = table.getRow(this.rowNum)).getCell("id") != null && row.getCell("id").getValue() == null) {
                row.getCell("id").setValue((Object)BOSUuid.create((String)barcodeResult.getBosType()));
            }
        }
        if (headItems.size() > 0) {
            this.fillHead(headItems);
            if (entryItems.size() == 0) {
                this.rowNum = -1;
            }
        }
        return table;
    }

    protected KDTMergeBlock getMergeBolck(KDTable table, int rowIndex, int colIndex) {
        KDTMergeBlock merg = null;
        merg = table.getMergeManager().getMergeBlockOfCell(rowIndex, colIndex);
        return merg;
    }

    protected void fillBarcodeInSrc(BarcodeAnalysisResult barcodeResult, List<BarcodeAnalysisResultItem> items, KDTable table, int scanCompletedRowIdx) throws Exception {
        Map map = this.getMatchResult(items, table, barcodeResult.isCumsumQty(), scanCompletedRowIdx, true);
        int matchRowIndex = new BigDecimal(map.get("matchRowIndex").toString()).intValue();
        int someMatchRowIndex = new BigDecimal(map.get("someMatchRowIndex").toString()).intValue();
        Boolean isNoMatchItemForRule = (Boolean)map.get("isNoMatchItemForRule");
        int someCellVaueNullRowIndex = new BigDecimal(map.get("someCellVaueNullRowIndex").toString()).intValue();
        IRow row = table.getRow(0);
        boolean isCumsum = barcodeResult.isCumsumQty();
        if (!isNoMatchItemForRule.booleanValue() && matchRowIndex == -1 && someMatchRowIndex == -1) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"153_BarcodeScanningEditUI"));
            SysUtil.abort();
        }
        if (isCumsum && !isNoMatchItemForRule.booleanValue()) {
            if (matchRowIndex != -1 || this.isSumForSomeMtchItem(someMatchRowIndex, table, items)) {
                BigDecimal difQty;
                row = table.getRow(matchRowIndex == -1 ? someMatchRowIndex : matchRowIndex);
                Object oDif = null;
                if (row.getCell(TB_DIFQTY) != null) {
                    oDif = row.getCell(TB_DIFQTY).getValue();
                }
                if (oDif != null && (difQty = this.getDifQty(items, row)).doubleValue() <= 0.0) {
                    boolean result = this.isScanNext(barcodeResult, items, table, row);
                    if (result) {
                        this.fillBarcodeInSrc(barcodeResult, items, table, this.getCompleteScanRowIdx(table, row));
                        return;
                    }
                    if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"156_BarcodeScanningEditUI")) != 0) {
                        SysUtil.abort();
                    }
                }
            } else {
                IRow someMathcRow = table.getRow(someMatchRowIndex);
                if (this.isScanNext(barcodeResult, items, table, someMathcRow)) {
                    this.fillBarcodeInSrc(barcodeResult, items, table, this.getCompleteScanRowIdx(table, someMathcRow));
                    return;
                }
                row = this.splitRow(table, someMathcRow, items);
            }
        } else {
            int rowIndx;
            int n = rowIndx = someMatchRowIndex == -1 ? matchRowIndex : someMatchRowIndex;
            if (rowIndx != -1) {
                row = table.getRow(rowIndx);
            } else if (someCellVaueNullRowIndex != -1) {
                row = table.getRow(someCellVaueNullRowIndex);
            } else {
                return;
            }
        }
        if (row == null) {
            return;
        }
        this.fillBarcodeAnalysisResultToRow(items, row, table);
        this.cumSumQty(items, table, row, isCumsum);
        this.rowNum = row.getRowIndex();
    }

    private BigDecimal getDifQty(List<BarcodeAnalysisResultItem> items, IRow row) {
        Object difQtyCellValue = row.getCell(TB_DIFQTY).getValue();
        BigDecimal diffQty = this.isValueNull(difQtyCellValue) ? new BigDecimal("0") : new BigDecimal(difQtyCellValue.toString());
        BigDecimal scanQty = this.getScanQty(items);
        diffQty = diffQty.subtract(scanQty);
        return diffQty;
    }

    private BigDecimal getScanQty(List<BarcodeAnalysisResultItem> items) {
        BigDecimal qty = new BigDecimal("0");
        String scanFiled = this.getScanQtyFiled();
        for (int i = 0; i < items.size(); ++i) {
            String filed = items.get(i).getField();
            if (!scanFiled.equals(filed)) continue;
            if (items.get(i).getValue() != null) {
                String qtyStr = items.get(i).getValue().toString();
                qty = new BigDecimal(qtyStr);
                break;
            }
            qty = new BigDecimal("1");
            break;
        }
        return qty;
    }

    protected boolean isScanNext(BarcodeAnalysisResult barcodeResult, List<BarcodeAnalysisResultItem> items, KDTable table, IRow sumRow) {
        BigDecimal difQty = this.getDifQty(table, sumRow, items.get(0).getField());
        boolean result = false;
        if (difQty.intValue() <= 0) {
            Map nexMap = this.getMatchResult(items, table, barcodeResult.isCumsumQty(), this.getCompleteScanRowIdx(table, sumRow), true);
            int nextMatchRowIndex = new BigDecimal(nexMap.get("matchRowIndex").toString()).intValue();
            int nextSomeMatchRowIndex = new BigDecimal(nexMap.get("someMatchRowIndex").toString()).intValue();
            if (nextMatchRowIndex != -1 || nextSomeMatchRowIndex != -1) {
                result = true;
            }
        }
        return result;
    }

    protected IRow splitRow(KDTable table, IRow row, List<BarcodeAnalysisResultItem> items) throws Exception {
        if (!ReflectUtil.isInstanceof(this.coreUI, "com.kingdee.eas.scm.common.client.SCMBillEditUI")) {
            return null;
        }
        int rowIndex = row.getRowIndex();
        SCMBillEditUI temp = (SCMBillEditUI)this.coreUI;
        table.getSelectManager().select(row.getRowIndex(), 0);
        SplitOptionConfig soc = (SplitOptionConfig)ReflectUtil.getFieldObject(temp.getClass(), "splitOptConf", temp);
        if (soc == null) {
            soc = new SplitOptionConfig(temp.getClass().getName());
        }
        int splitNum = soc.getSplitNum();
        int splitPos = soc.getSplitPos();
        int splitType = soc.getSplitType();
        soc.setSplitNum(2);
        soc.setSplitPos(0);
        soc.setSplitType(1);
        int preRowCount = table.getRowCount();
        temp.actionSplitLine_actionPerformed(null);
        if (table.getRowCount() == preRowCount) {
            return null;
        }
        soc.setSplitNum(splitNum);
        soc.setSplitPos(splitPos);
        soc.setSplitType(splitType);
        IRow splitRow = table.getRow(rowIndex + 1);
        KDTMergeBlock merg = this.getMergeBolck(table, rowIndex, table.getColumnIndex(TB_SRCQTY));
        if (merg == null && table.getColumn(TB_SRCQTY) != null) {
            int colunmIndex = table.getColumn(TB_SRCQTY).getColumnIndex();
            table.getMergeManager().mergeBlock(rowIndex, colunmIndex, rowIndex + 1, colunmIndex);
            int difQtyColIdx = table.getColumn(TB_DIFQTY).getColumnIndex();
            table.getMergeManager().mergeBlock(rowIndex, difQtyColIdx, rowIndex + 1, difQtyColIdx);
            merg = this.getMergeBolck(table, rowIndex, colunmIndex);
        }
        this.putValue(splitRow.getCell(this.getScanQtyColumnKey()), table, new BigDecimal("0"), null);
        return splitRow;
    }

    protected KDTable fillNomarlBarcodeNoSrcBill(BarcodeAnalysisResult barcodeResult) {
        Map<String, List<BarcodeAnalysisResultItem>> map = this.getItemsForEntryAndHead(barcodeResult.getItems());
        List<BarcodeAnalysisResultItem> entryItems = map.get("entryItems");
        List<BarcodeAnalysisResultItem> headItems = map.get("headItems");
        KDTable table = null;
        if (entryItems.size() > 0) {
            ComponentProperty compProp = this.dcm.getComponentProperty(entryItems.get(0).getField());
            Component comp = compProp.getComponent();
            table = (KDTable)comp;
            if (table.getRowCount3() == 0) {
                ReflectUtil.invoke(this.coreUI, "addLine", new Class[]{table.getClass()}, new Object[]{table});
            }
            IRow row = table.getRow(0);
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)table);
            if (selectRows.length > 0) {
                int selectRowIndx = selectRows[0];
                row = table.getRow(selectRowIndx);
                boolean isMatch = this.isMtchForSelectRow(entryItems, table, row);
                if (isMatch) {
                    this.fillBarcodeAnalysisResultToRow(entryItems, row, table);
                    this.cumSumQty(entryItems, table, row, barcodeResult.isCumsumQty());
                    this.rowNum = selectRowIndx;
                } else {
                    this.fillBarcodeNoSrc(barcodeResult, entryItems, table, "");
                }
            } else {
                this.fillBarcodeNoSrc(barcodeResult, entryItems, table, "");
            }
            if (this.rowNum > -1 && (row = table.getRow(this.rowNum)).getCell("id") != null && row.getCell("id").getValue() == null) {
                row.getCell("id").setValue((Object)BOSUuid.create((String)barcodeResult.getBosType()));
            }
        }
        if (headItems.size() > 0) {
            this.fillHead(headItems);
            if (entryItems.size() == 0) {
                this.rowNum = -1;
            }
        }
        return table;
    }

    protected void fillNomarlBarcodeNoSrcBillForInd(BarcodeAnalysisResult barcodeResult) {
        Map<String, List<BarcodeAnalysisResultItem>> map = this.getItemsForEntryAndHead(barcodeResult.getItems());
        List<BarcodeAnalysisResultItem> entryItems = map.get("entryItems");
        List<BarcodeAnalysisResultItem> headItems = map.get("headItems");
        if (entryItems.size() > 0) {
            ComponentProperty compProp = this.dcm.getComponentProperty(entryItems.get(0).getField());
            Component comp = compProp.getComponent();
            KDTable table = (KDTable)comp;
            if (table.getRowCount3() == 0) {
                ReflectUtil.invoke(this.coreUI, "addLine", new Class[]{table.getClass()}, new Object[]{table});
            }
            IRow row = table.getRow(0);
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)table);
            if (selectRows.length > 0) {
                int selectRowIndx = selectRows[0];
                row = table.getRow(selectRowIndx);
                boolean isMatch = this.isMtchForSelectRow(entryItems, table, row);
                if (isMatch) {
                    this.fillBarcodeAnalysisResultToRowForInd(entryItems, row, table);
                    this.cumSumQty(entryItems, table, row, barcodeResult.isCumsumQty());
                }
            } else {
                row = table.addRow();
                this.fillBarcodeAnalysisResultToRowForInd(entryItems, row, table);
                this.cumSumQty(entryItems, table, row, barcodeResult.isCumsumQty());
            }
        } else if (headItems.size() > 0) {
            this.fillHead(headItems);
        }
    }

    private void fillHead(List<BarcodeAnalysisResultItem> headItems) {
        for (int i = 0; i < headItems.size(); ++i) {
            BarcodeAnalysisResultItem item = headItems.get(i);
            ComponentProperty compProp = this.dcm.getComponentProperty(item.getField());
            Component comp = compProp.getComponent();
            this.putValue(comp, item.getValue(), item.getField());
        }
    }

    protected void fillBarcodeNoSrc(BarcodeAnalysisResult barcodeResult, List<BarcodeAnalysisResultItem> items, KDTable table, String entityAlais) {
        boolean isSum = barcodeResult.isCumsumQty();
        IRow row = table.getRow(0);
        Map map = this.getMatchResult(items, table, barcodeResult.isCumsumQty(), -1, false);
        int matchRowIndex = new BigDecimal(map.get("matchRowIndex").toString()).intValue();
        int someMatchRowIndex = new BigDecimal(map.get("someMatchRowIndex").toString()).intValue();
        int someCellVaueNullRowIndex = new BigDecimal(map.get("someCellVaueNullRowIndex").toString()).intValue();
        if (matchRowIndex != -1 || this.isSumForSomeMtchItem(someMatchRowIndex, table, items)) {
            row = table.getRow(matchRowIndex == -1 ? someMatchRowIndex : matchRowIndex);
        } else if (!isSum && someCellVaueNullRowIndex != -1) {
            row = table.getRow(someCellVaueNullRowIndex);
        } else {
            row = null;
            if (this.coreUI instanceof CoreBillEditUI) {
                ReflectUtil.invoke(this.coreUI, "addLine", new Class[]{table.getClass()}, new Object[]{table});
                row = table.getRow(table.getRowCount3() - 1);
            }
        }
        if (row == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"153_BarcodeScanningEditUI"));
            SysUtil.abort();
        }
        this.fillBarcodeAnalysisResultToRow(items, row, table);
        this.cumSumQty(items, table, row, isSum);
        this.rowNum = row.getRowIndex();
    }

    public BigDecimal getDifQty(KDTable table, IRow row, String filedName) {
        return new BigDecimal("1");
    }

    protected int getCompleteScanRowIdx(KDTable table, IRow row) {
        int rowIndex = row.getRowIndex();
        IObjectValue currRowValue = (IObjectValue)row.getUserObject();
        Object srcEntryIdO = currRowValue.get(TB_SRCBILLENTRYID);
        if (srcEntryIdO != null && !srcEntryIdO.equals("")) {
            int i = row.getRowIndex() + 1;
            while (i < table.getRowCount3()) {
                String srcEntryId = ((IObjectValue)table.getRow(i).getUserObject()).getString(TB_SRCBILLENTRYID);
                if (!srcEntryIdO.toString().equals(srcEntryId)) break;
                rowIndex = i++;
            }
        }
        return rowIndex;
    }

    protected void fillBarcodeAnalysisResultToRow(List<BarcodeAnalysisResultItem> items, IRow row, KDTable table) {
        for (int i = 0; i < items.size(); ++i) {
            Object value;
            String colName;
            ICell cell;
            ComponentProperty compProp;
            BarcodeAnalysisResultItem item = items.get(i);
            String filed = item.getField();
            if (filed.equals(this.getScanQtyFiled()) || (compProp = this.dcm.getComponentProperty(filed)) == null || (cell = row.getCell(colName = compProp.getPropertyName())) == null || (!item.getIsMatchItem() || !this.isValueNull(cell.getValue())) && item.getIsMatchItem()) continue;
            Object object = value = item.getNumber() != null ? item.getNumber() : item.getValue();
            if (this.isValueNull(value)) continue;
            this.putValue(cell, table, value, filed);
        }
    }

    protected void fillBarcodeAnalysisResultToRowForInd(List<BarcodeAnalysisResultItem> items, IRow row, KDTable table) {
        for (int i = 0; i < items.size(); ++i) {
            Object value;
            BarcodeAnalysisResultItem item = items.get(i);
            String filed = item.getField();
            ComponentProperty compProp = this.dcm.getComponentProperty(filed);
            String colName = compProp.getPropertyName();
            ICell cell = row.getCell(colName);
            if (cell == null || (!item.getIsMatchItem() || !this.isValueNull(cell.getValue())) && item.getIsMatchItem()) continue;
            Object object = value = item.getNumber() != null ? item.getNumber() : item.getValue();
            if (this.isValueNull(value)) continue;
            this.putValue(cell, table, value, filed);
        }
    }

    protected boolean isSumForSomeMtchItem(int someMatchRowIndex, KDTable table, List<BarcodeAnalysisResultItem> items) {
        if (someMatchRowIndex == -1) {
            return false;
        }
        Object scanQtyValue = null;
        if (this.getScanQtyColumnKey() != null) {
            scanQtyValue = table.getRow(someMatchRowIndex).getCell(this.getScanQtyColumnKey()).getValue();
        }
        if (this.isValueNull(scanQtyValue)) {
            return true;
        }
        BigDecimal scanQty = new BigDecimal("0.00");
        try {
            scanQty = new BigDecimal(scanQtyValue.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return scanQty.compareTo(new BigDecimal("0.00")) == 0;
    }

    protected Map getMatchResult(List<BarcodeAnalysisResultItem> items, KDTable table, boolean isCumSumQty, int scanCompletedRowIdx, boolean hasSrcBill) {
        LinkedHashMap<String, Constable> map = new LinkedHashMap<String, Constable>();
        int someMatchRowIndex = -1;
        int matchRowIndex = -1;
        int someCellVaueNullRowIndex = -1;
        Boolean isNoMatchItemForRule = false;
        for (int j = scanCompletedRowIdx + 1; j < table.getRowCount3(); ++j) {
            int cellNullCount = 0;
            int count = 0;
            int matchCount = 0;
            int notMatchCount = 0;
            int equal = 0;
            int srcAndScanCount = 0;
            IRow row = table.getRow(j);
            int size = items.size();
            for (int k = 0; k < items.size(); ++k) {
                BarcodeAnalysisResultItem item = items.get(k);
                String filed = item.getField();
                DataComponentMap dcm = this.dataBinder.getDataComponentMap();
                ComponentProperty compProp = dcm.getComponentProperty(filed);
                if (compProp == null) {
                    --size;
                    continue;
                }
                String colName = compProp.getPropertyName();
                if (!filed.equals(this.getScanQtyFiled())) {
                    ICell cell = row.getCell(colName);
                    if (cell == null) continue;
                    Object cellValue = cell.getValue();
                    if (item.getIsMatchItem()) {
                        ++matchCount;
                        if (this.isValueNull(cellValue)) {
                            ++count;
                        }
                        if (this.isValueNull(cellValue) || this.isValueNull(item.getValue())) continue;
                        if (item.isLinkedProperty()) {
                            cellValue = ((IObjectValue)cellValue).getString("number");
                        }
                        if (!cellValue.toString().trim().equals(item.getValue().toString().trim())) continue;
                        ++count;
                        continue;
                    }
                    ++notMatchCount;
                    if (this.isValueNull(cellValue)) {
                        ++equal;
                        ++cellNullCount;
                    }
                    if (this.isValueNull(cellValue) || this.isValueNull(item.getValue())) continue;
                    if (item.isLinkedProperty() && cellValue instanceof IObjectValue) {
                        cellValue = ((IObjectValue)cellValue).getString("number");
                    }
                    if (!cellValue.toString().trim().equals(item.getValue().toString().trim())) continue;
                    ++equal;
                    continue;
                }
                ++srcAndScanCount;
            }
            if (notMatchCount + srcAndScanCount == size) {
                if (cellNullCount != 0 && someCellVaueNullRowIndex == -1) {
                    someCellVaueNullRowIndex = j;
                }
                isNoMatchItemForRule = true;
                continue;
            }
            if (count != matchCount) continue;
            if (notMatchCount == equal && matchRowIndex == -1) {
                matchRowIndex = row.getRowIndex();
                continue;
            }
            if (notMatchCount == equal || someMatchRowIndex != -1) continue;
            someMatchRowIndex = row.getRowIndex();
        }
        if (hasSrcBill && isCumSumQty && matchRowIndex != -1 && someMatchRowIndex != -1) {
            someMatchRowIndex = -1;
        }
        map.put("someCellVaueNullRowIndex", Integer.valueOf(someCellVaueNullRowIndex));
        map.put("matchRowIndex", Integer.valueOf(matchRowIndex));
        map.put("someMatchRowIndex", Integer.valueOf(someMatchRowIndex));
        map.put("isNoMatchItemForRule", isNoMatchItemForRule);
        return map;
    }

    protected void cumSumQty(List<BarcodeAnalysisResultItem> items, KDTable table, IRow currRow) {
        BigDecimal qty = new BigDecimal("0");
        String scanFiled = this.getScanQtyFiled();
        ICell scanCell = currRow.getCell(this.getScanQtyColumnKey());
        if (scanCell == null) {
            return;
        }
        Object oldValue = scanCell.getValue();
        BigDecimal value = oldValue == null ? new BigDecimal("0") : new BigDecimal(oldValue.toString());
        for (int i = 0; i < items.size(); ++i) {
            String filed = items.get(i).getField();
            if (scanFiled.equals(filed)) {
                if (items.get(i).getValue() == null) continue;
                String qtyStr = items.get(i).getValue().toString();
                try {
                    BigDecimal scanQty = new BigDecimal(qtyStr);
                    qty = value.add(scanQty);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (scanFiled.equals(filed) || i != items.size() - 1) continue;
            qty = value.add(new BigDecimal("1"));
        }
        this.putValue(scanCell, table, qty, null);
    }

    protected void cumSumQty(List<BarcodeAnalysisResultItem> items, KDTable table, IRow currRow, boolean isSumQty) {
        BigDecimal qty = new BigDecimal("0");
        String scanFiled = this.getScanQtyFiled();
        ICell scanCell = currRow.getCell(this.getScanQtyColumnKey());
        if (scanCell == null) {
            return;
        }
        if (isSumQty) {
            Object oldValue = scanCell.getValue();
            BigDecimal value = oldValue == null ? new BigDecimal("0") : new BigDecimal(oldValue.toString());
            for (int i = 0; i < items.size(); ++i) {
                String filed = items.get(i).getField();
                if (scanFiled.equals(filed)) {
                    if (items.get(i).getValue() == null) continue;
                    String qtyStr = items.get(i).getValue().toString();
                    try {
                        BigDecimal scanQty = new BigDecimal(qtyStr);
                        qty = value.add(scanQty);
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                if (scanFiled.equals(filed) || i != items.size() - 1) continue;
                qty = value.add(new BigDecimal("1"));
            }
        } else {
            for (int i = 0; i < items.size(); ++i) {
                String filed = items.get(i).getField();
                if (!scanFiled.equals(filed) || items.get(i).getValue() == null) continue;
                String qtyStr = items.get(i).getValue().toString();
                try {
                    BigDecimal scanQty;
                    qty = scanQty = new BigDecimal(qtyStr);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.putValue(scanCell, table, qty, null);
    }

    protected Map<String, List<BarcodeAnalysisResultItem>> getItemsForEntryAndHead(List<BarcodeAnalysisResultItem> items) {
        HashMap<String, List<BarcodeAnalysisResultItem>> map = new HashMap<String, List<BarcodeAnalysisResultItem>>();
        ArrayList<BarcodeAnalysisResultItem> entryItems = new ArrayList<BarcodeAnalysisResultItem>();
        ArrayList<BarcodeAnalysisResultItem> headItems = new ArrayList<BarcodeAnalysisResultItem>();
        for (int i = 0; i < items.size(); ++i) {
            ComponentProperty compProp;
            BarcodeAnalysisResultItem item = items.get(i);
            if ("barcodeQ".equalsIgnoreCase(item.getField())) {
                entryItems.add(item);
            }
            if ((compProp = this.dcm.getComponentProperty(item.getField())) == null) continue;
            Component comp = compProp.getComponent();
            if (comp instanceof KDTable) {
                entryItems.add(item);
                continue;
            }
            headItems.add(item);
        }
        map.put("entryItems", entryItems);
        map.put("headItems", headItems);
        return map;
    }

    protected boolean isMtchForSelectRow(List<BarcodeAnalysisResultItem> items, KDTable table, IRow selectRow) {
        boolean isMatch = true;
        for (int j = 0; j < items.size(); ++j) {
            String filed;
            ComponentProperty compProp;
            String colName;
            ICell cell;
            BarcodeAnalysisResultItem item = items.get(j);
            if (!item.getIsMatchItem() || this.isValueNull((cell = selectRow.getCell(colName = (compProp = this.dcm.getComponentProperty(filed = item.getField())).getPropertyName())).getValue()) || this.isValueNull(item.getValue()) || this.mathText(cell, table, item.getValue(), filed)) continue;
            isMatch = false;
        }
        return isMatch;
    }

    protected String getScanQtyFiled() {
        if (this.scanQtyField != null) {
            return this.scanQtyField;
        }
        block0: for (int i = 0; i < this.xmlInfo.getDetails().size(); ++i) {
            BarcodeConfigXMLDetail xmlDetail = this.xmlInfo.getDetails().get(i);
            if (xmlDetail.getFullName() == null || this.botpDestEntryName != null && !xmlDetail.getFullName().equals(this.botpDestEntryName)) continue;
            List<BarcodeConfigXMLProperty> xmlPropertyList = xmlDetail.getProperties();
            for (int j = 0; j < xmlPropertyList.size(); ++j) {
                BarcodeConfigXMLProperty xmlProperty = xmlPropertyList.get(j);
                if (!xmlProperty.isScanQty()) continue;
                this.scanQtyField = xmlProperty.getFullName();
                continue block0;
            }
        }
        if (this.isValueNull(this.scanQtyField) && this.xmlInfo.getBotpId() != null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"162_BarcodeScanningEditUI"));
            SysUtil.abort();
        }
        return this.scanQtyField;
    }

    protected String getScanQtyColumnKey() {
        try {
            if (this.TB_SCANQTY == null && this.dcm != null) {
                ComponentProperty cp = this.dcm.getComponentProperty(this.getScanQtyFiled());
                if (this.getScanQtyFiled() != null) {
                    return cp.getPropertyName();
                }
            }
        }
        catch (Exception ex) {
            this.coreUI.handUIException((Throwable)ex);
        }
        return null;
    }

    @Override
    protected void afterBillBarcode(boolean isBotp) {
        if (isBotp) {
            this.clearScanQtyOfBill();
        }
    }

    protected void clearScanQtyOfBill() {
        this.xmlInfo = BarcodeXMLHelper.toBarcodeConfigXML(this.barcodeConfigInfo.getDetailsXML());
        for (int i = 0; i < this.xmlInfo.getDetails().size(); ++i) {
            int scanQtyIndex;
            ComponentProperty compProp;
            Component comp;
            BarcodeConfigXMLDetail xmlDetail = this.xmlInfo.getDetails().get(i);
            String entryName = xmlDetail.getFullName();
            if (this.isValueNull(entryName) || !entryName.equals(this.botpDestEntryName) || !((comp = (compProp = this.dcm.getComponentProperty(entryName)).getComponent()) instanceof KDTable)) continue;
            KDTable table = (KDTable)comp;
            String colunmName = this.getScanQtyColumnKey();
            if (colunmName == null) {
                return;
            }
            if (table.getColumn(TB_SRCQTY) != null && table.getColumn(TB_DIFQTY) != null) {
                table.removeColumn(table.getColumnIndex(TB_SRCQTY));
                table.removeColumn(table.getColumnIndex(TB_DIFQTY));
            }
            if ((scanQtyIndex = table.getColumnIndex(colunmName)) == -1) continue;
            this.addSrcQtyAndDiffQtyColumns(table, scanQtyIndex, colunmName);
            for (int j = 0; j < table.getRowCount3(); ++j) {
                ICell qtyCell = table.getCell(j, colunmName);
                Object srcQty = qtyCell.getValue();
                this.putValue(qtyCell, table, new BigDecimal("0"), null);
                table.getCell(j, TB_SRCQTY).setValue(srcQty);
                table.getCell(j, TB_DIFQTY).setValue(srcQty);
            }
        }
    }

    protected void addSrcQtyAndDiffQtyColumns(final KDTable table, int insertIndex, final String scanField) {
        IRow headRow = table.getHeadRow(0);
        table.addColumn(insertIndex).setKey(TB_SRCQTY);
        table.getColumn(TB_SRCQTY).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn(TB_SRCQTY).getStyleAttributes().setNumberFormat("0.00000000");
        table.getColumn(TB_SRCQTY).getStyleAttributes().setLocked(true);
        table.getColumn(TB_SRCQTY).getStyleAttributes().setFontColor(Color.BLUE);
        headRow.getCell(insertIndex).setValue((Object)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"146_BarcodeScanningEditUI"));
        table.addColumn(insertIndex + 2).setKey(TB_DIFQTY);
        table.getColumn(TB_DIFQTY).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn(TB_DIFQTY).getStyleAttributes().setNumberFormat("0.00000000");
        table.getColumn(TB_DIFQTY).getStyleAttributes().setLocked(true);
        table.getColumn(TB_DIFQTY).getStyleAttributes().setFontColor(Color.RED);
        headRow.getCell(insertIndex + 2).setValue((Object)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"148_BarcodeScanningEditUI"));
        table.addKDTEditListener(new KDTEditListener(){

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                int rowIndex = e.getRowIndex();
                int colIndex = e.getColIndex();
                if (colIndex == table.getColumnIndex(scanField)) {
                    try {
                        DefaultBarcodeComponent.this.calDiffQty(table, scanField, rowIndex);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
        try {
            if (ReflectUtil.isInstanceof(this.coreUI, "com.kingdee.eas.scm.im.inv.client.InvBillEditUI")) {
                ReflectUtil.invoke(this.coreUI, "initColIndexCacheMap");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void calDiffQty(KDTable table, String scanField, int rowIndex) {
        if (table.getColumn(TB_SRCQTY) == null || table.getColumn(TB_DIFQTY) == null) {
            return;
        }
        KDTMergeBlock merg = this.getMergeBolck(table, rowIndex, table.getColumnIndex(TB_SRCQTY));
        BigDecimal scanQty = new BigDecimal("0.00");
        BigDecimal srcQty = new BigDecimal("0.00");
        BigDecimal diffQty = new BigDecimal("0.00");
        if (merg != null) {
            int beginRowIdx = merg.getTop();
            int endRowIdx = merg.getBottom();
            srcQty = (BigDecimal)table.getCell(beginRowIdx, TB_SRCQTY).getValue();
            if (srcQty != null) {
                int x;
                for (x = beginRowIdx; x <= endRowIdx; ++x) {
                    scanQty = scanQty.add(new BigDecimal(table.getRow(x).getCell(this.getScanQtyColumnKey()).getValue().toString()));
                }
                diffQty = srcQty.subtract(scanQty);
                for (x = beginRowIdx; x <= endRowIdx; ++x) {
                    table.getRow(x).getCell(TB_DIFQTY).setValue((Object)diffQty);
                }
            }
        } else {
            scanQty = (BigDecimal)table.getCell(rowIndex, scanField).getValue();
            srcQty = (BigDecimal)table.getCell(rowIndex, TB_SRCQTY).getValue();
            if (srcQty != null) {
                table.getCell(rowIndex, TB_DIFQTY).setValue((Object)srcQty.subtract(scanQty));
            }
        }
    }

    protected boolean isValueNull(Object obj) {
        return obj == null || obj.toString().trim().equals("");
    }

    @Override
    public void checkBarcodeAnalysisIds(List list, String barcode, String srcBosType, String destBosType) {
    }

    @Override
    public void afterexecuteBarcode(String barcode, String destBosType, String transTypeNumber) {
        try {
            BarcodeDossierFactory.getRemoteInstance().updateBarcodeStatus(barcode, 1, destBosType, transTypeNumber);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    protected HashMap getQueryCondition(InvBillEditUI invEditUI, KDTable table, IRow row, InvBillBaseInfo editData) throws Exception {
        StorageOrgUnitInfo storageOrgUnitInfo;
        HashMap<String, Object> hm = new HashMap<String, Object>();
        boolean isView = false;
        hm.put("isView", new Boolean(isView));
        if (invEditUI.getMainOrgUnit() != null && (storageOrgUnitInfo = (StorageOrgUnitInfo)invEditUI.getMainOrgUnit().getData()) != null) {
            hm.put("STORAGEORGUNIT", storageOrgUnitInfo);
        }
        ComponentProperty compProp = this.dcm.getComponentProperty("transactionType");
        Component comp = compProp.getComponent();
        TransactionTypeInfo transactionTypeInfo = null;
        if (compProp != null && comp instanceof KDPromptBox) {
            KDPromptBox temp = (KDPromptBox)comp;
            transactionTypeInfo = (TransactionTypeInfo)temp.getData();
            hm.put("TRANSACTIONTYPE", transactionTypeInfo);
        }
        boolean isTableFocus = SCMClientUtils.isTableFocus((KDTable)table);
        hm.put("TABLEHASFOCUS", isTableFocus);
        String billTypeID = null;
        if (!editData.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD) && editData != null && editData.getId() != null) {
            hm.put("BILL", editData);
            if (editData != null && editData.getBillType() != null) {
                billTypeID = editData.getBillType().getId().toString();
                hm.put("BILLTYPE", billTypeID);
            }
        }
        String inORout = "";
        if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-0157c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-0167c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-0172c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-017bc0a812fd463ED552".equals(billTypeID)) {
            inORout = "in";
        } else if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-016ec0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-0177c0a812fd463ED552".equals(billTypeID)) {
            inORout = "out";
        }
        KDTSelectBlock selectBlock = table.getSelectManager().get();
        if (selectBlock != null) {
            KDPromptBox temp;
            TrackNumberInfo trackNumberInfo;
            ProjectInfo projectInfo;
            MeasureUnitInfo measureUnit;
            LocationInfo location;
            WarehouseInfo warehouse;
            AsstAttrValueInfo asstAttrValueInfo;
            if (row == null) {
                if (transactionTypeInfo != null && transactionTypeInfo != null) {
                    Map map = SCMBaseCommonUtil.getTranAllStoreTypeAndState((String)transactionTypeInfo.getId().toString(), (String)inORout);
                    List storeTypeList = (List)map.get("STORETYPE");
                    List storeStateList = (List)map.get("STORESTATE");
                    hm.put("STORETYPE", storeTypeList);
                    hm.put("STORESTATE", storeStateList);
                }
                return hm;
            }
            ICell cell = row.getCell("id");
            String entryId = null;
            if (cell != null && cell.getValue() != null) {
                entryId = cell.getValue().toString();
            }
            hm.put("BILLENTRYID", entryId);
            hm.put("BILLENTRYSEQ", String.valueOf(row.getRowIndex() + 1));
            StoreTypeInfo storeTypeInfo = null;
            StoreStateInfo storeStateInfo = null;
            InvUpdateTypeInfo invUpdateTypeInfo = null;
            if (row.getCell("invUpdateType") != null && (invUpdateTypeInfo = (InvUpdateTypeInfo)row.getCell("invUpdateType").getValue()) != null) {
                if ("in".equals(inORout)) {
                    storeTypeInfo = invUpdateTypeInfo.getStoreType();
                    storeStateInfo = invUpdateTypeInfo.getStoreState();
                } else if ("out".equals(inORout)) {
                    storeTypeInfo = invUpdateTypeInfo.getStoreTypePre();
                    storeStateInfo = invUpdateTypeInfo.getStoreStatePre();
                }
            }
            hm.put("INVUPDATETYPE", invUpdateTypeInfo);
            if (storeTypeInfo != null) {
                hm.put("STORETYPE", storeTypeInfo.getId().toString());
            }
            if (storeStateInfo != null) {
                hm.put("STORESTATE", storeStateInfo.getId().toString());
            }
            if (storeTypeInfo == null && storeStateInfo == null && transactionTypeInfo != null) {
                Map map = SCMBaseCommonUtil.getTranAllStoreTypeAndState((String)transactionTypeInfo.getId().toString(), (String)inORout);
                List storeTypeList = (List)map.get("STORETYPE");
                List storeStateList = (List)map.get("STORESTATE");
                hm.put("STORETYPE", storeTypeList);
                hm.put("STORESTATE", storeStateList);
            }
            if ((cell = row.getCell("materialNum")) != null) {
                MaterialInfo material = (MaterialInfo)cell.getValue();
                hm.put("MATERIAL", material);
            }
            if ((cell = row.getCell("assistProperty")) != null && (asstAttrValueInfo = (AsstAttrValueInfo)cell.getValue()) != null) {
                hm.put("ASSISTANTATTR", asstAttrValueInfo.getId().toString());
            }
            if ((cell = row.getCell("lot")) != null) {
                String lot = (String)cell.getValue();
                hm.put("BATCH", lot);
            }
            if ((cell = row.getCell("warehouse")) != null && (warehouse = (WarehouseInfo)cell.getValue()) != null) {
                hm.put("WAREHOUSE", warehouse.getId().toString());
            }
            if ((cell = row.getCell("location")) != null && (location = (LocationInfo)cell.getValue()) != null) {
                hm.put("LOCATION", location.getId().toString());
            }
            if ((cell = row.getCell("unit")) != null && (measureUnit = (MeasureUnitInfo)cell.getValue()) != null) {
                hm.put("UNIT", measureUnit.getId().toString());
            }
            if ((cell = row.getCell("baseUnit")) != null && (measureUnit = (MeasureUnitInfo)cell.getValue()) != null) {
                hm.put("BASEUNIT", measureUnit);
            }
            if ((cell = row.getCell("baseQty")) != null) {
                BigDecimal baseQty = (BigDecimal)cell.getValue();
                hm.put("BASEQTY", baseQty);
            }
            if ((cell = row.getCell("projectNumCol")) != null && (projectInfo = (ProjectInfo)cell.getValue()) != null) {
                hm.put("PROJECT", projectInfo.getId().toString());
            }
            if ((cell = row.getCell("trackNumCol")) != null && (trackNumberInfo = (TrackNumberInfo)cell.getValue()) != null) {
                hm.put("TRACKNUM", trackNumberInfo.getId().toString());
            }
            SupplierInfo supplierInfo = null;
            CustomerInfo customerInfo = null;
            if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeID)) {
                compProp = this.dcm.getComponentProperty("supplier");
                Component component = comp = compProp != null ? compProp.getComponent() : null;
                if (compProp != null && comp instanceof KDPromptBox) {
                    temp = (KDPromptBox)comp;
                    supplierInfo = (SupplierInfo)temp.getData();
                }
                if (row.getCell("customer") != null && row.getCell("customer").getValue() != null) {
                    customerInfo = (CustomerInfo)row.getCell("customer").getValue();
                }
            } else if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeID)) {
                if (row.getCell("supplier") != null && row.getCell("supplier").getValue() != null) {
                    supplierInfo = (SupplierInfo)row.getCell("supplier").getValue();
                }
                Component component = comp = (compProp = this.dcm.getComponentProperty("customer")) != null ? compProp.getComponent() : null;
                if (compProp != null && comp instanceof KDPromptBox) {
                    temp = (KDPromptBox)comp;
                    customerInfo = (CustomerInfo)temp.getData();
                }
            } else if ("50957179-0105-1000-e000-0157c0a812fd463ED552".equals(billTypeID)) {
                compProp = this.dcm.getComponentProperty("supplier");
                Component component = comp = compProp != null ? compProp.getComponent() : null;
                if (compProp != null && comp instanceof KDPromptBox) {
                    temp = (KDPromptBox)comp;
                    supplierInfo = (SupplierInfo)temp.getData();
                }
                Component component2 = comp = (compProp = this.dcm.getComponentProperty("customer")) != null ? compProp.getComponent() : null;
                if (compProp != null && comp instanceof KDPromptBox) {
                    temp = (KDPromptBox)comp;
                    customerInfo = (CustomerInfo)temp.getData();
                }
            } else {
                if (row.getCell("supplier") != null && row.getCell("supplier").getValue() != null) {
                    supplierInfo = (SupplierInfo)row.getCell("supplier").getValue();
                }
                if (row.getCell("customer") != null && row.getCell("customer").getValue() != null) {
                    customerInfo = (CustomerInfo)row.getCell("customer").getValue();
                }
            }
            if (storeTypeInfo != null && supplierInfo != null && (StoreFlagEnum.SUPPLIER.equals((Object)storeTypeInfo.getStoreFlag()) || StoreFlagEnum.TOSUPPLIER.equals((Object)storeTypeInfo.getStoreFlag()))) {
                hm.put("SUPPLIER", supplierInfo.getId().toString());
            }
            if (storeTypeInfo != null && customerInfo != null && (StoreFlagEnum.CUSTOMER.equals((Object)storeTypeInfo.getStoreFlag()) || StoreFlagEnum.TOCUSTOMER.equals((Object)storeTypeInfo.getStoreFlag()))) {
                hm.put("CUSTOMER", customerInfo.getId().toString());
            }
        } else {
            if (transactionTypeInfo != null) {
                Map<String, List> map = this.getTranAllStoreTypeAndState(transactionTypeInfo.getId().toString(), inORout);
                List storeTypeList = map.get("STORETYPE");
                List storeStateList = map.get("STORESTATE");
                hm.put("STORETYPE", storeTypeList);
                hm.put("STORESTATE", storeStateList);
            }
            return hm;
        }
        return hm;
    }

    private Map<String, List> getTranAllStoreTypeAndState(String transactionTypeID, String inORout) {
        HashMap<String, List> map = new HashMap<String, List>();
        ArrayList<String> storeTypeList = new ArrayList<String>();
        ArrayList<String> storeStateList = new ArrayList<String>();
        try {
            InvUpdateTypeCollection col = TransactionTypeFactory.getRemoteInstance().getInvUpdateType(transactionTypeID);
            StoreTypeInfo storeTypeInfo = null;
            StoreStateInfo storeStateInfo = null;
            InvUpdateTypeInfo invUpdateTypeInfo = null;
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                invUpdateTypeInfo = col.get(i);
                if ("in".equals(inORout)) {
                    storeTypeInfo = invUpdateTypeInfo.getStoreType();
                    storeStateInfo = invUpdateTypeInfo.getStoreState();
                }
                if ("out".equals(inORout)) {
                    storeTypeInfo = invUpdateTypeInfo.getStoreTypePre();
                    storeStateInfo = invUpdateTypeInfo.getStoreStatePre();
                }
                if (storeTypeInfo != null) {
                    storeTypeList.add(storeTypeInfo.getId().toString());
                }
                if (storeStateInfo == null) continue;
                storeStateList.add(storeStateInfo.getId().toString());
            }
            map.put("STORETYPE", storeTypeList);
            map.put("STORESTATE", storeStateList);
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return map;
    }

    private boolean isSerialNumberManger(IRow row, MeasureUnitInfo unit, MaterialInfo material) {
        Object isSerialNumber = row.getCell("isSerialNumber").getValue();
        InvUpdateTypeInfo invUpdateTypeInfo = null;
        try {
            invUpdateTypeInfo = (InvUpdateTypeInfo)row.getCell("invUpdateType").getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.isNeedCheckSN(invUpdateTypeInfo) && isSerialNumber != null && new Boolean(isSerialNumber.toString()) != false && material != null && material.getSeqUnit() != null && unit != null && unit.getId().equals((Object)material.getSeqUnit().getId());
    }

    protected boolean isNeedCheckSN(InvUpdateTypeInfo invUpdateTypeInfo) {
        boolean needCheck = true;
        try {
            if (invUpdateTypeInfo != null && invUpdateTypeInfo.isIsNotUpdateInv()) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return needCheck;
    }
}

