/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetInfo;
import com.kingdee.eas.barcode.scm.util.BarcodeClientUtils;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import java.util.Map;

public class FABarcodeUtils {
    public static final String FABARCODE = "FABARCODE";
    public static final String FABARCODELICENSENAME = "BARCODE_FA";

    public static void requestLicenseOrReleaseLicense(Map uiContext, boolean flag, CoreUI ui) throws LicenseException {
        try {
            IndubarodeParamsetInfo indubarodeParamsetInfo = BarcodeClientUtils.getParamValue(null);
            int days = indubarodeParamsetInfo.getDays();
            if (days == -99) {
                return;
            }
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        String uiParam = (String)uiContext.get("UIClassParam");
        if (FABarcodeUtils.isEmpty(uiParam) || !FABARCODE.equalsIgnoreCase(uiParam) || !flag) {
            return;
        }
        uiContext.put("moduleName", FABARCODELICENSENAME);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static String constructMessage(String className, IUIObject ui, boolean isRegisted) throws LicenseException {
        if (className == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ClassName"));
        buffer.append(ui.getUITitle() + "\n[" + FABarcodeUtils.getUIClassName(ui) + "]");
        buffer.append("\n");
        buffer.append(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource.Msg_ModuleName"));
        buffer.append("\n");
        buffer.append(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BarcodeResource.Msg_SubSystem"));
        if (isRegisted) {
            buffer.append("[PRO_BOSRUNTIME]");
        } else {
            buffer.append("[BOSRUNTIME]");
        }
        return buffer.toString();
    }

    public static String getUIClassName(IUIObject uiObject) {
        String className = null;
        className = uiObject.getMetaDataPK() != null ? uiObject.getMetaDataPK().getFullName() : uiObject.getClass().getName();
        return className;
    }
}

