/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.appframework.client.servicebinding.IBindService;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.barcode.scm.client.BarcodePrintHelper;
import com.kingdee.eas.barcode.scm.client.IBarcodeBillSelectUI;
import com.kingdee.eas.fi.fa.manage.client.FaCurCardListUI;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.service.NetFunctionService;
import com.kingdee.eas.framework.client.service.UserMonitorService;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class FaCurCardSelectUI
extends FaCurCardListUI
implements IBarcodeBillSelectUI {
    protected KDWorkButton btnSelectBills;
    protected ActionSelectBills actionSelectBills = null;
    private Map selectedBills = null;
    private String billNumber = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.disableOtherActions();
        this.initSelectBillsAction();
    }

    public void disableOtherActions() {
        Component comp;
        int i;
        int size = this.toolBar.getComponentCount();
        for (i = 0; i < size; ++i) {
            comp = this.toolBar.getComponents()[i];
            String btnName = this.toolBar.getComponents()[i].getName();
            if ("btnSelectBills".equalsIgnoreCase(btnName) || "btnView".equalsIgnoreCase(btnName) || "btnQuery".equalsIgnoreCase(btnName)) continue;
            comp.setVisible(false);
            comp.setEnabled(false);
        }
        size = this.menuBar.getComponentCount();
        for (i = 0; i < size; ++i) {
            comp = this.menuBar.getComponents()[i];
            String menuName = this.menuBar.getComponents()[i].getName();
            if ("menuItemView".equalsIgnoreCase(menuName) || "menuItemQuery".equalsIgnoreCase(menuName)) continue;
            comp.setVisible(false);
            comp.setEnabled(false);
        }
    }

    private void initSelectBillsAction() {
        this.btnSelectBills = new KDWorkButton();
        this.btnSelectBills.setName("btnSelectBills");
        this.actionSelectBills = new ActionSelectBills((IUIObject)this);
        this.getActionManager().registerAction("actionSelectBills", (ItemAction)this.actionSelectBills);
        this.actionSelectBills.addService((IBindService)new NetFunctionService());
        this.actionSelectBills.addService((IBindService)new UserMonitorService());
        this.btnSelectBills.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionSelectBills), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnSelectBills.setText("\u9009\u62e9\u5361\u7247");
        this.btnSelectBills.setToolTipText("\u9009\u62e9\u5361\u7247\u751f\u6210\u6761\u7801");
        this.btnSelectBills.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
        this.toolBar.add((Component)this.btnSelectBills);
        KDTableHelper.releaseEnterAndTab((JComponent)this.tblMain);
        KDTableHelper.releaseEsc((JComponent)this.tblMain);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.tblMain, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2 && e.getType() == 1) {
                    try {
                        FaCurCardSelectUI.this.actionSelectBills_actionPerformed(null);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.tblMain.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
            }
        });
        this.tblMain.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    try {
                        FaCurCardSelectUI.this.actionSelectBills_actionPerformed(null);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    public RequestContext prepareActionSelectBills(IItemAction itemAction) throws Exception {
        RequestContext request = new RequestContext();
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
        }
        return request;
    }

    public void actionSelectBills_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() == 0) {
            this.selectedBills = null;
            MsgBox.showWarning((Component)((Object)this), (String)"\u8bf7\u67e5\u8be2\u540e\u9009\u62e9\u5355\u636e\uff01");
            SysUtil.abort();
        } else {
            ArrayList selBlocks = this.tblMain.getSelectManager().getBlocks();
            if (selBlocks != null && selBlocks.size() > 0) {
                this.selectedBills = BarcodePrintHelper.getSelectedIdsMap(this.tblMain, this.getEntryID());
                this.checkData();
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)"\u8bf7\u9009\u62e9\u5355\u636e\uff01");
                SysUtil.abort();
            }
        }
        this.disposeUIWindow();
    }

    public void checkData() throws BOSException, SQLException {
        boolean bool = false;
        if (this.selectedBills != null) {
            Iterator it = this.selectedBills.entrySet().iterator();
            StringBuffer sb = new StringBuffer();
            sb.append("   select  max(FNumber) as fnumber,count(a.fid) as countid,max(FAssetAmt) as qty from   T_FA_FaCurCard   a  left join    T_FA_FaCurDepartment  b on a.fid=b.FFaCurCardID  where a.fid in ('");
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!bool) {
                    sb.append(entry.getKey());
                    bool = true;
                    continue;
                }
                sb.append("','").append(entry.getKey());
            }
            sb.append("') group by  a.fid");
            IRowSet setrow = SQLExecutorFactory.getRemoteInstance((String)sb.toString()).executeSQL();
            String fnumber = "";
            int countid = 0;
            int qty = 0;
            while (setrow.next()) {
                fnumber = setrow.getString("fnumber");
                countid = setrow.getInt("countid");
                if (countid > 1) {
                    this.selectedBills = null;
                    MsgBox.showWarning((String)(fnumber + "\u5361\u7247\u7684\u8d44\u4ea7\u6570\u91cf\u5927\u4e8e1\u6216\u8005\u5b58\u5728\u591a\u4e2a\u4f7f\u7528\u4eba\u3001\u4f7f\u7528\u90e8\u95e8\uff0c\u8bf7\u5148\u62c6\u5206\u5361\u7247\uff01"));
                    SysUtil.abort();
                }
                if ((qty = setrow.getInt("qty")) <= 1) continue;
                this.selectedBills = null;
                MsgBox.showWarning((String)(fnumber + "\u5361\u7247\u7684\u8d44\u4ea7\u6570\u91cf\u5927\u4e8e1\u6216\u8005\u5b58\u5728\u591a\u4e2a\u4f7f\u7528\u4eba\u3001\u4f7f\u7528\u90e8\u95e8\uff0c\u8bf7\u5148\u62c6\u5206\u5361\u7247\uff01"));
                SysUtil.abort();
            }
        }
    }

    @Override
    public Map getBarcodeSelectedData() {
        return this.selectedBills;
    }

    @Override
    public String getEntryID() {
        return "id";
    }

    protected void initKeyStroke() {
        this.tblMain.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "View_1");
        this.tblMain.getActionMap().put("View_1", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FaCurCardSelectUI.this.actionSelectBills_actionPerformed(e);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        ArrayList selBlocks = this.tblMain.getSelectManager().getBlocks();
        if (e.getClickCount() == 2 && selBlocks != null && selBlocks.size() > 0) {
            this.selectedBills = BarcodePrintHelper.getSelectedIdsMap(this.tblMain, this.getEntryID());
            this.billNumber = BarcodePrintHelper.getSelectedNumbers(this.tblMain, "number");
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    @Override
    public IMetaDataPK getTDQueryPK() {
        return super.getTDQueryPK();
    }

    @Override
    public String getNumber() {
        return this.billNumber;
    }

    protected class ActionSelectBills
    extends ItemAction {
        public ActionSelectBills() {
            this((IUIObject)this$0);
        }

        public ActionSelectBills(IUIObject uiObject) {
            super(uiObject);
        }

        public void actionPerformed(ActionEvent e) {
            FaCurCardSelectUI.this.getUIContext().put("ORG.PK", FaCurCardSelectUI.this.getOrgPK(this));
            this.innerActionPerformed("eas", (CoreUIObject)FaCurCardSelectUI.this, "ActionSelectBills", "actionSelectBills_actionPerformed", e);
        }
    }
}

