/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.barcode.scm.FaStockTakeRecRptFacadeFactory;
import com.kingdee.eas.barcode.scm.client.AbstractFaStockTakeRecRptDetailUI;
import com.kingdee.eas.base.multiapprove.SqlFacadeFactory;
import com.kingdee.eas.framework.report.util.DefaultKDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaStockTakeRecRptDetailUI
extends AbstractFaStockTakeRecRptDetailUI {
    private static final Logger logger = CoreUIObject.getLogger(FaStockTakeRecRptDetailUI.class);
    private RptParams pp = new RptParams();

    public FaStockTakeRecRptDetailUI() throws Exception {
        this.kDTable1.checkParsed();
        this.kDTable1.getSelectManager().setSelectMode(2);
        this.enableExportExcel(this.kDTable1);
        this.kDTable1.setEnabled(true);
        this.kDTable1.getStyleAttributes().setLocked(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDTable1.getStyleAttributes().setLocked(true);
        this.getData();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void getData() {
        this.pp.clear();
        if (this.getUIContext().containsKey("assetID")) {
            this.pp.setString("assetID", this.getUIContext().get("assetID").toString());
        }
        if (this.getUIContext().containsKey("faStockTTB")) {
            this.pp.setString("faStockTTB", this.getUIContext().get("faStockTTB").toString());
        }
        this.kDTable1.getMergeManager().setMergeMode(0);
        try {
            RptParams rpt = FaStockTakeRecRptFacadeFactory.getRemoteInstance().getDetail(this.pp);
            RptTableHeader detailHeader = (RptTableHeader)rpt.getObject("detailHeader");
            this.kDTable1.removeColumns();
            this.kDTable1.removeRows();
            KDTableUtil.setHeader((RptTableHeader)detailHeader, (KDTable)this.kDTable1);
            if (this.kDTable1.getColumnIndex("AssetID") != -1) {
                this.kDTable1.getColumn("AssetID").getStyleAttributes().setHided(true);
            }
            if (this.kDTable1.getColumnIndex("RecEID") != -1) {
                this.kDTable1.getColumn("RecEID").getStyleAttributes().setHided(true);
            }
            if (this.kDTable1.getColumnIndex("FaStockTTB") != -1) {
                this.kDTable1.getColumn("FaStockTTB").getStyleAttributes().setHided(true);
            }
            if (this.kDTable1.getColumnIndex("StocktakingAmt") != -1) {
                this.kDTable1.getColumn("StocktakingAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                this.kDTable1.getColumn("StocktakingAmt").getStyleAttributes().setNumberFormat("%r-{#}5.0f");
            }
            RptRowSet rs = (RptRowSet)rpt.getObject("detailRowset");
            this.insertRows(rs, 0, this.kDTable1, true, new DefaultKDTableInsertHandler(rs), 0);
            String[] sumFieldName = new String[]{"StocktakingAmt"};
            FaStockTakeRecRptDetailUI.apendFootRow(this.kDTable1, sumFieldName);
        }
        catch (Exception ee) {
            logger.error((Object)ee);
            this.handUIExceptionAndAbort(ee);
            this.abort();
        }
    }

    private void insertRows(RptRowSet rs, int insertRowIndex, KDTable table, boolean refreshUI, DefaultKDTableInsertHandler handler, int insertRowCount) {
        table.setRefresh(false);
        int rowIndex = insertRowIndex + insertRowCount;
        while (rs.next()) {
            IRow row = table.addRow(rowIndex++);
            handler.setTableRowData(row, rs.toRowArray());
            row.getCell("StocktakingAmt").setValue((Object)new BigDecimal(row.getCell("StocktakingAmt").getValue().toString()).setScale(4));
        }
        if (refreshUI) {
            table.setRefresh(true);
        }
        if (rs.getRowCount() > 0) {
            table.reLayoutAndPaint();
        } else {
            table.repaint();
        }
    }

    @Override
    public void actionDel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!this.confirmRemove()) {
            return;
        }
        ArrayList ids = this.getSelidList();
        boolean flag = false;
        StringBuffer eids = new StringBuffer();
        for (int i = 0; i < ids.size(); ++i) {
            if (i > 0) {
                eids.append(",");
            }
            eids.append("'").append(ids.get(i).toString()).append("'");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update CT_SCM_FaStockTakeRecEntry set CFIsDeleted=1 ").append("\t\n");
        sql.append("where fid in (").append(eids).append(")");
        if (eids != null && eids.length() > 0) {
            SqlFacadeFactory.getRemoteInstance().executeSql(sql.toString());
        }
        this.getData();
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
    }

    public void checkSelected() {
        if (this.kDTable1.getRowCount() != 0 && this.kDTable1.getSelectManager().size() != 0) {
            return;
        }
        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
        SysUtil.abort();
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    private ArrayList getSelidList() {
        int mode = 0;
        ArrayList blockList = this.kDTable1.getSelectManager().getBlocks();
        if (blockList != null && blockList.size() == 1) {
            mode = ((IBlock)this.kDTable1.getSelectManager().getBlocks().get(0)).getMode();
        }
        ArrayList<String> selList = new ArrayList<String>();
        int[] selRows = KDTableUtil.getSelectedRows((KDTable)this.kDTable1);
        if (selRows.length > 0) {
            for (int i = 0; i < selRows.length; ++i) {
                selList.add(this.kDTable1.getRow(selRows[i]).getCell("RecEID").getValue().toString());
            }
        }
        return selList;
    }

    public static void apendFootRow(KDTable table, String[] fields) {
        int i;
        int size = fields.length;
        if (size == 0) {
            return;
        }
        HashMap<String, BigDecimal> sumValue = new HashMap<String, BigDecimal>();
        int count = table.getRowCount3();
        for (int i2 = 0; i2 < fields.length; ++i2) {
            sumValue.put(fields[i2], new BigDecimal("0"));
        }
        IRow footRow = null;
        KDTFootManager footManager = table.getFootManager();
        if (footManager == null) {
            footManager = new KDTFootManager(table);
            footManager.addFootView();
            table.setFootManager(footManager);
        }
        footRow = footManager.getFootRow(0);
        for (int i3 = 0; i3 < count; ++i3) {
            IRow row = table.getRow(i3);
            for (int j = 0; j < fields.length; ++j) {
                FaStockTakeRecRptDetailUI.sumValueForCell(row, fields[j], sumValue);
            }
        }
        if (footRow == null) {
            footRow = footManager.addFootRow(0);
        }
        String colFormat = "%{0.0000}f";
        String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
        table.getIndexColumn().setWidthAdjustMode((short)1);
        table.getIndexColumn().setWidth(30);
        footManager.addIndexText(0, total);
        footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
        for (i = 0; i < size; ++i) {
            String colName = fields[i];
            footRow.getCell(colName).getStyleAttributes().setNumberFormat(colFormat);
            footRow.getCell(colName).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            footRow.getCell(colName).getStyleAttributes().setFontColor(Color.black);
        }
        for (i = 0; i < fields.length; ++i) {
            footRow.getCell(fields[i]).setValue(sumValue.get(fields[i]));
        }
    }

    private static void sumValueForCell(IRow row, String key, Map sumValue) {
        Object obj;
        ICell cell = row.getCell(key);
        if (cell != null && (obj = cell.getValue()) != null) {
            BigDecimal keyValue = (BigDecimal)sumValue.get(key);
            keyValue = keyValue.add(new BigDecimal(obj.toString()));
            sumValue.put(key, keyValue);
        }
    }
}

