/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.barcode.scm.FtpConfigFactory;
import com.kingdee.eas.barcode.scm.FtpConfigInfo;
import com.kingdee.eas.barcode.scm.client.AbstractFtpConfigEditUI;
import com.kingdee.eas.base.attachment.FtpConfigHelper;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.CryptException;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.enterprisedt.net.ftp.KDFileTransferClient;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class FtpConfigEditUI
extends AbstractFtpConfigEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FtpConfigEditUI.class);
    private static final String attachmentRes = "com.kingdee.eas.base.attachment.AttachmentResources";
    private boolean isSubmit = false;
    FtpConfigInfo oldEditData;

    public void onLoad() throws Exception {
        super.onLoad();
        if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.VIEW.equals(this.getOprtState())) {
            this.oldEditData = (FtpConfigInfo)this.editData.clone();
            if (this.oldEditData.getRootPath() == null) {
                this.oldEditData.setRootPath("");
            }
            if (this.oldEditData.getHost() == null) {
                this.oldEditData.setHost("");
            }
        }
        this.actionCancel.setEnabled(false);
        this.actionCancelCancel.setEnabled(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
    }

    @Override
    public void actionTestLink_actionPerformed(ActionEvent e) throws Exception {
        this.testLink();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testLink() {
        KDFileTransferClient fileTransferClient = new KDFileTransferClient();
        boolean flag = false;
        try {
            fileTransferClient.setRemoteHost(this.editData.getHost());
            fileTransferClient.setRemotePort(this.editData.getPort());
            fileTransferClient.setUserName(this.editData.getUserName());
            fileTransferClient.setPassword(CryptoTean.decrypt((String)this.editData.getUserName(), (String)this.editData.getPassword()));
            fileTransferClient.connect();
            logger.info((Object)"connect success");
            MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"ConnectSuccess"));
            return;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"ConnectFail"));
        }
        finally {
            try {
                fileTransferClient.disconnect();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void storeFields() {
        boolean isPasswordChange = false;
        String password = new String(this.txtPassword.getPassword());
        if (this.editData.getPassword() == null || this.editData.getPassword() != null && !this.editData.getPassword().equals(password)) {
            isPasswordChange = true;
        }
        super.storeFields();
        String userName = this.txtuserName.getText();
        if (this.isSubmit) {
            try {
                if (isPasswordChange) {
                    this.editData.setPassword(CryptoTean.encrypt((String)userName, (String)password));
                } else {
                    String d_password = CryptoTean.decrypt((String)userName, (String)password);
                    this.editData.setPassword(CryptoTean.encrypt((String)userName, (String)d_password));
                }
            }
            catch (CryptException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.isSubmit = true;
        if (!this.addVerify()) {
            return;
        }
        if (OprtState.EDIT.equals(this.getOprtState()) && FtpConfigHelper.FtpIsUsed(null, (String)this.editData.getId().toString()) && !this.editVerify()) {
            return;
        }
        super.actionSubmit_actionPerformed(e);
        this.isSubmit = false;
    }

    private boolean addVerify() {
        if (this.txtName.getSelectedItemData() == null || "".equals(this.txtName.getSelectedItemData())) {
            this.txtName.requestFocusInWindow();
            MsgBox.showError((String)EASResource.getString((String)attachmentRes, (String)"NameNotNull"));
            return false;
        }
        if (StringUtils.isEmpty((String)this.txthost.getText())) {
            this.txthost.requestFocusInWindow();
            MsgBox.showError((String)EASResource.getString((String)attachmentRes, (String)"HostNotNull"));
            return false;
        }
        if (StringUtils.isEmpty((String)this.txtport.getText())) {
            this.txtport.requestFocusInWindow();
            MsgBox.showError((String)EASResource.getString((String)attachmentRes, (String)"PortNotNull"));
            return false;
        }
        if (StringUtils.isEmpty((String)this.txtuserName.getText())) {
            this.txtuserName.requestFocusInWindow();
            MsgBox.showError((String)EASResource.getString((String)attachmentRes, (String)"UserNameNotNull"));
            return false;
        }
        return true;
    }

    private boolean editVerify() {
        if (this.txthost.getText() != null && !this.txthost.getText().equals(this.oldEditData.getHost())) {
            MsgBox.showError((String)EASResource.getString((String)attachmentRes, (String)"CanNotEditHost"));
            return false;
        }
        if (this.txtport.getText() != null && !this.txtport.getText().equals(Integer.toString(this.oldEditData.getPort()))) {
            MsgBox.showError((String)EASResource.getString((String)attachmentRes, (String)"CanNotEditPort"));
            return false;
        }
        if (this.txtrootPath.getText() != null && !this.txtrootPath.getText().equals(this.oldEditData.getRootPath())) {
            MsgBox.showError((String)EASResource.getString((String)attachmentRes, (String)"CanNotEditRootPath"));
            return false;
        }
        return true;
    }

    @Override
    protected IObjectValue createNewData() {
        FtpConfigInfo ftpConfigInfo = new FtpConfigInfo();
        ftpConfigInfo.setPassword(null);
        return ftpConfigInfo;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FtpConfigFactory.getRemoteInstance();
    }

    public boolean destroyWindow() {
        return super.destroyWindow();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("password"));
        return sic;
    }
}

