/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.barcode.scm.FtpConfigCollection;
import com.kingdee.eas.barcode.scm.FtpConfigFactory;
import com.kingdee.eas.barcode.scm.FtpConfigInfo;
import com.kingdee.eas.barcode.scm.FtpStatusEnum;
import com.kingdee.eas.barcode.scm.IFtpConfig;
import com.kingdee.eas.barcode.scm.client.AbstractFtpConfigListUI;
import com.kingdee.eas.barcode.scm.client.FtpConfigEditUI;
import com.kingdee.eas.base.attachment.FtpConfigHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.enterprisedt.net.ftp.KDFileTransferClient;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class FtpConfigListUI
extends AbstractFtpConfigListUI {
    private static final Logger logger = CoreUIObject.getLogger(FtpConfigListUI.class);
    private static final String attachmentRes = "com.kingdee.eas.base.attachment.AttachmentResources";

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void onLoad() throws Exception {
        ICell icell;
        super.onLoad();
        this.btnTestLink.setEnabled(true);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.btnCancelCancel.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnCancel.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnTestLink.setIcon(EASResource.getIcon((String)"imgTbtn_cancelverification"));
        if (this.tblMain.getRow(0) != null && (icell = this.tblMain.getRow(0).getCell("status")) != null && icell.getValue() != null) {
            boolean enabled = icell.getValue().toString().equalsIgnoreCase(FtpStatusEnum.START.toString());
            this.changeWBTEnabeld(enabled);
        }
        this.actionCancelCancel.setVisible(true);
        this.actionCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
        this.btnCancel.setVisible(true);
        this.tblMain.getColumn("password").getStyleAttributes().setHided(true);
    }

    private void changeWBTEnabeld(boolean isEnabled) {
        this.btnCancelCancel.setEnabled(!isEnabled);
        this.actionCancelCancel.setEnabled(!isEnabled);
        this.btnCancel.setEnabled(isEnabled);
        this.actionCancel.setEnabled(isEnabled);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        this.changeWBTEnabeld(this.statusIsEnabled());
        super.tblMain_tableClicked(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        ICell icell = this.tblMain.getRow(rowIndex).getCell("id");
        if (icell != null && icell.getValue() != null) {
            String ftpConfigId = icell.getValue().toString();
            if (this.disabledFtp(ftpConfigId)) {
                MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"DisabledSuccess"));
                this.changeWBTEnabeld(false);
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"DisabledFail"));
            }
        }
        this.refresh(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        ICell icell = this.tblMain.getRow(rowIndex).getCell("id");
        if (icell != null && icell.getValue() != null) {
            String ftpConfigId = icell.getValue().toString();
            if (this.enabledFtp(ftpConfigId)) {
                MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"EnabledSuccess"));
                this.changeWBTEnabeld(true);
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"EnabledFail"));
            }
        }
        this.refresh(e);
    }

    private boolean enabledFtp(String ftpConfigId) throws Exception {
        String oql;
        IFtpConfig iFtpConfig = FtpConfigFactory.getRemoteInstance();
        FtpConfigCollection coll = iFtpConfig.getFtpConfigCollection(oql = "select id where status = 1");
        if (coll == null || coll.size() == 0) {
            ObjectUuidPK pk = new ObjectUuidPK(ftpConfigId);
            FtpConfigInfo ftpConfigInfo = iFtpConfig.getFtpConfigInfo((IObjectPK)pk);
            ftpConfigInfo.setStatus(FtpStatusEnum.START);
            iFtpConfig.update((IObjectPK)pk, (CoreBaseInfo)ftpConfigInfo);
            return true;
        }
        logger.info((Object)"other ftp is started");
        return false;
    }

    private boolean disabledFtp(String ftpConfigId) throws Exception {
        IFtpConfig iFtpConfig = FtpConfigFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(ftpConfigId);
        FtpConfigInfo ftpConfigInfo = iFtpConfig.getFtpConfigInfo((IObjectPK)pk);
        ftpConfigInfo.setStatus(FtpStatusEnum.STOP);
        iFtpConfig.update((IObjectPK)pk, (CoreBaseInfo)ftpConfigInfo);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionTestLink_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        ICell icellHost = this.tblMain.getRow(rowIndex).getCell("host");
        ICell icellPort = this.tblMain.getRow(rowIndex).getCell("port");
        ICell icellUserName = this.tblMain.getRow(rowIndex).getCell("userName");
        ICell icellPassword = this.tblMain.getRow(rowIndex).getCell("password");
        if (icellHost == null || icellHost.getValue() == null || icellPort == null || icellPort.getValue() == null || icellUserName == null || icellUserName.getValue() == null || icellPassword == null || icellPassword.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"ConnectFail"));
            return;
        }
        KDFileTransferClient fileTransferClient = new KDFileTransferClient();
        try {
            fileTransferClient.setRemoteHost(icellHost.getValue().toString());
            fileTransferClient.setRemotePort(Integer.parseInt(icellPort.getValue().toString()));
            fileTransferClient.setUserName(icellUserName.getValue().toString());
            fileTransferClient.setPassword(CryptoTean.decrypt((String)icellUserName.getValue().toString(), (String)icellPassword.getValue().toString()));
            fileTransferClient.connect();
            logger.info((Object)"connect success");
            MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"ConnectSuccess"));
            return;
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"ConnectFail"));
        }
        finally {
            try {
                fileTransferClient.disconnect();
            }
            catch (Exception e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String ftpConfigId;
        ICell icell;
        if (this.statusIsEnabled()) {
            MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"StartCanNotRemove"));
            return;
        }
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex != -1 && (icell = this.tblMain.getRow(rowIndex).getCell("id")) != null && icell.getValue() != null && FtpConfigHelper.FtpIsUsed(null, (String)(ftpConfigId = icell.getValue().toString()))) {
            MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"CanNotRemove"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.statusIsEnabled()) {
            MsgBox.showInfo((String)EASResource.getString((String)attachmentRes, (String)"StartCanNotEdit"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    private boolean statusIsEnabled() {
        ICell icell;
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            return false;
        }
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex != -1 && (icell = this.tblMain.getRow(rowIndex).getCell("status")) != null && icell.getValue() != null) {
            return icell.getValue().toString().equalsIgnoreCase(FtpStatusEnum.START.toString());
        }
        return false;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FtpConfigFactory.getRemoteInstance();
    }

    @Override
    protected String getEditUIName() {
        return FtpConfigEditUI.class.getName();
    }
}

