/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterInfo;
import com.kingdee.eas.barcode.scm.client.AbstractIndBarcodeFilterUI;
import com.kingdee.eas.barcode.scm.util.BarcodeClientUtils;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class IndBarcodeFilterUI
extends AbstractIndBarcodeFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(IndBarcodeFilterUI.class);
    public boolean isFacard = false;

    public void onShow() throws Exception {
        if (this.isFacard) {
            this.prmtMaterial.setVisible(false);
            this.prmtMaterial.setEnabled(false);
            this.prmtFaCurCard.setVisible(true);
            this.prmtFaCurCard.setEnabled(true);
            this.labMasterial.setBoundLabelText("\u8d44\u4ea7\u5361\u7247");
        } else {
            this.prmtMaterial.setVisible(true);
            this.prmtMaterial.setEnabled(true);
            this.prmtFaCurCard.setVisible(false);
            this.prmtFaCurCard.setEnabled(false);
            this.labMasterial.setBoundLabelText("\u7269\u6599");
        }
        super.onShow();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getSelectors());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1));
        view.setFilter(filter);
        this.prmtMaster.setEntityViewInfo(view);
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        String selectorAll = System.getProperty("selector.all");
        if (StringUtils.isEmpty((String)selectorAll)) {
            selectorAll = "true";
        }
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("treeid.id"));
        sic.add(new SelectorItemInfo("ruleNumber"));
        sic.add(new SelectorItemInfo("ruleName"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("comment"));
        sic.add(new SelectorItemInfo("barcodeType.name"));
        sic.add(new SelectorItemInfo("facard"));
        return sic;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public FilterInfo getFilterInfo() {
        String tiaoma;
        this.filterInfo = super.getFilterInfo();
        this.filterInfo = new FilterInfo();
        Object o = this.prmtMaster.getValue();
        if (o != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("barRule.ruleNumber", (Object)((IndBarcodeMasterInfo)o).getRuleNumber()));
        }
        if ((tiaoma = this.txtTiaoMa.getText()) != null && !tiaoma.equals("")) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)tiaoma));
        }
        if ((o = this.prmtMaterial.getValue()) != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("material.number", (Object)((MaterialInfo)o).getNumber()));
        }
        if ((o = this.prmtFaCurCard.getValue()) != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("faCurCard.number", (Object)((FaCurCardInfo)o).getNumber()));
        }
        if (this.createDateFrom.getTimestamp() != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("createTime", (Object)this.createDateFrom.getTimestamp(), CompareType.GREATER_EQUALS));
        }
        if (this.createDateTo.getTimestamp() != null) {
            Calendar cd = Calendar.getInstance();
            cd.setTime(this.createDateTo.getTimestamp());
            cd.add(5, 1);
            this.filterInfo.getFilterItems().add(new FilterItemInfo("createTime", (Object)cd.getTime(), CompareType.LESS_EQUALS));
        }
        if (this.prmtStorageOrgUnit.getValue() != null) {
            StorageOrgUnitInfo storageinfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
            this.filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageinfo.getId(), CompareType.EQUALS));
        }
        return this.filterInfo;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        Object value = this.prmtMaster.getValue();
        if (value != null) {
            IndBarcodeMasterInfo masterInfo = (IndBarcodeMasterInfo)value;
            cp.addCustomerParam("barRule.ruleNumber", masterInfo.getId().toString());
        }
        if ((value = this.txtTiaoMa.getText()) != null && !value.equals("")) {
            cp.addCustomerParam("number", value.toString());
        }
        if ((value = this.prmtMaterial.getValue()) != null) {
            cp.addCustomerParam("material.number", ((MaterialInfo)value).getNumber());
        }
        if ((value = this.prmtFaCurCard.getValue()) != null) {
            cp.addCustomerParam("faCurCard.number", ((FaCurCardInfo)value).getNumber());
        }
        if ((value = this.createDateFrom.getTimestamp()) != null) {
            cp.putDate("createTimeFrom", (Date)this.createDateFrom.getTimestamp());
        }
        if ((value = this.createDateTo.getTimestamp()) != null) {
            cp.putDate("createTimeTo", (Date)this.createDateTo.getTimestamp());
        }
        value = this.prmtStorageOrgUnit.getValue();
        if (this.prmtStorageOrgUnit.getValue() != null) {
            StorageOrgUnitInfo storageinfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
            cp.addCustomerParam("storageOrgUnit.number", storageinfo.getId().toString());
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        this.clear();
        Object value = cp.getCustomerParam("barRule.ruleNumber");
        if (value != null && !value.equals("")) {
            try {
                IndBarcodeMasterInfo configInfo = IndBarcodeMasterFactory.getRemoteInstance().getIndBarcodeMasterInfo((IObjectPK)new ObjectUuidPK(((IndBarcodeMasterInfo)value).getId()), this.getSelectors());
                this.prmtMaster.setValue((Object)configInfo);
                this.isFacard = configInfo.isFacard();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((value = cp.getCustomerParam("number")) != null && !value.equals("")) {
            this.txtTiaoMa.setText(value.toString());
        }
        if ((value = cp.getCustomerParam("material.number")) != null && !value.equals("")) {
            try {
                MaterialInfo materialInfo = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(((MaterialInfo)value).getId()));
                this.prmtMaterial.setValue((Object)materialInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((value = cp.getCustomerParam("faCurCard.number")) != null && !value.equals("")) {
            try {
                FaCurCardInfo faCurCardInfo = FaCurCardFactory.getRemoteInstance().getFaCurCardInfo((IObjectPK)new ObjectUuidPK(((FaCurCardInfo)value).getId()));
                this.prmtFaCurCard.setValue((Object)faCurCardInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((value = cp.getCustomerParam("storageOrgUnit.number")) != null && !value.equals("")) {
            try {
                StorageOrgUnitInfo storageOrgUnitInfo = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(value.toString()));
                this.prmtStorageOrgUnit.setValue((Object)storageOrgUnitInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((value = cp.getDate("createTimeFrom")) != null && !value.equals("")) {
            this.createDateFrom.setValue(value);
        }
        if ((value = cp.getDate("createTimeTo")) != null && !value.equals("")) {
            this.createDateTo.setValue(value);
        }
    }

    public RequestContext prepareSetCustomerParams(CustomerParams cp) {
        return super.prepareSetCustomerParams(cp);
    }

    public RequestContext prepareGetCustomerParams() {
        return super.prepareGetCustomerParams();
    }

    public boolean verify() {
        if (this.prmtMaster.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("DocNameIsNull"));
            return false;
        }
        Timestamp beginDate = this.createDateFrom.getTimestamp();
        Timestamp toDate = this.createDateTo.getTimestamp();
        if (beginDate != null && toDate != null && beginDate.after((Date)toDate)) {
            MsgBox.showInfo((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("dateBefore"));
            return false;
        }
        return true;
    }

    @Override
    protected void prmtMaster_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtMaster_dataChanged(e);
        if (e.getOldValue() != null && e.getNewValue() != null && e.getOldValue().equals(e.getNewValue())) {
            return;
        }
        if (this.prmtMaster.getValue() != null) {
            IndBarcodeMasterInfo indbarcodemasterInfo = (IndBarcodeMasterInfo)this.prmtMaster.getValue();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("facard"));
            indbarcodemasterInfo = IndBarcodeMasterFactory.getRemoteInstance().getIndBarcodeMasterInfo((IObjectPK)new ObjectUuidPK(indbarcodemasterInfo.getId()), sic);
            if (indbarcodemasterInfo.isFacard()) {
                this.prmtMaterial.setVisible(false);
                this.prmtMaterial.setEnabled(false);
                this.prmtFaCurCard.setVisible(true);
                this.prmtFaCurCard.setEnabled(true);
                this.labMasterial.setBoundLabelText("\u8d44\u4ea7\u5361\u7247");
            } else {
                this.prmtMaterial.setVisible(true);
                this.prmtMaterial.setEnabled(true);
                this.prmtFaCurCard.setVisible(false);
                this.prmtFaCurCard.setEnabled(false);
                this.labMasterial.setBoundLabelText("\u7269\u6599");
            }
            this.isFacard = indbarcodemasterInfo.isFacard();
        }
    }
}

