/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.barcode.scm.BarcodeTDPropertyEnum;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterInfo;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterTreeInfo;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupFactory;
import com.kingdee.eas.barcode.scm.PropertyTypeEnum;
import com.kingdee.eas.barcode.scm.client.AbstractIndBarcodeMasterEditUI;
import com.kingdee.eas.barcode.scm.util.BarcodeClientUtils;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class IndBarcodeMasterEditUI
extends AbstractIndBarcodeMasterEditUI {
    private static final Logger logger = CoreUIObject.getLogger(IndBarcodeMasterEditUI.class);
    protected KDWorkButton btnAddLine = null;
    protected KDWorkButton btnInsertLine = null;
    protected KDWorkButton btnRemoveLine = null;
    Color[] colors = new Color[5];

    @Override
    public void loadFields() {
        this.colors[0] = Color.white;
        this.colors[1] = new Color(217, 217, 208);
        this.iniData();
        try {
            this.initEntry();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        super.loadFields();
    }

    public void onLoad() throws Exception {
        this.kdtEntry.getColumn("dcode").getStyleAttributes().setLocked(false);
        this.kdtEntry.getColumn("tpfiled").getStyleAttributes().setLocked(false);
        this.kdtEntry.checkParsed();
        super.onLoad();
        this.kdtEntry.checkParsed();
        this.initEntryData(false);
    }

    public void initEntryData(boolean isFaStock) {
        if (this.oprtState == "ADDNEW") {
            if (!isFaStock) {
                this.initRow(BarcodeClientUtils.getBarcodeResource("MaterialsCode"), PropertyTypeEnum.getEnum("0"));
                this.initRow(BarcodeClientUtils.getBarcodeResource("materialName"), PropertyTypeEnum.getEnum("0"));
                this.initRow(BarcodeClientUtils.getBarcodeResource("pacageQty"), PropertyTypeEnum.getEnum("1"));
                this.initRow(BarcodeClientUtils.getBarcodeResource("Specifation"), PropertyTypeEnum.getEnum("0"));
                this.initRow(BarcodeClientUtils.getBarcodeResource("Batch"), PropertyTypeEnum.getEnum("0"));
                this.initRow(BarcodeClientUtils.getBarcodeResource("ProjectNum"), PropertyTypeEnum.getEnum("0"));
                this.initRow(BarcodeClientUtils.getBarcodeResource("TrackNum"), PropertyTypeEnum.getEnum("0"));
                this.initRow(BarcodeClientUtils.getBarcodeResource("AidProperty"), PropertyTypeEnum.getEnum("0"));
                this.initRow(BarcodeClientUtils.getBarcodeResource("MeasureUnit"), PropertyTypeEnum.getEnum("0"));
                this.initRow(BarcodeClientUtils.getBarcodeResource("mfg"), PropertyTypeEnum.date);
                this.initRow(BarcodeClientUtils.getBarcodeResource("Count"), PropertyTypeEnum.getEnum("1"));
                this.initRow(BarcodeClientUtils.getBarcodeResource("AidCount"), PropertyTypeEnum.getEnum("1"));
            } else {
                this.initRow(BarcodeClientUtils.getBarcodeResource("purCardNumber"), PropertyTypeEnum.getEnum("0"));
                this.initRow(BarcodeClientUtils.getBarcodeResource("purCardName"), PropertyTypeEnum.getEnum("0"));
                this.initRow(BarcodeClientUtils.getBarcodeResource("pacageQty"), PropertyTypeEnum.getEnum("1"));
                this.initRow(BarcodeClientUtils.getBarcodeResource("Specifation"), PropertyTypeEnum.getEnum("0"));
                this.initRow(BarcodeClientUtils.getBarcodeResource("MeasureUnit"), PropertyTypeEnum.getEnum("0"));
                this.initRow(BarcodeClientUtils.getBarcodeResource("Count"), PropertyTypeEnum.getEnum("1"));
                this.initRow(BarcodeClientUtils.getBarcodeResource("FaCat"), PropertyTypeEnum.getEnum("0"));
                this.initRow(BarcodeClientUtils.getBarcodeResource("StoreCity"), PropertyTypeEnum.getEnum("0"));
                this.initRow(BarcodeClientUtils.getBarcodeResource("ManageDepartment"), PropertyTypeEnum.getEnum("0"));
                this.initRow(BarcodeClientUtils.getBarcodeResource("Keeper"), PropertyTypeEnum.getEnum("0"));
                this.initRow(BarcodeClientUtils.getBarcodeResource("useDepartment"), PropertyTypeEnum.getEnum("0"));
                this.initRow(BarcodeClientUtils.getBarcodeResource("usePerson"), PropertyTypeEnum.getEnum("0"));
            }
            this.kdtEntry.getColumn("tdPt").getStyleAttributes().setLocked(false);
            KDComboBox kdtEntry_tdPt_ComboBox = new KDComboBox();
            kdtEntry_tdPt_ComboBox.setName("kdtEntry_tdPt_ComboBox");
            kdtEntry_tdPt_ComboBox.setVisible(true);
            kdtEntry_tdPt_ComboBox.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.barcode.scm.BarcodeTDPropertyEnum").toArray());
            KDTDefaultCellEditor kdtEntry_tdPt_CellEditor = new KDTDefaultCellEditor((JComboBox)kdtEntry_tdPt_ComboBox);
            this.kdtEntry.getColumn("tdPt").setEditor((ICellEditor)kdtEntry_tdPt_CellEditor);
        }
        boolean reEdit = false;
        if (this.getUIContext().containsKey("reEdit") && (reEdit = Boolean.valueOf(this.getUIContext().get("reEdit").toString()).booleanValue())) {
            this.setEditeEnable();
        }
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            IRow row = this.kdtEntry.getRow(i);
            Boolean flag = (Boolean)row.getCell("isLock").getValue();
            if (flag.booleanValue()) {
                row.getStyleAttributes().setLocked(true);
                row.getCell("isCheck").getStyleAttributes().setLocked(false);
                row.getCell("isHide").getStyleAttributes().setLocked(false);
                row.getCell("tdPt").getStyleAttributes().setLocked(false);
                row.getCell("dcode").getStyleAttributes().setLocked(false);
                row.getCell("tpfiled").getStyleAttributes().setLocked(false);
            }
            if (!reEdit) continue;
            row.getCell("name").getStyleAttributes().setLocked(true);
            row.getCell("type").getStyleAttributes().setLocked(true);
            row.getCell("length").getStyleAttributes().setLocked(true);
            row.getCell("isCheck").getStyleAttributes().setLocked(true);
            row.getCell("isLock").getStyleAttributes().setLocked(true);
            row.getCell("isHide").getStyleAttributes().setLocked(true);
            row.getCell("tdPt").getStyleAttributes().setLocked(false);
            row.getCell("dcode").getStyleAttributes().setLocked(false);
            row.getCell("tpfiled").getStyleAttributes().setLocked(false);
        }
    }

    private void initRow(String name, PropertyTypeEnum penum) {
        IRow row = this.kdtEntry.addRow();
        row.getCell("name").setValue((Object)name);
        row.getCell("type").setValue((Object)penum);
        row.getCell("length").setValue((Object)0);
        row.getCell("isCheck").setValue((Object)false);
        row.getCell("isLock").setValue((Object)true);
        row.getCell("isHide").setValue((Object)false);
        row.getCell("dcode").setValue((Object)false);
        row.getCell("tpfiled").setValue((Object)false);
        row.getCell("relatedAtt").setValue((Object)false);
        this.initLockRow(row);
    }

    private void initLockRow(IRow row) {
        this.initLockRow(row, true, true, true, false);
    }

    private void initLockRow(IRow row, boolean lockname, boolean locktype, boolean locklength, boolean locklock) {
        row.getCell("name").getStyleAttributes().setLocked(lockname);
        row.getCell("type").getStyleAttributes().setLocked(locktype);
        row.getCell("length").getStyleAttributes().setLocked(locklength);
        row.getCell("isLock").getStyleAttributes().setLocked(locklock);
        row.getCell("dcode").getStyleAttributes().setLocked(false);
        row.getCell("tpfiled").getStyleAttributes().setLocked(false);
    }

    @Override
    protected void chkisFacard_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkisFacard.isSelected()) {
            this.kdtEntry.removeRows();
            this.initEntryData(true);
            this.kdtEntry.getColumn("relatedAtt").getStyleAttributes().setLocked(false);
            int size = this.kdtEntry.getRowCount();
            for (int i = 0; i < size; ++i) {
                this.kdtEntry.getRow(i).getCell("relatedAtt").setValue((Object)false);
                this.kdtEntry.getRow(i).getCell("relatedAtt").getStyleAttributes().setLocked(false);
            }
        } else {
            this.kdtEntry.getColumn("relatedAtt").getStyleAttributes().setLocked(true);
            int size = this.kdtEntry.getRowCount();
            for (int i = 0; i < size; ++i) {
                this.kdtEntry.getRow(i).getCell("relatedAtt").setValue((Object)false);
                this.kdtEntry.getRow(i).getCell("relatedAtt").getStyleAttributes().setLocked(true);
            }
            this.kdtEntry.removeRows();
            this.initEntryData(false);
        }
    }

    private void initRow(String name, PropertyTypeEnum penum, int length, boolean isCheck, boolean isLock, boolean dcode, boolean tpFiled, boolean lockname, boolean isHide, boolean locktype, boolean locklength, boolean locklock) {
    }

    private void setEditeEnable() {
        this.txtruleNumber.setEnabled(false);
        this.txtruleName.setEnabled(false);
        this.prmtbarcodeType.setEnabled(false);
        this.prmtuseOrg.setEnabled(false);
        this.btnAddLine.setEnabled(false);
        this.btnInsertLine.setEnabled(false);
        this.btnRemoveLine.setEnabled(false);
    }

    private void iniData() {
        this.kdtEntry.getColumn("seq").getStyleAttributes().setHided(true);
        this.status.setEnabled(false);
        this.actionCancel.setEnabled(true);
        this.actionCancelCancel.setEnabled(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return IndBarcodeMasterFactory.getRemoteInstance();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.editData.put("treeid", (IndBarcodeMasterTreeInfo)this.getUIContext().get("ParentNode"));
        }
    }

    @Override
    protected IObjectValue createNewData() {
        IndBarcodeMasterInfo objectValue = new IndBarcodeMasterInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    @Override
    protected void beforeStoreFields(ActionEvent arg0) throws Exception {
        int i;
        if (this.txtruleNumber.getText() == null || this.txtruleNumber.getText().length() == 0) {
            MsgBox.showWarning((String)BarcodeClientUtils.getBarcodeResource("CodeNoNull"));
            SysUtil.abort();
        } else if (this.txtruleName.getText() == null || this.txtruleName.getText().length() == 0) {
            MsgBox.showWarning((String)BarcodeClientUtils.getBarcodeResource("NameNoNull"));
            SysUtil.abort();
        } else if (this.prmtbarcodeType.getValue() == null) {
            MsgBox.showWarning((String)BarcodeClientUtils.getBarcodeResource("TypeNoNull"));
            SysUtil.abort();
        } else if (this.kdtEntry.getRowCount() != 0) {
            HashMap<String, String> tdptMap = new HashMap<String, String>();
            for (i = 0; i < this.kdtEntry.getRowCount(); ++i) {
                IRow row = this.kdtEntry.getRow(i);
                if (row.getCell("name").getValue() == null || row.getCell("name").getValue() == "") {
                    MsgBox.showWarning((String)(BarcodeClientUtils.getBarcodeResource("ExpandProperty") + (i + 1) + BarcodeClientUtils.getBarcodeResource("RowPropertyNameIsNull")));
                    SysUtil.abort();
                } else if (row.getCell("type").getValue() == null) {
                    MsgBox.showWarning((String)(BarcodeClientUtils.getBarcodeResource("ExpandProperty") + (i + 1) + BarcodeClientUtils.getBarcodeResource("RowTypeIsNull")));
                    SysUtil.abort();
                }
                if (row.getCell("tdPt").getValue() != null) {
                    BarcodeTDPropertyEnum tdProperty = (BarcodeTDPropertyEnum)((Object)row.getCell("tdPt").getValue());
                    if (BarcodeTDPropertyEnum.F0.equals((Object)tdProperty)) continue;
                    if (tdptMap.containsKey(tdProperty.getValue())) {
                        MsgBox.showWarning((String)(BarcodeClientUtils.getBarcodeResource("numIndex") + (String)tdptMap.get(tdProperty.getValue()) + BarcodeClientUtils.getBarcodeResource("sumInde") + (i + 1) + BarcodeClientUtils.getBarcodeResource("repeatProperty")));
                        SysUtil.abort();
                    } else {
                        tdptMap.put(tdProperty.getValue(), i + 1 + "");
                    }
                }
                if (this.chkisFacard.isSelected()) continue;
                row.getCell("relatedAtt").setValue((Object)false);
            }
        }
        this.checkEntryNameDup();
        if (this.oprtState == "EDIT") {
            IndBarcodeMasterInfo masterInfo = IndBarcodeMasterFactory.getRemoteInstance().getIndBarcodeMasterInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            if (!this.txtruleNumber.getText().equals(masterInfo.getRuleNumber())) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("ruleNumber", (Object)this.txtruleNumber.getText(), CompareType.EQUALS));
                if (IndBarcodeMasterFactory.getRemoteInstance().exists(filter)) {
                    MsgBox.showWarning((String)(BarcodeClientUtils.getBarcodeResource("Code") + this.txtruleNumber.getText() + BarcodeClientUtils.getBarcodeResource("NoReplace")));
                    SysUtil.abort();
                } else {
                    this.oprtState = "EDIT";
                }
            }
        }
        if (this.oprtState == "ADDNEW") {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("ruleNumber", (Object)this.txtruleNumber.getText(), CompareType.EQUALS));
            if (IndBarcodeMasterFactory.getRemoteInstance().exists(filter)) {
                MsgBox.showWarning((String)(BarcodeClientUtils.getBarcodeResource("Code") + this.txtruleNumber.getText() + BarcodeClientUtils.getBarcodeResource("NoReplace")));
                SysUtil.abort();
            } else {
                this.oprtState = "EDIT";
            }
        }
        int qrcodenums = 0;
        for (i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            if (!((Boolean)this.kdtEntry.getCell(i, "dcode").getValue()).booleanValue()) continue;
            ++qrcodenums;
        }
        if (qrcodenums > 7) {
            MsgBox.showInfo((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("qrcodenumslimit"));
        }
    }

    private void checkEntryNameDup() {
        HashSet<String> nameSet = new HashSet<String>();
        String tmpname = null;
        IRow row = null;
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            row = this.kdtEntry.getRow(i);
            tmpname = (String)row.getCell("name").getValue();
            if (tmpname.indexOf(":") >= 0 || tmpname.indexOf("\uff1a") >= 0) {
                MsgBox.showWarning((String)BarcodeClientUtils.getBarcodeResource("enterynamespecial"));
                SysUtil.abort();
            }
            if (nameSet.contains(tmpname)) {
                MsgBox.showWarning((String)BarcodeClientUtils.getBarcodeResource("entrynamedupkey"));
                SysUtil.abort();
                continue;
            }
            nameSet.add(tmpname);
        }
    }

    @Override
    protected void kdtEntry_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.initEntry();
    }

    protected void initEntry() throws EASBizException, BOSException {
        if (this.oprtState == "EDIT") {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("master", (Object)this.editData.getId(), CompareType.EQUALS));
            if (IndBarcodeSetupFactory.getRemoteInstance().exists(filter)) {
                this.kdtEntry.getColumn("type").getStyleAttributes().setLocked(true);
                this.kdtEntry.getColumn("type").getStyleAttributes().setBackground(this.colors[1]);
            } else {
                this.kdtEntry.getColumn("type").getStyleAttributes().setLocked(false);
                this.kdtEntry.getColumn("type").getStyleAttributes().setBackground(this.colors[0]);
            }
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.kdtEntry.addRow();
        row.getCell("isCheck").setValue((Object)false);
        row.getCell("length").setValue((Object)0);
        row.getCell("isHide").setValue((Object)false);
        row.getCell("dcode").setValue((Object)false);
        row.getCell("tpfiled").setValue((Object)false);
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.insertLine(this.kdtEntry);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        this.removeLine(this.kdtEntry);
    }

    protected void insertLine(KDTable table) {
        if (table == null) {
            return;
        }
        IRow row = null;
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            if (this.isTableColumnSelected(table)) {
                row = table.addRow();
                row.getCell("isCheck").setValue((Object)false);
                row.getCell("length").setValue((Object)0);
                row.getCell("isHide").setValue((Object)false);
            } else {
                row = table.addRow(top);
                row.getCell("isCheck").setValue((Object)false);
                row.getCell("length").setValue((Object)0);
                row.getCell("isHide").setValue((Object)false);
            }
        } else {
            row = table.addRow();
            row.getCell("isCheck").setValue((Object)false);
            row.getCell("length").setValue((Object)0);
            row.getCell("isHide").setValue((Object)false);
        }
        row.getCell("dcode").setValue((Object)false);
        row.getCell("tpfiled").setValue((Object)false);
    }

    protected final boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                Boolean isLock = (Boolean)table.getRow(rowIndex).getCell("isLock").getValue();
                if (isLock != null) {
                    if (isLock.booleanValue()) {
                        MsgBox.showWarning((String)BarcodeClientUtils.getBarcodeResource("BasePropertyNoDelete"));
                        return;
                    }
                    table.removeRow(rowIndex);
                    continue;
                }
                table.removeRow(rowIndex);
            }
            if (table.getRow(0) != null) {
                table.getSelectManager().select(0, 0);
            }
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.actionAddLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnAddLine = (KDWorkButton)this.kDContainer1.add((Action)((Object)this.actionAddLine));
        this.btnAddLine.setText(null);
        this.btnAddLine.setSize(new Dimension(22, 19));
        this.btnAddLine.setEnabled(true);
        this.actionInsertLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnInsertLine = (KDWorkButton)this.kDContainer1.add((Action)((Object)this.actionInsertLine));
        this.btnInsertLine.setText(null);
        this.btnInsertLine.setSize(new Dimension(22, 19));
        this.btnInsertLine.setEnabled(true);
        this.actionRemoveLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnRemoveLine = (KDWorkButton)this.kDContainer1.add((Action)((Object)this.actionRemoveLine));
        this.btnRemoveLine.setText(null);
        this.btnRemoveLine.setSize(new Dimension(22, 19));
        this.btnRemoveLine.setEnabled(true);
        this.btnAddLine.setToolTipText(BarcodeClientUtils.getBarcodeResource("AddnewRow"));
        this.btnInsertLine.setToolTipText(BarcodeClientUtils.getBarcodeResource("InsertRow"));
        this.btnRemoveLine.setToolTipText(BarcodeClientUtils.getBarcodeResource("DeleteRow"));
        this.status.setEnabled(false);
        if (this.oprtState == "VIEW") {
            this.btnAddLine.setEnabled(false);
            this.btnInsertLine.setEnabled(false);
            this.btnRemoveLine.setEnabled(false);
        }
    }
}

