/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterInfo;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterTreeFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupFactory;
import com.kingdee.eas.barcode.scm.StatusEnum;
import com.kingdee.eas.barcode.scm.client.AbstractIndBarcodeMasterListUI;
import com.kingdee.eas.barcode.scm.client.FABarcodeUtils;
import com.kingdee.eas.barcode.scm.client.IndBarcodeMasterTreeEditUI;
import com.kingdee.eas.barcode.scm.util.BarcodeClientUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class IndBarcodeMasterListUI
extends AbstractIndBarcodeMasterListUI {
    private static final Logger logger = CoreUIObject.getLogger(IndBarcodeMasterListUI.class);
    boolean F7User = false;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        FABarcodeUtils.requestLicenseOrReleaseLicense(this.getUIContext(), true, (CoreUI)this);
        for (int i = 0; i < this.treeView.getControlPane().getComponentCount(); ++i) {
            this.treeView.getControlPane().getComponent(i).setVisible(false);
        }
        super.onLoad();
        this.actionExportData.setVisible(true);
        this.actionExportData.setEnabled(true);
        this.selectCanncel();
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.selectCanncel();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return IndBarcodeMasterFactory.getRemoteInstance();
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return IndBarcodeMasterTreeFactory.getRemoteInstance();
    }

    protected String getGroupEditUIName() {
        return IndBarcodeMasterTreeEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return "treeid.id";
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getRootName() {
        return BarcodeClientUtils.getBarcodeResource("CodeDocDefition");
    }

    @Override
    protected IObjectValue createNewData() {
        IndBarcodeMasterInfo objectValue = new IndBarcodeMasterInfo();
        return objectValue;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String currentId = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()).getCell("id").getValue().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("master", (Object)currentId));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)StatusEnum.ACTIVE));
        if (IndBarcodeSetupFactory.getRemoteInstance().exists(filter)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"cancleData"));
            SysUtil.abort();
        }
        super.actionCancel_actionPerformed(e);
        this.refreshList();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkCancel()) {
            this.cancelCancel();
            this.refreshList();
        } else {
            MsgBox.showWarning((String)BarcodeClientUtils.getBarcodeResource("SelectRow"));
        }
    }

    public boolean checkCancel() {
        return this.tblMain.getSelectManager().getActiveRowIndex() != -1;
    }

    public void selectCanncel() throws BOSException, EASBizException {
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (rowIndex == -1) {
            return;
        }
        BizEnumValueDTO state = (BizEnumValueDTO)this.tblMain.getRow(rowIndex).getCell("status").getValue();
        if ("ACTIVE".equals(state.getName())) {
            this.actionCancel.setEnabled(true);
            this.actionCancelCancel.setEnabled(false);
        } else {
            this.actionCancel.setEnabled(false);
            this.actionCancelCancel.setEnabled(true);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().getActiveRowIndex() != -1) {
            String currentId = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()).getCell("id").getValue().toString();
            int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
            BizEnumValueDTO state = (BizEnumValueDTO)this.tblMain.getRow(rowIndex).getCell("status").getValue();
            if (state.getName().equals("ACTIVE")) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"73_PackageBarcodeControllerBean"));
                SysUtil.abort();
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("master", (Object)currentId));
            if (IndBarcodeSetupFactory.getRemoteInstance().exists(filter)) {
                throw new EASBizException(new NumericExceptionSubItem("0001", BarcodeClientUtils.getBarcodeResource("DataIsReadyNoDelete")));
            }
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkTreeNodeSelected(e);
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode.getChildCount() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_OnlyLeaf_CanDelete"));
            SysUtil.abort();
        }
        String selectID = this.getSelectedNodeKeyValue();
        if (IndBarcodeMasterFactory.getRemoteInstance().exists("where treeid.id='" + selectID + "'")) {
            MsgBox.showWarning((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("DetailDataNoDelete"));
            SysUtil.abort();
        }
        super.actionGroupRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String currentId = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()).getCell("id").getValue().toString();
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        BizEnumValueDTO state = (BizEnumValueDTO)this.tblMain.getRow(rowIndex).getCell("status").getValue();
        if (state.getName().equals("ACTIVE")) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("master", (Object)currentId));
            if (IndBarcodeSetupFactory.getRemoteInstance().exists(filter)) {
                int index = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"tdData"));
                if (index == 0) {
                    this.showEditUI(e);
                    return;
                }
                SysUtil.abort();
            }
        }
        super.actionEdit_actionPerformed(e);
    }

    private void checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    private IUIWindow showEditUI(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkObjectExists();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"reEdit", (Object)true);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        if (this.isDoRefresh(uiWindow)) {
            if (UtilRequest.isPrepare((String)"ActionRefresh", (CoreUIObject)this)) {
                this.prepareRefresh(null).callHandler();
            }
            this.setLocatePre(false);
            this.refresh(e);
            this.setPreSelecteRow();
            this.setLocatePre(true);
        }
        return uiWindow;
    }

    public void setEntityFilter(boolean F7User) {
        this.F7User = F7User;
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        if (this.F7User) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)1));
            try {
                viewInfo.getFilter().mergeFilter(filter, "and");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.invoke(para, 1);
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "IndBarcodeMaster";
        param.datataskMode = 1;
        param.alias = EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"215_IndBarcodeMaster");
        param.varList = new ArrayList();
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }
}

