/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.barcode.scm.IndBarcodeRuleInfo;
import com.kingdee.eas.barcode.scm.client.AbstractIndBarcodeRuleListUI;
import com.kingdee.eas.barcode.scm.client.FABarcodeUtils;
import com.kingdee.eas.barcode.scm.client.SelectEntityUI;
import com.kingdee.eas.barcode.scm.util.BarcodeClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUIController;
import com.kingdee.eas.scm.im.inv.CountingTableInfo;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreeSelectionModel;
import org.apache.log4j.Logger;

public class IndBarcodeRuleListUI
extends AbstractIndBarcodeRuleListUI {
    private static final Logger logger = CoreUIObject.getLogger(IndBarcodeRuleListUI.class);
    private boolean isOnload;
    private HashMap hm = new HashMap();
    private boolean isTemplate;
    private IMetaDataLoader metaLoader = null;
    private HashMap aliasHM = new HashMap();
    private int curIndex = -1;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        FABarcodeUtils.requestLicenseOrReleaseLicense(this.getUIContext(), true, (CoreUI)this);
        super.onLoad();
        this.actionCancelCancel.setVisible(true);
        this.actionCancel.setVisible(true);
        this.initTree();
        this.selectCanncel();
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.refreshList();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkCancel()) {
            this.cancelCancel();
            this.refreshList();
        } else {
            MsgBox.showWarning((String)BarcodeClientUtils.getBarcodeResource("SelectRow"));
        }
    }

    public boolean checkCancel() throws EASBizException, BOSException {
        if (this.tblMain.getSelectManager().getActiveRowIndex() == -1) {
            return false;
        }
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        Object id = this.tblMain.getCell(rowIndex, "barcodeType.id").getValue();
        Object businessObjectID = this.tblMain.getCell(rowIndex, "businessObjectID").getValue();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("businessObjectID", businessObjectID));
        if (id != null) {
            filter.getFilterItems().add(new FilterItemInfo("barcodeType.id", id));
        }
        return true;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        try {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeEntity.getLastSelectedPathComponent();
            if (node == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SelectObject"));
                return;
            }
            if (!node.isLeaf()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SelectObjectRight"));
                return;
            }
            MetaDataBriefInfo uo = (MetaDataBriefInfo)node.getUserObject();
            String currOrgType = SysContext.getSysContext().getCurrentCtrlUnit().getOrgTypeStr();
            logger.debug((Object)(uo.getAlias() + " , " + uo.getName()));
            if (uo.isPackage()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SelectObjectRight"));
                return;
            }
            EntityObjectInfo eo = (EntityObjectInfo)MetaDataLoaderFactory.getMetaDataLoader(null).get(MetaDataTypeList.ENTITY, uo.getMetaDataPK());
            String string = currOrgType = eo.getExtendedProperty("OrgType") == null ? currOrgType : eo.getExtendedProperty("OrgType");
            if (currOrgType == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_OrgTypeNull"));
                return;
            }
            if (currOrgType.toLowerCase(Locale.ENGLISH).equals("none") && !SysContext.getSysContext().getCurrentCtrlUnit().getCU().getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_GroupRight"));
                return;
            }
            this.showDetailWindows("addnew", e);
        }
        catch (Exception err) {
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Error_ListToEdit"), (Throwable)err);
        }
    }

    void initTree() {
        DefaultKingdeeTreeNode root = this.createNode();
        this.treeEntity.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        this.treeEntity.repaint();
        TreeSelectionModel treeSelectionModel = this.treeEntity.getSelectionModel();
        this.treeEntity.getSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        this.treeEntity.setSelectionRow(1);
    }

    private DefaultKingdeeTreeNode createNode() {
        DefaultKingdeeTreeNode rootNode = null;
        rootNode = SelectEntityUI.getBaseData();
        try {
            rootNode = new SelectEntityUI().getBizBillAndBase();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rootNode;
    }

    @Override
    protected void treeEntity_valueChanged(TreeSelectionEvent e) throws Exception {
        this.treeEntity.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.refreshQueryData();
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.treeEntity.setCursor(Cursor.getDefaultCursor());
        }
        this.checkTable(this.tblMain);
    }

    private void refreshQueryData() throws Exception {
        EntityViewInfo evi;
        this.setIsOnload(false);
        this.mainQuery = evi = new EntityViewInfo();
        this.filterData();
    }

    private void checkTable(KDTable table) {
        for (int i = 0; i < table.getRowCount(); ++i) {
            if (table.getRow(i) == null || table.getRow(i).getCell("custompro") == null || table.getRow(i).getCell("custompro").getValue() != null) continue;
            table.getRow(i).getCell("custompro").setValue((Object)"number");
            table.getRow(i).getCell("customproname").setValue((Object)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource", (String)"codingrule"));
        }
    }

    private void filterData() throws Exception {
        FilterInfo filter = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer("");
        String strBizObj = "";
        ArrayList<String> bizObjs = new ArrayList<String>();
        ArrayList boList = this.getTreeBOList();
        if (boList == null) {
            return;
        }
        this.hm.clear();
        StringBuffer strBizObjs = new StringBuffer("");
        for (int i = 0; i < boList.size(); ++i) {
            MetaDataBriefInfo uo = (MetaDataBriefInfo)boList.get(i);
            this.hm.put(uo.getMetaDataPK().getPackage() + "." + uo.getMetaDataPK().getName(), uo);
            strBizObj = uo.getMetaDataPK().getPackage() + "." + uo.getMetaDataPK().getName();
            if (strBizObjs.length() > 0) {
                strBizObjs.append(",");
            }
            strBizObjs.append(strBizObj);
            bizObjs.add(strBizObj);
        }
        FilterItemInfo fi = new FilterItemInfo("businessObject", (Object)strBizObjs.toString(), CompareType.INCLUDE);
        filter.getFilterItems().add(fi);
        sbFormula.append("#0");
        if (this.mainQuery.getSorter().size() == 0) {
            SorterItemInfo sorterItem = new SorterItemInfo();
            sorterItem.setPropertyName("businessObject");
            sorterItem.setSortType(SortType.ASCEND);
            this.mainQuery.getSorter().add(sorterItem);
            sorterItem = new SorterItemInfo();
            sorterItem.setPropertyName("number");
            sorterItem.setSortType(SortType.ASCEND);
            this.mainQuery.getSorter().add(sorterItem);
        }
        this.mainQuery.setFilter(filter);
        this.refreshKDTable(this.tblMain);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void showDetailWindows(String flag, ActionEvent e) throws Exception {
        EntityObjectInfo eo;
        UIContext hm;
        block16: {
            block18: {
                block17: {
                    hm = new UIContext((Object)this);
                    hm.put((Object)"flag", (Object)flag);
                    eo = null;
                    if (this.tblMain.getSelectManager().getActiveRowIndex() < 0 || this.aliasHM == null || this.aliasHM.size() <= 0 || this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()).getCell("businessObject").getValue() == null) break block17;
                    String fbusinessObject = String.valueOf(this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()).getCell("businessObject").getValue());
                    String eoType = null;
                    if (!StringUtils.isEmpty((String)fbusinessObject)) {
                        eoType = String.valueOf(this.aliasHM.get(String.valueOf(this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()).getCell("businessObject").getValue())));
                    }
                    if (eo == null && !StringUtils.isEmpty(eoType) && !eoType.equals("null")) {
                        eo = this.createIMetaDataLoader().getEntity((IMetaDataPK)new MetaDataPK(eoType));
                        break block16;
                    } else {
                        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeEntity.getLastSelectedPathComponent();
                        if (node != null && node.isLeaf()) {
                            MetaDataBriefInfo uo = (MetaDataBriefInfo)node.getUserObject();
                            if (uo.isPackage()) {
                                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SelectObject"));
                                return;
                            }
                            IMetaDataLoader iMetaDataLoader = this.createIMetaDataLoader();
                            eo = (EntityObjectInfo)uo.getMetaData(iMetaDataLoader);
                            break block16;
                        } else {
                            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SelectObject"));
                            return;
                        }
                    }
                }
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeEntity.getLastSelectedPathComponent();
                if (node == null || !node.isLeaf()) break block18;
                MetaDataBriefInfo uo = (MetaDataBriefInfo)node.getUserObject();
                if (uo.isPackage()) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SelectObject"));
                    return;
                }
                IMetaDataLoader iMetaDataLoader = this.createIMetaDataLoader();
                eo = (EntityObjectInfo)uo.getMetaData(iMetaDataLoader);
                if (eo == null) {
                    CountingTableInfo info;
                    if ("CountingTable".equalsIgnoreCase(uo.getName())) {
                        info = new CountingTableInfo();
                        eo = iMetaDataLoader.getEntity(info.getBOSType());
                    }
                    if ("Inventory".equalsIgnoreCase(uo.getName())) {
                        info = new InventoryInfo();
                        eo = iMetaDataLoader.getEntity(info.getBOSType());
                    }
                }
                break block16;
            }
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SelectObject"));
            return;
        }
        hm.put((Object)"EntityObjectInfo", (Object)eo);
        if (SysContext.getSysContext().getCurrentFIUnit() != null) {
            CompanyOrgUnitInfo orgInfo = SysContext.getSysContext().getCurrentFIUnit();
            hm.put((Object)"CompanyOrgUnitInfo", (Object)orgInfo);
        }
        if (!flag.equals("addnew") && (flag.equals("update") || flag.equals("readonly") || flag.equals("update_limited"))) {
            hm.put((Object)"CodingRule_Number", this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()).getCell("number").getValue());
            hm.put((Object)"CodingRule_Id", this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()).getCell("id").getValue());
            ArrayList idList = new ArrayList();
            int currentIndex = this.createIDList(this.tblMain, idList);
            if (idList.size() > 1) {
                hm.put((Object)"currentIndex", (Object)new Integer(currentIndex));
                hm.put((Object)"idList", idList);
            }
        }
        hm.put((Object)"canResize", (Object)"false");
        this.prepareUIContext(hm, e);
        this.getUIContext().putAll(hm);
        IUIWindow uiWindow = null;
        ((ListUIController)super.getUIController()).actionAddNew();
        uiWindow = ((ListUIController)super.getUIController()).getNavigator().getUIWindow();
        Window win = SwingUtilities.getWindowAncestor((Component)uiWindow.getUIObject());
        if (!win.isActive() && win instanceof JFrame && ((JFrame)win).getExtendedState() == 1) {
            ((JFrame)win).setExtendedState(0);
        }
        if (uiWindow == null || !this.isDoRefresh(uiWindow)) {
            return;
        }
        if (UtilRequest.isPrepare((String)"ActionRefresh", (CoreUIObject)this)) {
            this.prepareRefresh(null).callHandler();
        }
        this.refresh(e);
        this.setPreSelecteRow();
    }

    private int createIDList(KDTable table, ArrayList idList) {
        int currentIndex = -1;
        String currentId = table.getRow(this.tblMain.getSelectManager().getActiveRowIndex()).getCell("id").getValue().toString();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = table.getRow(i);
            if (row.getCell("id").getValue() == null) continue;
            idList.add(row.getCell("id").getValue().toString());
            if (!row.getCell("id").getValue().toString().equals(currentId)) continue;
            currentIndex = i;
        }
        return currentIndex;
    }

    public void eoFromNode(EntityObjectInfo eo) {
        MetaDataBriefInfo uo;
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeEntity.getLastSelectedPathComponent();
        if (node != null && node.isLeaf()) {
            uo = (MetaDataBriefInfo)node.getUserObject();
            if (uo.isPackage()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SelectObject"));
                return;
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SelectObject"));
            return;
        }
        eo = (EntityObjectInfo)uo.getMetaData(this.createIMetaDataLoader());
    }

    public IMetaDataLoader createIMetaDataLoader() {
        this.metaLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return this.metaLoader;
    }

    private ArrayList getTreeBOList() {
        KDTree tree = this.treeEntity;
        DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)tree.getLastSelectedPathComponent();
        ArrayList list = null;
        if (selectedNode != null) {
            list = this.getBOList(selectedNode);
        } else {
            logger.debug((Object)"tree event:No select Leaf Node!");
        }
        return list;
    }

    private ArrayList getBOList(DefaultKingdeeTreeNode root) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (root.isLeaf()) {
            list.add(root.getUserObject());
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                if (root.getChildAt(i).isLeaf()) {
                    Object childrenNode = ((DefaultKingdeeTreeNode)root.getChildAt(i)).getUserObject();
                    list.add(childrenNode);
                    continue;
                }
                list.addAll(this.getBOList((DefaultKingdeeTreeNode)root.getChildAt(i)));
            }
        }
        return list;
    }

    protected void refreshKDTable(KDTable table) {
        this.saveCurrentLocation(table);
        table.removeRows();
        this.restoreCurrentLocation(table);
        this.checkTable(table);
    }

    protected void restoreCurrentLocation(KDTable table) {
        if (table.getRow(this.curIndex) != null) {
            table.getSelectManager().select(this.curIndex, 0);
        }
    }

    protected void saveCurrentLocation(KDTable table) {
        KDTSelectBlock selectBlock = table.getSelectManager().get();
        this.curIndex = selectBlock != null ? selectBlock.getTop() : 0;
    }

    public boolean isOnload() {
        return this.isOnload;
    }

    public void setIsOnload(boolean isOnload) {
        this.isOnload = isOnload;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public void setIsTemplate(boolean isTemplate) {
        this.isTemplate = isTemplate;
    }

    @Override
    protected IObjectValue createNewData() {
        IndBarcodeRuleInfo objectValue = new IndBarcodeRuleInfo();
        return objectValue;
    }

    public void selectCanncel() throws BOSException, EASBizException {
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (rowIndex == -1) {
            return;
        }
        BizEnumValueDTO state = (BizEnumValueDTO)this.tblMain.getRow(rowIndex).getCell("state").getValue();
        if ("ACTIVE".equals(state.getName())) {
            this.actionCancel.setEnabled(true);
            this.actionCancelCancel.setEnabled(false);
        } else {
            this.actionCancel.setEnabled(false);
            this.actionCancelCancel.setEnabled(true);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        this.selectCanncel();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex;
        BizEnumValueDTO state;
        if (this.tblMain.getSelectManager().getActiveRowIndex() != -1 && (state = (BizEnumValueDTO)this.tblMain.getRow(rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain)).getCell("state").getValue()).getName().equals("ACTIVE")) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"73_PackageBarcodeControllerBean"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex;
        BizEnumValueDTO state;
        if (this.tblMain.getSelectManager().getActiveRowIndex() != -1 && (state = (BizEnumValueDTO)this.tblMain.getRow(rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain)).getCell("state").getValue()).getName().equals("ACTIVE")) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"72_PackageBarcodeControllerBean"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    static class TreeObject {
        private BusinessObjectInfo bo;
        private String nodeText;

        TreeObject(BusinessObjectInfo bo, String nodeText) {
            this.bo = bo;
            this.nodeText = nodeText;
        }

        public BusinessObjectInfo getBusinessObjectInfo() {
            return this.bo;
        }

        public String toString() {
            return this.nodeText;
        }
    }
}

