/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupInfo;
import com.kingdee.eas.barcode.scm.client.AbstractIndBarcodeSetupListUI;
import com.kingdee.eas.barcode.scm.client.FABarcodeUtils;
import com.kingdee.eas.barcode.scm.client.SelectEntityUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUIController;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreeSelectionModel;
import org.apache.log4j.Logger;

public class IndBarcodeSetupListUI
extends AbstractIndBarcodeSetupListUI {
    private static final Logger logger = CoreUIObject.getLogger(IndBarcodeSetupListUI.class);
    private boolean isOnload;
    private HashMap hm = new HashMap();
    private boolean isTemplate;
    private IMetaDataLoader metaLoader = null;
    private HashMap aliasHM = new HashMap();
    private int curIndex = -1;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        FABarcodeUtils.requestLicenseOrReleaseLicense(this.getUIContext(), true, (CoreUI)this);
        super.onLoad();
        this.initTree();
        this.actionCancel.setVisible(true);
        this.actionCancelCancel.setVisible(true);
        this.selectCanncel();
        this.tblMain.getColumn("masterID").getStyleAttributes().setHided(true);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblMain.getColumn("masterID").getStyleAttributes().setHided(true);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.tblMain.getColumn("masterID").getStyleAttributes().setHided(true);
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("master.*"));
        sic.add(new SelectorItemInfo("master.ruleName"));
        return sic;
    }

    void initTree() {
        DefaultKingdeeTreeNode root = this.createNode();
        this.treeEntity.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        this.treeEntity.repaint();
        TreeSelectionModel treeSelectionModel = this.treeEntity.getSelectionModel();
        this.treeEntity.getSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        this.treeEntity.setSelectionRow(1);
    }

    private DefaultKingdeeTreeNode createNode() {
        DefaultKingdeeTreeNode rootNode = null;
        rootNode = SelectEntityUI.getBaseData();
        try {
            rootNode = new SelectEntityUI().getBizBillAndBase();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rootNode;
    }

    public IMetaDataLoader createIMetaDataLoader() {
        this.metaLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return this.metaLoader;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        this.selectCanncel();
    }

    @Override
    protected void treeEntity_valueChanged(TreeSelectionEvent e) throws Exception {
        this.treeEntity.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.refreshQueryData();
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.treeEntity.setCursor(Cursor.getDefaultCursor());
        }
        this.checkTable(this.tblMain);
    }

    public boolean isOnload() {
        return this.isOnload;
    }

    public void setIsOnload(boolean isOnload) {
        this.isOnload = isOnload;
    }

    private void refreshQueryData() throws Exception {
        EntityViewInfo evi;
        this.setIsOnload(false);
        this.mainQuery = evi = new EntityViewInfo();
        this.filterData();
    }

    private void checkTable(KDTable table) {
        for (int i = 0; i < table.getRowCount(); ++i) {
            if (table.getRow(i) == null || table.getRow(i).getCell("custompro") == null || table.getRow(i).getCell("custompro").getValue() != null) continue;
            table.getRow(i).getCell("custompro").setValue((Object)"number");
            table.getRow(i).getCell("customproname").setValue((Object)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource", (String)"codingrule"));
        }
    }

    private ArrayList getTreeBOList() {
        KDTree tree = this.treeEntity;
        DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)tree.getLastSelectedPathComponent();
        ArrayList list = null;
        if (selectedNode != null) {
            list = this.getBOList(selectedNode);
        } else {
            logger.debug((Object)"tree event:No select Leaf Node!");
        }
        return list;
    }

    private ArrayList getBOList(DefaultKingdeeTreeNode root) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (root.isLeaf()) {
            list.add(root.getUserObject());
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                if (root.getChildAt(i).isLeaf()) {
                    Object childrenNode = ((DefaultKingdeeTreeNode)root.getChildAt(i)).getUserObject();
                    list.add(childrenNode);
                    continue;
                }
                list.addAll(this.getBOList((DefaultKingdeeTreeNode)root.getChildAt(i)));
            }
        }
        return list;
    }

    private void filterData() throws Exception {
        FilterInfo filter = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer("");
        String strBizObj = "";
        ArrayList<String> bizObjs = new ArrayList<String>();
        ArrayList boList = this.getTreeBOList();
        if (boList == null) {
            return;
        }
        this.hm.clear();
        StringBuffer strBizObjs = new StringBuffer("");
        for (int i = 0; i < boList.size(); ++i) {
            MetaDataBriefInfo uo = (MetaDataBriefInfo)boList.get(i);
            this.hm.put(uo.getMetaDataPK().getPackage() + "." + uo.getMetaDataPK().getName(), uo);
            strBizObj = uo.getMetaDataPK().getPackage() + "." + uo.getMetaDataPK().getName();
            if (strBizObjs.length() > 0) {
                strBizObjs.append(",");
            }
            strBizObjs.append(strBizObj);
            bizObjs.add(strBizObj);
        }
        FilterItemInfo fi = new FilterItemInfo("businessObject", (Object)strBizObjs.toString(), CompareType.INCLUDE);
        filter.getFilterItems().add(fi);
        sbFormula.append("#0");
        if (this.mainQuery.getSorter().size() == 0) {
            SorterItemInfo sorterItem = new SorterItemInfo();
            sorterItem.setPropertyName("businessObject");
            sorterItem.setSortType(SortType.ASCEND);
            this.mainQuery.getSorter().add(sorterItem);
            sorterItem = new SorterItemInfo();
            sorterItem.setPropertyName("number");
            sorterItem.setSortType(SortType.ASCEND);
            this.mainQuery.getSorter().add(sorterItem);
        }
        this.mainQuery.setFilter(filter);
        this.refreshKDTable(this.tblMain);
    }

    protected void restoreCurrentLocation(KDTable table) {
        if (table.getRow(this.curIndex) != null) {
            table.getSelectManager().select(this.curIndex, 0);
        }
    }

    protected void refreshKDTable(KDTable table) {
        this.saveCurrentLocation(table);
        table.removeRows();
        this.restoreCurrentLocation(table);
        this.checkTable(table);
    }

    protected void saveCurrentLocation(KDTable table) {
        KDTSelectBlock selectBlock = table.getSelectManager().get();
        this.curIndex = selectBlock != null ? selectBlock.getTop() : 0;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return IndBarcodeSetupFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        IndBarcodeSetupInfo objectValue = new IndBarcodeSetupInfo();
        return objectValue;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.refreshList();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.checkCancel()) {
            this.cancelCancel();
            this.refreshList();
        }
    }

    public boolean checkCancel() {
        String masterID = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()).getCell("masterID").getValue().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)masterID));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)2));
        try {
            if (IndBarcodeMasterFactory.getRemoteInstance().exists(filter)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"canlcecanlceEnable"));
                return false;
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void selectCanncel() throws BOSException, EASBizException {
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (rowIndex == -1) {
            return;
        }
        BizEnumValueDTO state = (BizEnumValueDTO)this.tblMain.getRow(rowIndex).getCell("state").getValue();
        if ("ACTIVE".equals(state.getName())) {
            this.actionCancel.setEnabled(true);
            this.actionCancelCancel.setEnabled(false);
        } else {
            this.actionCancel.setEnabled(false);
            this.actionCancelCancel.setEnabled(true);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex;
        BizEnumValueDTO state;
        if (this.tblMain.getSelectManager().getActiveRowIndex() != -1 && (state = (BizEnumValueDTO)this.tblMain.getRow(rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain)).getCell("state").getValue()).getName().equals("ACTIVE")) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"73_PackageBarcodeControllerBean"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex;
        BizEnumValueDTO state;
        if (this.tblMain.getSelectManager().getActiveRowIndex() != -1 && (state = (BizEnumValueDTO)this.tblMain.getRow(rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain)).getCell("state").getValue()).getName().equals("ACTIVE")) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"72_PackageBarcodeControllerBean"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeEntity.getLastSelectedPathComponent();
        EntityObjectInfo eo = null;
        if (node.isLeaf()) {
            MetaDataBriefInfo uo = (MetaDataBriefInfo)node.getUserObject();
            logger.debug((Object)(uo.getAlias() + " , " + uo.getName()));
            if (!uo.isPackage()) {
                eo = (EntityObjectInfo)uo.getMetaData(this.createIMetaDataLoader());
            }
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        uiContext.put((Object)"EntityObjectInfo", eo);
        this.prepareUIContext(uiContext, e);
        this.getUIContext().putAll(uiContext);
        IUIWindow uiWindow = null;
        ((ListUIController)super.getUIController()).actionAddNew();
        uiWindow = ((ListUIController)super.getUIController()).getNavigator().getUIWindow();
        Window win = SwingUtilities.getWindowAncestor((Component)uiWindow.getUIObject());
        if (!win.isActive() && win instanceof JFrame && ((JFrame)win).getExtendedState() == 1) {
            ((JFrame)win).setExtendedState(0);
        }
        if (uiWindow == null || !this.isDoRefresh(uiWindow)) {
            return;
        }
        if (UtilRequest.isPrepare((String)"ActionRefresh", (CoreUIObject)this)) {
            this.prepareRefresh(null).callHandler();
        }
        this.refresh(e);
        this.setPreSelecteRow();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        String selectorAll = System.getProperty("selector.all");
        if (StringUtils.isEmpty((String)selectorAll)) {
            selectorAll = "true";
        }
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("relationNub"));
        sic.add(new SelectorItemInfo("relationName"));
        sic.add(new SelectorItemInfo("isBarcodeRepeat"));
        sic.add(new SelectorItemInfo("isCumsumQty"));
        sic.add(new SelectorItemInfo("remark"));
        sic.add(new SelectorItemInfo("entityAlias"));
        sic.add(new SelectorItemInfo("master.ruleName"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("master.id"));
        return sic;
    }

    static class TreeObject {
        private BusinessObjectInfo bo;
        private String nodeText;

        TreeObject(BusinessObjectInfo bo, String nodeText) {
            this.bo = bo;
            this.nodeText = nodeText;
        }

        public BusinessObjectInfo getBusinessObjectInfo() {
            return this.bo;
        }

        public String toString() {
            return this.nodeText;
        }
    }
}

