/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetCollection;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetFactory;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetInfo;
import com.kingdee.eas.barcode.scm.ViewSizeEnum;
import com.kingdee.eas.barcode.scm.client.AbstractIndubarodeParamsetEditUI;
import com.kingdee.eas.barcode.scm.client.FABarcodeUtils;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class IndubarodeParamsetEditUI
extends AbstractIndubarodeParamsetEditUI {
    private static final Logger logger = CoreUIObject.getLogger(IndubarodeParamsetEditUI.class);

    @Override
    public void loadFields() {
        super.loadFields();
        this.chkbarcodeInv.setEnabled(true);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.txtDescription.setMaxLength(255);
        this.btnViewSizeGroup.setValue(Integer.valueOf(this.editData == null || this.editData.getPdaViewSize() == null ? "0" : this.editData.getPdaViewSize().getValue()).intValue());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        FABarcodeUtils.requestLicenseOrReleaseLicense(this.getUIContext(), true, (CoreUI)this);
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(123, 0), "F12Press");
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndubarodeParamsetEditUI.this.kDPanel2.setVisible(true);
                IndubarodeParamsetEditUI.this.contexpDate.setVisible(true);
                IndubarodeParamsetEditUI.this.contdays.setVisible(true);
            }
        };
        actionMap.put("F12Press", escAction);
        this.kDPanel2.setVisible(false);
        this.contexpDate.setVisible(false);
        this.contdays.setVisible(false);
        try {
            IndubarodeParamsetCollection indParamCol = IndubarodeParamsetFactory.getRemoteInstance().getIndubarodeParamsetCollection();
            if (indParamCol != null && indParamCol.size() > 0) {
                this.getUIContext().put("ID", indParamCol.get(0).getId());
                this.setOprtState("VIEW");
            } else {
                this.setOprtState("ADDNEW");
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        super.onLoad();
    }

    @Override
    protected void chkbarcodeLot_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkbarcodeLot.isSelected()) {
            this.chkbarcodeInv.setSelected(true);
            this.chkbarcodeInv.setEnabled(false);
        } else {
            this.chkbarcodeInv.setSelected(false);
            this.chkbarcodeInv.setEnabled(true);
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return IndubarodeParamsetFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        IndubarodeParamsetInfo objectValue = new IndubarodeParamsetInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        try {
            IndubarodeParamsetCollection paramList = IndubarodeParamsetFactory.getRemoteInstance().getIndubarodeParamsetCollection();
            if (paramList.size() > 0) {
                IndubarodeParamsetInfo paramInfo = paramList.get(0);
                objectValue.setIndBarcode(paramInfo.isIndBarcode());
                objectValue.setBusinessBarcode(paramInfo.isBusinessBarcode());
                objectValue.setPriorBusiness(paramInfo.isPriorBusiness());
                objectValue.setPriorInd(paramInfo.isPriorInd());
                objectValue.setDescription(paramInfo.getDescription());
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return objectValue;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        IndubarodeParamsetCollection paramList = IndubarodeParamsetFactory.getRemoteInstance().getIndubarodeParamsetCollection();
        if (paramList.size() > 0) {
            IndubarodeParamsetInfo paramInfo = paramList.get(0);
            IndubarodeParamsetFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(paramInfo.getId()));
        }
        int viewSize = this.btnViewSizeGroup.getValue();
        this.getViewSizeEnum(viewSize);
        this.editData.setPdaViewSize(this.getViewSizeEnum(viewSize));
        super.actionSubmit_actionPerformed(e);
    }

    private ViewSizeEnum getViewSizeEnum(int viewSize) {
        ViewSizeEnum ve = null;
        switch (viewSize) {
            case 0: {
                ve = ViewSizeEnum.getEnum("0");
                break;
            }
            case 1: {
                ve = ViewSizeEnum.getEnum("1");
                break;
            }
            default: {
                ve = ViewSizeEnum.getEnum("0");
            }
        }
        return ve;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("businessBarcode"));
        sic.add(new SelectorItemInfo("indBarcode"));
        sic.add(new SelectorItemInfo("priorBusiness"));
        sic.add(new SelectorItemInfo("priorInd"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("pdaViewSize"));
        sic.add(new SelectorItemInfo("pdaurl"));
        sic.add(new SelectorItemInfo("pdaViewSize"));
        sic.add(new SelectorItemInfo("pdaurl"));
        return sic;
    }
}

