/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.barcode.scm.BarcodeDossierCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierFactory;
import com.kingdee.eas.barcode.scm.BarcodeDossierInfo;
import com.kingdee.eas.barcode.scm.PackageBarcodeFactory;
import com.kingdee.eas.barcode.scm.PackageBarcodeInfo;
import com.kingdee.eas.barcode.scm.StatusEnum;
import com.kingdee.eas.barcode.scm.client.AbstractPackageBarcodeEditUI;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class PackageBarcodeEditUI
extends AbstractPackageBarcodeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PackageBarcodeEditUI.class);
    protected static final String TB_DETAILBARCODE = "barcode";
    protected static final String TB_MATERIALNUMBER = "materialNumber";
    protected static final String TB_MATERIALNAME = "materialName";
    protected static final String TB_MODEL = "model";
    protected static final String TB_AsstAttrValue = "asstAttrValue";
    protected static final String TB_BARCODEQTY = "barcodeQty";
    protected ActionBarcode barcodeAction = new ActionBarcode();
    protected KDWorkButton btnRemoveLine = null;

    public void onLoad() throws Exception {
        this.kdtEntry.checkParsed();
        super.onLoad();
        this.btnSave.setVisible(false);
        this.btnCopy.setVisible(false);
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        this.menuItemCopy.setVisible(false);
        this.actionSubmitOption.setVisible(false);
        this.prmtLastUpdateUser.setDisplayFormat("$name$");
        this.prmtCreator.setDisplayFormat("$name$");
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.txtDetailBarcode, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.txtDetailBarcode.setAction((Action)this.barcodeAction);
        this.txtDetailBarcode.setEnabled(true);
        this.txtDetailBarcode.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                PackageBarcodeEditUI.this.txtDetailBarcode.selectAll();
            }
        });
        this.actionRemoveLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnRemoveLine = (KDWorkButton)this.kDContainer1.add((Action)((Object)this.actionRemoveLine));
        this.btnRemoveLine.setText(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"149_BarcodeScanningEditUI"));
        this.btnRemoveLine.setSize(new Dimension(22, 19));
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if ("VIEW".equals(this.oprtState)) {
            this.actionCancel.setEnabled(true);
            this.actionCancelCancel.setEnabled(true);
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.actionCancel.setEnabled(false);
            this.actionCancelCancel.setEnabled(false);
            this.actionRemoveLine.setEnabled(true);
        } else if (this.getOprtState().equals(OprtState.EDIT)) {
            this.actionCancel.setEnabled(true);
            this.actionCancelCancel.setEnabled(true);
            this.actionRemoveLine.setEnabled(true);
        } else if (this.getOprtState().equals(OprtState.VIEW)) {
            this.actionCancel.setEnabled(true);
            this.actionCancelCancel.setEnabled(true);
            this.actionRemoveLine.setEnabled(false);
        }
        this.txtDetailBarcode.setText(null);
    }

    protected IObjectValue createNewData() {
        PackageBarcodeInfo info = new PackageBarcodeInfo();
        info.setStatus(StatusEnum.SAVED);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PackageBarcodeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public void loadFields() {
        super.loadFields();
        int size = this.kdtEntry.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kdtEntry.getRow(i);
            if (row.getCell(TB_DETAILBARCODE).getValue() == null) continue;
            String barcode = row.getCell(TB_DETAILBARCODE).getValue().toString();
            this.setRowCellValue(row, barcode);
        }
    }

    protected void detailBarcode_Action(ActionEvent e) {
        int[] rowIndx = KDTableUtil.getSelectedRows((KDTable)this.kdtEntry);
        IRow row = rowIndx.length > 0 ? this.kdtEntry.getRow(rowIndx[0]) : this.kdtEntry.addRow();
        row.getCell(TB_DETAILBARCODE).setValue((Object)this.txtDetailBarcode.getText());
        this.setRowCellValue(row, this.txtDetailBarcode.getText().trim());
        this.kdtEntry.getSelectManager().remove();
        this.txtDetailBarcode.selectAll();
    }

    protected void setRowCellValue(IRow row, String barcode) {
        BarcodeDossierInfo barcodeDossierInfo = this.getBarcodeDossierInfo(barcode);
        if (barcodeDossierInfo != null) {
            String assistNature;
            if (barcodeDossierInfo.getMaterial() != null) {
                row.getCell(TB_MATERIALNUMBER).setValue((Object)barcodeDossierInfo.getMaterial().getNumber());
                row.getCell(TB_MATERIALNAME).setValue((Object)barcodeDossierInfo.getMaterial().getName());
                row.getCell(TB_MODEL).setValue((Object)barcodeDossierInfo.getMaterial().getModel());
            }
            if ((assistNature = barcodeDossierInfo.getAssistNature()) != null && !"".equals(assistNature)) {
                try {
                    AsstAttrValueInfo valueInfo = AsstAttrValueFactory.getRemoteInstance().getAsstAttrValueInfo((IObjectPK)new ObjectUuidPK(assistNature));
                    row.getCell(TB_AsstAttrValue).setValue((Object)valueInfo.getName());
                }
                catch (EASBizException e1) {
                    e1.printStackTrace();
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                }
            }
            row.getCell(TB_BARCODEQTY).setValue((Object)barcodeDossierInfo.getQty());
        }
    }

    protected BarcodeDossierInfo getBarcodeDossierInfo(String barcode) {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("material.id"));
        coll.add(new SelectorItemInfo("material.number"));
        coll.add(new SelectorItemInfo("material.name"));
        coll.add(new SelectorItemInfo("material.model"));
        coll.add(new SelectorItemInfo("assistNature"));
        coll.add(new SelectorItemInfo("qty"));
        view.setSelector(coll);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)barcode, CompareType.EQUALS));
        view.setFilter(filter);
        try {
            BarcodeDossierCollection barcodeCol = BarcodeDossierFactory.getRemoteInstance().getBarcodeDossierCollection(view);
            if (barcodeCol.size() > 0) {
                return barcodeCol.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.isNullValue(this.txtPacakgeBarcode.getText())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"74_PackageBarcodeControllerBean"));
            SysUtil.abort();
        }
        if (this.kdtEntry.getRowCount3() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"75_PackageBarcodeControllerBean"));
            SysUtil.abort();
        } else {
            for (int i = 0; i < this.kdtEntry.getRowCount3(); ++i) {
                IRow row = this.kdtEntry.getRow(i);
                Object barcode = row.getCell(TB_DETAILBARCODE).getValue();
                if (!this.isNullValue(barcode)) continue;
                MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"76_PackageBarcodeControllerBean") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"190_PackageBarcodeEditUI")));
                SysUtil.abort();
            }
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getStatus() == StatusEnum.ACTIVE) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"191_PackageBarcodeEditUI"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getStatus() == StatusEnum.INACTIVE) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"70_PackageBarcodeControllerBean"));
            SysUtil.abort();
        }
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getStatus() != StatusEnum.SAVED && this.editData.getStatus() != StatusEnum.INACTIVE) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"71_PackageBarcodeControllerBean"));
            SysUtil.abort();
        }
        super.actionCancelCancel_actionPerformed(e);
    }

    protected boolean isNullValue(Object value) {
        return value == null || value.toString().equals("");
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        this.removeLine(this.kdtEntry);
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                table.removeRow(rowIndex);
            }
            this.kdtEntry.getSelectManager().remove();
        }
    }

    class ActionBarcode
    implements Action {
        ActionBarcode() {
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public Object getValue(String key) {
            return null;
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public void putValue(String key, Object value) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void setEnabled(boolean b) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PackageBarcodeEditUI.this.detailBarcode_Action(e);
        }
    }
}

