/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.UIFocusTraversalPolicy;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.barcode.scm.IPdaDataCenters;
import com.kingdee.eas.barcode.scm.PdaDataCentersCollection;
import com.kingdee.eas.barcode.scm.PdaDataCentersFactory;
import com.kingdee.eas.barcode.scm.PdaDataCentersInfo;
import com.kingdee.eas.barcode.scm.client.AbstractPdaDataCentersEditUI;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class PdaDataCentersEditUI
extends AbstractPdaDataCentersEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PdaDataCentersEditUI.class);
    private Map<String, DCInfo> dcMap = new HashMap<String, DCInfo>();

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        IPdaDataCenters iPdaDataCenters = (IPdaDataCenters)this.getBizInterface();
        PdaDataCentersCollection pdadc = iPdaDataCenters.getPdaDataCentersCollection();
        if (pdadc.size() > 0) {
            this.getUIContext().put("ID", pdadc.get(0).getId());
            this.setOprtState("VIEW");
        } else {
            this.setOprtState("ADDNEW");
        }
        super.onLoad();
        ArrayList dcList = iPdaDataCenters.getDataCenters();
        ArrayList dcNumberList = new ArrayList();
        int size = dcList.size();
        for (int i = 0; i < size; ++i) {
            DCInfo dcInfo = (DCInfo)dcList.get(i);
            String number = dcInfo.getNumber();
            if (this.dcMap.containsKey(number)) continue;
            this.dcMap.put(number, dcInfo);
        }
        KDComboBox dcName = new KDComboBox();
        dcName.setName("dcName");
        dcName.setVisible(true);
        dcName.addItems(this.dcMap.keySet().toArray());
        dcName.setRequired(false);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)new UIFocusTraversalPolicy(new Component[]{dcName}));
        this.setFocusCycleRoot(true);
        this.contdcName.setBoundEditor((JComponent)dcName);
        this.txtNumber.setEnabled(false);
        dcName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object number = e.getItem();
                if (number == null) {
                    return;
                }
                String numebrStr = number.toString();
                if (PdaDataCentersEditUI.this.dcMap.containsKey(numebrStr)) {
                    DCInfo dcInfo = (DCInfo)PdaDataCentersEditUI.this.dcMap.get(numebrStr);
                    PdaDataCentersEditUI.this.txtNumber.setText(dcInfo.getVersion());
                }
            }
        });
    }

    protected void dcName_itemStateChanged(ItemEvent e) throws Exception {
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PdaDataCentersFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        PdaDataCentersInfo objectValue = new PdaDataCentersInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        try {
            IPdaDataCenters iPdaDataCenters = (IPdaDataCenters)this.getBizInterface();
            PdaDataCentersCollection pdadc = iPdaDataCenters.getPdaDataCentersCollection();
            if (pdadc.size() > 0) {
                PdaDataCentersInfo pdcInfo = pdadc.get(0);
                objectValue.setDcName(pdcInfo.getDcName());
                objectValue.setNumber(pdcInfo.getNumber());
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objectValue;
    }
}

