/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.barcode.scm.IPosition;
import com.kingdee.eas.barcode.scm.PositionCollection;
import com.kingdee.eas.barcode.scm.PositionFactory;
import com.kingdee.eas.barcode.scm.PositionInfo;
import com.kingdee.eas.barcode.scm.StatusEnum;
import com.kingdee.eas.barcode.scm.client.AbstractPositionListUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class PositionListUI
extends AbstractPositionListUI {
    private static final Logger logger = CoreUIObject.getLogger(PositionListUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void changeWBTEnabeld(boolean isEnabled) {
        this.btnCancelCancel.setEnabled(!isEnabled);
        this.actionCancelCancel.setEnabled(!isEnabled);
        this.btnCancel.setEnabled(isEnabled);
        this.actionCancel.setEnabled(isEnabled);
    }

    private boolean statusIsEnabled() {
        ICell icell;
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            return false;
        }
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex != -1 && (icell = this.tblMain.getRow(rowIndex).getCell("status")) != null && icell.getValue() != null) {
            return icell.getValue().toString().equalsIgnoreCase(StatusEnum.ACTIVE.toString());
        }
        return false;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        this.changeWBTEnabeld(this.statusIsEnabled());
        super.tblMain_tableClicked(e);
    }

    private boolean disabledFtp(String ftpConfigId) throws Exception {
        IPosition iPosition = (IPosition)this.getBizInterface();
        ObjectUuidPK pk = new ObjectUuidPK(ftpConfigId);
        PositionInfo positionInfo = iPosition.getPositionInfo((IObjectPK)pk);
        positionInfo.setStatus(StatusEnum.INACTIVE);
        iPosition.update((IObjectPK)pk, (CoreBaseInfo)positionInfo);
        return true;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        ICell icell = this.tblMain.getRow(rowIndex).getCell("id");
        if (icell != null && icell.getValue() != null) {
            String ftpConfigId = icell.getValue().toString();
            if (this.disabledFtp(ftpConfigId)) {
                MsgBox.showInfo((String)"\u7981\u7528\u6210\u529f\uff01");
                this.changeWBTEnabeld(false);
            } else {
                MsgBox.showInfo((String)"\u7981\u7528\u5931\u8d25\uff01");
            }
        }
        this.refresh(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        ICell icell = this.tblMain.getRow(rowIndex).getCell("id");
        if (icell != null && icell.getValue() != null) {
            String ftpConfigId = icell.getValue().toString();
            if (this.enabledFtp(ftpConfigId)) {
                MsgBox.showInfo((String)"\u542f\u7528\u6210\u529f\uff01");
                this.changeWBTEnabeld(true);
            } else {
                MsgBox.showInfo((String)"\u542f\u7528\u5931\u8d25\uff01");
            }
        }
        this.refresh(e);
    }

    private boolean enabledFtp(String ftpConfigId) throws Exception {
        String oql;
        IPosition iPosition = (IPosition)this.getBizInterface();
        PositionCollection coll = iPosition.getPositionCollection(oql = "select id where status = 1 and  id='" + ftpConfigId + "'");
        if (coll == null || coll.size() == 0) {
            ObjectUuidPK pk = new ObjectUuidPK(ftpConfigId);
            PositionInfo ftpConfigInfo = iPosition.getPositionInfo((IObjectPK)pk);
            ftpConfigInfo.setStatus(StatusEnum.ACTIVE);
            iPosition.update((IObjectPK)pk, (CoreBaseInfo)ftpConfigInfo);
            return true;
        }
        logger.info((Object)"other ftp is started");
        return false;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        BizEnumValueDTO status;
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int index = -1;
        if (selectRows.length > 0) {
            index = selectRows[0];
        }
        if ((status = (BizEnumValueDTO)this.tblMain.getRow(index).getCell("status").getValue()).getName().equals("ACTIVE")) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"117_BarcodeDictEditUI"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PositionFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        PositionInfo objectValue = new PositionInfo();
        return objectValue;
    }
}

