/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.runtime.BotUtil;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.eqm.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.barcode.scm.BarcodeAnalysisResultItem;
import com.kingdee.eas.barcode.scm.BarcodeConfigFactory;
import com.kingdee.eas.barcode.scm.BarcodeConfigInfo;
import com.kingdee.eas.barcode.scm.BarcodeConfigXML;
import com.kingdee.eas.barcode.scm.BarcodeConfigXMLDetail;
import com.kingdee.eas.barcode.scm.BarcodeConfigXMLProperty;
import com.kingdee.eas.barcode.scm.BarcodeDefaultSolutionCollection;
import com.kingdee.eas.barcode.scm.BarcodeDefaultSolutionFactory;
import com.kingdee.eas.barcode.scm.BarcodeDefaultSolutionInfo;
import com.kingdee.eas.barcode.scm.BarcodeDefaultXMLInfo;
import com.kingdee.eas.barcode.scm.BarcodeDefaultXMLItem;
import com.kingdee.eas.barcode.scm.BarcodeScanningBarcodeInfo;
import com.kingdee.eas.barcode.scm.BarcodeScanningFactory;
import com.kingdee.eas.barcode.scm.BarcodeScanningPropertyInfo;
import com.kingdee.eas.barcode.scm.BarcodeScanningRecodeInfo;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.BarcodeXMLHelper;
import com.kingdee.eas.barcode.scm.IBarcodeScanning;
import com.kingdee.eas.barcode.scm.IScanTaskBill;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetCollection;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetFactory;
import com.kingdee.eas.barcode.scm.ObjectTypeEnum;
import com.kingdee.eas.barcode.scm.OrgUnitUtils;
import com.kingdee.eas.barcode.scm.ScanTaskBillFactory;
import com.kingdee.eas.barcode.scm.ScanTaskBillInfo;
import com.kingdee.eas.barcode.scm.client.AbstractScanTaskBillEditUI;
import com.kingdee.eas.barcode.scm.client.BarcodeAnalysisClientHelper;
import com.kingdee.eas.barcode.scm.client.IBarcodeBillSelectUI;
import com.kingdee.eas.barcode.scm.util.BarcodeClientUtils;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.CodingRuleUtils;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.core.util.EqualsUtil;
import com.kingdee.eas.base.form.ide.utils.EntityObjectInfoHelp;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.config.client.ConfigServiceUtils;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ScanTaskBillEditUI
extends AbstractScanTaskBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ScanTaskBillEditUI.class);
    protected String entryProperty = "";
    private IMetaDataPK mainQueryPK = null;
    public static final String TB_PARENTID = "fparentId";
    public static final String TB_ID = "fid";
    public static final String TB_BOSTYPE = "fbosType";
    public static final String TB_PARENTBOSTYPE = "fparentBosType";
    public static final String TB_SRCQTY = "fsrcQty";
    public static final String TB_DIFQTY = "fdifQty";
    public static final String TB_DIFSPLITQTY = "fdifSplitQty";
    public static final String TB_SPLITQTY = "fsplitQty";
    public static final String TB_SPLITTEDQTY = "fsplittedQty";
    public static final String TB_SRCSCANENTRYID = "fsrcScanEntryId";
    public static final String TB_SRCBILLID = "fsrcBillId";
    public static final String TB_SRCBILLENTRYID = "fsrcEntryId";
    public static final String TB_SEQ = "fseq";
    public static final String TB_DESTBILLID = "fdestBillid";
    public static final String TB_SCANNINGID = "fScanningId";
    public static String seqNoFiled = "sequenceNumber";
    public static final String BC_PARENTID = "parentId";
    public static final String BC_PARENTBOSTYPE = "parentBosType";
    public static final String BC_BARCODE = "barcode";
    public static final String BC_ENTITYALAILS = "entityAlais";
    public static final String BC_ROWNUM = "rowNum";
    public static final String BC_BARCODERULEID = "barcodeRuleId";
    public static final String SEQ_PARENTID = "parentId";
    public static final String SEQ_PARENTBOSTYPE = "parentBosType";
    public static final String SEQ_SEQ = "seq";
    public static final String SEQ_ENTITYALAILS = "entityAlais";
    public static final String SEQ_ROWNUM = "rowNum";
    public BarcodeConfigXML xmlInfo = new BarcodeConfigXML();
    public Map<String, String> parentIdMap = new HashMap<String, String>();
    public boolean isModifyNumber = true;
    public boolean isAddView = true;
    protected KDWorkButton btnRemoveLine = null;
    public String countTaskBosType = "AC301916";
    public String countTableBosType = "D9D2CA5D";
    private BarcodeAnalysisClientHelper barcodeAnalysisClientHelper = new BarcodeAnalysisClientHelper();
    public String barcode = null;
    private String defaultConfigId;
    public String paramValue = "0";
    private List<String> entryBosTypeList = new ArrayList<String>();

    @Override
    public void loadFields() {
        this.initUserConfig();
        if (this.editData.getOrgUnit() != null && OrgType.Storage.equals((Object)this.getMainBizOrgType())) {
            FullOrgUnitInfo fullorgUnitInfo = this.editData.getOrgUnit();
            StorageOrgUnitInfo orgUnitInfo = new StorageOrgUnitInfo();
            orgUnitInfo.setId(fullorgUnitInfo.getId());
            orgUnitInfo.setName(fullorgUnitInfo.getName());
            orgUnitInfo.setNumber(fullorgUnitInfo.getNumber());
            this.prmtorgUnit.setValue((Object)orgUnitInfo);
        }
        super.loadFields();
        ArrayList<BarcodeScanningRecodeInfo> recodesList = new ArrayList();
        try {
            if (!this.oprtState.equals("ADDNEW") && !this.oprtState.equalsIgnoreCase("SPLIT")) {
                BarcodeConfigInfo configInfo = (BarcodeConfigInfo)this.prmtbarcodeConfig.getValue();
                BarcodeConfigXML configXml = BarcodeXMLHelper.toBarcodeConfigXML(configInfo.getDetailsXML());
                this.initDetails(configInfo);
                Object o = ScanTaskBillFactory.getRemoteInstance().getRecodesList(this.editData.getId().toString(), configXml);
                if (o != null) {
                    recodesList = (List)o;
                    this.editData.setScanRecodeList(recodesList);
                    if (this.tblBarcode.getRowCount3() > 0) {
                        this.tblBarcode.removeRows();
                    }
                    if (this.tblSeq.getRowCount3() > 0) {
                        this.tblSeq.removeRows();
                    }
                    this.loadScanRecods(recodesList, null);
                }
            }
            if ("SPLIT".equalsIgnoreCase(this.oprtState)) {
                this.initDetails(this.editData.getBarcodeConfig());
                Map splitMap = (Map)this.getUIContext().get("splitMap");
                List idList = (List)this.getUIContext().get("idList");
                StringBuffer idStr = new StringBuffer();
                int size = idList.size();
                for (int i = 0; i < size; ++i) {
                    if (idStr.length() > 0) {
                        idStr.append(",").append(idList.get(i));
                        continue;
                    }
                    idStr.append(idList.get(i));
                }
                String scanQtyFiled = this.getUIContext().get("scanQtyFiled").toString();
                this.fillTableData(idStr.toString(), splitMap, scanQtyFiled, this.editData.getSrcBosType(), this.editData.getDestBosType(), this.editData.getBotpId(), null, this.editData.getSourceBillNumber());
            }
            if (this.editData.getTaskOperator() != null && this.editData.getTaskOperator().length() > 0) {
                if (this.editData.getTaskObject().equals((Object)ObjectTypeEnum.department)) {
                    this.prmtTaskOperator.setValue((Object)AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.editData.getTaskOperator())));
                }
                if (this.editData.getTaskObject().equals((Object)ObjectTypeEnum.person)) {
                    this.prmtTaskOperator.setValue((Object)PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(this.editData.getTaskOperator())));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handleException(e);
        }
    }

    protected void loadScanRecods(List<BarcodeScanningRecodeInfo> recodesList, String entryName) {
        for (int j = 0; j < this.kdtpEntry.getTabCount(); ++j) {
            KDTable table = (KDTable)this.kdtpEntry.getComponentAt(j);
            String tblName = table.getName();
            if ((tblName != null || entryName != null) && (tblName == null || entryName == null || !tblName.substring(tblName.lastIndexOf(".") + 1).equals(entryName))) continue;
            List<Object> childRecodsList = new ArrayList();
            String key = null;
            if (this.isValueNull(tblName) && table.getRowCount3() > 0) {
                table.removeRows();
            }
            if (recodesList.size() > 0) {
                this.parentIdMap.put(recodesList.get(recodesList.size() - 1).getFbosType(), recodesList.get(0).getFid());
            }
            EntityObjectInfo entity = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)this.getBosType(table, TB_BOSTYPE)));
            int startIndex = table.getRowCount3();
            for (int i = 0; i < recodesList.size(); ++i) {
                Map<String, List<BarcodeScanningRecodeInfo>> entryMap;
                IRow row = table.addRow(i + startIndex);
                BarcodeScanningRecodeInfo recodeInfo = recodesList.get(i);
                int rowNum = i + 1;
                String entityAlais = recodeInfo.getFentityAlias();
                Map<String, BarcodeScanningPropertyInfo> properties = recodeInfo.getProperties();
                for (int k = 0; k < table.getColumnCount(); ++k) {
                    String filed = table.getColumnKey(k);
                    BarcodeScanningPropertyInfo propertyInfo = properties.get(filed);
                    PropertyInfo property = entity.getPropertyByName(filed);
                    if (property != null) {
                        BarcodeClientUtils.setSingleCellValue(row.getCell(filed), property, propertyInfo.getValue() == null ? null : propertyInfo.getValue().toString());
                        continue;
                    }
                    row.getCell(filed).setValue(propertyInfo == null ? null : propertyInfo.getValue());
                }
                this.loadBarcodeAndSeq(recodeInfo, rowNum, entityAlais);
                if (!this.isCountTableForDestBosType()) {
                    this.mergAfterLoad(table);
                }
                if ((entryMap = recodeInfo.getEntriesMap()) == null || entryMap.size() <= 0) continue;
                Object[] keys = entryMap.keySet().toArray();
                for (int m = 0; m < keys.length; ++m) {
                    key = keys[m].toString();
                    childRecodsList = entryMap.get(key);
                    if (childRecodsList.size() <= 0) continue;
                    this.loadScanRecods(childRecodsList, key);
                }
            }
        }
    }

    protected void loadBarcodeAndSeq(BarcodeScanningRecodeInfo recodeInfo, int rowNum, String entityAlais) {
        List<BarcodeScanningBarcodeInfo> barcodeList = recodeInfo.getBarcodeList();
        for (int k = 0; k < barcodeList.size(); ++k) {
            IRow bRow = this.tblBarcode.addRow();
            BarcodeScanningBarcodeInfo bsbi = barcodeList.get(k);
            bRow.getCell(BC_BARCODE).setValue((Object)bsbi.getBarcode());
            bRow.getCell(BC_BARCODERULEID).setValue((Object)bsbi.getBarcodeRuleId());
            bRow.getCell("parentBosType").setValue((Object)recodeInfo.getFbosType());
            bRow.getCell("parentId").setValue((Object)recodeInfo.getFid());
            bRow.getCell("entityAlais").setValue((Object)entityAlais);
            bRow.getCell("rowNum").setValue((Object)rowNum);
        }
    }

    protected void mergAfterLoad(KDTable table) {
        String scanQty = this.getScanOrSrcQtyFiled(table, false, true);
        String mergRowParentIds = "";
        if (TB_SRCQTY != null && scanQty != null) {
            IRow row;
            Object value;
            for (int f = 0; f < table.getRowCount3() && (value = (row = table.getRow(f)).getCell(TB_SRCBILLENTRYID).getValue()) != null; ++f) {
                String srcEtryId = value.toString();
                String fparentId = row.getCell(TB_PARENTID).getValue().toString();
                if (mergRowParentIds.equals(srcEtryId)) continue;
                int count = 0;
                for (int m = 0; m < table.getRowCount3(); ++m) {
                    if (m == f) continue;
                    String srcEid = table.getRow(m).getCell(TB_SRCBILLENTRYID).getValue().toString();
                    String pId = table.getRow(m).getCell(TB_PARENTID).getValue().toString();
                    if (!srcEtryId.equals(srcEid) || !fparentId.equals(pId)) continue;
                    ++count;
                }
                if (count <= 0) continue;
                table.getMergeManager().mergeBlock(f, table.getColumnIndex(TB_SRCQTY), f + count, table.getColumnIndex(TB_SRCQTY));
                table.getMergeManager().mergeBlock(f, table.getColumnIndex(TB_DIFQTY), f + count, table.getColumnIndex(TB_DIFQTY));
                mergRowParentIds = mergRowParentIds + srcEtryId;
            }
        }
    }

    @Override
    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        Map rsMap = ScanTaskBillFactory.getRemoteInstance().exportData(this.editData.getId().toString(), null);
        Iterator it = rsMap.keySet().iterator();
        Object messeage = null;
        while (it.hasNext()) {
            String key = it.next().toString();
            if (!"message".equals(key)) continue;
            messeage = rsMap.get(key);
        }
        if (messeage != null) {
            MsgBox.showInfo((Component)((Object)this), (String)messeage.toString());
        }
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        KDTable table = (KDTable)this.kdtpEntry.getSelectedComponent();
        this.removeLine(table);
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            String bosType = this.getBosType(table, TB_BOSTYPE);
            List<KDTable> list = this.getChildTable(bosType);
            block2: for (int i = indexArr.length - 1; i >= 0; --i) {
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                String id = table.getRow(rowIndex).getCell(TB_ID).getValue().toString();
                this.removeRows(table, list, id);
                this.removeBarcodeRows(id, bosType);
                this.removeSeqRows(id, bosType);
                String scanFiled = this.getScanOrSrcQtyFiled(table, false, true);
                if (!this.isValueNull(scanFiled)) {
                    BigDecimal scanQty;
                    KDTMergeBlock merg = this.getMergeBolck(table, rowIndex);
                    Object scanValue = table.getRow(rowIndex).getCell(scanFiled).getValue();
                    BigDecimal bigDecimal = scanQty = this.isValueNull(scanValue) ? new BigDecimal("0") : new BigDecimal("-" + scanValue.toString());
                    if (merg != null && scanQty.compareTo(new BigDecimal("0")) != 0) {
                        scanQty = new BigDecimal("0");
                        this.cumSumQty(null, table, table.getRow(rowIndex), scanQty);
                        this.calculateDifQty(table, table.getRow(rowIndex), merg, null);
                    }
                }
                table.removeRow(rowIndex);
                if (table.getRow(rowIndex) == null || table.getRow(rowIndex).getCell(TB_DESTBILLID).getValue() == null) continue;
                String fdestBillid = table.getRow(rowIndex).getCell(TB_DESTBILLID).getValue().toString();
                for (int j = 0; j < this.tblBill.getRowCount(); ++j) {
                    Object value = this.tblBill.getRow(j).getCell("sourceBillEntryId").getValue();
                    if (value == null || !value.toString().equals(fdestBillid)) continue;
                    this.tblBill.removeRow(j);
                    continue block2;
                }
            }
            table.getSelectManager().remove();
        }
    }

    protected List<KDTable> getChildTable(String bosType) {
        ArrayList<KDTable> list = new ArrayList<KDTable>();
        for (int j = 0; j < this.kdtpEntry.getTabCount(); ++j) {
            KDTable cldTable = (KDTable)this.kdtpEntry.getComponentAt(j);
            String pBosType = this.getBosType(cldTable, TB_PARENTBOSTYPE);
            if (pBosType == null || !pBosType.equals(bosType)) continue;
            list.add(cldTable);
        }
        return list;
    }

    protected void removeRows(KDTable table, List<KDTable> childTableList, String id) {
        if (childTableList != null && childTableList.size() > 0) {
            for (int i = 0; i < childTableList.size(); ++i) {
                KDTable childTable = childTableList.get(i);
                for (int j = childTable.getRowCount3() - 1; j >= 0; --j) {
                    String parentId = childTable.getRow(j).getCell(TB_PARENTID).getValue().toString();
                    if (!parentId.equals(id)) continue;
                    String childId = childTable.getRow(j).getCell(TB_ID).getValue().toString();
                    List<KDTable> cldTableList = this.getChildTable(this.getBosType(childTable, TB_BOSTYPE));
                    this.removeRows(childTable, cldTableList, childId);
                    childTable.removeRow(j);
                }
            }
        }
    }

    protected void removeBarcodeRows(String id, String bosType) {
        int size = this.tblBarcode.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow barcodeRow = this.tblBarcode.getRow(i);
            if (barcodeRow == null || barcodeRow.getCell("parentId").getValue() == null || barcodeRow.getCell("parentBosType").getValue() == null) continue;
            String parentID = barcodeRow.getCell("parentId").getValue().toString();
            String parentBosType = barcodeRow.getCell("parentBosType").getValue().toString();
            if (!parentID.equals(id) || !parentBosType.equals(bosType)) continue;
            this.tblBarcode.removeRow(i);
        }
    }

    protected void removeSeqRows(String id, String bosType) {
        int size = this.tblSeq.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow barcodeRow = this.tblSeq.getRow(i);
            if (barcodeRow.getCell("parentId").getValue() == null || barcodeRow.getCell("parentId").getValue() == null) continue;
            String parentID = barcodeRow.getCell("parentBosType").getValue().toString();
            String parentBosType = barcodeRow.getCell("parentBosType").getValue().toString();
            if (!parentID.equals(id) || !parentBosType.equals(bosType)) continue;
            this.tblSeq.removeRow(i);
        }
    }

    @Override
    public void storeFields() {
        List<BarcodeScanningRecodeInfo> list = this.editData.getScanRecodeList();
        for (int i = 0; i < this.kdtpEntry.getTabCount(); ++i) {
            KDTable table = (KDTable)this.kdtpEntry.getComponentAt(i);
            String parentBosType = this.getBosType(table, TB_PARENTBOSTYPE);
            String entityName = this.getEntityName(table);
            String entityAlias = this.kdtpEntry.getTitleAt(i);
            if (!parentBosType.equals(new ScanTaskBillInfo().getBOSType().toString()) || (list = this.crateRecodeList(table, this.editData.getId() == null ? "" : this.editData.getId().toString(), list)).size() <= 0) continue;
            for (int j = 0; j < list.size(); ++j) {
                BarcodeScanningRecodeInfo info = list.get(j);
                info.setFentityName(entityName);
                info.setFentityAlias(entityAlias);
            }
        }
        if (list != null && list.size() > 0) {
            this.editData.setScanRecodeList(list);
        }
        if (this.prmtTaskOperator.getValue() == null) {
            this.editData.setTaskOperator(null);
        } else {
            if (this.prmtTaskOperator.getData() instanceof AdminOrgUnitInfo) {
                AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)this.prmtTaskOperator.getData();
                this.editData.setTaskOperator(adminInfo.getId().toString());
            }
            if (this.prmtTaskOperator.getData() instanceof PersonInfo) {
                PersonInfo personInfo = (PersonInfo)this.prmtTaskOperator.getData();
                this.editData.setTaskOperator(personInfo.getId().toString());
            }
        }
        if (this.prmtorgUnit.getValue() != null) {
            StorageOrgUnitInfo orgUnitInfo = (StorageOrgUnitInfo)this.prmtorgUnit.getValue();
            FullOrgUnitInfo fullOrgInfo = new FullOrgUnitInfo();
            fullOrgInfo.setId(orgUnitInfo.getId());
            this.editData.setOrgUnit(fullOrgInfo);
        }
        super.storeFields();
    }

    protected List<BarcodeScanningRecodeInfo> crateRecodeList(KDTable table, String parentId, List<BarcodeScanningRecodeInfo> list) {
        ArrayList<BarcodeScanningRecodeInfo> listNew = new ArrayList<BarcodeScanningRecodeInfo>();
        String bosType = this.getBosType(table, TB_BOSTYPE);
        EntityObjectInfo entity = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)this.getBosType(table, TB_BOSTYPE)));
        for (int j = 0; j < table.getRowCount3(); ++j) {
            IRow row = table.getRow(j);
            BarcodeScanningRecodeInfo info = this.setPropertyValue(table, row, parentId, entity);
            Map<String, List<BarcodeScanningRecodeInfo>> entryMap = this.createEntryMap(row, bosType);
            info.setEntriesMap(entryMap);
            info.setBarcodeList(this.createBarcodeList(info.getFid()));
            info.setSeqNoList(this.createSeqList(info.getFid()));
            listNew.add(info);
        }
        return listNew;
    }

    protected List<String> createSeqList(String id) {
        ArrayList<String> seqNoList = new ArrayList<String>();
        for (int i = 0; i < this.tblSeq.getRowCount3(); ++i) {
            IRow row = this.tblSeq.getRow(i);
            String parentId = row.getCell("parentId").getValue().toString();
            if (!id.equals(parentId)) continue;
            seqNoList.add(row.getCell(SEQ_SEQ).getValue().toString());
        }
        return seqNoList;
    }

    protected Map<String, List<BarcodeScanningRecodeInfo>> createEntryMap(IRow row, String bosType) {
        LinkedHashMap<String, List<BarcodeScanningRecodeInfo>> entriesMap = new LinkedHashMap<String, List<BarcodeScanningRecodeInfo>>();
        String id = row.getCell(TB_ID).getValue().toString();
        for (int i = 0; i < this.kdtpEntry.getTabCount(); ++i) {
            KDTable table = (KDTable)this.kdtpEntry.getComponentAt(i);
            String parentBosType = this.getBosType(table, TB_PARENTBOSTYPE);
            String childBosType = this.getBosType(table, TB_BOSTYPE);
            String entityName = this.getEntityName(table);
            String entityAlias = this.kdtpEntry.getTitleAt(i);
            if (!parentBosType.equals(bosType)) continue;
            ArrayList<BarcodeScanningRecodeInfo> childList = new ArrayList<BarcodeScanningRecodeInfo>();
            EntityObjectInfo entity = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)childBosType));
            for (int j = 0; j < table.getRowCount3(); ++j) {
                IRow childRow = table.getRow(j);
                String parentId = childRow.getCell(TB_PARENTID).getValue().toString();
                if (!parentId.equals(id)) continue;
                Object prtId = childRow.getCell(TB_PARENTID).getValue();
                BarcodeScanningRecodeInfo childInfo = this.setPropertyValue(table, childRow, prtId == null ? null : prtId.toString(), entity);
                childInfo.setBarcodeList(this.createBarcodeList(childInfo.getFid()));
                childInfo.setSeqNoList(this.createSeqList(childInfo.getFid()));
                childInfo.setFentityName(entityName);
                childInfo.setFentityAlias(entityAlias);
                childList.add(childInfo);
                Map<String, List<BarcodeScanningRecodeInfo>> childEntryMap = this.createEntryMap(childRow, childBosType);
                if (childEntryMap.size() <= 0) continue;
                childInfo.setEntriesMap(childEntryMap);
            }
            entriesMap.put(table.getName().substring(table.getName().lastIndexOf(".") + 1), childList);
        }
        return entriesMap;
    }

    protected List<BarcodeScanningBarcodeInfo> createBarcodeList(String id) {
        ArrayList<BarcodeScanningBarcodeInfo> barcodeList = new ArrayList<BarcodeScanningBarcodeInfo>();
        for (int i = 0; i < this.tblBarcode.getRowCount3(); ++i) {
            IRow row = this.tblBarcode.getRow(i);
            String parentId = row.getCell("parentId").getValue().toString();
            if (!id.equals(parentId)) continue;
            BarcodeScanningBarcodeInfo bsbi = new BarcodeScanningBarcodeInfo();
            if (row.getCell(BC_BARCODE).getValue() == null) continue;
            bsbi.setBarcode(row.getCell(BC_BARCODE).getValue().toString());
            if (row.getCell(BC_BARCODERULEID) != null && row.getCell(BC_BARCODERULEID).getValue() != null) {
                bsbi.setBarcodeRuleId(row.getCell(BC_BARCODERULEID).getValue().toString());
            }
            barcodeList.add(bsbi);
        }
        return barcodeList;
    }

    protected BarcodeConfigXMLProperty getXmlPropertyByKey(String filed, String bosType) {
        int index = filed.indexOf("f");
        filed = index == 0 ? filed.substring(index + 1) : filed;
        for (int i = 0; i < this.xmlInfo.getDetails().size(); ++i) {
            if (!this.xmlInfo.getDetails().get(i).getBosType().equals(bosType)) continue;
            BarcodeConfigXMLDetail detailXml = this.xmlInfo.getDetails().get(i);
            for (int j = 0; j < detailXml.getProperties().size(); ++j) {
                BarcodeConfigXMLProperty xmlProperty = detailXml.getProperties().get(j);
                if (xmlProperty.getName().equals(filed)) {
                    return xmlProperty;
                }
                if (xmlProperty.getName().equals(filed) || j != detailXml.getProperties().size() - 1) continue;
                return null;
            }
        }
        return null;
    }

    protected String getEntityName(KDTable table) {
        for (int i = 0; i < this.xmlInfo.getDetails().size(); ++i) {
            BarcodeConfigXMLDetail xmlDetail = this.xmlInfo.getDetails().get(i);
            if ((xmlDetail.getFullName() != null || xmlDetail.getFullName() != table.getName()) && (xmlDetail.getFullName() == null || !xmlDetail.getFullName().equals(table.getName()))) continue;
            return xmlDetail.getEntityName();
        }
        return null;
    }

    protected BarcodeScanningRecodeInfo setPropertyValue(KDTable table, IRow childRow, String parentId, EntityObjectInfo entity) {
        BarcodeScanningRecodeInfo childInfo = new BarcodeScanningRecodeInfo();
        TreeMap<String, BarcodeScanningPropertyInfo> map = new TreeMap<String, BarcodeScanningPropertyInfo>();
        String childId = childRow.getCell(TB_ID).getValue().toString();
        String bosType = this.getBosType(table, TB_BOSTYPE);
        String parentBosType = this.getBosType(table, TB_PARENTBOSTYPE);
        childInfo.setFid(childId);
        childInfo.setFparentId(parentId);
        childInfo.setFbosType(bosType);
        if (parentBosType == null) {
            parentBosType = new ScanTaskBillInfo().getBOSType().toString();
        }
        childInfo.setFparentBosType(parentBosType);
        Object srcBillId = childRow.getCell(TB_SRCBILLID).getValue();
        childInfo.setFsrcBillId(srcBillId == null ? null : srcBillId.toString());
        Object srcBillEntryId = childRow.getCell(TB_SRCBILLENTRYID).getValue();
        childInfo.setFsrcEntryId(srcBillEntryId == null ? null : srcBillEntryId.toString());
        for (int k = 0; k < table.getColumnCount(); ++k) {
            Object cellValue;
            BarcodeScanningPropertyInfo proInfo;
            String key = table.getColumnKey(k);
            PropertyInfo property = entity.getPropertyByName(key);
            if (property != null) {
                proInfo = new BarcodeScanningPropertyInfo();
                proInfo.setKey(key);
                cellValue = BarcodeClientUtils.getSingleCellValue(childRow.getCell(key), property);
                String dataType = property.getString("dataType");
                if (dataType.equals("Date")) {
                    proInfo.setValue(cellValue == null ? null : java.sql.Date.valueOf(cellValue.toString()));
                } else if (dataType.equals("TimeStamp")) {
                    Object timeValue = childRow.getCell(key).getValue();
                    proInfo.setValue(timeValue == null ? null : Timestamp.valueOf(cellValue.toString()));
                } else {
                    proInfo.setValue(cellValue);
                }
                map.put(key, proInfo);
                continue;
            }
            if (key.indexOf("_") != -1) {
                proInfo = new BarcodeScanningPropertyInfo();
                proInfo.setKey(key);
                cellValue = childRow.getCell(k).getValue();
                if (cellValue instanceof IObjectValue) {
                    proInfo.setValue(((IObjectValue)cellValue).get("number"));
                } else {
                    proInfo.setValue(cellValue);
                }
                map.put(key, proInfo);
                proInfo = new BarcodeScanningPropertyInfo();
                String nameKey = key.substring(0, key.indexOf("_")) + "_name";
                proInfo.setKey(nameKey);
                proInfo.setValue(childRow.getCell(++k).getValue());
                map.put(nameKey, proInfo);
                continue;
            }
            proInfo = new BarcodeScanningPropertyInfo();
            proInfo.setKey(key);
            Object value = childRow.getCell(k).getValue();
            if (value instanceof BigDecimal) {
                if (value != null) {
                    if (BigDecimal.ZERO.compareTo(new BigDecimal(value.toString())) == 0) {
                        value = BigDecimal.ZERO;
                    }
                } else {
                    value = BigDecimal.ZERO;
                }
            }
            if ("0E-14".equals(value)) {
                value = BigDecimal.ZERO;
            }
            proInfo.setValue(value);
            map.put(key, proInfo);
        }
        if (!parentId.equals("")) {
            ((BarcodeScanningPropertyInfo)map.get(TB_PARENTID)).setValue(parentId);
        }
        BarcodeScanningPropertyInfo proInfo = new BarcodeScanningPropertyInfo();
        proInfo.setKey(TB_SEQ);
        proInfo.setValue(childRow.getRowIndex());
        map.put(TB_SEQ, proInfo);
        proInfo = new BarcodeScanningPropertyInfo();
        proInfo.setKey(TB_SCANNINGID);
        proInfo.setValue(this.editData.getId().toString());
        map.put(TB_SCANNINGID, proInfo);
        childInfo.setProperties(map);
        return childInfo;
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.clearAll();
        this.setEnableOrUnEnable(true);
        this.setTableIsEnable(true);
    }

    protected void setEnableOrUnEnable(boolean isEnable) {
        this.prmtbarcodeConfig.setEnabled(isEnable);
        if (this.isModifyNumber) {
            this.txtNumber.setEnabled(isEnable);
        }
    }

    protected void clearAll() {
        this.kdtpEntry.removeAll();
        this.tblBarcode.removeRows();
        this.tblSeq.removeRows();
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setTableIsEnable(true);
    }

    protected void setTableIsEnable(boolean isEanble) {
        for (int i = 0; i < this.kdtpEntry.getTabCount(); ++i) {
            KDTable table = (KDTable)this.kdtpEntry.getComponentAt(i);
            table.setEnabled(isEanble);
        }
        this.btnRemoveLine.setEnabled(isEanble);
    }

    @Override
    protected void removeByPK(IObjectPK pk) throws Exception {
        this.clearAll();
        for (int i = 0; i < this.kdtpEntry.getTabCount(); ++i) {
            KDTable table = (KDTable)this.kdtpEntry.getComponentAt(i);
            table.removeRows();
        }
        super.removeByPK(pk);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void registerCustomerBindings() {
        super.registerCustomerBindings();
        EQMPromptDialogFactory.createPrmptOrgDialog(this.prmtorgUnit, null, false, this.getMainBizOrgType(), true, false);
        ObjectTypeEnum objectTypeEnum = (ObjectTypeEnum)((Object)this.taskObject.getSelectedItem());
        if (ObjectTypeEnum.department.equals((Object)objectTypeEnum)) {
            this.prmtTaskOperator.setQueryInfo("com.kingdee.eas.sem.mp.app.AdminOrgUnitF7");
            this.prmtTaskOperator.setDisplayFormat("$name$");
            this.prmtTaskOperator.setEditFormat("$number$");
            this.prmtTaskOperator.setCommitFormat("$number$");
            this.prmtTaskOperator.setEditable(true);
            this.prmtTaskOperator.setRequired(true);
        }
        if (ObjectTypeEnum.person.equals((Object)objectTypeEnum)) {
            this.prmtTaskOperator.setDisplayFormat("$name$");
            this.prmtTaskOperator.setEditFormat("$number$");
            this.prmtTaskOperator.setCommitFormat("$number$");
            this.prmtTaskOperator.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
            this.prmtTaskOperator.setEditable(true);
        }
    }

    @Override
    public void onLoad() throws Exception {
        this.getCodingRuleStatus();
        this.initUICompont();
        super.onLoad();
        this.hideCompont();
        this.initBarcodeConfig();
        this.prmtbarcodeConfig.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                try {
                    ScanTaskBillEditUI.this.configNamePreChange(e);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    ScanTaskBillEditUI.this.handleException(e1);
                }
            }
        });
        this.prmtbarcodeConfig.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    ScanTaskBillEditUI.this.pconfigNameChange(e);
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                    ScanTaskBillEditUI.this.handleException((Exception)((Object)e1));
                }
            }
        });
        IndubarodeParamsetCollection paramCol = IndubarodeParamsetFactory.getRemoteInstance().getIndubarodeParamsetCollection();
        if (paramCol != null && paramCol.get(0) != null) {
            if (paramCol.get(0).isBusinessBarcode()) {
                this.paramValue = "0";
            } else if (paramCol.get(0).isIndBarcode()) {
                this.paramValue = "1";
            } else if (paramCol.get(0).isPriorBusiness()) {
                this.paramValue = "2";
            } else if (paramCol.get(0).isPriorInd()) {
                this.paramValue = "3";
            }
        }
        this.btnExportData.setEnabled(true);
        this.prmttransactionType.setRequired(true);
    }

    protected void initBarcodeConfig() throws EASBizException, BOSException {
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        this.defaultConfigId = ConfigServiceUtils.getUserConfigData((String)"defaultBarcodeConfig", (CoreUI)this);
        OrgUnitCollection coll = OrgUnitUtils.getAuthOrgByPermItem(null, OrgType.ControlUnit, "barcodeScan_view");
        String permissionCuStr = OrgUnitUtils.toStringList(coll, "number");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cu.number", (Object)permissionCuStr, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtbarcodeConfig.setEntityViewInfo(view);
        if (this.prmtbarcodeConfig.getValue() == null && this.defaultConfigId != null && !"null".equalsIgnoreCase(this.defaultConfigId)) {
            try {
                BarcodeConfigInfo defaultConfigInfo = BarcodeConfigFactory.getRemoteInstance().getBarcodeConfigInfo("where id='" + this.defaultConfigId + "' and cu.id='" + cu.getId().toString() + "'");
                if (defaultConfigInfo != null) {
                    this.prmtbarcodeConfig.setValue((Object)defaultConfigInfo);
                    PreChangeEvent e = new PreChangeEvent((Object)this.prmtbarcodeConfig);
                    e.setData(this.prmtbarcodeConfig.getValue());
                    this.configNamePreChange(e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("storeType.storeFlag"));
        sic.add(new SelectorItemInfo("storeTypePre.storeFlag"));
        sic.add(new SelectorItemInfo("riType.bizDirection"));
        this.prmttransactionType.setSelectorCollection(sic);
        this.txtSrcNumber.setEnabled(false);
        this.prmtorgUnit.setRequired(true);
    }

    protected void hideCompont() {
        this.prmtCreator.setEnabled(false);
        this.prmtLastUpdateUser.setEnabled(false);
        this.btnCopy.setVisible(false);
        this.prmtbarcodeConfig.setHistoryRecordEnabled(false);
        this.menuSubmitOption.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.menuBiz.setVisible(false);
        this.menuItemCopy.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
    }

    protected void pconfigNameChange(ChangeEvent e) throws BOSException {
    }

    protected void getCodingRuleStatus() throws BOSException, EASBizException, CodingRuleException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        this.editData = new ScanTaskBillInfo();
        RuleStatus rStatus = iCodingRuleManager.getRuleStatus((IObjectValue)this.editData, SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        if (rStatus.isExist()) {
            if (!rStatus.isModifiable()) {
                this.isModifyNumber = false;
                this.txtNumber.setEnabled(false);
            }
            if (!rStatus.isAddView()) {
                this.isAddView = false;
            }
        }
    }

    protected void initUICompont() {
        this.actionRemoveLine.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnRemoveLine = (KDWorkButton)this.kDContainer1.add((Action)this.actionRemoveLine);
        this.btnRemoveLine.setText(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"149_BarcodeScanningEditUI"));
        this.btnRemoveLine.setSize(new Dimension(22, 19));
        this.btnRemoveLine.setEnabled(true);
        this.btnSave.setVisible(false);
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        KeyStroke enter = KeyStroke.getKeyStroke("ENTER");
        this.kdtChirdEntry_detailPanel.setTitle("\u5b50\u4efb\u52a1\u5206\u5f55");
        this.kdtChirdEntry_detailPanel.setToolTipText("\u5b50\u4efb\u52a1\u5206\u5f55");
        this.kdtChirdEntry_detailPanel.getAddNewLineButton().setVisible(false);
        this.kdtChirdEntry_detailPanel.getInsertLineButton().setVisible(false);
    }

    protected void configNamePreChange(PreChangeEvent e) throws EASBizException, BOSException {
        int result;
        if (EqualsUtil.equals((Object)e.getData(), (Object)e.getOldData())) {
            return;
        }
        if (this.kdtpEntry.getTabCount() > 0 && ((result = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"134_BarcodeScanningEditUI"))) == 1 || result == 2)) {
            e.setResult(0);
            return;
        }
        this.clearByChangeConfig();
        if (e.getData() == null) {
            return;
        }
        BarcodeConfigInfo info = (BarcodeConfigInfo)e.getData();
        if (this.txtNumber.getText() == null) {
            this.txtNumber.setText(this.getNumberByCoding(this.editData));
        }
        this.editData.setId(BOSUuid.create((BOSObjectType)new ScanTaskBillInfo().getBOSType()));
        this.editData.setCU(info.getCU());
        if (info.getSrcBosType() != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("name");
            sic.add("id");
            BOTMappingInfo botInfo = BOTMappingFactory.getRemoteInstance().getBOTMappingInfo((IObjectPK)new ObjectUuidPK(info.getBotMapping().getId()), sic);
            this.txtbotpNumber.setText(botInfo.getName());
            this.txtbotpId.setText(botInfo.getId().toString());
            this.txtsrcBosType.setText(info.getSrcBosType());
            this.txtbilltype.setText(botInfo.getDestEntityAlias());
        } else {
            this.txtbotpNumber.setText(null);
            this.txtbotpId.setText(null);
            this.txtsrcBosType.setText(null);
            this.txtbilltype.setText(null);
        }
        this.txtdestBosType.setText(info.getDestBosType().toString());
        this.initDetails(info);
    }

    protected void initDetails(BarcodeConfigInfo configInfo) {
        this.kdtpEntry.removeAll();
        this.entryBosTypeList.clear();
        String o = configInfo.getDetailsXML();
        if (o != null) {
            String detailsXml = o;
            this.xmlInfo = BarcodeXMLHelper.toBarcodeConfigXML(detailsXml);
            for (int i = 0; i < this.xmlInfo.getDetails().size(); ++i) {
                BarcodeConfigXMLDetail detail = this.xmlInfo.getDetails().get(i);
                KDTable table = this.initTable(detail);
                this.kdtpEntry.addTab(detail.getEntityAlias(), (Component)table);
                if (detail.getParentBosType() != null) {
                    this.entryBosTypeList.add(detail.getBosType());
                }
                table.addKDTEditListener(new KDTEditListener(){

                    public void editValueChanged(KDTEditEvent e) {
                    }

                    public void editStopping(KDTEditEvent e) {
                    }

                    public void editStopped(KDTEditEvent e) {
                        ScanTaskBillEditUI.this.editStoped(e);
                    }

                    public void editStarting(KDTEditEvent e) {
                    }

                    public void editStarted(KDTEditEvent e) {
                    }

                    public void editCanceled(KDTEditEvent e) {
                    }
                });
                table.addKeyListener(new KeyListener(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                    }

                    @Override
                    public void keyReleased(KeyEvent e) {
                        ScanTaskBillEditUI.this.tableKeyReleased(e);
                    }

                    @Override
                    public void keyPressed(KeyEvent e) {
                    }
                });
                if (detail.getParentBosType() == null && this.isValueNull(this.txtsrcBosType.getText()) && this.oprtState.equals("VIEW")) continue;
            }
        }
    }

    protected KDTable initTable(BarcodeConfigXMLDetail detail) {
        KDTable table = new KDTable();
        table.setName(detail.getFullName());
        ArrayList<String> aliasList = new ArrayList<String>();
        this.initPropertyColumns(detail, table, aliasList);
        this.addSrcAndDifQtyColumn(table, aliasList);
        table.addColumn().setKey(TB_SRCBILLID);
        table.getColumn(TB_SRCBILLID).getStyleAttributes().setHided(true);
        aliasList.add(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"135_BarcodeScanningEditUI"));
        table.addColumn().setKey(TB_SRCBILLENTRYID);
        table.getColumn(TB_SRCBILLENTRYID).getStyleAttributes().setHided(true);
        aliasList.add(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"136_BarcodeScanningEditUI"));
        table.addColumn().setKey(TB_DESTBILLID);
        table.getColumn(TB_DESTBILLID).getStyleAttributes().setHided(true);
        aliasList.add(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"137_BarcodeScanningEditUI"));
        table.addColumn().setKey(TB_PARENTID);
        table.getColumn(TB_PARENTID).getStyleAttributes().setHided(true);
        aliasList.add(TB_PARENTID);
        table.addColumn().setKey(TB_ID);
        table.getColumn(TB_ID).getStyleAttributes().setHided(true);
        aliasList.add(TB_ID);
        table.addColumn().setKey(TB_SRCSCANENTRYID);
        table.getColumn(TB_SRCSCANENTRYID).getStyleAttributes().setHided(true);
        aliasList.add(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)TB_SRCSCANENTRYID));
        IRow headRow = table.addHeadRow(0);
        for (int i = 0; i < aliasList.size(); ++i) {
            headRow.getCell(i).setValue(aliasList.get(i));
        }
        table.getColumn(TB_SPLITQTY).getStyleAttributes().setLocked(false);
        return table;
    }

    protected void clearByChangeConfig() {
        this.kdtpEntry.removeAll();
        this.prmtLastUpdateUser.setValue(null);
        this.prmtCreator.setValue(null);
        this.kDDateCreateTime.setValue(null);
        this.kDDateLastUpdateTime.setValue(null);
        this.txtSrcNumber.setText(null);
    }

    protected void editStoped(KDTEditEvent e) {
        String key;
        KDTable table = (KDTable)e.getSource();
        int rowIndex = e.getRowIndex();
        IRow row = table.getRow(rowIndex);
        String colName = table.getColumnKey(e.getColIndex());
        String scanQtyFiled = this.getScanOrSrcQtyFiled(table, false, true);
        if (!this.isValueNull(scanQtyFiled) && colName.equals(scanQtyFiled)) {
            Object scanO = row.getCell(scanQtyFiled).getValue();
            scanO = this.isValueNull(scanO) ? "0" : scanO;
            this.isNumberFormt(scanO.toString());
            BigDecimal scanQty = new BigDecimal(scanO.toString());
            this.cumSumQty(null, table, row, scanQty);
            this.calculateDifQty(table, row, this.getMergeBolck(table, rowIndex), null);
        }
        if (colName.equals(TB_SPLITQTY)) {
            Object splitQtyO = row.getCell(colName).getValue();
            splitQtyO = this.isValueNull(splitQtyO) ? "0" : splitQtyO;
            this.isNumberFormt(splitQtyO.toString());
            BigDecimal splitQty = new BigDecimal(splitQtyO.toString());
            if (row.getCell(TB_DIFQTY) != null && row.getCell(TB_DIFQTY).getValue() != null) {
                BigDecimal difQty = new BigDecimal(row.getCell(TB_DIFQTY).getValue().toString());
                row.getCell(TB_DIFSPLITQTY).getStyleAttributes().setNumberFormat("0.00000000");
                BigDecimal newDifSplitQty = difQty.subtract(splitQty);
                if (newDifSplitQty.compareTo(BigDecimal.ZERO) >= 0) {
                    row.getCell(TB_DIFSPLITQTY).setValue((Object)newDifSplitQty);
                } else {
                    row.getCell(TB_SPLITQTY).setValue((Object)BigDecimal.ZERO);
                }
            }
        }
        if (colName.indexOf("_") != -1 && this.isReferProperty(table, key = colName.substring(0, colName.indexOf("_")))) {
            IObjectValue value;
            Object valueO = row.getCell(colName).getValue();
            if (valueO == null) {
                row.getCell(key + "_name").setValue(null);
            }
            if (valueO instanceof IObjectValue && (value = (IObjectValue)row.getCell(colName).getValue()) != null) {
                row.getCell(key + "_name").setValue(value.get("name"));
            }
        }
    }

    protected boolean isReferProperty(KDTable table, String key) {
        for (int i = 0; i < this.xmlInfo.getDetails().size(); ++i) {
            BarcodeConfigXMLDetail xmlDetail = this.xmlInfo.getDetails().get(i);
            String fullName = xmlDetail.getFullName();
            String tblName = table.getName();
            if ((tblName != null || fullName != null) && (tblName == null || fullName == null || !tblName.equals(fullName))) continue;
            for (int j = 0; j < xmlDetail.getProperties().size(); ++j) {
                BarcodeConfigXMLProperty property = xmlDetail.getProperties().get(j);
                if (!property.isRefer() || !property.getName().equals(key)) continue;
                return true;
            }
        }
        return false;
    }

    protected void calculateDifQty(KDTable table, IRow row, KDTMergeBlock merg, List<BarcodeAnalysisResultItem> items) {
        BigDecimal srcQty;
        String scanFiled = this.getScanOrSrcQtyFiled(table, false, true);
        BigDecimal scanQty = new BigDecimal("0");
        BigDecimal diffQty = new BigDecimal("0");
        Object srcQtyO = row.getCell(TB_SRCQTY).getValue();
        BigDecimal bigDecimal = srcQty = this.isValueNull(srcQtyO) ? new BigDecimal("0") : new BigDecimal(srcQtyO.toString());
        if (merg != null) {
            int x;
            int beginRowIdx = merg.getTop();
            int endRowIdx = merg.getBottom();
            for (x = beginRowIdx; x <= endRowIdx; ++x) {
                scanQty = scanQty.add(new BigDecimal(table.getRow(x).getCell(scanFiled).getValue().toString()));
            }
            diffQty = srcQty.subtract(scanQty);
            for (x = beginRowIdx; x <= endRowIdx; ++x) {
                table.getRow(x).getCell(TB_DIFQTY).setValue((Object)diffQty);
            }
        } else {
            Object scanQtyO = row.getCell(scanFiled).getValue();
            scanQty = this.isValueNull(scanQtyO) ? new BigDecimal("0") : new BigDecimal(scanQtyO.toString());
            diffQty = srcQty.subtract(scanQty);
            if (this.isCountTableForDestBosType()) {
                diffQty = diffQty.multiply(new BigDecimal("-1"));
            }
            row.getCell(TB_DIFQTY).getStyleAttributes().setNumberFormat("0.00000000");
            row.getCell(TB_DIFQTY).setValue((Object)diffQty);
        }
    }

    protected void isNumberFormt(String qtyStr) {
        try {
            new BigDecimal(qtyStr);
        }
        catch (NumberFormatException e) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"163_BarcodeScanningEditUI"));
            SysUtil.abort();
        }
    }

    protected boolean isCountTableForDestBosType() {
        return this.countTableBosType.equals(this.txtdestBosType.getText());
    }

    protected void initPropertyColumns(BarcodeConfigXMLDetail detail, KDTable table, List<String> aliasList) {
        List<BarcodeConfigXMLProperty> propertys = detail.getProperties();
        EntityObjectInfo entity = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)detail.getBosType()));
        for (int i = 0; i < propertys.size(); ++i) {
            BarcodeConfigXMLProperty property = propertys.get(i);
            String key = property.getFullName();
            key = key.substring(key.lastIndexOf(".") + 1);
            PropertyInfo entityProperty = entity.getPropertyByName(key);
            if (property.isLinkedProperty()) {
                this.addColumnForLinkedProperty(table, aliasList, property, key, entityProperty);
                continue;
            }
            if (property.isScanQty()) {
                this.addColunm(table, key, property, entityProperty);
                table.getColumn(key).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                aliasList.add(property.getAlias() + EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"147_BarcodeScanningEditUI"));
                continue;
            }
            this.addColunm(table, key, property, entityProperty);
            if (property.getDataType().equals("BigDecimal") || property.getDataType().equals("Integer")) {
                table.getColumn(key).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            } else if (property.getDataType().equals("Date")) {
                table.getColumn(key).getStyleAttributes().setNumberFormat("%{yyyy-MM-dd}t");
            } else if (property.getDataType().equals("TimeStamp")) {
                table.getColumn(key).getStyleAttributes().setNumberFormat("%{yyyy-MM-dd HH:mm:ss}t");
            }
            aliasList.add(property.getAlias());
        }
    }

    protected void addColumnForLinkedProperty(KDTable table, List<String> aliasList, BarcodeConfigXMLProperty property, String key, PropertyInfo entityProperty) {
        String filedNumber = key + "_number";
        String filedName = key + "_name";
        this.addColunm(table, filedNumber, property, entityProperty);
        this.addColunm(table, filedName, property, entityProperty);
        aliasList.add(property.getAlias() + EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"145_BarcodeScanningEditUI"));
        aliasList.add(property.getAlias() + EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"103_BarcodeDefaultTablePanel"));
    }

    protected void addSrcAndDifQtyColumn(KDTable table, List<String> aliasList) {
        String srcBosType = this.txtsrcBosType.getText();
        boolean isHasSrcBill = !this.isValueNull(srcBosType);
        String scanQtyFiled = this.getScanOrSrcQtyFiled(table, false, true);
        int scannIndex = table.getColumnIndex(scanQtyFiled);
        if (scannIndex == -1) {
            table.addColumn().setKey(TB_SRCQTY);
            aliasList.add(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"146_BarcodeScanningEditUI"));
            table.addColumn().setKey(TB_DIFQTY);
            aliasList.add(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"148_BarcodeScanningEditUI"));
            table.addColumn().setKey(TB_DIFSPLITQTY);
            aliasList.add(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)TB_DIFSPLITQTY));
            table.addColumn().setKey(TB_SPLITQTY);
            aliasList.add(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)TB_SPLITQTY));
            table.addColumn().setKey(TB_SPLITTEDQTY);
            aliasList.add(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)TB_SPLITTEDQTY));
        } else {
            table.addColumn(scannIndex).setKey(TB_SRCQTY);
            aliasList.add(scannIndex, EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"146_BarcodeScanningEditUI"));
            table.addColumn(scannIndex + 2).setKey(TB_DIFQTY);
            aliasList.add(scannIndex + 2, EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"148_BarcodeScanningEditUI"));
            table.addColumn(scannIndex + 3).setKey(TB_DIFSPLITQTY);
            aliasList.add(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)TB_DIFSPLITQTY));
            table.addColumn(scannIndex + 4).setKey(TB_SPLITQTY);
            aliasList.add(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)TB_SPLITQTY));
            table.addColumn(scannIndex + 5).setKey(TB_SPLITTEDQTY);
            aliasList.add(EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)TB_SPLITTEDQTY));
        }
        table.getColumn(TB_SRCQTY).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn(TB_SRCQTY).getStyleAttributes().setNumberFormat("0.00000000");
        table.getColumn(TB_SRCQTY).getStyleAttributes().setLocked(true);
        table.getColumn(TB_SRCQTY).getStyleAttributes().setFontColor(Color.BLUE);
        table.getColumn(TB_DIFQTY).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn(TB_DIFQTY).getStyleAttributes().setNumberFormat("0.00000000");
        table.getColumn(TB_DIFQTY).getStyleAttributes().setLocked(true);
        table.getColumn(TB_DIFQTY).getStyleAttributes().setFontColor(Color.RED);
        table.getColumn(TB_DIFSPLITQTY).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn(TB_DIFSPLITQTY).getStyleAttributes().setNumberFormat("0.00000000");
        table.getColumn(TB_DIFSPLITQTY).getStyleAttributes().setLocked(true);
        table.getColumn(TB_DIFSPLITQTY).getStyleAttributes().setFontColor(Color.RED);
        table.getColumn(TB_SPLITQTY).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn(TB_SPLITQTY).getStyleAttributes().setNumberFormat("0.00000000");
        table.getColumn(TB_SPLITQTY).getStyleAttributes().setLocked(true);
        table.getColumn(TB_SPLITTEDQTY).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn(TB_SPLITTEDQTY).getStyleAttributes().setNumberFormat("0.00000000");
        table.getColumn(TB_SPLITTEDQTY).getStyleAttributes().setLocked(true);
        table.getColumn(TB_SPLITTEDQTY).getStyleAttributes().setFontColor(Color.BLUE);
        if (isHasSrcBill && scannIndex != -1) {
            table.getColumn(TB_SRCQTY).getStyleAttributes().setHided(false);
            table.getColumn(TB_DIFQTY).getStyleAttributes().setHided(false);
            table.getColumn(TB_DIFSPLITQTY).getStyleAttributes().setHided(false);
            table.getColumn(TB_SPLITQTY).getStyleAttributes().setHided(false);
            table.getColumn(TB_SPLITTEDQTY).getStyleAttributes().setHided(false);
        } else {
            table.getColumn(TB_SRCQTY).getStyleAttributes().setHided(true);
            table.getColumn(TB_DIFQTY).getStyleAttributes().setHided(true);
            table.getColumn(TB_DIFSPLITQTY).getStyleAttributes().setHided(true);
            table.getColumn(TB_SPLITQTY).getStyleAttributes().setHided(true);
            table.getColumn(TB_SPLITTEDQTY).getStyleAttributes().setHided(true);
        }
    }

    protected KDTMergeBlock getMergeBolck(KDTable table, int matchRowIndex) {
        KDTMergeBlock merg = null;
        Set set = table.getMergeManager().getMergeBlockSet();
        Iterator itr = set.iterator();
        if (itr.hasNext()) {
            while (itr.hasNext()) {
                KDTMergeBlock block = (KDTMergeBlock)itr.next();
                if (matchRowIndex < block.getTop() || matchRowIndex > block.getBottom()) continue;
                merg = block;
                break;
            }
        }
        return merg;
    }

    protected void addColunm(KDTable table, String key, BarcodeConfigXMLProperty property, PropertyInfo entityProperty) {
        IColumn column = table.addColumn();
        column.setKey(key);
        column.getStyleAttributes().setHided(property.isUnVisable());
        if (property.isLinkedProperty() && property.isRefer() && key.contains("_number")) {
            this.addF7Column(column, property, entityProperty);
        } else if (!property.isLinkedProperty()) {
            BarcodeClientUtils.loadSingleColumn(column, entityProperty);
        }
    }

    protected void addF7Column(IColumn column, BarcodeConfigXMLProperty xmlProperty, PropertyInfo entityProperty) {
        EntityObjectInfo tempEntity;
        String defaultF7;
        KDBizPromptBox f7 = null;
        if (entityProperty instanceof LinkPropertyInfo && (defaultF7 = (tempEntity = ((LinkPropertyInfo)entityProperty).getRelationship().getSupplierObject()).getExtendedProperty("defaultF7Query")) != null) {
            f7 = new KDBizPromptBox();
            f7.setVisible(true);
            f7.setEditable(true);
            f7.setDisplayFormat("$number$");
            f7.setEditFormat("$number$");
            f7.setCommitFormat("$number$");
            KDTDefaultCellEditor object_CellEditor = new KDTDefaultCellEditor((IKDEditor)f7);
            column.setEditor((ICellEditor)object_CellEditor);
            ObjectValueRender avr = new ObjectValueRender();
            avr.setFormat((IDataFormat)new BizDataFormat(f7.getDisplayFormatter().toString()));
            column.setRenderer((IBasicRender)avr);
            f7.setQueryInfo(defaultF7);
        }
    }

    protected String getScanOrSrcQtyFiled(KDTable table, boolean isSrcQty, boolean isScanQty) {
        for (int i = 0; i < this.xmlInfo.getDetails().size(); ++i) {
            BarcodeConfigXMLDetail xmlDetail = this.xmlInfo.getDetails().get(i);
            if (xmlDetail.getFullName() != null && !xmlDetail.getFullName().equals(table.getName())) continue;
            List<BarcodeConfigXMLProperty> xmlPropertyList = xmlDetail.getProperties();
            for (int j = 0; j < xmlPropertyList.size(); ++j) {
                BarcodeConfigXMLProperty xmlProperty = xmlPropertyList.get(j);
                if (isSrcQty && xmlProperty.isSrcQty()) {
                    return xmlProperty.getName();
                }
                if (!isScanQty || !xmlProperty.isScanQty()) continue;
                return xmlProperty.getName();
            }
        }
        return null;
    }

    protected BigDecimal cumSumQty(List<BarcodeAnalysisResultItem> items, KDTable table, IRow currRow, BigDecimal scanQty) {
        BigDecimal qty = new BigDecimal("0");
        String scanQtyFiled = this.getScanOrSrcQtyFiled(table, false, true);
        if (scanQtyFiled == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"162_BarcodeScanningEditUI"));
            SysUtil.abort();
        }
        if (scanQty != null) {
            qty = scanQty;
        } else {
            for (int i = 0; i < items.size(); ++i) {
                Object oldValue = currRow.getCell(scanQtyFiled).getValue();
                BigDecimal value = oldValue == null ? new BigDecimal("0") : new BigDecimal(oldValue.toString());
                String filed = items.get(i).getField();
                if ((filed = filed.substring(filed.lastIndexOf(".") + 1)).equals(scanQtyFiled)) {
                    if (items.get(i).getValue() == null) break;
                    String qtyStr = items.get(i).getValue().toString();
                    this.isNumberFormt(qtyStr);
                    qty = value.add(new BigDecimal(qtyStr));
                    break;
                }
                if (scanQtyFiled.equals(filed) || i != items.size() - 1) continue;
                qty = value.add(new BigDecimal("1"));
            }
        }
        currRow.getCell(scanQtyFiled).setValue((Object)qty);
        return qty;
    }

    protected BigDecimal cumSumQty(List<BarcodeAnalysisResultItem> items, KDTable table, IRow currRow, BigDecimal scanQty, boolean isCumsum) {
        BigDecimal qty = new BigDecimal("0");
        String scanQtyFiled = this.getScanOrSrcQtyFiled(table, false, true);
        if (scanQtyFiled == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"162_BarcodeScanningEditUI"));
            SysUtil.abort();
        }
        if (scanQty != null) {
            qty = scanQty;
        } else if (isCumsum) {
            for (int i = 0; i < items.size(); ++i) {
                Object oldValue = currRow.getCell(scanQtyFiled).getValue();
                BigDecimal value = oldValue == null ? new BigDecimal("0") : new BigDecimal(oldValue.toString());
                String filed = items.get(i).getField();
                if ((filed = filed.substring(filed.lastIndexOf(".") + 1)).equals(scanQtyFiled)) {
                    if (items.get(i).getValue() == null) break;
                    String qtyStr = items.get(i).getValue().toString();
                    this.isNumberFormt(qtyStr);
                    qty = value.add(new BigDecimal(qtyStr));
                    break;
                }
                if (scanQtyFiled.equals(filed) || i != items.size() - 1) continue;
                qty = value.add(new BigDecimal("1"));
            }
        } else {
            for (int i = 0; i < items.size(); ++i) {
                String filed = items.get(i).getField();
                if (!(filed = filed.substring(filed.lastIndexOf(".") + 1)).equals(scanQtyFiled)) continue;
                if (items.get(i).getValue() == null) break;
                String qtyStr = items.get(i).getValue().toString();
                this.isNumberFormt(qtyStr);
                qty = new BigDecimal(qtyStr);
                break;
            }
        }
        currRow.getCell(scanQtyFiled).setValue((Object)qty);
        return qty;
    }

    protected void doAfterSubmit(IObjectPK pk) throws Exception {
        this.setOprtState(OprtState.VIEW);
        super.doAfterSubmit(pk);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (this.isValueNull(this.txtNumber.getText()) && this.isAddView) {
            MsgBox.showWarning((String)"\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            this.txtNumber.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtbarcodeConfig.getValue() == null) {
            MsgBox.showWarning((String)"\u626b\u63cf\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
            this.prmtbarcodeConfig.requestFocus();
            SysUtil.abort();
        }
        if (this.prmttransactionType.getValue() == null) {
            MsgBox.showWarning((String)"\u4e8b\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            this.prmttransactionType.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtorgUnit.getValue() == null) {
            MsgBox.showWarning((String)"\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
            this.prmtorgUnit.requestFocus();
            SysUtil.abort();
        }
        String bosType = "";
        for (int i = 0; i < this.kdtpEntry.getTabCount(); ++i) {
            KDTable table = (KDTable)this.kdtpEntry.getComponentAt(i);
            String chiledBosType = this.getBosType(table, TB_BOSTYPE);
            String parentBosType = this.getBosType(table, TB_PARENTBOSTYPE);
            if (parentBosType.equals(new ScanTaskBillInfo().getBOSType().toString())) {
                bosType = this.getBosType(table, TB_BOSTYPE);
                if (table.getRowCount3() == 0) {
                    MsgBox.showWarning((String)(this.kdtpEntry.getTitleAt(i) + "\u6ca1\u6709\u4efb\u52a1\u6570\u636e"));
                    SysUtil.abort();
                }
            }
            if (!chiledBosType.equals(bosType) || table.getRowCount3() != 0) continue;
            MsgBox.showWarning((String)(this.kdtpEntry.getTitleAt(i) + "\u6ca1\u6709\u4efb\u52a1\u6570\u636e"));
            SysUtil.abort();
        }
    }

    @Override
    protected void taskObject_itemStateChanged(ItemEvent e) throws Exception {
        ObjectTypeEnum objectTypeEnum = (ObjectTypeEnum)((Object)this.taskObject.getSelectedItem());
        this.prmtTaskOperator.setValue(null);
        if (ObjectTypeEnum.department.equals((Object)objectTypeEnum)) {
            this.prmtTaskOperator.setQueryInfo("com.kingdee.eas.sem.mp.app.AdminOrgUnitF7");
            this.prmtTaskOperator.setDisplayFormat("$name$");
            this.prmtTaskOperator.setEditFormat("$number$");
            this.prmtTaskOperator.setCommitFormat("$number$");
            this.prmtTaskOperator.setEditable(true);
            this.prmtTaskOperator.setRequired(true);
        }
        if (ObjectTypeEnum.person.equals((Object)objectTypeEnum)) {
            this.prmtTaskOperator.setDisplayFormat("$name$");
            this.prmtTaskOperator.setEditFormat("$number$");
            this.prmtTaskOperator.setCommitFormat("$number$");
            this.prmtTaskOperator.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
            this.prmtTaskOperator.setEditable(true);
        }
    }

    @Override
    protected void prmtTaskOperator_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtTaskOperator_dataChanged(e);
    }

    @Override
    protected void prmtbarcodeConfig_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtbarcodeConfig.getValue() != null) {
            BarcodeConfigInfo barcodeInfo = (BarcodeConfigInfo)this.prmtbarcodeConfig.getValue();
            this.txtsrcBosType.setText(barcodeInfo.getSrcBosType());
            this.txtdestBosType.setText(barcodeInfo.getDestBosType());
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("barcodeConfig.id", (Object)barcodeInfo.getId()));
            view.setFilter(filterInfo);
            SelectorItemCollection coll = new SelectorItemCollection();
            coll.add(new SelectorItemInfo("barcodeConfig.*"));
            coll.add(new SelectorItemInfo("detailsXML"));
            coll.add(new SelectorItemInfo("entityBosType"));
            view.setSelector(coll);
            BarcodeDefaultSolutionCollection barcodeScol = BarcodeDefaultSolutionFactory.getRemoteInstance().getBarcodeDefaultSolutionCollection(view);
            if (this.prmttransactionType != null) {
                this.prmttransactionType.setEntityViewInfo(this.buildTransactionTypeEntityView(barcodeInfo.getDestBosType(), barcodeScol, null));
            }
        }
    }

    protected EntityViewInfo buildTransactionTypeEntityView(String bosType, BarcodeDefaultSolutionCollection col, BizTypeInfo bizTypeInfo) {
        String bizTypeid = this.getBizTypeNumber(col);
        if (bizTypeInfo != null) {
            bizTypeid = bizTypeInfo.getId().toString();
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String billTypeID = this.getBillTypeId(bosType);
        if (null != billTypeID) {
            filterInfo.getFilterItems().add(new FilterItemInfo("billType.id", (Object)billTypeID, CompareType.EQUALS));
        }
        if (null != bizTypeid) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bizType.id", (Object)bizTypeid, CompareType.EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("transBizType.selfmade", (Object)1, CompareType.EQUALS));
        ev.setFilter(filterInfo);
        this.setTransacationNumber(billTypeID, bizTypeid, col);
        return ev;
    }

    private String getBizTypeNumber(BarcodeDefaultSolutionCollection col) {
        String bizTypeNumber = null;
        if (col == null) {
            return bizTypeNumber;
        }
        int size = col.size();
        block3: for (int i = 0; i < size; ++i) {
            BarcodeDefaultSolutionInfo solInfo = col.get(i);
            BarcodeDefaultXMLInfo defaultXmlInfo = BarcodeXMLHelper.toBarcodeDefaultXMLInfo(solInfo.getDetailsXML());
            for (int j = 0; j < defaultXmlInfo.getItems().size(); ++j) {
                BarcodeDefaultXMLItem item = defaultXmlInfo.getItems().get(j);
                String fullField = item.getField();
                if (!"bizType".equalsIgnoreCase(fullField)) continue;
                bizTypeNumber = item.getValue();
                continue block3;
            }
        }
        try {
            BizTypeInfo bizTypeInfo;
            if (bizTypeNumber != null && !"".equals(bizTypeNumber) && (bizTypeInfo = BizTypeFactory.getRemoteInstance().getBizTypeInfo("select id from where number='" + bizTypeNumber + "'")) != null) {
                bizTypeNumber = bizTypeInfo.getId().toString();
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return bizTypeNumber;
    }

    private void setTransacationNumber(String billTypeID, String bizTypeid, BarcodeDefaultSolutionCollection col) {
        if (col == null) {
            return;
        }
        String transactionTypeNumber = null;
        int size = col.size();
        block3: for (int i = 0; i < size; ++i) {
            BarcodeDefaultSolutionInfo solInfo = col.get(i);
            BarcodeDefaultXMLInfo defaultXmlInfo = BarcodeXMLHelper.toBarcodeDefaultXMLInfo(solInfo.getDetailsXML());
            int j = 0;
            while (i < defaultXmlInfo.getItems().size()) {
                BarcodeDefaultXMLItem item = defaultXmlInfo.getItems().get(j);
                String fullField = item.getField();
                if ("transactionType".equalsIgnoreCase(fullField)) {
                    transactionTypeNumber = item.getValue();
                    continue block3;
                }
                ++j;
            }
        }
        if (transactionTypeNumber != null && !"".equals(transactionTypeNumber)) {
            EntityViewInfo view = new EntityViewInfo();
            SorterItemCollection sic = new SorterItemCollection();
            SorterItemInfo riType = new SorterItemInfo("riType.bizDirection");
            riType.setSortType(SortType.DESCEND);
            SorterItemInfo number = new SorterItemInfo("number");
            sic.add(riType);
            sic.add(number);
            view.setSorter(sic);
            view.setSelector(SCMSelectorFactory.getTransactionTypeSelector((boolean)false));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)transactionTypeNumber, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("riType", null, CompareType.NOTEQUALS));
            view.setFilter(filter);
            try {
                TransactionTypeCollection transcationCol = TransactionTypeFactory.getRemoteInstance().getTransactionTypeCollection(view);
                if (transcationCol.size() > 0) {
                    this.prmttransactionType.setValue((Object)transcationCol.get(0));
                } else if (billTypeID != null && bizTypeid != null) {
                    this.prmttransactionType.setValue((Object)this.getOnlyOneTransactionType(billTypeID, bizTypeid));
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
    }

    private String getBillTypeId(String bosType) {
        try {
            BillTypeInfo billType = BillTypeFactory.getRemoteInstance().getBillTypeInfo("where bosType='" + bosType + "'");
            this.txtbilltype.setText(billType.getName());
            String billTypeId = billType.getId().toString();
            return billTypeId;
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ScanTaskBillFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    @Override
    public void actionSelectBills_actionPerformed(ActionEvent ex) throws Exception {
        if (this.prmtbarcodeConfig.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u8bf7\u5148\u9009\u62e9\u626b\u63cf\u914d\u7f6e\uff01");
            this.prmtbarcodeConfig.requestFocusInWindow();
            SysUtil.abort();
        }
        EntityObjectInfo selectEntity = this.getSelectEntity(this.txtsrcBosType.getText(), this.txtdestBosType.getText());
        Map selBills = null;
        String uiCls = this.getBillSelectUICls(selectEntity);
        if (StringUtils.isEmpty((String)uiCls)) {
            logger.error((Object)("invalid billTye, not in enum!! " + selectEntity.getType()));
        }
        UIContext uiContext = new UIContext((Object)this);
        try {
            IUIWindow billSelUiWin = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiCls, (Map)uiContext, null, OprtState.VIEW, 95);
            billSelUiWin.show();
            IUIObject selUI = billSelUiWin.getUIObject();
            if (selUI instanceof IBarcodeBillSelectUI) {
                selBills = ((IBarcodeBillSelectUI)selUI).getBarcodeSelectedData();
                this.entryProperty = ((IBarcodeBillSelectUI)selUI).getEntryID();
                this.mainQueryPK = ((IBarcodeBillSelectUI)selUI).getTDQueryPK();
                if (selBills == null) {
                    return;
                }
                Iterator it = selBills.keySet().iterator();
                StringBuffer idStr = new StringBuffer();
                while (it.hasNext()) {
                    if (idStr.length() > 0) {
                        idStr.append(",").append(it.next());
                        continue;
                    }
                    idStr.append(it.next());
                }
                String number = ((IBarcodeBillSelectUI)selUI).getNumber();
                String srcNumber = this.txtSrcNumber.getText();
                if (srcNumber != null && number != null && srcNumber.contains(number)) {
                    MsgBox.showWarning((Component)((Object)this), (String)"\u9009\u62e9\u5bf9\u8c61\u6570\u636e\u5df2\u7ecf\u505a\u8fc7\u4efb\u52a1\uff01");
                    SysUtil.abort();
                }
                IScanTaskBill iScanTaskBill = ScanTaskBillFactory.getRemoteInstance();
                HashMap<String, Object> argumentMap = new HashMap<String, Object>();
                argumentMap.put("billId", idStr);
                argumentMap.put("destBosType", this.txtdestBosType.getText());
                argumentMap.put("entryBosTypeList", this.entryBosTypeList);
                argumentMap.put("id", this.editData.getId() != null ? this.editData.getId().toString() : null);
                iScanTaskBill.checkScanTask(argumentMap);
                BarcodeConfigInfo info = (BarcodeConfigInfo)this.prmtbarcodeConfig.getData();
                String botMappingId = info.getBotMapping() != null ? info.getBotMapping().getId().toString() : null;
                this.fillTableData(idStr.toString(), null, null, this.txtsrcBosType.getText(), this.txtdestBosType.getText(), botMappingId, ((IBarcodeBillSelectUI)selUI).getSelectors(), number);
            }
        }
        catch (UIException e) {
            if (e.getMessage() != null && e.getMessage().contains("Can not create ui object!")) {
                MsgBox.showWarning((Component)((Object)this), (String)("[" + selectEntity.getAlias() + "]" + BarcodeClientUtils.getBarcodeResource("ObjectTypePrint")));
                SysUtil.abort();
            }
            if (e.getCauseClassName() != null && e.getCauseClassName().equals("com.kingdee.eas.common.EASBizException")) {
                MsgBox.showWarning((String)e.fillInStackTrace().getCause().getMessage());
                SysUtil.abort();
            }
            e.printStackTrace();
        }
    }

    private EntityObjectInfo getSelectEntity(String srcBosType, String destBosType) {
        EntityObjectInfo selectEntity = null;
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        selectEntity = srcBosType != null && !"".equals(srcBosType) ? loader.getEntity(BOSObjectType.create((String)srcBosType)) : loader.getEntity(BOSObjectType.create((String)destBosType));
        return selectEntity;
    }

    private void fillTableData(String idStr, Map splitMap, String scanQtyFiled, String srcBosType, String destBosType, String botMappingID, SelectorItemCollection srcSic, String number) {
        try {
            String botpNumber;
            IScanTaskBill iScanTaskBill = ScanTaskBillFactory.getRemoteInstance();
            LinkedHashMap<String, Object> paramMap = new LinkedHashMap<String, Object>();
            if (srcBosType != null && botMappingID != null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("name");
                sic.add("id");
                BOTMappingInfo botInfo = BOTMappingFactory.getRemoteInstance().getBOTMappingInfo((IObjectPK)new ObjectUuidPK(botMappingID), sic);
                paramMap.put("botpNumber", botInfo.getName());
                if (srcSic == null) {
                    List rt = BotUtil.getSrcBillPropList((BOTMappingInfo)botInfo);
                    srcSic = new SelectorItemCollection();
                    int size = rt.size();
                    for (int j = 0; j < size; ++j) {
                        srcSic.add(new SelectorItemInfo(rt.get(j).toString()));
                    }
                }
            }
            if (srcSic == null) {
                srcSic = new SelectorItemCollection();
                srcSic.add(new SelectorItemInfo("*"));
            }
            paramMap.put("srcBosType", srcBosType);
            paramMap.put("destBosType", destBosType);
            paramMap.put("idStr", idStr.toString());
            paramMap.put("selectEntity", this.getSelectEntity(srcBosType, destBosType));
            paramMap.put("sic", srcSic);
            if (splitMap != null) {
                paramMap.put("splitMap", splitMap);
                paramMap.put("scanQtyFiled", scanQtyFiled);
                if (this.getUIContext().containsKey("billIDMap")) {
                    paramMap.put("billIDMap", this.getUIContext().get("billIDMap"));
                }
            }
            boolean isBotp = (botpNumber = this.txtbotpNumber.getText()).length() > 0;
            IObjectCollection objectColl = (IObjectCollection)iScanTaskBill.getDestBill(paramMap);
            if (objectColl != null && objectColl.size() > 0) {
                for (int i = 0; i < objectColl.size(); ++i) {
                    this.fillBillData(objectColl.getObject(i), isBotp);
                }
                this.txtSrcNumber.setText(number);
                IObjectValue objectValue = objectColl.getObject(0);
                if (objectValue.get("bizType") != null && objectValue.get("bizType") instanceof BizTypeInfo) {
                    this.buildTransactionTypeEntityView(objectValue.getBOSType().toString(), null, (BizTypeInfo)objectValue.get("bizType"));
                }
            } else {
                this.destroyWindow();
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.handleException((Exception)((Object)e));
        }
    }

    protected void fillBillData(IObjectValue value, boolean isBotp) {
        KDTable billTable = null;
        BOSUuid billId = null;
        String entityAlais = this.kdtpEntry.getTitleAt(0);
        for (int i = 0; i < this.kdtpEntry.getTabCount(); ++i) {
            KDTable table = (KDTable)this.kdtpEntry.getComponentAt(i);
            String scanQtyFiled = this.getScanOrSrcQtyFiled(table, false, true);
            IObjectCollection entryColl = null;
            EntityObjectInfo entity = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)this.getBosType(table, TB_BOSTYPE)));
            if (!this.isValueNull(table.getName())) {
                if (table.getName().indexOf(".") != -1 || (entryColl = (IObjectCollection)value.get(table.getName())) == null || entryColl.size() <= 0) continue;
                for (int x = 0; x < entryColl.size(); ++x) {
                    IObjectValue entryValue = entryColl.getObject(x);
                    IRow row = table.addRow();
                    IRow billRow = this.tblBill.addRow();
                    row.getStyleAttributes().setLocked(true);
                    this.fillBillToTable(table, entryValue, row, billRow, entity, isBotp);
                    if (!this.isValueNull(scanQtyFiled) && !this.isValueNull(this.txtsrcBosType.getText())) {
                        row.getCell(TB_SRCQTY).setValue(entryValue.get(scanQtyFiled));
                        BigDecimal scanQty = new BigDecimal(row.getCell(scanQtyFiled).getValue().toString());
                        BigDecimal srcQty = new BigDecimal(row.getCell(TB_SRCQTY).getValue().toString());
                        row.getCell(TB_DIFQTY).setValue((Object)srcQty.subtract(scanQty));
                        row.getCell(TB_SPLITTEDQTY).setValue((Object)BigDecimal.ZERO);
                        BigDecimal splittedQty = new BigDecimal(row.getCell(TB_SPLITTEDQTY).getValue().toString());
                        row.getCell(TB_DIFSPLITQTY).setValue((Object)srcQty.subtract(splittedQty));
                        row.getCell(TB_SPLITQTY).setValue((Object)BigDecimal.ZERO);
                    }
                    row.getCell(TB_PARENTID).setValue((Object)billId);
                    row.getCell(TB_ID).setValue((Object)this.createRowId(table, row, TB_ID));
                    row.getCell(TB_SRCBILLID).setValue(entryValue.get("sourceBillId"));
                    row.getCell(TB_SRCBILLENTRYID).setValue(entryValue.get("sourceBillEntryId"));
                    row.getCell(TB_DESTBILLID).setValue(entryValue.get("id"));
                    if (entryValue.get(TB_SRCSCANENTRYID) != null) {
                        row.getCell(TB_SRCSCANENTRYID).setValue(entryValue.get(TB_SRCSCANENTRYID));
                    }
                    billRow.getCell("sourceBillEntryId").setValue(entryValue.get("id"));
                }
                this.kdtpEntry.setSelectedIndex(i);
                continue;
            }
            billTable = table;
            IRow row = table.addRow();
            this.fillBillToTable(table, value, row, null, entity, isBotp);
            billId = this.createRowId(table, row, TB_ID);
            row.getCell(TB_ID).setValue((Object)billId);
            row.getCell(TB_DESTBILLID).setValue(value.get("id"));
            this.fillToTblBarcode(billTable, billId.toString(), this.barcode, entityAlais, row.getRowIndex());
            this.parentIdMap.put(this.getBosType(table, TB_BOSTYPE), billId.toString());
            if (value.get(TB_SRCSCANENTRYID) == null) continue;
            row.getCell(TB_SRCSCANENTRYID).setValue(value.get(TB_SRCSCANENTRYID));
        }
    }

    protected String getBosType(KDTable table, String key) {
        for (int i = 0; i < this.xmlInfo.getDetails().size(); ++i) {
            BarcodeConfigXMLDetail xmlDetail = this.xmlInfo.getDetails().get(i);
            if ((xmlDetail.getFullName() != null || xmlDetail.getFullName() != table.getName()) && (xmlDetail.getFullName() == null || !xmlDetail.getFullName().equals(table.getName()))) continue;
            if (key.equals(TB_BOSTYPE)) {
                return xmlDetail.getBosType();
            }
            if (!key.equals(TB_PARENTBOSTYPE)) continue;
            return xmlDetail.getParentBosType() == null ? new ScanTaskBillInfo().getBOSType().toString() : xmlDetail.getParentBosType();
        }
        return null;
    }

    protected void fillToTblBarcode(KDTable table, String id, String barcode, String entityAlais, int rowNum) {
        IRow barcodeRow = this.tblBarcode.addRow();
        barcodeRow.getCell("parentId").setValue((Object)id);
        barcodeRow.getCell("parentBosType").setValue((Object)this.getBosType(table, TB_BOSTYPE));
        barcodeRow.getCell(BC_BARCODE).setValue((Object)barcode);
        barcodeRow.getCell("entityAlais").setValue((Object)entityAlais);
        barcodeRow.getCell("rowNum").setValue((Object)(rowNum + 1));
        barcodeRow.getCell(BC_BARCODERULEID).setValue((Object)this.barcodeAnalysisClientHelper.getCurrRuleId());
    }

    protected void fillToTblSeqNo(KDTable table, String id, String seqNo, String entityAlais, int rowNum) {
        IRow barcodeRow = this.tblSeq.addRow();
        barcodeRow.getCell("parentId").setValue((Object)id);
        barcodeRow.getCell("parentBosType").setValue((Object)this.getBosType(table, TB_BOSTYPE));
        barcodeRow.getCell(SEQ_SEQ).setValue((Object)seqNo);
        barcodeRow.getCell("entityAlais").setValue((Object)entityAlais);
        barcodeRow.getCell("rowNum").setValue((Object)(rowNum + 1));
    }

    protected BOSUuid createRowId(KDTable table, IRow row, String key) {
        BOSUuid id = BOSUuid.create((String)"CF7797BA");
        row.getCell(key).setValue((Object)id);
        return id;
    }

    protected void fillBillToTable(KDTable table, IObjectValue value, IRow row, IRow billrow, EntityObjectInfo entity, boolean isBotp) {
        String scanQtyFiled = this.getScanOrSrcQtyFiled(table, false, true);
        IBarcodeScanning iBarcodeScanning = null;
        try {
            iBarcodeScanning = BarcodeScanningFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.handleException((Exception)((Object)e));
        }
        for (int j = 0; j < table.getColumnCount(); ++j) {
            String key = table.getColumnKey(j);
            String objectKey = key.substring(key.lastIndexOf(".") + 1);
            if (key.contains("_")) {
                Object linkValue = value.get(objectKey = objectKey.substring(0, objectKey.indexOf("_")));
                if (linkValue != null) {
                    IObjectValue objectValue = (IObjectValue)linkValue;
                    Object number = objectValue.get("number");
                    if (number == null && objectValue.get("id") != null) {
                        try {
                            objectValue = (IObjectValue)iBarcodeScanning.getIObjectValueById(objectValue.get("id").toString());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.handleException(e);
                        }
                    }
                    if (billrow != null && linkValue instanceof MaterialInfo) {
                        billrow.getCell("material").setValue((Object)objectValue);
                    }
                    if (linkValue instanceof TransactionTypeInfo) {
                        TransactionTypeInfo scationTypeInfo = (TransactionTypeInfo)linkValue;
                        this.prmttransactionType.setValue((Object)scationTypeInfo);
                    }
                    row.getCell(j).setValue(objectValue.get("number"));
                    if (objectValue instanceof MaterialInfo) {
                        row.getCell(j).getStyleAttributes().setLocked(true);
                    } else {
                        row.getCell(j).getStyleAttributes().setLocked(false);
                    }
                    row.getCell(++j).setValue(objectValue.get("name"));
                    continue;
                }
                row.getCell(j).getStyleAttributes().setLocked(false);
                ++j;
                continue;
            }
            if (key.equals(scanQtyFiled) && isBotp) {
                row.getCell(j).setValue((Object)new BigDecimal("0"));
                continue;
            }
            if (key.equals(TB_ID) || key.equals(TB_PARENTID)) continue;
            PropertyInfo property = entity.getPropertyByName(objectKey);
            if (property != null) {
                if (value.get(objectKey) instanceof Date) {
                    BarcodeClientUtils.setSingleCellValue(row.getCell(j), property, BarcodeUtils.SIMPLE_DATE_FORMAT.format(value.get(objectKey)));
                    continue;
                }
                BarcodeClientUtils.setSingleCellValue(row.getCell(j), property, value.getString(objectKey));
                continue;
            }
            row.getCell(j).setValue((Object)value.getString(objectKey));
        }
    }

    private String getBillSelectUICls(EntityObjectInfo selectEntity) {
        String cls = null;
        String fullName = selectEntity.getFullName();
        fullName = fullName.substring(fullName.lastIndexOf("."), fullName.length());
        cls = "com.kingdee.eas.barcode.scm.client" + fullName + "SelectUI";
        return cls;
    }

    private Map getBillSelectedData(EntityObjectInfo selectEntity) throws Exception {
        if (selectEntity == null) {
            return null;
        }
        Map selBills = null;
        String uiCls = this.getBillSelectUICls(selectEntity);
        if (StringUtils.isEmpty((String)uiCls)) {
            logger.error((Object)("invalid billTye, not in enum!! " + selectEntity.getType()));
            return selBills;
        }
        UIContext uiContext = new UIContext((Object)this);
        try {
            IUIWindow billSelUiWin = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiCls, (Map)uiContext, null, OprtState.VIEW, 95);
            billSelUiWin.show();
            IUIObject selUI = billSelUiWin.getUIObject();
            if (selUI instanceof IBarcodeBillSelectUI) {
                selBills = ((IBarcodeBillSelectUI)selUI).getBarcodeSelectedData();
                this.entryProperty = ((IBarcodeBillSelectUI)selUI).getEntryID();
                this.mainQueryPK = ((IBarcodeBillSelectUI)selUI).getTDQueryPK();
            }
        }
        catch (UIException e) {
            if (e.getMessage() != null && e.getMessage().contains("Can not create ui object!")) {
                MsgBox.showWarning((Component)((Object)this), (String)("[" + selectEntity.getAlias() + "]" + BarcodeClientUtils.getBarcodeResource("ObjectTypePrint")));
                SysUtil.abort();
            }
            if (e.getCauseClassName() != null && e.getCauseClassName().equals("com.kingdee.eas.common.EASBizException")) {
                MsgBox.showWarning((String)e.fillInStackTrace().getCause().getMessage());
                SysUtil.abort();
            }
            e.printStackTrace();
        }
        return selBills;
    }

    @Override
    protected IObjectValue createNewData() {
        ScanTaskBillInfo objectValue = new ScanTaskBillInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setBizDate(new Date());
        objectValue.setSrcBosType(null);
        if (this.getMainBizOrgType().equals((Object)OrgType.Storage)) {
            FullOrgUnitInfo fullOrgInfo = new FullOrgUnitInfo();
            StorageOrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentStorageUnit();
            fullOrgInfo.setId(orgUnitInfo.getId());
            fullOrgInfo.setName(orgUnitInfo.getName());
            fullOrgInfo.setNumber(orgUnitInfo.getNumber());
            objectValue.setOrgUnit(fullOrgInfo);
        }
        return objectValue;
    }

    @Override
    protected String getMainBizOrgField() {
        return "orgUnit";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemTDPrint.setAccelerator(KeyStroke.getKeyStroke("ctrl alt P"));
        this.menuItemTDPrintPreview.setAccelerator(KeyStroke.getKeyStroke("ctrl shift P"));
        this.actionSelectBills.setEnabled(true);
        this.actionSelectBills.setVisible(true);
        this.btnObjectNumber.setEnabled(true);
        this.btnObjectNumber.setVisible(true);
        this.tblSeq.setEnabled(false);
        this.tblSeq.setVisible(false);
        this.actionCreateFrom.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionTDPrint.setVisible(false);
        this.actionTDPrintPreview.setVisible(false);
    }

    protected String getMaterialIDForView() {
        return null;
    }

    @Override
    protected IObjectValue createNewDetailData(KDTable table, IRow srcrow) {
        return null;
    }

    @Override
    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    @Override
    protected IObjectValue newInstanceData() throws EASBizException, BOSException {
        return null;
    }

    protected String getNumberByCoding(ScanTaskBillInfo info) {
        if (this.isAddView) {
            try {
                String number = CodingRuleUtils.getNumberByClient((IObjectValue)info, (String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
                if (number != null && !number.equals("")) {
                    return number;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void tableKeyReleased(KeyEvent e) {
        KDTable table;
        if (e.getKeyCode() == 27 && KDTableUtil.getSelectedRows((KDTable)(table = (KDTable)e.getSource())).length > 0) {
            table.getSelectManager().getBlocks().clear();
            table.repaint();
        }
    }

    protected boolean isValueNull(Object obj) {
        return obj == null || obj.toString().trim().equals("");
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("orgUnit.number");
        sic.add(new SelectorItemInfo("ChirdEntry.taskBill.id"));
        sic.add(new SelectorItemInfo("ChirdEntry.taskBill.id"));
        sic.add(new SelectorItemInfo("ChirdEntry.taskBill.number"));
        sic.add(new SelectorItemInfo("ChirdEntry.taskName"));
        sic.add(new SelectorItemInfo("ChirdEntry.taskObject"));
        sic.add(new SelectorItemInfo("ChirdEntry.taskOperator"));
        return sic;
    }

    @Override
    protected void prmttransactionType_dataChanged(DataChangeEvent e) throws Exception {
    }

    @Override
    public void actionSplitTask_actionPerformed(ActionEvent e) throws Exception {
        KDTable table = (KDTable)this.kdtpEntry.getSelectedComponent();
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmSplit()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            String scanQtyFiled = this.getScanOrSrcQtyFiled(table, false, true);
            ArrayList<String> idList = new ArrayList<String>();
            HashMap<String, BigDecimal> splitMap = new HashMap<String, BigDecimal>();
            HashMap<String, String> checkSrcBillMap = new HashMap<String, String>();
            HashMap<String, String> billIDMap = new HashMap<String, String>();
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                if (table.getRow(rowIndex).getCell(TB_SPLITQTY) == null || table.getRow(rowIndex).getCell(TB_SPLITQTY).getValue() == null) continue;
                BigDecimal splitQty = new BigDecimal(table.getRow(rowIndex).getCell(TB_SPLITQTY).getValue().toString());
                if (splitQty.compareTo(BigDecimal.ZERO) > 0) {
                    String srcBillEntryid = table.getRow(rowIndex).getCell(TB_SRCBILLENTRYID).getValue().toString();
                    String srcBillid = table.getRow(rowIndex).getCell(TB_SRCBILLID).getValue().toString();
                    String billId = table.getRow(rowIndex).getCell(TB_ID).getValue().toString();
                    if (!checkSrcBillMap.containsKey(srcBillid)) {
                        checkSrcBillMap.put(srcBillid, srcBillid);
                        idList.add(srcBillid);
                    }
                    billIDMap.put(srcBillEntryid, billId);
                    splitMap.put(srcBillEntryid, splitQty);
                    continue;
                }
                MsgBox.showInfo((Component)((Object)this), (String)BarcodeClientUtils.getBarcodeResource("spiltQtyISZREO"));
                return;
            }
            HashMap<String, ScanTaskBillInfo> argumentMap = new HashMap<String, ScanTaskBillInfo>();
            argumentMap.put("mainTaskBill", this.editData);
            ScanTaskBillInfo billInfo = null;
            try {
                billInfo = ScanTaskBillFactory.getRemoteInstance().splitTaskBill(argumentMap);
                if (billInfo == null) {
                    return;
                }
                this.showAsplirtUI(idList, splitMap, scanQtyFiled, billIDMap, billInfo);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                billInfo = null;
            }
        }
    }

    protected boolean confirmSplit() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)"\u662f\u5426\u8981\u62c6\u5206\u626b\u63cf\u4efb\u52a1\uff1f"));
    }

    public void showAsplirtUI(List<String> idList, Map<String, BigDecimal> splitMap, String scanQtyFiled, Map<String, String> billIDMap, ScanTaskBillInfo billInfo) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"InitDataObject", (Object)billInfo);
        uiContext.put((Object)"splitMap", splitMap);
        uiContext.put((Object)"idList", idList);
        uiContext.put((Object)"scanQtyFiled", (Object)scanQtyFiled);
        uiContext.put((Object)"billIDMap", billIDMap);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, "SPLIT");
        uiWindow.show();
    }

    protected TransactionTypeInfo getOnlyOneTransactionType(String billTypeID, String bizTypeID) throws EASBizException, BOSException {
        return InvCommonUtils.getDefaultTransactionType(null, (String)billTypeID, (String)bizTypeID);
    }
}

