/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.client;

public abstract class SchedThreadBase {
    protected static final long NEVER = Long.MAX_VALUE;
    private final Object lock = new Object();
    private Thread thread;
    private boolean active = true;
    private long nextTime;
    private boolean status = false;
    private long internal = 0L;

    protected abstract long getNextTime();

    protected abstract void executeWork();

    protected String getName() {
        return this.getClass().getName();
    }

    protected boolean getStatus() {
        return this.status;
    }

    protected void setInternal(long value) {
        this.internal = value;
    }

    public void start() {
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                SchedThreadBase.this.runInternal();
            }
        }, this.getName());
        this.status = true;
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.status = false;
            this.active = false;
            this.lock.notify();
        }
        this.thread.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void workAdded(long time) {
        Object object = this.lock;
        synchronized (object) {
            if (time < this.nextTime) {
                this.lock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInternal() {
        block9: while (true) {
            try {
                while (true) {
                    Object object = this.lock;
                    synchronized (object) {
                        this.nextTime = this.getNextTime();
                        long interval = this.nextTime - System.currentTimeMillis();
                        if (interval > 0L) {
                            try {
                                this.lock.wait(interval);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (!this.active) {
                            break block9;
                        }
                    }
                    this.executeWork();
                }
            }
            catch (Throwable t) {
                try {
                    this.status = false;
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
    }
}

