/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.IIndubarodeParamset;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetCollection;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetFactory;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetInfo;
import com.kingdee.eas.barcode.scm.util.ResourceUtil;
import com.kingdee.eas.base.form.ide.utils.EntityObjectInfoHelp;
import com.kingdee.eas.basedata.scm.common.ITransactionType;
import com.kingdee.eas.basedata.scm.common.RIEnum;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.DataDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;

public class BarcodeClientUtils {
    public static final Color necessaryColor = new Color(252, 251, 223);
    public static final Color lockedColor = new Color(217, 217, 208);
    public static final String DEFAULT_BARCODECONFIG = "defaultBarcodeConfig";
    public static final String DEFAULT_Entity = "defaultEntity";
    public static final String DEFAULT_IndBarcodeSetup = "defaultIndBarcodeSetup";
    public static final String DEFAULT_Rule = "defaultRule";

    public static Object getSingleCellValue(ICell cell, PropertyInfo property) {
        Object value = cell.getValue();
        if (value == null) {
            return null;
        }
        String dataType = property.getString("dataType");
        if (property instanceof LinkPropertyInfo) {
            if (value instanceof IObjectValue) {
                return ((IObjectValue)value).get("number");
            }
            return value;
        }
        if ("Enum".equals(dataType)) {
            return ((Enum)value).getName();
        }
        if ("Boolean".equals(dataType)) {
            return value;
        }
        if ("Date".equals(dataType)) {
            String result = null;
            try {
                result = BarcodeUtils.SIMPLE_DATE_FORMAT.format(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }
        if ("TimeStamp".equals(dataType)) {
            String result = null;
            try {
                result = BarcodeUtils.SIMPLE_TIMESTAMP_FORMAT.format(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }
        if ("BigDecimal".equals(dataType)) {
            BigDecimal result = null;
            try {
                result = new BigDecimal(value.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }
        if ("Integer".equals(dataType)) {
            Integer result = null;
            try {
                result = Integer.parseInt(value.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }
        return value;
    }

    public static Object getSingleValue(Object value, PropertyInfo property) {
        if (value == null || "".equals(value)) {
            return null;
        }
        String dataType = property.getString("dataType");
        if (property instanceof LinkPropertyInfo) {
            if (value instanceof IObjectValue) {
                return ((IObjectValue)value).get("number");
            }
            return value;
        }
        if ("Enum".equals(dataType)) {
            return ((Enum)value).getName();
        }
        if ("Boolean".equals(dataType)) {
            return value;
        }
        if ("Date".equals(dataType)) {
            String result = null;
            try {
                result = BarcodeUtils.SIMPLE_DATE_FORMAT.format(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }
        if ("TimeStamp".equals(dataType)) {
            String result = null;
            try {
                result = BarcodeUtils.SIMPLE_TIMESTAMP_FORMAT.format(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }
        if ("BigDecimal".equals(dataType)) {
            BigDecimal result = null;
            try {
                result = new BigDecimal(value.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }
        if ("Integer".equals(dataType)) {
            Integer result = null;
            try {
                result = Integer.parseInt(value.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }
        return value;
    }

    public static void loadSingleColumn(IColumn column, PropertyInfo property) {
        column.getStyleAttributes().setLocked(false);
        String dataType = property.getString("dataType");
        if (property instanceof LinkPropertyInfo) {
            KDBizPromptBox f7 = null;
            EntityObjectInfo tempEntity = ((LinkPropertyInfo)property).getRelationship().getSupplierObject();
            String defaultF7 = tempEntity.getExtendedProperty("defaultF7Query");
            if (defaultF7 != null) {
                f7 = new KDBizPromptBox();
                f7.setVisible(true);
                f7.setEditable(true);
                f7.setDisplayFormat("$number$");
                f7.setEditFormat("$number$");
                f7.setCommitFormat("$number$");
                KDTDefaultCellEditor object_CellEditor = new KDTDefaultCellEditor((IKDEditor)f7);
                column.setEditor((ICellEditor)object_CellEditor);
                ObjectValueRender avr = new ObjectValueRender();
                avr.setFormat((IDataFormat)new BizDataFormat(f7.getDisplayFormatter().toString()));
                column.setRenderer((IBasicRender)avr);
                f7.setQueryInfo(defaultF7);
            }
        } else if ("Enum".equals(dataType)) {
            String enumClass = (String)property.get("metadataRef");
            if (enumClass != null) {
                List emList = EnumUtils.getEnumList((String)enumClass);
                KDComboBox kdComboBox = new KDComboBox(emList.toArray());
                kdComboBox.setUserObject((Object)emList);
                kdComboBox.setMaximumRowCount(10);
                KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JComboBox)kdComboBox);
                column.setEditor((ICellEditor)kdtDefaultCellEditor);
            }
        } else if ("Boolean".equals(dataType)) {
            KDCheckBox checkBox = new KDCheckBox();
            checkBox.setSelected(false);
            KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JCheckBox)checkBox);
            column.setEditor((ICellEditor)kdtDefaultCellEditor);
        } else if ("Date".equals(dataType)) {
            KDDatePicker datePicker = new KDDatePicker();
            KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor(datePicker);
            column.setEditor((ICellEditor)kdtDefaultCellEditor);
            column.getStyleAttributes().setLocked(false);
            column.getStyleAttributes().setNumberFormat("yyyy-MM-dd");
        } else if ("TimeStamp".equals(dataType)) {
            KDDatePicker datePicker = new KDDatePicker();
            datePicker.setTimeEnabled(true);
            KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor(datePicker);
            column.setEditor((ICellEditor)kdtDefaultCellEditor);
            column.getStyleAttributes().setLocked(false);
            column.getStyleAttributes().setNumberFormat("yyyy-MM-dd HH:mm:ss");
        } else if ("BigDecimal".equals(dataType)) {
            column.getStyleAttributes().setNumberFormat("0.00000000");
        }
    }

    public static void setSingleCellValue(ICell cell, PropertyInfo property, String value) {
        boolean isSetValue;
        String dataType = property.getString("dataType");
        boolean bl = isSetValue = value != null && !"".equals(value.trim());
        if ("Enum".equals(dataType)) {
            String enumClass = (String)property.get("metadataRef");
            List emList = EnumUtils.getEnumList((String)enumClass);
            if (isSetValue && enumClass != null) {
                cell.setValue(BarcodeUtils.getEnum(emList, value));
            }
        } else if ("Boolean".equals(dataType)) {
            if (isSetValue) {
                if ("1".equals(value) || "true".equalsIgnoreCase(value) || EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"82_BarcodeUtils").equals(value)) {
                    cell.setValue((Object)true);
                } else {
                    cell.setValue((Object)false);
                }
            }
        } else if ("Date".equals(dataType)) {
            if (isSetValue) {
                try {
                    Date date = BarcodeUtils.SIMPLE_DATE_FORMAT.parse(value);
                    cell.setValue((Object)date);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        } else if ("TimeStamp".equals(dataType)) {
            if (isSetValue) {
                try {
                    Date date = BarcodeUtils.SIMPLE_TIMESTAMP_FORMAT.parse(value);
                    cell.setValue((Object)date);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        } else if ("BigDecimal".equals(dataType)) {
            if (isSetValue) {
                try {
                    cell.setValue((Object)new BigDecimal(value));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    cell.setValue((Object)new BigDecimal("0.00000000"));
                }
            }
        } else if ("Integer".equals(dataType)) {
            if (isSetValue) {
                try {
                    cell.setValue((Object)Integer.parseInt(value));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    cell.setValue((Object)0);
                }
            }
        } else if (isSetValue) {
            cell.setValue((Object)value);
        }
    }

    public static void loadSingleCell(ICell cell, PropertyInfo property, String value) {
        block32: {
            boolean isPutValue;
            cell.getStyleAttributes().setLocked(false);
            String dataType = property.getString("dataType");
            boolean bl = isPutValue = value != null && !"".equals(value.trim());
            if (property instanceof LinkPropertyInfo) {
                KDBizPromptBox f7 = null;
                EntityObjectInfo tempEntity = ((LinkPropertyInfo)property).getRelationship().getSupplierObject();
                String defaultF7 = tempEntity.getExtendedProperty("defaultF7Query");
                if (defaultF7 != null) {
                    f7 = new KDBizPromptBox();
                    f7.setVisible(true);
                    f7.setEditable(true);
                    f7.setDisplayFormat("$number$");
                    f7.setEditFormat("$number$");
                    f7.setCommitFormat("$number$");
                    KDTDefaultCellEditor object_CellEditor = new KDTDefaultCellEditor((IKDEditor)f7);
                    cell.setEditor((ICellEditor)object_CellEditor);
                    ObjectValueRender avr = new ObjectValueRender();
                    avr.setFormat((IDataFormat)new BizDataFormat(f7.getDisplayFormatter().toString()));
                    cell.setRenderer((IBasicRender)avr);
                    f7.setQueryInfo(defaultF7);
                }
                if (isPutValue) {
                    try {
                        if (defaultF7 != null) {
                            IObjectValue tempObj = (IObjectValue)Class.forName(tempEntity.getObjectValueClassRuntime()).newInstance();
                            tempObj.put("number", (Object)value);
                            cell.setValue((Object)tempObj);
                            break block32;
                        }
                        cell.setValue((Object)value);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if ("Enum".equals(dataType)) {
                String enumClass = (String)property.get("metadataRef");
                if (enumClass != null) {
                    List emList = EnumUtils.getEnumList((String)enumClass);
                    KDComboBox kdComboBox = new KDComboBox(emList.toArray());
                    kdComboBox.setUserObject((Object)emList);
                    kdComboBox.setMaximumRowCount(10);
                    KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JComboBox)kdComboBox);
                    cell.setEditor((ICellEditor)kdtDefaultCellEditor);
                    if (isPutValue) {
                        cell.setValue(BarcodeUtils.getEnum(emList, value));
                    }
                }
            } else if ("Boolean".equals(dataType)) {
                KDCheckBox checkBox = new KDCheckBox();
                checkBox.setSelected(false);
                KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JCheckBox)checkBox);
                cell.setEditor((ICellEditor)kdtDefaultCellEditor);
                cell.setValue((Object)false);
                if (isPutValue) {
                    if ("1".equals(value) || "true".equalsIgnoreCase(value) || EASResource.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"82_BarcodeUtils").equals(value)) {
                        checkBox.setSelected(true);
                        cell.setValue((Object)true);
                    } else {
                        cell.setValue((Object)false);
                    }
                }
            } else if ("Date".equals(dataType) || "TimeStamp".equals(dataType)) {
                KDDatePicker datePicker = new KDDatePicker();
                KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor(datePicker);
                cell.setEditor((ICellEditor)kdtDefaultCellEditor);
                cell.getStyleAttributes().setLocked(false);
                cell.getStyleAttributes().setNumberFormat("yyyy-MM-dd");
                cell.setValue(null);
                if (isPutValue) {
                    try {
                        Date date = BarcodeUtils.SIMPLE_DATE_FORMAT.parse(value);
                        cell.setValue((Object)date);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            } else if ("BigDecimal".equals(dataType)) {
                if (isPutValue) {
                    try {
                        cell.setValue((Object)new BigDecimal(value));
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        cell.setValue((Object)new BigDecimal("0.00"));
                    }
                }
            } else if ("Integer".equals(dataType)) {
                if (isPutValue) {
                    try {
                        cell.setValue((Object)Integer.parseInt(value));
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        cell.setValue((Object)0);
                    }
                }
            } else if (isPutValue) {
                cell.setValue((Object)value);
            }
        }
    }

    public static String getBarcodeResource(String key) {
        return ResourceUtil.getResource("com.kingdee.eas.barcode.scm.IndBarcodeResource", key);
    }

    public static String getFormatPattern(int scale, boolean takeOutZero) {
        if (takeOutZero) {
            String pattern = null;
            String temp = "#############";
            String scaleStr = temp.substring(0, scale);
            pattern = scale == 0 ? "%{#,##0}f" : "%{#,##0." + scaleStr + "}f";
            return pattern;
        }
        return BarcodeClientUtils.getFormatPattern(scale);
    }

    public static String getFormatPattern(int scale) {
        String pattern = null;
        String temp = "000000000000000000";
        String end = temp.substring(0, scale);
        pattern = scale == 0 ? "#,##0" : "#,##0." + end;
        pattern = pattern + ";-" + pattern + ";";
        return pattern;
    }

    public static int getInOrOutBill(Context ctx, String bosType, String transferNumber) {
        if (transferNumber == null) {
            EntityObjectInfo entity = EntityObjectInfoHelp.getEntity((BOSObjectType)BOSObjectType.create((String)bosType));
            String bizClsName = entity.getFullName();
            if ("com.kingdee.eas.scm.im.inv.app.ManufactureRecBill".equals(bizClsName) || "com.kingdee.eas.scm.im.inv.app.MoveInWarehsBill".equals(bizClsName) || "com.kingdee.eas.scm.im.inv.app.OtherInWarehsBill".equals(bizClsName) || "com.kingdee.eas.scm.im.inv.app.PurInWarehsBill".equals(bizClsName)) {
                return 2;
            }
            if ("com.kingdee.eas.scm.im.inv.app.MaterialReqBill".equals(bizClsName) || "com.kingdee.eas.scm.im.inv.app.MoveIssueBill".equals(bizClsName) || "com.kingdee.eas.scm.im.inv.app.SaleIssueBill".equals(bizClsName) || "com.kingdee.eas.scm.im.inv.app.OtherIssueBill".equals(bizClsName)) {
                return 3;
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection seleCol = new SelectorItemCollection();
        seleCol.add(new SelectorItemInfo("id"));
        seleCol.add(new SelectorItemInfo("number"));
        seleCol.add(new SelectorItemInfo("name"));
        seleCol.add(new SelectorItemInfo("riType.dataDirection"));
        seleCol.add(new SelectorItemInfo("riType.bizDirection"));
        seleCol.add(new SelectorItemInfo("riType.*"));
        view.setSelector(seleCol);
        FilterInfo transfilterInfo = new FilterInfo();
        transfilterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)transferNumber));
        view.setFilter(transfilterInfo);
        TransactionTypeInfo typeInfo = null;
        try {
            ITransactionType iTransactionType = null;
            iTransactionType = ctx == null ? TransactionTypeFactory.getRemoteInstance() : TransactionTypeFactory.getLocalInstance((Context)ctx);
            TransactionTypeCollection tyleCol = iTransactionType.getTransactionTypeCollection(view);
            if (tyleCol.size() > 0) {
                typeInfo = tyleCol.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (typeInfo == null) {
            return 1;
        }
        if (typeInfo != null) {
            if (DataDirectionEnum.positive.equals((Object)typeInfo.getRiType().getDataDirection()) && RIEnum.Receive.equals((Object)typeInfo.getRiType().getRI()) || DataDirectionEnum.navitive.equals((Object)typeInfo.getRiType().getDataDirection()) && RIEnum.Issue.equals((Object)typeInfo.getRiType().getRI())) {
                return 2;
            }
            if (DataDirectionEnum.positive.equals((Object)typeInfo.getRiType().getDataDirection()) && RIEnum.Issue.equals((Object)typeInfo.getRiType().getRI()) || DataDirectionEnum.navitive.equals((Object)typeInfo.getRiType().getDataDirection()) && RIEnum.Receive.equals((Object)typeInfo.getRiType().getRI())) {
                return 3;
            }
        }
        return 0;
    }

    public static IndubarodeParamsetInfo getParamValue(Context ctx) throws BOSException {
        IIndubarodeParamset iIndubarodeParamset = null;
        iIndubarodeParamset = ctx == null ? IndubarodeParamsetFactory.getRemoteInstance() : IndubarodeParamsetFactory.getLocalInstance(ctx);
        IndubarodeParamsetCollection paramCol = iIndubarodeParamset.getIndubarodeParamsetCollection();
        if (paramCol != null && paramCol.get(0) != null) {
            IndubarodeParamsetInfo indParasetInfo = paramCol.get(0);
            return indParasetInfo;
        }
        return new IndubarodeParamsetInfo();
    }

    public static String getParamValueStr(Context ctx) throws BOSException {
        IndubarodeParamsetCollection paramCol = IndubarodeParamsetFactory.getLocalInstance(ctx).getIndubarodeParamsetCollection();
        String paramValue = "0";
        if (paramCol != null && paramCol.get(0) != null) {
            IndubarodeParamsetInfo indParasetInfo = paramCol.get(0);
            if (indParasetInfo.isBusinessBarcode()) {
                paramValue = "0";
            } else if (indParasetInfo.isIndBarcode()) {
                paramValue = "1";
            } else if (indParasetInfo.isPriorBusiness()) {
                paramValue = "3";
            } else if (indParasetInfo.isPriorInd()) {
                paramValue = "4";
            }
        }
        return paramValue;
    }

    public static String getIndBarcodeMasterEntry(Context ctx, String masterId, String fname) {
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" select fid,CFName from CT_IND_IndBarcodeMasterEntry").append("\t\n");
        selectSql.append(" where fparentid='").append(masterId).append("'").append("\t\n");
        selectSql.append(" and  CFName='").append(fname).append("'").append("\t\n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            if (rs.next()) {
                return rs.getString("fid");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void checkDateControl() {
        Date date = new Date();
        try {
            IndubarodeParamsetInfo indubarodeParamsetInfo = BarcodeClientUtils.getParamValue(null);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            if (indubarodeParamsetInfo.getExpDate() == null) {
                MsgBox.showWarning((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u65f6\u95f4\u63a7\u5236\uff01");
                SysUtil.abort();
            } else if (indubarodeParamsetInfo.getExpDate().compareTo(sdf.parse("2000-01-01")) != 0) {
                if (indubarodeParamsetInfo.getExpDate().getTime() < date.getTime()) {
                    MsgBox.showWarning((String)"\u4f7f\u7528\u65f6\u95f4\u5df2\u5230\u671f\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                    SysUtil.abort();
                } else {
                    long daysBetween = (indubarodeParamsetInfo.getExpDate().getTime() - date.getTime() + 1000000L) / 86400000L;
                    if (daysBetween <= (long)indubarodeParamsetInfo.getDays()) {
                        MsgBox.showInfo((String)("\u8ddd\u4f7f\u7528\u65f6\u95f4\u8fd8\u6709" + daysBetween + "\u5929\uff01"));
                    }
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

