/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.scm.BarcodeDossierCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierFactory;
import com.kingdee.eas.barcode.scm.BarcodeDossierInfo;
import com.kingdee.eas.barcode.scm.BarcodeInventoryCollection;
import com.kingdee.eas.barcode.scm.BarcodeInventoryFactory;
import com.kingdee.eas.barcode.scm.BarcodeInventoryInfo;
import com.kingdee.eas.barcode.scm.BarcodeOfDateMinCollection;
import com.kingdee.eas.barcode.scm.BarcodeOfDateMinInfo;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.BarcodeWSException;
import com.kingdee.eas.barcode.scm.IBarcodeInventory;
import com.kingdee.eas.barcode.scm.IIndBarcodeBack;
import com.kingdee.eas.barcode.scm.IIndubarodeParamset;
import com.kingdee.eas.barcode.scm.IndBarcodeBackCollection;
import com.kingdee.eas.barcode.scm.IndBarcodeBackFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeBackInfo;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetCollection;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetFactory;
import com.kingdee.eas.barcode.scm.IndubarodeParamsetInfo;
import com.kingdee.eas.barcode.scm.PositionInfo;
import com.kingdee.eas.barcode.scm.app.BarcodeServerUtils;
import com.kingdee.eas.barcode.scm.util.BarcodeInvDateInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IssuePriorityEnum;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateCollection;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.framework.UseStatusEnum;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BarcodeInvServerUtils {
    public static BarcodeInventoryCollection getInventoryCollectionForCalculateLot(Context ctx, String souID, String materialID, String warehouseID, String locationID, IssuePriorityEnum issuePriority) throws BOSException {
        BarcodeInventoryCollection barcodeInventoryCollection;
        Connection conn = null;
        PreparedStatement preStmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("select inv.FStorageOrgUnitID as souID, ").append("\n");
            sql.append("inv.FMaterialID as materialID, ").append("\n");
            sql.append("inv.FWarehouseID as warehouseID, ").append("\n");
            sql.append("warehouse.fname_l2 as warehouseName, ").append("\n");
            sql.append("warehouse.fnumber as warehouseNumber, ").append("\n");
            sql.append("inv.FLocationID as locationID, ").append("\n");
            sql.append("location.fname_l2 as locationName, ").append("\n");
            sql.append("location.fNumber as locationNumber, ").append("\n");
            sql.append("inv.FPositionID as positionID, ").append("\n");
            sql.append("position.fname_l2 as positionName, ").append("\n");
            sql.append("position.fNumber as positionNumber, ").append("\n");
            sql.append("inv.FLot as lot, ").append("\n");
            sql.append("sum(dom.FQty) as qty,  ").append("\n");
            sql.append("dom.FInWarehouseDate, ").append("\n");
            sql.append("inv.fid as id ").append("\n");
            sql.append("from T_IND_BarcodeInventory inv  ").append("\n");
            sql.append("left join T_DB_WAREHOUSE warehouse on  warehouse.fid=inv.FWarehouseID").append("\n");
            sql.append("left join T_DB_LOCATION  location on  location.fid=inv.FLocationID").append("\n");
            sql.append("left join CT_SCM_Position  position on  position.fid=inv.FPositionID").append("\n");
            sql.append("left outer join T_IND_BarcodeOfDateMin dom   on  inv.FID=dom.FBInventoryID").append("\n\t");
            sql.append(" where inv.FStorageOrgUnitID = '").append(souID).append("'").append("\n\t");
            sql.append(" and inv.FMaterialID = '").append(materialID).append("'").append("\n\t");
            if (warehouseID != null) {
                sql.append(" and inv.FWarehouseID = '").append(warehouseID).append("'").append("\n\t");
            }
            if (locationID != null) {
                sql.append(" and inv.FLocationID = '").append(locationID).append("'").append("\n\t");
            }
            sql.append(" and dom.FQty > 0 and inv.FLot is not null ").append("\n\t");
            sql.append("group by inv.FStorageOrgUnitID,inv.FMaterialID,inv.FWarehouseID").append("\n\t");
            sql.append(",warehouse.fname_l2,warehouse.fnumber,inv.FLocationID,location.fname_l2").append("\n\t");
            sql.append(",location.fNumber ,inv.FPositionID,position.fname_l2,position.fNumber").append("\n\t");
            sql.append(",inv.FLot,inv.fid ,dom.FInWarehouseDate").append("\n\t");
            if (issuePriority != null) {
                switch (issuePriority.getValue()) {
                    case 1: {
                        sql.append(" order by inv.FLot asc");
                        break;
                    }
                    case 2: {
                        sql.append(" order by dom.FInWarehouseDate,inv.FLot asc,warehouse.fnumber asc ");
                        break;
                    }
                    case 3: {
                        sql.append(" order by dom.FInWarehouseDate desc,inv.FLot asc");
                        break;
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        sql.append(" order by dom.FInWarehouseDate,inv.FLot asc ,warehouse.fnumber asc");
                        break;
                    }
                }
            } else {
                sql.append(" order by dom.FInWarehouseDate,inv.FLot asc ,warehouse.fnumber asc");
            }
            preStmt = conn.prepareStatement(sql.toString());
            rs = preStmt.executeQuery();
            BarcodeInventoryCollection coll = new BarcodeInventoryCollection();
            HashMap<String, BarcodeInventoryInfo> barcodeInvMap = new HashMap<String, BarcodeInventoryInfo>();
            BarcodeInventoryInfo info = null;
            while (rs.next()) {
                info = new BarcodeInventoryInfo();
                StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
                sou.setId(BOSUuid.read((String)rs.getString("souID")));
                info.setStorageOrgUnit(sou);
                MaterialInfo material = new MaterialInfo();
                material.setId(BOSUuid.read((String)rs.getString("materialID")));
                info.setMaterial(material);
                if (rs.getString("warehouseID") != null) {
                    WarehouseInfo warehouse = new WarehouseInfo();
                    warehouse.setId(BOSUuid.read((String)rs.getString("warehouseID")));
                    warehouse.setName(rs.getString("warehouseName"));
                    warehouse.setNumber(rs.getString("warehouseNumber"));
                    info.setWarehouse(warehouse);
                }
                if (rs.getString("locationID") != null) {
                    LocationInfo location = new LocationInfo();
                    location.setId(BOSUuid.read((String)rs.getString("locationID")));
                    location.setName(rs.getString("locationName"));
                    location.setNumber(rs.getString("locationNumber"));
                    info.setLocation(location);
                }
                if (rs.getString("positionID") != null) {
                    PositionInfo positionInfo = new PositionInfo();
                    positionInfo.setId(BOSUuid.read((String)rs.getString("positionID")));
                    positionInfo.setName(rs.getString("positionName"));
                    positionInfo.setNumber(rs.getString("positionNumber"));
                    info.setPosition(positionInfo);
                }
                info.setLot(rs.getString("lot"));
                info.setCurStoreQty(new BigDecimal(rs.getBigDecimal("qty").stripTrailingZeros().toPlainString()));
                String key = rs.getString("id");
                info.setId(BOSUuid.read((String)rs.getString("id")));
                if (barcodeInvMap.containsKey(key)) {
                    BarcodeInventoryInfo barcodeInvInfo = (BarcodeInventoryInfo)barcodeInvMap.get(key);
                    info.setCurStoreQty(info.getCurStoreQty().add(barcodeInvInfo.getCurStoreQty()));
                    barcodeInvMap.put(key, info);
                    continue;
                }
                barcodeInvMap.put(key, info);
            }
            for (String key : barcodeInvMap.keySet()) {
                coll.add((BarcodeInventoryInfo)barcodeInvMap.get(key));
            }
            barcodeInventoryCollection = coll;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, preStmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)preStmt, (Connection)conn);
        return barcodeInventoryCollection;
    }

    public static BarcodeInventoryCollection getBarcodeInventoryCol(Context ctx, String barcode, String materialId, String warehouseID, String locationID, String positionId, String lot) throws BOSException {
        BarcodeInventoryCollection barcodeInventoryCollection;
        Connection conn = null;
        PreparedStatement preStmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("select inv.FStorageOrgUnitID as souID, ").append("\n");
            sql.append("inv.FBarcode as barcode, ").append("\n");
            sql.append("inv.FMaterialID as materialID, ").append("\n");
            sql.append("inv.FWarehouseID as warehouseID, ").append("\n");
            sql.append("warehouse.fname_l2 as warehouseName, ").append("\n");
            sql.append("warehouse.fnumber as warehouseNumber, ").append("\n");
            sql.append("inv.FLocationID as locationID, ").append("\n");
            sql.append("location.fname_l2 as locationName, ").append("\n");
            sql.append("location.fNumber as locationNumber, ").append("\n");
            sql.append("inv.FPositionID as positionID, ").append("\n");
            sql.append("position.fname_l2 as positionName, ").append("\n");
            sql.append("position.fNumber as positionNumber, ").append("\n");
            sql.append("inv.FLot as lot, ").append("\n");
            sql.append("inv.FCurStoreQty as FCurStoreQty, ").append("\n");
            sql.append("inv.FLockQty as FLockQty, ").append("\n");
            sql.append("inv.fid as id ").append("\n");
            sql.append("from T_IND_BarcodeInventory inv  ").append("\n");
            sql.append("left join T_DB_WAREHOUSE warehouse on  warehouse.fid=inv.FWarehouseID").append("\n");
            sql.append("left join T_DB_LOCATION  location on  location.fid=inv.FLocationID").append("\n");
            sql.append("left join CT_SCM_Position  position on  position.fid=inv.FPositionID").append("\n");
            sql.append(" where inv.FMaterialID = '").append(materialId).append("'").append("\n\t");
            if (barcode != null) {
                sql.append(" and inv.FBarcode = '").append(barcode).append("'").append("\n\t");
            }
            if (warehouseID != null) {
                sql.append(" and inv.FWarehouseID = '").append(warehouseID).append("'").append("\n\t");
            }
            if (locationID != null) {
                sql.append(" and inv.FLocationID = '").append(locationID).append("'").append("\n\t");
            } else {
                sql.append(" and inv.FLocationID  is null").append("\n\t");
            }
            if (positionId != null) {
                sql.append(" and inv.FPositionID = '").append(positionId).append("'").append("\n\t");
            } else {
                sql.append(" and inv.FPositionID  is null").append("\n\t");
            }
            if (lot != null) {
                sql.append(" and inv.Flot = '").append(lot).append("'").append("\n\t");
            } else {
                sql.append(" and inv.Flot  is null").append("\n\t");
            }
            preStmt = conn.prepareStatement(sql.toString());
            rs = preStmt.executeQuery();
            BarcodeInventoryCollection coll = new BarcodeInventoryCollection();
            BarcodeInventoryInfo info = null;
            while (rs.next()) {
                info = new BarcodeInventoryInfo();
                StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
                sou.setId(BOSUuid.read((String)rs.getString("souID")));
                info.setStorageOrgUnit(sou);
                MaterialInfo material = new MaterialInfo();
                material.setId(BOSUuid.read((String)rs.getString("materialID")));
                info.setMaterial(material);
                if (rs.getString("warehouseID") != null) {
                    WarehouseInfo warehouse = new WarehouseInfo();
                    warehouse.setId(BOSUuid.read((String)rs.getString("warehouseID")));
                    warehouse.setName(rs.getString("warehouseName"));
                    warehouse.setNumber(rs.getString("warehouseNumber"));
                    info.setWarehouse(warehouse);
                }
                if (rs.getString("locationID") != null) {
                    LocationInfo location = new LocationInfo();
                    location.setId(BOSUuid.read((String)rs.getString("locationID")));
                    location.setName(rs.getString("locationName"));
                    location.setNumber(rs.getString("locationNumber"));
                    info.setLocation(location);
                }
                if (rs.getString("positionID") != null) {
                    PositionInfo positionInfo = new PositionInfo();
                    positionInfo.setId(BOSUuid.read((String)rs.getString("positionID")));
                    positionInfo.setName(rs.getString("positionName"));
                    positionInfo.setNumber(rs.getString("positionNumber"));
                    info.setPosition(positionInfo);
                }
                info.setLot(rs.getString("lot"));
                if (rs.getBigDecimal("FCurStoreQty") != null) {
                    info.setCurStoreQty(new BigDecimal(rs.getBigDecimal("FCurStoreQty").stripTrailingZeros().toPlainString()));
                } else {
                    info.setCurStoreQty(BigDecimal.ZERO);
                }
                if (rs.getBigDecimal("FLockQty") != null) {
                    info.setLockQty(new BigDecimal(rs.getBigDecimal("FLockQty").stripTrailingZeros().toPlainString()));
                } else {
                    info.setLockQty(BigDecimal.ZERO);
                }
                info.setId(BOSUuid.read((String)rs.getString("id")));
                coll.add(info);
            }
            barcodeInventoryCollection = coll;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, preStmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)preStmt, (Connection)conn);
        return barcodeInventoryCollection;
    }

    public List<BarcodeInvDateInfo> buildBarcodeInventoryInfo(Context ctx, IObjectValue value, BatchActionEnum actionName) throws BOSException, EASBizException {
        ArrayList<BarcodeInvDateInfo> barcodeDateList = new ArrayList<BarcodeInvDateInfo>();
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        if (value instanceof InvBillBaseInfo) {
            Map<String, IndBarcodeBackCollection> indbarcodeMap = this.getIndBarcodeBackCol(ctx, value, actionName);
            if (indbarcodeMap.size() == 0) {
                return barcodeDateList;
            }
            IObjectCollection entries = (IObjectCollection)value.get("entry");
            StorageOrgUnitInfo orgUnitInfo = (StorageOrgUnitInfo)value.get("storageOrgUnit");
            TransactionTypeInfo typeInfo = (TransactionTypeInfo)value.get("transactionType");
            if (typeInfo == null) {
                return barcodeDateList;
            }
            if (typeInfo.getNumber() == null) {
                typeInfo = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(typeInfo.getId()));
            }
            int invType = BarcodeServerUtils.getInOrOutBill((Context)ctx, null, (String)typeInfo.getNumber());
            HashMap<String, BarcodeInvDateInfo> barcodeIndDateMap = new HashMap<String, BarcodeInvDateInfo>();
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                IObjectValue entryInfo = entries.getObject(i);
                if (entryInfo.get("id") == null) {
                    throw new EASBizException(new NumericExceptionSubItem("", "\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u518d\u63d0\u4ea4\uff01"));
                }
                String fid = entryInfo.get("id").toString();
                if (!indbarcodeMap.containsKey(fid)) continue;
                BigDecimal qty = (BigDecimal)entryInfo.get("qty");
                IndBarcodeBackCollection backCol = indbarcodeMap.get(fid);
                MaterialInfo materialInfo = (MaterialInfo)entryInfo.get("material");
                materialInfo = iMaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()));
                PositionInfo positionInfo = entryInfo.get("position") != null ? (PositionInfo)entryInfo.get("position") : null;
                WarehouseInfo warehouseInfo = (WarehouseInfo)entryInfo.get("warehouse");
                LocationInfo locationInfo = (LocationInfo)entryInfo.get("location");
                String lot = (String)entryInfo.get("lot");
                BigDecimal totalBarcode = BigDecimal.ZERO;
                int m = backCol.size();
                for (int j = 0; j < m; ++j) {
                    BarcodeOfDateMinInfo barcodeOfDateInfo;
                    IndBarcodeBackInfo backInfo = backCol.get(j);
                    StringBuffer invkey = new StringBuffer();
                    invkey.append(materialInfo.getId());
                    if (warehouseInfo != null) {
                        invkey.append(warehouseInfo.getId());
                    }
                    if (locationInfo != null) {
                        invkey.append(locationInfo.getId());
                    }
                    if (positionInfo != null) {
                        invkey.append(positionInfo.getId());
                    }
                    if (lot != null) {
                        invkey.append(lot);
                    }
                    if (backInfo.getName() != null) {
                        invkey.append(backInfo.getName());
                    }
                    BarcodeInvDateInfo barcodeInvDateInfo = null;
                    if (barcodeIndDateMap.containsKey(invkey.toString())) {
                        barcodeInvDateInfo = (BarcodeInvDateInfo)barcodeIndDateMap.get(invkey.toString());
                    }
                    if (barcodeInvDateInfo == null) {
                        barcodeInvDateInfo = new BarcodeInvDateInfo();
                    }
                    BarcodeInventoryInfo barcodeInventoryInfo = null;
                    if (barcodeInvDateInfo.getBarcodeInventoryInfo() != null) {
                        barcodeInventoryInfo = barcodeInvDateInfo.getBarcodeInventoryInfo();
                    }
                    if (barcodeInventoryInfo == null) {
                        barcodeInventoryInfo = new BarcodeInventoryInfo();
                        barcodeInventoryInfo.setMaterial(materialInfo);
                        barcodeInventoryInfo.setStorageOrgUnit(orgUnitInfo);
                        barcodeInventoryInfo.setWarehouse(warehouseInfo);
                        barcodeInventoryInfo.setLocation(locationInfo);
                        barcodeInventoryInfo.setPosition(positionInfo);
                        barcodeInventoryInfo.setLot(lot);
                        barcodeInventoryInfo.setBarcode(backInfo.getName());
                        barcodeInventoryInfo.setCurStoreQty(BigDecimal.ZERO);
                    }
                    BarcodeOfDateMinCollection barcodeDateMinCol = barcodeInvDateInfo.getBarcodeDateMinCol();
                    if (2 == invType) {
                        if (actionName.equals((Object)BatchActionEnum.AUDIT)) {
                            barcodeOfDateInfo = new BarcodeOfDateMinInfo();
                            barcodeOfDateInfo.setBarcode(backInfo.getName());
                            barcodeOfDateInfo.setInWarehouseDate(this.getTime());
                            barcodeOfDateInfo.setLot(lot);
                            barcodeOfDateInfo.setBarcodeInventory(barcodeInventoryInfo);
                            barcodeDateMinCol.add(barcodeOfDateInfo);
                            barcodeOfDateInfo.setCreateTime(this.getTime());
                            barcodeOfDateInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                            barcodeInventoryInfo.setCurStoreQty(barcodeInventoryInfo.getCurStoreQty().add(backInfo.getBarcodeQty()));
                            barcodeOfDateInfo.setQty(backInfo.getBarcodeQty());
                        }
                        if (actionName.equals((Object)BatchActionEnum.UNAUDIT)) {
                            barcodeInventoryInfo.setCurStoreQty(barcodeInventoryInfo.getCurStoreQty().add(backInfo.getBarcodeQty().negate()));
                            barcodeInvDateInfo.setKoujian(true);
                        }
                    } else {
                        if (actionName.equals((Object)BatchActionEnum.AUDIT)) {
                            barcodeInvDateInfo.setKoujian(true);
                            barcodeInventoryInfo.setCurStoreQty(barcodeInventoryInfo.getCurStoreQty().add(backInfo.getBarcodeQty().negate()));
                        }
                        if (actionName.equals((Object)BatchActionEnum.UNAUDIT)) {
                            barcodeInvDateInfo.setKoujian(false);
                            barcodeInventoryInfo.setCurStoreQty(barcodeInventoryInfo.getCurStoreQty().add(backInfo.getBarcodeQty()));
                            barcodeOfDateInfo = new BarcodeOfDateMinInfo();
                            barcodeOfDateInfo.setBarcode(backInfo.getName());
                            barcodeOfDateInfo.setInWarehouseDate(this.getTime());
                            barcodeOfDateInfo.setLot(lot);
                            barcodeOfDateInfo.setBarcodeInventory(barcodeInventoryInfo);
                            barcodeDateMinCol.add(barcodeOfDateInfo);
                            barcodeOfDateInfo.setCreateTime(this.getTime());
                            barcodeOfDateInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                            barcodeOfDateInfo.setQty(backInfo.getBarcodeQty());
                        }
                    }
                    barcodeInventoryInfo.setLockQty(BigDecimal.ZERO);
                    barcodeInvDateInfo.setBarcodeInventoryInfo(barcodeInventoryInfo);
                    barcodeInvDateInfo.setBarcodeDateMinCol(barcodeDateMinCol);
                    barcodeIndDateMap.put(invkey.toString(), barcodeInvDateInfo);
                    totalBarcode = totalBarcode.add(backInfo.getBarcodeQty().abs());
                }
                if (qty.abs().compareTo(totalBarcode.abs()) == 0) continue;
                if (materialInfo.getName() == null) {
                    materialInfo = iMaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()));
                }
                throw new BarcodeWSException(BarcodeWSException.QTYNOTE, new String[]{materialInfo.getName()});
            }
            for (String key : barcodeIndDateMap.keySet()) {
                barcodeDateList.add((BarcodeInvDateInfo)barcodeIndDateMap.get(key));
            }
        }
        return barcodeDateList;
    }

    public IndubarodeParamsetInfo getParamsetInfo() {
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            String selectorAll = System.getProperty("selector.all");
            if (StringUtils.isEmpty((String)selectorAll)) {
                selectorAll = "true";
            }
            sic.add(new SelectorItemInfo("indBarcode"));
            sic.add(new SelectorItemInfo("priorBusiness"));
            sic.add(new SelectorItemInfo("businessBarcode"));
            sic.add(new SelectorItemInfo("priorInd"));
            sic.add(new SelectorItemInfo("barcodeInv"));
            sic.add(new SelectorItemInfo("barcodeLot"));
            sic.add(new SelectorItemInfo("description"));
            sic.add(new SelectorItemInfo("status"));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setSelector(sic);
            IndubarodeParamsetCollection paramCol = IndubarodeParamsetFactory.getRemoteInstance().getIndubarodeParamsetCollection(viewInfo);
            if (paramCol.size() > 0) {
                return paramCol.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return new IndubarodeParamsetInfo();
    }

    private Map<String, IndBarcodeBackCollection> getIndBarcodeBackCol(Context ctx, IObjectValue value, BatchActionEnum actionName) throws BOSException, EASBizException {
        int i;
        IIndBarcodeBack iIndBarcodeBack = null;
        iIndBarcodeBack = ctx == null ? IndBarcodeBackFactory.getRemoteInstance() : IndBarcodeBackFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getSelectors());
        FilterInfo filterInfo = new FilterInfo();
        String number = value.get("number").toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("num", (Object)number, CompareType.EQUALS));
        view.setFilter(filterInfo);
        IndBarcodeBackCollection indbarcodeBackCol = iIndBarcodeBack.getIndBarcodeBackCollection(view);
        HashMap<String, IndBarcodeBackCollection> indbarcodeMap = new HashMap<String, IndBarcodeBackCollection>();
        if (indbarcodeBackCol.size() == 0) {
            return indbarcodeMap;
        }
        if (indbarcodeBackCol.size() != 0 || actionName.equals((Object)BizActionEnum.AUDIT)) {
            // empty if block
        }
        StringBuffer barcodeStr = new StringBuffer();
        int size = indbarcodeBackCol.size();
        for (int i2 = 0; i2 < size; ++i2) {
            IndBarcodeBackInfo indBarcodeInfo = indbarcodeBackCol.get(i2);
            String barcode = indBarcodeInfo.getName();
            if (barcodeStr.length() > 0) {
                barcodeStr.append(",").append(barcode);
                continue;
            }
            barcodeStr.append(barcode);
        }
        view = new EntityViewInfo();
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)barcodeStr.toString()));
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("number"));
        coll.add(new SelectorItemInfo("batchNumber"));
        view.setSelector(coll);
        view.setFilter(filterInfo);
        BarcodeDossierCollection barcodeCol = BarcodeDossierFactory.getLocalInstance(ctx).getBarcodeDossierCollection(view);
        HashMap<String, String> barcodeLotMap = new HashMap<String, String>();
        int size2 = barcodeCol.size();
        for (i = 0; i < size2; ++i) {
            BarcodeDossierInfo barcodeDossierInfo = barcodeCol.get(i);
            String key = barcodeDossierInfo.getNumber();
            String mapvalue = barcodeDossierInfo.getBatchNumber();
            if (barcodeLotMap.containsKey(key) || mapvalue == null) continue;
            barcodeLotMap.put(key, mapvalue);
        }
        size2 = indbarcodeBackCol.size();
        for (i = 0; i < size2; ++i) {
            IndBarcodeBackCollection indbarcodeCol;
            String rownumid;
            IndBarcodeBackInfo indBarcodeInfo = indbarcodeBackCol.get(i);
            if (barcodeLotMap.containsKey(indBarcodeInfo.getName())) {
                indBarcodeInfo.setLot((String)barcodeLotMap.get(indBarcodeInfo.getName()));
            }
            if (indbarcodeMap.containsKey(rownumid = indBarcodeInfo.getRowNum())) {
                indbarcodeCol = (IndBarcodeBackCollection)((Object)indbarcodeMap.get(rownumid));
                indbarcodeCol.add(indBarcodeInfo);
                indbarcodeMap.put(rownumid, indbarcodeCol);
                continue;
            }
            indbarcodeCol = new IndBarcodeBackCollection();
            indbarcodeCol.add(indBarcodeInfo);
            indbarcodeMap.put(rownumid, indbarcodeCol);
        }
        return indbarcodeMap;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        String selectorAll = System.getProperty("selector.all");
        if (StringUtils.isEmpty((String)selectorAll)) {
            selectorAll = "true";
        }
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("billType.name"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("num"));
        sic.add(new SelectorItemInfo("rowNum"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("barcodeQty"));
        return sic;
    }

    public void updateBarcodeInventrory(Context ctx, BatchActionEnum bizAction, IObjectValue value, String bosType) throws BOSException, EASBizException {
        if (!BarcodeInvServerUtils.isBarcodeInv(ctx)) {
            return;
        }
        this.updateBarcodeInventrory(ctx, value, bizAction);
    }

    public void updateBarcodeInventrory(Context ctx, IObjectValue value, BatchActionEnum actionName) throws BOSException, EASBizException {
        List<BarcodeInvDateInfo> barcodeInventoryCol = this.buildBarcodeInventoryInfo(ctx, value, actionName);
        if (barcodeInventoryCol.size() == 0) {
            return;
        }
        IBarcodeInventory iBarcodeInventory = null;
        iBarcodeInventory = ctx == null ? BarcodeInventoryFactory.getRemoteInstance() : BarcodeInventoryFactory.getLocalInstance(ctx);
        iBarcodeInventory.updateBarcodeInv(barcodeInventoryCol);
    }

    public void pipeiBarcodeToRow(Context ctx, IObjectValue value) throws BOSException, EASBizException {
    }

    private Map<String, String> checkBarcodeInv(Context ctx, IObjectValue model) throws BOSException, SQLException, EASBizException {
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select billentry.fid from ").append(this.getEntryEntityObjectInfo(ctx, model, "entry")).append(" billentry").append("\t\n");
        selectSql.append("inner join   ").append(this.getMainTableName(ctx, model)).append("  bill on  bill.FID=billentry.FParentID ").append("\t\n");
        selectSql.append("inner join t_bd_material material on material.fid=billentry.fmaterialid").append("\t\n");
        selectSql.append(" inner join T_BD_MaterialInventory inventory on inventory.fmaterialID=material.fid and inventory.forgUnit=bill.FStorageOrgUnitID").append("\t\n");
        selectSql.append("where bill.FNumber='").append(model.get("number")).append("'").append("\t\n");
        selectSql.append("and material.CFSuit=0").append("\t\n");
        selectSql.append(" and inventory.FIsBarcode=1").append("\t\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        HashMap<String, String> entryFidMap = new HashMap<String, String>();
        while (rs.next()) {
            String fid = rs.getString("fid");
            if (entryFidMap.containsKey(fid)) continue;
            entryFidMap.put(fid, fid);
        }
        return entryFidMap;
    }

    private TransactionTypeInfo getTransactionTypeInfo(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        TransactionTypeInfo transactionInfo = null;
        if (model.get("transactionType") != null && (transactionInfo = (TransactionTypeInfo)model.get("transactionType")).getId() != null && transactionInfo.getNumber() != null) {
            transactionInfo = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(transactionInfo.getId()));
        }
        if (transactionInfo == null) {
            throw new EASBizException(new NumericExceptionSubItem("", "\u4e8b\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25\uff01"));
        }
        return transactionInfo;
    }

    private CoreBaseCollection getIndBarcodeBackCol(Context ctx, IObjectValue model, boolean isPipei) throws EASBizException, BOSException {
        CoreBaseCollection indbarcodeBackCol = new CoreBaseCollection();
        StringBuffer selectSql = new StringBuffer();
        TransactionTypeInfo transactionInfo = this.getTransactionTypeInfo(ctx, model);
        int barcodeState = BarcodeServerUtils.getInOrOutBill((Context)ctx, (String)model.getBOSType().toString(), (String)transactionInfo.getNumber());
        selectSql.append("select distinct billentry.FMaterialID materialID,dossier.CFBatchNumber batchNumber,dossier.FNumber barcode").append("\t\n");
        selectSql.append(",billentry.fid entryfid,billentry.fqty entryQty").append("\t\n");
        selectSql.append("from CT_IND_BarcodeDossier dossier").append("\t\n");
        selectSql.append("inner join ").append(this.getEntryEntityObjectInfo(ctx, model, "entry")).append(" billentry  on dossier.CFMaterialID=billentry.FMaterialID and dossier.CFBatchNumber=billentry.FLot").append("\t\n");
        selectSql.append("inner join   ").append(this.getMainTableName(ctx, model)).append("  bill on  bill.FID=billentry.FParentID ").append("\t\n");
        selectSql.append(" inner join T_BD_Material material on material.fid=dossier.CFMaterialID").append("\t\n");
        selectSql.append(" inner join T_BD_MaterialInventory inventory on inventory.fmaterialID=material.fid and inventory.forgUnit=bill.FStorageOrgUnitID").append("\t\n");
        selectSql.append("where bill.FNumber='").append(model.get("number")).append("'").append("\t\n");
        selectSql.append(" and inventory.FIsBarcode=1").append("\t\n");
        selectSql.append("order by dossier.CFBatchNumber,dossier.FNumber").append("\t\n");
        HashMap<String, BigDecimal> entryFidQtyMap = new HashMap<String, BigDecimal>();
        StringBuffer barcodeStr = new StringBuffer();
        CoreBaseCollection barcodeOfDateMinCol = new CoreBaseCollection();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            while (rs.next()) {
                String barcode = rs.getString("barcode");
                String entryFid = rs.getString("entryfid");
                BigDecimal entryQty = rs.getBigDecimal("entryQty");
                if (entryFidQtyMap.containsKey(entryFid)) continue;
                IndBarcodeBackInfo indBarcodeBackInfo = new IndBarcodeBackInfo();
                indBarcodeBackInfo.setNum(model.get("number").toString());
                indBarcodeBackInfo.setName(barcode);
                indBarcodeBackInfo.setBarcodeQty(entryQty.abs());
                indBarcodeBackInfo.setBillType((BillTypeInfo)model.get("billType"));
                indBarcodeBackInfo.setBizDate(new Date());
                indBarcodeBackInfo.setBizType((BizTypeInfo)model.get("BizType"));
                indBarcodeBackInfo.setRowNum(entryFid);
                indbarcodeBackCol.add((CoreBaseInfo)indBarcodeBackInfo);
                if (entryFidQtyMap.containsKey(entryFid)) {
                    BigDecimal totalEntryQty = (BigDecimal)entryFidQtyMap.get(entryFid);
                    totalEntryQty = totalEntryQty.add(entryQty);
                    entryFidQtyMap.put(entryFid, entryQty);
                } else {
                    entryFidQtyMap.put(entryFid, entryQty);
                }
                if (barcodeStr.length() > 0) {
                    barcodeStr.append("','").append(barcode);
                    continue;
                }
                barcodeStr.append(barcode);
            }
            Map<String, String> entryFidMap = this.checkBarcodeInv(ctx, model);
            if (entryFidQtyMap.size() != entryFidMap.size()) {
                throw new EASBizException(new NumericExceptionSubItem("", "\u627e\u4e0d\u5230\u76f8\u5e94\u5206\u5f55\u5bf9\u5e94\u7684\u6761\u7801\uff0c\u64cd\u4f5c\u5931\u8d25\uff01"));
            }
            IIndBarcodeBack iIndBarcodeBack = null;
            iIndBarcodeBack = ctx == null ? IndBarcodeBackFactory.getRemoteInstance() : IndBarcodeBackFactory.getLocalInstance(ctx);
            String number = model.get("number").toString();
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(this.getSelectors());
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("num", (Object)number, CompareType.EQUALS));
            view.setFilter(filterInfo);
            IndBarcodeBackCollection isExstsBackCol = iIndBarcodeBack.getIndBarcodeBackCollection(view);
            if (isExstsBackCol.size() == 0) {
                iIndBarcodeBack.saveBatchData(indbarcodeBackCol);
                StringBuffer updateSql = new StringBuffer();
                updateSql.append("update CT_IND_BarcodeDossier set CFIsScan=").append(1);
                updateSql.append(" ,CFBarcodeState=").append(barcodeState).append("\n");
                updateSql.append(" where fnumber in('").append(barcodeStr).append("')");
                DbUtil.execute((Context)ctx, (String)updateSql.toString());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return indbarcodeBackCol;
    }

    public String getMainTableName(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (model == null) {
            return null;
        }
        IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        IMetaDataPK pk = imeataLoader.getEntityObjectPK(model.getBOSType());
        EntityObjectInfo entityObjectInfo = imeataLoader.getEntity(pk);
        DataTableInfo tableInfo = entityObjectInfo.getTable();
        String tableName = tableInfo.getName();
        return tableName;
    }

    private String getEntryEntityObjectInfo(Context ctx, IObjectValue model, String entryName) {
        IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        IMetaDataPK pk = imeataLoader.getEntityObjectPK(model.getBOSType());
        EntityObjectInfo billEntity = imeataLoader.getEntity(pk);
        HashMap<String, EntityObjectInfo> bosTypeMap = new HashMap<String, EntityObjectInfo>();
        PropertyCollection pyColl = billEntity.getEntityProperties();
        for (int i = 0; i < pyColl.size(); ++i) {
            PropertyInfo property = pyColl.get(i);
            if (property.getName().equalsIgnoreCase("ID") || !BarcodeUtils.isEntryProperty(billEntity, property)) continue;
            RelationshipInfo relation = ((LinkPropertyInfo)property).getRelationship();
            String bosType = relation.getSupplierObject().getType().toString();
            EntityObjectInfo entryEntity = BarcodeUtils.getEntityByBosType(bosType);
            bosTypeMap.put(property.getName(), entryEntity);
            DataTableInfo tableInfo = entryEntity.getTable();
            if (!entryName.equalsIgnoreCase(property.getName())) continue;
            return tableInfo.getName();
        }
        return null;
    }

    public void deleteIndBarcodeBack(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IIndBarcodeBack iIndBarcodeBack = null;
        iIndBarcodeBack = ctx == null ? IndBarcodeBackFactory.getRemoteInstance() : IndBarcodeBackFactory.getLocalInstance(ctx);
        String number = model.get("number").toString();
        TransactionTypeInfo transactionTypeInfo = this.getTransactionTypeInfo(ctx, model);
        BarcodeDossierFactory.getLocalInstance(ctx).updateBarcodeStatus(number, 3, model.getBOSType().toString(), transactionTypeInfo.getNumber());
        StringBuffer deleteStr = new StringBuffer();
        deleteStr.append("delete from T_IND_BarcodeOfDateMin where fbarcode in  (").append("\t\n");
        deleteStr.append(" select fname_l2 from CT_IND_IndBarcodeBack where ").append("\t\n");
        deleteStr.append(" cfnum in('").append(number).append("'))").append("\t\n");
        DbUtil.execute((Context)ctx, (String)deleteStr.toString());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("num", (Object)number));
        iIndBarcodeBack.delete(filter);
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(date);
        Timestamp createtime = null;
        try {
            createtime = new Timestamp(formatter.parse(dateString).getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return createtime;
    }

    private Date getMonthTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
        String dateString = formatter.format(date);
        Date createtime = null;
        try {
            return formatter.parse(dateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return createtime;
        }
    }

    public IndubarodeParamsetInfo getParamsetInfo(Context ctx) {
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            String selectorAll = System.getProperty("selector.all");
            if (StringUtils.isEmpty((String)selectorAll)) {
                selectorAll = "true";
            }
            sic.add(new SelectorItemInfo("indBarcode"));
            sic.add(new SelectorItemInfo("priorBusiness"));
            sic.add(new SelectorItemInfo("businessBarcode"));
            sic.add(new SelectorItemInfo("priorInd"));
            sic.add(new SelectorItemInfo("barcodeInv"));
            sic.add(new SelectorItemInfo("barcodeLot"));
            sic.add(new SelectorItemInfo("description"));
            sic.add(new SelectorItemInfo("status"));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setSelector(sic);
            IndubarodeParamsetCollection paramCol = IndubarodeParamsetFactory.getLocalInstance(ctx).getIndubarodeParamsetCollection(viewInfo);
            if (paramCol.size() > 0) {
                return paramCol.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return new IndubarodeParamsetInfo();
    }

    public StoreStateCollection getStoreStateCol(Context ctx) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)UseStatusEnum.ACTIVE));
        viewInfo.setFilter(filter);
        return StoreStateFactory.getLocalInstance((Context)ctx).getStoreStateCollection(viewInfo);
    }

    public static boolean isBarcodeInv(Context ctx) throws BOSException {
        IIndubarodeParamset iIndubarodeParamset = null;
        iIndubarodeParamset = ctx == null ? IndubarodeParamsetFactory.getRemoteInstance() : IndubarodeParamsetFactory.getLocalInstance(ctx);
        IndubarodeParamsetCollection paramCol = iIndubarodeParamset.getIndubarodeParamsetCollection();
        if (paramCol != null && paramCol.get(0) != null) {
            IndubarodeParamsetInfo indParasetInfo = paramCol.get(0);
            return indParasetInfo.isBarcodeInv();
        }
        return false;
    }
}

