/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.barcode.scm.IndBarcodeBackInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreFlagEnum;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.im.inv.IMaterialSNInventory;
import com.kingdee.eas.scm.im.inv.IMaterialSerialNumber;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryCollection;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryFactory;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryInfo;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberCollection;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberFactory;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberInfo;
import com.kingdee.eas.scm.im.inv.SerialNumberStatusEnum;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SerialNumberHelper {
    private static final String resFile = "com.kingdee.eas.scm.im.inv.MaterialSNResource";
    private static final String INM190 = "INM190";
    private static final String INM200 = "INM200";
    private static final String INM210 = "INM210";
    private static final String INM220 = "INM220";
    private static final String INM230 = "INM230";

    private boolean isSerialNumberManger(Context ctx, String souID, InvUpdateTypeInfo invUpdateTypeInfo, MeasureUnitInfo unit, MaterialInfo material) throws EASBizException, BOSException {
        if (material == null || material.getId() == null) {
            return false;
        }
        MaterialInventoryInfo inwentoryInfo = ctx != null ? MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(material.getId().toString(), souID) : MaterialInventoryFactory.getRemoteInstance().getInventoryInfo(material.getId().toString(), souID);
        boolean isSerialNumber = inwentoryInfo.isIsSequenceNo();
        return this.isNeedCheckSN(invUpdateTypeInfo) && isSerialNumber && material != null && material.getSeqUnit() != null && unit != null && unit.getId().equals((Object)material.getSeqUnit().getId());
    }

    protected boolean isNeedCheckSN(InvUpdateTypeInfo invUpdateTypeInfo) {
        boolean needCheck = true;
        if (invUpdateTypeInfo != null && invUpdateTypeInfo.isIsNotUpdateInv()) {
            return false;
        }
        return needCheck;
    }

    public void saveSerialNumberOfBarcode(Context ctx, IObjectValue value, CoreBaseCollection barcodeBack, String entryName, String entryBosType, Map<String, List<CoreBaseInfo>> entryIdBarcodeMap) throws Exception {
        if (value instanceof InvBillBaseInfo) {
            IMaterialSerialNumber iMaterialSerialNumber;
            IObjectCollection destColl = (IObjectCollection)value.get(entryName);
            MaterialSerialNumberCollection snInfoList = new MaterialSerialNumberCollection();
            int size = destColl.size();
            for (int i = 0; i < size; ++i) {
                IObjectValue entryValue = destColl.getObject(i);
                MaterialSerialNumberInfo snInfo = this.createSerialNumberInfo(ctx, value, entryValue, entryIdBarcodeMap);
                if (snInfo == null) continue;
                snInfoList.add(snInfo);
            }
            IMaterialSerialNumber iMaterialSerialNumber2 = iMaterialSerialNumber = ctx != null ? MaterialSerialNumberFactory.getLocalInstance((Context)ctx) : MaterialSerialNumberFactory.getRemoteInstance();
            if (snInfoList.size() > 0) {
                for (int i = 0; i < snInfoList.size(); ++i) {
                    iMaterialSerialNumber.saveSerialNumber(snInfoList.get(i));
                }
            }
        }
    }

    public MaterialSerialNumberInfo createSerialNumberInfo(Context ctx, IObjectValue value, IObjectValue entryValue, Map<String, List<CoreBaseInfo>> entryIdBarcodeMap) throws Exception {
        BigDecimal baseQty;
        MaterialSerialNumberInfo snInfo = new MaterialSerialNumberInfo();
        HashMap hm = this.getQueryCondition(ctx, (InvBillBaseInfo)value, entryValue);
        StorageOrgUnitInfo aStorageOrgUnitInfo = (StorageOrgUnitInfo)hm.get("STORAGEORGUNIT");
        String souid = aStorageOrgUnitInfo.getId().toString();
        InvUpdateTypeInfo invUpdateTypeInfo = (InvUpdateTypeInfo)hm.get("INVUPDATETYPE");
        snInfo.setStorageOrgUnit(aStorageOrgUnitInfo);
        MaterialInfo material = (MaterialInfo)hm.get("MATERIAL");
        MeasureUnitInfo abaseUnitInfo = (MeasureUnitInfo)hm.get("BASEUNIT");
        IMaterial iMaterial = ctx != null ? MaterialFactory.getLocalInstance((Context)ctx) : MaterialFactory.getRemoteInstance();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("seqUnit.number"));
        sic.add(new SelectorItemInfo("seqUnit.name"));
        material = iMaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(material.getId()), sic);
        MeasureUnitInfo sNUnitInfo = material.getSeqUnit();
        if (sNUnitInfo == null) {
            return null;
        }
        boolean isSerialNumber = this.isSerialNumberManger(ctx, souid, invUpdateTypeInfo, abaseUnitInfo, material);
        if (!isSerialNumber) {
            return null;
        }
        BigDecimal billEntryQty = baseQty = (BigDecimal)hm.get("BASEQTY");
        if (!abaseUnitInfo.equals((Object)sNUnitInfo.getId().toString())) {
            billEntryQty = SerialNumberHelper.getAssUnitQty(ctx, sNUnitInfo, material, baseQty);
        }
        billEntryQty = billEntryQty.abs();
        int snSize = billEntryQty.intValue();
        snInfo.setBillID(value.get("id").toString());
        String entryid = entryValue.get("id").toString();
        snInfo.setBillEntryID(entryid);
        Boolean isReversed = (Boolean)hm.get("isReversed");
        snInfo.setIsReversed(isReversed.booleanValue());
        String sourceBillID = (String)hm.get("SOUREBILLID");
        snInfo.setSoureBillID(sourceBillID);
        String sourceBillEntryID = (String)hm.get("SOURCEBILLENTRYID");
        snInfo.setSoureBillEntryID(sourceBillEntryID);
        SerialNumberStatusEnum status = (SerialNumberStatusEnum)hm.get("snStatus");
        if (status != null) {
            snInfo.setSnStatus(status);
        }
        String billTypeid = (String)hm.get("BILLTYPE");
        BillTypeInfo aBillTypeInfo = new BillTypeInfo();
        aBillTypeInfo.setId(BOSUuid.read((String)billTypeid));
        snInfo.setBillType(aBillTypeInfo);
        snInfo.setBillNumber(value.get("number").toString());
        String entrySeq = (String)hm.get("BILLENTRYSEQ");
        if (!StringUtil.isEmpty((String)entrySeq)) {
            snInfo.setBillEntrySeq(Integer.valueOf(entrySeq).intValue());
        } else {
            snInfo.setBillEntrySeq(0);
        }
        snInfo.setMaterial(material);
        snInfo.setSnUnit(sNUnitInfo);
        snInfo.setSnQty(billEntryQty);
        boolean isCheckSerialNumber = true;
        if (value instanceof InvBillBaseInfo) {
            InvBillBaseInfo invBill = (InvBillBaseInfo)value;
            String orgid = invBill.getStorageOrgUnit().getId().toString();
            String billTypeID = invBill.getBillType().getId().toString();
            isCheckSerialNumber = this.getParamValue(orgid, billTypeID);
        }
        MaterialSerialNumberEntryCollection entryColl = snInfo.getEntry();
        List<CoreBaseInfo> coreBaseInfoList = entryIdBarcodeMap.get(entryid);
        for (int j = 0; j < coreBaseInfoList.size(); ++j) {
            MaterialSerialNumberEntryInfo entryInfo = new MaterialSerialNumberEntryInfo();
            IndBarcodeBackInfo barcodeBackInfo = (IndBarcodeBackInfo)coreBaseInfoList.get(j);
            entryInfo.setSeq(j);
            entryInfo.setSerialNumber(barcodeBackInfo.getName());
            if (isCheckSerialNumber) {
                SerialNumberHelper.checkSNIsExist4Submit(ctx, barcodeBackInfo.getName(), material.getId().toString(), (InvBillBaseEntryInfo)entryValue);
            }
            entryColl.add(entryInfo);
        }
        return snInfo;
    }

    protected HashMap getQueryCondition(Context ctx, InvBillBaseInfo editData, IObjectValue entryValue) throws Exception {
        TrackNumberInfo trackNumberInfo;
        ProjectInfo projectInfo;
        MeasureUnitInfo measureUnit;
        LocationInfo location;
        WarehouseInfo warehouse;
        AsstAttrValueInfo asstAttrValueInfo;
        TransactionTypeInfo transactionTypeInfo;
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("isView", false);
        if (editData.getStorageOrgUnit() != null) {
            hm.put("STORAGEORGUNIT", editData.getStorageOrgUnit());
        }
        if (editData.getTransactionType() != null) {
            hm.put("TRANSACTIONTYPE", editData.getTransactionType());
        }
        hm.put("TABLEHASFOCUS", true);
        String billTypeID = editData.getBillType().getId().toString();
        if (!editData.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD) && editData != null && editData.getId() != null) {
            hm.put("BILL", editData);
            if (editData.getBillType() != null) {
                hm.put("BILLTYPE", billTypeID);
            }
        }
        String inORout = "";
        if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-0157c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-0167c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-0172c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-017bc0a812fd463ED552".equals(billTypeID)) {
            inORout = "in";
        } else if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-016ec0a812fd463ED552".equals(billTypeID) || "50957179-0105-1000-e000-0177c0a812fd463ED552".equals(billTypeID)) {
            inORout = "out";
        }
        String entryId = entryValue.get("id").toString();
        hm.put("BILLENTRYID", entryId);
        hm.put("BILLENTRYSEQ", entryValue.get("seq").toString());
        StoreTypeInfo storeTypeInfo = null;
        StoreStateInfo storeStateInfo = null;
        InvUpdateTypeInfo invUpdateTypeInfo = null;
        if (entryValue.get("invUpdateType") != null && (invUpdateTypeInfo = (InvUpdateTypeInfo)entryValue.get("invUpdateType")) != null) {
            if ("in".equals(inORout)) {
                storeTypeInfo = invUpdateTypeInfo.getStoreType();
                storeStateInfo = invUpdateTypeInfo.getStoreState();
            } else if ("out".equals(inORout)) {
                storeTypeInfo = invUpdateTypeInfo.getStoreTypePre();
                storeStateInfo = invUpdateTypeInfo.getStoreStatePre();
            }
        }
        hm.put("INVUPDATETYPE", invUpdateTypeInfo);
        if (storeTypeInfo != null) {
            hm.put("STORETYPE", storeTypeInfo.getId().toString());
        }
        if (storeStateInfo != null) {
            hm.put("STORESTATE", storeStateInfo.getId().toString());
        }
        if (storeTypeInfo == null && storeStateInfo == null && editData.getTransactionType() != null && (transactionTypeInfo = editData.getTransactionType()) != null) {
            Map map = SCMBaseCommonUtil.getTranAllStoreTypeAndState((Context)ctx, (String)transactionTypeInfo.getId().toString(), (String)inORout);
            List storeTypeList = (List)map.get("STORETYPE");
            List storeStateList = (List)map.get("STORESTATE");
            hm.put("STORETYPE", storeTypeList);
            hm.put("STORESTATE", storeStateList);
        }
        if (entryValue.get("material") != null) {
            MaterialInfo material = (MaterialInfo)entryValue.get("material");
            hm.put("MATERIAL", material);
        }
        if (entryValue.get("assistProperty") != null && (asstAttrValueInfo = (AsstAttrValueInfo)entryValue.get("assistProperty")) != null) {
            hm.put("ASSISTANTATTR", asstAttrValueInfo.getId().toString());
        }
        if (entryValue.get("lot") != null) {
            String lot = (String)entryValue.get("lot");
            hm.put("BATCH", lot);
        }
        if (entryValue.get("warehouse") != null && (warehouse = (WarehouseInfo)entryValue.get("warehouse")) != null) {
            hm.put("WAREHOUSE", warehouse.getId().toString());
        }
        if (entryValue.get("location") != null && (location = (LocationInfo)entryValue.get("location")) != null) {
            hm.put("LOCATION", location.getId().toString());
        }
        if (entryValue.get("unit") != null && (measureUnit = (MeasureUnitInfo)entryValue.get("unit")) != null) {
            hm.put("UNIT", measureUnit.getId().toString());
        }
        if (entryValue.get("baseUnit") != null && (measureUnit = (MeasureUnitInfo)entryValue.get("baseUnit")) != null) {
            hm.put("BASEUNIT", measureUnit);
        }
        BigDecimal baseQty = BigDecimal.ZERO;
        if (entryValue.get("baseQty") != null) {
            baseQty = (BigDecimal)entryValue.get("baseQty");
            hm.put("BASEQTY", baseQty);
        }
        if (entryValue.get("project") != null && (projectInfo = (ProjectInfo)entryValue.get("project")) != null) {
            hm.put("PROJECT", projectInfo.getId().toString());
        }
        if (entryValue.get("trackNumber") != null && (trackNumberInfo = (TrackNumberInfo)entryValue.get("trackNumber")) != null) {
            hm.put("TRACKNUM", trackNumberInfo.getId().toString());
        }
        SupplierInfo supplierInfo = null;
        CustomerInfo customerInfo = null;
        if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeID)) {
            if (editData.get("supplier") != null) {
                supplierInfo = (SupplierInfo)editData.get("supplier");
            }
            if (entryValue.get("customer") != null) {
                customerInfo = (CustomerInfo)entryValue.get("customer");
            }
        } else if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeID)) {
            if (entryValue.get("supplier") != null) {
                supplierInfo = (SupplierInfo)entryValue.get("supplier");
            }
            if (editData.get("customer") != null) {
                customerInfo = (CustomerInfo)editData.get("customer");
            }
        } else if ("50957179-0105-1000-e000-0157c0a812fd463ED552".equals(billTypeID)) {
            if (editData.get("supplier") != null) {
                supplierInfo = (SupplierInfo)editData.get("supplier");
            }
            if (editData.get("customer") != null) {
                customerInfo = (CustomerInfo)editData.get("customer");
            }
        } else {
            if (entryValue.get("supplier") != null) {
                supplierInfo = (SupplierInfo)entryValue.get("supplier");
            }
            if (entryValue.get("customer") != null) {
                customerInfo = (CustomerInfo)entryValue.get("customer");
            }
        }
        if (storeTypeInfo != null && supplierInfo != null && (StoreFlagEnum.SUPPLIER.equals((Object)storeTypeInfo.getStoreFlag()) || StoreFlagEnum.TOSUPPLIER.equals((Object)storeTypeInfo.getStoreFlag()))) {
            hm.put("SUPPLIER", supplierInfo.getId().toString());
        }
        if (storeTypeInfo != null && customerInfo != null && (StoreFlagEnum.CUSTOMER.equals((Object)storeTypeInfo.getStoreFlag()) || StoreFlagEnum.TOCUSTOMER.equals((Object)storeTypeInfo.getStoreFlag()))) {
            hm.put("CUSTOMER", customerInfo.getId().toString());
        }
        hm.put("isReversed", editData.isIsReversed());
        SerialNumberStatusEnum snStatus = null;
        if ("528d806a-0106-1000-e000-0194c0a812e6463ED552".equals(billTypeID)) {
            snStatus = SerialNumberStatusEnum.INWAREHOUSE;
        } else {
            TransactionTypeInfo tti = editData.getTransactionType();
            boolean isNagetive = baseQty.signum() == -1;
            snStatus = InvCommonUtils.getSnStatusByTranType((TransactionTypeInfo)tti, (InvUpdateTypeInfo)invUpdateTypeInfo, (boolean)isNagetive);
        }
        hm.put("snStatus", snStatus);
        return hm;
    }

    public static BigDecimal getAssUnitQty(Context ctx, MeasureUnitInfo mui, MaterialInfo mi, BigDecimal baseQty) throws BaseException {
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal assQty = BigDecimal.ZERO;
        if (baseQty != null) {
            assQty = baseQty;
        } else {
            baseQty = assQty;
        }
        MultiMeasureUnitInfo mulUnit = SerialNumberHelper.getMulUnit(ctx, mui, mi);
        if (mulUnit != null) {
            coefficient = mulUnit.getBaseConvsRate();
            int precision = mulUnit.getQtyPrecision();
            if (coefficient != null) {
                assQty = baseQty.divide(coefficient, precision, 4);
            }
        } else {
            assQty = BigDecimal.ZERO;
        }
        return assQty;
    }

    public static MultiMeasureUnitInfo getMulUnit(Context ctx, MeasureUnitInfo mui, MaterialInfo mi) throws BaseException {
        IMultiMeasureUnit immu;
        MultiMeasureUnitInfo mulUnit = null;
        IMultiMeasureUnit iMultiMeasureUnit = immu = ctx != null ? MultiMeasureUnitFactory.getLocalInstance((Context)ctx) : MultiMeasureUnitFactory.getRemoteInstance();
        if (mui != null && mi != null) {
            mulUnit = immu.getMultiUnit(mi.getId().toString(), mui.getId().toString());
        }
        return mulUnit;
    }

    public static void checkSNIsExist4Submit(Context ctx, String serialNumber, String materialID, InvBillBaseEntryInfo entryInfo) throws BOSException {
        StringBuffer errorMsg = new StringBuffer();
        EntityViewInfo cview = new EntityViewInfo();
        FilterInfo cfilter = new FilterInfo();
        cfilter.getFilterItems().add(new FilterItemInfo("serialNumber", (Object)serialNumber, CompareType.EQUALS));
        cfilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID, CompareType.EQUALS));
        cview.setFilter(cfilter);
        IMaterialSNInventory iMaterialSNInventory = null;
        iMaterialSNInventory = ctx != null ? MaterialSNInventoryFactory.getLocalInstance((Context)ctx) : MaterialSNInventoryFactory.getRemoteInstance();
        MaterialSNInventoryCollection sniColl = iMaterialSNInventory.getMaterialSNInventoryCollection(cview);
        if (sniColl == null || sniColl.size() == 0) {
            errorMsg.append(EASResource.getString((String)resFile, (String)"SERIALNUMBER_ISEXIST", (Object[])new Object[]{entryInfo.getSeq(), entryInfo.getMaterial().getName(), serialNumber})).append("\n");
            return;
        }
        MaterialSNInventoryInfo sniInfo = sniColl.get(0);
        if (sniInfo.getSnStatus() == SerialNumberStatusEnum.INWAREHOUSE || sniInfo.getSnStatus() == SerialNumberStatusEnum.OUTTHENIN) {
            errorMsg.append(EASResource.getString((String)resFile, (String)"SERIALNUMBER_INWAREHOUSE", (Object[])new Object[]{entryInfo.getSeq(), entryInfo.getMaterial().getName(), serialNumber})).append("\n");
            if (errorMsg.length() > 0) {
                MsgBox.showWarning((String)errorMsg.toString());
                SysUtil.abort();
            }
            return;
        }
        if (sniInfo.getSnStatus() != SerialNumberStatusEnum.SALE) {
            errorMsg.append(EASResource.getString((String)resFile, (String)"SERIALNUMBER_ISEXIST", (Object[])new Object[]{entryInfo.getSeq(), entryInfo.getMaterial().getName(), serialNumber})).append("\n");
        }
        if (errorMsg.length() > 0) {
            MsgBox.showWarning((String)errorMsg.toString());
            SysUtil.abort();
        }
    }

    private boolean getParamValue(String orgid, String billTypeID) throws EASBizException, BOSException {
        String paramName = this.getParamNameByBillTypeID(billTypeID);
        if (StringUtils.isEmpty((String)paramName)) {
            return false;
        }
        String paramValue = SCMUtil.getInvParamValue(null, (String)orgid, (String)paramName);
        return paramName != null && paramValue != null && ("true".equalsIgnoreCase(paramValue.trim()) || "1".equalsIgnoreCase(paramValue.trim()));
    }

    private String getParamNameByBillTypeID(String billTypeID) {
        if (billTypeID.equals("50957179-0105-1000-e000-015fc0a812fd463ED552")) {
            return INM190;
        }
        if (billTypeID.equals("50957179-0105-1000-e000-0167c0a812fd463ED552")) {
            return INM200;
        }
        if (billTypeID.equals("50957179-0105-1000-e000-017bc0a812fd463ED552")) {
            return INM210;
        }
        if (billTypeID.equals("50957179-0105-1000-e000-0172c0a812fd463ED552")) {
            return INM220;
        }
        if (billTypeID.equals("50957179-0105-1000-e000-0157c0a812fd463ED552")) {
            return INM230;
        }
        return null;
    }
}

