/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal;

import com.kingdee.eas.scm.cal.AbstractRecentCostInfo;
import com.kingdee.eas.scm.cal.PriceSourEnum;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class RecentCostInfo
extends AbstractRecentCostInfo
implements Serializable {
    private ArrayList combitionList;
    private BigDecimal totalCombitionCost = CalculateUtil.ZERO;
    private BigDecimal totalCombitionQty = CalculateUtil.ZERO;
    private int combitionSize = 0;
    private ArrayList moveInbillList;
    private ArrayList moveBillList;
    private ArrayList redBillList;
    private ArrayList balanceList;
    private ArrayList moveOutbillList = null;
    private boolean isInListCal = true;
    private boolean isHasSynData = false;
    private boolean isRedBill = false;
    private String FBillEntryId;
    private String FSourceBillEntryID;
    private String FBlueBillEntryID;
    private String FEntryTableMame;
    private boolean isDealComplete = false;
    private boolean isNeedUpdate = false;
    private String stockTransBillEntryID;
    private boolean isDealdiffOK = true;
    private boolean isZeroPrice = false;
    private boolean isNegativePrice = false;
    private PriceSourEnum priceSource;
    private boolean isStockClose = false;
    private boolean stockCloseinafterPeriod = false;
    private String FkeyID = null;

    public boolean isStockCloseinafterPeriod() {
        return this.stockCloseinafterPeriod;
    }

    public void setStockCloseinafterPeriod(boolean stockCloseinafterPeriod) {
        this.stockCloseinafterPeriod = stockCloseinafterPeriod;
    }

    public boolean isStockClose() {
        return this.isStockClose;
    }

    public void setStockClose(boolean isStockClose) {
        this.isStockClose = isStockClose;
    }

    public String getFkeyID() {
        return this.FkeyID;
    }

    public void setFkeyID(String fkeyID) {
        this.FkeyID = fkeyID;
    }

    public boolean getIsDealdiffOK() {
        return this.isDealdiffOK;
    }

    public void setIsDealdiffOK(boolean isDealdiffOK) {
        this.isDealdiffOK = isDealdiffOK;
    }

    public RecentCostInfo() {
    }

    protected RecentCostInfo(String pkField) {
        super(pkField);
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        String billEntryID = ((RecentCostInfo)that).getString("FBillEntryId");
        if (billEntryID == null) {
            return ((RecentCostInfo)that).getString("FBillId").equals(this.getString("FBillId"));
        }
        return billEntryID.equals(this.getString("FBillEntryId"));
    }

    public boolean isCostAdjustBill() {
        return "3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(this.getString("FBillTypeID"));
    }

    public List getCombibionList() {
        return this.combitionList;
    }

    public void addCombition(RecentCostInfo info) {
        if (this.combitionList == null) {
            this.combitionList = new ArrayList();
        }
        ++this.combitionSize;
        this.combitionList.add(info);
    }

    public BigDecimal getTotalCombitionCost() {
        return this.totalCombitionCost;
    }

    public BigDecimal getTotalCombitionQty() {
        return this.totalCombitionQty;
    }

    public void addTotalCombitionQtyAndCost(BigDecimal qty, BigDecimal cost) {
        this.totalCombitionCost = this.totalCombitionCost.add(cost);
        this.totalCombitionQty = this.totalCombitionQty.add(qty);
    }

    public int getCombitionSize() {
        return this.combitionSize;
    }

    public String getEntryTableName() {
        return this.getString("FEntryTableMame");
    }

    public boolean isMatAttrChange() {
        return "kXeVPjF4chDgQKjAYj1RYCQHQ1w=".equals(this.getString("FBizTypeID")) || "kXeVPjGzchDgQKjAYj1RYCQHQ1w=".equals(this.getString("FBizTypeID")) || "kXeUoXWkByTgQKjAYj1F6CQHQ1w=".equals(this.getString("FBizTypeID")) || "kXeUoXXfByTgQKjAYj1F6CQHQ1w=".equals(this.getString("FBizTypeID")) || "kXeVPjHuchDgQKjAYj1RYCQHQ1w=".equals(this.getString("FBizTypeID"));
    }

    public boolean isLotChange() {
        return "kXeVPjF4chDgQKjAYj1RYCQHQ1w=".equals(this.getString("FBizTypeID")) || "kXeVPjGzchDgQKjAYj1RYCQHQ1w=".equals(this.getString("FBizTypeID"));
    }

    public boolean isCostPriceMove() {
        return "d8e80652-011b-1000-e000-04c5c0a812202407435C".equals(this.getString("FBizTypeID")) || "d8e80652-011a-1000-e000-04c5c0a812202407435C".equals(this.getString("FBizTypeID"));
    }

    public boolean isMoveInCostPriceStorage() {
        return "d8e80652-011a-1000-e000-04c5c0a812202407435C".equals(this.getString("FBizTypeID"));
    }

    public boolean isMoveInCostPriceWarehouse() {
        return "d8e80652-011b-1000-e000-04c5c0a812202407435C".equals(this.getString("FBizTypeID"));
    }

    public boolean isMoveOutBill() {
        return "T_IM_MoveIssueBillEntry".equalsIgnoreCase(this.getString("FEntryTableMame"));
    }

    public boolean isMoveInBill() {
        return "T_IM_MoveInWarehsBillEntry".equalsIgnoreCase(this.getString("FEntryTableMame"));
    }

    public ArrayList getMoveInbillList() {
        return this.moveInbillList;
    }

    public void addMoveInbillList(RecentCostInfo info) {
        if (this.moveInbillList == null) {
            this.moveInbillList = new ArrayList();
        }
        this.moveInbillList.add(info);
    }

    public void setMoveInbillList(ArrayList list) {
        this.moveInbillList = list;
    }

    public ArrayList getRedBillList() {
        return this.redBillList;
    }

    public void addRedBillList(RecentCostInfo info) {
        if (this.redBillList == null) {
            this.redBillList = new ArrayList();
        }
        this.redBillList.add(info);
    }

    public ArrayList getBalanceList() {
        return this.balanceList;
    }

    public void setBalanceList(ArrayList balanceList) {
        this.balanceList = balanceList;
    }

    public void addBalanceInfo(RecentCostInfo info) {
        if (this.balanceList == null) {
            this.balanceList = new ArrayList();
        }
        this.balanceList.add(info);
    }

    public boolean isRedBill() {
        return this.isRedBill;
    }

    public boolean isNotSrcOutRetBill() {
        return this.isRedBill() && !this.isCostAdjustBill() && !this.isReversed() && (this.getString("FSourceBillTypeID") == null || !this.getString("FSourceBillTypeID").equals("50957179-0105-1000-e000-015bc0a812fd463ED552") && !this.getString("FSourceBillTypeID").equals("50957179-0105-1000-e000-0163c0a812fd463ED552") && !this.getString("FSourceBillTypeID").equals("50957179-0105-1000-e000-0177c0a812fd463ED552"));
    }

    public boolean isSrcOutBillInPrePeriod() {
        return this.isRedBill() && !this.isCostAdjustBill() && this.getInt("FisSrcBilInCurrPid") == 2 && this.getString("FSourceBillTypeID") != null && this.getString("FSourceBillTypeID").equals(this.getString("FBillTypeID"));
    }

    public boolean isBlueOutBillInPrePeriod() {
        return this.isRedBill() && !this.isCostAdjustBill() && this.getInt("FisSrcBilInCurrPid") == 2 && this.getString("FSourceBillTypeID") != null && this.getFBlueBillEntryID() != null;
    }

    public boolean isSrcBillInPrePeriod() {
        return !this.isCostAdjustBill() && this.isReversed() && this.getInt("FisSrcBilInCurrPid") == 2 && this.getString("FSourceBillTypeID") != null && (this.getString("FSourceBillTypeID").equals("50957179-0105-1000-e000-015bc0a812fd463ED552") || this.getString("FSourceBillTypeID").equals("50957179-0105-1000-e000-0163c0a812fd463ED552"));
    }

    public boolean isSrcMoveBillInPrePeriod() {
        return !(this.isCostAdjustBill() || !this.isReversed() && !this.isRedBill() || this.getString("FSourceBillTypeID") == null || !this.getString("FSourceBillTypeID").equals("50957179-0105-1000-e000-016ec0a812fd463ED552") && !this.getString("FSourceBillTypeID").equals("50957179-0105-1000-e000-0172c0a812fd463ED552"));
    }

    public boolean isSrcOutBillInCurrentPd() {
        return this.isRedBill() && !this.isCostAdjustBill() && this.getInt("FisSrcBilInCurrPid") == -1 && this.getString("FSourceBillTypeID") != null && (this.getString("FSourceBillTypeID").equals("50957179-0105-1000-e000-015bc0a812fd463ED552") || this.getString("FSourceBillTypeID").equals("50957179-0105-1000-e000-0163c0a812fd463ED552"));
    }

    public boolean isExistSrcBill() {
        return this.isRedBill() && !this.isCostAdjustBill() && this.getString("FSourceBillTypeID") != null && (this.getString("FSourceBillTypeID").equals("50957179-0105-1000-e000-015bc0a812fd463ED552") || this.getString("FSourceBillTypeID").equals("50957179-0105-1000-e000-0163c0a812fd463ED552"));
    }

    public boolean isSameOutBillType(RecentCostInfo info) {
        return this.getFEntryTableMame() != null && this.getFEntryTableMame().equals(info.getFEntryTableMame()) && 1 == info.getInt("FCalculateKind");
    }

    public boolean isOutBill() {
        return 1 == this.getInt("FCalculateKind");
    }

    public boolean isCalculate() {
        return this.getBoolean("IsCalculate");
    }

    public ArrayList getMoveOutbillList() {
        return this.moveOutbillList;
    }

    public void addMoveOutbillList(RecentCostInfo info) {
        if (this.moveOutbillList == null) {
            this.moveOutbillList = new ArrayList();
        }
        this.moveOutbillList.add(info);
    }

    public void setMoveOutbillList(ArrayList list) {
        this.moveOutbillList = list;
    }

    public boolean isPriceExcep() {
        return CalculateUtil.ZERO.compareTo(this.getPrice()) > 0;
    }

    public boolean isBalanceExcep() {
        return CalculateUtil.ZERO.compareTo(this.getPrice()) > 0 || CalculateUtil.ZERO.compareTo(this.getRecentCost()) != 0 && CalculateUtil.ZERO.compareTo(this.getRecentQty()) == 0 || CalculateUtil.ZERO.compareTo(this.getRecentCost()) == 0 && CalculateUtil.ZERO.compareTo(this.getRecentQty()) != 0;
    }

    public boolean isReversed() {
        return this.getBoolean("FIsReversed");
    }

    public boolean isCommissionSaleOut() {
        return ("d8e80652-0113-1000-e000-04c5c0a812202407435C".equals(this.getString("FBizTypeID")) || "d8e80652-0114-1000-e000-04c5c0a812202407435C".equals(this.getString("FBizTypeID"))) && "181875d5-0105-1000-e000-011ac0a812fd97D461A6".equals(this.getString("FStoreTypeID"));
    }

    public BigDecimal getTotalCostMoveQty(boolean getBlue) {
        BigDecimal totalQty = CalculateUtil.ZERO;
        if (this.moveOutbillList != null) {
            for (int i = 0; i < this.moveOutbillList.size(); ++i) {
                if (getBlue && ((RecentCostInfo)this.moveOutbillList.get(i)).getRecentQty().compareTo(CalculateUtil.ZERO) < 0) continue;
                totalQty = totalQty.add(((RecentCostInfo)this.moveOutbillList.get(i)).getRecentQty());
            }
        }
        return totalQty;
    }

    public BigDecimal getTotalCostMoveCost(boolean gtBlue) {
        BigDecimal totalCost = CalculateUtil.ZERO;
        if (this.moveOutbillList != null) {
            for (int i = 0; i < this.moveOutbillList.size(); ++i) {
                if (gtBlue && ((RecentCostInfo)this.moveOutbillList.get(i)).getRecentCost().compareTo(CalculateUtil.ZERO) < 0) continue;
                totalCost = totalCost.add(((RecentCostInfo)this.moveOutbillList.get(i)).getRecentCost());
            }
        }
        return totalCost;
    }

    public boolean isInListCal() {
        return this.isInListCal;
    }

    public void setInListCal(boolean isInListCal) {
        this.isInListCal = isInListCal;
    }

    public boolean isReWorkBill() {
        return this.getInt("isReWork") == 1;
    }

    public BigDecimal getQty() {
        return this.getBigDecimal("FQty");
    }

    public BigDecimal getWrittenOffBaseQty() {
        return this.getBigDecimal("FWrittenOffBaseQty");
    }

    public BigDecimal getUnWriteOffBaseQty() {
        return this.getBigDecimal("FUnWriteOffBaseQty");
    }

    public BigDecimal getUnitActualCost() {
        BigDecimal unitActualCost = this.getPrice();
        if (!this.getString("FBaseUnit").equals(this.getString("FUnitID"))) {
            unitActualCost = this.getRecentCost().divide(this.getQty(), this.getInt("FPricePrecision"), 4);
        } else if (this.getBigDecimal("FQty").compareTo(BigDecimal.ZERO) == 0) {
            unitActualCost = BigDecimal.ZERO;
        }
        return unitActualCost;
    }

    public BigDecimal getWrittenOffAmount() {
        BigDecimal writtenOffAmount = this.getPrice().multiply(this.getWrittenOffBaseQty()).setScale(this.getInt("FLocalCurrencyPrecision"), 4);
        if (this.getWrittenOffBaseQty().compareTo(this.getRecentQty()) == 0) {
            writtenOffAmount = this.getRecentCost();
        }
        this.setBigDecimal("FWrittenOffAmount", writtenOffAmount);
        return writtenOffAmount;
    }

    public BigDecimal getUnWriteOffAmount() {
        BigDecimal writtenOffAmount = this.getBigDecimal("FWrittenOffAmount");
        if (writtenOffAmount == null) {
            writtenOffAmount = this.getWrittenOffAmount();
        }
        BigDecimal unWriteOffAmount = this.getRecentCost().subtract(writtenOffAmount);
        return unWriteOffAmount;
    }

    public boolean isHasSynData() {
        return this.isHasSynData;
    }

    public void setSynData(boolean isHasSynData) {
        this.isHasSynData = isHasSynData;
    }

    public String getFBillEntryId() {
        return this.FBillEntryId;
    }

    public void setFBillEntryId(String fBillEntryId) {
        this.FBillEntryId = fBillEntryId;
    }

    public String getFSourceBillEntryID() {
        return this.FSourceBillEntryID;
    }

    public void setFSourceBillEntryID(String fSourceBillEntryID) {
        this.FSourceBillEntryID = fSourceBillEntryID;
    }

    public String getFEntryTableMame() {
        return this.FEntryTableMame;
    }

    public void setFEntryTableMame(String fEntryTableMame) {
        this.FEntryTableMame = fEntryTableMame;
    }

    @Override
    public void setRecentQty(BigDecimal item) {
        this.setBigDecimal("recentQty", item);
        if (item != null && item.signum() < 0) {
            this.isRedBill = true;
        }
    }

    public boolean isDealComplete() {
        return this.isDealComplete;
    }

    public void setDealComplete(boolean isDealComplete) {
        this.isDealComplete = isDealComplete;
    }

    public boolean isNeedUpdate() {
        return this.isNeedUpdate;
    }

    public void setNeedUpdate(boolean isNeedUpdate) {
        this.isNeedUpdate = isNeedUpdate;
    }

    public String getStockTransBillEntryID() {
        return this.stockTransBillEntryID;
    }

    public void setStockTransBillEntryID(String stockTransBillEntryID) {
        this.stockTransBillEntryID = stockTransBillEntryID;
    }

    public Object clone() {
        RecentCostInfo retValue = (RecentCostInfo)super.clone();
        return this.copyInfo(retValue);
    }

    private RecentCostInfo copyInfo(RecentCostInfo retValue) {
        retValue.setFBillEntryId(this.getFBillEntryId());
        retValue.setFSourceBillEntryID(this.getFSourceBillEntryID());
        retValue.setFEntryTableMame(this.getFEntryTableMame());
        retValue.setDealComplete(this.isDealComplete());
        retValue.setNeedUpdate(this.isNeedUpdate());
        retValue.setStockTransBillEntryID(this.getStockTransBillEntryID());
        return retValue;
    }

    public PriceSourEnum getPriceSource() {
        return this.priceSource;
    }

    public void setPriceSource(PriceSourEnum priceSource) {
        this.priceSource = priceSource;
    }

    public ArrayList getMoveBillList() {
        return this.moveBillList;
    }

    public void setMoveBillList(ArrayList moveBillList) {
        this.moveBillList = moveBillList;
    }

    public String getFBlueBillEntryID() {
        return this.FBlueBillEntryID;
    }

    public void setFBlueBillEntryID(String fBlueBillEntryID) {
        this.FBlueBillEntryID = fBlueBillEntryID;
    }
}

