/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.OrgRelationUtils;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.CalRptUtilFacadeFactory;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.ICalRptUtilFacade;
import com.kingdee.eas.scm.cal.VoucheredEnum;
import com.kingdee.eas.scm.cal.client.AbstractBillAccountViewConditionUI;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.ISCMBillStatusControl;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class BillAccountViewConditionUI
extends AbstractBillAccountViewConditionUI
implements ISCMBillStatusControl {
    private static final Logger logger = CoreUIObject.getLogger(BillAccountViewConditionUI.class);
    private F7ContextManager f7Manger = new F7ContextManager((Component)((Object)this), OrgType.Company, 1);
    private CompanyOrgUnitInfo curCompany = null;
    private OrgUnitCollection curCompanyCol = null;
    private boolean isSetCustomCondition = false;
    private int curYear = 0;
    private int curPeriod = 0;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        RptParams para = new RptParams();
        para.setObject("company", this.prmtCompany.getValue());
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        if (companyInfo != null && companyInfo.getId() != null) {
            para.setString("COMPANY_ID", companyInfo.getId().toString());
        }
        para.setInt("startYear", this.kdspStartYear.getIntegerVlaue().intValue());
        para.setInt("startPeriod", this.kspdStartPeriod.getIntegerVlaue().intValue());
        para.setInt("endYear", this.spdEndYear.getIntegerVlaue().intValue());
        para.setInt("endPeriod", this.spdEndPeriod.getIntegerVlaue().intValue());
        para.setObject("billType", this.prmtBillType.getValue());
        para.setObject("startTransacionType", this.prmtStartTransacionType.getValue());
        para.setObject("endTransactionType", this.prmtEndTransactionType.getValue());
        para.setObject("startMaterial", this.prmtStartMaterial.getValue());
        para.setObject("endMaterial", this.prmtEndMaterial.getValue());
        para.setObject("vouchered", this.comboVouchered.getSelectedItem());
        para.setBoolean("isOnlyShowNull", this.checkIsOnlyShowNull.isSelected());
        para.setObject("billStatus", this.kdcbStatus.getSelectedItem());
        para.setObject("storage", this.prmtStorage.getValue());
        para.setObject("warehouse", this.prmtWarehouse.getValue());
        para.setObject("startBillNumber", (Object)this.textStartBillNumber.getStringValue());
        para.setObject("endBillNumber", (Object)this.textEndBillNumber.getStringValue());
        para.setObject("accountView", this.prmtAccountView.getValue());
        return para;
    }

    public void setCustomCondition(RptParams params) {
        if (params == null) {
            return;
        }
        this.isSetCustomCondition = true;
        this.prmtCompany.setValue(params.getObject("company"));
        this.kdspStartYear.setValue((Object)new Integer(params.getInt("startYear")));
        this.kspdStartPeriod.setValue((Object)new Integer(params.getInt("startPeriod")));
        this.spdEndYear.setValue((Object)new Integer(params.getInt("endYear")));
        this.spdEndPeriod.setValue((Object)new Integer(params.getInt("endPeriod")));
        this.prmtBillType.setValue(params.getObject("billType"));
        this.prmtStartTransacionType.setValue(params.getObject("startTransacionType"));
        this.prmtEndTransactionType.setValue(params.getObject("endTransactionType"));
        this.prmtStartMaterial.setValue(params.getObject("startMaterial"));
        this.prmtEndMaterial.setValue(params.getObject("endMaterial"));
        this.comboVouchered.setSelectedItem(params.getObject("vouchered"));
        this.checkIsOnlyShowNull.setSelected(params.getBoolean("isOnlyShowNull"));
        this.kdcbStatus.setSelectedItem(params.getObject("billStatus"));
        this.isSetCustomCondition = false;
        this.prmtStorage.setValue(params.getObject("storage"));
        this.prmtWarehouse.setValue(params.getObject("warehouse"));
        if (params.getObject("startBillNumber") != null) {
            this.textStartBillNumber.setStringValue(params.getString("startBillNumber"));
        } else {
            this.textStartBillNumber.setStringValue("");
        }
        if (params.getObject("endBillNumber") != null) {
            this.textEndBillNumber.setStringValue(params.getString("endBillNumber"));
        } else {
            this.textEndBillNumber.setStringValue("");
        }
        this.prmtAccountView.setValue(params.getObject("accountView"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        try {
            this.initBizComponentF7();
            this.prmtCompany.setRequired(true);
            this.prmtCompany.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    try {
                        BillAccountViewConditionUI.this.bizOrgUnit_stateChanged(e);
                    }
                    catch (Exception e1) {
                        BillAccountViewConditionUI.this.handUIException(e1);
                    }
                }
            });
            this.checkIsOnlyShowNull.setSelected(true);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        SCMQueryFormat.formatBillStatus((ISCMBillStatusControl)this, (KDComboBox)this.kdcbStatus);
        this.prmtWarehouse.setEnabled(false);
        this.prmtStorage.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BillAccountViewConditionUI.this.storage_change(e);
            }
        });
    }

    private void initBizComponentF7() throws EASBizException, BOSException {
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtCompany, (OrgType)this.getMainBizOrgType(), (String)this.getViewPermission());
        this.prmtCompany.setCommitFormat("$number$");
        this.prmtStartMaterial.setEditFormat("$number$");
        this.prmtStartMaterial.setDisplayFormat("$number$");
        this.prmtStartMaterial.setCommitFormat("$number$");
        this.prmtEndMaterial.setEditFormat("$number$");
        this.prmtEndMaterial.setDisplayFormat("$number$");
        this.prmtEndMaterial.setCommitFormat("$number$");
        this.f7Manger.registerBizMaterialF7(this.prmtStartMaterial, null, null, (OrgUnitInfo)this.curCompany, true);
        this.f7Manger.registerBizMaterialF7(this.prmtEndMaterial, null, null, (OrgUnitInfo)this.curCompany, false);
        CalculateClientUtil.addListenerForMultiF7(this.prmtStartMaterial, this.prmtEndMaterial);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtStartMaterial, this.prmtEndMaterial});
        this.setBillTypeF7();
        this.setTranSactionTypeF7();
        this.prmtBillType.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BillAccountViewConditionUI.this.setTranSactionTypeF7();
            }
        });
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompany;
    }

    public void clear() {
        super.clear();
        this.prmtBillType.setValue(null);
        this.prmtStartTransacionType.setValue(null);
        this.prmtEndTransactionType.setValue(null);
        this.prmtStartMaterial.setValue(null);
        this.prmtEndMaterial.setValue(null);
        this.prmtStartTransacionType.setValue(null);
        this.prmtEndTransactionType.setValue(null);
        this.prmtStorage.setValue(null);
        this.prmtWarehouse.setValue(null);
        this.textStartBillNumber.setStringValue("");
        this.textEndBillNumber.setStringValue("");
        this.prmtAccountView.setValue(null);
        this.prmtCompany.setValue(null);
        this.comboVouchered.setSelectedItem((Object)VoucheredEnum.NOVOUCHERED);
        this.kdcbStatus.setSelectedItem((Object)BillBaseStatusEnum.NULL);
        this.checkIsOnlyShowNull.setSelected(true);
        try {
            this.curCompany = (CompanyOrgUnitInfo)this.getDefaultMainBizOrg();
            if (this.curCompany != null && this.curCompany.isIsBizUnit()) {
                this.prmtCompany.setValue((Object)this.curCompany);
            }
            this.isSetCustomCondition = false;
            this.bizOrgUnit_stateChanged(null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected final OrgUnitInfo getDefaultMainBizOrg() {
        CompanyOrgUnitInfo currentMainOrg = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
        try {
            OrgUnitInfo[] orgs;
            if (currentMainOrg != null && currentMainOrg.isIsBizUnit() && SCMGroupClientUtils.isAuthoriedForOrg((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)this.getMainBizOrgType(), (IObjectPK)new ObjectStringPK(currentMainOrg.getId().toString()), (String)this.getViewPermission())) {
                return currentMainOrg;
            }
            FullOrgUnitCollection orgCol = SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)this.getMainBizOrgType(), (String)this.getViewPermission());
            if (orgCol != null && orgCol.size() > 0 && (orgs = OrgRelationUtils.getOrgUnitInfosByType((FullOrgUnitCollection)orgCol, (OrgType)this.getMainBizOrgType())) != null) {
                return orgs[0];
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return null;
    }

    protected void storage_change(ChangeEvent e) {
        if (this.prmtStorage.getValue() != null) {
            Object[] StorageOrgUnit;
            HashSet<String> set = new HashSet<String>();
            for (Object s : StorageOrgUnit = (Object[])this.prmtStorage.getValue()) {
                set.add(((StorageOrgUnitInfo)s).getId().toString());
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", set, CompareType.INCLUDE));
            viewInfo.setFilter(filterInfo);
            this.prmtWarehouse.setEntityViewInfo(viewInfo);
            this.prmtWarehouse.setEnabled(true);
            this.prmtWarehouse.setValue(null);
        } else {
            this.prmtWarehouse.setValue(null);
            this.prmtWarehouse.setEnabled(false);
        }
    }

    protected void bizOrgUnit_stateChanged(ChangeEvent e) throws Exception {
        this.curCompany = (CompanyOrgUnitInfo)this.prmtCompany.getData();
        if (!this.isSetCustomCondition) {
            if (this.curCompany != null) {
                this.curCompanyCol = new OrgUnitCollection();
                this.curCompanyCol.add((OrgUnitInfo)this.curCompany);
                this.prmtStartMaterial.setMainBizOrgs(this.curCompanyCol, OrgType.Company);
                this.prmtEndMaterial.setMainBizOrgs(this.curCompanyCol, OrgType.Company);
                this.loadAccountPeriod(this.curCompany);
                this.prmtStorage.setCommitFormat("$number$");
            }
            this.prmtStorage.setValue(null);
            this.prmtWarehouse.setValue(null);
        }
        if (this.curCompany != null) {
            this.prmtAccountView.setEntityViewInfo(InvClientUtils.getEntityViewForF7AccountView((CompanyOrgUnitInfo)this.curCompany));
            this.prmtAccountView.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("isleaf", (Object)1));
            OrgUnitCollection orgCollection = SCMClientUtils.getStorageUnitInfo((CompanyOrgUnitInfo)this.curCompany);
            this.prmtStorage.setEntityViewInfo(this.getOrgEntityViewInfo(orgCollection));
            this.f7Manger.changeF7Context(this.curCompany.getId().toString());
            this.prmtStartMaterial.setEnabled(true);
            this.prmtEndMaterial.setEnabled(true);
            this.prmtStorage.setEnabled(true);
        } else {
            this.prmtStartMaterial.setEnabled(false);
            this.prmtEndMaterial.setEnabled(false);
            this.prmtStorage.setEnabled(false);
            this.prmtWarehouse.setEnabled(false);
        }
    }

    private EntityViewInfo getOrgEntityViewInfo(OrgUnitCollection collcetion) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < collcetion.size(); ++i) {
            if (collcetion.get(i).getId() == null) continue;
            stringBuffer.append(collcetion.get(i).getId().toString());
            stringBuffer.append(",");
        }
        String storageOrgUnitIDs = stringBuffer.toString();
        if (storageOrgUnitIDs.length() > 0) {
            storageOrgUnitIDs = storageOrgUnitIDs.substring(0, storageOrgUnitIDs.length() - 1);
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)storageOrgUnitIDs, CompareType.INCLUDE));
        } else {
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)"NOTEXISTID", CompareType.INCLUDE));
        }
        evi.setFilter(fi);
        return evi;
    }

    private void loadAccountPeriod(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        ICalRptUtilFacade iCalRptUtil;
        Object[] reslut;
        if (companyInfo != null) {
            PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            if (periodInfo == null) {
                this.prmtCompany.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTSTART);
            }
            if (curPeriodInfo == null) {
                this.prmtCompany.setValue(null);
                throw new CalculateException(CalculateException.REPORT_ACCOUNT_NOTCURRENT);
            }
        }
        if ((reslut = (iCalRptUtil = CalRptUtilFacadeFactory.getRemoteInstance()).fetchInitFilterData(companyInfo.getId().toString())) != null) {
            CalculateUtil.AccountPeriodInfo actPeriodInfo = (CalculateUtil.AccountPeriodInfo)reslut[1];
            CalculateUtil.appliesPeriodControl(this.kdspStartYear, this.spdEndYear, this.kspdStartPeriod, this.spdEndPeriod, actPeriodInfo, true, false);
            this.curYear = (Integer)this.kdspStartYear.getValue();
            this.curPeriod = (Integer)this.kspdStartPeriod.getValue();
        }
    }

    protected String getViewPermission() {
        return "billAccountView_view";
    }

    private void addF7SelectorListener(KDBizPromptBox[] f7s) {
        for (int i = 0; i < f7s.length; ++i) {
            f7s[i].addSelectorListener(new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    if (BillAccountViewConditionUI.this.getMainBizOrgF7() != null) {
                        return;
                    }
                    Object value = BillAccountViewConditionUI.this.getMainBizOrgF7().getValue();
                    if (value == null || value instanceof Object[] && ((Object[])value).length == 0 || value instanceof Object[] && ((Object[])value)[0] == null) {
                        MsgBox.showInfo((String)SCMGroupClientUtils.getMainOrgNullMsg((OrgType)BillAccountViewConditionUI.this.getMainBizOrgType()));
                        BillAccountViewConditionUI.this.getMainBizOrgF7().requestFocus();
                        SysUtil.abort();
                    }
                }
            });
        }
    }

    protected void setNeedMainOrgF7s(KDBizPromptBox[] f7s) {
        this.addF7SelectorListener(f7s);
        this.f7Manger.setPrmtNeedOrgF7s(f7s);
    }

    private void setBillTypeF7() {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("102");
        hashSet.add("103");
        hashSet.add("104");
        hashSet.add("105");
        hashSet.add("106");
        hashSet.add("107");
        hashSet.add("108");
        hashSet.add("109");
        hashSet.add("410");
        filter.getFilterItems().add(new FilterItemInfo("number", hashSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        this.prmtBillType.setQueryInfo("com.kingdee.eas.basedata.scm.common.app.F7BillTypeQuery");
        this.prmtBillType.setEntityViewInfo(ev);
        this.prmtBillType.setCommitFormat("$number$");
        this.prmtBillType.setDisplayFormat("$number$");
        this.prmtBillType.setEditFormat("$number$");
        this.prmtBillType.setEnabledMultiSelection(true);
    }

    private void setTranSactionTypeF7() {
        this.prmtStartTransacionType.setValue(null);
        this.prmtEndTransactionType.setValue(null);
        this.prmtStartTransacionType.setQueryInfo("com.kingdee.eas.basedata.scm.common.app.F7TransactionTypeDefaultQuery");
        this.prmtEndTransactionType.setQueryInfo("com.kingdee.eas.basedata.scm.common.app.F7TransactionTypeDefaultQuery");
        this.prmtStartTransacionType.setEnabledMultiSelection(true);
        this.prmtStartTransacionType.setDisplayFormat("$name$");
        this.prmtStartTransacionType.setEditFormat("$name$");
        CalculateClientUtil.addListenerForMultiF7(this.prmtStartTransacionType, this.prmtEndTransactionType);
        if (this.prmtBillType.getValue() != null) {
            Object obj = this.prmtBillType.getValue();
            HashSet<String> oriSet = new HashSet<String>();
            if (obj instanceof Object[]) {
                Object[] billTypes = (Object[])this.prmtBillType.getValue();
                int size = billTypes.length;
                for (int j = 0; j < size; ++j) {
                    if (billTypes[j] instanceof Object[]) {
                        Object[] tempBillTypes = (Object[])billTypes[j];
                        for (int k = 0; k < tempBillTypes.length; ++k) {
                            BillTypeInfo billType = (BillTypeInfo)tempBillTypes[k];
                            if (billType == null) continue;
                            oriSet.add(billType.getNumber());
                        }
                        continue;
                    }
                    BillTypeInfo billType = (BillTypeInfo)billTypes[j];
                    if (billType == null) continue;
                    oriSet.add(billType.getNumber());
                }
                InvClientUtils.setFilterForTransactionTypeByBillType((KDBizPromptBox)this.prmtStartTransacionType, oriSet);
                InvClientUtils.setFilterForTransactionTypeByBillType((KDBizPromptBox)this.prmtEndTransactionType, oriSet);
            } else if (obj instanceof BillTypeInfo) {
                InvClientUtils.setFilterForTransactionType((KDBizPromptBox)this.prmtStartTransacionType, (String)((BillTypeInfo)this.prmtBillType.getValue()).getNumber());
                InvClientUtils.setFilterForTransactionType((KDBizPromptBox)this.prmtEndTransactionType, (String)((BillTypeInfo)this.prmtBillType.getValue()).getNumber());
            }
        }
    }

    public boolean verify() {
        if (this.prmtCompany.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COMPANY_NOTNULL"));
            return false;
        }
        int yearFrom = this.kdspStartYear.getIntegerVlaue();
        int periodfrom = this.kspdStartPeriod.getIntegerVlaue();
        int yearTo = this.spdEndYear.getIntegerVlaue();
        int periodTo = this.spdEndPeriod.getIntegerVlaue();
        if (100 * yearFrom + periodfrom < 100 * this.curYear + this.curPeriod || 100 * yearTo + periodTo < 100 * this.curYear + this.curPeriod) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"CanNo_less_CurPeriod"));
            return false;
        }
        if (100 * yearFrom + periodfrom > 100 * yearTo + periodTo) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_BEGIN_NOTBIG_END"));
            return false;
        }
        return true;
    }

    public Object[] getUnVisibleBillStatus() {
        return new Object[]{BillBaseStatusEnum.RELEASED, BillBaseStatusEnum.BLOCKED, BillBaseStatusEnum.DELETED, BillBaseStatusEnum.CLOSED};
    }

    public Object[] getAdditiveBillStatus() {
        return null;
    }
}

