/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.CloseAccountFacadeFactory;
import com.kingdee.eas.scm.cal.ICloseAccountFacade;
import com.kingdee.eas.scm.cal.client.AbstractCloseAccountUI;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LowTimer;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class CloseAccountUI
extends AbstractCloseAccountUI
implements Runnable {
    private static final Logger logger = CoreUIObject.getLogger(CloseAccountUI.class);
    private static final String PERMISSION = "closeaccount";
    private static final String RESOURCEPATH = "com.kingdee.eas.scm.cal.CalCommonResource";
    private static final String ISCHECK_COSTBILL = "IsCheckCostbill";
    private CompanyOrgUnitInfo companyInfo;
    private PeriodInfo currPeriodInfo;
    private boolean isProcessing;
    private Map param = new HashMap();

    public CloseAccountUI() throws Exception {
        this.currPeriodInfo = new PeriodInfo();
        this.currPeriodInfo.setId(BOSUuid.create((BOSObjectType)this.currPeriodInfo.getBOSType()));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LowTimer timer = new LowTimer();
        this.btnCloseAccount.setEnabled(false);
        this.btnCancel.setEnabled(false);
        this.param.put("period", this.currPeriodInfo);
        this.param.put(ISCHECK_COSTBILL, "false");
        this.param.put("isStoreType", new Boolean(true));
        String closing = InvClientUtils.getResource((String)"PERIODCLOSING");
        this.progressBar.setStringPainted(true);
        this.progressBar.setString(closing);
        this.progressBar.setIndeterminate(true);
        this.progressBar.setVisible(true);
        long endTime = 0L;
        String getcalcHMSString = "";
        boolean isSuccess = false;
        try {
            if (this.rdoInit.isSelected()) {
                this.param.put("isInitStore", new Boolean(true));
                isSuccess = this.closeAccount();
            } else if (this.rdoClose.isSelected()) {
                isSuccess = this.closeAccount();
            } else if (this.rdoUnClose.isSelected()) {
                isSuccess = this.unCloseAccount();
            }
            if (isSuccess) {
                this.setCurrPeriod();
                this.setCurrPeriodLable();
            }
            endTime = timer.msValue();
            getcalcHMSString = CalculateUtil.getcalcHMSString((int)endTime);
        }
        catch (Exception e) {
            this.isProcessing = false;
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(this.progressBar.getMaximum());
            this.progressBar.setVisible(false);
            this.handUIException(e);
        }
        finally {
            this.progressBar.setValue(this.progressBar.getMaximum());
            this.progressBar.setIndeterminate(false);
            this.param.remove("isInitStore");
            String costTime = EASResource.getString((String)RESOURCEPATH, (String)"COSTIME");
            this.progressBar.setString(costTime + getcalcHMSString);
            this.btnCloseAccount.setEnabled(true);
            this.btnCancel.setEnabled(true);
            this.isProcessing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeAccount() throws EASBizException, BOSException {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        ComponentUtil.setWindowsCursorOfWair((Window)window);
        try {
            ICloseAccountFacade closeFacade = CloseAccountFacadeFactory.getRemoteInstance();
            closeFacade.closeAccount(this.companyInfo, this.param);
            boolean bl = true;
            return bl;
        }
        finally {
            ComponentUtil.setWindowCursorOfDefault((Window)window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unCloseAccount() throws EASBizException, BOSException {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        ComponentUtil.setWindowsCursorOfWair((Window)window);
        if (!SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)this.companyInfo)) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCEPATH, (String)"NOTINITINV"));
            ComponentUtil.setWindowCursorOfDefault((Window)window);
            return false;
        }
        try {
            ICloseAccountFacade closeFacade = CloseAccountFacadeFactory.getRemoteInstance();
            closeFacade.reverseColoseAccount(this.companyInfo, this.param);
            boolean bl = true;
            return bl;
        }
        finally {
            ComponentUtil.setWindowCursorOfDefault((Window)window);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        CalculateClientUtil.setCompanyOrgF7(this.prmtCompany, PERMISSION, true);
        SCMClientUtils.setF7OrgUnitBizUnit((KDBizPromptBox)this.prmtCompany);
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CloseAccountUI.this.prmtCompanyStateChanged();
            }
        };
        this.prmtCompany.addChangeListener(changeListener);
        CalculateClientUtil.InitCompanyF7(this.prmtCompany, PERMISSION);
        this.progressBar.setVisible(false);
        this.isProcessing = false;
    }

    public boolean destroyWindow() {
        if (this.isProcessing) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCEPATH, (String)"CLOSEACCOUNTING"));
            return false;
        }
        return super.destroyWindow();
    }

    private void prmtCompanyStateChanged() {
        this.companyInfo = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        if (this.companyInfo != null) {
            this.setCurrPeriod();
            this.setCurrPeriodLable();
        }
    }

    private void setCurrPeriodLable() {
        String period = String.valueOf(this.currPeriodInfo.getPeriodYear()) + "." + String.valueOf(this.currPeriodInfo.getPeriodNumber());
        this.contCurrPeriod.setBoundLabelText(this.resHelper.getString("contCurrPeriod.boundLabelText") + period);
    }

    private void setCurrPeriod() {
        int periodInt = 0;
        try {
            ICloseAccountFacade closeFacade = CloseAccountFacadeFactory.getRemoteInstance();
            periodInt = closeFacade.getCurrPeriod(this.companyInfo);
            this.currPeriodInfo.setPeriodYear(periodInt / 100);
            this.currPeriodInfo.setPeriodNumber(periodInt % 100);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void actionCloseAccount_actionPerformed(ActionEvent e) throws Exception {
        if (this.companyInfo == null) {
            MsgBox.showInfo((String)InvClientUtils.getResource((String)"CompanyIsNull"));
            return;
        }
        if (!SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)this.companyInfo)) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCEPATH, (String)"NOTINITINV"));
            return;
        }
        if (this.rdoInit.isSelected() && MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"192_CloseAccountUI")) != 0) {
            return;
        }
        if (this.rdoInit.isSelected()) {
            this.currPeriodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)this.companyInfo);
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.getUIWindow().close();
    }
}

