/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.JobConfig;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.common.perf.client.JobMonitorManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.CalculateFacadeFactory;
import com.kingdee.eas.scm.cal.CostCalculateFacadeFactory;
import com.kingdee.eas.scm.cal.CostUpdateMutexFacadeFactory;
import com.kingdee.eas.scm.cal.ICalculateFacade;
import com.kingdee.eas.scm.cal.client.AbstractCostCalculateStep4UI;
import com.kingdee.eas.scm.cal.client.CostCalCulateWizard;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LowTimer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CostCalculateStep4UI
extends AbstractCostCalculateStep4UI
implements Runnable {
    private static final long serialVersionUID = 2799519526381635304L;
    private static final Logger logger = CoreUIObject.getLogger(CostCalculateStep4UI.class);
    private CalculateParams params = null;
    private CostCalCulateWizard wizardFirst = null;

    public CostCalCulateWizard getWizardFirst() {
        return this.wizardFirst;
    }

    public void setWizardFirst(CostCalCulateWizard wizardFirst) {
        this.wizardFirst = wizardFirst;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public CalculateParams getParams() {
        return this.params;
    }

    public void setParams(CalculateParams params) {
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        if (this.params.getObject("isPerf") != null && ((Boolean)this.params.getObject("isPerf")).booleanValue()) {
            try {
                this.changeBtnStatus(false);
                this.progressBar.setStringPainted(true);
                this.progressBar.setIndeterminate(true);
                JobConfig jobCfg = this.createJobCfg();
                HashMap<String, String> con = new HashMap<String, String>();
                String notCalculate = this.params.getString("COMPANY_NUMBER") + "SCM_CAL_0002";
                con.put("CloseMutexCalculate", notCalculate);
                con.put("CALCULATE_ROWMATEIAL_WAITE", jobCfg.getTaskType());
                String calType = "prdOutCal";
                if ("rawMaterailCostCal".equals(this.params.getString("CALCULATEMATERIALRANGE"))) {
                    calType = "matOutCal";
                }
                CostUpdateMutexFacadeFactory.getRemoteInstance().checkCostUpdateMutex(this.params.getString("COMPANY_ID"), calType);
                Map rs = CostCalculateFacadeFactory.getRemoteInstance().fetchData(con);
                if (((Boolean)rs.get("CloseMutexCalculate")).booleanValue()) {
                    MsgBox.showWarning((String)CalculateClientUtil.getCalResource("CloseMutexCalculate_Msg"));
                    return;
                }
                if (((Boolean)rs.get("CALCULATE_ROWMATEIAL_WAITE")).booleanValue()) {
                    if (this.params.getString("OprtState").equalsIgnoreCase("rawMaterailCostCal")) {
                        MsgBox.showWarning((String)CalculateClientUtil.getCalResource("CALCULATE_ROWMATEIAL_WAITE_MSG"));
                        return;
                    } else {
                        MsgBox.showWarning((String)CalculateClientUtil.getCalResource("CALCULATE_FINSHGOOD_WAITE_MSG"));
                    }
                    return;
                }
                if (this.params.getString("OprtState").equalsIgnoreCase("rawMaterailCostCal")) {
                    MsgBox.showWarning((String)(CalculateClientUtil.getCalResource("CALCULATE_ROWMATEIAL_RUNNING_MSG") + this.getAccountTypeName(this.params.getInt("ACCOUNT_TYPE"))));
                } else {
                    MsgBox.showWarning((String)(CalculateClientUtil.getCalResource("CALCULATE_FINSHGOOD_RUNNING_MSG") + this.getAccountTypeName(this.params.getInt("ACCOUNT_TYPE"))));
                }
                try {
                    String jobInstExtId;
                    this.params.setObject("CURRENT_USER", (Object)SysContext.getSysContext().getCurrentUserInfo());
                    this.params.setObject("CURRENT_COMPANY", (Object)SysContext.getSysContext().getCurrentFIUnit());
                    this.params.setObject("CURRENT_CU", (Object)SysContext.getSysContext().getCurrentCtrlUnit());
                    this.params.setObject("languageLocale", (Object)SysContext.getSysContext().getLocale());
                    Map result = CreateJobFacadeFactory.getRemoteInstance().executeJob(new JobParam((Object)this.params), jobCfg);
                    if (null == result || null == (jobInstExtId = (String)result.get("jobInstExtId"))) return;
                    JobMonitorManager.getInstance().addMonitorInfo(jobInstExtId, jobCfg.getTitle());
                    return;
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
                return;
            }
            catch (EASBizException e) {
                this.progressBar.setIndeterminate(false);
                this.params.setBoolean("ISEXECPTION", true);
                this.handUIException(e);
                return;
            }
            catch (BOSException e1) {
                this.progressBar.setIndeterminate(false);
                this.params.setBoolean("ISEXECPTION", true);
                this.handUIException(e1);
                return;
            }
            finally {
                this.changeBtnStatus(true);
                this.getWizardFirst().setStep(5);
                this.updateLastCalculateKind();
            }
        }
        LowTimer st = new LowTimer();
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        ComponentUtil.setWindowsCursorOfWair((Window)window);
        String complete = this.getCompleteMsg(true);
        String getcalcHMSString = "";
        long endTime = 0L;
        try {
            this.changeBtnStatus(false);
            String closing = this.getCalculteIngMsg();
            this.progressBar.setStringPainted(true);
            this.progressBar.setString(closing);
            this.progressBar.setIndeterminate(true);
            ICalculateFacade ida = CalculateFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
            CalculateParams cps = ida.costCalculate(this.params);
            if (!cps.getBoolean("boolean")) {
                complete = this.getCompleteMsg(false);
            }
            endTime = st.msValue();
            getcalcHMSString = CalculateUtil.getcalcHMSString((int)endTime);
            this.getWizardFirst().setUITitle(CalculateClientUtil.getCalResource("costCalStep4"));
            return;
        }
        catch (Exception exception) {
            complete = this.getCompleteMsg(false);
            this.progressBar.setIndeterminate(false);
            this.handUIException(exception);
            return;
        }
        finally {
            this.changeBtnStatus(true);
            this.getWizardFirst().setStep(5);
            String costTime = EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COSTIME");
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(this.progressBar.getMaximum());
            this.progressBar.setString(complete + " " + costTime + getcalcHMSString);
            ComponentUtil.setWindowCursorOfDefault((Window)window);
            this.updateLastCalculateKind();
        }
    }

    private JobConfig createJobCfg() {
        String title = "\u3010" + this.params.getString("COMPANY_NAME") + "(" + this.params.getString("COMPANY_NUMBER") + ")\u3011" + this.params.getString("title");
        JobConfig jobCfg = new JobConfig();
        int accountType = this.params.getInt("ACCOUNT_TYPE");
        if (this.params.getString("OprtState").equalsIgnoreCase("rawMaterailCostCal")) {
            jobCfg.setNumber("SCM_CAL_0001");
            jobCfg.setTaskType(this.params.getString("COMPANY_NUMBER") + "SCM_CAL_0001");
        } else {
            jobCfg.setNumber("SCM_CAL_0003");
            jobCfg.setTaskType(this.params.getString("COMPANY_NUMBER") + "SCM_CAL_0003");
        }
        jobCfg.setTaskType(jobCfg.getTaskType() + "ACCOUNT_TYPE_" + accountType);
        jobCfg.setTitle(title);
        jobCfg.setDescription(title);
        jobCfg.setNeedCheckTaskType(false);
        return jobCfg;
    }

    private String getCompleteMsg(boolean calcualteSuccess) {
        String completeText = "";
        completeText = calcualteSuccess ? (this.params.getBoolean("ISSUE_COST_ADJUST") ? EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COST_ADJUST_CAL_COMPLETE") : (this.params.getBoolean("ExceptionDataAdjZero") ? EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"EXCEPTIONAJDZERO") : EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"WEIGHTED_AVERAGE_COST_CAL_COMPLETE"))) : (this.params.getBoolean("ISSUE_COST_ADJUST") ? EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COST_ADJUST_CAL_DEFEAT") : (this.params.getBoolean("ExceptionDataAdjZero") ? EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"ExcepDataAdjZeroFail") : EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"WEIGHTED_AVERAGE_COST_CAL_DEFEAT")));
        return completeText;
    }

    private String getCalculteIngMsg() {
        String ingText = "";
        ingText = this.params.getBoolean("ISSUE_COST_ADJUST") ? EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COST_ADJUST_CAL_ING") : (this.params.getBoolean("ExceptionDataAdjZero") ? EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"EXCEPTIONAJDZERO") : EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"WEIGHTED_AVERAGE_COST_CAL_ING"));
        return ingText;
    }

    private void updateLastCalculateKind() {
        try {
            ICalculateFacade calculateFacade = CalculateFacadeFactory.getRemoteInstance();
            int calculKind = this.params.getInt("ACCOUNT_TYPE");
            this.params.getString("COMPANY_ID");
            calculateFacade.updateLastCalculateKind(this.params.getString("COMPANY_ID"), calculKind);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    private void changeBtnStatus(boolean status) {
        this.btn_ViewCostRpt.setEnabled(status);
        this.btn_ViewDetailCostRpt.setEnabled(status);
        this.btn_ExpCostAdj.setEnabled(status);
        this.getWizardFirst().setNextOrPreBtnStatus(status);
        int account_type = this.params.getInt("ACCOUNT_TYPE");
        if (account_type != 4 && account_type != 3 && account_type != 5) {
            this.btn_ExpCostAdj.setEnabled(false);
        }
    }

    @Override
    protected void btn_ViewDetailCostRpt_actionPerformed(ActionEvent e) throws Exception {
        super.btn_ViewDetailCostRpt_actionPerformed(e);
        Object id = null;
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", id);
        uiContext.put((Object)"HISTORY_QUERY", (Object)"HISTORY_QUERY");
        uiContext.put((Object)"PREFERRED_SIZE", (Object)new Dimension(this.getWidth(), this.getHeight()));
        String UIName = "com.kingdee.eas.scm.cal.client.CostComputeReportUI";
        IUIWindow uiWindow = null;
        Window parentWin = SwingUtilities.getWindowAncestor((Component)((Object)this));
        uiWindow = parentWin != null && parentWin instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(UIName, (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(UIName, (Map)uiContext, null, OprtState.VIEW);
        if (parentWin != null && parentWin instanceof JDialog) {
            parentWin.dispose();
        }
        uiWindow.show();
    }

    @Override
    protected void btn_ExpCostAdj_actionPerformed(ActionEvent e) throws Exception {
        super.btn_ExpCostAdj_actionPerformed(e);
        ICalculateFacade ida = CalculateFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        CalculateParams cps = ida.expDataAdjZero(this.params);
        if (cps.getBoolean("boolean")) {
            MsgBox.showInfo((String)CalculateClientUtil.getCalResource("EXPDataAdjZerING"));
        } else {
            MsgBox.showInfo((String)CalculateClientUtil.getCalResource("ExcepDataAdjZeroFail"));
        }
    }

    @Override
    protected void btn_ViewCostRpt_actionPerformed(ActionEvent e) throws Exception {
        super.btn_ViewCostRpt_actionPerformed(e);
        RptParams filter = new RptParams();
        filter.setString("companyNumber", this.params.getString("COMPANY_NUMBER"));
        filter.setString("materialnumberfrom", this.params.getString("MATERIAL_FROM"));
        filter.setString("materialnumberto", this.params.getString("MATERIAL_TO"));
        filter.setString("name", CalculateClientUtil.getCalResource("COSTCALSUMRPT"));
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"rptparams", (Object)filter);
        ctx.put((Object)"report", (Object)"bAEjbmeGI8XgQKjAYj1IztBgBtA=");
        IUIWindow win = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.base.report.client.ReportViewerUI", (Map)ctx, null);
        win.show();
        ctx.put((Object)"rptparams", (Object)filter);
        ctx.put((Object)"report", (Object)"bAEjbmeGI8XgQKjAYj1IztBgBtA=");
        Window parentWin = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (parentWin != null && parentWin instanceof JDialog) {
            parentWin.dispose();
        }
    }

    private String getAccountTypeName(int accountType) {
        String resFile = "com.kingdee.eas.scm.common.SCMResource";
        String res = "-";
        res = accountType == 3 ? res + EASResource.getString((String)resFile, (String)"ADD_AVERAGE_VALUE") : (accountType == 6 ? res + EASResource.getString((String)resFile, (String)"MOVE_WEIGHTED_AVERAGE_VALUE") : (accountType == 1 ? res + EASResource.getString((String)resFile, (String)"MOVE_ADD_AVERAGE_VALUE") : (accountType == 2 ? res + EASResource.getString((String)resFile, (String)"STANDARDCOST_VALUE") : (accountType == 4 ? res + EASResource.getString((String)resFile, (String)"FIN_FOUT_VALUE") : (accountType == 5 ? res + EASResource.getString((String)resFile, (String)"SPECIAL_ACCT_VALUE") : null)))));
        return res;
    }
}

