/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.base.report.CellEvent;
import com.kingdee.eas.base.report.ReportListener;
import com.kingdee.eas.base.report.client.MenuBuilder;
import com.kingdee.eas.base.report.client.ReportViewerUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CostComputeSumPlugin
extends ReportListener {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.client.CostComputeSumPlugin");
    public static int col = 0;
    public static int sowhSetSize = 0;

    public void onInitialize() throws Exception {
        col = 0;
        RptParams rptParams = this.getReportApplication().getFilter();
        Set sowhSet = (Set)rptParams.getObject("sowhSet");
        if (sowhSet != null) {
            sowhSetSize = sowhSet.size();
        }
        String rptTitle = CalculateClientUtil.getCalResource("COSTCALDETAILRPT");
        this.reportApplication.addBarItem("openDetailCostRpt", rptTitle, rptTitle, rptTitle, null, (Object)EASResource.getIcon((String)"imgTbtn_bill"), null, true, true, false);
        String priceTitle = CalculateClientUtil.getCalResource("CalPriceTitle");
        this.reportApplication.addBarItem("openPriceCostRpt", priceTitle, priceTitle, priceTitle, null, (Object)EASResource.getIcon((String)"imgTbtn_bill"), null, true, true, false);
    }

    public void onMenuClick(String name) throws Exception {
        if (name.equals("openDetailCostRpt")) {
            this.openCostComputeDetailRpt();
        }
        if (name.equals("openPriceCostRpt")) {
            this.openCostComputePriceRpt();
        }
    }

    private void openCostComputePriceRpt() throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        RptParams params = this.reportApplication.getFilter();
        try {
            uiContext.put((Object)"rptFilterInfo", (Object)this.getDetailRptFilterEntity());
            uiContext.put((Object)"rptParams", (Object)this.getReportApplication().getFilter());
            Object companyOrg = params.getObject("FINANCEORG.ID");
            uiContext.put((Object)"orgId", companyOrg);
        }
        catch (SQLException e) {
            throw new UIException((Throwable)e);
        }
        this.checkViewPriceSourcePermission();
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.scm.cal.client.CostComputePriceSourceReportUI", (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public void fireTableDbClick(CellEvent event) throws Exception {
        if (event.getCellValue() != null) {
            this.openCostComputeDetailRpt();
        }
    }

    private void openCostComputeDetailRpt() throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        RptParams params = this.reportApplication.getFilter();
        try {
            uiContext.put((Object)"rptFilterInfo", (Object)this.getDetailRptFilterEntity());
            uiContext.put((Object)"rptParams", (Object)this.getReportApplication().getFilter());
            Object companyOrg = params.getObject("FINANCEORG.ID");
            uiContext.put((Object)"orgId", companyOrg);
        }
        catch (SQLException e) {
            throw new UIException((Throwable)e);
        }
        this.checkViewPermission();
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.scm.cal.client.CostComputeReportUI", (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private void checkViewPermission() throws Exception {
        Object companyOrg;
        RptParams params = this.reportApplication.getFilter();
        if (params != null && params.getObject("FINANCEORG.ID") != null && (companyOrg = params.getObject("FINANCEORG.ID")) != null) {
            ObjectUuidPK orgPk = new ObjectUuidPK((String)companyOrg);
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
            PermissionHelper.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPk, (String)"costComputeReport");
        }
    }

    private void checkViewPriceSourcePermission() throws Exception {
        Object companyOrg;
        RptParams params = this.reportApplication.getFilter();
        if (params != null && params.getObject("FINANCEORG.ID") != null && (companyOrg = params.getObject("FINANCEORG.ID")) != null) {
            ObjectUuidPK orgPk = new ObjectUuidPK((String)companyOrg);
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
            PermissionHelper.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPk, (String)"priceSourceReport");
        }
    }

    private EntityViewInfo getDetailRptFilterEntity() throws SQLException {
        HashMap selectMap;
        ArrayList selList;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        RptParams rptParams = this.getReportApplication().getFilter();
        FilterItemInfo fItemnfo = null;
        if (rptParams != null && (selList = this.reportApplication.getSelectRows()) != null && selList.size() > 0 && (selectMap = (HashMap)selList.get(0)) != null) {
            if (selectMap.get("FSTORAGENUMBER") != null) {
                fItemnfo = new FilterItemInfo("STORAGEORG.NUMBER", selectMap.get("FSTORAGENUMBER"), CompareType.EQUALS);
                filter.getFilterItems().add(fItemnfo);
            }
            if (selectMap.get("FWAREHOUSENUMBER") != null) {
                fItemnfo = new FilterItemInfo("WAREHOUSE.NUMBER", selectMap.get("FWAREHOUSENUMBER"), CompareType.EQUALS);
                filter.getFilterItems().add(fItemnfo);
            }
            if (selectMap.get("FMATERIALNUMBER") != null) {
                fItemnfo = new FilterItemInfo("MATERIAL.NUMBER", selectMap.get("FMATERIALNUMBER"), CompareType.EQUALS);
                filter.getFilterItems().add(fItemnfo);
                rptParams.setString("MATERIAL.NUMBER", (String)selectMap.get("FMATERIALNUMBER"));
            }
            if (selectMap.get("FYEAR") != null) {
                fItemnfo = new FilterItemInfo("YEAR", selectMap.get("FYEAR"), CompareType.EQUALS);
                filter.getFilterItems().add(fItemnfo);
                rptParams.setObject("YEAR", selectMap.get("FYEAR"));
            }
            if (selectMap.get("FPERIOD") != null) {
                fItemnfo = new FilterItemInfo("PERIOD", selectMap.get("FPERIOD"), CompareType.EQUALS);
                filter.getFilterItems().add(fItemnfo);
                rptParams.setObject("PERIOD", selectMap.get("FPERIOD"));
            }
            if (selectMap.get("FCOMPANYORGUNITID") != null) {
                fItemnfo = new FilterItemInfo("FINANCEORG.ID", selectMap.get("FCOMPANYORGUNITID"), CompareType.EQUALS);
                filter.getFilterItems().add(fItemnfo);
                rptParams.setString("FINANCEORG.ID", (String)selectMap.get("FCOMPANYORGUNITID"));
            }
            if (selectMap.get("FLOT") != null) {
                fItemnfo = new FilterItemInfo("Lot", selectMap.get("FLOT"), CompareType.EQUALS);
                filter.getFilterItems().add(fItemnfo);
                rptParams.setString("Lot", (String)selectMap.get("FLOT"));
            }
            if (selectMap.get("FASSISTPROPERTY") != null) {
                fItemnfo = new FilterItemInfo("AssistProperty.number", selectMap.get("FASSISTPROPERTY"), CompareType.EQUALS);
                filter.getFilterItems().add(fItemnfo);
                rptParams.setString("AssistProperty.number", (String)selectMap.get("FASSISTPROPERTY"));
            }
            if (selectMap.get("FPROJECTNUMBER") != null) {
                fItemnfo = new FilterItemInfo("Project.number", selectMap.get("FPROJECTNUMBER"), CompareType.EQUALS);
                filter.getFilterItems().add(fItemnfo);
                rptParams.setString("Project.number", (String)selectMap.get("FPROJECTNUMBER"));
            }
            if (selectMap.get("FTRACKNUMBER") != null) {
                fItemnfo = new FilterItemInfo("trackNumber.number", selectMap.get("FTRACKNUMBER"), CompareType.EQUALS);
                filter.getFilterItems().add(fItemnfo);
                rptParams.setString("trackNumber.number", (String)selectMap.get("FTRACKNUMBER"));
            }
        }
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private void checkSelected() throws UIException {
        try {
            if (this.reportApplication.getSelectRows() == null || this.reportApplication.getSelectRows().size() == 0) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
                SysUtil.abort();
            }
        }
        catch (SQLException e) {
            throw new UIException((Throwable)e);
        }
    }

    protected String getSelectedKeyValue() {
        String keyValue = null;
        try {
            HashMap selectMap;
            ArrayList selList = this.reportApplication.getSelectRows();
            if (selList != null && selList.size() > 0 && (selectMap = (HashMap)selList.get(0)) != null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(selectMap.get("FMATERIALNUMBER"));
                if (selectMap.get("FWAREHOUSENUMBER") != null) {
                    buffer.append(selectMap.get("FWAREHOUSENUMBER"));
                }
                if (selectMap.get("FSTORAGENUMBER") != null) {
                    buffer.append(selectMap.get("FSTORAGENUMBER"));
                }
                keyValue = buffer.toString();
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return keyValue;
    }

    public void fireBeforePrint(boolean isPreview) throws Exception {
        RptParams rptParams = this.getReportApplication().getFilter();
        String companyNumber = rptParams.getString("companyNumber");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)companyNumber, CompareType.EQUALS));
        view.setFilter(filter);
        CoreBaseCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCollection(view);
        if (coll != null && coll.size() > 0) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)coll.get(0);
            CalculateClientUtil.checkHasAuthorized(company.getId().toString(), company.getDisplayName(), OrgType.Company, "invOutSumRpt_Print");
        }
    }

    public void setButtonEnabled(String name, boolean flag) {
        MenuBuilder menuBuilder = ((ReportViewerUI)this.reportApplication.getReportViewer()).getMenuBuilder();
        Component[] buttonComps = menuBuilder.getToolBar().getComponents();
        for (int i = 0; i < buttonComps.length; ++i) {
            KDWorkButton buttonComp;
            if (!(buttonComps[i] instanceof KDWorkButton) || !(buttonComp = (KDWorkButton)buttonComps[i]).getName().equals(name)) continue;
            buttonComp.setEnabled(flag);
            break;
        }
    }
}

