/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.cal.MaterialCalTypeEnum;
import com.kingdee.eas.scm.cal.client.AbstractCostComputeSumRptFilterUI;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMRptFetchData;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CheckRadioFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.MultiF7FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import java.awt.Component;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CostComputeSumRptFilterUI
extends AbstractCostComputeSumRptFilterUI {
    private String calType = null;
    private SCMRptFetchData fetchData;
    private ISCMBillCommonFacade billCommon = SCMBillCommonFacadeFactory.getRemoteInstance();
    private PeriodInfo periodInfo = null;

    public CostComputeSumRptFilterUI() throws Exception {
        this.getElementsInfo();
    }

    private void getElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainOrgElement = new SingleFilterElement("companyNumber", (Component)this.prmtFinanceOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, CalculateClientUtil.getCalResource("COMPANY_NOTNULL")));
        elements.add((FilterElement)mainOrgElement);
        elements.add((FilterElement)new SingleFilterElement("stroageNumber", (Component)this.prmtStorageOrgUnit));
        elements.add((FilterElement)new SingleFilterElement("warehouseNumber", (Component)this.prmtWarehouse));
        elements.add((FilterElement)new MultiF7FilterElement("materialnumberfrom", this.prmtMaterialFrom, Boolean.valueOf(false)));
        elements.add((FilterElement)new SingleFilterElement("materialnumberto", (Component)this.prmtMaterialTo));
        elements.add((FilterElement)new SingleFilterElement("chk_OnlyVisibleErrorRpt", (Component)this.chk_OnlyVisibleErrorRpt));
        elements.add((FilterElement)new CheckRadioFilterElement("kDRadioButton1", (Component)this.kDRadioButton1));
        elements.add((FilterElement)new CheckRadioFilterElement("kDRadioButton2", (Component)this.kDRadioButton2));
        elements.add((FilterElement)new CheckRadioFilterElement("kDRadioButton3", (Component)this.kDRadioButton3));
        this.getFilterManager().setElement((FilterElement)elements);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtFinanceOrgUnit;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.lblCalKind.setText(null);
        this.labPeriod.setText(null);
        this.prmtFinanceOrgUnit.setRequired(true);
        this.initControl();
        this.addControlListener();
        CalculateClientUtil.setF7FilterUIProperties(this.prmtStorageOrgUnit, false);
        CalculateClientUtil.setF7FilterUIProperties(this.prmtWarehouse, false);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    private void initControl() throws Exception {
        this.prmtStorageOrgUnit.setText(null);
        this.prmtStorageOrgUnit.setLabelText(null);
        this.prmtWarehouse.setText(null);
        this.prmtWarehouse.setLabelText(null);
        this.clearStorageOrWarehsFilter(this.prmtStorageOrgUnit);
        this.clearStorageOrWarehsFilter(this.prmtWarehouse);
        this.prmtMaterialFrom.setText(null);
        this.prmtMaterialTo.setText(null);
        this.kDRadioButton3.setSelected(true);
        this.kDRadioButton1.setSelected(false);
        this.prmtFinanceOrgUnit.setText(null);
        this.prmtFinanceOrgUnit.setLabelText(null);
        try {
            this.prmtFinanceOrgUnit.setQueryInfo("com.kingdee.eas.scm.common.app.CompanyOrgUnitQuery");
            SCMClientUtils.setMainBizOrgF7forSealUp((KDBizPromptBox)this.prmtFinanceOrgUnit, (OrgType)OrgType.Company, (String)"invOutSumRpt_View");
            if (this.prmtFinanceOrgUnit.getValue() != null) {
                HashMap<String, String> rptParam = new HashMap<String, String>();
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue();
                rptParam.put("companyId", company.getId().toString());
                this.setCalLable(company);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.setMaterialF7Filter();
        CalculateClientUtil.setStorageOrgF7((CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue(), this.prmtStorageOrgUnit, null);
        this.prmtMaterialFrom.setEnabledMultiSelection(true);
        CalculateClientUtil.addListenerForMultiF7(this.prmtMaterialFrom, this.prmtMaterialTo);
    }

    private void addControlListener() throws Exception {
        this.kDRadioButton1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (CostComputeSumRptFilterUI.this.kDRadioButton1.isSelected()) {
                    CostComputeSumRptFilterUI.this.prmtMaterialFrom.setData(null);
                    CostComputeSumRptFilterUI.this.prmtMaterialFrom.setEnabled(false);
                    CostComputeSumRptFilterUI.this.prmtMaterialTo.setData(null);
                    CostComputeSumRptFilterUI.this.prmtMaterialTo.setEnabled(false);
                }
            }
        });
        this.kDRadioButton2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (CostComputeSumRptFilterUI.this.kDRadioButton2.isSelected()) {
                    CostComputeSumRptFilterUI.this.prmtMaterialFrom.setData(null);
                    CostComputeSumRptFilterUI.this.prmtMaterialFrom.setEnabled(false);
                    CostComputeSumRptFilterUI.this.prmtMaterialTo.setData(null);
                    CostComputeSumRptFilterUI.this.prmtMaterialTo.setEnabled(false);
                }
            }
        });
        this.kDRadioButton3.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (CostComputeSumRptFilterUI.this.kDRadioButton3.isSelected()) {
                    CostComputeSumRptFilterUI.this.prmtMaterialFrom.setData(null);
                    CostComputeSumRptFilterUI.this.prmtMaterialFrom.setEnabled(true);
                    CostComputeSumRptFilterUI.this.prmtMaterialTo.setData(null);
                    CostComputeSumRptFilterUI.this.prmtMaterialTo.setEnabled(true);
                }
            }
        });
        this.prmtFinanceOrgUnit.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    if (e.getSource() != null && CostComputeSumRptFilterUI.this.prmtFinanceOrgUnit.getValue() != null) {
                        CalculateClientUtil.setStorageOrgF7((CompanyOrgUnitInfo)CostComputeSumRptFilterUI.this.prmtFinanceOrgUnit.getValue(), CostComputeSumRptFilterUI.this.prmtStorageOrgUnit, null);
                        CostComputeSumRptFilterUI.this.clearStorageOrWarehsFilter(CostComputeSumRptFilterUI.this.prmtWarehouse);
                        CostComputeSumRptFilterUI.this.setCalLable((CompanyOrgUnitInfo)CostComputeSumRptFilterUI.this.prmtFinanceOrgUnit.getValue());
                    } else {
                        CostComputeSumRptFilterUI.this.clearStorageOrWarehsFilter(CostComputeSumRptFilterUI.this.prmtStorageOrgUnit);
                        CostComputeSumRptFilterUI.this.clearStorageOrWarehsFilter(CostComputeSumRptFilterUI.this.prmtWarehouse);
                    }
                    CostComputeSumRptFilterUI.this.prmtMaterialFrom.setText(null);
                    CostComputeSumRptFilterUI.this.prmtMaterialTo.setText(null);
                    CostComputeSumRptFilterUI.this.setMaterialF7Filter();
                }
                catch (Exception e1) {
                    CostComputeSumRptFilterUI.this.handUIException(e1);
                }
            }
        });
        this.prmtFinanceOrgUnit.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                if (e.getData() != null && e.getData().equals(e.getOldData())) {
                    return;
                }
                try {
                    if (e.getData() != null) {
                        CalculateClientUtil.setStorageOrgF7((CompanyOrgUnitInfo)e.getData(), CostComputeSumRptFilterUI.this.prmtStorageOrgUnit, null);
                        CostComputeSumRptFilterUI.this.clearStorageOrWarehsFilter(CostComputeSumRptFilterUI.this.prmtWarehouse);
                        CostComputeSumRptFilterUI.this.setCalLable((CompanyOrgUnitInfo)e.getData());
                    } else {
                        CostComputeSumRptFilterUI.this.clearStorageOrWarehsFilter(CostComputeSumRptFilterUI.this.prmtStorageOrgUnit);
                        CostComputeSumRptFilterUI.this.clearStorageOrWarehsFilter(CostComputeSumRptFilterUI.this.prmtWarehouse);
                    }
                    CostComputeSumRptFilterUI.this.prmtMaterialFrom.setText(null);
                    CostComputeSumRptFilterUI.this.prmtMaterialTo.setText(null);
                    CostComputeSumRptFilterUI.this.setMaterialF7Filter();
                }
                catch (Exception e1) {
                    CostComputeSumRptFilterUI.this.handUIException(e1);
                }
            }
        });
        this.prmtStorageOrgUnit.addChangeListener(new ChangeListener(){

            public void preChange(PreChangeEvent e) {
                if (e.getData() != null && e.getData().equals(e.getOldData())) {
                    return;
                }
                if (e.getData() != null) {
                    CostComputeSumRptFilterUI.this.setWarehouseFilter((StorageOrgUnitInfo)e.getData(), (StorageOrgUnitInfo)CostComputeSumRptFilterUI.this.prmtStorageOrgUnit.getValue(), CostComputeSumRptFilterUI.this.prmtWarehouse);
                } else if (CostComputeSumRptFilterUI.this.prmtStorageOrgUnit.getValue() == null) {
                    CostComputeSumRptFilterUI.this.clearStorageOrWarehsFilter(CostComputeSumRptFilterUI.this.prmtWarehouse);
                } else {
                    CostComputeSumRptFilterUI.this.prmtWarehouse.setText(null);
                }
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                if (((KDBizPromptBox)e.getSource()).equals(CostComputeSumRptFilterUI.this.prmtStorageOrgUnit)) {
                    if (CostComputeSumRptFilterUI.this.prmtStorageOrgUnit.getValue() != null && "2".equals(CostComputeSumRptFilterUI.this.calType)) {
                        CostComputeSumRptFilterUI.this.setWarehouseFilter((StorageOrgUnitInfo)CostComputeSumRptFilterUI.this.prmtStorageOrgUnit.getValue(), (StorageOrgUnitInfo)CostComputeSumRptFilterUI.this.prmtStorageOrgUnit.getValue(), CostComputeSumRptFilterUI.this.prmtWarehouse);
                    } else if (CostComputeSumRptFilterUI.this.prmtStorageOrgUnit.getValue() == null) {
                        CostComputeSumRptFilterUI.this.clearStorageOrWarehsFilter(CostComputeSumRptFilterUI.this.prmtWarehouse);
                    } else {
                        CostComputeSumRptFilterUI.this.prmtWarehouse.setValue(null);
                    }
                }
            }
        });
    }

    private void clearStorageOrWarehsFilter(KDBizPromptBox box) {
        box.setEnabled(false);
        box.setValue(null);
    }

    private void setCalLable(CompanyOrgUnitInfo e) throws EASBizException, BOSException {
        if (e != null) {
            HashMap<String, String> rptParam = new HashMap<String, String>();
            rptParam.put("companyId", e.getId().toString());
            this.retreFectData(rptParam);
        }
        this.periodInfo = this.getFetchData().getCurrperiod();
        if (this.periodInfo != null) {
            this.labPeriod.setText(this.periodInfo.getPeriodYear() + "." + this.periodInfo.getPeriodNumber());
        }
        this.calType = this.getFetchData().getCalType();
        if ("0".equals(this.calType)) {
            this.prmtStorageOrgUnit.setValue(null);
            this.prmtStorageOrgUnit.setEnabled(false);
            this.lblCalKind.setText(MaterialCalTypeEnum.CAL_TYPE_PARTITION_FINANCE.toString());
        } else {
            this.prmtStorageOrgUnit.setValue(null);
            this.prmtStorageOrgUnit.setEnabled(true);
            this.prmtWarehouse.setEnabled(false);
        }
        if ("1".equals(this.calType)) {
            this.lblCalKind.setText(MaterialCalTypeEnum.CAL_TYPE_PARTITION_STORAGE.toString());
        }
        if ("2".equals(this.calType)) {
            this.lblCalKind.setText(MaterialCalTypeEnum.CAL_TYPE_PARTITION_WAREHOUSE.toString());
        }
    }

    private void setWarehouseFilter(StorageOrgUnitInfo sou, StorageOrgUnitInfo souto, KDBizPromptBox box) {
        this.openStorageOrWarehsFilter(box);
        try {
            box.setEntityViewInfo(InvClientUtils.getWarehouseFilter((StorageOrgUnitInfo)sou, (int)1));
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void openStorageOrWarehsFilter(KDBizPromptBox box) {
        box.setEnabled(true);
        box.setValue(null);
    }

    private void retreFectData(HashMap rptParam) throws EASBizException, BOSException {
        this.fetchData = this.billCommon.getRptFetchData(rptParam);
    }

    public SCMRptFetchData getFetchData() {
        return this.fetchData;
    }

    protected String getViewPermission() {
        return "invOutSumRpt_View";
    }

    private void setMaterialF7Filter() throws Exception {
        CalculateClientUtil.getMaterialF7ForFilterUI((CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue(), (Object)this, this.prmtMaterialFrom, null, true);
        CalculateClientUtil.getMaterialF7ForFilterUI((CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue(), (Object)this, this.prmtMaterialTo, null, false);
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        try {
            String onlyShowError;
            String materialToNumber;
            String btnAllMaterial;
            String whNumber;
            String storageNumber;
            String companyNumber = this.params.getCustomerParam("prmtFinanceOrgUnit");
            if (!StringUtil.isEmpty((String)companyNumber)) {
                CompanyOrgUnitInfo orgUnitInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("select name,number where number = '" + companyNumber + "'");
                this.prmtFinanceOrgUnit.setValue((Object)orgUnitInfo);
            }
            if (!StringUtil.isEmpty((String)(storageNumber = this.params.getCustomerParam("prmtStorageOrgUnit")))) {
                StorageOrgUnitInfo orgUnitInfo = (StorageOrgUnitInfo)StorageOrgUnitFactory.getRemoteInstance().getOrgUnitInfo("select name,number where number = '" + storageNumber + "'");
                this.prmtStorageOrgUnit.setValue((Object)orgUnitInfo);
            }
            if (!StringUtil.isEmpty((String)(whNumber = this.params.getCustomerParam("prmtWarehouse")))) {
                WarehouseInfo orgUnitInfo = WarehouseFactory.getRemoteInstance().getWarehouseInfo("select name,number where number = '" + whNumber + "'");
                this.prmtWarehouse.setValue((Object)orgUnitInfo);
            }
            if ("true".equals(btnAllMaterial = this.params.getCustomerParam("kDRadioButton1"))) {
                this.kDRadioButton1.setSelected(true);
                this.prmtMaterialFrom.setEnabled(false);
                this.prmtMaterialTo.setEnabled(false);
            } else {
                this.kDRadioButton3.setSelected(true);
                this.prmtMaterialFrom.setEnabled(true);
                this.prmtMaterialTo.setEnabled(true);
            }
            String materialFromId = this.params.getCustomerParam("materialnumberfrom");
            if (!StringUtil.isEmpty((String)materialFromId)) {
                if ((materialFromId = materialFromId.replaceAll("\\s", "")).contains(";")) {
                    String[] materialIds = materialFromId.split(";");
                    HashSet<String> materialSet = new HashSet<String>(Arrays.asList(materialIds));
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", materialSet, CompareType.INCLUDE));
                    view.setFilter(filter);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("number"));
                    view.setSelector(sic);
                    MaterialCollection coll = MaterialFactory.getRemoteInstance().getMaterialCollection(view);
                    this.prmtMaterialFrom.setValue((Object)coll);
                    this.prmtMaterialTo.setEnabled(false);
                } else {
                    CoreBaseInfo material = MaterialFactory.getRemoteInstance().getValue("select name,number where id = '" + materialFromId + "'");
                    this.prmtMaterialFrom.setValue((Object)material);
                }
            }
            if (!StringUtil.isEmpty((String)(materialToNumber = this.params.getCustomerParam("materialnumberto")))) {
                CoreBaseInfo material = MaterialFactory.getRemoteInstance().getValue("select name,number where id = '" + materialToNumber + "'");
                this.prmtMaterialTo.setValue((Object)material);
            }
            if ("true".equals(onlyShowError = this.params.getCustomerParam("chk_OnlyVisibleErrorRpt"))) {
                this.chk_OnlyVisibleErrorRpt.setSelected(true);
            } else {
                this.chk_OnlyVisibleErrorRpt.setSelected(false);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }
}

