/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.JobConfig;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.common.perf.client.JobMonitorManager;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.scm.cal.CostUpdateMutexFacadeFactory;
import com.kingdee.eas.scm.cal.client.AbstractDevolveCostCalculateUI;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class DevolveCostCalculateUI
extends AbstractDevolveCostCalculateUI
implements ChangeListener {
    private static final Logger logger = CoreUIObject.getLogger(DevolveCostCalculateUI.class);
    private static final long serialVersionUID = 1L;
    private static final String RESOURCE = "com.kingdee.eas.scm.cal.CalCommonResource";
    private CompanyOrgUnitInfo companyInfo;
    protected F7ContextManager f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType(), 1);

    private void setPeriodEnabled() {
        this.spinBeginYear.setEnabled(false);
        this.spinEndYear.setEnabled(false);
        this.spinBeginPeriod.setEnabled(false);
        this.spinEndPeriod.setEnabled(false);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        CalculateClientUtil.setCompanyOrgF7(this.prmtCompanyOrg, "DevolveCostCalculate", true);
        SCMClientUtils.setF7OrgUnitBizUnit((KDBizPromptBox)this.prmtCompanyOrg);
        SCMClientUtils.setSotrageOrgF7((KDBizPromptBox)this.prmtStorageOrg);
        this.prmtCompanyOrg.addChangeListener((ChangeListener)this);
        this.prmtStorageOrg.addChangeListener((ChangeListener)this);
        this.prmtWarehouse.setEnabledMultiSelection(true);
        this.prmtBillNum.setEnabledMultiSelection(true);
        CalculateClientUtil.InitCompanyF7(this.prmtCompanyOrg, "DevolveCostCalculate");
        if (this.prmtCompanyOrg.getValue() != null) {
            this.companyInfo = (CompanyOrgUnitInfo)this.prmtCompanyOrg.getValue();
            CalculateClientUtil.setStorageOrgF7(this.companyInfo, this.prmtStorageOrg, null);
            CalculateClientUtil.getMaterialF7ForFilterIsRawMaterial(this.companyInfo, this, this.prmtMaterialFrom, null, "subcostcalculate");
            CalculateClientUtil.getMaterialF7ForFilterIsRawMaterial(this.companyInfo, this, this.prmtMaterialTo, null, "subcostcalculate");
        } else {
            this.clearWareHouse(false);
            this.clearStorageOrg(false);
            this.clearBillNumber(false);
        }
        CalculateUtil.loadAccountPeriod(this.prmtCompanyOrg, this.spinBeginYear, this.spinEndYear, this.spinBeginPeriod, this.spinEndPeriod);
        this.setPeriodEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionCalculate_actionPerformed(ActionEvent e) throws Exception {
        CalculateParams params = this.getFilterParam();
        CostUpdateMutexFacadeFactory.getRemoteInstance().checkCostUpdateMutex(params.getString("COMPANY_ID"), "devolveCal");
        JobParam jobParam = new JobParam((Object)params);
        JobConfig jobCfg = this.createJobCfg();
        MsgBox.showWarning((String)CalculateClientUtil.getCalResource("DEVOLVE_COST_CALCULATE_RUNNING_MSG"));
        try {
            String jobInstExtId;
            params.setObject("CURRENT_USER", (Object)SysContext.getSysContext().getCurrentUserInfo());
            params.setObject("CURRENT_COMPANY", (Object)SysContext.getSysContext().getCurrentFIUnit());
            params.setObject("CURRENT_CU", (Object)SysContext.getSysContext().getCurrentCtrlUnit());
            params.setObject("languageLocale", (Object)SysContext.getSysContext().getLocale());
            params.setString("title", CalculateClientUtil.getCalResource("DevolveCostCalculateTitle"));
            Map result = CreateJobFacadeFactory.getRemoteInstance().executeJob(jobParam, jobCfg);
            if (null != result && null != (jobInstExtId = (String)result.get("jobInstExtId"))) {
                JobMonitorManager.getInstance().addMonitorInfo(jobInstExtId, jobCfg.getTitle());
            }
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
        }
        finally {
            this.disposeUIWindow();
        }
    }

    private JobConfig createJobCfg() {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.prmtCompanyOrg.getValue();
        String title = CalculateClientUtil.getCalResource("DevolveCostCalculateTitle");
        JobConfig jobCfg = new JobConfig();
        jobCfg.setTitle(title);
        jobCfg.setTaskType(companyInfo.getNumber() + "SCM_CAL_0004");
        jobCfg.setDescription(title);
        jobCfg.setNeedCheckTaskType(false);
        jobCfg.setMutex("DevolveCostCalculateTitle");
        jobCfg.setNumber("SCM_CAL_0004");
        return jobCfg;
    }

    private CalculateParams getFilterParam() {
        int i;
        Object[] values;
        String companyOrgID = "";
        String storageId = "";
        String materialFromNum = "";
        String materialToNum = "";
        HashSet<String> warehouseList = null;
        HashSet<String> billList = null;
        CalculateParams params = new CalculateParams();
        if ((CompanyOrgUnitInfo)this.prmtCompanyOrg.getValue() != null) {
            companyOrgID = ((CompanyOrgUnitInfo)this.prmtCompanyOrg.getValue()).getId().toString();
            params.setString("COMPANY_ID", companyOrgID);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"COMPANY_NOTNULL"));
            this.abort();
        }
        int beginPeriod = (Integer)this.spinBeginYear.getValue() * 100 + (Integer)this.spinBeginPeriod.getValue();
        int endPeriod = (Integer)this.spinEndYear.getValue() * 100 + (Integer)this.spinEndPeriod.getValue();
        params.setInt("PERIOD_FROM", beginPeriod);
        params.setInt("PERIOD_TO", endPeriod);
        if (this.prmtStorageOrg.getValue() != null) {
            storageId = ((StorageOrgUnitInfo)this.prmtStorageOrg.getValue()).getId().toString();
            params.setString("STORAGEORGUNITID", storageId);
        }
        if (this.prmtWarehouse.getValue() != null) {
            values = (Object[])this.prmtWarehouse.getValue();
            warehouseList = new HashSet<String>(values.length);
            WarehouseInfo warehs = null;
            for (i = 0; i < values.length; ++i) {
                warehs = (WarehouseInfo)values[i];
                if (warehs == null) continue;
                warehouseList.add(warehs.getId().toString());
            }
            params.setObject("WAREHOUSEID", warehouseList);
        }
        if (null != this.prmtMaterialFrom.getValue()) {
            materialFromNum = ((MaterialInfo)this.prmtMaterialFrom.getValue()).getNumber();
            params.setString("MATERIAL_ID_FROM", materialFromNum);
        }
        if (null != this.prmtMaterialTo.getValue()) {
            materialToNum = ((MaterialInfo)this.prmtMaterialTo.getValue()).getNumber();
            params.setString("MATERIAL_ID_TO", materialToNum);
        }
        if (null != this.prmtBillNum.getValue()) {
            values = (Object[])this.prmtBillNum.getValue();
            billList = new HashSet<String>(values.length);
            PurInWarehsBillInfo bill = null;
            for (i = 0; i < values.length; ++i) {
                bill = (PurInWarehsBillInfo)values[i];
                if (bill == null) continue;
                billList.add(bill.getId().toString());
            }
            params.setObject("BILL_ID", billList);
        }
        return params;
    }

    protected void setNeedMainOrgF7s(KDBizPromptBox[] f7s) {
        this.addF7SelectorListener(f7s);
        this.f7Manager.setPrmtNeedOrgF7s(f7s);
    }

    private void addF7SelectorListener(KDBizPromptBox[] f7s) {
        for (int i = 0; i < f7s.length; ++i) {
            f7s[i].addSelectorListener(new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    if (DevolveCostCalculateUI.this.getMainBizOrgF7() != null) {
                        return;
                    }
                    Object value = DevolveCostCalculateUI.this.getMainBizOrgF7().getValue();
                    if (value == null || value instanceof Object[] && ((Object[])value).length == 0 || value instanceof Object[] && ((Object[])value)[0] == null) {
                        MsgBox.showInfo((String)SCMGroupClientUtils.getMainOrgNullMsg((OrgType)DevolveCostCalculateUI.this.getMainBizOrgType()));
                        DevolveCostCalculateUI.this.getMainBizOrgF7().requestFocus();
                        SysUtil.abort();
                    }
                }
            });
        }
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrg;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (((KDBizPromptBox)e.getSource()).equals(this.prmtCompanyOrg)) {
            if (this.prmtCompanyOrg.getValue() != null) {
                this.companyInfo = (CompanyOrgUnitInfo)this.prmtCompanyOrg.getValue();
                try {
                    CalculateClientUtil.getMaterialF7ForFilterIsRawMaterial(this.companyInfo, this, this.prmtMaterialFrom, null, "subcostcalculate");
                    CalculateClientUtil.getMaterialF7ForFilterIsRawMaterial(this.companyInfo, this, this.prmtMaterialTo, null, "subcostcalculate");
                }
                catch (Exception ex) {
                    this.handUIException(ex);
                }
                this.clearStorageOrg(true);
                CalculateClientUtil.setStorageOrgF7(this.companyInfo, this.prmtStorageOrg, null);
                this.clearBillNumber(true);
                this.setF7Filter(this.prmtBillNum, this.getCompanyFilterForBill(this.companyInfo.getId().toString()));
                this.clearWareHouse(false);
                try {
                    CalculateUtil.loadAccountPeriod(this.prmtCompanyOrg, this.spinBeginYear, this.spinEndYear, this.spinBeginPeriod, this.spinEndPeriod);
                }
                catch (EASBizException eas) {
                    this.handUIException(eas);
                }
                catch (BOSException bos) {
                    this.handUIException(bos);
                }
            } else {
                this.clearWareHouse(false);
                this.clearStorageOrg(false);
                this.clearBillNumber(false);
            }
        } else if (((KDBizPromptBox)e.getSource()).equals(this.prmtStorageOrg)) {
            if (this.prmtStorageOrg.getValue() != null) {
                StorageOrgUnitInfo storage = (StorageOrgUnitInfo)this.prmtStorageOrg.getValue();
                this.clearWareHouse(true);
                this.clearBillNumber(true);
                try {
                    this.prmtWarehouse.setEntityViewInfo(InvClientUtils.getWarehouseFilter((StorageOrgUnitInfo)storage, (int)1));
                    this.setF7Filter(this.prmtBillNum, this.getStorageFilterForBill(storage.getId().toString()));
                }
                catch (EASBizException eas) {
                    this.handUIException(eas);
                }
                catch (BOSException bos) {
                    this.handUIException(bos);
                }
            } else {
                this.clearWareHouse(false);
                this.clearBillNumber(false);
            }
        }
    }

    private void clearWareHouse(boolean bln) {
        this.prmtWarehouse.setValue(null);
        this.prmtWarehouse.setEnabled(bln);
    }

    private void clearStorageOrg(boolean bln) {
        this.prmtStorageOrg.setValue(null);
        this.prmtStorageOrg.setEnabled(bln);
    }

    private void clearBillNumber(boolean bln) {
        this.prmtBillNum.setValue(null);
        this.prmtBillNum.setEnabled(bln);
    }

    protected void setMaterialF7BySubContract(KDBizPromptBox bizMaterialBox) {
        this.setF7Filter(bizMaterialBox, this.getMaterialFilterBySubContract());
    }

    protected FilterInfo getMaterialFilterBySubContract() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.companyInfo.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("isOutsourcedPart", (Object)new Integer(1)));
        filterInfo.getFilterItems().add(new FilterItemInfo("BrowserGroup.deletedStatus", (Object)new Integer(1)));
        filterInfo.getFilterItems().add(new FilterItemInfo("BrowserGroup.deletedStatus", null, CompareType.IS));
        filterInfo.setMaskString("#0 And #1 And (#2 or #3)");
        return filterInfo;
    }

    protected FilterInfo getCompanyFilterForBill(String companyId) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyId));
        filterInfo.getFilterItems().add(new FilterItemInfo("purchaseType", (Object)new Integer(1)));
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(4)));
        return filterInfo;
    }

    protected FilterInfo getStorageFilterForBill(String storageId) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageId));
        filterInfo.getFilterItems().add(new FilterItemInfo("purchaseType", (Object)new Integer(1)));
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(4)));
        return filterInfo;
    }

    private void setF7Filter(KDBizPromptBox bizMaterialBox, FilterInfo filterInfo) {
        if (bizMaterialBox != null) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(filterInfo);
            bizMaterialBox.setEntityViewInfo(entityViewInfo);
        }
    }

    private void showSuccess(String key) {
        this.setMessageText(EASResource.getString((String)RESOURCE, (String)key));
        boolean oldbln = this.isShowTextOnly();
        this.setIsShowTextOnly(false);
        this.showMessage();
        if (oldbln) {
            this.setIsShowTextOnly(oldbln);
        }
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }
}

