/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.scm.cal.DevolveMaterialTotalInfo;
import com.kingdee.eas.scm.cal.client.AbstractDevolveMaterialTotalUI;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class DevolveMaterialTotalUI
extends AbstractDevolveMaterialTotalUI {
    private static final Logger logger = CoreUIObject.getLogger(DevolveMaterialTotalUI.class);
    private boolean isOK = false;
    private Map rowMap = new HashMap();

    public boolean isOK() {
        return this.isOK;
    }

    public void setOK(boolean isOK) {
        this.isOK = isOK;
    }

    public Map getRowMap() {
        return this.rowMap;
    }

    public void setRowMap(Map rowMap) {
        this.rowMap = rowMap;
    }

    protected void initWorkButton() {
        this.btnAllSelect.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnNonSelected.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    private void initTable() {
        KDCheckBox checkBox = new KDCheckBox();
        this.kdtable.getColumn("selected").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)checkBox));
        this.checkRows(true);
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        this.setOK(true);
        IRow row = null;
        String materialID = null;
        BigDecimal totalQty = null;
        int n = this.kdtable.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.kdtable.getRow(i);
            materialID = row.getCell("materialID").getValue().toString();
            if (row.getCell("selected").getValue().equals(Boolean.FALSE)) {
                this.rowMap.remove(materialID);
                continue;
            }
            totalQty = (BigDecimal)row.getCell("currentQty").getValue();
            DevolveMaterialTotalInfo totalInfo = (DevolveMaterialTotalInfo)this.rowMap.get(materialID);
            if (totalInfo == null) continue;
            totalInfo.setUnWriteOffTotalBaseQty(totalQty);
        }
        this.getUIWindow().close();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setOK(false);
        this.getUIWindow().close();
    }

    @Override
    public void actionSelect_actionPerformed(ActionEvent e) throws Exception {
        this.checkRows(true);
    }

    @Override
    public void actionNonSelect_actionPerformed(ActionEvent e) throws Exception {
        this.checkRows(false);
    }

    public void onLoad() throws Exception {
        this.kdtable.checkParsed();
        this.addListeners();
        this.bindingData();
        this.initWorkButton();
        this.initTable();
        super.onLoad();
    }

    private void bindingData() {
        Map uictx = this.getUIContext();
        if (uictx.get("materials") != null) {
            HashMap materialMap = (HashMap)uictx.get("materials");
            this.setRowMap(materialMap);
        }
        int precision = 4;
        KDFormattedTextField currentQty = null;
        if (this.rowMap != null && this.rowMap.size() != 0) {
            Iterator iterator = this.rowMap.keySet().iterator();
            DevolveMaterialTotalInfo info = null;
            while (iterator.hasNext()) {
                String key = iterator.next().toString();
                info = (DevolveMaterialTotalInfo)this.rowMap.get(key);
                IRow row = this.kdtable.addRow();
                precision = info.getBaseQtyPrecision();
                currentQty = new KDFormattedTextField(1);
                currentQty.setEditable(true);
                currentQty.setPrecision(precision);
                KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((JTextField)currentQty);
                row.getCell("totalQty").setEditor((ICellEditor)itemEditor);
                row.getCell("currentQty").setEditor((ICellEditor)itemEditor);
                row.getCell("totalQty").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)precision));
                row.getCell("currentQty").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)precision));
                row.getCell("materialID").setValue((Object)info.getMaterialID());
                row.getCell("materialNumber").setValue((Object)info.getMaterialNumber());
                row.getCell("materialName").setValue((Object)info.getMaterialName());
                row.getCell("materialModel").setValue((Object)info.getMaterialModel());
                row.getCell("baseUnit").setValue((Object)info.getBaseUnit());
                row.getCell("totalQty").setValue((Object)info.getUnWriteOffTotalBaseQty());
                row.getCell("currentQty").setValue((Object)info.getUnWriteOffTotalBaseQty());
                row.getCell("baseQtyPrecision").setValue((Object)info.getBaseQtyPrecision());
            }
        }
    }

    private void checkRows(boolean flag) {
        Boolean check = flag;
        int count = this.kdtable.getRowCount();
        ICell cell = null;
        for (int i = 0; i < count; ++i) {
            cell = this.kdtable.getCell(i, "selected");
            cell.setValue((Object)check);
        }
    }

    private boolean checkData(BigDecimal oldValue, BigDecimal newValue) {
        boolean flag = true;
        if (newValue.compareTo(oldValue) > 0) {
            flag = false;
        }
        if (newValue.compareTo(CalculateUtil.ZERO) <= 0) {
            flag = false;
        }
        return flag;
    }

    private void addListeners() {
        this.kdtable.addKDTEditListener(new KDTEditListener(){

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                if (e.getColIndex() == DevolveMaterialTotalUI.this.kdtable.getColumnIndex("currentQty")) {
                    Object oldValue = e.getOldValue();
                    Object newValue = e.getValue();
                    int rowIndex = e.getRowIndex();
                    if (newValue == null) {
                        DevolveMaterialTotalUI.this.kdtable.getCell(rowIndex, "currentQty").setValue(oldValue);
                        return;
                    }
                    Object totalQty = DevolveMaterialTotalUI.this.kdtable.getCell(rowIndex, "totalQty").getValue();
                    boolean flag = DevolveMaterialTotalUI.this.checkData(new BigDecimal(totalQty.toString()), new BigDecimal(newValue.toString()));
                    if (!flag) {
                        DevolveMaterialTotalUI.this.kdtable.getCell(rowIndex, "currentQty").setValue(oldValue);
                    }
                }
            }

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
    }
}

