/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.cal.EvaluateDetailReportFacadeFactory;
import com.kingdee.eas.scm.cal.VoucheredEnum;
import com.kingdee.eas.scm.cal.client.AbstractEvaluateDetailReportUI;
import com.kingdee.eas.scm.cal.client.EvaluateDetailReportConditionUI;
import com.kingdee.eas.scm.cal.client.EvaluateDetailReportDataProvider;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.client.PurInWarehsBillEditUI;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class EvaluateDetailReportUI
extends AbstractEvaluateDetailReportUI {
    private static final Logger logger = CoreUIObject.getLogger(EvaluateDetailReportUI.class);
    private static final String permItem_print = "evaluatedetailreport_print";
    private Object[] pkCollection;
    private int currentPKIndex = -1;
    private RptRowSet currentRowSet = null;
    private String res = "com.kingdee.eas.scm.cal.CalRptResource";
    public static final Color necessaryColor = new Color(252, 251, 223);

    public EvaluateDetailReportUI() throws Exception {
        this.initToolbar();
        this.tbl.setEditable(false);
        this.tbl.getActionMap().remove("Delete");
        this.tbl.checkParsed();
        this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tbl.getDataRequestManager().setDataRequestMode(1);
        this.enableExportExcel(this.tbl);
        this.tbl.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                EvaluateDetailReportUI.this.tbl_afterDataFill(e, EvaluateDetailReportUI.this.tbl);
            }
        });
        this.tbl.getDataRequestManager().setExportMemoryCallback(false);
    }

    protected void tbl_afterDataFill(KDTDataRequestEvent e, KDTable tbl) {
        int from = e.getFirstRow();
        int last = e.getLastRow();
        for (int i = from; i <= last; ++i) {
            IRow row = tbl.getRow(i);
            String transaction = (String)row.getCell("FTransactionType").getValue();
            if (!EASResource.getString((String)this.res, (String)"BEGINBALANCE").equals(transaction) && !EASResource.getString((String)this.res, (String)"PERIODTOTAL").equals(transaction) && !EASResource.getString((String)this.res, (String)"YEARTOTAL").equals(transaction)) continue;
            row.getStyleAttributes().setBackground(necessaryColor);
        }
    }

    public void onLoad() throws Exception {
        if (this.getUIContext().get("rptParams") != null) {
            this.params = (RptParams)this.getUIContext().get("rptParams");
            this.btnFirst.setVisible(false);
            this.btnPre.setVisible(false);
            this.btnNext.setVisible(false);
            this.btnLast.setVisible(false);
            this.btnQuery.setVisible(false);
            this.menuItemFirst.setVisible(false);
            this.menuItemPre.setVisible(false);
            this.menuItemNext.setVisible(false);
            this.menuItemLast.setVisible(false);
            this.menuItemQuery.setVisible(false);
            this.currentPKIndex = -2;
            super.initWorkButton();
            super.onLoad();
            this.init();
            this.query();
        } else {
            super.onLoad();
        }
    }

    private void initToolbar() {
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnFirst.setIcon(EASResource.getIcon((String)"imgTbtn_first"));
        this.btnPre.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.btnNext.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.btnLast.setIcon(EASResource.getIcon((String)"imgTbtn_last"));
        this.btnViewUI.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        this.menuItemFirst.setIcon(EASResource.getIcon((String)"imgTbtn_first"));
        this.menuItemPre.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.menuItemNext.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.menuItemLast.setIcon(EASResource.getIcon((String)"imgTbtn_last"));
        this.menuViewDetail.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
    }

    @Override
    protected void tbl_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            ActionEvent evt = new ActionEvent(this.btnViewUI, 0, "Double Clicked");
            ItemAction actView = this.getActionFromActionEvent(evt);
            actView.actionPerformed(evt);
        }
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.currentPKIndex = -1;
        super.actionQuery_actionPerformed(e);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.params.getObject("company");
        if (company != null) {
            IMRptUtils.checkHasAuthorized((String)company.getId().toString(), (OrgType)OrgType.Company, (String)permItem_print);
            this.invokePrintFunction(true, e);
        }
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.params.getObject("company");
        if (company != null) {
            IMRptUtils.checkHasAuthorized((String)company.getId().toString(), (OrgType)OrgType.Company, (String)permItem_print);
            this.invokePrintFunction(false, e);
        }
    }

    @Override
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.changeMaterialID(6);
        this.query();
    }

    @Override
    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.changeMaterialID(7);
        this.query();
    }

    @Override
    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.changeMaterialID(8);
        this.query();
    }

    @Override
    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.changeMaterialID(9);
        this.query();
    }

    private void getMaterialPKList(RptParams params) throws EASBizException, BOSException {
        this.pkCollection = EvaluateDetailReportFacadeFactory.getRemoteInstance().getMaterialPKArray(params);
    }

    private Object getCurrentPKInCollection() {
        if (this.pkCollection == null) {
            this.currentPKIndex = -1;
            return null;
        }
        if (this.pkCollection.length <= 0) {
            this.currentPKIndex = -1;
            return null;
        }
        if (this.pkCollection.length >= 1 && this.currentPKIndex >= this.pkCollection.length) {
            this.currentPKIndex = this.pkCollection.length - 1;
        } else if (this.currentPKIndex <= 0) {
            this.currentPKIndex = 0;
        }
        return this.pkCollection[this.currentPKIndex];
    }

    private void changeMaterialID(int changeAction) throws BOSException, EASBizException {
        switch (changeAction) {
            case 6: {
                this.currentPKIndex = 0;
                break;
            }
            case 7: {
                --this.currentPKIndex;
                break;
            }
            case 8: {
                ++this.currentPKIndex;
                break;
            }
            case 9: {
                if (this.pkCollection == null) {
                    return;
                }
                if (this.pkCollection.length == 0) {
                    return;
                }
                this.currentPKIndex = this.pkCollection.length - 1;
            }
        }
    }

    private void getMaterialID() {
        String matID = null;
        Object pk = null;
        try {
            if (this.currentPKIndex != -2) {
                if (this.currentPKIndex == -1) {
                    this.changeMaterialID(6);
                }
                if ((pk = this.getCurrentPKInCollection()) != null) {
                    matID = pk.toString();
                }
                this.params.setString("CurrentMaterialID", matID);
            }
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    private void setChangeRecordButton() {
        if (this.pkCollection == null) {
            this.btnFirst.setEnabled(false);
            this.btnPre.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
            this.menuItemFirst.setEnabled(false);
            this.menuItemPre.setEnabled(false);
            this.menuItemNext.setEnabled(false);
            this.menuItemLast.setEnabled(false);
        } else if (this.pkCollection.length <= 1) {
            this.btnFirst.setEnabled(false);
            this.btnPre.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
            this.menuItemFirst.setEnabled(false);
            this.menuItemPre.setEnabled(false);
            this.menuItemNext.setEnabled(false);
            this.menuItemLast.setEnabled(false);
        } else if (this.currentPKIndex <= 0) {
            this.btnFirst.setEnabled(false);
            this.btnPre.setEnabled(false);
            this.btnNext.setEnabled(true);
            this.btnLast.setEnabled(true);
            this.menuItemFirst.setEnabled(false);
            this.menuItemPre.setEnabled(false);
            this.menuItemNext.setEnabled(true);
            this.menuItemLast.setEnabled(true);
        } else if (this.currentPKIndex >= this.pkCollection.length - 1) {
            this.btnFirst.setEnabled(true);
            this.btnPre.setEnabled(true);
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
            this.menuItemFirst.setEnabled(true);
            this.menuItemPre.setEnabled(true);
            this.menuItemNext.setEnabled(false);
            this.menuItemLast.setEnabled(false);
        } else {
            this.btnFirst.setEnabled(true);
            this.btnPre.setEnabled(true);
            this.btnNext.setEnabled(true);
            this.btnLast.setEnabled(true);
            this.menuItemFirst.setEnabled(true);
            this.menuItemPre.setEnabled(true);
            this.menuItemNext.setEnabled(true);
            this.menuItemLast.setEnabled(true);
        }
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!this.checkObjectExists()) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected String getSelectedKeyValue() {
        KDTSelectBlock selectBlock = this.tbl.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tbl.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell(this.getKeyFieldName());
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if (!((keyValue = cell.getValue()) == null || keyValue.equals("0") || keyValue.equals(" ") || keyValue.equals(""))) {
                return keyValue.toString();
            }
            return null;
        }
        return null;
    }

    protected String getCellValue(String cellField) {
        KDTSelectBlock selectBlock = this.tbl.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tbl.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell(cellField);
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        }
        return null;
    }

    private String getKeyFieldName() {
        return "FID";
    }

    private String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        RealModeIDList idList = new RealModeIDList();
        idList.add(this.getSelectedKeyValue());
        uiContext.put((Object)"IDList", (Object)idList);
    }

    private String getEditUIName() {
        int sortType = new Integer(this.getCellValue("FBillType"));
        switch (sortType) {
            case 0: {
                return PurInWarehsBillEditUI.class.getName();
            }
            case 1: {
                return PurInWarehsBillEditUI.class.getName();
            }
        }
        return PurInWarehsBillEditUI.class.getName();
    }

    private ICoreBase getBizInterface() throws Exception {
        int sortType = new Integer(this.getCellValue("FBillType"));
        switch (sortType) {
            case 0: {
                return PurInWarehsBillFactory.getRemoteInstance();
            }
            case 1: {
                return PurInWarehsBillFactory.getRemoteInstance();
            }
        }
        return PurInWarehsBillFactory.getRemoteInstance();
    }

    private void checkSelected() {
        if (this.tbl.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    private boolean checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.getSelectedKeyValue() == null) {
            return false;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        return true;
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return EvaluateDetailReportFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tbl;
    }

    protected RptParams getParamsForInit() {
        RptParams initParam = new RptParams();
        return initParam;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        EvaluateDetailReportConditionUI condUI = new EvaluateDetailReportConditionUI();
        condUI.setSize(380, 340);
        return condUI;
    }

    protected void query() {
        try {
            String PeriodFrom = String.valueOf(this.params.getInt("accPeriodYearFrom")) + "." + String.valueOf(this.params.getInt("accPeriodMonthFrom"));
            String PeriodTo = String.valueOf(this.params.getInt("accPeriodYearTo")) + "." + String.valueOf(this.params.getInt("accPeriodMonthTo"));
            this.txtPeriod.setText(PeriodFrom + " - " + PeriodTo);
            if (this.currentPKIndex == -1) {
                this.getMaterialPKList(this.params);
            } else if (this.currentPKIndex == -2) {
                this.pkCollection = new Object[]{this.params.getString("CurrentMaterialID")};
            }
            this.getMaterialID();
            this.setChangeRecordButton();
            if (this.params.getObject("company") != null) {
                this.bizCompany.setValue((Object)((CompanyOrgUnitInfo)this.params.getObject("company")));
                this.companyName.setText(((CompanyOrgUnitInfo)this.params.getObject("company")).getName());
            } else {
                this.bizCompany.setValue(null);
                this.companyName.setText("");
            }
            if (this.params.getString("CurrentMaterialID") != null) {
                MaterialInfo aMaterialInfo = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(this.params.getString("CurrentMaterialID")));
                this.bizMaterialName.setValue((Object)aMaterialInfo);
                this.materialName.setText(aMaterialInfo.getName());
                if (aMaterialInfo.getModel() != null) {
                    this.txtModel.setText(aMaterialInfo.getModel().toString());
                } else {
                    this.txtModel.setText("");
                }
                String unitID = aMaterialInfo.getBaseUnit().getId().toString();
                MeasureUnitInfo aMeasureUnitInfo = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(unitID));
                this.txtUnit.setText(aMeasureUnitInfo.toString());
            } else {
                this.bizMaterialName.setValue(null);
                this.materialName.setText("");
            }
            if (this.params.getObject("voucher") != null) {
                this.txtVoucher.setText(((VoucheredEnum)((Object)this.params.getObject("voucher"))).getAlias());
            } else {
                this.txtVoucher.setText("");
            }
            if (this.params.getObject("status") != null) {
                this.txtStatus.setText(((BillBaseStatusEnum)this.params.getObject("status")).getAlias());
            } else {
                this.txtStatus.setText("");
            }
            this.tbl.removeColumns();
            if (this.params.getString("CurrentMaterialID") != null) {
                this.tbl.removeRows();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.initUIMainOrgContext(((CompanyOrgUnitInfo)this.params.getObject("company")).getId().toString());
        this.initUserConfig();
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        try {
            RptParams rpt;
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            RptParams para = new RptParams();
            int prcPrecision = 6;
            para.setString("CurrentMaterialID", this.params.getString("CurrentMaterialID"));
            para.setObject("company", this.params.getObject("company"));
            if (from == 0) {
                int i;
                boolean flag;
                para.setBoolean("filteNoINOut", this.params.getBoolean("filteNoINOut"));
                para.setString("tempTable", this.getTempTable());
                para.setObject("materialFrom", this.params.getObject("materialFrom"));
                para.setObject("materialTo", this.params.getObject("materialTo"));
                para.setObject("voucher", this.params.getObject("voucher"));
                para.setObject("status", this.params.getObject("status"));
                para.setInt("accPeriodYearFrom", this.params.getInt("accPeriodYearFrom"));
                para.setInt("accPeriodMonthFrom", this.params.getInt("accPeriodMonthFrom"));
                para.setInt("accPeriodYearTo", this.params.getInt("accPeriodYearTo"));
                para.setInt("accPeriodMonthTo", this.params.getInt("accPeriodMonthTo"));
                para.setObject("supperFrom", this.params.getObject("supperFrom"));
                para.setObject("supperTo", this.params.getObject("supperTo"));
                if (this.params.getObject("storageOrgUnit") != null) {
                    Object[] storageArray = (Object[])this.params.getObject("storageOrgUnit");
                    StringBuffer storageOrgNumber = new StringBuffer();
                    flag = true;
                    for (i = 0; i < storageArray.length; ++i) {
                        StorageOrgUnitInfo storageInfo = (StorageOrgUnitInfo)storageArray[i];
                        if (storageInfo == null) {
                            flag = false;
                            continue;
                        }
                        if (i != 0) {
                            storageOrgNumber.append(",");
                        }
                        storageOrgNumber.append("'").append(storageInfo.getNumber()).append("'");
                    }
                    if (storageOrgNumber.length() > 0 && flag) {
                        para.setString("storageOrgUnit", storageOrgNumber.toString());
                    }
                }
                if (this.getUIContext().get("rptParams") != null) {
                    if (this.params.getObject("warehouse") != null) {
                        Object[] warehsArray = (Object[])this.params.getObject("warehouse");
                        StringBuffer warehsNumber = new StringBuffer();
                        flag = true;
                        for (i = 0; i < warehsArray.length; ++i) {
                            WarehouseInfo warehouse = (WarehouseInfo)warehsArray[i];
                            if (warehouse == null) {
                                flag = false;
                                continue;
                            }
                            if (i != 0) {
                                warehsNumber.append(",");
                            }
                            warehsNumber.append("'").append(warehouse.getNumber()).append("'");
                        }
                        if (warehsNumber.length() > 0 && flag) {
                            para.setString("warehouse", warehsNumber.toString());
                        }
                    }
                    para.setBoolean("IsJoinQuery", true);
                } else {
                    para.setObject("warehouseFrom", this.params.getObject("warehouseFrom"));
                    para.setObject("warehouseTo", this.params.getObject("warehouseTo"));
                    para.setBoolean("IsJoinQuery", false);
                }
                rpt = EvaluateDetailReportFacadeFactory.getRemoteInstance().createTempTable(para);
                this.setTempTable(rpt.getString("tempTable"));
                RptTableHeader header = (RptTableHeader)rpt.getObject("header");
                KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tbl);
                this.tbl.setRowCount(rpt.getInt("verticalCount"));
            }
            para.setString("tempTable", this.getTempTable());
            para.setString("isPrint", this.params.getString("isPrint"));
            rpt = EvaluateDetailReportFacadeFactory.getRemoteInstance().query(para, from, len);
            if ("true".equals(this.params.getString("isPrint"))) {
                this.currentRowSet = (RptRowSet)rpt.getObject("printRs");
                this.params.setString("isPrint", "false");
            }
            RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
            prcPrecision = rpt.getInt("prcPrecision");
            KDTableUtil.insertRows((RptRowSet)rs, (int)from, (KDTable)this.tbl);
            this.afterDataFill(e, prcPrecision);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void afterDataFill(KDTDataRequestEvent e, int prcPrecision) {
        BigDecimal zero;
        String fieldName = null;
        int index_ix = 0;
        int beqty_ix = 0;
        int beamt_ix = 0;
        int inqty_ix = 0;
        int inamt_ix = 0;
        int outqty_ix = 0;
        int outamt_ix = 0;
        int price_ix = 0;
        int columnCount = this.tbl.getColumnCount();
        for (int c = 0; c < columnCount; ++c) {
            fieldName = this.tbl.getColumnKey(c).toLowerCase();
            if (fieldName.equals("ftransactiontype")) {
                index_ix = c;
            }
            if (fieldName.equals("fremainqty")) {
                beqty_ix = c;
            }
            if (fieldName.equals("fremainamount")) {
                beamt_ix = c;
            }
            if (fieldName.equals("finqty")) {
                inqty_ix = c;
            }
            if (fieldName.equals("finamount")) {
                inamt_ix = c;
            }
            if (fieldName.equals("foutqty")) {
                outqty_ix = c;
            }
            if (fieldName.equals("foutamount")) {
                outamt_ix = c;
            }
            if (!fieldName.equals("fremainunitprice")) continue;
            price_ix = c;
        }
        String beginBalance = EASResource.getString((String)this.res, (String)"BEGINBALANCE");
        String periodTotal = EASResource.getString((String)this.res, (String)"PERIODTOTAL");
        String yearTotal = EASResource.getString((String)this.res, (String)"YEARTOTAL");
        int from = e.getFirstRow();
        int last = e.getLastRow();
        IRow row = null;
        IRow uprow = null;
        String scale = null;
        String up = null;
        BigDecimal beginQty = zero = new BigDecimal("0.00");
        BigDecimal beginAmt = zero;
        BigDecimal upQty = zero;
        BigDecimal upAmt = zero;
        BigDecimal inQty = zero;
        BigDecimal inAmt = zero;
        BigDecimal outQty = zero;
        BigDecimal outAmt = zero;
        BigDecimal endQty = zero;
        BigDecimal endAmt = zero;
        BigDecimal endPrice = zero;
        for (int i = from; i <= last; ++i) {
            row = this.tbl.getRow(i);
            if (row == null) {
                return;
            }
            if (row.getCell(index_ix) == null || row.getCell(beqty_ix) == null || row.getCell(beamt_ix) == null || row.getCell(inqty_ix) == null || row.getCell(inamt_ix) == null || row.getCell(outqty_ix) == null || row.getCell(outamt_ix) == null || row.getCell(price_ix) == null) {
                return;
            }
            Object scaleObj = row.getCell(index_ix).getValue();
            if (scaleObj == null) continue;
            scale = scaleObj.toString();
            if (beginBalance != null && beginBalance.equals(scale)) {
                beginQty = row.getCell(beqty_ix).getValue() == null ? zero : (BigDecimal)row.getCell(beqty_ix).getValue();
                BigDecimal bigDecimal = beginAmt = row.getCell(beamt_ix).getValue() == null ? zero : (BigDecimal)row.getCell(beamt_ix).getValue();
            }
            if (beginBalance == null || periodTotal == null || yearTotal == null || beginBalance.equals(scale) || periodTotal.equals(scale) || yearTotal.equals(scale)) continue;
            if (i == 0) {
                upQty = zero;
                upAmt = zero;
            } else {
                uprow = this.tbl.getRow(i - 1);
                Object upObj = uprow.getCell(index_ix).getValue();
                if (upObj != null) {
                    up = upObj.toString();
                    if (beginBalance.equals(up)) {
                        upQty = beginQty;
                        upAmt = beginAmt;
                    } else {
                        upQty = uprow.getCell(beqty_ix).getValue() == null ? zero : (BigDecimal)uprow.getCell(beqty_ix).getValue();
                        upAmt = uprow.getCell(beamt_ix).getValue() == null ? zero : (BigDecimal)uprow.getCell(beamt_ix).getValue();
                    }
                }
            }
            inQty = row.getCell(inqty_ix).getValue() == null ? zero : (BigDecimal)row.getCell(inqty_ix).getValue();
            inAmt = row.getCell(inamt_ix).getValue() == null ? zero : (BigDecimal)row.getCell(inamt_ix).getValue();
            outQty = row.getCell(outqty_ix).getValue() == null ? zero : (BigDecimal)row.getCell(outqty_ix).getValue();
            outAmt = row.getCell(outamt_ix).getValue() == null ? zero : (BigDecimal)row.getCell(outamt_ix).getValue();
            endQty = upQty.add(inQty).subtract(outQty);
            endAmt = upAmt.add(inAmt).subtract(outAmt);
            endPrice = endQty.compareTo(zero) != 0 ? endAmt.divide(endQty, prcPrecision, 4) : zero;
            row.getCell(beqty_ix).setValue((Object)endQty);
            row.getCell(price_ix).setValue((Object)endPrice);
            row.getCell(beamt_ix).setValue((Object)endAmt);
        }
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        String res = "com.kingdee.eas.scm.cal.CalRptResource";
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)res, (String)"FICU")).append("&[Company]").append("&|");
        sb.append(EASResource.getString((String)res, (String)"YEARPERIOD")).append("&[Period]").append("&|");
        sb.append(EASResource.getString((String)res, (String)"MATERIELCODE")).append("&[MATERIELCODE]").append("&|");
        sb.append(EASResource.getString((String)res, (String)"MATERIELNAME")).append("&[MATERIELNAME]").append("&|");
        sb.append(EASResource.getString((String)res, (String)"MODEL")).append("&[MODEL]").append("&|");
        sb.append(EASResource.getString((String)res, (String)"BASEUNIT")).append("&[BASEUNIT]").append("&|\r\n");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        if (this.params.getString("CurrentMaterialID") == null) {
            return null;
        }
        MaterialInfo aMaterialInfo = null;
        MeasureUnitInfo aMeasureUnitInfo = null;
        String PeriodFrom = String.valueOf(this.params.getInt("accPeriodYearFrom")) + "." + String.valueOf(this.params.getInt("accPeriodMonthFrom"));
        String PeriodTo = String.valueOf(this.params.getInt("accPeriodYearTo")) + "." + String.valueOf(this.params.getInt("accPeriodMonthTo"));
        try {
            aMaterialInfo = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(this.params.getString("CurrentMaterialID")), SCMSelectorFactory.getMaterialInfoSelector());
            String unitID = aMaterialInfo.getBaseUnit().getId().toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            aMeasureUnitInfo = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(unitID));
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Company", ":" + ((CompanyOrgUnitInfo)this.params.getObject("company")).getName());
        map.put("Period", ":" + PeriodFrom + " - " + PeriodTo);
        map.put("MATERIELCODE", ":" + aMaterialInfo.getNumber());
        map.put("MATERIELNAME", ":" + aMaterialInfo.getName());
        map.put("MODEL", ":" + aMaterialInfo.getModel());
        map.put("BASEUNIT", ":" + aMeasureUnitInfo.getName());
        return map;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected void invokePrintFunction(boolean isPrint, ActionEvent e) throws Exception {
        EvaluateDetailReportDataProvider data = new EvaluateDetailReportDataProvider();
        if (isPrint) {
            if (this.pkCollection == null || this.pkCollection.length == 0) {
                MsgBox.showError((String)EASResource.getString((String)(this.res + ".DATA_BLANK")));
                SysUtil.abort();
                data.insertDataToDynamicRowSet(this.params, this.currentRowSet);
            } else {
                int tempPKIndex = this.currentPKIndex;
                this.currentPKIndex = -1;
                for (int i = 0; i < this.pkCollection.length; ++i) {
                    this.params.setString("isPrint", "true");
                    this.actionNext_actionPerformed(e);
                    data.insertDataToDynamicRowSet(this.params, this.currentRowSet);
                }
                this.currentPKIndex = tempPKIndex - 1;
                this.actionNext_actionPerformed(e);
            }
        } else if (this.pkCollection != null && this.pkCollection.length != 0) {
            this.params.setString("isPrint", "true");
            --this.currentPKIndex;
            this.actionNext_actionPerformed(e);
            data.insertDataToDynamicRowSet(this.params, this.currentRowSet);
        } else {
            MsgBox.showError((String)EASResource.getString((String)(this.res + ".DATA_BLANK")));
            SysUtil.abort();
        }
        if (this.getTDFileName() == null) {
            return;
        }
        KDNoteHelper appHlp = new KDNoteHelper();
        if (isPrint) {
            appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    public Object getTablePreferenceSchemaKey() {
        QuerySolutionInfo currentSolutionInfo;
        Object obj = super.getTablePreferenceSchemaKey();
        if (obj == null && (currentSolutionInfo = this.queryDialog.getCommonQueryParam().getCurrentSolutionInfo()) != null) {
            obj = currentSolutionInfo.getId();
        }
        return obj;
    }

    protected String getTDFileName() {
        return "/FI/CAL/EvaluateDetailReport";
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        if (this.getUIContext().get("rptParams") != null) {
            return true;
        }
        if (useDefaultSolution) {
            IQuerySolutionFacade iQuery = null;
            QuerySolutionInfo solution = null;
            try {
                iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
                String queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.getQueryMetaDataPK()).getFullName();
                solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
                this.queryDialog.setCurrentSolutionInfo(solution);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (solution == null || EASResource.getString((String)"com.kingdee.eas.framework.report.CommRptResource", (String)"DefaultSolution").equals(solution.getName())) {
                useDefaultSolution = false;
            }
        }
        return super.showQueryDialog(useDefaultSolution);
    }
}

