/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditHelper;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionEvent;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptCellFormatter;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.CloseAccountFacadeFactory;
import com.kingdee.eas.scm.cal.ExceptionBalanceReportFacadeFactory;
import com.kingdee.eas.scm.cal.ICloseAccountFacade;
import com.kingdee.eas.scm.cal.IExceptionBalanceReportFacade;
import com.kingdee.eas.scm.cal.IssueTypeEnum;
import com.kingdee.eas.scm.cal.client.AbstractExceptionBalanceReportUI;
import com.kingdee.eas.scm.cal.client.ExceptionBalanceCostAdjustOptionUI;
import com.kingdee.eas.scm.cal.client.ExceptionBalanceReportFilterUI;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.util.numeric.PrecisionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ExceptionBalanceReportUI
extends AbstractExceptionBalanceReportUI {
    private static final Logger logger = ExceptionBalanceReportUI.getLogger(ExceptionBalanceReportUI.class);
    private static final long serialVersionUID = -7005417636371425992L;
    String formaStr = RptCellFormatter.getTrimZeroFormat();
    private static final String EXISTISSUERECORD = "ExistIssueRecord";
    private static final String EXISTUNISSUERECORD = "ExistUnIssueRecord";
    private CompanyOrgUnitInfo mainBizorg = null;
    private String[] lockColNames = new String[]{"isIssueBill", "year", "period", "storageOrgUnit", "assistProperty", "warehourse", "location", "materialID", "materialNumber", "materialName", "shortName", "model", "lot", "project", "trackNumber", "qty", "amount", "diffAmount", "storeType", "storeStatus", "customer"};
    private String[] fmtColNames = new String[]{"amount", "adjustAmount", "diffAmount"};
    private String calType = null;
    private ExceptionBalanceReportFilterUI filterUI = null;
    private KDComboBox comBoxOutWareTpye = null;
    private RptParams globalRptParams = null;
    private RptParams costAdjustBillRptParams = new RptParams();
    private String[] invBalanceIDs = null;
    private IExceptionBalanceReportFacade ieb = null;
    private Set<Integer> selectedRow = null;
    private boolean isEndAdjust = false;
    private KDComboBox bizTpye = null;
    private Map param = new HashMap();
    private final String CAL_RESOURCE = "com.kingdee.eas.scm.cal.CalRptResource";
    private final String CAL_COM_RESOURCE = "com.kingdee.eas.scm.cal.CalCommonResource";
    private KDTEditHelper kdtEditHelper = new KDTEditHelper(this.tblMain);

    public ExceptionBalanceReportUI() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getActionMap().remove("Delete");
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.enableExportExcel(this.tblMain);
        this.selectedRow = new HashSet<Integer>();
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                ExceptionBalanceReportUI.this.adjustAmountChanged(e, ExceptionBalanceReportUI.this.tblMain);
                ExceptionBalanceReportUI.this.outTypeChanged(e, ExceptionBalanceReportUI.this.tblMain);
            }
        });
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                ExceptionBalanceReportUI.this.clickRows(ExceptionBalanceReportUI.this.tblMain);
            }
        });
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                ExceptionBalanceReportUI.this.checkRows(ExceptionBalanceReportUI.this.tblMain);
            }
        });
        this.tblMain.setAfterAction(new BeforeActionListener(){

            public void beforeAction(BeforeActionEvent e) {
                if (e.getType() == 5) {
                    int curCol = ExceptionBalanceReportUI.this.tblMain.getSelectManager().getActiveColumnIndex();
                    ExceptionBalanceReportUI.this.calAmount(ExceptionBalanceReportUI.this.tblMain, curCol);
                }
            }
        });
        this.tblMain.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                ExceptionBalanceReportUI.this.formatQtyCell(e, ExceptionBalanceReportUI.this.tblMain);
            }
        });
        this.ieb = ExceptionBalanceReportFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        this.tblMain.getDataRequestManager().setExportMemoryCallback(false);
    }

    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.kdtEditHelper.copy(2);
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.kdtEditHelper.paste(2);
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    private void clickRows(KDTable table) {
        if (!this.btnIssueBill.isEnabled()) {
            return;
        }
        KDTSelectBlock selectBlock = null;
        IRow iRow = null;
        int size = table.getSelectManager().size();
        int selectCol = this.tblMain.getColumnIndex("selected");
        for (int i = 0; i < size; ++i) {
            selectBlock = table.getSelectManager().get(i);
            int length = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= length; ++j) {
                iRow = table.getRow(j);
                Integer val = j;
                if (this.selectedRow.contains(val)) {
                    this.selectedRow.remove(val);
                    continue;
                }
                this.selectedRow.add(j);
            }
        }
    }

    private void checkRows(KDTable table) {
        if (!this.btnIssueBill.isEnabled()) {
            return;
        }
        KDTSelectBlock selectBlock = null;
        IRow iRow = null;
        int size = table.getSelectManager().size();
        int selectCol = this.tblMain.getColumnIndex("selected");
        for (int i = 0; i < size; ++i) {
            selectBlock = table.getSelectManager().get(i);
            int length = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= length; ++j) {
                iRow = table.getRow(j);
                boolean isSelected = false;
                if (iRow == null) continue;
                isSelected = iRow.getCell("selected").getValue() == null ? false : (Boolean)iRow.getCell("selected").getValue();
                int selectBeginCol = selectBlock.getBeginCol();
                int selectEndCol = selectBlock.getEndCol();
                int selectBiginRow = selectBlock.getBeginRow();
                int selectEndRow = selectBlock.getEndRow();
                if (selectCol != selectBeginCol || selectBeginCol != selectEndCol || selectBeginCol == -1 || selectBiginRow == selectEndRow) continue;
                if (!isSelected) {
                    iRow.getCell("selected").setValue((Object)new Boolean(true));
                    this.selectedRow.add(j);
                    continue;
                }
                iRow.getCell("selected").setValue((Object)new Boolean(false));
                Integer value = j;
                this.selectedRow.remove(value);
            }
        }
    }

    private void calAmount(KDTable tbl, int curCol) {
        int count = tbl.getRowCount();
        int colAdjustAmount = tbl.getColumnIndex("adjustAmount");
        int colAmount = tbl.getColumnIndex("amount");
        int colDiffAmount = tbl.getColumnIndex("diffAmount");
        int colQty = tbl.getColumnIndex("qty");
        IRow curRow = null;
        BigDecimal qty = CalculateUtil.ZERO;
        BigDecimal adjustAmount = CalculateUtil.ZERO;
        Object obj = null;
        if (curCol == colAdjustAmount) {
            for (int i = 0; i < count; ++i) {
                curRow = tbl.getRow(i);
                qty = this.getBigDecimalValue(curRow.getCell(colQty).getValue());
                adjustAmount = this.getBigDecimalValue(curRow.getCell(colAdjustAmount).getValue());
                curRow.getCell(colAdjustAmount).setValue((Object)adjustAmount);
                if (CalculateUtil.ZERO.compareTo(adjustAmount) <= 0 && CalculateUtil.ZERO.compareTo(qty) <= 0 || CalculateUtil.ZERO.compareTo(adjustAmount) > 0 && CalculateUtil.ZERO.compareTo(qty) > 0 || CalculateUtil.ZERO.compareTo(adjustAmount) == 0) {
                    BigDecimal amount = this.getBigDecimalValue(curRow.getCell(colAmount).getValue());
                    BigDecimal diffAmount = adjustAmount.subtract(amount);
                    curRow.getCell(colDiffAmount).setValue((Object)diffAmount);
                    continue;
                }
                MsgBox.showInfo((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"IndexAmountQtyDirectionError"), i + 1));
            }
        }
    }

    private void adjustAmountChanged(KDTEditEvent e, KDTable tbl) {
        int selectRow = e.getRowIndex();
        int selectCol = e.getColIndex();
        int colAdjustAmount = tbl.getColumnIndex("adjustAmount");
        int colAmount = tbl.getColumnIndex("amount");
        int colDiffAmount = tbl.getColumnIndex("diffAmount");
        int colQty = tbl.getColumnIndex("qty");
        if (selectCol == colAdjustAmount) {
            IRow curRow = tbl.getRow(selectRow);
            BigDecimal qty = (BigDecimal)curRow.getCell(colQty).getValue();
            Object obj = curRow.getCell(colAdjustAmount).getValue();
            BigDecimal adjustAmount = new BigDecimal("0.0");
            if (obj instanceof BigDecimal) {
                adjustAmount = (BigDecimal)curRow.getCell(colAdjustAmount).getValue();
                if (CalculateUtil.ZERO.compareTo(adjustAmount) <= 0 && CalculateUtil.ZERO.compareTo(qty) <= 0 || CalculateUtil.ZERO.compareTo(adjustAmount) > 0 && CalculateUtil.ZERO.compareTo(qty) > 0 || CalculateUtil.ZERO.compareTo(adjustAmount) == 0) {
                    BigDecimal amount = (BigDecimal)curRow.getCell(colAmount).getValue();
                    BigDecimal diffAmount = adjustAmount.subtract(amount);
                    curRow.getCell(colDiffAmount).setValue((Object)diffAmount);
                } else {
                    curRow.getCell(colAdjustAmount).setValue((Object)new BigDecimal("0.0000"));
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"AmountQtyDirectionError"));
                }
            }
        }
    }

    private void outTypeChanged(KDTEditEvent e, KDTable tbl) {
        Object outWareTpyeValue;
        int selectRow = e.getRowIndex();
        int selectCol = e.getColIndex();
        int colBizType = tbl.getColumnIndex("bizType");
        int colOutWareTpye = tbl.getColumnIndex("outWareTpye");
        IRow curRow = tbl.getRow(selectRow);
        if (selectCol == colBizType) {
            Object bizTypeValue = curRow.getCell(colBizType).getValue();
            Object outWareTpyeValue2 = curRow.getCell(colOutWareTpye).getValue();
            boolean isInPut = CalculateKindEnum.INPUT_WAREHOUSE.toString().equals(bizTypeValue.toString().trim());
            boolean isNullOutWare = IssueTypeEnum.NULL.toString().equals(outWareTpyeValue2.toString().trim());
            curRow.getCell(colOutWareTpye).getStyleAttributes().setLocked(false);
            curRow.getCell(colOutWareTpye).getStyleAttributes().setBackground(SCMClientUtils.necessaryColor);
            if (isInPut) {
                curRow.getCell(colOutWareTpye).setValue((Object)IssueTypeEnum.NULL);
                curRow.getCell(colOutWareTpye).getStyleAttributes().setLocked(true);
                curRow.getCell(colOutWareTpye).getStyleAttributes().setBackground(Color.WHITE);
            } else if (isNullOutWare) {
                curRow.getCell(colOutWareTpye).setValue((Object)IssueTypeEnum.SALEISSUEBILL);
            }
            if (bizTypeValue != null && selectRow == 0) {
                int rowCount = tbl.getRowCount();
                IRow iRow = null;
                for (int i = 1; i < rowCount; ++i) {
                    iRow = tbl.getRow(i);
                    iRow.getCell(colBizType).setValue(bizTypeValue);
                    iRow.getCell(colOutWareTpye).getStyleAttributes().setLocked(false);
                    iRow.getCell(colOutWareTpye).getStyleAttributes().setBackground(SCMClientUtils.necessaryColor);
                    if (isInPut) {
                        iRow.getCell(colOutWareTpye).setValue((Object)IssueTypeEnum.NULL);
                        iRow.getCell(colOutWareTpye).getStyleAttributes().setLocked(true);
                        iRow.getCell(colOutWareTpye).getStyleAttributes().setBackground(Color.WHITE);
                        continue;
                    }
                    if (!isNullOutWare) continue;
                    iRow.getCell(colOutWareTpye).setValue((Object)IssueTypeEnum.SALEISSUEBILL);
                }
            }
        }
        if (selectCol == colOutWareTpye && (outWareTpyeValue = curRow.getCell(colOutWareTpye).getValue()) != null && selectRow == 0) {
            int rowCount = tbl.getRowCount();
            IRow iRow = null;
            for (int i = 1; i < rowCount; ++i) {
                iRow = tbl.getRow(i);
                iRow.getCell(colOutWareTpye).setValue(outWareTpyeValue);
            }
        }
    }

    private boolean isSelected(KDTable tbl) {
        boolean flag = false;
        int count = tbl.getRowCount();
        IRow row = null;
        for (int i = 0; i < count; ++i) {
            row = tbl.getRow(i);
            if (!row.getCell("selected").getValue().equals(Boolean.TRUE)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private boolean isIssueBill(KDTable tbl, boolean isIssueBill) {
        boolean flag = false;
        KDTSelectManager sm = tbl.getSelectManager();
        int blockCount = sm.size();
        IRow row = null;
        block0: for (int i = 0; i < blockCount; ++i) {
            KDTSelectBlock block = sm.get(i);
            int bottom = block.getBottom();
            for (int j = block.getTop(); j <= bottom; ++j) {
                row = tbl.getRow(j);
                if (!row.getCell("isIssueBill").getValue().equals(isIssueBill) || !row.getCell("selected").getValue().equals(Boolean.TRUE)) continue;
                flag = true;
                continue block0;
            }
        }
        return flag;
    }

    public void onLoad() throws Exception {
        SCMClientUtils.lockColumns((KDTable)this.tblMain, (String[])this.lockColNames, (boolean)true);
        int iprecision = CalculateUtil.getLocalCurrencyPrecision(null, SysContext.getSysContext().getCurrentFIUnit());
        this.tblMain.getColumn("qty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        InvClientUtils.fmtTableAmt((KDTable)this.tblMain, (String[])this.fmtColNames, (int)iprecision);
        this.tblMain.getColumn("amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("adjustAmount").setRequired(true);
        this.tblMain.getColumn("adjustAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("adjustAmount").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)this.getNewFormatTxtField(iprecision, true)));
        this.tblMain.getColumn("diffAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("materialID").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("Fid").getStyleAttributes().setHided(true);
        if (!"preEndBalance".equalsIgnoreCase(this.getOprtState())) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"BEGINBALANCEREPORT"));
            this.btnPreCloseAccount.setEnabled(false);
        } else {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"ENDBALANCEREPORT"));
        }
        super.onLoad();
        this.comBoxOutWareTpye = new KDComboBox();
        KDTDefaultCellEditor bizchkBoxEditorOutWareTpye = new KDTDefaultCellEditor((JComboBox)this.comBoxOutWareTpye);
        this.tblMain.getColumn("outWareTpye").setWidth(80);
        this.tblMain.getColumn("outWareTpye").setEditor((ICellEditor)bizchkBoxEditorOutWareTpye);
        this.tblMain.getColumn("outWareTpye").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("outWareTpye").setRequired(true);
        this.comBoxOutWareTpye.addItem((Object)IssueTypeEnum.NULL);
        this.comBoxOutWareTpye.addItem((Object)IssueTypeEnum.SALEISSUEBILL);
        this.comBoxOutWareTpye.addItem((Object)IssueTypeEnum.PRODUCELINGLIAO);
        this.comBoxOutWareTpye.addItem((Object)IssueTypeEnum.ORTHERSALE);
        this.comBoxOutWareTpye.addItem((Object)IssueTypeEnum.MOVEISSUE);
        this.menuCostAdjustEntryOption.setEnabled(true);
        this.bizTpye = new KDComboBox();
        KDTDefaultCellEditor bizTpyeEditor = new KDTDefaultCellEditor((JComboBox)this.bizTpye);
        this.tblMain.getColumn("bizType").setWidth(80);
        this.tblMain.getColumn("bizType").setEditor((ICellEditor)bizTpyeEditor);
        this.tblMain.getColumn("bizType").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("bizType").setRequired(true);
        this.bizTpye.addItem((Object)CalculateKindEnum.OUTPUT_WAREHOUSE);
        this.bizTpye.addItem((Object)CalculateKindEnum.INPUT_WAREHOUSE);
        IParamControl iParamControl = ParamControlFactory.getRemoteInstance();
        this.calType = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(((CompanyOrgUnitInfo)this.filterUI.prmtFinanceOrgUnit.getValue()).getId().toString()), "SCM_CAL_002");
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected KDFormattedTextField getNewFormatTxtField(int precision, boolean canMinus) {
        KDFormattedTextField txtField = new KDFormattedTextField(1);
        txtField.setPrecision(precision);
        txtField.setMaximumValue((Comparable)InvClientUtils.MAXVAL);
        txtField.setMinimumValue((Comparable)InvClientUtils.MINVAL);
        txtField.setNegatived(canMinus);
        return txtField;
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnNoSelect.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnIssueBill.setIcon(EASResource.getIcon((String)"imgTbtn_createcredence"));
        this.menuItemIssueBill.setIcon(EASResource.getIcon((String)"imgTbtn_createcredence"));
        this.btnDelBill.setIcon(EASResource.getIcon((String)"imgTbtn_deletecredence"));
        this.menuItemDelBill.setIcon(EASResource.getIcon((String)"imgTbtn_deletecredence"));
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return ExceptionBalanceReportFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected RptParams getParamsForInit() {
        RptParams initParam = new RptParams();
        return initParam;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        this.filterUI = new ExceptionBalanceReportFilterUI();
        this.filterUI.setOprtState(this.getOprtState());
        return this.filterUI;
    }

    protected void query() {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(this.params.getString("COMPANY_ID"));
            this.mainBizorg = (CompanyOrgUnitInfo)CompanyOrgUnitFactory.getRemoteInstance().getValue((IObjectPK)pk);
            this.initUIMainOrgContext(this.mainBizorg.getId().toString());
            if ("preEndBalance".equalsIgnoreCase(this.getOprtState())) {
                this.params.setBoolean("isPreCloseAccount", true);
                PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)this.mainBizorg);
                this.params.setInt("YEAR_FROM", curPeriodInfo.getPeriodYear());
                this.params.setInt("PERIOD_FROM", curPeriodInfo.getPeriodNumber());
                this.params.setInt("YEAR_TO", curPeriodInfo.getPeriodYear());
                this.params.setInt("PERIOD_TO", curPeriodInfo.getPeriodNumber());
                this.preCloseAcc();
            }
        }
        catch (EASBizException e1) {
            String message = EASResource.getString((String)"com.kingdee.eas.scm.cal.CalRptResource", (String)"PreCloseError");
            String detailMessage = e1.getMessage();
            MsgBox.showDetailAndOK((Component)((Object)this), (String)message, (String)detailMessage, (int)1);
            SysUtil.abort();
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
            SysUtil.abort();
        }
        this.initUIMainOrgContext(this.params.getString("COMPANY_ID"));
        this.initUserConfig();
        this.tblMain.removeRows();
        boolean ckShowNoCalculate = this.params.getBoolean("ckShowNoCalculate");
        int period_from = this.params.getInt("YEAR_FROM") * 100 + this.params.getInt("PERIOD_FROM");
        int period_to = this.params.getInt("YEAR_TO") * 100 + this.params.getInt("PERIOD_TO");
        PeriodInfo curPeriodInfo = null;
        try {
            curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)this.getMainOrgInfo()));
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        int curPeriod = curPeriodInfo.getPeriodYear() * 100 + curPeriodInfo.getPeriodNumber();
        if (period_from != curPeriod || period_to != curPeriod || ckShowNoCalculate) {
            this.menuItemIssueBill.setEnabled(false);
            this.menuItemDelBill.setEnabled(false);
            this.btnIssueBill.setEnabled(false);
            this.btnDelBill.setEnabled(false);
            this.tblMain.setEditable(false);
        } else {
            this.menuItemIssueBill.setEnabled(true);
            this.menuItemDelBill.setEnabled(true);
            this.btnIssueBill.setEnabled(true);
            this.btnDelBill.setEnabled(true);
            this.tblMain.setEditable(true);
        }
    }

    public Object getTablePreferenceSchemaKey() {
        QuerySolutionInfo currentSolutionInfo = this.queryDialog.getCurrentSolutionInfo();
        BOSUuid obj = null;
        if (currentSolutionInfo != null) {
            obj = currentSolutionInfo.getId();
        }
        if (obj == null && (currentSolutionInfo = this.queryDialog.getCommonQueryParam().getCurrentSolutionInfo()) != null) {
            obj = currentSolutionInfo.getId();
        }
        return obj;
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        if (useDefaultSolution) {
            IQuerySolutionFacade iQuery = null;
            QuerySolutionInfo solution = null;
            try {
                iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
                String queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.getQueryMetaDataPK()).getFullName();
                solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
                this.queryDialog.setCurrentSolutionInfo(solution);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (solution == null || solution.getName().equals(EASResource.getString((String)"com.kingdee.eas.framework.report.CommRptResource", (String)"DefaultSolution"))) {
                useDefaultSolution = false;
            }
        }
        return super.showQueryDialog(useDefaultSolution);
    }

    public void getData(KDTDataRequestEvent e) {
        try {
            this.tblMain.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            RptParams pp = this.params;
            this.tblMain.getColumn("shortName").getStyleAttributes().setHided(true);
            RptParams rpt = null;
            if (from == 0) {
                rpt = ExceptionBalanceReportFacadeFactory.getRemoteInstance().createTempTable(pp);
                this.setTempTable(rpt.getString("tempTable"));
                int cbReturnNum = 0;
                if (pp.getObject("cbReturnNum") != null) {
                    cbReturnNum = pp.getInt("cbReturnNum");
                }
                int showNum = rpt.getInt("totalCount");
                int totalCount = rpt.getInt("totalCount");
                if (cbReturnNum == 1) {
                    showNum = 1000;
                } else if (cbReturnNum == 2) {
                    showNum = 5000;
                }
                showNum = Math.min(totalCount, showNum);
                this.tblMain.setRowCount(showNum);
            }
            pp.setString("tempTable", this.getTempTable());
            rpt = ExceptionBalanceReportFacadeFactory.getRemoteInstance().query(pp, from, len);
            RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
            KDTableUtil.insertRows((RptRowSet)rs, (int)from, (KDTable)this.tblMain);
            this.initUserConfig();
            this.globalRptParams = pp;
            this.txtCompanyName.setText(this.params.getString("COMPANY_NAME"));
            StringBuffer temp = new StringBuffer();
            if (this.params.getString("MATERIAL_FROM") != null && this.params.getString("MATERIAL_FROM").length() != 0) {
                temp.append(this.params.getString("MATERIAL_FROM"));
                if (this.params.getString("MATERIAL_TO") != null && this.params.getString("MATERIAL_TO").length() != 0) {
                    temp.append(" -- ");
                    temp.append(this.params.getString("MATERIAL_TO"));
                }
            }
            if (from == 0) {
                this.formatQtyCell(e, this.tblMain);
            }
            this.txtMaterial.setText(temp.toString());
            this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        String res = "com.kingdee.eas.scm.cal.CalRptResource";
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)res, (String)"FICU")).append("&[Company]").append("&|");
        sb.append(EASResource.getString((String)res, (String)"MATERIALAREA")).append("&[MATERIALAREA]").append("&|");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Company", ":" + this.txtCompanyName.getText());
        map.put("MATERIALAREA", ":" + this.txtMaterial.getText());
        return map;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.selectedRow.clear();
        super.actionQuery_actionPerformed(e);
    }

    private void updateIsIsseBill(List selectedRow, Set globalIDSet, boolean isIssueBill) throws BOSException, EASBizException {
        if (selectedRow == null || selectedRow.size() == 0) {
            return;
        }
        ArrayList<Integer> removeList = new ArrayList<Integer>();
        for (int i = 0; i < selectedRow.size(); ++i) {
            List retList = (List)selectedRow.get(i);
            if (!globalIDSet.contains(retList.get(0))) continue;
            int rowNum = (Integer)retList.get(6);
            IRow row = this.tblMain.getRow(rowNum - 1);
            removeList.add(rowNum - 1);
            if (row == null) continue;
            row.getCell("selected").setValue((Object)Boolean.FALSE);
            row.getCell("isIssueBill").setValue((Object)isIssueBill);
        }
        selectedRow.clear();
        this.selectedRow.clear();
        this.selectedRow.removeAll(removeList);
    }

    private void updateIsDeleteBill(List seleteRow) {
        if (seleteRow == null || seleteRow.size() == 0) {
            return;
        }
        for (int i = 0; i < seleteRow.size(); ++i) {
            int rowNum = (Integer)seleteRow.get(i);
            IRow row = this.tblMain.getRow(rowNum);
            if (row == null) continue;
            row.getCell("selected").setValue((Object)Boolean.FALSE);
            row.getCell("isIssueBill").setValue((Object)Boolean.FALSE);
        }
        this.selectedRow.clear();
    }

    private boolean isCanCreate(BigDecimal qty, BigDecimal adjustAmount) {
        boolean flag = false;
        if (qty.compareTo(CalculateUtil.ZERO) > 0 && adjustAmount.compareTo(CalculateUtil.ZERO) > 0) {
            flag = true;
        } else if (qty.compareTo(CalculateUtil.ZERO) < 0 && adjustAmount.compareTo(CalculateUtil.ZERO) < 0) {
            flag = true;
        } else if (qty.compareTo(CalculateUtil.ZERO) == 0 && adjustAmount.compareTo(CalculateUtil.ZERO) == 0) {
            flag = true;
        }
        return flag;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.selectedRow.clear();
    }

    @Override
    public void actionIssueBill_actionPerformed(ActionEvent e) throws Exception {
        String errorMsg;
        List globalList = this.getRowFieldValue(this.tblMain, new String[]{"Fid", "diffAmount", "outWareTpye", "bizType", "qty", "adjustAmount"});
        if (globalList.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"ChooseRecord"));
            return;
        }
        if (globalList.indexOf(EXISTISSUERECORD) > -1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"HasAdjust"));
            return;
        }
        CalculateParams params = new CalculateParams();
        params.setString("COMPANY_ID", this.globalRptParams.getString("COMPANY_ID"));
        params.setString("CALTYPE", this.calType);
        params.setObject("GLOBALRPTPARAMS_OBJ", (Object)this.globalRptParams);
        params.setObject("globalList", (Object)globalList);
        params.setBoolean("isEndAdjust", this.isEndAdjust);
        params.setInt("sumType", this.globalRptParams.getInt("sumType"));
        params.setString("tempTable", this.getTempTable());
        Integer rowIndex = null;
        StringBuffer msg = new StringBuffer();
        for (int n = 0; n < globalList.size(); ++n) {
            String retRes;
            ArrayList list = (ArrayList)globalList.get(n);
            BigDecimal diffAmount = (BigDecimal)list.get(1);
            BigDecimal qty = (BigDecimal)list.get(4);
            BigDecimal adjustAmount = (BigDecimal)list.get(5);
            rowIndex = (Integer)list.get(6);
            if (!this.isCanCreate(qty, adjustAmount)) {
                retRes = EASResource.getString((String)"com.kingdee.eas.scm.cal.CalRptResource", (String)"IS_CAN_NOT_CREATE") + "\r\n";
                msg.append(MessageFormat.format(retRes, rowIndex));
            }
            if (CalculateUtil.ZERO.compareTo(diffAmount) != 0) continue;
            retRes = EASResource.getString((String)"com.kingdee.eas.scm.cal.CalRptResource", (String)"PERIODBEGINEXPCOSTADJZERO_ISSEUEBILL") + "\r\n";
            msg.append(MessageFormat.format(retRes, rowIndex));
        }
        if (msg.length() > 0 && MsgBox.showConfirm3((Component)((Object)this), (String)(errorMsg = EASResource.getString((String)"com.kingdee.eas.scm.cal.CalRptResource", (String)"HAVA_ROWS_NOT_CREATE")), (String)msg.toString()) != 0) {
            return;
        }
        CalculateParams cps = this.ieb.issueBill(params);
        if (cps.getBoolean("boolean")) {
            ArrayList globalIDList = (ArrayList)cps.getObject("globalIDList");
            this.costAdjustBillRptParams.setObject("globalIDList", (Object)globalIDList);
            HashSet costAdjustNumberSet = (HashSet)cps.getObject("costAdjustNumberList");
            this.costAdjustBillRptParams.setObject("costAdjustNumberList", (Object)costAdjustNumberSet);
            StringBuffer costAdjustNumber = new StringBuffer();
            if (costAdjustNumberSet != null && costAdjustNumberSet.size() > 0) {
                Iterator iterator = costAdjustNumberSet.iterator();
                while (iterator.hasNext()) {
                    costAdjustNumber.append((String)iterator.next()).append(",");
                }
            }
            HashSet globalIDSet = new HashSet();
            for (int i = 0; i < globalIDList.size(); ++i) {
                globalIDSet.add(((List)globalIDList.get(i)).get(0));
            }
            this.updateIsIsseBill(globalList, globalIDSet, true);
            if (costAdjustNumber.length() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"GenerateAdjustError"));
                return;
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"GenerateAdjustSuccessTitle"), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"GenerateAdjustSuccess"), costAdjustNumber.substring(0, costAdjustNumber.length() - 1)), (int)1);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"GenerateAdjustError"));
        }
    }

    public List getRowFieldValue(KDTable kdtTable, String[] fields) {
        int keyFid = kdtTable.getColumnIndex(fields[0]);
        int keyDiffAmount = kdtTable.getColumnIndex(fields[1]);
        int keyOutWareTpye = kdtTable.getColumnIndex(fields[2]);
        int keyBizType = kdtTable.getColumnIndex(fields[3]);
        int qtyIndex = kdtTable.getColumnIndex(fields[4]);
        int adjustAmountIndex = kdtTable.getColumnIndex(fields[5]);
        ArrayList<Object> list = new ArrayList<Object>();
        Object fidValue = null;
        Object diffAmountValue = null;
        Object outWareTpyeValue = null;
        Object bizTypeValue = null;
        Integer[] selec = this.selectedRow.toArray(new Integer[0]);
        for (int i = 0; i < selec.length; ++i) {
            int rowNumber = selec[i];
            IRow row = kdtTable.getRow(rowNumber);
            if (!row.getCell("selected").getValue().equals(Boolean.TRUE)) continue;
            if (row.getCell("isIssueBill").getValue().equals(Boolean.TRUE)) {
                list.add(EXISTISSUERECORD);
                break;
            }
            ArrayList<Object> retList = new ArrayList<Object>();
            fidValue = row.getCell(keyFid).getValue();
            diffAmountValue = row.getCell(keyDiffAmount).getValue();
            outWareTpyeValue = row.getCell(keyOutWareTpye).getValue();
            bizTypeValue = row.getCell(keyBizType).getValue();
            if (fidValue == null || fidValue.toString().trim().length() == 0 || diffAmountValue == null || diffAmountValue.toString().trim().length() == 0 || outWareTpyeValue == null) continue;
            String retStr = (String)fidValue;
            BigDecimal retStr1 = (BigDecimal)diffAmountValue;
            int retStr2 = -1;
            retStr2 = IssueTypeEnum.SALEISSUEBILL.toString().trim().equals(outWareTpyeValue.toString().trim()) ? 0 : (IssueTypeEnum.PRODUCELINGLIAO.toString().trim().equals(outWareTpyeValue.toString().trim()) ? 1 : (IssueTypeEnum.ORTHERSALE.toString().trim().equals(outWareTpyeValue.toString().trim()) ? 2 : (IssueTypeEnum.MOVEISSUE.toString().trim().equals(outWareTpyeValue.toString().trim()) ? 3 : 0)));
            int bizType = -1;
            bizType = CalculateKindEnum.OUTPUT_WAREHOUSE.toString().trim().equals(bizTypeValue.toString().trim()) ? 1 : 0;
            retList.add(retStr);
            retList.add(retStr1);
            if (0 == bizType) {
                retList.add(Integer.toString(-1));
            } else {
                retList.add(Integer.toString(retStr2));
            }
            retList.add(Integer.toString(bizType));
            BigDecimal qty = (BigDecimal)row.getCell(qtyIndex).getValue();
            BigDecimal adjustAmount = (BigDecimal)row.getCell(adjustAmountIndex).getValue();
            Integer rowIndex = new Integer(row.getRowIndex() + 1);
            retList.add(qty);
            retList.add(adjustAmount);
            retList.add(rowIndex);
            list.add(retList);
        }
        return list;
    }

    protected List getSelectedFieldList(KDTable kdtTable, String fid, List rowList) {
        ArrayList<Object> list = new ArrayList<Object>();
        Integer[] selec = this.selectedRow.toArray(new Integer[0]);
        for (int i = 0; i < selec.length; ++i) {
            int rowNumber = selec[i];
            IRow row = kdtTable.getRow(rowNumber);
            if (!row.getCell("selected").getValue().equals(Boolean.TRUE)) continue;
            if (row.getCell("isIssueBill").getValue().equals(Boolean.FALSE)) {
                list.add(EXISTUNISSUERECORD);
                break;
            }
            list.add(row.getCell(fid).getValue());
            rowList.add(rowNumber);
        }
        return list;
    }

    @Override
    public void actionDelBIll_actionPerformed(ActionEvent e) throws Exception {
        ArrayList rowList = new ArrayList();
        List idList = this.getSelectedFieldList(this.tblMain, "Fid", rowList);
        if (idList.size() > 0) {
            if (idList.indexOf(EXISTUNISSUERECORD) < 0) {
                CalculateParams params = new CalculateParams();
                params.setString("COMPANY_ID", this.globalRptParams.getString("COMPANY_ID"));
                PeriodInfo periodInfo = new PeriodInfo();
                periodInfo.setPeriodNumber(this.globalRptParams.getInt("PERIOD_FROM"));
                periodInfo.setPeriodYear(this.globalRptParams.getInt("YEAR_FROM"));
                params.setObject("PERIOD_OBJ", (Object)periodInfo);
                params.setString("CALTYPE", this.calType);
                params.setBoolean("isEndAdjust", this.isEndAdjust);
                params.setString("tempTable", this.getTempTable());
                params.setInt("sumType", this.globalRptParams.getInt("sumType"));
                this.invBalanceIDs = new String[idList.size()];
                for (int i = 0; i < idList.size(); ++i) {
                    this.invBalanceIDs[i] = (String)idList.get(i);
                }
                params.setObject("INVBALANCEID", (Object)this.invBalanceIDs);
                CalculateParams cps = this.ieb.delBIll(params);
                if (cps.getBoolean("isSuccess")) {
                    String costAdjustNumber = cps.getString("COSTADJUSTBILLNUMBER");
                    MsgBox.showInfo((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"DeleteAdjustSuccess"), costAdjustNumber));
                    this.updateIsDeleteBill(rowList);
                } else {
                    String costAdjustNumber = cps.getString("numberCount");
                    MsgBox.showInfo((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"DeleteAdjustError"), costAdjustNumber));
                }
                this.tblMain.refresh();
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"HasNoIssue"));
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"HasNoChoose"));
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected String getUIFullName() {
        return "com.kingdee.eas.scm.cal.client.ExceptionBalanceReportUI";
    }

    public boolean isAsynchronism() {
        return true;
    }

    @Override
    public void actionPreCloseAccount_actionPerformed(ActionEvent e) throws Exception {
        this.preCloseAcc();
        this.actionRefresh_actionPerformed(e);
    }

    private void preCloseAcc() throws BOSException, EASBizException {
        this.isEndAdjust = true;
        this.param.put("IsCheckCostbill", "false");
        this.param.put("isPreCloseAccount", new Boolean(true));
        PeriodInfo curPeriodInfo = new PeriodInfo();
        curPeriodInfo.setPeriodNumber(this.params.getInt("PERIOD_FROM"));
        curPeriodInfo.setPeriodYear(this.params.getInt("YEAR_FROM"));
        this.param.put("period", curPeriodInfo);
        this.param.put("calculateParams", this.params);
        this.checkViewPermission();
        ICloseAccountFacade ica = CloseAccountFacadeFactory.getRemoteInstance();
        ica.closeAccount(this.mainBizorg, this.param);
    }

    private void checkViewPermission() throws BOSException, EASBizException {
        if (this.mainBizorg != null) {
            ObjectUuidPK orgPk = new ObjectUuidPK(this.mainBizorg.getId());
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
            PermissionHelper.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPk, (String)"closeaccount");
        }
    }

    private void ckSelect(boolean isSelect) {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            row.getCell("selected").setValue((Object)isSelect);
            this.selectedRow.add(i);
        }
        if (!isSelect) {
            this.selectedRow.clear();
        }
    }

    @Override
    public void actonSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.ckSelect(true);
    }

    @Override
    public void actionNoSelect_actionPerformed(ActionEvent e) throws Exception {
        this.ckSelect(false);
    }

    protected void formatQtyCell(KDTDataRequestEvent e, KDTable tbl) {
        IRow row;
        int from = e.getFirstRow();
        int last = e.getLastRow();
        for (int i = from; i <= last && (row = tbl.getRow(i)) != null; ++i) {
            Boolean flag;
            row.getCell("selected").setValue((Object)Boolean.FALSE);
            int isIssueBill = 0;
            if (row.getCell("isIssueBill").getValue() instanceof Integer) {
                isIssueBill = (Integer)row.getCell("isIssueBill").getValue();
            } else if (row.getCell("isIssueBill").getValue() instanceof BigDecimal) {
                BigDecimal decimalVal = (BigDecimal)row.getCell("isIssueBill").getValue();
                isIssueBill = decimalVal.intValue();
            } else if (row.getCell("isIssueBill").getValue() instanceof Boolean && (flag = (Boolean)row.getCell("isIssueBill").getValue()).booleanValue()) {
                isIssueBill = 1;
            }
            if (isIssueBill == 0) {
                row.getCell("isIssueBill").setValue((Object)Boolean.FALSE);
            } else {
                row.getCell("isIssueBill").setValue((Object)Boolean.TRUE);
            }
            int qtyPrecision = 4;
            if (row.getCell("qtyPrecision").getValue() != null) {
                BigDecimal decimal = new BigDecimal(row.getCell("qtyPrecision").getValue().toString());
                qtyPrecision = decimal.intValue();
            }
            row.getCell("qty").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)qtyPrecision));
        }
    }

    private BigDecimal getBigDecimalValue(Object value) {
        BigDecimal result = CalculateUtil.ZERO;
        try {
            if (value instanceof String) {
                result = new BigDecimal((String)value);
            } else if (value instanceof BigDecimal) {
                result = (BigDecimal)value;
            }
        }
        catch (Exception e) {
            result = CalculateUtil.ZERO;
        }
        return result;
    }

    protected KDTable getTable() {
        return this.tblMain;
    }

    @Override
    public void actionCostAdjustOption_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"className", (Object)this.getMetaDataPK().getFullName());
        uiContext.put((Object)"COMPANY_ID", (Object)this.params.getString("COMPANY_ID"));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ExceptionBalanceCostAdjustOptionUI.class.getName(), (Map)uiContext, null, null);
        uiWindow.show();
    }

    protected void disposeUIWindow() {
        super.disposeUIWindow();
        final String companyId = this.params.getString("COMPANY_ID");
        final int year = this.params.getInt("YEAR_FROM");
        final int period = this.params.getInt("PERIOD_FROM");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    CloseAccountFacadeFactory.getRemoteInstance().clearPreInventoryBalance(companyId, year * 100 + period);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
            }
        }).start();
    }
}

