/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.cal.CalRptUtilFacadeFactory;
import com.kingdee.eas.scm.cal.CalculateReportFacadeFactory;
import com.kingdee.eas.scm.cal.ICalRptUtilFacade;
import com.kingdee.eas.scm.cal.client.AbstractInpWarehsSumReportFilterUI;
import com.kingdee.eas.scm.cal.util.CalculateClientUtil;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class InpWarehsSumReportFilterUI
extends AbstractInpWarehsSumReportFilterUI {
    private static final long serialVersionUID = 940244868837749126L;
    private static final Logger logger = CoreUIObject.getLogger(InpWarehsSumReportFilterUI.class);
    private CompanyOrgUnitInfo oldCompanyInfo = null;
    private PeriodInfo periodInfo = null;
    private ItemListener groupStandardListener = null;
    private String materialGroupStandardID = null;
    private MaterialGroupStandardInfo standardInfo = null;
    private ICalRptUtilFacade rptUtilFacade = null;
    private Object[] companyAddInfo = null;
    private F7ContextManager f7Manger = null;
    private Object costCenter;
    private Map fetchData = new HashMap();

    public InpWarehsSumReportFilterUI() throws Exception {
        this.setSize(505, 400);
        this.rptUtilFacade = CalRptUtilFacadeFactory.getRemoteInstance();
        CalculateClientUtil.setCompanyOrgF7ForSealUp(this.prmtFinanceOrgUnit, "inpWarehsSumCal", true);
        SCMClientUtils.setF7OrgUnitBizUnit((KDBizPromptBox)this.prmtFinanceOrgUnit);
        InpWarehsSumReportFilterUI.setFilterForBillType(this.prmtBillType, 12);
        CalculateClientUtil.setF7FilterUIProperties(this.prmtBillType, true);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectFrom);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectTo);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumberFrom);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumberTo);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.f7Manger = new F7ContextManager((Component)((Object)this), OrgType.Company, 1);
        this.onInitFilter();
        this.initLoadData();
        this.setStorageFilterF7();
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameFrom.setEditable(false);
        this.txtMShortNameFrom.setBackground(CtrlUtil.Color.parseColor((String)"#ffffff"));
        this.txtMShortNameTo.setText(null);
        this.txtMShortNameTo.setEditable(false);
        this.txtMShortNameTo.setBackground(CtrlUtil.Color.parseColor((String)"#ffffff"));
        if (this.prmtFinanceOrgUnit.getValue() == null) {
            this.prmtMaterial.setEnabled(false);
            this.prmtMaterialTo.setEnabled(false);
        }
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtMaterial, this.prmtMaterialTo});
        CalculateClientUtil.addListenerForMultiF7(this.prmtMaterial, this.prmtMaterialTo);
        this.costCenter = this.comboSumCondition.getItemAt(4);
        this.prmtStorage.setValue(null);
        this.prmtDepartment.setValue(null);
        this.prmtMaterialGroup.setValue(null);
        this.prmtWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQueryForCal");
        this.prmtStorage.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    CalculateClientUtil.setWareHouseEntity(InpWarehsSumReportFilterUI.this.prmtFinanceOrgUnit, InpWarehsSumReportFilterUI.this.prmtStorage, InpWarehsSumReportFilterUI.this.prmtWarehouse, false);
                }
                catch (EASBizException e1) {
                    InpWarehsSumReportFilterUI.this.handUIException(e1);
                }
                catch (BOSException e1) {
                    InpWarehsSumReportFilterUI.this.handUIException(e1);
                }
            }
        });
    }

    private void financeOrgUnitDataChange(DataChangeEvent e) {
        this.prmtStorage.setValue(null);
        this.prmtWarehouse.setValue(null);
        if (null == this.prmtFinanceOrgUnit.getValue()) {
            this.prmtStorage.setEntityViewInfo(new EntityViewInfo());
        }
        if (null == e || null == e.getNewValue() || e.getNewValue().equals(e.getOldValue())) {
            return;
        }
        try {
            OrgUnitInfo org = (OrgUnitInfo)e.getNewValue();
            OrgUnitCollection orgCol = null;
            orgCol = this.fetchData.get("FromUnit") != null ? (OrgUnitCollection)this.fetchData.get("FromUnit") : OrgUnitRelationFactory.getRemoteInstance().getFromUnit(org.getId().toString(), 1, 4);
            EntityViewInfo storageEv = new EntityViewInfo();
            FilterInfo storageFilterInfo = new FilterInfo();
            HashSet<String> set = new HashSet<String>();
            if (orgCol != null) {
                for (int i = 0; i < orgCol.size(); ++i) {
                    set.add(orgCol.get(i).getId().toString());
                }
            }
            if (set.size() > 0) {
                storageFilterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
                storageEv.setFilter(storageFilterInfo);
                this.prmtStorage.setEntityViewInfo(storageEv);
            }
            CalculateClientUtil.setWareHouseEntity(this.prmtFinanceOrgUnit, null, this.prmtWarehouse, true);
            this.f7Manger.registerBizMaterialF7(this.prmtMaterial, null, null, null, true);
            this.f7Manger.registerBizMaterialF7(this.prmtMaterialTo, null, null, null, false);
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    protected void initListener() {
        this.prmtFinanceOrgUnit.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                if (e.getData() != null && e.getData().equals(e.getOldData())) {
                    return;
                }
                e.setResult(InpWarehsSumReportFilterUI.this.prmtCompanyOrgUnitStateChanged(e));
            }
        });
        this.prmtFinanceOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                InpWarehsSumReportFilterUI.this.financeOrgUnitDataChange(e);
            }
        });
        this.prmtStorage.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                InpWarehsSumReportFilterUI.this.prmtWarehouse.setValue(null);
                Object[] obj = (Object[])InpWarehsSumReportFilterUI.this.prmtStorage.getValue();
                InpWarehsSumReportFilterUI.this.setWareHouseEntity(obj);
            }
        });
        this.prmtBillType.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                InpWarehsSumReportFilterUI.this.prmtBillTypeStateChanged();
            }
        });
        this.spinPeriodYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int year = (Integer)InpWarehsSumReportFilterUI.this.spinPeriodYear.getValue();
                if (InpWarehsSumReportFilterUI.this.companyAddInfo == null) {
                    return;
                }
                Vector vecPrd = ((CalculateUtil.AccountPeriodInfo)((InpWarehsSumReportFilterUI)InpWarehsSumReportFilterUI.this).companyAddInfo[1]).periods;
                int idx = -1;
                int minMonth = 1;
                int maxMonth = 12;
                for (int i = 0; i < vecPrd.size(); ++i) {
                    if (year != ((int[])vecPrd.get(i))[0]) continue;
                    idx = i;
                    break;
                }
                if (idx > -1) {
                    minMonth = ((int[])vecPrd.get(idx))[1];
                    maxMonth = ((int[])vecPrd.get(idx))[2];
                }
                InpWarehsSumReportFilterUI.this.SetSpinnerMaxMin((JSpinner)InpWarehsSumReportFilterUI.this.spinPeriodMonth, minMonth, maxMonth);
            }
        });
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtFinanceOrgUnit;
    }

    public void onInit(RptParams arg0) throws Exception {
    }

    private void loadGroupStandard() throws Exception {
        IMaterialGroupStandard iMaterialGroupStandard = MaterialGroupStandardFactory.getRemoteInstance();
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), (String)SysContext.getSysContext().getCurrentCtrlUnit().getLongNumber());
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfoCU);
        this.comboMaterialGroupStandard.removeItemListener(this.groupStandardListener);
        MaterialGroupStandardCollection groupStandardColl = iMaterialGroupStandard.getMaterialGroupStandardCollection(viewInfo);
        this.comboMaterialGroupStandard.removeAllItems();
        if (groupStandardColl != null) {
            this.comboMaterialGroupStandard.addItems(groupStandardColl.toArray());
        }
        int size = groupStandardColl.size();
        MaterialGroupStandardInfo baseGroupStandardInfo = null;
        for (int index = 0; index < size; ++index) {
            if (groupStandardColl.get(index).getStandardType() == null || !groupStandardColl.get(index).getStandardType().equals((Object)MaterialGroupStandardTypeEnum.BasicStandard)) continue;
            baseGroupStandardInfo = groupStandardColl.get(index);
        }
        if (baseGroupStandardInfo != null) {
            this.comboMaterialGroupStandard.setSelectedItem(baseGroupStandardInfo);
        }
        this.comboMaterialGroupStandard.addItemListener(this.groupStandardListener);
        if (this.comboMaterialGroupStandard.getSelectedItem() != null) {
            this.standardInfo = (MaterialGroupStandardInfo)this.comboMaterialGroupStandard.getSelectedItem();
            this.materialGroupStandardID = this.standardInfo.getId().toString();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("groupStandard.id", (Object)this.materialGroupStandardID, CompareType.EQUALS));
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(filterInfo);
            this.prmtMaterialGroup.setEntityViewInfo(entityViewInfo);
        }
    }

    private void initLoadData() {
        this.groupStandardListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                InpWarehsSumReportFilterUI.this.itemChanaged(e);
            }
        };
        try {
            this.loadGroupStandard();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void itemChanaged(ItemEvent e) {
        this.standardInfo = (MaterialGroupStandardInfo)this.comboMaterialGroupStandard.getSelectedItem();
        this.materialGroupStandardID = this.standardInfo.getId().toString();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("groupStandard.id", (Object)this.materialGroupStandardID, CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        this.prmtMaterialGroup.setEntityViewInfo(viewInfo);
        this.prmtMaterialGroup.setValue(null);
    }

    public static void setFilterForBillType(KDBizPromptBox bizPromptBox, int i) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("103");
        hashSet.add("105");
        hashSet.add("107");
        hashSet.add("109");
        hashSet.add("102");
        hashSet.add("104");
        hashSet.add("108");
        filterInfo.getFilterItems().add(new FilterItemInfo("number", hashSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        bizPromptBox.setEntityViewInfo(viewInfo);
    }

    private void prmtBillTypeStateChanged() {
        if (this.prmtBillType.getValue() != null) {
            this.prmtTranscationType.setEnabled(true);
            this.prmtTranscationType.setValue(null);
            CalculateClientUtil.setFilterForTransactionType(this.prmtTranscationType, ((BillTypeInfo)this.prmtBillType.getValue()).getNumber());
        } else {
            this.prmtTranscationType.setEnabled(false);
            this.prmtTranscationType.setValue(null);
        }
    }

    private int prmtCompanyOrgUnitStateChanged(PreChangeEvent e) {
        try {
            Object obj = e.getData();
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = null;
            if (obj instanceof CompanyOrgUnitInfo) {
                aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)e.getData();
            }
            this.setStorageEntity(aCompanyOrgUnitInfo);
            if (aCompanyOrgUnitInfo != null && !aCompanyOrgUnitInfo.equals(e.getOldData())) {
                String strTemp;
                int ret;
                this.fetchData.putAll(CalculateReportFacadeFactory.getRemoteInstance().fetchDataByCou(aCompanyOrgUnitInfo));
                if (!this.isPeriodNotNull(aCompanyOrgUnitInfo)) {
                    this.spinPeriodYear.setValue((Object)new Integer(0));
                    this.spinPeriodMonth.setValue((Object)new Integer(0));
                    return 0;
                }
                if ((this.prmtMaterial.getValue() != null || this.prmtMaterialTo.getValue() != null) && (ret = MsgBox.showConfirm2((String)(strTemp = InvClientUtils.getResource((String)"CLEAR_RELATION_AFTER_ORGCHANGED")))) == 2) {
                    return 0;
                }
                this.prmtMaterial.setValue(null);
                this.prmtMaterialTo.setValue(null);
                this.prmtStorage.setValue(null);
                this.prmtWarehouse.setValue(null);
                this.companyAddInfo = this.fetchData.get("companyAddInfo") != null ? (Object[])this.fetchData.get("companyAddInfo") : this.rptUtilFacade.fetchInitFilterData(aCompanyOrgUnitInfo.getId().toString());
                this.loadAccountPeriod(aCompanyOrgUnitInfo);
                if (aCompanyOrgUnitInfo != null) {
                    this.prmtMaterial.setEnabled(true);
                    this.prmtMaterialTo.setEnabled(true);
                }
            } else if (aCompanyOrgUnitInfo == null) {
                if (this.prmtMaterial.getValue() != null || this.prmtMaterialTo.getValue() != null) {
                    String strTemp = InvClientUtils.getResource((String)"CLEAR_RELATION_AFTER_ORGCHANGED");
                    int ret = MsgBox.showConfirm2((String)strTemp);
                    if (ret == 2) {
                        return 0;
                    }
                    this.prmtMaterial.setValue(null);
                    this.prmtMaterialTo.setValue(null);
                }
                this.prmtStorage.setValue(null);
                this.prmtWarehouse.setValue(null);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return 1;
    }

    private void setStorageEntity(CompanyOrgUnitInfo companyOrg) {
        EntityViewInfo entiryView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (companyOrg != null) {
            OrgUnitCollection orgCol = InvClientUtils.getStorageUnitInfo((CompanyOrgUnitInfo)companyOrg);
            if (orgCol != null) {
                StorageOrgUnitInfo storageUnit = null;
                StringBuffer mskStr = new StringBuffer("");
                String msk = "";
                int k = 0;
                for (int i = 0; i < orgCol.size(); ++i) {
                    storageUnit = (StorageOrgUnitInfo)orgCol.get(i);
                    if (storageUnit == null || storageUnit.getId() == null) continue;
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)storageUnit.getId().toString()));
                    mskStr.append("#").append(k++).append(" or ");
                }
                if (mskStr.length() > 0) {
                    msk = mskStr.delete(mskStr.lastIndexOf("or"), mskStr.length() - 1).toString();
                    filterInfo.setMaskString(msk);
                }
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)"****"));
            }
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)"****"));
        }
        entiryView.setFilter(filterInfo);
        this.prmtStorage.setEntityViewInfo(entiryView);
    }

    private void setWareHouseEntity(Object[] obj) {
        CompanyOrgUnitInfo companyOrg = (CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue();
        StorageOrgUnitInfo storageUnit = null;
        EntityViewInfo entiryView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (obj != null && obj.length > 0) {
            StringBuffer mskStr = new StringBuffer("");
            String msk = "";
            int k = 0;
            for (int i = 0; i < obj.length; ++i) {
                storageUnit = (StorageOrgUnitInfo)obj[i];
                filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORGUNIT.ID", (Object)storageUnit.getId().toString()));
                mskStr.append("#").append(k++).append(" or ");
            }
            if (mskStr.length() > 0) {
                msk = mskStr.delete(mskStr.lastIndexOf("or"), mskStr.length() - 1).toString();
                filterInfo.setMaskString(msk);
            }
        } else {
            OrgUnitCollection orgCol = InvClientUtils.getStorageUnitInfo((CompanyOrgUnitInfo)companyOrg);
            if (orgCol != null) {
                StringBuffer mskStr = new StringBuffer("");
                String msk = "";
                int k = 0;
                for (int i = 0; i < orgCol.size(); ++i) {
                    storageUnit = (StorageOrgUnitInfo)orgCol.get(i);
                    filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORGUNIT.ID", (Object)storageUnit.getId().toString()));
                    mskStr.append("#").append(k++).append(" or ");
                }
                if (mskStr.length() > 0) {
                    msk = mskStr.delete(mskStr.lastIndexOf("or"), mskStr.length() - 1).toString();
                    filterInfo.setMaskString(msk);
                }
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORGUNIT.ID", (Object)"****"));
            }
        }
        entiryView.setFilter(filterInfo);
        this.prmtWarehouse.setEntityViewInfo(entiryView);
    }

    private boolean isPeriodNotNull(CompanyOrgUnitInfo companyOrgUnitInfo) {
        PeriodInfo curPeriodInfo = null;
        try {
            if (companyOrgUnitInfo != null && this.fetchData.get(companyOrgUnitInfo.getId().toString() + "curPeriod") != null) {
                curPeriodInfo = (PeriodInfo)this.fetchData.get(companyOrgUnitInfo.getId().toString() + "curPeriod");
            } else {
                curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
                this.fetchData.put(companyOrgUnitInfo.getId().toString() + "curPeriod", curPeriodInfo);
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (curPeriodInfo == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_IS_NULL"));
            return false;
        }
        this.periodInfo = curPeriodInfo;
        return true;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void prmtFinanceOrgUnit_stateChanged(ChangeEvent e) throws Exception {
        super.prmtFinanceOrgUnit_stateChanged(e);
    }

    private void onInitFilter() throws Exception {
        try {
            CalculateClientUtil.InitCompanyF7(this.prmtFinanceOrgUnit, "inpWarehsSumCal");
            if (this.prmtFinanceOrgUnit.getValue() != null) {
                this.oldCompanyInfo = (CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue();
                if (this.oldCompanyInfo != null) {
                    this.companyAddInfo = this.rptUtilFacade.fetchInitFilterData(this.oldCompanyInfo.getId().toString());
                }
                this.loadAccountPeriod(this.oldCompanyInfo);
                CalculateClientUtil.getMaterialF7ForFilterUI(this.oldCompanyInfo, (Object)this, this.prmtMaterial, null, true);
                CalculateClientUtil.getMaterialF7ForFilterUI(this.oldCompanyInfo, (Object)this, this.prmtMaterialTo, null, false);
                this.comboSumCondition.setSelectedIndex(0);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (this.prmtBillType.getData() == null) {
            ObjectUuidPK pk = new ObjectUuidPK("50957179-0105-1000-e000-0167c0a812fd463ED552");
            IBillType iBillType = BillTypeFactory.getRemoteInstance();
            BillTypeInfo aBillTypeInfo = iBillType.getBillTypeInfo((IObjectPK)pk);
            this.prmtBillType.setValue((Object)aBillTypeInfo);
            this.prmtBillType.setLabelText(aBillTypeInfo.getName());
        }
        this.ckBxZeroPrice.setSelected(true);
        this.prmtBillTypeStateChanged();
    }

    public RptParams getCustomCondition() {
        Object[] obj;
        RptParams params = new RptParams();
        String CompanyOrgUnitID = "";
        String companyname = "";
        String MaterialFrom = "";
        String MaterialTo = "";
        String MaterialIn = "";
        String MaterialFromId = "";
        String MaterialToId = "";
        int sumCondition = 0;
        String BillTypeNumber = "";
        String BillTypeID = "";
        BillTypeInfo billType = null;
        String MaterialGroupIDS = null;
        Object[] group = null;
        if (this.prmtFinanceOrgUnit.getValue() != null) {
            companyname = ((CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue()).getName();
            int year = (Integer)this.spinPeriodYear.getValue();
            int period = (Integer)this.spinPeriodMonth.getValue();
            if (((CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue()).getId() != null) {
                CompanyOrgUnitID = ((CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue()).getId().toString();
            }
            try {
                CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue();
                if (companyOrgUnitInfo != null) {
                    this.periodInfo = PeriodUtils.getPeriodInfo((int)year, (int)period, (CompanyOrgUnitInfo)companyOrgUnitInfo);
                } else {
                    this.periodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue()));
                    this.periodInfo.setPeriodYear(year);
                    this.periodInfo.setPeriodNumber(period);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (null == this.periodInfo) {
                this.periodInfo = new PeriodInfo();
                this.periodInfo.setPeriodYear(year);
                this.periodInfo.setPeriodNumber(period);
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COMPANY_NOTNULL"));
        }
        if (this.prmtMaterial.getValue() != null) {
            MaterialInfo m = null;
            if (this.prmtMaterial.getValue() instanceof Object[]) {
                Object[] obj2 = (Object[])this.prmtMaterial.getValue();
                if (obj2.length == 1) {
                    m = (MaterialInfo)obj2[0];
                } else {
                    StringBuffer materialNum = new StringBuffer();
                    StringBuffer materialId = new StringBuffer();
                    Object[] materials = (Object[])this.prmtMaterial.getValue();
                    for (int i = 0; i < materials.length; ++i) {
                        if (i != 0) {
                            materialNum.append("','");
                            materialId.append(",");
                        }
                        materialNum.append(((MaterialInfo)materials[i]).getNumber());
                        materialId.append(((MaterialInfo)materials[i]).getId().toString());
                    }
                    MaterialIn = materialNum.toString();
                    MaterialFromId = materialId.toString();
                }
            } else if (this.prmtMaterial.getValue() instanceof MaterialInfo) {
                m = (MaterialInfo)this.prmtMaterial.getValue();
            } else if (this.prmtMaterial.getValue() instanceof String) {
                MaterialFrom = this.prmtMaterial.getValue().toString();
            }
            if (m != null) {
                MaterialFrom = m.getNumber();
                if (m.getId() != null) {
                    MaterialFromId = m.getId().toString();
                }
            }
        }
        if (this.prmtMaterialTo.getValue() != null) {
            MaterialInfo m = null;
            if (this.prmtMaterialTo.getValue() instanceof MaterialInfo[]) {
                m = ((MaterialInfo[])this.prmtMaterialTo.getValue())[0];
            } else if (this.prmtMaterialTo.getValue() instanceof MaterialInfo) {
                m = (MaterialInfo)this.prmtMaterialTo.getValue();
            } else if (this.prmtMaterial.getValue() instanceof String) {
                MaterialTo = this.prmtMaterialTo.getValue().toString();
            }
            if (m != null) {
                MaterialTo = m.getNumber();
                if (m.getId() != null) {
                    MaterialToId = m.getId().toString();
                }
            }
        }
        if (this.prmtMaterialGroup.getValue() != null && (obj = (Object[])this.prmtMaterialGroup.getValue()) != null && obj.length > 0) {
            StringBuffer bf = new StringBuffer();
            boolean flag = false;
            bf.append("(");
            int size = obj.length;
            for (int i = 0; i < size; ++i) {
                MaterialGroupInfo materialGroupInfo = (MaterialGroupInfo)obj[i];
                if (null == materialGroupInfo) {
                    flag = true;
                    break;
                }
                bf.append("'").append(materialGroupInfo.getId().toString()).append("'");
                if (i == size - 1) continue;
                bf.append(",");
            }
            bf.append(")");
            MaterialGroupIDS = flag ? null : bf.toString();
            Object[] objectArray = group = flag ? null : obj;
        }
        if (this.prmtBillType.getValue() != null) {
            BillTypeNumber = ((BillTypeInfo)this.prmtBillType.getValue()).getNumber();
            if (((BillTypeInfo)this.prmtBillType.getValue()).getId() != null) {
                BillTypeID = ((BillTypeInfo)this.prmtBillType.getValue()).getId().toString();
            }
            billType = (BillTypeInfo)this.prmtBillType.getValue();
        }
        sumCondition = this.comboSumCondition.getSelectedIndex();
        params.setString("COMPANY_ID", CompanyOrgUnitID);
        params.setString("COMPANY_NAME", companyname);
        params.setString("MATERIAL_FROM", MaterialFrom);
        params.setString("MATERIAL_TO", MaterialTo);
        params.setString("MATERIAL_IN", MaterialIn);
        params.setString("MATERIAL_ID_FROM", MaterialFromId);
        params.setString("MATERIAL_ID_TO", MaterialToId);
        params.setString("txtMShortNameFrom", this.txtMShortNameFrom.getText());
        params.setString("txtMShortNameTo", this.txtMShortNameTo.getText());
        params.setString("BILLTYPE", BillTypeNumber);
        params.setString("BILLTYPE_ID", BillTypeID);
        params.setObject("BILLTYPE_INFO", (Object)billType);
        params.setObject("TRANSACTIONS", this.prmtTranscationType.getValue());
        params.setObject("STORAGEORGUNIT", this.prmtStorage.getValue());
        params.setObject("WAREHOUSE", this.prmtWarehouse.getValue());
        params.setObject("COSTCENTER", this.prmtCostCenter.getValue());
        params.setObject("DEPARTMENT", this.prmtDepartment.getValue());
        params.setObject("PERIOD_OBJ", (Object)this.periodInfo);
        params.setInt("SUMCONDITION", sumCondition);
        params.setString("MATERIALGROUPSTANDARD_ID", this.materialGroupStandardID);
        params.setString("MATERIALGROUP_IDS", MaterialGroupIDS);
        params.setObject("MATERIALGROUPINFO", (Object)this.standardInfo);
        params.setObject("MATERIALGROUP", (Object)group);
        params.setBoolean("ckBxMShortName", this.ckBxMShortName.isSelected());
        params.setBoolean("ckBxZeroPrice", this.ckBxZeroPrice.isSelected());
        params.setString("LOT_FROM", this.txtLotFrom.getText());
        params.setString("LOT_TO", this.txtLotTo.getText());
        params.setObject("PROJECT_FROM", this.prmtProjectFrom.getValue());
        params.setObject("PROJECT_TO", this.prmtProjectTo.getValue());
        params.setObject("TRACKNUMBER_FROM", this.prmtTrackNumberFrom.getValue());
        params.setObject("TRACKNUMBER_TO", this.prmtTrackNumberTo.getValue());
        return params;
    }

    public void setCustomCondition(RptParams params) {
        try {
            Object projectFrom;
            Map rs = CalculateReportFacadeFactory.getRemoteInstance().getCustomConditionData(params);
            if (rs.get("COMPANY_ID") != null) {
                this.fetchData.remove("FromUnit");
                this.prmtFinanceOrgUnit.setValue(rs.get("COMPANY_ID"));
            }
            if (rs.get("MATERIAL_ID_FROM") != null) {
                this.prmtMaterial.setValue(rs.get("MATERIAL_ID_FROM"));
            }
            if (rs.get("MATERIAL_ID_TO") != null) {
                this.prmtMaterialTo.setValue(rs.get("MATERIAL_ID_TO"));
            }
            if (rs.get("BILLTYPE_ID") != null) {
                this.prmtBillType.setValue(rs.get("BILLTYPE_ID"));
            } else {
                this.prmtBillType.setValue(null);
            }
            this.prmtTranscationType.setValue(params.getObject("TRANSACTIONS"));
            this.prmtStorage.setValue(params.getObject("STORAGEORGUNIT"));
            this.prmtWarehouse.setValue(params.getObject("WAREHOUSE"));
            this.prmtCostCenter.setValue(params.getObject("COSTCENTER"));
            this.prmtDepartment.setValue(params.getObject("DEPARTMENT"));
            if (params.getObject("MATERIALGROUP") != null) {
                this.prmtMaterialGroup.setValue(params.getObject("MATERIALGROUP"));
            } else {
                this.prmtMaterialGroup.setValue(null);
            }
            if (params.getObject("PERIOD_OBJ") != null) {
                PeriodInfo periodInfo = (PeriodInfo)params.getObject("PERIOD_OBJ");
                this.spinPeriodYear.setValue((Object)new Integer(periodInfo.getPeriodYear()));
                this.spinPeriodMonth.setValue((Object)new Integer(periodInfo.getPeriodNumber()));
            }
            this.comboSumCondition.setSelectedIndex(params.getInt("SUMCONDITION"));
            this.comboMaterialGroupStandard.setSelectedItem(params.getObject("MATERIALGROUPINFO"));
            if (params.getObject("ckBxMShortName") != null) {
                this.ckBxMShortName.setSelected(params.getBoolean("ckBxMShortName"));
                if (params.getBoolean("ckBxMShortName")) {
                    if (params.getObject("txtMShortNameFrom") != null) {
                        this.txtMShortNameFrom.setText(params.getObject("txtMShortNameFrom").toString());
                        this.txtMShortNameFrom.setEditable(true);
                    }
                    if (params.getObject("txtMShortNameTo") != null) {
                        this.txtMShortNameTo.setText(params.getObject("txtMShortNameTo").toString());
                        this.txtMShortNameTo.setEditable(true);
                    }
                } else {
                    this.txtMShortNameFrom.setText(null);
                    this.txtMShortNameFrom.setEditable(false);
                    this.txtMShortNameTo.setText(null);
                    this.txtMShortNameTo.setEditable(false);
                }
            } else {
                this.ckBxMShortName.setSelected(false);
            }
            if (params.getObject("ckBxZeroPrice") != null) {
                this.ckBxZeroPrice.setSelected(params.getBoolean("ckBxZeroPrice"));
            } else {
                this.ckBxZeroPrice.setSelected(false);
            }
            if (!StringUtils.isEmpty((String)params.getString("LOT_FROM"))) {
                this.txtLotFrom.setText(params.getString("LOT_FROM"));
            }
            if (!StringUtils.isEmpty((String)params.getString("LOT_TO"))) {
                this.txtLotTo.setText(params.getString("LOT_TO"));
            }
            if ((projectFrom = params.getObject("PROJECT_FROM")) instanceof ProjectInfo) {
                this.prmtProjectFrom.setValue(projectFrom);
            } else {
                this.prmtProjectFrom.setValue(null);
                params.setObject("PROJECT_FROM", null);
            }
            Object projectTo = params.getObject("PROJECT_TO");
            if (projectTo instanceof ProjectInfo) {
                this.prmtProjectTo.setValue(projectTo);
            } else {
                this.prmtProjectTo.setValue(null);
                params.setObject("PROJECT_TO", null);
            }
            Object trackNumberFrom = params.getObject("TRACKNUMBER_FROM");
            if (trackNumberFrom instanceof TrackNumberInfo) {
                this.prmtTrackNumberFrom.setValue(trackNumberFrom);
            } else {
                this.prmtTrackNumberFrom.setValue(null);
                params.setObject("TRACKNUMBER_FROM", null);
            }
            Object trackNumberTo = params.getObject("TRACKNUMBER_TO");
            if (trackNumberTo instanceof TrackNumberInfo) {
                this.prmtTrackNumberTo.setValue(trackNumberTo);
            } else {
                this.prmtTrackNumberTo.setValue(null);
                params.setObject("TRACKNUMBER_TO", null);
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    public void clear() {
        super.clear();
        this.prmtMaterial.setValue(null);
        this.prmtMaterialTo.setValue(null);
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameTo.setText(null);
        this.ckBxMShortName.setSelected(false);
        this.ckBxZeroPrice.setSelected(false);
        this.prmtFinanceOrgUnit.setValue(null);
        this.prmtBillType.setValue(null);
        this.prmtTranscationType.setValue(null);
        this.txtLotFrom.setText(null);
        this.txtLotTo.setText(null);
        this.prmtProjectFrom.setValue(null);
        this.prmtProjectTo.setValue(null);
        this.prmtTrackNumberFrom.setValue(null);
        this.prmtTrackNumberTo.setValue(null);
        try {
            this.onInitFilter();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public boolean verify() {
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getData();
        if (cou == null || cou.getId() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COMPANY_NOTNULL"));
            return false;
        }
        try {
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
            if (periodInfo == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_IS_NULL"));
                return false;
            }
            if (this.prmtBillType.getValue() == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"197_InpWarehsSumReportFilterUI"));
                return false;
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return true;
    }

    private void loadAccountPeriod(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        PeriodInfo curPeriodInfo = null;
        int minYear = 0;
        int maxYear = 0;
        int minMonth = 0;
        int maxMonth = 0;
        if (companyInfo != null && this.companyAddInfo != null) {
            CalculateUtil.AccountPeriodInfo acctPeriod = (CalculateUtil.AccountPeriodInfo)this.companyAddInfo[1];
            this.periodInfo = acctPeriod.startPeriod;
            curPeriodInfo = acctPeriod.curPeriod;
            minYear = ((int[])acctPeriod.periods.get(0))[0];
            maxYear = ((int[])acctPeriod.periods.get(acctPeriod.periods.size() - 1))[0];
            for (int i = 0; i < acctPeriod.periods.size(); ++i) {
                if (curPeriodInfo.getPeriodYear() != ((int[])acctPeriod.periods.get(i))[0]) continue;
                minMonth = ((int[])acctPeriod.periods.get(i))[1];
                maxMonth = ((int[])acctPeriod.periods.get(i))[2];
                break;
            }
        }
        this.SetSpinnerMaxMin((JSpinner)this.spinPeriodYear, minYear, maxYear);
        this.SetSpinnerMaxMin((JSpinner)this.spinPeriodMonth, minMonth, maxMonth);
        if (curPeriodInfo != null) {
            this.spinPeriodYear.setValue((Object)new Integer(curPeriodInfo.getPeriodYear()));
            this.spinPeriodMonth.setValue((Object)new Integer(curPeriodInfo.getPeriodNumber()));
        }
    }

    private void SetSpinnerMaxMin(JSpinner spinner, int min, int max) {
        int month;
        SpinnerModel model = spinner.getModel();
        if (model instanceof SpinnerNumberModel) {
            if (max >= min) {
                ((SpinnerNumberModel)model).setMaximum(new Integer(max));
            }
            ((SpinnerNumberModel)model).setMinimum(new Integer(min));
        }
        if ((month = ((Integer)spinner.getValue()).intValue()) > max) {
            spinner.setValue(new Integer(max));
        }
        if (month < min) {
            spinner.setValue(new Integer(min));
        }
    }

    @Override
    protected void ckBxMShortName_stateChanged(ChangeEvent e) throws Exception {
        if (this.ckBxMShortName.isSelected()) {
            this.txtMShortNameFrom.setText(null);
            this.txtMShortNameTo.setText(null);
            this.txtMShortNameFrom.setEditable(true);
            this.txtMShortNameTo.setEditable(true);
        } else {
            this.txtMShortNameFrom.setText(null);
            this.txtMShortNameTo.setText(null);
            this.txtMShortNameFrom.setEditable(false);
            this.txtMShortNameTo.setEditable(false);
        }
    }

    private void addF7SelectorListener(KDBizPromptBox[] f7s) {
        for (int i = 0; i < f7s.length; ++i) {
            f7s[i].addSelectorListener(new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    if (InpWarehsSumReportFilterUI.this.getMainBizOrgF7() != null) {
                        return;
                    }
                    Object value = InpWarehsSumReportFilterUI.this.getMainBizOrgF7().getValue();
                    if (value == null || value instanceof Object[] && ((Object[])value).length == 0 || value instanceof Object[] && ((Object[])value)[0] == null) {
                        MsgBox.showInfo((String)SCMGroupClientUtils.getMainOrgNullMsg((OrgType)OrgType.Company));
                        InpWarehsSumReportFilterUI.this.getMainBizOrgF7().requestFocus();
                        SysUtil.abort();
                    }
                }
            });
        }
    }

    protected void setNeedMainOrgF7s(KDBizPromptBox[] f7s) {
        this.addF7SelectorListener(f7s);
        this.f7Manger.setPrmtNeedOrgF7s(f7s);
    }

    private void setStorageFilterF7() {
        if (this.prmtFinanceOrgUnit.getValue() != null) {
            OrgUnitCollection orgCollection = SCMClientUtils.getStorageUnitInfo((CompanyOrgUnitInfo)((CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue()));
            try {
                this.prmtStorage.setEntityViewInfo(this.getOrgEntityViewInfo(orgCollection));
                this.prmtStorage.setCommitFormat("$number$");
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private EntityViewInfo getOrgEntityViewInfo(OrgUnitCollection collcetion) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < collcetion.size(); ++i) {
            if (collcetion.get(i).getId() == null) continue;
            stringBuffer.append(collcetion.get(i).getId().toString());
            stringBuffer.append(",");
        }
        String storageOrgUnitIDs = stringBuffer.toString();
        if (storageOrgUnitIDs.length() > 0) {
            storageOrgUnitIDs = storageOrgUnitIDs.substring(0, storageOrgUnitIDs.length() - 1);
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)storageOrgUnitIDs, CompareType.INCLUDE));
        } else {
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)"NOTEXISTID", CompareType.INCLUDE));
        }
        evi.setFilter(fi);
        return evi;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = new RequestContext();
            this.prepareHandlerParam(request);
            request.setClassName(this.getUIHandlerClassName());
            handler.setRequestContext((Serializable)request);
        }
        return handler;
    }

    private void prepareHandlerParam(RequestContext request) {
        request.put("_COMPANYID", this.prmtFinanceOrgUnit.getValue() == null ? null : ((CompanyOrgUnitInfo)this.prmtFinanceOrgUnit.getValue()).getId().toString());
    }
}

